/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.bootstrap.servlet;

import io.opentelemetry.javaagent.bootstrap.servlet.SnippetInjectingResponseWrapper;

public class InjectionState {
    private static final int HEAD_TAG_WRITTEN_FAKE_VALUE = -1;
    private static final int HEAD_TAG_PREFIX_LENGTH = "<head".length();
    private final SnippetInjectingResponseWrapper wrapper;
    private int headTagBytesSeen = 0;

    public InjectionState(SnippetInjectingResponseWrapper wrapper) {
        this.wrapper = wrapper;
    }

    public int getHeadTagBytesSeen() {
        return this.headTagBytesSeen;
    }

    public String getCharacterEncoding() {
        return this.wrapper.getCharacterEncoding();
    }

    private void setHeadTagWritten() {
        this.headTagBytesSeen = -1;
    }

    public boolean isHeadTagWritten() {
        return this.headTagBytesSeen == -1;
    }

    public boolean processByte(int b) {
        if (this.isHeadTagWritten()) {
            return false;
        }
        this.headTagBytesSeen = this.inHeadTag(b) ? ++this.headTagBytesSeen : 0;
        if (this.headTagBytesSeen > HEAD_TAG_PREFIX_LENGTH && b == 62) {
            this.setHeadTagWritten();
            return true;
        }
        return false;
    }

    private boolean inHeadTag(int b) {
        if (this.headTagBytesSeen == 0 && b == 60) {
            return true;
        }
        if (this.headTagBytesSeen == 1 && b == 104) {
            return true;
        }
        if (this.headTagBytesSeen == 2 && b == 101) {
            return true;
        }
        if (this.headTagBytesSeen == 3 && b == 97) {
            return true;
        }
        if (this.headTagBytesSeen == 4 && b == 100) {
            return true;
        }
        if (this.headTagBytesSeen == 5 && (b == 62 || Character.isWhitespace(b))) {
            return true;
        }
        return this.headTagBytesSeen > 5;
    }

    public SnippetInjectingResponseWrapper getWrapper() {
        return this.wrapper;
    }
}

