import { jsxs, jsx } from 'react/jsx-runtime';
import { cx, css } from '@emotion/css';
import { useRef, useState, useMemo, useCallback } from 'react';
import '../FormField/FormField.mjs';
import '../Forms/Legacy/Input/Input.mjs';
import 'react-select';
import { Icon } from '../Icon/Icon.mjs';
import '../Forms/Legacy/Select/Select.mjs';
import '../Forms/Legacy/Switch/Switch.mjs';
import '../SecretFormField/SecretFormField.mjs';
import '../IconButton/IconButton.mjs';
import '../ConfirmButton/ConfirmButton.mjs';
import '../Button/Button.mjs';
import '../Button/ButtonGroup.mjs';
import '../Tooltip/Tooltip.mjs';
import { Popover } from '../Tooltip/Popover.mjs';
import '../Toggletip/Toggletip.mjs';
import '../Portal/Portal.mjs';
import 'react-custom-scrollbars-2';
import '@grafana/data';
import { useStyles2 } from '../../themes/ThemeContext.mjs';
import 'micro-memoize';
import '@emotion/react';
import 'tinycolor2';
import '../../utils/skeleton.mjs';
import '../Tabs/Tab.mjs';
import '../Tabs/TabsBar.mjs';
import '../ScrollContainer/ScrollContainer.mjs';
import '../../utils/i18n.mjs';
import '@floating-ui/react';
import '../Cascader/Cascader.mjs';
import '../ButtonCascader/ButtonCascader.mjs';
import 'react-inlinesvg';
import '../../utils/keyframes.mjs';
import '../ColorPicker/ColorPicker.mjs';
import '../ColorPicker/ColorPickerInput.mjs';
import '../ColorPicker/SeriesColorPickerPopover.mjs';
import '../Layout/Box/Box.mjs';
import '../Layout/Stack/Stack.mjs';
import '../Text/Text.mjs';
import '../EmptyState/GrotCTA/GrotCTA.mjs';
import '../EmptyState/GrotNotFound/GrotNotFound.mjs';
import '../StatsPicker/StatsPicker.mjs';
import '../RefreshPicker/RefreshPicker.mjs';
import '../DateTimePickers/TimeRangePicker.mjs';
import '../DateTimePickers/TimeRangeContext.mjs';
import '../DateTimePickers/TimeRangePicker/TimeRangeLabel.mjs';
import 'rc-picker';
import 'rc-picker/lib/generate/moment';
import 'rc-picker/lib/locale/en_US';
import 'rc-picker/assets/index.css';
import 'lodash';
import 'i18next';
import 'react-select/async';
import 'react-select/async-creatable';
import 'react-select/creatable';
import '../Select/IndicatorsContainer.mjs';
import '../Select/InputControl.mjs';
import '../Select/getSelectStyles.mjs';
import '../Input/Input.mjs';
import '../Select/SelectMenu.mjs';
import 'react-transition-group';
import '../Select/ValueContainer.mjs';
import '@grafana/e2e-selectors';
import '@tanstack/react-virtual';
import 'downshift';
import '../Input/AutoSizeInput.mjs';
import '../Combobox/filter.mjs';
import '../../utils/dom.mjs';
import '../../utils/colors.mjs';
import 'slate';
import '../../utils/logger.mjs';
import '../DateTimePickers/DatePicker/DatePicker.mjs';
import '../DateTimePickers/DateTimePicker/DateTimePicker.mjs';
import '../List/AbstractList.mjs';
import 'react-table';
import '../InteractiveTable/Expander/index.mjs';
import '../AutoSaveField/AutoSaveField.mjs';
import '../Tags/Tag.mjs';
import '../Tags/TagList.mjs';
import '../Modal/Modal.mjs';
import 'react-hook-form';
import '../Forms/Field.mjs';
import '../QueryField/QueryField.mjs';
import '../Monaco/CodeEditor.mjs';
import 'react-use';
import '../ErrorBoundary/ErrorWithStack.mjs';
import '../Modal/ModalsContext.mjs';
import '../PageLayout/PageToolbar.mjs';
import 'rxjs';
import 'rxjs/operators';
import './Table.mjs';
import '@react-aria/dialog';
import '@react-aria/focus';
import '@react-aria/overlays';
import 'rc-drawer';
import 'rc-drawer/assets/index.css';
import '../TableInputCSV/TableInputCSV.mjs';
import '../Tabs/VerticalTab.mjs';
import '../BigValue/BigValue.mjs';
import '../Sparkline/Sparkline.mjs';
import '../Gauge/Gauge.mjs';
import '../BarGauge/BarGauge.mjs';
import '../VizTooltip/VizTooltip.mjs';
import '../VizTooltip/VizTooltipContainer.mjs';
import '../VizLegend/SeriesIcon.mjs';
import '../VizRepeater/VizRepeater.mjs';
import '../PanelChrome/index.mjs';
import '../VizLayout/VizLayout.mjs';
import '../VizLegend/VizLegend.mjs';
import '../VizLegend/VizLegendListItem.mjs';
import '../Alert/Alert.mjs';
import '../Collapse/Collapse.mjs';
import '../ClickOutsideWrapper/ClickOutsideWrapper.mjs';
import '@grafana/schema';
import '../ContextMenu/ContextMenu.mjs';
import '../Menu/Menu.mjs';
import '../Menu/MenuGroup.mjs';
import '../Menu/MenuItem.mjs';
import '../DataLinks/DataLinkEditor.mjs';
import '@hello-pangea/dnd';
import '../Badge/Badge.mjs';
import '../DataLinks/DataLinkInput.mjs';
import '../InfoBox/InfoBox.mjs';
import '../InfoBox/FeatureInfoBox.mjs';
import '../JSONFormatter/JSONFormatter.mjs';
import '../ErrorBoundary/ErrorBoundary.mjs';
import '../DataSourceSettings/DataSourceHttpSettings.mjs';
import '../DataSourceSettings/CustomHeadersSettings.mjs';
import '../Switch/Switch.mjs';
import '../Forms/InlineField.mjs';
import '../TextArea/TextArea.mjs';
import 'react-use/lib/useClickAway';
import '../Slider/Slider.mjs';
import '../Slider/RangeSlider.mjs';
import '../ToolbarButton/ToolbarButton.mjs';
import '../ToolbarButton/ToolbarButtonRow.mjs';
import '../MatchersUI/fieldMatchersUI.mjs';
import '../Link/Link.mjs';
import '../Link/TextLink.mjs';
import '../Layout/Grid/Grid.mjs';
import '../Forms/InlineSegmentGroup.mjs';
import '../Forms/Checkbox.mjs';
import '../Combobox/ValuePill.mjs';
import '../Forms/RadioButtonGroup/RadioButtonGroup.mjs';
import '../FilterInput/FilterInput.mjs';
import 'uuid';
import 'react-dropzone';
import '../DateTimePickers/TimeRangePicker/TimePickerContent.mjs';
import '../DateTimePickers/RelativeTimeRangePicker/RelativeTimeRangePicker.mjs';
import '../Card/Card.mjs';
import '../FormattedValueDisplay/FormattedValueDisplay.mjs';
import '../Dropdown/ButtonSelect.mjs';
import '../Dropdown/Dropdown.mjs';
import '../PluginSignatureBadge/PluginSignatureBadge.mjs';
import 'classnames';
import '../Divider/Divider.mjs';
import '../uPlot/config.mjs';
import 'uplot';
import '../uPlot/utils.mjs';
import 'uplot/dist/uPlot.min.css';
import '../uPlot/PlotLegend.mjs';
import 'react-dom';
import '../BrowserLabel/Label.mjs';
import '../../graveyard/Graph/Graph.mjs';
import '../../graveyard/GraphNG/GraphNG.mjs';
import '../../graveyard/TimeSeries/TimeSeries.mjs';
import '../../graveyard/GraphNG/hooks.mjs';
import '../ElementSelectionContext/ElementSelectionContext.mjs';
import { REGEX_OPERATOR } from './FilterList.mjs';
import { FilterPopup } from './FilterPopup.mjs';

const Filter = ({ column, field, tableStyles }) => {
  var _a;
  const ref = useRef(null);
  const [isPopoverVisible, setPopoverVisible] = useState(false);
  const styles = useStyles2(getStyles);
  const filterEnabled = useMemo(() => Boolean(column.filterValue), [column.filterValue]);
  const onShowPopover = useCallback(() => setPopoverVisible(true), [setPopoverVisible]);
  const onClosePopover = useCallback(() => setPopoverVisible(false), [setPopoverVisible]);
  const [searchFilter, setSearchFilter] = useState("");
  const [operator, setOperator] = useState(REGEX_OPERATOR);
  if (!field || !((_a = field.config.custom) == null ? undefined : _a.filterable)) {
    return null;
  }
  return /* @__PURE__ */ jsxs(
    "button",
    {
      className: cx(tableStyles.headerFilter, filterEnabled ? styles.filterIconEnabled : styles.filterIconDisabled),
      ref,
      type: "button",
      onClick: onShowPopover,
      children: [
        /* @__PURE__ */ jsx(Icon, { name: "filter" }),
        isPopoverVisible && ref.current && /* @__PURE__ */ jsx(
          Popover,
          {
            content: /* @__PURE__ */ jsx(
              FilterPopup,
              {
                column,
                tableStyles,
                field,
                onClose: onClosePopover,
                searchFilter,
                setSearchFilter,
                operator,
                setOperator
              }
            ),
            placement: "bottom-start",
            referenceElement: ref.current,
            show: true
          }
        )
      ]
    }
  );
};
const getStyles = (theme) => ({
  filterIconEnabled: css({
    label: "filterIconEnabled",
    color: theme.colors.primary.text
  }),
  filterIconDisabled: css({
    label: "filterIconDisabled",
    color: theme.colors.text.disabled
  })
});

export { Filter };
//# sourceMappingURL=Filter.mjs.map
