import { jsxs, jsx } from 'react/jsx-runtime';
import { cx, css } from '@emotion/css';
import '@grafana/data';
import { useStyles2 } from '../../themes/ThemeContext.mjs';
import 'micro-memoize';
import '@emotion/react';
import 'tinycolor2';
import '../../utils/skeleton.mjs';
import { Icon } from '../Icon/Icon.mjs';
import { Tooltip } from '../Tooltip/Tooltip.mjs';
import 'react';

const InlineLabel = ({
  children,
  className,
  tooltip,
  width,
  transparent,
  interactive,
  as: Component = "label",
  ...rest
}) => {
  const styles = useStyles2(getInlineLabelStyles, transparent, width);
  return /* @__PURE__ */ jsxs(Component, { className: cx(styles.label, className), ...rest, children: [
    children,
    tooltip && /* @__PURE__ */ jsx(Tooltip, { interactive, placement: "top", content: tooltip, theme: "info", children: /* @__PURE__ */ jsx(Icon, { tabIndex: 0, name: "info-circle", size: "sm", className: styles.icon }) })
  ] });
};
const getInlineLabelStyles = (theme, transparent = false, width) => {
  return {
    label: css({
      display: "flex",
      alignItems: "center",
      justifyContent: "space-between",
      flexShrink: 0,
      padding: theme.spacing(0, 1),
      fontWeight: theme.typography.fontWeightMedium,
      fontSize: theme.typography.size.sm,
      backgroundColor: transparent ? "transparent" : theme.colors.background.secondary,
      height: theme.spacing(theme.components.height.md),
      lineHeight: theme.spacing(theme.components.height.md),
      marginRight: theme.spacing(0.5),
      borderRadius: theme.shape.radius.default,
      border: "none",
      width: width ? width !== "auto" ? `${8 * width}px` : width : "100%",
      color: theme.colors.text.primary
    }),
    icon: css({
      color: theme.colors.text.secondary,
      marginLeft: "10px",
      ":hover": {
        color: theme.colors.text.primary
      }
    })
  };
};

export { InlineLabel, getInlineLabelStyles };
//# sourceMappingURL=InlineLabel.mjs.map
