import * as ui from '@grafana/schema';
export declare const pluginVersion = "11.6.9";
export interface Options extends ui.OptionsWithLegend, ui.OptionsWithTooltip, ui.OptionsWithTimezones {
    /**
     * Controls value alignment on the timelines
     */
    alignValue?: ui.TimelineValueAlignment;
    /**
     * Merge equal consecutive values
     */
    mergeValues?: boolean;
    /**
     * Enables pagination when > 0
     */
    perPage?: number;
    /**
     * Controls the row height
     */
    rowHeight: number;
    /**
     * Show timeline values on chart
     */
    showValue: ui.VisibilityMode;
}
export declare const defaultOptions: Partial<Options>;
export interface FieldConfig extends ui.AxisConfig, ui.HideableFieldConfig {
    fillOpacity?: number;
    lineWidth?: number;
}
export declare const defaultFieldConfig: Partial<FieldConfig>;
