/**
 * Parses the action attribute name by removing the 'data-' prefix and converting
 * the remaining string to camelCase.
 *
 * This is needed because the browser will remove the 'data-' prefix and the dashes from
 * data attributes and make then camelCase.
 */
export function convertDataAttributeName(userActionDataAttribute) {
    const withoutData = userActionDataAttribute.split('data-')[1];
    const withUpperCase = withoutData === null || withoutData === void 0 ? void 0 : withoutData.replace(/-(.)/g, (_, char) => char.toUpperCase());
    return withUpperCase === null || withUpperCase === void 0 ? void 0 : withUpperCase.replace(/-/g, '');
}
//# sourceMappingURL=util.js.map