import { BaseInstrumentation, faro, VERSION } from '@grafana/faro-core';
import { userActionStartByApiCallEventName } from './const';
import { getUserEventHandler } from './processUserActionEventHandler';
let processUserEventHandler;
export class UserActionInstrumentation extends BaseInstrumentation {
    constructor() {
        super(...arguments);
        this.name = '@grafana/faro-web-sdk:instrumentation-user-action';
        this.version = VERSION;
    }
    initialize() {
        processUserEventHandler = getUserEventHandler(faro);
        window.addEventListener('pointerdown', processUserEventHandler);
        window.addEventListener('keydown', processUserEventHandler);
    }
}
export function startUserAction(name, attributes) {
    processUserEventHandler === null || processUserEventHandler === void 0 ? void 0 : processUserEventHandler(createUserActionApiEvent(name, attributes));
}
function createUserActionApiEvent(name, attributes) {
    return {
        name,
        attributes,
        type: userActionStartByApiCallEventName,
    };
}
//# sourceMappingURL=instrumentation.js.map