import { atString, safariExtensionString, safariWebExtensionString } from './const';
export function getDataFromSafariExtensions(func, filename) {
    const isSafariExtension = func === null || func === void 0 ? void 0 : func.includes(safariExtensionString);
    const isSafariWebExtension = !isSafariExtension && (func === null || func === void 0 ? void 0 : func.includes(safariWebExtensionString));
    if (!isSafariExtension && !isSafariWebExtension) {
        return [func, filename];
    }
    return [
        (func === null || func === void 0 ? void 0 : func.includes(atString)) ? func.split(atString)[0] : func,
        isSafariExtension ? `${safariExtensionString}:${filename}` : `${safariWebExtensionString}:${filename}`,
    ];
}
//# sourceMappingURL=getDataFromSafariExtensions.js.map