"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getIgnoreUrls = getIgnoreUrls;
exports.isUrlIgnored = isUrlIgnored;
exports.getUrlFromResource = getUrlFromResource;
var faro_core_1 = require("@grafana/faro-core");
/**
 * Retrieves a list of URLs to be ignored by aggregating the ignore URLs from all transports.
 *
 * @returns {string[]} An array of URLs to be ignored.
 */
function getIgnoreUrls() {
    return faro_core_1.faro.transports.transports.flatMap(function (transport) { return transport.getIgnoreUrls(); });
}
/**
 * Checks if the given URL should be ignored based on a list of ignored URLs.
 *
 * @param url - The URL to check.
 * @returns `true` if the URL is in the list of ignored URLs, `false` otherwise.
 */
function isUrlIgnored(url) {
    if (url === void 0) { url = ''; }
    return getIgnoreUrls().some(function (ignoredUrl) { return url && url.match(ignoredUrl) != null; });
}
/**
 * Extracts a URL string from the given resource.
 *
 * @param resource - The input resource which can be a string, a URL object, or an object with a `toString` method.
 * @returns The URL as a string if the resource is a valid URL-like object, or `undefined` if the resource is not valid.
 *
 */
function getUrlFromResource(resource) {
    if ((0, faro_core_1.isString)(resource)) {
        return resource;
    }
    if (resource instanceof URL) {
        return resource.href;
    }
    if (!(0, faro_core_1.isEmpty)(resource) && (0, faro_core_1.isFunction)(resource === null || resource === void 0 ? void 0 : resource.toString)) {
        return resource.toString();
    }
    return undefined;
}
//# sourceMappingURL=url.js.map