"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.browserMeta = void 0;
var ua_parser_js_1 = require("ua-parser-js");
var faro_core_1 = require("@grafana/faro-core");
var browserMeta = function () {
    var parser = new ua_parser_js_1.UAParser();
    var _a = parser.getBrowser(), name = _a.name, version = _a.version;
    var _b = parser.getOS(), osName = _b.name, osVersion = _b.version;
    var userAgent = parser.getUA();
    var language = navigator.language;
    var mobile = navigator.userAgent.includes('Mobi');
    var brands = getBrands();
    return {
        browser: {
            name: name !== null && name !== void 0 ? name : faro_core_1.unknownString,
            version: version !== null && version !== void 0 ? version : faro_core_1.unknownString,
            os: "".concat(osName !== null && osName !== void 0 ? osName : faro_core_1.unknownString, " ").concat(osVersion !== null && osVersion !== void 0 ? osVersion : faro_core_1.unknownString),
            userAgent: userAgent !== null && userAgent !== void 0 ? userAgent : faro_core_1.unknownString,
            language: language !== null && language !== void 0 ? language : faro_core_1.unknownString,
            mobile: mobile,
            brands: brands !== null && brands !== void 0 ? brands : faro_core_1.unknownString,
            viewportWidth: "".concat(window.innerWidth),
            viewportHeight: "".concat(window.innerHeight),
        },
    };
    function getBrands() {
        if (!name || !version) {
            return undefined;
        }
        if ('userAgentData' in navigator && navigator.userAgentData) {
            // userAgentData in experimental (only Chrome supports it) thus TS does not ship the respective type declarations
            return navigator.userAgentData.brands;
        }
        return undefined;
    }
};
exports.browserMeta = browserMeta;
//# sourceMappingURL=meta.js.map