"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.monitorPerformanceEntries = monitorPerformanceEntries;
var faro_core_1 = require("@grafana/faro-core");
var instrumentation_1 = require("../performance/instrumentation");
var performanceConstants_1 = require("../performance/performanceConstants");
var const_1 = require("./const");
function monitorPerformanceEntries() {
    var observable = new faro_core_1.Observable();
    instrumentation_1.performanceEntriesSubscription.subscribe(function (data) {
        if (data.type === performanceConstants_1.RESOURCE_ENTRY) {
            observable.notify({ type: const_1.MESSAGE_TYPE_RESOURCE_ENTRY });
        }
    });
    return observable;
}
//# sourceMappingURL=performanceEntriesMonitor.js.map