"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
exports.UserActionInstrumentation = void 0;
exports.startUserAction = startUserAction;
var faro_core_1 = require("@grafana/faro-core");
var const_1 = require("./const");
var processUserActionEventHandler_1 = require("./processUserActionEventHandler");
var processUserEventHandler;
var UserActionInstrumentation = /** @class */ (function (_super) {
    __extends(UserActionInstrumentation, _super);
    function UserActionInstrumentation() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.name = '@grafana/faro-web-sdk:instrumentation-user-action';
        _this.version = faro_core_1.VERSION;
        return _this;
    }
    UserActionInstrumentation.prototype.initialize = function () {
        processUserEventHandler = (0, processUserActionEventHandler_1.getUserEventHandler)(faro_core_1.faro);
        window.addEventListener('pointerdown', processUserEventHandler);
        window.addEventListener('keydown', processUserEventHandler);
    };
    return UserActionInstrumentation;
}(faro_core_1.BaseInstrumentation));
exports.UserActionInstrumentation = UserActionInstrumentation;
function startUserAction(name, attributes) {
    processUserEventHandler === null || processUserEventHandler === void 0 ? void 0 : processUserEventHandler(createUserActionApiEvent(name, attributes));
}
function createUserActionApiEvent(name, attributes) {
    return {
        name: name,
        attributes: attributes,
        type: const_1.userActionStartByApiCallEventName,
    };
}
//# sourceMappingURL=instrumentation.js.map