"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.monitorDomMutations = monitorDomMutations;
var faro_core_1 = require("@grafana/faro-core");
var const_1 = require("./const");
function monitorDomMutations() {
    var observable = new faro_core_1.Observable();
    var observer = new MutationObserver(function (_mutationsList, _observer) {
        observable.notify({ type: const_1.MESSAGE_TYPE_DOM_MUTATION });
    });
    observer.observe(document, {
        attributes: true,
        childList: true,
        subtree: true,
        characterData: true,
    });
    return observable;
}
//# sourceMappingURL=domMutationMonitor.js.map