"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.createUserSessionObject = createUserSessionObject;
exports.isUserSessionValid = isUserSessionValid;
exports.getUserSessionUpdater = getUserSessionUpdater;
exports.addSessionMetadataToNextSession = addSessionMetadataToNextSession;
exports.getSessionMetaUpdateHandler = getSessionMetaUpdateHandler;
var faro_core_1 = require("@grafana/faro-core");
var utils_1 = require("../../../utils");
var sampling_1 = require("./sampling");
var sessionConstants_1 = require("./sessionConstants");
function createUserSessionObject(_a) {
    var _b, _c;
    var _d = _a === void 0 ? {} : _a, sessionId = _d.sessionId, started = _d.started, lastActivity = _d.lastActivity, _e = _d.isSampled, isSampled = _e === void 0 ? true : _e;
    var now = (0, faro_core_1.dateNow)();
    var generateSessionId = (_c = (_b = faro_core_1.faro.config) === null || _b === void 0 ? void 0 : _b.sessionTracking) === null || _c === void 0 ? void 0 : _c.generateSessionId;
    if (sessionId == null) {
        sessionId = typeof generateSessionId === 'function' ? generateSessionId() : (0, faro_core_1.genShortID)();
    }
    return {
        sessionId: sessionId,
        lastActivity: lastActivity !== null && lastActivity !== void 0 ? lastActivity : now,
        started: started !== null && started !== void 0 ? started : now,
        isSampled: isSampled,
    };
}
function isUserSessionValid(session) {
    if (session == null) {
        return false;
    }
    var now = (0, faro_core_1.dateNow)();
    var lifetimeValid = now - session.started < sessionConstants_1.SESSION_EXPIRATION_TIME;
    if (!lifetimeValid) {
        return false;
    }
    var inactivityPeriodValid = now - session.lastActivity < sessionConstants_1.SESSION_INACTIVITY_TIME;
    return inactivityPeriodValid;
}
function getUserSessionUpdater(_a) {
    var fetchUserSession = _a.fetchUserSession, storeUserSession = _a.storeUserSession;
    return function updateSession(_a) {
        var _b, _c, _d;
        var _e = _a === void 0 ? { forceSessionExtend: false } : _a, forceSessionExtend = _e.forceSessionExtend;
        if (!fetchUserSession || !storeUserSession) {
            return;
        }
        var sessionTrackingConfig = faro_core_1.faro.config.sessionTracking;
        var isPersistentSessions = sessionTrackingConfig === null || sessionTrackingConfig === void 0 ? void 0 : sessionTrackingConfig.persistent;
        if ((isPersistentSessions && !utils_1.isLocalStorageAvailable) || (!isPersistentSessions && !utils_1.isSessionStorageAvailable)) {
            return;
        }
        var sessionFromStorage = fetchUserSession();
        if (forceSessionExtend === false && isUserSessionValid(sessionFromStorage)) {
            storeUserSession(__assign(__assign({}, sessionFromStorage), { lastActivity: (0, faro_core_1.dateNow)() }));
        }
        else {
            var newSession = addSessionMetadataToNextSession(createUserSessionObject({ isSampled: (0, sampling_1.isSampled)() }), sessionFromStorage);
            storeUserSession(newSession);
            (_b = faro_core_1.faro.api) === null || _b === void 0 ? void 0 : _b.setSession(newSession.sessionMeta);
            (_c = sessionTrackingConfig === null || sessionTrackingConfig === void 0 ? void 0 : sessionTrackingConfig.onSessionChange) === null || _c === void 0 ? void 0 : _c.call(sessionTrackingConfig, (_d = sessionFromStorage === null || sessionFromStorage === void 0 ? void 0 : sessionFromStorage.sessionMeta) !== null && _d !== void 0 ? _d : null, newSession.sessionMeta);
        }
    };
}
function addSessionMetadataToNextSession(newSession, previousSession) {
    var _a, _b, _c, _d, _e, _f, _g;
    var sessionWithMeta = __assign(__assign({}, newSession), { sessionMeta: {
            id: newSession.sessionId,
            attributes: __assign(__assign(__assign({}, (_b = (_a = faro_core_1.faro.config.sessionTracking) === null || _a === void 0 ? void 0 : _a.session) === null || _b === void 0 ? void 0 : _b.attributes), ((_d = (_c = faro_core_1.faro.metas.value.session) === null || _c === void 0 ? void 0 : _c.attributes) !== null && _d !== void 0 ? _d : {})), { isSampled: newSession.isSampled.toString() }),
        } });
    var overrides = (_f = (_e = faro_core_1.faro.metas.value.session) === null || _e === void 0 ? void 0 : _e.overrides) !== null && _f !== void 0 ? _f : (_g = previousSession === null || previousSession === void 0 ? void 0 : previousSession.sessionMeta) === null || _g === void 0 ? void 0 : _g.overrides;
    if (!(0, faro_core_1.isEmpty)(overrides)) {
        sessionWithMeta.sessionMeta.overrides = overrides;
    }
    var previousSessionId = previousSession === null || previousSession === void 0 ? void 0 : previousSession.sessionId;
    if (previousSessionId != null) {
        sessionWithMeta.sessionMeta.attributes['previousSession'] = previousSessionId;
    }
    return sessionWithMeta;
}
function getSessionMetaUpdateHandler(_a) {
    var fetchUserSession = _a.fetchUserSession, storeUserSession = _a.storeUserSession;
    return function syncSessionIfChangedExternally(meta) {
        var session = meta.session;
        var sessionFromSessionStorage = fetchUserSession();
        var sessionId = session === null || session === void 0 ? void 0 : session.id;
        var sessionAttributes = session === null || session === void 0 ? void 0 : session.attributes;
        var sessionOverrides = session === null || session === void 0 ? void 0 : session.overrides;
        var storedSessionMeta = sessionFromSessionStorage === null || sessionFromSessionStorage === void 0 ? void 0 : sessionFromSessionStorage.sessionMeta;
        var storedSessionMetaOverrides = storedSessionMeta === null || storedSessionMeta === void 0 ? void 0 : storedSessionMeta.overrides;
        var hasSessionOverridesChanged = !!sessionOverrides && !(0, faro_core_1.deepEqual)(sessionOverrides, storedSessionMetaOverrides);
        var hasAttributesChanged = !!sessionAttributes && !(0, faro_core_1.deepEqual)(sessionAttributes, storedSessionMeta === null || storedSessionMeta === void 0 ? void 0 : storedSessionMeta.attributes);
        var hasSessionIdChanged = !!session && sessionId !== (sessionFromSessionStorage === null || sessionFromSessionStorage === void 0 ? void 0 : sessionFromSessionStorage.sessionId);
        if (hasSessionIdChanged || hasAttributesChanged || hasSessionOverridesChanged) {
            var userSession = addSessionMetadataToNextSession(createUserSessionObject({ sessionId: sessionId, isSampled: (0, sampling_1.isSampled)() }), sessionFromSessionStorage);
            storeUserSession(userSession);
            sendOverrideEvent(hasSessionOverridesChanged, sessionOverrides, storedSessionMetaOverrides);
            faro_core_1.faro.api.setSession(userSession.sessionMeta);
        }
    };
}
function sendOverrideEvent(hasSessionOverridesChanged, sessionOverrides, storedSessionOverrides) {
    var _a, _b, _c;
    if (sessionOverrides === void 0) { sessionOverrides = {}; }
    if (storedSessionOverrides === void 0) { storedSessionOverrides = {}; }
    if (!hasSessionOverridesChanged) {
        return;
    }
    var serviceName = sessionOverrides.serviceName;
    var previousServiceName = (_c = (_a = storedSessionOverrides.serviceName) !== null && _a !== void 0 ? _a : (_b = faro_core_1.faro.metas.value.app) === null || _b === void 0 ? void 0 : _b.name) !== null && _c !== void 0 ? _c : '';
    if (serviceName && serviceName !== previousServiceName) {
        faro_core_1.faro.api.pushEvent(faro_core_1.EVENT_OVERRIDES_SERVICE_NAME, {
            serviceName: serviceName,
            previousServiceName: previousServiceName,
        });
    }
}
//# sourceMappingURL=sessionManagerUtils.js.map