"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.registerOnunhandledrejection = registerOnunhandledrejection;
var faro_core_1 = require("@grafana/faro-core");
var const_1 = require("./const");
var getErrorDetails_1 = require("./getErrorDetails");
function registerOnunhandledrejection(api) {
    window.addEventListener('unhandledrejection', function (evt) {
        var _a;
        var _b, _c;
        var error = evt;
        if (error.reason) {
            error = evt.reason;
        }
        else if ((_b = evt.detail) === null || _b === void 0 ? void 0 : _b.reason) {
            error = (_c = evt.detail) === null || _c === void 0 ? void 0 : _c.reason;
        }
        var value;
        var type;
        var stackFrames = [];
        if ((0, faro_core_1.isPrimitive)(error)) {
            value = "".concat(const_1.primitiveUnhandledValue, " ").concat(String(error));
            type = const_1.primitiveUnhandledType;
        }
        else {
            _a = (0, getErrorDetails_1.getErrorDetails)(error), value = _a[0], type = _a[1], stackFrames = _a[2];
        }
        if (value) {
            api.pushError(new Error(value), { type: type, stackFrames: stackFrames });
        }
    });
}
//# sourceMappingURL=registerOnunhandledrejection.js.map