import { type PushEventOptions } from '@grafana/faro-core';
import type { FaroNavigationTiming, FaroResourceTiming } from './types';
type SpanContext = PushEventOptions['spanContext'];
export declare function getSpanContextFromServerTiming(serverTimings?: PerformanceServerTiming[]): SpanContext | undefined;
export declare function performanceObserverSupported(): boolean;
export declare function onDocumentReady(handleReady: () => void): void;
type PerformanceEntryAllowProperties = Record<string, Array<string | number> | string | number>;
export declare function includePerformanceEntry(performanceEntryJSON: Record<string, any>, allowProps?: PerformanceEntryAllowProperties): boolean;
export declare function createFaroResourceTiming(resourceEntryRaw: PerformanceResourceTiming): FaroResourceTiming;
export declare function createFaroNavigationTiming(navigationEntryRaw: PerformanceNavigationTiming): FaroNavigationTiming;
export {};
