export type Subscription = {
    unsubscribe: () => void;
};
type Subscriber<T> = (value: T) => void;
export declare class Observable<T = any> {
    private subscribers;
    subscribe(subscriber: Subscriber<T>): Subscription;
    unsubscribe(subscriber: Subscriber<T>): void;
    notify(value: T): void;
    first(): Observable<T>;
    takeWhile(predicate: (value: T) => boolean): Observable<T>;
    filter(predicate: (value: T) => boolean): Observable<T>;
    merge(...observables: Array<Observable<T>>): Observable<T>;
    private withUnsubscribeOverride;
    private unsubscribeAll;
}
export {};
