"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var utils_1 = require("./utils");
describe('api/utils', function () {
    it('should ignore event', function () {
        var patterns = ['pattern1', 'pattern2'];
        var msg = 'message pattern1';
        var result = (0, utils_1.shouldIgnoreEvent)(patterns, msg);
        expect(result).toBe(true);
        patterns = ['pattern1', /foo/];
        msg = 'This is a foo example';
        result = (0, utils_1.shouldIgnoreEvent)(patterns, msg);
        expect(result).toBe(true);
        patterns = ['pattern1', /foo/];
        msg = "This example doesn't match";
        result = (0, utils_1.shouldIgnoreEvent)(patterns, msg);
        expect(result).toBe(false);
    });
});
//# sourceMappingURL=utils.test.js.map