"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
Object.defineProperty(exports, "__esModule", { value: true });
var __1 = require("..");
var reactive_1 = require("../utils/reactive");
var apiTestHelpers_1 = require("./apiTestHelpers");
var const_1 = require("./const");
var userActionLifecycleHandler_1 = require("./userActionLifecycleHandler");
describe('userActionLifecycleHandler', function () {
    it('assigns the user-action-start message to the message variable when it receives it', function () {
        var apiMessageBus = new reactive_1.Observable();
        var getMessage = (0, userActionLifecycleHandler_1.createUserActionLifecycleHandler)({
            apiMessageBus: apiMessageBus,
            transports: apiTestHelpers_1.mockTransports,
            config: {},
        }).getMessage;
        var message = {
            type: const_1.USER_ACTION_START,
            name: 'start-test',
            startTime: 0,
            parentId: '123',
        };
        apiMessageBus.notify(message);
        expect(getMessage()).toEqual(message);
    });
    it('assigns the user-action-halt message to the message variable when it receives it', function () {
        var apiMessageBus = new reactive_1.Observable();
        var getMessage = (0, userActionLifecycleHandler_1.createUserActionLifecycleHandler)({
            apiMessageBus: apiMessageBus,
            transports: apiTestHelpers_1.mockTransports,
            config: {},
        }).getMessage;
        var message = {
            type: __1.USER_ACTION_HALT,
            name: 'halt-test',
            haltTime: 0,
            reason: 'pending-requests',
            parentId: '123',
        };
        apiMessageBus.notify(message);
        expect(getMessage()).toEqual(message);
    });
    it('When it receives a user-action-cancel message, it resets the cached message flushes the buffer and sends the items to the transports', function () {
        var apiMessageBus = new reactive_1.Observable();
        var mockExecute = jest.fn();
        var _a = (0, userActionLifecycleHandler_1.createUserActionLifecycleHandler)({
            apiMessageBus: apiMessageBus,
            transports: __assign(__assign({}, apiTestHelpers_1.mockTransports), { execute: mockExecute }),
            config: {},
        }), actionBuffer = _a.actionBuffer, getMessage = _a.getMessage;
        var message = {
            type: const_1.USER_ACTION_START,
            name: '',
            startTime: 0,
            parentId: '',
        };
        apiMessageBus.notify(message);
        var item = { type: __1.TransportItemType.EVENT, payload: {}, meta: {} };
        actionBuffer.addItem(item);
        var cancelMessage = {
            type: const_1.USER_ACTION_CANCEL,
            name: 'pointerdown',
        };
        apiMessageBus.notify(cancelMessage);
        expect(getMessage()).toBeUndefined();
        expect(mockExecute).toHaveBeenCalledTimes(1);
        expect(mockExecute).toHaveBeenCalledWith(item);
        expect(actionBuffer.size()).toEqual(0);
    });
    it('When it receives a user-action-end message, it sends the items to the transports with the action parentId and name', function () {
        var apiMessageBus = new reactive_1.Observable();
        var mockExecute = jest.fn();
        var actionBuffer = (0, userActionLifecycleHandler_1.createUserActionLifecycleHandler)({
            apiMessageBus: apiMessageBus,
            transports: __assign(__assign({}, apiTestHelpers_1.mockTransports), { execute: mockExecute }),
            config: {},
        }).actionBuffer;
        var message = {
            type: const_1.USER_ACTION_START,
            name: 'pointerdown',
            startTime: 0,
            parentId: '123',
        };
        apiMessageBus.notify(message);
        var item = { type: __1.TransportItemType.EVENT, payload: {}, meta: {} };
        actionBuffer.addItem(item);
        var endMessage = {
            type: const_1.USER_ACTION_END,
            id: '123',
            name: 'pointerdown',
            startTime: 100,
            endTime: 120,
            duration: 20,
            eventType: 'keydown',
        };
        apiMessageBus.notify(endMessage);
        expect(mockExecute).toHaveBeenCalledTimes(1);
        expect(mockExecute).toHaveBeenCalledWith(__assign(__assign({}, item), { payload: __assign(__assign({}, item.payload), { action: {
                    parentId: '123',
                    name: 'pointerdown',
                } }) }));
    });
    it('excludes items defined by the isExcludeFromUserAction function from the user actions', function () {
        var apiMessageBus = new reactive_1.Observable();
        var mockExecute = jest.fn();
        var _a = (0, userActionLifecycleHandler_1.createUserActionLifecycleHandler)({
            apiMessageBus: apiMessageBus,
            transports: __assign(__assign({}, apiTestHelpers_1.mockTransports), { execute: mockExecute }),
            config: {
                trackUserActionsExcludeItem: function (item) {
                    return item.type === __1.TransportItemType.EVENT && item.payload.name === 'i-am-excluded';
                },
            },
        }), actionBuffer = _a.actionBuffer, getMessage = _a.getMessage;
        var message = {
            type: const_1.USER_ACTION_START,
            name: 'pointerdown',
            startTime: 0,
            parentId: '123',
        };
        apiMessageBus.notify(message);
        var itemEvent = { type: __1.TransportItemType.EVENT, payload: {}, meta: {} };
        actionBuffer.addItem(itemEvent);
        var itemMeasurement = {
            type: __1.TransportItemType.MEASUREMENT,
            payload: { type: 'web-vitals', values: {}, timestamp: (0, __1.dateNow)().toString() },
            meta: {},
        };
        actionBuffer.addItem(itemMeasurement);
        var itemEventExcluded = {
            type: __1.TransportItemType.EVENT,
            payload: {
                timestamp: (0, __1.dateNow)().toString(),
                name: 'i-am-excluded',
            },
            meta: {},
        };
        actionBuffer.addItem(itemEventExcluded);
        var endMessage = {
            type: const_1.USER_ACTION_END,
            id: '123',
            name: 'pointerdown',
            startTime: 100,
            endTime: 120,
            duration: 20,
            eventType: 'keydown',
        };
        apiMessageBus.notify(endMessage);
        expect(mockExecute).toHaveBeenCalledTimes(3);
        expect(mockExecute).toHaveBeenNthCalledWith(1, __assign(__assign({}, itemEvent), { payload: __assign(__assign({}, itemEvent.payload), { action: {
                    parentId: '123',
                    name: 'pointerdown',
                } }) }));
        expect(mockExecute).toHaveBeenNthCalledWith(2, itemMeasurement);
        expect(mockExecute).toHaveBeenNthCalledWith(3, itemEventExcluded);
        expect(getMessage()).toBeUndefined();
    });
});
//# sourceMappingURL=userActionLifecycleHandler.test.js.map