"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var ItemBuffer_1 = require("./ItemBuffer");
describe('ItemBuffer', function () {
    it('Adds items to buffer', function () {
        var buffer = new ItemBuffer_1.ItemBuffer();
        buffer.addItem(1);
        buffer.addItem(2);
        buffer.addItem(3);
        expect(buffer.size()).toBe(3);
    });
    it('Flushes buffer', function () {
        var buffer = new ItemBuffer_1.ItemBuffer();
        buffer.addItem(1);
        buffer.addItem(2);
        buffer.addItem(3);
        expect(buffer.size()).toBe(3);
        buffer.flushBuffer();
        expect(buffer.size()).toBe(0);
    });
    it('Flushes buffer and calls callback', function () {
        var buffer = new ItemBuffer_1.ItemBuffer();
        buffer.addItem(1);
        buffer.addItem(2);
        buffer.addItem(3);
        expect(buffer.size()).toBe(3);
        var mockCallback = jest.fn();
        buffer.flushBuffer(mockCallback);
        expect(buffer.size()).toBe(0);
        expect(mockCallback).toHaveBeenCalledTimes(3);
        expect(mockCallback).toHaveBeenNthCalledWith(1, 1);
        expect(mockCallback).toHaveBeenNthCalledWith(2, 2);
        expect(mockCallback).toHaveBeenNthCalledWith(3, 3);
    });
});
//# sourceMappingURL=itemBuffer.test.js.map