"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || (function () {
    var ownKeys = function(o) {
        ownKeys = Object.getOwnPropertyNames || function (o) {
            var ar = [];
            for (var k in o) if (Object.prototype.hasOwnProperty.call(o, k)) ar[ar.length] = k;
            return ar;
        };
        return ownKeys(o);
    };
    return function (mod) {
        if (mod && mod.__esModule) return mod;
        var result = {};
        if (mod != null) for (var k = ownKeys(mod), i = 0; i < k.length; i++) if (k[i] !== "default") __createBinding(result, mod, k[i]);
        __setModuleDefault(result, mod);
        return result;
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var __1 = require("..");
var testUtils_1 = require("../testUtils");
var initialize_1 = require("../unpatchedConsole/initialize");
var apiTestHelpers_1 = require("./apiTestHelpers");
var initialize_2 = require("./initialize");
var ItemBuffer_1 = require("./ItemBuffer");
var createUserActionLifecycleHandlerModule = __importStar(require("./userActionLifecycleHandler"));
describe('initialize', function () {
    it('should initialize the API', function () {
        var api = (0, initialize_2.initializeAPI)(initialize_1.unpatchedConsole, testUtils_1.mockInternalLogger, (0, testUtils_1.mockConfig)(), apiTestHelpers_1.mockMetas, apiTestHelpers_1.mockTransports);
        expect(api).toBeDefined();
        expect(api).toHaveProperty('pushError');
        expect(api).toHaveProperty('pushLog');
        expect(api).toHaveProperty('pushMeasurement');
        expect(api).toHaveProperty('pushTraces');
        expect(api).toHaveProperty('pushEvent');
        expect(api).toHaveProperty('changeStacktraceParser');
        expect(api).toHaveProperty('getOTEL');
        expect(api).toHaveProperty('getPage');
        expect(api).toHaveProperty('getSession');
        expect(api).toHaveProperty('getStacktraceParser');
        expect(api).toHaveProperty('getTraceContext');
        expect(api).toHaveProperty('getView');
        expect(api).toHaveProperty('initOTEL');
        expect(api).toHaveProperty('isOTELInitialized');
        expect(api).toHaveProperty('resetSession');
        expect(api).toHaveProperty('resetUser');
        expect(api).toHaveProperty('setSession');
        expect(api).toHaveProperty('setUser');
        expect(api).toHaveProperty('setPage');
        expect(api).toHaveProperty('setView');
    });
    it('Exports the apiMessageBus observable', function () {
        expect(initialize_2.apiMessageBus).toBeInstanceOf(__1.Observable);
    });
    it('creates a user action lifecycle handler', function () {
        var mockUserActionLifecycleHandler = jest.fn(function () { return ({
            actionBuffer: new ItemBuffer_1.ItemBuffer(),
            getMessage: jest.fn(),
        }); });
        jest
            .spyOn(createUserActionLifecycleHandlerModule, 'createUserActionLifecycleHandler')
            .mockImplementationOnce(mockUserActionLifecycleHandler);
        (0, initialize_2.initializeAPI)(initialize_1.unpatchedConsole, testUtils_1.mockInternalLogger, (0, testUtils_1.mockConfig)(), apiTestHelpers_1.mockMetas, apiTestHelpers_1.mockTransports);
        expect(mockUserActionLifecycleHandler).toHaveBeenCalled();
    });
});
//# sourceMappingURL=initialize.test.js.map