import { Observable } from '../utils';
import { initializeEventsAPI } from './events';
import { initializeExceptionsAPI } from './exceptions';
import { initializeLogsAPI } from './logs';
import { initializeMeasurementsAPI } from './measurements';
import { initializeMetaAPI } from './meta';
import { initializeTracesAPI } from './traces';
import { createUserActionLifecycleHandler } from './userActionLifecycleHandler';
export const apiMessageBus = new Observable();
export function initializeAPI(unpatchedConsole, internalLogger, config, metas, transports) {
    internalLogger.debug('Initializing API');
    const { actionBuffer, getMessage } = createUserActionLifecycleHandler({ apiMessageBus, transports, config });
    const tracesApi = initializeTracesAPI(unpatchedConsole, internalLogger, config, metas, transports);
    const props = {
        unpatchedConsole,
        internalLogger,
        config,
        metas,
        transports,
        tracesApi,
        actionBuffer,
        getMessage,
    };
    return Object.assign(Object.assign(Object.assign(Object.assign(Object.assign(Object.assign({}, tracesApi), initializeExceptionsAPI(props)), initializeMetaAPI(props)), initializeLogsAPI(props)), initializeMeasurementsAPI(props)), initializeEventsAPI(props));
}
//# sourceMappingURL=initialize.js.map