import { isFunction } from '../utils/is';
export class ItemBuffer {
    constructor() {
        this.buffer = [];
    }
    addItem(item) {
        this.buffer.push(item);
    }
    flushBuffer(cb) {
        if (isFunction(cb)) {
            for (const item of this.buffer) {
                cb(item);
            }
        }
        this.buffer.length = 0;
    }
    size() {
        return this.buffer.length;
    }
}
//# sourceMappingURL=ItemBuffer.js.map