"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Observable = void 0;
var Observable = /** @class */ (function () {
    function Observable() {
        this.subscribers = [];
    }
    Observable.prototype.subscribe = function (subscriber) {
        var _this = this;
        this.subscribers.push(subscriber);
        return {
            unsubscribe: function () { return _this.unsubscribe(subscriber); },
        };
    };
    Observable.prototype.unsubscribe = function (subscriber) {
        this.subscribers = this.subscribers.filter(function (sub) { return sub !== subscriber; });
    };
    Observable.prototype.notify = function (value) {
        this.subscribers.forEach(function (subscriber) { return subscriber(value); });
    };
    Observable.prototype.first = function () {
        var result = new Observable();
        var internalSubscriber = function (data) {
            result.notify(data);
            subscription.unsubscribe();
        };
        var subscription = this.subscribe(internalSubscriber);
        var resultUnsubscribeFn = result.unsubscribe.bind(result);
        return this.withUnsubscribeOverride(result, resultUnsubscribeFn, internalSubscriber);
    };
    Observable.prototype.takeWhile = function (predicate) {
        var result = new Observable();
        var internalSubscriber = function (value) {
            if (predicate(value)) {
                result.notify(value);
            }
            else {
                result.unsubscribe(internalSubscriber);
            }
        };
        this.subscribe(internalSubscriber);
        var resultUnsubscribeFn = result.unsubscribe.bind(result);
        return this.withUnsubscribeOverride(result, resultUnsubscribeFn, internalSubscriber);
    };
    Observable.prototype.filter = function (predicate) {
        var result = new Observable();
        var internalSubscriber = function (value) {
            if (predicate(value)) {
                result.notify(value);
            }
        };
        this.subscribe(internalSubscriber);
        var resultUnsubscribeFn = result.unsubscribe.bind(result);
        return this.withUnsubscribeOverride(result, resultUnsubscribeFn, internalSubscriber);
    };
    Observable.prototype.merge = function () {
        var observables = [];
        for (var _i = 0; _i < arguments.length; _i++) {
            observables[_i] = arguments[_i];
        }
        var mergerObservable = new Observable();
        var subscriptions = [];
        observables.forEach(function (observable) {
            var subscription = observable.subscribe(function (value) {
                mergerObservable.notify(value);
            });
            subscriptions.push(subscription);
        });
        var originalUnsubscribeAll = mergerObservable.unsubscribeAll.bind(mergerObservable);
        mergerObservable.unsubscribe = function () {
            subscriptions.forEach(function (subscription) { return subscription.unsubscribe(); });
            originalUnsubscribeAll();
        };
        return mergerObservable;
    };
    Observable.prototype.withUnsubscribeOverride = function (observable, resultUnsubscribeFn, internalSubscriber) {
        var _this = this;
        observable.unsubscribe = function (subscriber) {
            resultUnsubscribeFn(subscriber);
            _this.unsubscribe(internalSubscriber);
        };
        return observable;
    };
    Observable.prototype.unsubscribeAll = function () {
        this.subscribers = [];
    };
    return Observable;
}());
exports.Observable = Observable;
//# sourceMappingURL=reactive.js.map