"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getCircularDependencyReplacer = getCircularDependencyReplacer;
exports.stringifyExternalJson = stringifyExternalJson;
exports.stringifyObjectValues = stringifyObjectValues;
var is_1 = require("./is");
function getCircularDependencyReplacer() {
    var valueSeen = new WeakSet();
    return function (_key, value) {
        if ((0, is_1.isObject)(value) && value !== null) {
            if (valueSeen.has(value)) {
                return null;
            }
            valueSeen.add(value);
        }
        return value;
    };
}
function stringifyExternalJson(json) {
    if (json === void 0) { json = {}; }
    return JSON.stringify(json !== null && json !== void 0 ? json : {}, getCircularDependencyReplacer());
}
function stringifyObjectValues(obj) {
    if (obj === void 0) { obj = {}; }
    var o = {};
    for (var _i = 0, _a = Object.entries(obj); _i < _a.length; _i++) {
        var _b = _a[_i], key = _b[0], value = _b[1];
        o[key] = (0, is_1.isObject)(value) && value !== null ? stringifyExternalJson(value) : String(value);
    }
    return o;
}
//# sourceMappingURL=json.js.map