"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.setFaroOnGlobalObject = setFaroOnGlobalObject;
var globalObject_1 = require("../globalObject");
function setFaroOnGlobalObject(faro) {
    if (!faro.config.preventGlobalExposure) {
        faro.internalLogger.debug("Registering public faro reference in the global scope using \"".concat(faro.config.globalObjectKey, "\" key"));
        if (faro.config.globalObjectKey in globalObject_1.globalObject) {
            faro.internalLogger.warn("Skipping global registration due to key \"".concat(faro.config.globalObjectKey, "\" being used already. Please set \"globalObjectKey\" to something else or set \"preventGlobalExposure\" to \"true\""));
            return;
        }
        Object.defineProperty(globalObject_1.globalObject, faro.config.globalObjectKey, {
            configurable: false,
            writable: false,
            value: faro,
        });
    }
    else {
        faro.internalLogger.debug('Skipping registering public Faro instance in the global scope');
    }
}
//# sourceMappingURL=faroGlobalObject.js.map