"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.initializeMetaAPI = initializeMetaAPI;
var is_1 = require("../../utils/is");
function initializeMetaAPI(_a) {
    var internalLogger = _a.internalLogger, metas = _a.metas;
    internalLogger.debug('Initializing meta API');
    var metaSession = undefined;
    var metaUser = undefined;
    var metaView = undefined;
    var metaPage = undefined;
    var setUser = function (user) {
        if (metaUser) {
            metas.remove(metaUser);
        }
        metaUser = {
            user: user,
        };
        metas.add(metaUser);
    };
    var setSession = function (session, options) {
        var _a;
        var newOverrides = options === null || options === void 0 ? void 0 : options.overrides;
        var overrides = newOverrides
            ? {
                overrides: __assign(__assign({}, (_a = metaSession === null || metaSession === void 0 ? void 0 : metaSession.session) === null || _a === void 0 ? void 0 : _a.overrides), newOverrides),
            }
            : {};
        if (metaSession) {
            metas.remove(metaSession);
        }
        metaSession = {
            session: __assign(__assign({}, ((0, is_1.isEmpty)(session) ? undefined : session)), overrides),
        };
        metas.add(metaSession);
    };
    var getSession = function () { return metas.value.session; };
    var setView = function (view, options) {
        var _a;
        if (options === null || options === void 0 ? void 0 : options.overrides) {
            setSession(getSession(), { overrides: options.overrides });
        }
        if (((_a = metaView === null || metaView === void 0 ? void 0 : metaView.view) === null || _a === void 0 ? void 0 : _a.name) === (view === null || view === void 0 ? void 0 : view.name)) {
            return;
        }
        var previousView = metaView;
        metaView = {
            view: view,
        };
        metas.add(metaView);
        if (previousView) {
            metas.remove(previousView);
        }
    };
    var getView = function () { return metas.value.view; };
    var setPage = function (page) {
        var _a;
        var pageMeta = (0, is_1.isString)(page)
            ? __assign(__assign({}, ((_a = metaPage === null || metaPage === void 0 ? void 0 : metaPage.page) !== null && _a !== void 0 ? _a : getPage())), { id: page }) : page;
        if (metaPage) {
            metas.remove(metaPage);
        }
        metaPage = {
            page: pageMeta,
        };
        metas.add(metaPage);
    };
    var getPage = function () { return metas.value.page; };
    return {
        setUser: setUser,
        resetUser: setUser,
        setSession: setSession,
        resetSession: setSession,
        getSession: getSession,
        setView: setView,
        getView: getView,
        setPage: setPage,
        getPage: getPage,
    };
}
//# sourceMappingURL=initialize.js.map