"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.apiMessageBus = void 0;
exports.initializeAPI = initializeAPI;
var utils_1 = require("../utils");
var events_1 = require("./events");
var exceptions_1 = require("./exceptions");
var logs_1 = require("./logs");
var measurements_1 = require("./measurements");
var meta_1 = require("./meta");
var traces_1 = require("./traces");
var userActionLifecycleHandler_1 = require("./userActionLifecycleHandler");
exports.apiMessageBus = new utils_1.Observable();
function initializeAPI(unpatchedConsole, internalLogger, config, metas, transports) {
    internalLogger.debug('Initializing API');
    var _a = (0, userActionLifecycleHandler_1.createUserActionLifecycleHandler)({ apiMessageBus: exports.apiMessageBus, transports: transports, config: config }), actionBuffer = _a.actionBuffer, getMessage = _a.getMessage;
    var tracesApi = (0, traces_1.initializeTracesAPI)(unpatchedConsole, internalLogger, config, metas, transports);
    var props = {
        unpatchedConsole: unpatchedConsole,
        internalLogger: internalLogger,
        config: config,
        metas: metas,
        transports: transports,
        tracesApi: tracesApi,
        actionBuffer: actionBuffer,
        getMessage: getMessage,
    };
    return __assign(__assign(__assign(__assign(__assign(__assign({}, tracesApi), (0, exceptions_1.initializeExceptionsAPI)(props)), (0, meta_1.initializeMetaAPI)(props)), (0, logs_1.initializeLogsAPI)(props)), (0, measurements_1.initializeMeasurementsAPI)(props)), (0, events_1.initializeEventsAPI)(props));
}
//# sourceMappingURL=initialize.js.map