"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.initializeEventsAPI = initializeEventsAPI;
var transports_1 = require("../../transports");
var utils_1 = require("../../utils");
var date_1 = require("../../utils/date");
var const_1 = require("../const");
function initializeEventsAPI(_a) {
    var internalLogger = _a.internalLogger, config = _a.config, metas = _a.metas, transports = _a.transports, tracesApi = _a.tracesApi, actionBuffer = _a.actionBuffer, getMessage = _a.getMessage;
    var lastPayload = null;
    var pushEvent = function (name, attributes, domain, _a) {
        var _b = _a === void 0 ? {} : _a, skipDedupe = _b.skipDedupe, spanContext = _b.spanContext, timestampOverwriteMs = _b.timestampOverwriteMs, _c = _b.customPayloadTransformer, customPayloadTransformer = _c === void 0 ? function (payload) { return payload; } : _c;
        try {
            var attrs = (0, utils_1.stringifyObjectValues)(attributes);
            var item = {
                meta: metas.value,
                payload: customPayloadTransformer({
                    name: name,
                    domain: domain !== null && domain !== void 0 ? domain : config.eventDomain,
                    attributes: (0, utils_1.isEmpty)(attrs) ? undefined : attrs,
                    timestamp: timestampOverwriteMs ? (0, date_1.timestampToIsoString)(timestampOverwriteMs) : (0, utils_1.getCurrentTimestamp)(),
                    trace: spanContext
                        ? {
                            trace_id: spanContext.traceId,
                            span_id: spanContext.spanId,
                        }
                        : tracesApi.getTraceContext(),
                }),
                type: transports_1.TransportItemType.EVENT,
            };
            var testingPayload = {
                name: item.payload.name,
                attributes: item.payload.attributes,
                domain: item.payload.domain,
            };
            if (!skipDedupe && config.dedupe && !(0, utils_1.isNull)(lastPayload) && (0, utils_1.deepEqual)(testingPayload, lastPayload)) {
                internalLogger.debug('Skipping event push because it is the same as the last one\n', item.payload);
                return;
            }
            lastPayload = testingPayload;
            internalLogger.debug('Pushing event\n', item);
            var msg = getMessage();
            if (msg && msg.type === const_1.USER_ACTION_START) {
                actionBuffer.addItem(item);
            }
            else {
                transports.execute(item);
            }
        }
        catch (err) {
            internalLogger.error('Error pushing event', err);
        }
    };
    return {
        pushEvent: pushEvent,
    };
}
//# sourceMappingURL=initialize.js.map