// Code generated by Wire. DO NOT EDIT.

//go:generate go run ./pkg/build/wire/cmd/wire/main.go gen -tags "oss"
//go:build !wireinject && !enterprise && !pro

package server

import (
	"github.com/google/wire"
	httpclient2 "github.com/grafana/grafana-plugin-sdk-go/backend/httpclient"
	"github.com/grafana/grafana/pkg/api"
	"github.com/grafana/grafana/pkg/api/avatar"
	"github.com/grafana/grafana/pkg/api/routing"
	"github.com/grafana/grafana/pkg/bus"
	"github.com/grafana/grafana/pkg/expr"
	"github.com/grafana/grafana/pkg/infra/db"
	"github.com/grafana/grafana/pkg/infra/httpclient"
	"github.com/grafana/grafana/pkg/infra/httpclient/httpclientprovider"
	"github.com/grafana/grafana/pkg/infra/kvstore"
	"github.com/grafana/grafana/pkg/infra/localcache"
	"github.com/grafana/grafana/pkg/infra/log/slogadapter"
	"github.com/grafana/grafana/pkg/infra/metrics"
	"github.com/grafana/grafana/pkg/infra/remotecache"
	"github.com/grafana/grafana/pkg/infra/serverlock"
	"github.com/grafana/grafana/pkg/infra/tracing"
	"github.com/grafana/grafana/pkg/infra/usagestats"
	"github.com/grafana/grafana/pkg/infra/usagestats/service"
	"github.com/grafana/grafana/pkg/infra/usagestats/statscollector"
	validator2 "github.com/grafana/grafana/pkg/infra/usagestats/validator"
	"github.com/grafana/grafana/pkg/login/social"
	"github.com/grafana/grafana/pkg/login/social/connectors"
	"github.com/grafana/grafana/pkg/login/social/socialimpl"
	"github.com/grafana/grafana/pkg/middleware/csrf"
	"github.com/grafana/grafana/pkg/middleware/loggermw"
	"github.com/grafana/grafana/pkg/plugins/backendplugin/coreplugin"
	provider2 "github.com/grafana/grafana/pkg/plugins/backendplugin/provider"
	manager3 "github.com/grafana/grafana/pkg/plugins/manager"
	"github.com/grafana/grafana/pkg/plugins/manager/filestore"
	"github.com/grafana/grafana/pkg/plugins/manager/loader/assetpath"
	"github.com/grafana/grafana/pkg/plugins/manager/loader/finder"
	"github.com/grafana/grafana/pkg/plugins/manager/process"
	"github.com/grafana/grafana/pkg/plugins/manager/registry"
	"github.com/grafana/grafana/pkg/plugins/manager/signature"
	"github.com/grafana/grafana/pkg/plugins/manager/sources"
	"github.com/grafana/grafana/pkg/plugins/pluginscdn"
	"github.com/grafana/grafana/pkg/plugins/repo"
	"github.com/grafana/grafana/pkg/registry/apis"
	notifications2 "github.com/grafana/grafana/pkg/registry/apis/alerting/notifications"
	"github.com/grafana/grafana/pkg/registry/apis/dashboard"
	"github.com/grafana/grafana/pkg/registry/apis/dashboard/v0alpha1"
	"github.com/grafana/grafana/pkg/registry/apis/dashboard/v1alpha1"
	"github.com/grafana/grafana/pkg/registry/apis/dashboard/v2alpha1"
	"github.com/grafana/grafana/pkg/registry/apis/dashboardsnapshot"
	"github.com/grafana/grafana/pkg/registry/apis/datasource"
	"github.com/grafana/grafana/pkg/registry/apis/featuretoggle"
	"github.com/grafana/grafana/pkg/registry/apis/folders"
	"github.com/grafana/grafana/pkg/registry/apis/iam"
	"github.com/grafana/grafana/pkg/registry/apis/peakq"
	query2 "github.com/grafana/grafana/pkg/registry/apis/query"
	"github.com/grafana/grafana/pkg/registry/apis/scope"
	"github.com/grafana/grafana/pkg/registry/apis/userstorage"
	"github.com/grafana/grafana/pkg/registry/apps"
	"github.com/grafana/grafana/pkg/registry/apps/investigation"
	"github.com/grafana/grafana/pkg/registry/apps/playlist"
	"github.com/grafana/grafana/pkg/registry/backgroundsvcs"
	"github.com/grafana/grafana/pkg/registry/usagestatssvcs"
	"github.com/grafana/grafana/pkg/services/accesscontrol"
	"github.com/grafana/grafana/pkg/services/accesscontrol/acimpl"
	"github.com/grafana/grafana/pkg/services/accesscontrol/ossaccesscontrol"
	"github.com/grafana/grafana/pkg/services/accesscontrol/permreg"
	"github.com/grafana/grafana/pkg/services/accesscontrol/resourcepermissions"
	"github.com/grafana/grafana/pkg/services/annotations"
	"github.com/grafana/grafana/pkg/services/annotations/annotationsimpl"
	"github.com/grafana/grafana/pkg/services/anonymous/anonimpl"
	"github.com/grafana/grafana/pkg/services/anonymous/anonimpl/anonstore"
	"github.com/grafana/grafana/pkg/services/anonymous/validator"
	"github.com/grafana/grafana/pkg/services/apikey/apikeyimpl"
	"github.com/grafana/grafana/pkg/services/apiserver"
	"github.com/grafana/grafana/pkg/services/apiserver/standalone"
	"github.com/grafana/grafana/pkg/services/auth"
	"github.com/grafana/grafana/pkg/services/auth/authimpl"
	"github.com/grafana/grafana/pkg/services/auth/idimpl"
	"github.com/grafana/grafana/pkg/services/auth/jwt"
	"github.com/grafana/grafana/pkg/services/authn/authnimpl"
	"github.com/grafana/grafana/pkg/services/authz"
	"github.com/grafana/grafana/pkg/services/caching"
	"github.com/grafana/grafana/pkg/services/cleanup"
	"github.com/grafana/grafana/pkg/services/cloudmigration/cloudmigrationimpl"
	"github.com/grafana/grafana/pkg/services/contexthandler"
	"github.com/grafana/grafana/pkg/services/correlations"
	"github.com/grafana/grafana/pkg/services/dashboardimport"
	service9 "github.com/grafana/grafana/pkg/services/dashboardimport/service"
	database2 "github.com/grafana/grafana/pkg/services/dashboards/database"
	service5 "github.com/grafana/grafana/pkg/services/dashboards/service"
	"github.com/grafana/grafana/pkg/services/dashboardsnapshots"
	database3 "github.com/grafana/grafana/pkg/services/dashboardsnapshots/database"
	service7 "github.com/grafana/grafana/pkg/services/dashboardsnapshots/service"
	"github.com/grafana/grafana/pkg/services/dashboardversion/dashverimpl"
	"github.com/grafana/grafana/pkg/services/datasourceproxy"
	"github.com/grafana/grafana/pkg/services/datasources"
	"github.com/grafana/grafana/pkg/services/datasources/guardian"
	service4 "github.com/grafana/grafana/pkg/services/datasources/service"
	"github.com/grafana/grafana/pkg/services/encryption"
	"github.com/grafana/grafana/pkg/services/encryption/provider"
	service2 "github.com/grafana/grafana/pkg/services/encryption/service"
	"github.com/grafana/grafana/pkg/services/extsvcauth"
	registry2 "github.com/grafana/grafana/pkg/services/extsvcauth/registry"
	"github.com/grafana/grafana/pkg/services/featuremgmt"
	"github.com/grafana/grafana/pkg/services/folder"
	"github.com/grafana/grafana/pkg/services/folder/folderimpl"
	"github.com/grafana/grafana/pkg/services/grpcserver"
	"github.com/grafana/grafana/pkg/services/grpcserver/context"
	"github.com/grafana/grafana/pkg/services/grpcserver/interceptors"
	guardian2 "github.com/grafana/grafana/pkg/services/guardian"
	"github.com/grafana/grafana/pkg/services/hooks"
	"github.com/grafana/grafana/pkg/services/kmsproviders/osskmsproviders"
	"github.com/grafana/grafana/pkg/services/ldap"
	api4 "github.com/grafana/grafana/pkg/services/ldap/api"
	service10 "github.com/grafana/grafana/pkg/services/ldap/service"
	"github.com/grafana/grafana/pkg/services/libraryelements"
	"github.com/grafana/grafana/pkg/services/librarypanels"
	"github.com/grafana/grafana/pkg/services/licensing"
	"github.com/grafana/grafana/pkg/services/live"
	"github.com/grafana/grafana/pkg/services/live/pushhttp"
	"github.com/grafana/grafana/pkg/services/login"
	"github.com/grafana/grafana/pkg/services/login/authinfoimpl"
	"github.com/grafana/grafana/pkg/services/loginattempt"
	"github.com/grafana/grafana/pkg/services/loginattempt/loginattemptimpl"
	"github.com/grafana/grafana/pkg/services/navtree/navtreeimpl"
	"github.com/grafana/grafana/pkg/services/ngalert"
	"github.com/grafana/grafana/pkg/services/ngalert/image"
	metrics2 "github.com/grafana/grafana/pkg/services/ngalert/metrics"
	store2 "github.com/grafana/grafana/pkg/services/ngalert/store"
	"github.com/grafana/grafana/pkg/services/notifications"
	"github.com/grafana/grafana/pkg/services/oauthtoken"
	"github.com/grafana/grafana/pkg/services/oauthtoken/oauthtokentest"
	"github.com/grafana/grafana/pkg/services/org/orgimpl"
	"github.com/grafana/grafana/pkg/services/playlist/playlistimpl"
	"github.com/grafana/grafana/pkg/services/plugindashboards"
	service6 "github.com/grafana/grafana/pkg/services/plugindashboards/service"
	"github.com/grafana/grafana/pkg/services/pluginsintegration"
	"github.com/grafana/grafana/pkg/services/pluginsintegration/angulardetectorsprovider"
	"github.com/grafana/grafana/pkg/services/pluginsintegration/angularinspector"
	"github.com/grafana/grafana/pkg/services/pluginsintegration/angularpatternsstore"
	"github.com/grafana/grafana/pkg/services/pluginsintegration/dashboards"
	"github.com/grafana/grafana/pkg/services/pluginsintegration/keyretriever"
	"github.com/grafana/grafana/pkg/services/pluginsintegration/keyretriever/dynamic"
	"github.com/grafana/grafana/pkg/services/pluginsintegration/keystore"
	licensing2 "github.com/grafana/grafana/pkg/services/pluginsintegration/licensing"
	"github.com/grafana/grafana/pkg/services/pluginsintegration/loader"
	"github.com/grafana/grafana/pkg/services/pluginsintegration/managedplugins"
	"github.com/grafana/grafana/pkg/services/pluginsintegration/pipeline"
	"github.com/grafana/grafana/pkg/services/pluginsintegration/pluginaccesscontrol"
	"github.com/grafana/grafana/pkg/services/pluginsintegration/pluginassets"
	"github.com/grafana/grafana/pkg/services/pluginsintegration/pluginconfig"
	"github.com/grafana/grafana/pkg/services/pluginsintegration/plugincontext"
	"github.com/grafana/grafana/pkg/services/pluginsintegration/pluginerrs"
	"github.com/grafana/grafana/pkg/services/pluginsintegration/pluginexternal"
	"github.com/grafana/grafana/pkg/services/pluginsintegration/plugininstaller"
	service3 "github.com/grafana/grafana/pkg/services/pluginsintegration/pluginsettings/service"
	"github.com/grafana/grafana/pkg/services/pluginsintegration/pluginstore"
	"github.com/grafana/grafana/pkg/services/pluginsintegration/renderer"
	"github.com/grafana/grafana/pkg/services/pluginsintegration/serviceregistration"
	"github.com/grafana/grafana/pkg/services/preference/prefimpl"
	"github.com/grafana/grafana/pkg/services/provisioning"
	"github.com/grafana/grafana/pkg/services/publicdashboards"
	api2 "github.com/grafana/grafana/pkg/services/publicdashboards/api"
	database4 "github.com/grafana/grafana/pkg/services/publicdashboards/database"
	"github.com/grafana/grafana/pkg/services/publicdashboards/metric"
	service8 "github.com/grafana/grafana/pkg/services/publicdashboards/service"
	"github.com/grafana/grafana/pkg/services/query"
	"github.com/grafana/grafana/pkg/services/queryhistory"
	"github.com/grafana/grafana/pkg/services/quota/quotaimpl"
	"github.com/grafana/grafana/pkg/services/rendering"
	search2 "github.com/grafana/grafana/pkg/services/search"
	"github.com/grafana/grafana/pkg/services/searchV2"
	"github.com/grafana/grafana/pkg/services/searchusers"
	"github.com/grafana/grafana/pkg/services/searchusers/filters"
	"github.com/grafana/grafana/pkg/services/secrets"
	"github.com/grafana/grafana/pkg/services/secrets/database"
	kvstore2 "github.com/grafana/grafana/pkg/services/secrets/kvstore"
	migrations2 "github.com/grafana/grafana/pkg/services/secrets/kvstore/migrations"
	"github.com/grafana/grafana/pkg/services/secrets/manager"
	"github.com/grafana/grafana/pkg/services/secrets/migrator"
	"github.com/grafana/grafana/pkg/services/serviceaccounts"
	"github.com/grafana/grafana/pkg/services/serviceaccounts/extsvcaccounts"
	manager2 "github.com/grafana/grafana/pkg/services/serviceaccounts/manager"
	"github.com/grafana/grafana/pkg/services/serviceaccounts/proxy"
	"github.com/grafana/grafana/pkg/services/serviceaccounts/retriever"
	"github.com/grafana/grafana/pkg/services/shorturls"
	"github.com/grafana/grafana/pkg/services/shorturls/shorturlimpl"
	"github.com/grafana/grafana/pkg/services/signingkeys"
	"github.com/grafana/grafana/pkg/services/signingkeys/signingkeysimpl"
	"github.com/grafana/grafana/pkg/services/sqlstore"
	"github.com/grafana/grafana/pkg/services/sqlstore/migrations"
	"github.com/grafana/grafana/pkg/services/sqlstore/sqlutil"
	"github.com/grafana/grafana/pkg/services/ssosettings"
	"github.com/grafana/grafana/pkg/services/ssosettings/ssosettingsimpl"
	api3 "github.com/grafana/grafana/pkg/services/star/api"
	"github.com/grafana/grafana/pkg/services/star/starimpl"
	"github.com/grafana/grafana/pkg/services/stats/statsimpl"
	"github.com/grafana/grafana/pkg/services/store"
	"github.com/grafana/grafana/pkg/services/store/resolver"
	"github.com/grafana/grafana/pkg/services/store/sanitizer"
	"github.com/grafana/grafana/pkg/services/supportbundles"
	"github.com/grafana/grafana/pkg/services/supportbundles/bundleregistry"
	"github.com/grafana/grafana/pkg/services/supportbundles/supportbundlesimpl"
	"github.com/grafana/grafana/pkg/services/tag"
	"github.com/grafana/grafana/pkg/services/tag/tagimpl"
	"github.com/grafana/grafana/pkg/services/team/teamapi"
	"github.com/grafana/grafana/pkg/services/team/teamimpl"
	"github.com/grafana/grafana/pkg/services/temp_user"
	"github.com/grafana/grafana/pkg/services/temp_user/tempuserimpl"
	"github.com/grafana/grafana/pkg/services/updatechecker"
	"github.com/grafana/grafana/pkg/services/user"
	"github.com/grafana/grafana/pkg/services/user/userimpl"
	"github.com/grafana/grafana/pkg/services/validations"
	"github.com/grafana/grafana/pkg/setting"
	"github.com/grafana/grafana/pkg/storage/unified"
	"github.com/grafana/grafana/pkg/storage/unified/resource"
	"github.com/grafana/grafana/pkg/storage/unified/search"
	"github.com/grafana/grafana/pkg/tsdb/azuremonitor"
	"github.com/grafana/grafana/pkg/tsdb/cloud-monitoring"
	"github.com/grafana/grafana/pkg/tsdb/cloudwatch"
	"github.com/grafana/grafana/pkg/tsdb/elasticsearch"
	"github.com/grafana/grafana/pkg/tsdb/grafana-postgresql-datasource"
	"github.com/grafana/grafana/pkg/tsdb/grafana-pyroscope-datasource"
	"github.com/grafana/grafana/pkg/tsdb/grafana-testdata-datasource"
	"github.com/grafana/grafana/pkg/tsdb/grafanads"
	"github.com/grafana/grafana/pkg/tsdb/graphite"
	"github.com/grafana/grafana/pkg/tsdb/influxdb"
	"github.com/grafana/grafana/pkg/tsdb/loki"
	"github.com/grafana/grafana/pkg/tsdb/mssql"
	"github.com/grafana/grafana/pkg/tsdb/mysql"
	"github.com/grafana/grafana/pkg/tsdb/opentsdb"
	"github.com/grafana/grafana/pkg/tsdb/parca"
	"github.com/grafana/grafana/pkg/tsdb/prometheus"
	"github.com/grafana/grafana/pkg/tsdb/tempo"
	"github.com/grafana/grafana/pkg/tsdb/zipkin"
)

import (
	_ "github.com/grafana/grafana/pkg/extensions"
)

// Injectors from wire.go:

func Initialize(cfg *setting.Cfg, opts Options, apiOpts api.ServerOptions) (*Server, error) {
	routeRegisterImpl := routing.ProvideRegister()
	tracingConfig, err := tracing.ProvideTracingConfig(cfg)
	if err != nil {
		return nil, err
	}
	tracingService, err := tracing.ProvideService(tracingConfig)
	if err != nil {
		return nil, err
	}
	inProcBus := bus.ProvideBus(tracingService)
	featureManager, err := featuremgmt.ProvideManagerService(cfg)
	if err != nil {
		return nil, err
	}
	featureToggles := featuremgmt.ProvideToggles(featureManager)
	ossMigrations := migrations.ProvideOSSMigrations(featureToggles)
	sqlStore, err := sqlstore.ProvideService(cfg, featureToggles, ossMigrations, inProcBus, tracingService)
	if err != nil {
		return nil, err
	}
	kvStore := kvstore.ProvideService(sqlStore)
	accessControl := acimpl.ProvideAccessControl(featureToggles)
	bundleregistryService := bundleregistry.ProvideService()
	usageStats, err := service.ProvideService(cfg, kvStore, routeRegisterImpl, tracingService, accessControl, bundleregistryService)
	if err != nil {
		return nil, err
	}
	secretsStoreImpl := database.ProvideSecretsStore(sqlStore)
	providerProvider := provider.ProvideEncryptionProvider()
	serviceService, err := service2.ProvideEncryptionService(tracingService, providerProvider, usageStats, cfg)
	if err != nil {
		return nil, err
	}
	osskmsprovidersService := osskmsproviders.ProvideService(serviceService, cfg, featureToggles)
	secretsService, err := manager.ProvideSecretsService(tracingService, secretsStoreImpl, osskmsprovidersService, serviceService, cfg, featureToggles, usageStats)
	if err != nil {
		return nil, err
	}
	remoteCache, err := remotecache.ProvideService(cfg, sqlStore, usageStats, secretsService)
	if err != nil {
		return nil, err
	}
	ossImpl := setting.ProvideProvider(cfg)
	pluginManagementCfg, err := pluginconfig.ProvidePluginManagementConfig(cfg, ossImpl, featureToggles)
	if err != nil {
		return nil, err
	}
	pluginInstanceCfg, err := pluginconfig.ProvidePluginInstanceConfig(cfg, ossImpl, featureToggles)
	if err != nil {
		return nil, err
	}
	hooksService := hooks.ProvideService()
	ossLicensingService := licensing.ProvideService(cfg, hooksService)
	licensingService := licensing2.ProvideLicensing(cfg, ossLicensingService)
	envVarsProvider := pluginconfig.NewEnvVarsProvider(pluginInstanceCfg, licensingService)
	inMemory := registry.ProvideService()
	rendererManager, err := renderer.ProvideService(pluginManagementCfg, envVarsProvider, inMemory, tracingService)
	if err != nil {
		return nil, err
	}
	renderingService, err := rendering.ProvideService(cfg, featureToggles, remoteCache, rendererManager)
	if err != nil {
		return nil, err
	}
	cacheService := localcache.ProvideService()
	ossPluginRequestValidator := validations.ProvideValidator()
	sourcesService := sources.ProvideService(cfg)
	local := finder.ProvideLocalFinder(pluginManagementCfg)
	discovery := pipeline.ProvideDiscoveryStage(pluginManagementCfg, local, inMemory)
	keystoreService := keystore.ProvideService(kvStore)
	keyRetriever := dynamic.ProvideService(cfg, keystoreService)
	keyretrieverService := keyretriever.ProvideService(keyRetriever)
	signatureSignature := signature.ProvideService(pluginManagementCfg, keyretrieverService)
	pluginscdnService := pluginscdn.ProvideService(pluginManagementCfg)
	assetpathService := assetpath.ProvideService(pluginManagementCfg, pluginscdnService)
	bootstrap := pipeline.ProvideBootstrapStage(pluginManagementCfg, signatureSignature, assetpathService)
	unsignedPluginAuthorizer := signature.ProvideOSSAuthorizer(pluginManagementCfg)
	validation := signature.ProvideValidatorService(unsignedPluginAuthorizer)
	angularpatternsstoreService := angularpatternsstore.ProvideService(kvStore)
	angulardetectorsproviderDynamic, err := angulardetectorsprovider.ProvideDynamic(cfg, angularpatternsstoreService)
	if err != nil {
		return nil, err
	}
	angularinspectorService, err := angularinspector.ProvideService(angulardetectorsproviderDynamic)
	if err != nil {
		return nil, err
	}
	validate := pipeline.ProvideValidationStage(pluginManagementCfg, validation, angularinspectorService)
	httpclientProvider := httpclientprovider.New(cfg, ossPluginRequestValidator, tracingService)
	azuremonitorService := azuremonitor.ProvideService(httpclientProvider)
	cloudWatchService := cloudwatch.ProvideService(httpclientProvider)
	cloudmonitoringService := cloudmonitoring.ProvideService(httpclientProvider)
	elasticsearchService := elasticsearch.ProvideService(httpclientProvider)
	graphiteService := graphite.ProvideService(httpclientProvider, tracingService)
	influxdbService := influxdb.ProvideService(httpclientProvider, featureToggles)
	lokiService := loki.ProvideService(httpclientProvider, tracingService)
	opentsdbService := opentsdb.ProvideService(httpclientProvider)
	prometheusService := prometheus.ProvideService(httpclientProvider)
	tempoService := tempo.ProvideService(httpclientProvider)
	testdatasourceService := testdatasource.ProvideService()
	postgresService := postgres.ProvideService(cfg)
	mysqlService := mysql.ProvideService()
	mssqlService := mssql.ProvideService(cfg)
	entityEventsService := store.ProvideEntityEventsService(cfg, sqlStore, featureToggles)
	quotaService := quotaimpl.ProvideService(sqlStore, cfg)
	orgService, err := orgimpl.ProvideService(sqlStore, cfg, quotaService)
	if err != nil {
		return nil, err
	}
	teamService, err := teamimpl.ProvideService(sqlStore, cfg, tracingService)
	if err != nil {
		return nil, err
	}
	userService, err := userimpl.ProvideService(sqlStore, orgService, cfg, teamService, cacheService, tracingService, quotaService, bundleregistryService)
	if err != nil {
		return nil, err
	}
	actionSetService := resourcepermissions.NewActionSetService(featureToggles)
	client, err := authz.ProvideZanzana(cfg, sqlStore, featureToggles)
	if err != nil {
		return nil, err
	}
	permissionRegistry := permreg.ProvidePermissionRegistry()
	serverLockService := serverlock.ProvideService(sqlStore, tracingService)
	folderStoreImpl := folderimpl.ProvideStore(sqlStore)
	tagimplService := tagimpl.ProvideService(sqlStore)
	dashboardsStore, err := database2.ProvideDashboardStore(sqlStore, cfg, featureToggles, tagimplService)
	if err != nil {
		return nil, err
	}
	dashboardFolderStoreImpl := folderimpl.ProvideDashboardFolderStore(sqlStore)
	registerer := metrics.ProvideRegisterer()
	folderimplService := folderimpl.ProvideService(folderStoreImpl, accessControl, inProcBus, dashboardsStore, dashboardFolderStoreImpl, sqlStore, featureToggles, bundleregistryService, cfg, registerer, tracingService)
	acimplService, err := acimpl.ProvideService(cfg, sqlStore, routeRegisterImpl, cacheService, accessControl, userService, actionSetService, featureToggles, tracingService, client, permissionRegistry, serverLockService, folderimplService)
	if err != nil {
		return nil, err
	}
	searchService := searchV2.ProvideService(cfg, sqlStore, entityEventsService, acimplService, tracingService, featureToggles, orgService, userService, folderimplService)
	systemUsers := store.ProvideSystemUsersService()
	storageService, err := store.ProvideService(sqlStore, featureToggles, cfg, quotaService, systemUsers)
	if err != nil {
		return nil, err
	}
	grafanadsService := grafanads.ProvideService(searchService, storageService, featureToggles)
	pyroscopeService := pyroscope.ProvideService(httpclientProvider)
	parcaService := parca.ProvideService(httpclientProvider)
	zipkinService := zipkin.ProvideService(httpclientProvider)
	corepluginRegistry := coreplugin.ProvideCoreRegistry(tracingService, azuremonitorService, cloudWatchService, cloudmonitoringService, elasticsearchService, graphiteService, influxdbService, lokiService, opentsdbService, prometheusService, tempoService, testdatasourceService, postgresService, mysqlService, mssqlService, grafanadsService, pyroscopeService, parcaService, zipkinService)
	providerService := provider2.ProvideService(corepluginRegistry)
	processService := process.ProvideService()
	apikeyService, err := apikeyimpl.ProvideService(sqlStore, cfg, quotaService)
	if err != nil {
		return nil, err
	}
	retrieverService := retriever.ProvideService(sqlStore, apikeyService, kvStore, userService, orgService)
	serviceAccountPermissionsService, err := ossaccesscontrol.ProvideServiceAccountPermissions(cfg, featureToggles, routeRegisterImpl, sqlStore, accessControl, ossLicensingService, retrieverService, acimplService, teamService, userService, actionSetService)
	if err != nil {
		return nil, err
	}
	serviceAccountsService, err := manager2.ProvideServiceAccountsService(cfg, usageStats, sqlStore, apikeyService, kvStore, userService, orgService, acimplService, serviceAccountPermissionsService)
	if err != nil {
		return nil, err
	}
	extSvcAccountsService := extsvcaccounts.ProvideExtSvcAccountsService(acimplService, cfg, inProcBus, sqlStore, featureToggles, registerer, serviceAccountsService, secretsService, tracingService)
	registryRegistry := registry2.ProvideExtSvcRegistry(cfg, extSvcAccountsService, serverLockService, featureToggles)
	service11 := service3.ProvideService(sqlStore, secretsService)
	serviceregistrationService := serviceregistration.ProvideService(cfg, featureToggles, registryRegistry, service11)
	initialize := pipeline.ProvideInitializationStage(pluginManagementCfg, inMemory, providerService, processService, serviceregistrationService, acimplService, actionSetService, envVarsProvider, tracingService)
	terminate, err := pipeline.ProvideTerminationStage(pluginManagementCfg, inMemory, processService)
	if err != nil {
		return nil, err
	}
	errorRegistry := pluginerrs.ProvideErrorTracker()
	loaderLoader := loader.ProvideService(discovery, bootstrap, validate, initialize, terminate, errorRegistry)
	pluginstoreService, err := pluginstore.ProvideService(inMemory, sourcesService, loaderLoader)
	if err != nil {
		return nil, err
	}
	filestoreService := filestore.ProvideService(inMemory)
	fileStoreManager := dashboards.ProvideFileStoreManager(pluginstoreService, filestoreService)
	folderPermissionsService, err := ossaccesscontrol.ProvideFolderPermissions(cfg, featureToggles, routeRegisterImpl, sqlStore, accessControl, ossLicensingService, dashboardsStore, folderimplService, acimplService, teamService, userService, actionSetService)
	if err != nil {
		return nil, err
	}
	dashboardPermissionsService, err := ossaccesscontrol.ProvideDashboardPermissions(cfg, featureToggles, routeRegisterImpl, sqlStore, accessControl, ossLicensingService, dashboardsStore, folderimplService, acimplService, teamService, userService, actionSetService)
	if err != nil {
		return nil, err
	}
	orgRoleMapper := connectors.ProvideOrgRoleMapper(cfg, orgService)
	ssosettingsimplService := ssosettingsimpl.ProvideService(cfg, sqlStore, accessControl, routeRegisterImpl, featureToggles, secretsService, usageStats, registerer, ossImpl, ossLicensingService)
	socialService := socialimpl.ProvideService(cfg, featureToggles, usageStats, bundleregistryService, remoteCache, orgRoleMapper, ssosettingsimplService)
	loginStore := authinfoimpl.ProvideStore(sqlStore, secretsService)
	authinfoimplService := authinfoimpl.ProvideService(loginStore, remoteCache, secretsService)
	userAuthTokenService, err := authimpl.ProvideUserAuthTokenService(sqlStore, serverLockService, quotaService, secretsService, cfg, tracingService)
	if err != nil {
		return nil, err
	}
	oauthtokenService := oauthtoken.ProvideService(socialService, authinfoimplService, cfg, registerer, serverLockService, tracingService, userAuthTokenService, featureToggles)
	ossCachingService := caching.ProvideCachingService()
	middlewareHandler, err := pluginsintegration.ProvideClientWithMiddlewares(cfg, inMemory, oauthtokenService, tracingService, ossCachingService, featureToggles, registerer)
	if err != nil {
		return nil, err
	}
	secretsKVStore, err := kvstore2.ProvideService(sqlStore, secretsService, pluginstoreService, kvStore, featureToggles, cfg)
	if err != nil {
		return nil, err
	}
	datasourcePermissionsService := ossaccesscontrol.ProvideDatasourcePermissionsService(cfg, featureToggles, sqlStore)
	requestConfigProvider := pluginconfig.NewRequestConfigProvider(pluginInstanceCfg)
	baseProvider := plugincontext.ProvideBaseService(cfg, requestConfigProvider)
	service12, err := service4.ProvideService(sqlStore, secretsService, secretsKVStore, cfg, featureToggles, accessControl, datasourcePermissionsService, quotaService, pluginstoreService, middlewareHandler, baseProvider)
	if err != nil {
		return nil, err
	}
	ossProvider := guardian.ProvideGuardian()
	cacheServiceImpl := service4.ProvideCacheService(cacheService, sqlStore, ossProvider)
	plugincontextProvider := plugincontext.ProvideService(cfg, cacheService, pluginstoreService, cacheServiceImpl, service12, service11, requestConfigProvider)
	scopedPluginDatasourceProvider := datasource.ProvideDefaultPluginConfigs(service12, cacheServiceImpl, plugincontextProvider)
	contextHandler := grpccontext.ProvideContextHandler(tracingService)
	authenticator := interceptors.ProvideAuthenticator(apikeyService, userService, acimplService, contextHandler)
	grpcserverProvider, err := grpcserver.ProvideService(cfg, featureToggles, authenticator, tracingService, registerer)
	if err != nil {
		return nil, err
	}
	authzClient, err := authz.ProvideAuthZClient(cfg, featureToggles, grpcserverProvider, tracingService, sqlStore)
	if err != nil {
		return nil, err
	}
	ossDashboardStats := search.ProvideDashboardStats()
	documentBuilderSupplier := search.ProvideDocumentBuilders(sqlStore, ossDashboardStats)
	resourceClient, err := unified.ProvideUnifiedStorageClient(cfg, featureToggles, sqlStore, tracingService, registerer, authzClient, documentBuilderSupplier)
	if err != nil {
		return nil, err
	}
	apiserverService, err := apiserver.ProvideService(cfg, featureToggles, routeRegisterImpl, orgService, tracingService, serverLockService, sqlStore, kvStore, middlewareHandler, scopedPluginDatasourceProvider, plugincontextProvider, pluginstoreService, resourceClient)
	if err != nil {
		return nil, err
	}
	dashboardServiceImpl, err := service5.ProvideDashboardServiceImpl(cfg, dashboardsStore, dashboardFolderStoreImpl, featureToggles, folderPermissionsService, dashboardPermissionsService, accessControl, folderimplService, folderStoreImpl, registerer, apiserverService, userService, resourceClient, quotaService, orgService)
	if err != nil {
		return nil, err
	}
	pluginService := service5.ProvideDashboardPluginService(featureToggles, dashboardServiceImpl)
	service13 := service6.ProvideService(fileStoreManager, pluginService)
	pluginerrsStore := pluginerrs.ProvideStore(errorRegistry)
	repoManager, err := repo.ProvideService(pluginManagementCfg)
	if err != nil {
		return nil, err
	}
	pluginInstaller := manager3.ProvideInstaller(pluginManagementCfg, inMemory, loaderLoader, repoManager, serviceregistrationService)
	shortURLService := shorturlimpl.ProvideService(sqlStore)
	queryHistoryService := queryhistory.ProvideService(cfg, sqlStore, routeRegisterImpl, accessControl)
	dashboardService := service5.ProvideDashboardService(featureToggles, dashboardServiceImpl)
	dashverService := dashverimpl.ProvideService(cfg, sqlStore, dashboardService)
	dashboardSnapshotStore := database3.ProvideStore(sqlStore, cfg)
	serviceImpl := service7.ProvideService(dashboardSnapshotStore, secretsService, dashboardService)
	dBstore, err := store2.ProvideDBStore(cfg, featureToggles, sqlStore, folderimplService, dashboardService, accessControl, inProcBus)
	if err != nil {
		return nil, err
	}
	deleteExpiredService := image.ProvideDeleteExpiredService(dBstore)
	tempuserService := tempuserimpl.ProvideService(sqlStore, cfg)
	cleanupServiceImpl := annotationsimpl.ProvideCleanupService(sqlStore, cfg)
	cleanUpService := cleanup.ProvideService(cfg, serverLockService, shortURLService, sqlStore, queryHistoryService, dashverService, serviceImpl, deleteExpiredService, tempuserService, tracingService, cleanupServiceImpl, dashboardService)
	correlationsService, err := correlations.ProvideService(sqlStore, routeRegisterImpl, service12, accessControl, inProcBus, quotaService, cfg)
	if err != nil {
		return nil, err
	}
	mailer, err := notifications.ProvideSmtpService(cfg)
	if err != nil {
		return nil, err
	}
	notificationService, err := notifications.ProvideService(inProcBus, cfg, mailer, tempuserService)
	if err != nil {
		return nil, err
	}
	dashboardProvisioningService := service5.ProvideDashboardProvisioningService(featureToggles, dashboardServiceImpl)
	receiverPermissionsService, err := ossaccesscontrol.ProvideReceiverPermissionsService(cfg, featureToggles, routeRegisterImpl, sqlStore, accessControl, ossLicensingService, acimplService, teamService, userService, actionSetService)
	if err != nil {
		return nil, err
	}
	provisioningServiceImpl, err := provisioning.ProvideService(accessControl, cfg, sqlStore, pluginstoreService, dBstore, serviceService, notificationService, dashboardProvisioningService, service12, correlationsService, dashboardService, folderimplService, service11, searchService, quotaService, secretsService, orgService, receiverPermissionsService, tracingService)
	if err != nil {
		return nil, err
	}
	dataSourceProxyService := datasourceproxy.ProvideService(cacheServiceImpl, ossPluginRequestValidator, pluginstoreService, cfg, httpclientProvider, oauthtokenService, service12, tracingService, secretsService, featureToggles)
	starService := starimpl.ProvideService(sqlStore)
	searchSearchService := search2.ProvideService(cfg, sqlStore, starService, dashboardService)
	exprService := expr.ProvideService(cfg, middlewareHandler, plugincontextProvider, featureToggles, registerer, tracingService)
	queryServiceImpl := query.ProvideService(cfg, cacheServiceImpl, exprService, ossPluginRequestValidator, middlewareHandler, plugincontextProvider)
	repositoryImpl := annotationsimpl.ProvideService(sqlStore, cfg, featureToggles, tagimplService, tracingService, dBstore, dashboardService)
	grafanaLive, err := live.ProvideService(plugincontextProvider, cfg, routeRegisterImpl, pluginstoreService, middlewareHandler, cacheService, cacheServiceImpl, sqlStore, secretsService, usageStats, queryServiceImpl, featureToggles, accessControl, dashboardService, repositoryImpl, orgService)
	if err != nil {
		return nil, err
	}
	gateway := pushhttp.ProvideService(cfg, grafanaLive)
	authnimplService := authnimpl.ProvideService(cfg, tracingService, userAuthTokenService, usageStats, registerer, authinfoimplService)
	authnAuthenticator := authnimpl.ProvideAuthnServiceAuthenticateOnly(authnimplService)
	contexthandlerContextHandler := contexthandler.ProvideService(cfg, tracingService, authnAuthenticator, featureToggles)
	logger := loggermw.Provide(cfg, featureToggles)
	ngAlert := metrics2.ProvideService()
	alertNG, err := ngalert.ProvideService(cfg, featureToggles, cacheServiceImpl, service12, routeRegisterImpl, sqlStore, kvStore, exprService, dataSourceProxyService, quotaService, secretsService, notificationService, ngAlert, folderimplService, accessControl, dashboardService, renderingService, inProcBus, acimplService, repositoryImpl, pluginstoreService, tracingService, dBstore, httpclientProvider, receiverPermissionsService)
	if err != nil {
		return nil, err
	}
	libraryElementService := libraryelements.ProvideService(cfg, sqlStore, routeRegisterImpl, folderimplService, featureToggles, accessControl)
	libraryPanelService, err := librarypanels.ProvideService(cfg, sqlStore, routeRegisterImpl, libraryElementService, folderimplService)
	if err != nil {
		return nil, err
	}
	grafanaService, err := updatechecker.ProvideGrafanaService(cfg, tracingService)
	if err != nil {
		return nil, err
	}
	pluginsService, err := updatechecker.ProvidePluginsService(cfg, pluginstoreService, tracingService)
	if err != nil {
		return nil, err
	}
	ossSearchUserFilter := filters.ProvideOSSSearchUserFilter()
	ossService := searchusers.ProvideUsersService(cfg, ossSearchUserFilter, userService)
	serviceAccountsProxy, err := proxy.ProvideServiceAccountsProxy(cfg, accessControl, acimplService, featureToggles, serviceAccountPermissionsService, serviceAccountsService, routeRegisterImpl)
	if err != nil {
		return nil, err
	}
	pluginassetsService := pluginassets.ProvideService(pluginManagementCfg, pluginscdnService, signatureSignature, pluginstoreService)
	avatarCacheServer := avatar.ProvideAvatarCacheServer(cfg)
	prefService := prefimpl.ProvideService(sqlStore, cfg)
	csrfCSRF := csrf.ProvideCSRFFilter(cfg)
	noop := managedplugins.NewNoop()
	playlistService := playlistimpl.ProvideService(sqlStore, tracingService)
	secretsMigrator := migrator.ProvideSecretsMigrator(serviceService, secretsService, sqlStore, ossImpl, featureToggles)
	dataSourceSecretMigrationService := migrations2.ProvideDataSourceMigrationService(service12, kvStore, featureToggles)
	migrateToPluginService := migrations2.ProvideMigrateToPluginService(secretsKVStore, cfg, sqlStore, secretsService, kvStore, pluginstoreService)
	migrateFromPluginService := migrations2.ProvideMigrateFromPluginService(cfg, sqlStore, secretsService, pluginstoreService, kvStore)
	secretMigrationProviderImpl := migrations2.ProvideSecretMigrationProvider(cfg, serverLockService, dataSourceSecretMigrationService, migrateToPluginService, migrateFromPluginService)
	publicDashboardStoreImpl := database4.ProvideStore(sqlStore, cfg, featureToggles)
	publicDashboardServiceWrapperImpl := service8.ProvideServiceWrapper(publicDashboardStoreImpl)
	publicDashboardServiceImpl := service8.ProvideService(cfg, featureToggles, publicDashboardStoreImpl, queryServiceImpl, repositoryImpl, accessControl, publicDashboardServiceWrapperImpl, dashboardService, ossLicensingService)
	middleware := api2.ProvideMiddleware()
	apiApi := api2.ProvideApi(publicDashboardServiceImpl, routeRegisterImpl, accessControl, featureToggles, middleware, cfg, ossLicensingService)
	loginattemptimplService := loginattemptimpl.ProvideService(sqlStore, cfg, serverLockService)
	deletionService, err := orgimpl.ProvideDeletionService(sqlStore, cfg, dashboardService)
	if err != nil {
		return nil, err
	}
	authnService := authnimpl.ProvideAuthnService(authnimplService)
	navtreeService := navtreeimpl.ProvideService(cfg, accessControl, pluginstoreService, service11, starService, featureToggles, dashboardService, acimplService, kvStore, apikeyService, ossLicensingService, authnService)
	searchHTTPService := searchV2.ProvideSearchHTTPService(searchService)
	statsService := statsimpl.ProvideService(cfg, sqlStore, dashboardService, folderimplService, orgService)
	gatherer := metrics.ProvideGatherer()
	apiAPI := api3.ProvideApi(starService, dashboardService)
	anonUserLimitValidatorImpl := validator.ProvideAnonUserLimitValidator()
	anonDeviceService := anonimpl.ProvideAnonymousDeviceService(usageStats, authnService, sqlStore, cfg, orgService, serverLockService, accessControl, routeRegisterImpl, anonUserLimitValidatorImpl)
	signingkeysimplService, err := signingkeysimpl.ProvideEmbeddedSigningKeysService(sqlStore, secretsService, remoteCache, routeRegisterImpl)
	if err != nil {
		return nil, err
	}
	localSigner, err := idimpl.ProvideLocalSigner(signingkeysimplService)
	if err != nil {
		return nil, err
	}
	idimplService := idimpl.ProvideService(cfg, localSigner, remoteCache, authnService, registerer)
	verifier := userimpl.ProvideVerifier(cfg, userService, tempuserService, notificationService, idimplService)
	httpServer, err := api.ProvideHTTPServer(apiOpts, cfg, routeRegisterImpl, inProcBus, renderingService, ossLicensingService, hooksService, cacheService, sqlStore, ossPluginRequestValidator, pluginstoreService, service13, pluginstoreService, middlewareHandler, pluginerrsStore, pluginInstaller, ossImpl, cacheServiceImpl, userAuthTokenService, cleanUpService, shortURLService, queryHistoryService, correlationsService, remoteCache, provisioningServiceImpl, accessControl, dataSourceProxyService, searchSearchService, grafanaLive, gateway, plugincontextProvider, contexthandlerContextHandler, logger, featureToggles, alertNG, libraryPanelService, libraryElementService, quotaService, socialService, tracingService, serviceService, grafanaService, pluginsService, ossService, service12, queryServiceImpl, filestoreService, serviceAccountsProxy, pluginassetsService, authinfoimplService, storageService, notificationService, dashboardService, dashboardProvisioningService, folderimplService, ossProvider, serviceImpl, service11, avatarCacheServer, prefService, folderPermissionsService, dashboardPermissionsService, dashverService, starService, csrfCSRF, noop, playlistService, apikeyService, kvStore, secretsMigrator, pluginstoreService, secretsService, secretMigrationProviderImpl, secretsKVStore, apiApi, userService, tempuserService, loginattemptimplService, orgService, deletionService, teamService, acimplService, navtreeService, repositoryImpl, tagimplService, searchHTTPService, oauthtokenService, statsService, authnService, pluginscdnService, gatherer, apiAPI, registerer, apiserverService, anonDeviceService, verifier)
	if err != nil {
		return nil, err
	}
	validatorService, err := validator2.ProvideService(pluginstoreService)
	if err != nil {
		return nil, err
	}
	statscollectorService := statscollector.ProvideService(usageStats, validatorService, statsService, cfg, sqlStore, socialService, pluginstoreService, featureManager, service12, httpclientProvider)
	internalMetricsService, err := metrics.ProvideService(cfg, registerer, gatherer)
	if err != nil {
		return nil, err
	}
	supportbundlesimplService, err := supportbundlesimpl.ProvideService(accessControl, acimplService, bundleregistryService, cfg, featureToggles, httpServer, kvStore, service11, pluginstoreService, routeRegisterImpl, ossImpl, sqlStore, usageStats, tracingService)
	if err != nil {
		return nil, err
	}
	metricService, err := metric.ProvideService(publicDashboardStoreImpl, registerer)
	if err != nil {
		return nil, err
	}
	pluginexternalService, err := pluginexternal.ProvideService(cfg, pluginstoreService)
	if err != nil {
		return nil, err
	}
	plugininstallerService, err := plugininstaller.ProvideService(cfg, pluginstoreService, pluginInstaller, registerer, repoManager, featureToggles)
	if err != nil {
		return nil, err
	}
	playlistAppProvider := playlist.RegisterApp(playlistService, cfg, featureToggles)
	investigationAppProvider := investigation.RegisterApp(cfg)
	appregistryService, err := appregistry.ProvideRegistryServiceSink(apiserverService, apiserverService, featureToggles, playlistAppProvider, investigationAppProvider)
	if err != nil {
		return nil, err
	}
	guardianProvider := guardian2.ProvideService(cfg, accessControl, dashboardService, teamService)
	importDashboardService := service9.ProvideService(routeRegisterImpl, quotaService, service13, pluginstoreService, libraryPanelService, dashboardService, accessControl, folderimplService)
	dashboardUpdater := service6.ProvideDashboardUpdater(inProcBus, pluginstoreService, service13, importDashboardService, service11, pluginService, dashboardService)
	sanitizerProvider := sanitizer.ProvideService(renderingService)
	healthService, err := grpcserver.ProvideHealthService(cfg, grpcserverProvider)
	if err != nil {
		return nil, err
	}
	reflectionService, err := grpcserver.ProvideReflectionService(cfg, grpcserverProvider)
	if err != nil {
		return nil, err
	}
	ossGroups := ldap.ProvideGroupsService()
	identitySynchronizer := authnimpl.ProvideIdentitySynchronizer(authnimplService)
	ldapImpl := service10.ProvideService(cfg, featureToggles, ssosettingsimplService)
	apiService := api4.ProvideService(cfg, routeRegisterImpl, accessControl, userService, authinfoimplService, ossGroups, identitySynchronizer, orgService, ldapImpl, userAuthTokenService, bundleregistryService)
	dashboardsAPIBuilder := dashboard.RegisterAPIService(featureToggles, apiserverService, dashboardProvisioningService)
	v0alpha1DashboardsAPIBuilder := v0alpha1.RegisterAPIService(cfg, featureToggles, apiserverService, dashboardService, dashboardProvisioningService, accessControl, provisioningServiceImpl, dashboardsStore, registerer, sqlStore, tracingService, resourceClient)
	v1alpha1DashboardsAPIBuilder := v1alpha1.RegisterAPIService(cfg, featureToggles, apiserverService, dashboardService, dashboardProvisioningService, accessControl, provisioningServiceImpl, dashboardsStore, registerer, sqlStore, tracingService, resourceClient)
	v2alpha1DashboardsAPIBuilder := v2alpha1.RegisterAPIService(cfg, featureToggles, apiserverService, dashboardService, dashboardProvisioningService, accessControl, provisioningServiceImpl, dashboardsStore, registerer, sqlStore, tracingService, resourceClient)
	snapshotsAPIBuilder := dashboardsnapshot.RegisterAPIService(serviceImpl, apiserverService, cfg, featureToggles, sqlStore, registerer)
	featureFlagAPIBuilder := featuretoggle.RegisterAPIService(featureManager, accessControl, apiserverService, cfg, registerer)
	dataSourceAPIBuilder, err := datasource.RegisterAPIService(featureToggles, apiserverService, middlewareHandler, scopedPluginDatasourceProvider, plugincontextProvider, pluginstoreService, accessControl, registerer)
	if err != nil {
		return nil, err
	}
	folderAPIBuilder := folders.RegisterAPIService(cfg, featureToggles, apiserverService, folderimplService, folderPermissionsService, accessControl, registerer, resourceClient)
	peakQAPIBuilder := peakq.RegisterAPIService(featureToggles, apiserverService, registerer)
	identityAccessManagementAPIBuilder, err := iam.RegisterAPIService(apiserverService, ssosettingsimplService, sqlStore, accessControl)
	if err != nil {
		return nil, err
	}
	scopeAPIBuilder := scope.RegisterAPIService(featureToggles, apiserverService, registerer)
	legacyDataSourceLookup := service4.ProvideLegacyDataSourceLookup(service12)
	queryAPIBuilder, err := query2.RegisterAPIService(featureToggles, apiserverService, service12, pluginstoreService, accessControl, middlewareHandler, plugincontextProvider, registerer, tracingService, legacyDataSourceLookup)
	if err != nil {
		return nil, err
	}
	notificationsAPIBuilder := notifications2.RegisterAPIService(featureToggles, apiserverService, cfg, alertNG)
	userStorageAPIBuilder := userstorage.RegisterAPIService(featureToggles, apiserverService, registerer)
	apiregistryService := apiregistry.ProvideRegistryServiceSink(dashboardsAPIBuilder, v0alpha1DashboardsAPIBuilder, v1alpha1DashboardsAPIBuilder, v2alpha1DashboardsAPIBuilder, snapshotsAPIBuilder, featureFlagAPIBuilder, dataSourceAPIBuilder, folderAPIBuilder, peakQAPIBuilder, identityAccessManagementAPIBuilder, scopeAPIBuilder, queryAPIBuilder, notificationsAPIBuilder, userStorageAPIBuilder)
	teamPermissionsService, err := ossaccesscontrol.ProvideTeamPermissions(cfg, featureToggles, routeRegisterImpl, sqlStore, accessControl, ossLicensingService, acimplService, teamService, userService, actionSetService)
	if err != nil {
		return nil, err
	}
	teamAPI := teamapi.ProvideTeamAPI(routeRegisterImpl, teamService, acimplService, accessControl, teamPermissionsService, userService, ossLicensingService, cfg, prefService, dashboardService)
	cloudmigrationService, err := cloudmigrationimpl.ProvideService(cfg, httpclientProvider, featureToggles, sqlStore, service12, secretsKVStore, secretsService, routeRegisterImpl, registerer, tracingService, dashboardService, folderimplService, pluginstoreService, service11, accessControl, acimplService, kvStore, libraryElementService, alertNG)
	if err != nil {
		return nil, err
	}
	authService, err := jwt.ProvideService(cfg, remoteCache)
	if err != nil {
		return nil, err
	}
	ossUserProtectionImpl := authinfoimpl.ProvideOSSUserProtectionService()
	registration := authnimpl.ProvideRegistration(cfg, authnService, orgService, userAuthTokenService, acimplService, permissionRegistry, apikeyService, userService, authService, ossUserProtectionImpl, loginattemptimplService, quotaService, authinfoimplService, renderingService, featureToggles, oauthtokenService, socialService, remoteCache, ldapImpl, ossImpl, tracingService, tempuserService, notificationService)
	backgroundServiceRegistry := backgroundsvcs.ProvideBackgroundServiceRegistry(httpServer, alertNG, cleanUpService, grafanaLive, gateway, notificationService, pluginstoreService, renderingService, userAuthTokenService, tracingService, provisioningServiceImpl, usageStats, statscollectorService, grafanaService, pluginsService, internalMetricsService, secretsService, remoteCache, storageService, searchService, entityEventsService, serviceAccountsService, grpcserverProvider, secretMigrationProviderImpl, loginattemptimplService, supportbundlesimplService, metricService, keyRetriever, angulardetectorsproviderDynamic, apiserverService, anonDeviceService, ssosettingsimplService, pluginexternalService, plugininstallerService, acimplService, appregistryService, serviceImpl, serviceAccountsProxy, guardianProvider, dashboardUpdater, sanitizerProvider, healthService, authzClient, reflectionService, apiService, apiregistryService, idimplService, teamAPI, ssosettingsimplService, cloudmigrationService, registration)
	usageStatsProvidersRegistry := usagestatssvcs.ProvideUsageStatsProvidersRegistry(acimplService, userService)
	server, err := New(opts, cfg, httpServer, acimplService, provisioningServiceImpl, backgroundServiceRegistry, usageStatsProvidersRegistry, statscollectorService, registerer)
	if err != nil {
		return nil, err
	}
	return server, nil
}

func InitializeForTest(t sqlutil.ITestDB, cfg *setting.Cfg, opts Options, apiOpts api.ServerOptions) (*TestEnv, error) {
	routeRegisterImpl := routing.ProvideRegister()
	tracingConfig, err := tracing.ProvideTracingConfig(cfg)
	if err != nil {
		return nil, err
	}
	tracingService, err := tracing.ProvideService(tracingConfig)
	if err != nil {
		return nil, err
	}
	inProcBus := bus.ProvideBus(tracingService)
	featureManager, err := featuremgmt.ProvideManagerService(cfg)
	if err != nil {
		return nil, err
	}
	featureToggles := featuremgmt.ProvideToggles(featureManager)
	ossMigrations := migrations.ProvideOSSMigrations(featureToggles)
	sqlStore, err := sqlstore.ProvideServiceForTests(t, cfg, featureToggles, ossMigrations)
	if err != nil {
		return nil, err
	}
	kvStore := kvstore.ProvideService(sqlStore)
	accessControl := acimpl.ProvideAccessControl(featureToggles)
	bundleregistryService := bundleregistry.ProvideService()
	usageStats, err := service.ProvideService(cfg, kvStore, routeRegisterImpl, tracingService, accessControl, bundleregistryService)
	if err != nil {
		return nil, err
	}
	secretsStoreImpl := database.ProvideSecretsStore(sqlStore)
	providerProvider := provider.ProvideEncryptionProvider()
	serviceService, err := service2.ProvideEncryptionService(tracingService, providerProvider, usageStats, cfg)
	if err != nil {
		return nil, err
	}
	osskmsprovidersService := osskmsproviders.ProvideService(serviceService, cfg, featureToggles)
	secretsService, err := manager.ProvideSecretsService(tracingService, secretsStoreImpl, osskmsprovidersService, serviceService, cfg, featureToggles, usageStats)
	if err != nil {
		return nil, err
	}
	remoteCache, err := remotecache.ProvideService(cfg, sqlStore, usageStats, secretsService)
	if err != nil {
		return nil, err
	}
	ossImpl := setting.ProvideProvider(cfg)
	pluginManagementCfg, err := pluginconfig.ProvidePluginManagementConfig(cfg, ossImpl, featureToggles)
	if err != nil {
		return nil, err
	}
	pluginInstanceCfg, err := pluginconfig.ProvidePluginInstanceConfig(cfg, ossImpl, featureToggles)
	if err != nil {
		return nil, err
	}
	hooksService := hooks.ProvideService()
	ossLicensingService := licensing.ProvideService(cfg, hooksService)
	licensingService := licensing2.ProvideLicensing(cfg, ossLicensingService)
	envVarsProvider := pluginconfig.NewEnvVarsProvider(pluginInstanceCfg, licensingService)
	inMemory := registry.ProvideService()
	rendererManager, err := renderer.ProvideService(pluginManagementCfg, envVarsProvider, inMemory, tracingService)
	if err != nil {
		return nil, err
	}
	renderingService, err := rendering.ProvideService(cfg, featureToggles, remoteCache, rendererManager)
	if err != nil {
		return nil, err
	}
	cacheService := localcache.ProvideService()
	ossPluginRequestValidator := validations.ProvideValidator()
	sourcesService := sources.ProvideService(cfg)
	local := finder.ProvideLocalFinder(pluginManagementCfg)
	discovery := pipeline.ProvideDiscoveryStage(pluginManagementCfg, local, inMemory)
	keystoreService := keystore.ProvideService(kvStore)
	keyRetriever := dynamic.ProvideService(cfg, keystoreService)
	keyretrieverService := keyretriever.ProvideService(keyRetriever)
	signatureSignature := signature.ProvideService(pluginManagementCfg, keyretrieverService)
	pluginscdnService := pluginscdn.ProvideService(pluginManagementCfg)
	assetpathService := assetpath.ProvideService(pluginManagementCfg, pluginscdnService)
	bootstrap := pipeline.ProvideBootstrapStage(pluginManagementCfg, signatureSignature, assetpathService)
	unsignedPluginAuthorizer := signature.ProvideOSSAuthorizer(pluginManagementCfg)
	validation := signature.ProvideValidatorService(unsignedPluginAuthorizer)
	angularpatternsstoreService := angularpatternsstore.ProvideService(kvStore)
	angulardetectorsproviderDynamic, err := angulardetectorsprovider.ProvideDynamic(cfg, angularpatternsstoreService)
	if err != nil {
		return nil, err
	}
	angularinspectorService, err := angularinspector.ProvideService(angulardetectorsproviderDynamic)
	if err != nil {
		return nil, err
	}
	validate := pipeline.ProvideValidationStage(pluginManagementCfg, validation, angularinspectorService)
	httpclientProvider := httpclientprovider.New(cfg, ossPluginRequestValidator, tracingService)
	azuremonitorService := azuremonitor.ProvideService(httpclientProvider)
	cloudWatchService := cloudwatch.ProvideService(httpclientProvider)
	cloudmonitoringService := cloudmonitoring.ProvideService(httpclientProvider)
	elasticsearchService := elasticsearch.ProvideService(httpclientProvider)
	graphiteService := graphite.ProvideService(httpclientProvider, tracingService)
	influxdbService := influxdb.ProvideService(httpclientProvider, featureToggles)
	lokiService := loki.ProvideService(httpclientProvider, tracingService)
	opentsdbService := opentsdb.ProvideService(httpclientProvider)
	prometheusService := prometheus.ProvideService(httpclientProvider)
	tempoService := tempo.ProvideService(httpclientProvider)
	testdatasourceService := testdatasource.ProvideService()
	postgresService := postgres.ProvideService(cfg)
	mysqlService := mysql.ProvideService()
	mssqlService := mssql.ProvideService(cfg)
	entityEventsService := store.ProvideEntityEventsService(cfg, sqlStore, featureToggles)
	quotaService := quotaimpl.ProvideService(sqlStore, cfg)
	orgService, err := orgimpl.ProvideService(sqlStore, cfg, quotaService)
	if err != nil {
		return nil, err
	}
	teamService, err := teamimpl.ProvideService(sqlStore, cfg, tracingService)
	if err != nil {
		return nil, err
	}
	userService, err := userimpl.ProvideService(sqlStore, orgService, cfg, teamService, cacheService, tracingService, quotaService, bundleregistryService)
	if err != nil {
		return nil, err
	}
	actionSetService := resourcepermissions.NewActionSetService(featureToggles)
	client, err := authz.ProvideZanzana(cfg, sqlStore, featureToggles)
	if err != nil {
		return nil, err
	}
	permissionRegistry := permreg.ProvidePermissionRegistry()
	serverLockService := serverlock.ProvideService(sqlStore, tracingService)
	folderStoreImpl := folderimpl.ProvideStore(sqlStore)
	tagimplService := tagimpl.ProvideService(sqlStore)
	dashboardsStore, err := database2.ProvideDashboardStore(sqlStore, cfg, featureToggles, tagimplService)
	if err != nil {
		return nil, err
	}
	dashboardFolderStoreImpl := folderimpl.ProvideDashboardFolderStore(sqlStore)
	registerer := metrics.ProvideRegistererForTest()
	folderimplService := folderimpl.ProvideService(folderStoreImpl, accessControl, inProcBus, dashboardsStore, dashboardFolderStoreImpl, sqlStore, featureToggles, bundleregistryService, cfg, registerer, tracingService)
	acimplService, err := acimpl.ProvideService(cfg, sqlStore, routeRegisterImpl, cacheService, accessControl, userService, actionSetService, featureToggles, tracingService, client, permissionRegistry, serverLockService, folderimplService)
	if err != nil {
		return nil, err
	}
	searchService := searchV2.ProvideService(cfg, sqlStore, entityEventsService, acimplService, tracingService, featureToggles, orgService, userService, folderimplService)
	systemUsers := store.ProvideSystemUsersService()
	storageService, err := store.ProvideService(sqlStore, featureToggles, cfg, quotaService, systemUsers)
	if err != nil {
		return nil, err
	}
	grafanadsService := grafanads.ProvideService(searchService, storageService, featureToggles)
	pyroscopeService := pyroscope.ProvideService(httpclientProvider)
	parcaService := parca.ProvideService(httpclientProvider)
	zipkinService := zipkin.ProvideService(httpclientProvider)
	corepluginRegistry := coreplugin.ProvideCoreRegistry(tracingService, azuremonitorService, cloudWatchService, cloudmonitoringService, elasticsearchService, graphiteService, influxdbService, lokiService, opentsdbService, prometheusService, tempoService, testdatasourceService, postgresService, mysqlService, mssqlService, grafanadsService, pyroscopeService, parcaService, zipkinService)
	providerService := provider2.ProvideService(corepluginRegistry)
	processService := process.ProvideService()
	apikeyService, err := apikeyimpl.ProvideService(sqlStore, cfg, quotaService)
	if err != nil {
		return nil, err
	}
	retrieverService := retriever.ProvideService(sqlStore, apikeyService, kvStore, userService, orgService)
	serviceAccountPermissionsService, err := ossaccesscontrol.ProvideServiceAccountPermissions(cfg, featureToggles, routeRegisterImpl, sqlStore, accessControl, ossLicensingService, retrieverService, acimplService, teamService, userService, actionSetService)
	if err != nil {
		return nil, err
	}
	serviceAccountsService, err := manager2.ProvideServiceAccountsService(cfg, usageStats, sqlStore, apikeyService, kvStore, userService, orgService, acimplService, serviceAccountPermissionsService)
	if err != nil {
		return nil, err
	}
	extSvcAccountsService := extsvcaccounts.ProvideExtSvcAccountsService(acimplService, cfg, inProcBus, sqlStore, featureToggles, registerer, serviceAccountsService, secretsService, tracingService)
	registryRegistry := registry2.ProvideExtSvcRegistry(cfg, extSvcAccountsService, serverLockService, featureToggles)
	service11 := service3.ProvideService(sqlStore, secretsService)
	serviceregistrationService := serviceregistration.ProvideService(cfg, featureToggles, registryRegistry, service11)
	initialize := pipeline.ProvideInitializationStage(pluginManagementCfg, inMemory, providerService, processService, serviceregistrationService, acimplService, actionSetService, envVarsProvider, tracingService)
	terminate, err := pipeline.ProvideTerminationStage(pluginManagementCfg, inMemory, processService)
	if err != nil {
		return nil, err
	}
	errorRegistry := pluginerrs.ProvideErrorTracker()
	loaderLoader := loader.ProvideService(discovery, bootstrap, validate, initialize, terminate, errorRegistry)
	pluginstoreService, err := pluginstore.ProvideService(inMemory, sourcesService, loaderLoader)
	if err != nil {
		return nil, err
	}
	filestoreService := filestore.ProvideService(inMemory)
	fileStoreManager := dashboards.ProvideFileStoreManager(pluginstoreService, filestoreService)
	folderPermissionsService, err := ossaccesscontrol.ProvideFolderPermissions(cfg, featureToggles, routeRegisterImpl, sqlStore, accessControl, ossLicensingService, dashboardsStore, folderimplService, acimplService, teamService, userService, actionSetService)
	if err != nil {
		return nil, err
	}
	dashboardPermissionsService, err := ossaccesscontrol.ProvideDashboardPermissions(cfg, featureToggles, routeRegisterImpl, sqlStore, accessControl, ossLicensingService, dashboardsStore, folderimplService, acimplService, teamService, userService, actionSetService)
	if err != nil {
		return nil, err
	}
	oauthtokentestService := oauthtokentest.ProvideService()
	ossCachingService := caching.ProvideCachingService()
	middlewareHandler, err := pluginsintegration.ProvideClientWithMiddlewares(cfg, inMemory, oauthtokentestService, tracingService, ossCachingService, featureToggles, registerer)
	if err != nil {
		return nil, err
	}
	secretsKVStore, err := kvstore2.ProvideService(sqlStore, secretsService, pluginstoreService, kvStore, featureToggles, cfg)
	if err != nil {
		return nil, err
	}
	datasourcePermissionsService := ossaccesscontrol.ProvideDatasourcePermissionsService(cfg, featureToggles, sqlStore)
	requestConfigProvider := pluginconfig.NewRequestConfigProvider(pluginInstanceCfg)
	baseProvider := plugincontext.ProvideBaseService(cfg, requestConfigProvider)
	service12, err := service4.ProvideService(sqlStore, secretsService, secretsKVStore, cfg, featureToggles, accessControl, datasourcePermissionsService, quotaService, pluginstoreService, middlewareHandler, baseProvider)
	if err != nil {
		return nil, err
	}
	ossProvider := guardian.ProvideGuardian()
	cacheServiceImpl := service4.ProvideCacheService(cacheService, sqlStore, ossProvider)
	plugincontextProvider := plugincontext.ProvideService(cfg, cacheService, pluginstoreService, cacheServiceImpl, service12, service11, requestConfigProvider)
	scopedPluginDatasourceProvider := datasource.ProvideDefaultPluginConfigs(service12, cacheServiceImpl, plugincontextProvider)
	contextHandler := grpccontext.ProvideContextHandler(tracingService)
	authenticator := interceptors.ProvideAuthenticator(apikeyService, userService, acimplService, contextHandler)
	grpcserverProvider, err := grpcserver.ProvideService(cfg, featureToggles, authenticator, tracingService, registerer)
	if err != nil {
		return nil, err
	}
	authzClient, err := authz.ProvideAuthZClient(cfg, featureToggles, grpcserverProvider, tracingService, sqlStore)
	if err != nil {
		return nil, err
	}
	ossDashboardStats := search.ProvideDashboardStats()
	documentBuilderSupplier := search.ProvideDocumentBuilders(sqlStore, ossDashboardStats)
	resourceClient, err := unified.ProvideUnifiedStorageClient(cfg, featureToggles, sqlStore, tracingService, registerer, authzClient, documentBuilderSupplier)
	if err != nil {
		return nil, err
	}
	apiserverService, err := apiserver.ProvideService(cfg, featureToggles, routeRegisterImpl, orgService, tracingService, serverLockService, sqlStore, kvStore, middlewareHandler, scopedPluginDatasourceProvider, plugincontextProvider, pluginstoreService, resourceClient)
	if err != nil {
		return nil, err
	}
	dashboardServiceImpl, err := service5.ProvideDashboardServiceImpl(cfg, dashboardsStore, dashboardFolderStoreImpl, featureToggles, folderPermissionsService, dashboardPermissionsService, accessControl, folderimplService, folderStoreImpl, registerer, apiserverService, userService, resourceClient, quotaService, orgService)
	if err != nil {
		return nil, err
	}
	pluginService := service5.ProvideDashboardPluginService(featureToggles, dashboardServiceImpl)
	service13 := service6.ProvideService(fileStoreManager, pluginService)
	pluginerrsStore := pluginerrs.ProvideStore(errorRegistry)
	repoManager, err := repo.ProvideService(pluginManagementCfg)
	if err != nil {
		return nil, err
	}
	pluginInstaller := manager3.ProvideInstaller(pluginManagementCfg, inMemory, loaderLoader, repoManager, serviceregistrationService)
	userAuthTokenService, err := authimpl.ProvideUserAuthTokenService(sqlStore, serverLockService, quotaService, secretsService, cfg, tracingService)
	if err != nil {
		return nil, err
	}
	shortURLService := shorturlimpl.ProvideService(sqlStore)
	queryHistoryService := queryhistory.ProvideService(cfg, sqlStore, routeRegisterImpl, accessControl)
	dashboardService := service5.ProvideDashboardService(featureToggles, dashboardServiceImpl)
	dashverService := dashverimpl.ProvideService(cfg, sqlStore, dashboardService)
	dashboardSnapshotStore := database3.ProvideStore(sqlStore, cfg)
	serviceImpl := service7.ProvideService(dashboardSnapshotStore, secretsService, dashboardService)
	dBstore, err := store2.ProvideDBStore(cfg, featureToggles, sqlStore, folderimplService, dashboardService, accessControl, inProcBus)
	if err != nil {
		return nil, err
	}
	deleteExpiredService := image.ProvideDeleteExpiredService(dBstore)
	tempuserService := tempuserimpl.ProvideService(sqlStore, cfg)
	cleanupServiceImpl := annotationsimpl.ProvideCleanupService(sqlStore, cfg)
	cleanUpService := cleanup.ProvideService(cfg, serverLockService, shortURLService, sqlStore, queryHistoryService, dashverService, serviceImpl, deleteExpiredService, tempuserService, tracingService, cleanupServiceImpl, dashboardService)
	correlationsService, err := correlations.ProvideService(sqlStore, routeRegisterImpl, service12, accessControl, inProcBus, quotaService, cfg)
	if err != nil {
		return nil, err
	}
	mailer, err := notifications.ProvideSmtpService(cfg)
	if err != nil {
		return nil, err
	}
	notificationService, err := notifications.ProvideService(inProcBus, cfg, mailer, tempuserService)
	if err != nil {
		return nil, err
	}
	dashboardProvisioningService := service5.ProvideDashboardProvisioningService(featureToggles, dashboardServiceImpl)
	receiverPermissionsService, err := ossaccesscontrol.ProvideReceiverPermissionsService(cfg, featureToggles, routeRegisterImpl, sqlStore, accessControl, ossLicensingService, acimplService, teamService, userService, actionSetService)
	if err != nil {
		return nil, err
	}
	provisioningServiceImpl, err := provisioning.ProvideService(accessControl, cfg, sqlStore, pluginstoreService, dBstore, serviceService, notificationService, dashboardProvisioningService, service12, correlationsService, dashboardService, folderimplService, service11, searchService, quotaService, secretsService, orgService, receiverPermissionsService, tracingService)
	if err != nil {
		return nil, err
	}
	orgRoleMapper := connectors.ProvideOrgRoleMapper(cfg, orgService)
	ssosettingsimplService := ssosettingsimpl.ProvideService(cfg, sqlStore, accessControl, routeRegisterImpl, featureToggles, secretsService, usageStats, registerer, ossImpl, ossLicensingService)
	socialService := socialimpl.ProvideService(cfg, featureToggles, usageStats, bundleregistryService, remoteCache, orgRoleMapper, ssosettingsimplService)
	loginStore := authinfoimpl.ProvideStore(sqlStore, secretsService)
	authinfoimplService := authinfoimpl.ProvideService(loginStore, remoteCache, secretsService)
	oauthtokenService := oauthtoken.ProvideService(socialService, authinfoimplService, cfg, registerer, serverLockService, tracingService, userAuthTokenService, featureToggles)
	dataSourceProxyService := datasourceproxy.ProvideService(cacheServiceImpl, ossPluginRequestValidator, pluginstoreService, cfg, httpclientProvider, oauthtokenService, service12, tracingService, secretsService, featureToggles)
	starService := starimpl.ProvideService(sqlStore)
	searchSearchService := search2.ProvideService(cfg, sqlStore, starService, dashboardService)
	exprService := expr.ProvideService(cfg, middlewareHandler, plugincontextProvider, featureToggles, registerer, tracingService)
	queryServiceImpl := query.ProvideService(cfg, cacheServiceImpl, exprService, ossPluginRequestValidator, middlewareHandler, plugincontextProvider)
	repositoryImpl := annotationsimpl.ProvideService(sqlStore, cfg, featureToggles, tagimplService, tracingService, dBstore, dashboardService)
	grafanaLive, err := live.ProvideService(plugincontextProvider, cfg, routeRegisterImpl, pluginstoreService, middlewareHandler, cacheService, cacheServiceImpl, sqlStore, secretsService, usageStats, queryServiceImpl, featureToggles, accessControl, dashboardService, repositoryImpl, orgService)
	if err != nil {
		return nil, err
	}
	gateway := pushhttp.ProvideService(cfg, grafanaLive)
	authnimplService := authnimpl.ProvideService(cfg, tracingService, userAuthTokenService, usageStats, registerer, authinfoimplService)
	authnAuthenticator := authnimpl.ProvideAuthnServiceAuthenticateOnly(authnimplService)
	contexthandlerContextHandler := contexthandler.ProvideService(cfg, tracingService, authnAuthenticator, featureToggles)
	logger := loggermw.Provide(cfg, featureToggles)
	notificationServiceMock := notifications.MockNotificationService()
	ngAlert := metrics2.ProvideServiceForTest()
	alertNG, err := ngalert.ProvideService(cfg, featureToggles, cacheServiceImpl, service12, routeRegisterImpl, sqlStore, kvStore, exprService, dataSourceProxyService, quotaService, secretsService, notificationServiceMock, ngAlert, folderimplService, accessControl, dashboardService, renderingService, inProcBus, acimplService, repositoryImpl, pluginstoreService, tracingService, dBstore, httpclientProvider, receiverPermissionsService)
	if err != nil {
		return nil, err
	}
	libraryElementService := libraryelements.ProvideService(cfg, sqlStore, routeRegisterImpl, folderimplService, featureToggles, accessControl)
	libraryPanelService, err := librarypanels.ProvideService(cfg, sqlStore, routeRegisterImpl, libraryElementService, folderimplService)
	if err != nil {
		return nil, err
	}
	grafanaService, err := updatechecker.ProvideGrafanaService(cfg, tracingService)
	if err != nil {
		return nil, err
	}
	pluginsService, err := updatechecker.ProvidePluginsService(cfg, pluginstoreService, tracingService)
	if err != nil {
		return nil, err
	}
	ossSearchUserFilter := filters.ProvideOSSSearchUserFilter()
	ossService := searchusers.ProvideUsersService(cfg, ossSearchUserFilter, userService)
	serviceAccountsProxy, err := proxy.ProvideServiceAccountsProxy(cfg, accessControl, acimplService, featureToggles, serviceAccountPermissionsService, serviceAccountsService, routeRegisterImpl)
	if err != nil {
		return nil, err
	}
	pluginassetsService := pluginassets.ProvideService(pluginManagementCfg, pluginscdnService, signatureSignature, pluginstoreService)
	avatarCacheServer := avatar.ProvideAvatarCacheServer(cfg)
	prefService := prefimpl.ProvideService(sqlStore, cfg)
	csrfCSRF := csrf.ProvideCSRFFilter(cfg)
	noop := managedplugins.NewNoop()
	playlistService := playlistimpl.ProvideService(sqlStore, tracingService)
	secretsMigrator := migrator.ProvideSecretsMigrator(serviceService, secretsService, sqlStore, ossImpl, featureToggles)
	dataSourceSecretMigrationService := migrations2.ProvideDataSourceMigrationService(service12, kvStore, featureToggles)
	migrateToPluginService := migrations2.ProvideMigrateToPluginService(secretsKVStore, cfg, sqlStore, secretsService, kvStore, pluginstoreService)
	migrateFromPluginService := migrations2.ProvideMigrateFromPluginService(cfg, sqlStore, secretsService, pluginstoreService, kvStore)
	secretMigrationProviderImpl := migrations2.ProvideSecretMigrationProvider(cfg, serverLockService, dataSourceSecretMigrationService, migrateToPluginService, migrateFromPluginService)
	publicDashboardStoreImpl := database4.ProvideStore(sqlStore, cfg, featureToggles)
	publicDashboardServiceWrapperImpl := service8.ProvideServiceWrapper(publicDashboardStoreImpl)
	publicDashboardServiceImpl := service8.ProvideService(cfg, featureToggles, publicDashboardStoreImpl, queryServiceImpl, repositoryImpl, accessControl, publicDashboardServiceWrapperImpl, dashboardService, ossLicensingService)
	middleware := api2.ProvideMiddleware()
	apiApi := api2.ProvideApi(publicDashboardServiceImpl, routeRegisterImpl, accessControl, featureToggles, middleware, cfg, ossLicensingService)
	loginattemptimplService := loginattemptimpl.ProvideService(sqlStore, cfg, serverLockService)
	deletionService, err := orgimpl.ProvideDeletionService(sqlStore, cfg, dashboardService)
	if err != nil {
		return nil, err
	}
	authnService := authnimpl.ProvideAuthnService(authnimplService)
	navtreeService := navtreeimpl.ProvideService(cfg, accessControl, pluginstoreService, service11, starService, featureToggles, dashboardService, acimplService, kvStore, apikeyService, ossLicensingService, authnService)
	searchHTTPService := searchV2.ProvideSearchHTTPService(searchService)
	statsService := statsimpl.ProvideService(cfg, sqlStore, dashboardService, folderimplService, orgService)
	gatherer := metrics.ProvideGathererForTest(registerer)
	apiAPI := api3.ProvideApi(starService, dashboardService)
	anonUserLimitValidatorImpl := validator.ProvideAnonUserLimitValidator()
	anonDeviceService := anonimpl.ProvideAnonymousDeviceService(usageStats, authnService, sqlStore, cfg, orgService, serverLockService, accessControl, routeRegisterImpl, anonUserLimitValidatorImpl)
	signingkeysimplService, err := signingkeysimpl.ProvideEmbeddedSigningKeysService(sqlStore, secretsService, remoteCache, routeRegisterImpl)
	if err != nil {
		return nil, err
	}
	localSigner, err := idimpl.ProvideLocalSigner(signingkeysimplService)
	if err != nil {
		return nil, err
	}
	idimplService := idimpl.ProvideService(cfg, localSigner, remoteCache, authnService, registerer)
	verifier := userimpl.ProvideVerifier(cfg, userService, tempuserService, notificationServiceMock, idimplService)
	httpServer, err := api.ProvideHTTPServer(apiOpts, cfg, routeRegisterImpl, inProcBus, renderingService, ossLicensingService, hooksService, cacheService, sqlStore, ossPluginRequestValidator, pluginstoreService, service13, pluginstoreService, middlewareHandler, pluginerrsStore, pluginInstaller, ossImpl, cacheServiceImpl, userAuthTokenService, cleanUpService, shortURLService, queryHistoryService, correlationsService, remoteCache, provisioningServiceImpl, accessControl, dataSourceProxyService, searchSearchService, grafanaLive, gateway, plugincontextProvider, contexthandlerContextHandler, logger, featureToggles, alertNG, libraryPanelService, libraryElementService, quotaService, socialService, tracingService, serviceService, grafanaService, pluginsService, ossService, service12, queryServiceImpl, filestoreService, serviceAccountsProxy, pluginassetsService, authinfoimplService, storageService, notificationServiceMock, dashboardService, dashboardProvisioningService, folderimplService, ossProvider, serviceImpl, service11, avatarCacheServer, prefService, folderPermissionsService, dashboardPermissionsService, dashverService, starService, csrfCSRF, noop, playlistService, apikeyService, kvStore, secretsMigrator, pluginstoreService, secretsService, secretMigrationProviderImpl, secretsKVStore, apiApi, userService, tempuserService, loginattemptimplService, orgService, deletionService, teamService, acimplService, navtreeService, repositoryImpl, tagimplService, searchHTTPService, oauthtokentestService, statsService, authnService, pluginscdnService, gatherer, apiAPI, registerer, apiserverService, anonDeviceService, verifier)
	if err != nil {
		return nil, err
	}
	validatorService, err := validator2.ProvideService(pluginstoreService)
	if err != nil {
		return nil, err
	}
	statscollectorService := statscollector.ProvideService(usageStats, validatorService, statsService, cfg, sqlStore, socialService, pluginstoreService, featureManager, service12, httpclientProvider)
	internalMetricsService, err := metrics.ProvideService(cfg, registerer, gatherer)
	if err != nil {
		return nil, err
	}
	supportbundlesimplService, err := supportbundlesimpl.ProvideService(accessControl, acimplService, bundleregistryService, cfg, featureToggles, httpServer, kvStore, service11, pluginstoreService, routeRegisterImpl, ossImpl, sqlStore, usageStats, tracingService)
	if err != nil {
		return nil, err
	}
	metricService, err := metric.ProvideService(publicDashboardStoreImpl, registerer)
	if err != nil {
		return nil, err
	}
	pluginexternalService, err := pluginexternal.ProvideService(cfg, pluginstoreService)
	if err != nil {
		return nil, err
	}
	plugininstallerService, err := plugininstaller.ProvideService(cfg, pluginstoreService, pluginInstaller, registerer, repoManager, featureToggles)
	if err != nil {
		return nil, err
	}
	playlistAppProvider := playlist.RegisterApp(playlistService, cfg, featureToggles)
	investigationAppProvider := investigation.RegisterApp(cfg)
	appregistryService, err := appregistry.ProvideRegistryServiceSink(apiserverService, apiserverService, featureToggles, playlistAppProvider, investigationAppProvider)
	if err != nil {
		return nil, err
	}
	guardianProvider := guardian2.ProvideService(cfg, accessControl, dashboardService, teamService)
	importDashboardService := service9.ProvideService(routeRegisterImpl, quotaService, service13, pluginstoreService, libraryPanelService, dashboardService, accessControl, folderimplService)
	dashboardUpdater := service6.ProvideDashboardUpdater(inProcBus, pluginstoreService, service13, importDashboardService, service11, pluginService, dashboardService)
	sanitizerProvider := sanitizer.ProvideService(renderingService)
	healthService, err := grpcserver.ProvideHealthService(cfg, grpcserverProvider)
	if err != nil {
		return nil, err
	}
	reflectionService, err := grpcserver.ProvideReflectionService(cfg, grpcserverProvider)
	if err != nil {
		return nil, err
	}
	ossGroups := ldap.ProvideGroupsService()
	identitySynchronizer := authnimpl.ProvideIdentitySynchronizer(authnimplService)
	ldapImpl := service10.ProvideService(cfg, featureToggles, ssosettingsimplService)
	apiService := api4.ProvideService(cfg, routeRegisterImpl, accessControl, userService, authinfoimplService, ossGroups, identitySynchronizer, orgService, ldapImpl, userAuthTokenService, bundleregistryService)
	dashboardsAPIBuilder := dashboard.RegisterAPIService(featureToggles, apiserverService, dashboardProvisioningService)
	v0alpha1DashboardsAPIBuilder := v0alpha1.RegisterAPIService(cfg, featureToggles, apiserverService, dashboardService, dashboardProvisioningService, accessControl, provisioningServiceImpl, dashboardsStore, registerer, sqlStore, tracingService, resourceClient)
	v1alpha1DashboardsAPIBuilder := v1alpha1.RegisterAPIService(cfg, featureToggles, apiserverService, dashboardService, dashboardProvisioningService, accessControl, provisioningServiceImpl, dashboardsStore, registerer, sqlStore, tracingService, resourceClient)
	v2alpha1DashboardsAPIBuilder := v2alpha1.RegisterAPIService(cfg, featureToggles, apiserverService, dashboardService, dashboardProvisioningService, accessControl, provisioningServiceImpl, dashboardsStore, registerer, sqlStore, tracingService, resourceClient)
	snapshotsAPIBuilder := dashboardsnapshot.RegisterAPIService(serviceImpl, apiserverService, cfg, featureToggles, sqlStore, registerer)
	featureFlagAPIBuilder := featuretoggle.RegisterAPIService(featureManager, accessControl, apiserverService, cfg, registerer)
	dataSourceAPIBuilder, err := datasource.RegisterAPIService(featureToggles, apiserverService, middlewareHandler, scopedPluginDatasourceProvider, plugincontextProvider, pluginstoreService, accessControl, registerer)
	if err != nil {
		return nil, err
	}
	folderAPIBuilder := folders.RegisterAPIService(cfg, featureToggles, apiserverService, folderimplService, folderPermissionsService, accessControl, registerer, resourceClient)
	peakQAPIBuilder := peakq.RegisterAPIService(featureToggles, apiserverService, registerer)
	identityAccessManagementAPIBuilder, err := iam.RegisterAPIService(apiserverService, ssosettingsimplService, sqlStore, accessControl)
	if err != nil {
		return nil, err
	}
	scopeAPIBuilder := scope.RegisterAPIService(featureToggles, apiserverService, registerer)
	legacyDataSourceLookup := service4.ProvideLegacyDataSourceLookup(service12)
	queryAPIBuilder, err := query2.RegisterAPIService(featureToggles, apiserverService, service12, pluginstoreService, accessControl, middlewareHandler, plugincontextProvider, registerer, tracingService, legacyDataSourceLookup)
	if err != nil {
		return nil, err
	}
	notificationsAPIBuilder := notifications2.RegisterAPIService(featureToggles, apiserverService, cfg, alertNG)
	userStorageAPIBuilder := userstorage.RegisterAPIService(featureToggles, apiserverService, registerer)
	apiregistryService := apiregistry.ProvideRegistryServiceSink(dashboardsAPIBuilder, v0alpha1DashboardsAPIBuilder, v1alpha1DashboardsAPIBuilder, v2alpha1DashboardsAPIBuilder, snapshotsAPIBuilder, featureFlagAPIBuilder, dataSourceAPIBuilder, folderAPIBuilder, peakQAPIBuilder, identityAccessManagementAPIBuilder, scopeAPIBuilder, queryAPIBuilder, notificationsAPIBuilder, userStorageAPIBuilder)
	teamPermissionsService, err := ossaccesscontrol.ProvideTeamPermissions(cfg, featureToggles, routeRegisterImpl, sqlStore, accessControl, ossLicensingService, acimplService, teamService, userService, actionSetService)
	if err != nil {
		return nil, err
	}
	teamAPI := teamapi.ProvideTeamAPI(routeRegisterImpl, teamService, acimplService, accessControl, teamPermissionsService, userService, ossLicensingService, cfg, prefService, dashboardService)
	cloudmigrationService, err := cloudmigrationimpl.ProvideService(cfg, httpclientProvider, featureToggles, sqlStore, service12, secretsKVStore, secretsService, routeRegisterImpl, registerer, tracingService, dashboardService, folderimplService, pluginstoreService, service11, accessControl, acimplService, kvStore, libraryElementService, alertNG)
	if err != nil {
		return nil, err
	}
	authService, err := jwt.ProvideService(cfg, remoteCache)
	if err != nil {
		return nil, err
	}
	ossUserProtectionImpl := authinfoimpl.ProvideOSSUserProtectionService()
	registration := authnimpl.ProvideRegistration(cfg, authnService, orgService, userAuthTokenService, acimplService, permissionRegistry, apikeyService, userService, authService, ossUserProtectionImpl, loginattemptimplService, quotaService, authinfoimplService, renderingService, featureToggles, oauthtokentestService, socialService, remoteCache, ldapImpl, ossImpl, tracingService, tempuserService, notificationServiceMock)
	backgroundServiceRegistry := backgroundsvcs.ProvideBackgroundServiceRegistry(httpServer, alertNG, cleanUpService, grafanaLive, gateway, notificationService, pluginstoreService, renderingService, userAuthTokenService, tracingService, provisioningServiceImpl, usageStats, statscollectorService, grafanaService, pluginsService, internalMetricsService, secretsService, remoteCache, storageService, searchService, entityEventsService, serviceAccountsService, grpcserverProvider, secretMigrationProviderImpl, loginattemptimplService, supportbundlesimplService, metricService, keyRetriever, angulardetectorsproviderDynamic, apiserverService, anonDeviceService, ssosettingsimplService, pluginexternalService, plugininstallerService, acimplService, appregistryService, serviceImpl, serviceAccountsProxy, guardianProvider, dashboardUpdater, sanitizerProvider, healthService, authzClient, reflectionService, apiService, apiregistryService, idimplService, teamAPI, ssosettingsimplService, cloudmigrationService, registration)
	usageStatsProvidersRegistry := usagestatssvcs.ProvideUsageStatsProvidersRegistry(acimplService, userService)
	server, err := New(opts, cfg, httpServer, acimplService, provisioningServiceImpl, backgroundServiceRegistry, usageStatsProvidersRegistry, statscollectorService, registerer)
	if err != nil {
		return nil, err
	}
	testEnv, err := ProvideTestEnv(server, sqlStore, cfg, notificationServiceMock, grpcserverProvider, inMemory, httpclientProvider, oauthtokentestService, featureToggles, resourceClient, idimplService)
	if err != nil {
		return nil, err
	}
	return testEnv, nil
}

func InitializeForCLI(cfg *setting.Cfg) (Runner, error) {
	featureManager, err := featuremgmt.ProvideManagerService(cfg)
	if err != nil {
		return Runner{}, err
	}
	featureToggles := featuremgmt.ProvideToggles(featureManager)
	ossMigrations := migrations.ProvideOSSMigrations(featureToggles)
	tracingConfig, err := tracing.ProvideTracingConfig(cfg)
	if err != nil {
		return Runner{}, err
	}
	tracingService, err := tracing.ProvideService(tracingConfig)
	if err != nil {
		return Runner{}, err
	}
	inProcBus := bus.ProvideBus(tracingService)
	sqlStore, err := sqlstore.ProvideService(cfg, featureToggles, ossMigrations, inProcBus, tracingService)
	if err != nil {
		return Runner{}, err
	}
	ossImpl := setting.ProvideProvider(cfg)
	providerProvider := provider.ProvideEncryptionProvider()
	kvStore := kvstore.ProvideService(sqlStore)
	routeRegisterImpl := routing.ProvideRegister()
	accessControl := acimpl.ProvideAccessControl(featureToggles)
	bundleregistryService := bundleregistry.ProvideService()
	usageStats, err := service.ProvideService(cfg, kvStore, routeRegisterImpl, tracingService, accessControl, bundleregistryService)
	if err != nil {
		return Runner{}, err
	}
	serviceService, err := service2.ProvideEncryptionService(tracingService, providerProvider, usageStats, cfg)
	if err != nil {
		return Runner{}, err
	}
	secretsStoreImpl := database.ProvideSecretsStore(sqlStore)
	osskmsprovidersService := osskmsproviders.ProvideService(serviceService, cfg, featureToggles)
	secretsService, err := manager.ProvideSecretsService(tracingService, secretsStoreImpl, osskmsprovidersService, serviceService, cfg, featureToggles, usageStats)
	if err != nil {
		return Runner{}, err
	}
	secretsMigrator := migrator.ProvideSecretsMigrator(serviceService, secretsService, sqlStore, ossImpl, featureToggles)
	quotaService := quotaimpl.ProvideService(sqlStore, cfg)
	orgService, err := orgimpl.ProvideService(sqlStore, cfg, quotaService)
	if err != nil {
		return Runner{}, err
	}
	teamService, err := teamimpl.ProvideService(sqlStore, cfg, tracingService)
	if err != nil {
		return Runner{}, err
	}
	cacheService := localcache.ProvideService()
	userService, err := userimpl.ProvideService(sqlStore, orgService, cfg, teamService, cacheService, tracingService, quotaService, bundleregistryService)
	if err != nil {
		return Runner{}, err
	}
	runner := NewRunner(cfg, sqlStore, ossImpl, serviceService, featureToggles, secretsService, secretsMigrator, userService)
	return runner, nil
}

// InitializeForCLITarget is a simplified set of dependencies for the CLI, used
// by the server target subcommand to launch specific dskit modules.
func InitializeForCLITarget(cfg *setting.Cfg) (ModuleRunner, error) {
	ossImpl := setting.ProvideProvider(cfg)
	featureManager, err := featuremgmt.ProvideManagerService(cfg)
	if err != nil {
		return ModuleRunner{}, err
	}
	featureToggles := featuremgmt.ProvideToggles(featureManager)
	moduleRunner := NewModuleRunner(cfg, ossImpl, featureToggles)
	return moduleRunner, nil
}

// InitializeModuleServer is a simplified set of dependencies for the CLI,
// suitable for running background services and targeting dskit modules.
func InitializeModuleServer(cfg *setting.Cfg, opts Options, apiOpts api.ServerOptions) (*ModuleServer, error) {
	featureManager, err := featuremgmt.ProvideManagerService(cfg)
	if err != nil {
		return nil, err
	}
	featureToggles := featuremgmt.ProvideToggles(featureManager)
	moduleServer, err := NewModule(opts, apiOpts, featureToggles, cfg)
	if err != nil {
		return nil, err
	}
	return moduleServer, nil
}

// Initialize the standalone APIServer factory
func InitializeAPIServerFactory() (standalone.APIServerFactory, error) {
	apiServerFactory := standalone.ProvideAPIServerFactory()
	return apiServerFactory, nil
}

func InitializeDocumentBuilders(cfg *setting.Cfg) (resource.DocumentBuilderSupplier, error) {
	featureManager, err := featuremgmt.ProvideManagerService(cfg)
	if err != nil {
		return nil, err
	}
	featureToggles := featuremgmt.ProvideToggles(featureManager)
	ossMigrations := migrations.ProvideOSSMigrations(featureToggles)
	tracingConfig, err := tracing.ProvideTracingConfig(cfg)
	if err != nil {
		return nil, err
	}
	tracingService, err := tracing.ProvideService(tracingConfig)
	if err != nil {
		return nil, err
	}
	inProcBus := bus.ProvideBus(tracingService)
	sqlStore, err := sqlstore.ProvideService(cfg, featureToggles, ossMigrations, inProcBus, tracingService)
	if err != nil {
		return nil, err
	}
	ossDashboardStats := search.ProvideDashboardStats()
	documentBuilderSupplier := search.ProvideDocumentBuilders(sqlStore, ossDashboardStats)
	return documentBuilderSupplier, nil
}

// wire.go:

var wireBasicSet = wire.NewSet(annotationsimpl.ProvideService, wire.Bind(new(annotations.Repository), new(*annotationsimpl.RepositoryImpl)), New, api.ProvideHTTPServer, query.ProvideService, wire.Bind(new(query.Service), new(*query.ServiceImpl)), bus.ProvideBus, wire.Bind(new(bus.Bus), new(*bus.InProcBus)), rendering.ProvideService, wire.Bind(new(rendering.Service), new(*rendering.RenderingService)), routing.ProvideRegister, wire.Bind(new(routing.RouteRegister), new(*routing.RouteRegisterImpl)), hooks.ProvideService, kvstore.ProvideService, localcache.ProvideService, bundleregistry.ProvideService, wire.Bind(new(supportbundles.Service), new(*bundleregistry.Service)), updatechecker.ProvideGrafanaService, updatechecker.ProvidePluginsService, service.ProvideService, wire.Bind(new(usagestats.Service), new(*service.UsageStats)), validator2.ProvideService, pluginsintegration.WireSet, dashboards.ProvideFileStoreManager, wire.Bind(new(dashboards.FileStore), new(*dashboards.FileStoreManager)), cloudwatch.ProvideService, cloudmonitoring.ProvideService, azuremonitor.ProvideService, postgres.ProvideService, mysql.ProvideService, mssql.ProvideService, store.ProvideEntityEventsService, unified.ProvideUnifiedStorageClient, httpclientprovider.New, wire.Bind(new(httpclient.Provider), new(*httpclient2.Provider)), serverlock.ProvideService, annotationsimpl.ProvideCleanupService, wire.Bind(new(annotations.Cleaner), new(*annotationsimpl.CleanupServiceImpl)), cleanup.ProvideService, shorturlimpl.ProvideService, wire.Bind(new(shorturls.Service), new(*shorturlimpl.ShortURLService)), queryhistory.ProvideService, wire.Bind(new(queryhistory.Service), new(*queryhistory.QueryHistoryService)), correlations.ProvideService, wire.Bind(new(correlations.Service), new(*correlations.CorrelationsService)), quotaimpl.ProvideService, remotecache.ProvideService, wire.Bind(new(remotecache.CacheStorage), new(*remotecache.RemoteCache)), authinfoimpl.ProvideService, wire.Bind(new(login.AuthInfoService), new(*authinfoimpl.Service)), authinfoimpl.ProvideStore, datasourceproxy.ProvideService, search2.ProvideService, searchV2.ProvideService, searchV2.ProvideSearchHTTPService, store.ProvideService, store.ProvideSystemUsersService, live.ProvideService, pushhttp.ProvideService, contexthandler.ProvideService, service10.ProvideService, wire.Bind(new(service10.LDAP), new(*service10.LDAPImpl)), jwt.ProvideService, wire.Bind(new(jwt.JWTService), new(*jwt.AuthService)), store2.ProvideDBStore, image.ProvideDeleteExpiredService, ngalert.ProvideService, librarypanels.ProvideService, wire.Bind(new(librarypanels.Service), new(*librarypanels.LibraryPanelService)), libraryelements.ProvideService, wire.Bind(new(libraryelements.Service), new(*libraryelements.LibraryElementService)), notifications.ProvideService, notifications.ProvideSmtpService, tracing.ProvideService, tracing.ProvideTracingConfig, wire.Bind(new(tracing.Tracer), new(*tracing.TracingService)), testdatasource.ProvideService, api4.ProvideService, opentsdb.ProvideService, socialimpl.ProvideService, influxdb.ProvideService, wire.Bind(new(social.Service), new(*socialimpl.SocialService)), tempo.ProvideService, loki.ProvideService, graphite.ProvideService, prometheus.ProvideService, elasticsearch.ProvideService, pyroscope.ProvideService, parca.ProvideService, zipkin.ProvideService, service4.ProvideCacheService, wire.Bind(new(datasources.CacheService), new(*service4.CacheServiceImpl)), service2.ProvideEncryptionService, wire.Bind(new(encryption.Internal), new(*service2.Service)), manager.ProvideSecretsService, wire.Bind(new(secrets.Service), new(*manager.SecretsService)), database.ProvideSecretsStore, wire.Bind(new(secrets.Store), new(*database.SecretsStoreImpl)), grafanads.ProvideService, wire.Bind(new(dashboardsnapshots.Store), new(*database3.DashboardSnapshotStore)), database3.ProvideStore, wire.Bind(new(dashboardsnapshots.Service), new(*service7.ServiceImpl)), service7.ProvideService, service4.ProvideService, wire.Bind(new(datasources.DataSourceService), new(*service4.Service)), service4.ProvideLegacyDataSourceLookup, retriever.ProvideService, wire.Bind(new(serviceaccounts.ServiceAccountRetriever), new(*retriever.Service)), ossaccesscontrol.ProvideServiceAccountPermissions, wire.Bind(new(accesscontrol.ServiceAccountPermissionsService), new(*ossaccesscontrol.ServiceAccountPermissionsService)), manager2.ProvideServiceAccountsService, proxy.ProvideServiceAccountsProxy, wire.Bind(new(serviceaccounts.Service), new(*proxy.ServiceAccountsProxy)), expr.ProvideService, featuremgmt.ProvideManagerService, featuremgmt.ProvideToggles, service5.ProvideDashboardServiceImpl, service5.ProvideDashboardService, service5.ProvideDashboardProvisioningService, service5.ProvideDashboardPluginService, database2.ProvideDashboardStore, folderimpl.ProvideService, wire.Bind(new(folder.Service), new(*folderimpl.Service)), folderimpl.ProvideStore, wire.Bind(new(folder.Store), new(*folderimpl.FolderStoreImpl)), folderimpl.ProvideDashboardFolderStore, wire.Bind(new(folder.FolderStore), new(*folderimpl.DashboardFolderStoreImpl)), service9.ProvideService, wire.Bind(new(dashboardimport.Service), new(*service9.ImportDashboardService)), service6.ProvideService, wire.Bind(new(plugindashboards.Service), new(*service6.Service)), service6.ProvideDashboardUpdater, guardian2.ProvideService, sanitizer.ProvideService, kvstore2.ProvideService, avatar.ProvideAvatarCacheServer, statscollector.ProvideService, csrf.ProvideCSRFFilter, wire.Bind(new(csrf.Service), new(*csrf.CSRF)), ossaccesscontrol.ProvideTeamPermissions, wire.Bind(new(accesscontrol.TeamPermissionsService), new(*ossaccesscontrol.TeamPermissionsService)), ossaccesscontrol.ProvideFolderPermissions, wire.Bind(new(accesscontrol.FolderPermissionsService), new(*ossaccesscontrol.FolderPermissionsService)), ossaccesscontrol.ProvideDashboardPermissions, wire.Bind(new(accesscontrol.DashboardPermissionsService), new(*ossaccesscontrol.DashboardPermissionsService)), ossaccesscontrol.ProvideReceiverPermissionsService, wire.Bind(new(accesscontrol.ReceiverPermissionsService), new(*ossaccesscontrol.ReceiverPermissionsService)), starimpl.ProvideService, playlistimpl.ProvideService, apikeyimpl.ProvideService, dashverimpl.ProvideService, service8.ProvideService, wire.Bind(new(publicdashboards.Service), new(*service8.PublicDashboardServiceImpl)), database4.ProvideStore, wire.Bind(new(publicdashboards.Store), new(*database4.PublicDashboardStoreImpl)), metric.ProvideService, api2.ProvideApi, api3.ProvideApi, userimpl.ProvideService, orgimpl.ProvideService, orgimpl.ProvideDeletionService, statsimpl.ProvideService, grpccontext.ProvideContextHandler, grpcserver.ProvideService, grpcserver.ProvideHealthService, grpcserver.ProvideReflectionService, interceptors.ProvideAuthenticator, resolver.ProvideEntityReferenceResolver, teamimpl.ProvideService, teamapi.ProvideTeamAPI, tempuserimpl.ProvideService, loginattemptimpl.ProvideService, wire.Bind(new(loginattempt.Service), new(*loginattemptimpl.Service)), migrations2.ProvideDataSourceMigrationService, migrations2.ProvideMigrateToPluginService, migrations2.ProvideMigrateFromPluginService, migrations2.ProvideSecretMigrationProvider, wire.Bind(new(migrations2.SecretMigrationProvider), new(*migrations2.SecretMigrationProviderImpl)), resourcepermissions.NewActionSetService, wire.Bind(new(accesscontrol.ActionResolver), new(resourcepermissions.ActionSetService)), wire.Bind(new(pluginaccesscontrol.ActionSetRegistry), new(resourcepermissions.ActionSetService)), permreg.ProvidePermissionRegistry, acimpl.ProvideAccessControl, navtreeimpl.ProvideService, wire.Bind(new(accesscontrol.AccessControl), new(*acimpl.AccessControl)), wire.Bind(new(notifications.TempUserStore), new(tempuser.Service)), tagimpl.ProvideService, wire.Bind(new(tag.Service), new(*tagimpl.Service)), authnimpl.ProvideService, authnimpl.ProvideIdentitySynchronizer, authnimpl.ProvideAuthnService, authnimpl.ProvideAuthnServiceAuthenticateOnly, authnimpl.ProvideRegistration, supportbundlesimpl.ProvideService, extsvcaccounts.ProvideExtSvcAccountsService, wire.Bind(new(serviceaccounts.ExtSvcAccountsService), new(*extsvcaccounts.ExtSvcAccountsService)), registry2.ProvideExtSvcRegistry, wire.Bind(new(extsvcauth.ExternalServiceRegistry), new(*registry2.Registry)), anonstore.ProvideAnonDBStore, wire.Bind(new(anonstore.AnonStore), new(*anonstore.AnonDBStore)), loggermw.Provide, slogadapter.Provide, signingkeysimpl.ProvideEmbeddedSigningKeysService, wire.Bind(new(signingkeys.Service), new(*signingkeysimpl.Service)), ssosettingsimpl.ProvideService, wire.Bind(new(ssosettings.Service), new(*ssosettingsimpl.Service)), idimpl.ProvideService, wire.Bind(new(auth.IDService), new(*idimpl.Service)), cloudmigrationimpl.ProvideService, userimpl.ProvideVerifier, connectors.ProvideOrgRoleMapper, wire.Bind(new(user.Verifier), new(*userimpl.Verifier)), authz.WireSet, apiserver.WireSet, apiregistry.WireSet, appregistry.WireSet)

var wireSet = wire.NewSet(
	wireBasicSet, metrics.WireSet, sqlstore.ProvideService, metrics2.ProvideService, wire.Bind(new(notifications.Service), new(*notifications.NotificationService)), wire.Bind(new(notifications.WebhookSender), new(*notifications.NotificationService)), wire.Bind(new(notifications.EmailSender), new(*notifications.NotificationService)), wire.Bind(new(db.DB), new(*sqlstore.SQLStore)), prefimpl.ProvideService, oauthtoken.ProvideService, wire.Bind(new(oauthtoken.OAuthTokenService), new(*oauthtoken.Service)),
)

var wireCLISet = wire.NewSet(
	NewRunner,
	wireBasicSet, metrics.WireSet, sqlstore.ProvideService, metrics2.ProvideService, wire.Bind(new(notifications.Service), new(*notifications.NotificationService)), wire.Bind(new(notifications.WebhookSender), new(*notifications.NotificationService)), wire.Bind(new(notifications.EmailSender), new(*notifications.NotificationService)), wire.Bind(new(db.DB), new(*sqlstore.SQLStore)), prefimpl.ProvideService, oauthtoken.ProvideService, wire.Bind(new(oauthtoken.OAuthTokenService), new(*oauthtoken.Service)),
)

var wireTestSet = wire.NewSet(
	wireBasicSet,
	ProvideTestEnv, metrics.WireSetForTest, sqlstore.ProvideServiceForTests, metrics2.ProvideServiceForTest, notifications.MockNotificationService, wire.Bind(new(notifications.Service), new(*notifications.NotificationServiceMock)), wire.Bind(new(notifications.WebhookSender), new(*notifications.NotificationServiceMock)), wire.Bind(new(notifications.EmailSender), new(*notifications.NotificationServiceMock)), wire.Bind(new(db.DB), new(*sqlstore.SQLStore)), prefimpl.ProvideService, oauthtoken.ProvideService, oauthtokentest.ProvideService, wire.Bind(new(oauthtoken.OAuthTokenService), new(*oauthtokentest.Service)),
)
