// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// AlertQuery AlertQuery represents a single query associated with an alert definition.
//
// swagger:model AlertQuery
type AlertQuery struct {

	// Grafana data source unique identifier; it should be '__expr__' for a Server Side Expression operation.
	DatasourceUID string `json:"datasourceUid,omitempty"`

	// JSON is the raw JSON query and includes the above properties as well as custom properties.
	Model interface{} `json:"model,omitempty"`

	// QueryType is an optional identifier for the type of query.
	// It can be used to distinguish different types of queries.
	QueryType string `json:"queryType,omitempty"`

	// RefID is the unique identifier of the query, set by the frontend call.
	RefID string `json:"refId,omitempty"`

	// relative time range
	RelativeTimeRange *RelativeTimeRange `json:"relativeTimeRange,omitempty"`
}

// Validate validates this alert query
func (m *AlertQuery) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateRelativeTimeRange(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *AlertQuery) validateRelativeTimeRange(formats strfmt.Registry) error {
	if swag.IsZero(m.RelativeTimeRange) { // not required
		return nil
	}

	if m.RelativeTimeRange != nil {
		if err := m.RelativeTimeRange.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("relativeTimeRange")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("relativeTimeRange")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this alert query based on the context it is used
func (m *AlertQuery) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateRelativeTimeRange(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *AlertQuery) contextValidateRelativeTimeRange(ctx context.Context, formats strfmt.Registry) error {

	if m.RelativeTimeRange != nil {

		if swag.IsZero(m.RelativeTimeRange) { // not required
			return nil
		}

		if err := m.RelativeTimeRange.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("relativeTimeRange")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("relativeTimeRange")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *AlertQuery) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *AlertQuery) UnmarshalBinary(b []byte) error {
	var res AlertQuery
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
