// Code generated by go-swagger; DO NOT EDIT.

package orgs

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewGetOrgUsersParams creates a new GetOrgUsersParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewGetOrgUsersParams() *GetOrgUsersParams {
	return &GetOrgUsersParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewGetOrgUsersParamsWithTimeout creates a new GetOrgUsersParams object
// with the ability to set a timeout on a request.
func NewGetOrgUsersParamsWithTimeout(timeout time.Duration) *GetOrgUsersParams {
	return &GetOrgUsersParams{
		timeout: timeout,
	}
}

// NewGetOrgUsersParamsWithContext creates a new GetOrgUsersParams object
// with the ability to set a context for a request.
func NewGetOrgUsersParamsWithContext(ctx context.Context) *GetOrgUsersParams {
	return &GetOrgUsersParams{
		Context: ctx,
	}
}

// NewGetOrgUsersParamsWithHTTPClient creates a new GetOrgUsersParams object
// with the ability to set a custom HTTPClient for a request.
func NewGetOrgUsersParamsWithHTTPClient(client *http.Client) *GetOrgUsersParams {
	return &GetOrgUsersParams{
		HTTPClient: client,
	}
}

/*
GetOrgUsersParams contains all the parameters to send to the API endpoint

	for the get org users operation.

	Typically these are written to a http.Request.
*/
type GetOrgUsersParams struct {

	// OrgID.
	//
	// Format: int64
	OrgID int64

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the get org users params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *GetOrgUsersParams) WithDefaults() *GetOrgUsersParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the get org users params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *GetOrgUsersParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the get org users params
func (o *GetOrgUsersParams) WithTimeout(timeout time.Duration) *GetOrgUsersParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the get org users params
func (o *GetOrgUsersParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the get org users params
func (o *GetOrgUsersParams) WithContext(ctx context.Context) *GetOrgUsersParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the get org users params
func (o *GetOrgUsersParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the get org users params
func (o *GetOrgUsersParams) WithHTTPClient(client *http.Client) *GetOrgUsersParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the get org users params
func (o *GetOrgUsersParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithOrgID adds the orgID to the get org users params
func (o *GetOrgUsersParams) WithOrgID(orgID int64) *GetOrgUsersParams {
	o.SetOrgID(orgID)
	return o
}

// SetOrgID adds the orgId to the get org users params
func (o *GetOrgUsersParams) SetOrgID(orgID int64) {
	o.OrgID = orgID
}

// WriteToRequest writes these params to a swagger request
func (o *GetOrgUsersParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	// path param org_id
	if err := r.SetPathParam("org_id", swag.FormatInt64(o.OrgID)); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
