// Code generated by go-swagger; DO NOT EDIT.

package annotations

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/grafana/grafana-openapi-client-go/models"
)

// PostGraphiteAnnotationReader is a Reader for the PostGraphiteAnnotation structure.
type PostGraphiteAnnotationReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *PostGraphiteAnnotationReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewPostGraphiteAnnotationOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 400:
		result := NewPostGraphiteAnnotationBadRequest()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 401:
		result := NewPostGraphiteAnnotationUnauthorized()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewPostGraphiteAnnotationForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewPostGraphiteAnnotationInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[POST /annotations/graphite] postGraphiteAnnotation", response, response.Code())
	}
}

// NewPostGraphiteAnnotationOK creates a PostGraphiteAnnotationOK with default headers values
func NewPostGraphiteAnnotationOK() *PostGraphiteAnnotationOK {
	return &PostGraphiteAnnotationOK{}
}

/*
PostGraphiteAnnotationOK describes a response with status code 200, with default header values.

(empty)
*/
type PostGraphiteAnnotationOK struct {
	Payload *models.PostGraphiteAnnotationOKBody
}

// IsSuccess returns true when this post graphite annotation Ok response has a 2xx status code
func (o *PostGraphiteAnnotationOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this post graphite annotation Ok response has a 3xx status code
func (o *PostGraphiteAnnotationOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this post graphite annotation Ok response has a 4xx status code
func (o *PostGraphiteAnnotationOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this post graphite annotation Ok response has a 5xx status code
func (o *PostGraphiteAnnotationOK) IsServerError() bool {
	return false
}

// IsCode returns true when this post graphite annotation Ok response a status code equal to that given
func (o *PostGraphiteAnnotationOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the post graphite annotation Ok response
func (o *PostGraphiteAnnotationOK) Code() int {
	return 200
}

func (o *PostGraphiteAnnotationOK) Error() string {
	return fmt.Sprintf("[POST /annotations/graphite][%d] postGraphiteAnnotationOk  %+v", 200, o.Payload)
}

func (o *PostGraphiteAnnotationOK) String() string {
	return fmt.Sprintf("[POST /annotations/graphite][%d] postGraphiteAnnotationOk  %+v", 200, o.Payload)
}

func (o *PostGraphiteAnnotationOK) GetPayload() *models.PostGraphiteAnnotationOKBody {
	return o.Payload
}

func (o *PostGraphiteAnnotationOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.PostGraphiteAnnotationOKBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewPostGraphiteAnnotationBadRequest creates a PostGraphiteAnnotationBadRequest with default headers values
func NewPostGraphiteAnnotationBadRequest() *PostGraphiteAnnotationBadRequest {
	return &PostGraphiteAnnotationBadRequest{}
}

/*
PostGraphiteAnnotationBadRequest describes a response with status code 400, with default header values.

BadRequestError is returned when the request is invalid and it cannot be processed.
*/
type PostGraphiteAnnotationBadRequest struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this post graphite annotation bad request response has a 2xx status code
func (o *PostGraphiteAnnotationBadRequest) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this post graphite annotation bad request response has a 3xx status code
func (o *PostGraphiteAnnotationBadRequest) IsRedirect() bool {
	return false
}

// IsClientError returns true when this post graphite annotation bad request response has a 4xx status code
func (o *PostGraphiteAnnotationBadRequest) IsClientError() bool {
	return true
}

// IsServerError returns true when this post graphite annotation bad request response has a 5xx status code
func (o *PostGraphiteAnnotationBadRequest) IsServerError() bool {
	return false
}

// IsCode returns true when this post graphite annotation bad request response a status code equal to that given
func (o *PostGraphiteAnnotationBadRequest) IsCode(code int) bool {
	return code == 400
}

// Code gets the status code for the post graphite annotation bad request response
func (o *PostGraphiteAnnotationBadRequest) Code() int {
	return 400
}

func (o *PostGraphiteAnnotationBadRequest) Error() string {
	return fmt.Sprintf("[POST /annotations/graphite][%d] postGraphiteAnnotationBadRequest  %+v", 400, o.Payload)
}

func (o *PostGraphiteAnnotationBadRequest) String() string {
	return fmt.Sprintf("[POST /annotations/graphite][%d] postGraphiteAnnotationBadRequest  %+v", 400, o.Payload)
}

func (o *PostGraphiteAnnotationBadRequest) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *PostGraphiteAnnotationBadRequest) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewPostGraphiteAnnotationUnauthorized creates a PostGraphiteAnnotationUnauthorized with default headers values
func NewPostGraphiteAnnotationUnauthorized() *PostGraphiteAnnotationUnauthorized {
	return &PostGraphiteAnnotationUnauthorized{}
}

/*
PostGraphiteAnnotationUnauthorized describes a response with status code 401, with default header values.

UnauthorizedError is returned when the request is not authenticated.
*/
type PostGraphiteAnnotationUnauthorized struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this post graphite annotation unauthorized response has a 2xx status code
func (o *PostGraphiteAnnotationUnauthorized) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this post graphite annotation unauthorized response has a 3xx status code
func (o *PostGraphiteAnnotationUnauthorized) IsRedirect() bool {
	return false
}

// IsClientError returns true when this post graphite annotation unauthorized response has a 4xx status code
func (o *PostGraphiteAnnotationUnauthorized) IsClientError() bool {
	return true
}

// IsServerError returns true when this post graphite annotation unauthorized response has a 5xx status code
func (o *PostGraphiteAnnotationUnauthorized) IsServerError() bool {
	return false
}

// IsCode returns true when this post graphite annotation unauthorized response a status code equal to that given
func (o *PostGraphiteAnnotationUnauthorized) IsCode(code int) bool {
	return code == 401
}

// Code gets the status code for the post graphite annotation unauthorized response
func (o *PostGraphiteAnnotationUnauthorized) Code() int {
	return 401
}

func (o *PostGraphiteAnnotationUnauthorized) Error() string {
	return fmt.Sprintf("[POST /annotations/graphite][%d] postGraphiteAnnotationUnauthorized  %+v", 401, o.Payload)
}

func (o *PostGraphiteAnnotationUnauthorized) String() string {
	return fmt.Sprintf("[POST /annotations/graphite][%d] postGraphiteAnnotationUnauthorized  %+v", 401, o.Payload)
}

func (o *PostGraphiteAnnotationUnauthorized) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *PostGraphiteAnnotationUnauthorized) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewPostGraphiteAnnotationForbidden creates a PostGraphiteAnnotationForbidden with default headers values
func NewPostGraphiteAnnotationForbidden() *PostGraphiteAnnotationForbidden {
	return &PostGraphiteAnnotationForbidden{}
}

/*
PostGraphiteAnnotationForbidden describes a response with status code 403, with default header values.

ForbiddenError is returned if the user/token has insufficient permissions to access the requested resource.
*/
type PostGraphiteAnnotationForbidden struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this post graphite annotation forbidden response has a 2xx status code
func (o *PostGraphiteAnnotationForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this post graphite annotation forbidden response has a 3xx status code
func (o *PostGraphiteAnnotationForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this post graphite annotation forbidden response has a 4xx status code
func (o *PostGraphiteAnnotationForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this post graphite annotation forbidden response has a 5xx status code
func (o *PostGraphiteAnnotationForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this post graphite annotation forbidden response a status code equal to that given
func (o *PostGraphiteAnnotationForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the post graphite annotation forbidden response
func (o *PostGraphiteAnnotationForbidden) Code() int {
	return 403
}

func (o *PostGraphiteAnnotationForbidden) Error() string {
	return fmt.Sprintf("[POST /annotations/graphite][%d] postGraphiteAnnotationForbidden  %+v", 403, o.Payload)
}

func (o *PostGraphiteAnnotationForbidden) String() string {
	return fmt.Sprintf("[POST /annotations/graphite][%d] postGraphiteAnnotationForbidden  %+v", 403, o.Payload)
}

func (o *PostGraphiteAnnotationForbidden) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *PostGraphiteAnnotationForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewPostGraphiteAnnotationInternalServerError creates a PostGraphiteAnnotationInternalServerError with default headers values
func NewPostGraphiteAnnotationInternalServerError() *PostGraphiteAnnotationInternalServerError {
	return &PostGraphiteAnnotationInternalServerError{}
}

/*
PostGraphiteAnnotationInternalServerError describes a response with status code 500, with default header values.

InternalServerError is a general error indicating something went wrong internally.
*/
type PostGraphiteAnnotationInternalServerError struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this post graphite annotation internal server error response has a 2xx status code
func (o *PostGraphiteAnnotationInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this post graphite annotation internal server error response has a 3xx status code
func (o *PostGraphiteAnnotationInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this post graphite annotation internal server error response has a 4xx status code
func (o *PostGraphiteAnnotationInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this post graphite annotation internal server error response has a 5xx status code
func (o *PostGraphiteAnnotationInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this post graphite annotation internal server error response a status code equal to that given
func (o *PostGraphiteAnnotationInternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the post graphite annotation internal server error response
func (o *PostGraphiteAnnotationInternalServerError) Code() int {
	return 500
}

func (o *PostGraphiteAnnotationInternalServerError) Error() string {
	return fmt.Sprintf("[POST /annotations/graphite][%d] postGraphiteAnnotationInternalServerError  %+v", 500, o.Payload)
}

func (o *PostGraphiteAnnotationInternalServerError) String() string {
	return fmt.Sprintf("[POST /annotations/graphite][%d] postGraphiteAnnotationInternalServerError  %+v", 500, o.Payload)
}

func (o *PostGraphiteAnnotationInternalServerError) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *PostGraphiteAnnotationInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
