// Code generated by go-swagger; DO NOT EDIT.

package access_control

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/grafana/grafana-openapi-client-go/models"
)

// CreateRoleReader is a Reader for the CreateRole structure.
type CreateRoleReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *CreateRoleReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 201:
		result := NewCreateRoleCreated()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 400:
		result := NewCreateRoleBadRequest()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewCreateRoleForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewCreateRoleInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[POST /access-control/roles] createRole", response, response.Code())
	}
}

// NewCreateRoleCreated creates a CreateRoleCreated with default headers values
func NewCreateRoleCreated() *CreateRoleCreated {
	return &CreateRoleCreated{}
}

/*
CreateRoleCreated describes a response with status code 201, with default header values.

(empty)
*/
type CreateRoleCreated struct {
	Payload *models.RoleDTO
}

// IsSuccess returns true when this create role created response has a 2xx status code
func (o *CreateRoleCreated) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this create role created response has a 3xx status code
func (o *CreateRoleCreated) IsRedirect() bool {
	return false
}

// IsClientError returns true when this create role created response has a 4xx status code
func (o *CreateRoleCreated) IsClientError() bool {
	return false
}

// IsServerError returns true when this create role created response has a 5xx status code
func (o *CreateRoleCreated) IsServerError() bool {
	return false
}

// IsCode returns true when this create role created response a status code equal to that given
func (o *CreateRoleCreated) IsCode(code int) bool {
	return code == 201
}

// Code gets the status code for the create role created response
func (o *CreateRoleCreated) Code() int {
	return 201
}

func (o *CreateRoleCreated) Error() string {
	return fmt.Sprintf("[POST /access-control/roles][%d] createRoleCreated  %+v", 201, o.Payload)
}

func (o *CreateRoleCreated) String() string {
	return fmt.Sprintf("[POST /access-control/roles][%d] createRoleCreated  %+v", 201, o.Payload)
}

func (o *CreateRoleCreated) GetPayload() *models.RoleDTO {
	return o.Payload
}

func (o *CreateRoleCreated) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.RoleDTO)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewCreateRoleBadRequest creates a CreateRoleBadRequest with default headers values
func NewCreateRoleBadRequest() *CreateRoleBadRequest {
	return &CreateRoleBadRequest{}
}

/*
CreateRoleBadRequest describes a response with status code 400, with default header values.

BadRequestError is returned when the request is invalid and it cannot be processed.
*/
type CreateRoleBadRequest struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this create role bad request response has a 2xx status code
func (o *CreateRoleBadRequest) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this create role bad request response has a 3xx status code
func (o *CreateRoleBadRequest) IsRedirect() bool {
	return false
}

// IsClientError returns true when this create role bad request response has a 4xx status code
func (o *CreateRoleBadRequest) IsClientError() bool {
	return true
}

// IsServerError returns true when this create role bad request response has a 5xx status code
func (o *CreateRoleBadRequest) IsServerError() bool {
	return false
}

// IsCode returns true when this create role bad request response a status code equal to that given
func (o *CreateRoleBadRequest) IsCode(code int) bool {
	return code == 400
}

// Code gets the status code for the create role bad request response
func (o *CreateRoleBadRequest) Code() int {
	return 400
}

func (o *CreateRoleBadRequest) Error() string {
	return fmt.Sprintf("[POST /access-control/roles][%d] createRoleBadRequest  %+v", 400, o.Payload)
}

func (o *CreateRoleBadRequest) String() string {
	return fmt.Sprintf("[POST /access-control/roles][%d] createRoleBadRequest  %+v", 400, o.Payload)
}

func (o *CreateRoleBadRequest) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *CreateRoleBadRequest) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewCreateRoleForbidden creates a CreateRoleForbidden with default headers values
func NewCreateRoleForbidden() *CreateRoleForbidden {
	return &CreateRoleForbidden{}
}

/*
CreateRoleForbidden describes a response with status code 403, with default header values.

ForbiddenError is returned if the user/token has insufficient permissions to access the requested resource.
*/
type CreateRoleForbidden struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this create role forbidden response has a 2xx status code
func (o *CreateRoleForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this create role forbidden response has a 3xx status code
func (o *CreateRoleForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this create role forbidden response has a 4xx status code
func (o *CreateRoleForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this create role forbidden response has a 5xx status code
func (o *CreateRoleForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this create role forbidden response a status code equal to that given
func (o *CreateRoleForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the create role forbidden response
func (o *CreateRoleForbidden) Code() int {
	return 403
}

func (o *CreateRoleForbidden) Error() string {
	return fmt.Sprintf("[POST /access-control/roles][%d] createRoleForbidden  %+v", 403, o.Payload)
}

func (o *CreateRoleForbidden) String() string {
	return fmt.Sprintf("[POST /access-control/roles][%d] createRoleForbidden  %+v", 403, o.Payload)
}

func (o *CreateRoleForbidden) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *CreateRoleForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewCreateRoleInternalServerError creates a CreateRoleInternalServerError with default headers values
func NewCreateRoleInternalServerError() *CreateRoleInternalServerError {
	return &CreateRoleInternalServerError{}
}

/*
CreateRoleInternalServerError describes a response with status code 500, with default header values.

InternalServerError is a general error indicating something went wrong internally.
*/
type CreateRoleInternalServerError struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this create role internal server error response has a 2xx status code
func (o *CreateRoleInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this create role internal server error response has a 3xx status code
func (o *CreateRoleInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this create role internal server error response has a 4xx status code
func (o *CreateRoleInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this create role internal server error response has a 5xx status code
func (o *CreateRoleInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this create role internal server error response a status code equal to that given
func (o *CreateRoleInternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the create role internal server error response
func (o *CreateRoleInternalServerError) Code() int {
	return 500
}

func (o *CreateRoleInternalServerError) Error() string {
	return fmt.Sprintf("[POST /access-control/roles][%d] createRoleInternalServerError  %+v", 500, o.Payload)
}

func (o *CreateRoleInternalServerError) String() string {
	return fmt.Sprintf("[POST /access-control/roles][%d] createRoleInternalServerError  %+v", 500, o.Payload)
}

func (o *CreateRoleInternalServerError) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *CreateRoleInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
