/*
Package k8s contains an implementation of the resource.Client, resource.SchemalessClient, and resource.ClientGenerator interfaces
which uses a standard kubernetes API server as its storage system API server.

# Instrumentation

This package is instrumented for logs, metrics, and traces.

## Logs

TODO - info here.

## Metrics

TODO - info here.

## Traces

Spans are generated for all interactions with the kubernetes API Server, regardless of the client used.
Tracing uses OpenTelemetry, and the Tracer used can be set with k8s.SetTracer (by default, the global Tracer is used).
Spans attributes follow the semantic conventions for HTTP spans set by the
OpenTelemetry Semantic Conventions for HTTP Spans: https://github.com/open-telemetry/semantic-conventions/blob/098db1ca510da01fe941f6c6308aad5000def910/docs/http/http-spans.md.
Currently, the k8s package uses an underlying kubernetes client-go rest.Interface REST client, which does not have tracing instrumentation.
This means that retries which are configured in the kubernetes rest.Config used to generate the Client will not be known to spans
generated by the k8s.Client, and the entire set of requests will be treated as one HTTP request for the purposes of tracing.
*/
package k8s
