/*
 *	Command pipe utilities
 *
 *	Copyright (C) 2003 SuSE Linux AG Nuernberg, Germany.
 *	Copyright (C) 2011 SUSE LINUX Products GmbH, Nuernberg, Germany.
 *
 *	This program is free software; you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License as published by
 *	the Free Software Foundation; either version 2 of the License, or
 *	(at your option) any later version.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this program; if not, write to the Free Software
 *	Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 *	MA  02110-1301  USA
 *
 *	Authors: Marius Tomaschewski <mt@suse.de>
 *
 *	libnetcontrol contains source code which is based on wicked.
 *	Wicked is licensed under the GPL-2.0+, but permission has been
 *	granted by the authors of wicked to use the code derived from
 *	wicked under the LGPL-2.1+ in libnetcontrol.
 *	You can find the wicked project at http://gitorious.org/wicked/.
 *
 */
#ifndef __NETCONTROL_CMD_PIPE_H
#define __NETCONTROL_CMD_PIPE_H
#if defined(HAVE_CONFIG_H)
#include <config.h>
#endif

#include <sys/types.h>
#include <sys/wait.h>
#include <stdio.h>
#include <sutils.h>

typedef struct {
	pid_t			pid;		/* pipe child pid number  */
	FILE * 			file;		/* descriptor to the pipe */
	nc_string_array_t *	args;		/* function arguments     */
	int          (*exec)(nc_string_array_t *args);	/* the function   */
} nc_cmd_pipe_t;

int		nc_cmd_pipe_exec(nc_cmd_pipe_t *cmd);
pid_t		nc_cmd_pipe_wait(nc_cmd_pipe_t *cmd, int *status, int flags);

#endif /* __NETCONTROL_CMD_PIPE_H */
