/* filehelper.c generated by valac, the Vala compiler
 * generated from filehelper.vala, do not modify */

/* filehelper.vala
 *
 * Copyright (C) 2008-2009 Florian Brosch
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Brosch Florian <flo.brosch@gmail.com>
 */

#include <glib.h>
#include <glib-object.h>
#include "valadoc.h"
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <glib/gstdio.h>

#define _fclose0(var) ((var == NULL) ? NULL : (var = (fclose (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_dir_close0(var) ((var == NULL) ? NULL : (var = (g_dir_close (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))



G_GNUC_INTERNAL gboolean valadoc_ends_with_dir_separator (const gchar* s);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


/**
 * Makes a copy of the file src to dest. 
 *
 * @param src the file to copy
 * @param dest the destination path
 */
gboolean valadoc_copy_file (const gchar* src, const gchar* dest) {
	gboolean result = FALSE;
	FILE* fsrc = NULL;
	const gchar* _tmp0_;
	FILE* _tmp1_;
	FILE* _tmp2_;
	FILE* fdest = NULL;
	const gchar* _tmp3_;
	FILE* _tmp4_;
	FILE* _tmp5_;
	g_return_val_if_fail (src != NULL, FALSE);
	g_return_val_if_fail (dest != NULL, FALSE);
	_tmp0_ = src;
	_tmp1_ = g_fopen (_tmp0_, "rb");
	fsrc = _tmp1_;
	_tmp2_ = fsrc;
	if (_tmp2_ == NULL) {
		result = FALSE;
		_fclose0 (fsrc);
		return result;
	}
	_tmp3_ = dest;
	_tmp4_ = g_fopen (_tmp3_, "wb");
	fdest = _tmp4_;
	_tmp5_ = fdest;
	if (_tmp5_ == NULL) {
		result = FALSE;
		_fclose0 (fdest);
		_fclose0 (fsrc);
		return result;
	}
	{
		gint c = 0;
		FILE* _tmp6_;
		gint _tmp7_;
		_tmp6_ = fsrc;
		_tmp7_ = fgetc (_tmp6_);
		c = _tmp7_;
		{
			gboolean _tmp8_ = FALSE;
			_tmp8_ = TRUE;
			while (TRUE) {
				FILE* _tmp11_;
				gboolean _tmp12_;
				FILE* _tmp13_;
				gint _tmp14_;
				if (!_tmp8_) {
					FILE* _tmp9_;
					gint _tmp10_;
					_tmp9_ = fsrc;
					_tmp10_ = fgetc (_tmp9_);
					c = _tmp10_;
				}
				_tmp8_ = FALSE;
				_tmp11_ = fsrc;
				_tmp12_ = feof (_tmp11_);
				if (!(!_tmp12_)) {
					break;
				}
				_tmp13_ = fdest;
				_tmp14_ = c;
				fputc ((gchar) _tmp14_, _tmp13_);
			}
		}
	}
	result = TRUE;
	_fclose0 (fdest);
	_fclose0 (fsrc);
	return result;
}


/**
 * Makes a copy of the directory src to dest. 
 *
 * @param src the directory to copy
 * @param dest the destination path
 */
gboolean valadoc_copy_directory (const gchar* src, const gchar* dest) {
	gboolean result = FALSE;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (src != NULL, FALSE);
	g_return_val_if_fail (dest != NULL, FALSE);
	{
		GDir* dir = NULL;
		const gchar* _tmp0_;
		GDir* _tmp1_;
		_tmp0_ = src;
		_tmp1_ = g_dir_open (_tmp0_, (guint) 0, &_inner_error_);
		dir = _tmp1_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			gboolean _tmp2_ = FALSE;
			if (_inner_error_->domain == G_FILE_ERROR) {
				goto __catch1_g_file_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return _tmp2_;
		}
		{
			gchar* file = NULL;
			const gchar* _tmp3_;
			gchar* _tmp4_;
			_tmp3_ = g_dir_read_name (dir);
			_tmp4_ = g_strdup (_tmp3_);
			file = _tmp4_;
			{
				gboolean _tmp5_ = FALSE;
				_tmp5_ = TRUE;
				while (TRUE) {
					const gchar* _tmp8_;
					gchar* src_file_path = NULL;
					const gchar* _tmp9_;
					const gchar* _tmp10_;
					gchar* _tmp11_;
					gchar* dest_file_path = NULL;
					const gchar* _tmp12_;
					const gchar* _tmp13_;
					gchar* _tmp14_;
					const gchar* _tmp15_;
					gboolean _tmp16_;
					if (!_tmp5_) {
						const gchar* _tmp6_;
						gchar* _tmp7_;
						_tmp6_ = g_dir_read_name (dir);
						_tmp7_ = g_strdup (_tmp6_);
						_g_free0 (file);
						file = _tmp7_;
					}
					_tmp5_ = FALSE;
					_tmp8_ = file;
					if (!(_tmp8_ != NULL)) {
						break;
					}
					_tmp9_ = src;
					_tmp10_ = file;
					_tmp11_ = g_build_filename (_tmp9_, _tmp10_, NULL);
					src_file_path = _tmp11_;
					_tmp12_ = dest;
					_tmp13_ = file;
					_tmp14_ = g_build_filename (_tmp12_, _tmp13_, NULL);
					dest_file_path = _tmp14_;
					_tmp15_ = src_file_path;
					_tmp16_ = g_file_test (_tmp15_, G_FILE_TEST_IS_DIR);
					if (_tmp16_) {
						const gchar* _tmp17_;
						const gchar* _tmp18_;
						const gchar* _tmp19_;
						gboolean _tmp20_;
						_tmp17_ = dest_file_path;
						g_mkdir (_tmp17_, 0755);
						_tmp18_ = src_file_path;
						_tmp19_ = dest_file_path;
						_tmp20_ = valadoc_copy_directory (_tmp18_, _tmp19_);
						if (!_tmp20_) {
							result = FALSE;
							_g_free0 (dest_file_path);
							_g_free0 (src_file_path);
							_g_free0 (file);
							_g_dir_close0 (dir);
							return result;
						}
					} else {
						const gchar* _tmp21_;
						const gchar* _tmp22_;
						gboolean _tmp23_;
						_tmp21_ = src_file_path;
						_tmp22_ = dest_file_path;
						_tmp23_ = valadoc_copy_file (_tmp21_, _tmp22_);
						if (!_tmp23_) {
							result = FALSE;
							_g_free0 (dest_file_path);
							_g_free0 (src_file_path);
							_g_free0 (file);
							_g_dir_close0 (dir);
							return result;
						}
					}
					_g_free0 (dest_file_path);
					_g_free0 (src_file_path);
				}
			}
			_g_free0 (file);
		}
		_g_dir_close0 (dir);
	}
	goto __finally1;
	__catch1_g_file_error:
	{
		GError* err = NULL;
		err = _inner_error_;
		_inner_error_ = NULL;
		result = FALSE;
		_g_error_free0 (err);
		return result;
	}
	__finally1:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		gboolean _tmp24_ = FALSE;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return _tmp24_;
	}
	result = TRUE;
	return result;
}


/**
 * A recursive directory delete function
 *
 * @param rpath the directory to remove
 */
gboolean valadoc_remove_directory (const gchar* rpath) {
	gboolean result = FALSE;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (rpath != NULL, FALSE);
	{
		GDir* dir = NULL;
		const gchar* _tmp0_;
		GDir* _tmp1_;
		GDir* _tmp3_;
		_tmp0_ = rpath;
		_tmp1_ = g_dir_open (_tmp0_, (guint) 0, &_inner_error_);
		dir = _tmp1_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			gboolean _tmp2_ = FALSE;
			if (_inner_error_->domain == G_FILE_ERROR) {
				goto __catch2_g_file_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return _tmp2_;
		}
		_tmp3_ = dir;
		if (_tmp3_ == NULL) {
			result = FALSE;
			_g_dir_close0 (dir);
			return result;
		}
		{
			const gchar* entry = NULL;
			GDir* _tmp4_;
			const gchar* _tmp5_;
			_tmp4_ = dir;
			_tmp5_ = g_dir_read_name (_tmp4_);
			entry = _tmp5_;
			{
				gboolean _tmp6_ = FALSE;
				_tmp6_ = TRUE;
				while (TRUE) {
					const gchar* _tmp9_;
					gchar* path = NULL;
					const gchar* _tmp10_;
					const gchar* _tmp11_;
					gchar* _tmp12_;
					gboolean is_dir = FALSE;
					const gchar* _tmp13_;
					gboolean _tmp14_;
					gboolean _tmp15_;
					if (!_tmp6_) {
						GDir* _tmp7_;
						const gchar* _tmp8_;
						_tmp7_ = dir;
						_tmp8_ = g_dir_read_name (_tmp7_);
						entry = _tmp8_;
					}
					_tmp6_ = FALSE;
					_tmp9_ = entry;
					if (!(_tmp9_ != NULL)) {
						break;
					}
					_tmp10_ = rpath;
					_tmp11_ = entry;
					_tmp12_ = g_strconcat (_tmp10_, _tmp11_, NULL);
					path = _tmp12_;
					_tmp13_ = path;
					_tmp14_ = g_file_test (_tmp13_, G_FILE_TEST_IS_DIR);
					is_dir = _tmp14_;
					_tmp15_ = is_dir;
					if (_tmp15_ == TRUE) {
						gboolean tmp = FALSE;
						const gchar* _tmp16_;
						gboolean _tmp17_;
						gboolean _tmp18_;
						_tmp16_ = path;
						_tmp17_ = valadoc_remove_directory (_tmp16_);
						tmp = _tmp17_;
						_tmp18_ = tmp;
						if (_tmp18_ == FALSE) {
							result = FALSE;
							_g_free0 (path);
							_g_dir_close0 (dir);
							return result;
						}
					} else {
						gint tmp = 0;
						const gchar* _tmp19_;
						gint _tmp20_;
						gint _tmp21_;
						_tmp19_ = path;
						_tmp20_ = g_unlink (_tmp19_);
						tmp = _tmp20_;
						_tmp21_ = tmp;
						if (_tmp21_ > 0) {
							result = FALSE;
							_g_free0 (path);
							_g_dir_close0 (dir);
							return result;
						}
					}
					_g_free0 (path);
				}
			}
		}
		_g_dir_close0 (dir);
	}
	goto __finally2;
	__catch2_g_file_error:
	{
		GError* err = NULL;
		err = _inner_error_;
		_inner_error_ = NULL;
		result = FALSE;
		_g_error_free0 (err);
		return result;
	}
	__finally2:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		gboolean _tmp22_ = FALSE;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return _tmp22_;
	}
	result = TRUE;
	return result;
}


static gunichar string_get_char (const gchar* self, glong index) {
	gunichar result = 0U;
	glong _tmp0_;
	gunichar _tmp1_;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = index;
	_tmp1_ = g_utf8_get_char (((gchar*) self) + _tmp0_);
	result = _tmp1_;
	return result;
}


G_GNUC_INTERNAL inline gboolean valadoc_ends_with_dir_separator (const gchar* s) {
	gboolean result = FALSE;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gunichar _tmp4_;
	gboolean _tmp5_;
	g_return_val_if_fail (s != NULL, FALSE);
	_tmp0_ = s;
	_tmp1_ = s;
	_tmp2_ = strlen (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = string_get_char (_tmp0_, (glong) (_tmp3_ - 1));
	_tmp5_ = G_IS_DIR_SEPARATOR (_tmp4_);
	result = _tmp5_;
	return result;
}


/**
 * Returns canonicalized absolute pathname
 *
 * @param name the path being checked
 * @return a canonicalized absolute pathname
 */
static glong string_strnlen (gchar* str, glong maxlen) {
	glong result = 0L;
	gchar* end = NULL;
	gchar* _tmp0_;
	glong _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	_tmp0_ = str;
	_tmp1_ = maxlen;
	_tmp2_ = memchr (_tmp0_, 0, (gsize) _tmp1_);
	end = _tmp2_;
	_tmp3_ = end;
	if (_tmp3_ == NULL) {
		glong _tmp4_;
		_tmp4_ = maxlen;
		result = _tmp4_;
		return result;
	} else {
		gchar* _tmp5_;
		gchar* _tmp6_;
		_tmp5_ = end;
		_tmp6_ = str;
		result = (glong) (_tmp5_ - _tmp6_);
		return result;
	}
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp1_;
	glong _tmp8_;
	glong _tmp14_;
	glong _tmp17_;
	glong _tmp18_;
	glong _tmp19_;
	glong _tmp20_;
	glong _tmp21_;
	gchar* _tmp22_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = offset;
	if (_tmp1_ >= ((glong) 0)) {
		glong _tmp2_;
		_tmp2_ = len;
		_tmp0_ = _tmp2_ >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		glong _tmp3_;
		glong _tmp4_;
		glong _tmp5_;
		_tmp3_ = offset;
		_tmp4_ = len;
		_tmp5_ = string_strnlen ((gchar*) self, _tmp3_ + _tmp4_);
		string_length = _tmp5_;
	} else {
		gint _tmp6_;
		gint _tmp7_;
		_tmp6_ = strlen (self);
		_tmp7_ = _tmp6_;
		string_length = (glong) _tmp7_;
	}
	_tmp8_ = offset;
	if (_tmp8_ < ((glong) 0)) {
		glong _tmp9_;
		glong _tmp10_;
		glong _tmp11_;
		_tmp9_ = string_length;
		_tmp10_ = offset;
		offset = _tmp9_ + _tmp10_;
		_tmp11_ = offset;
		g_return_val_if_fail (_tmp11_ >= ((glong) 0), NULL);
	} else {
		glong _tmp12_;
		glong _tmp13_;
		_tmp12_ = offset;
		_tmp13_ = string_length;
		g_return_val_if_fail (_tmp12_ <= _tmp13_, NULL);
	}
	_tmp14_ = len;
	if (_tmp14_ < ((glong) 0)) {
		glong _tmp15_;
		glong _tmp16_;
		_tmp15_ = string_length;
		_tmp16_ = offset;
		len = _tmp15_ - _tmp16_;
	}
	_tmp17_ = offset;
	_tmp18_ = len;
	_tmp19_ = string_length;
	g_return_val_if_fail ((_tmp17_ + _tmp18_) <= _tmp19_, NULL);
	_tmp20_ = offset;
	_tmp21_ = len;
	_tmp22_ = g_strndup (((gchar*) self) + _tmp20_, (gsize) _tmp21_);
	result = _tmp22_;
	return result;
}


static gchar* _vala_g_strjoinv (const gchar* separator, gchar** str_array, int str_array_length1) {
	gchar* result = NULL;
	const gchar* _tmp0_;
	gboolean _tmp1_ = FALSE;
	gchar** _tmp2_;
	gint _tmp2__length1;
	_tmp0_ = separator;
	if (_tmp0_ == NULL) {
		separator = "";
	}
	_tmp2_ = str_array;
	_tmp2__length1 = str_array_length1;
	if (_tmp2_ != NULL) {
		gboolean _tmp3_ = FALSE;
		gchar** _tmp4_;
		gint _tmp4__length1;
		_tmp4_ = str_array;
		_tmp4__length1 = str_array_length1;
		if (_tmp4__length1 > 0) {
			_tmp3_ = TRUE;
		} else {
			gboolean _tmp5_ = FALSE;
			gchar** _tmp6_;
			gint _tmp6__length1;
			_tmp6_ = str_array;
			_tmp6__length1 = str_array_length1;
			if (_tmp6__length1 == -1) {
				gchar** _tmp7_;
				gint _tmp7__length1;
				const gchar* _tmp8_;
				_tmp7_ = str_array;
				_tmp7__length1 = str_array_length1;
				_tmp8_ = _tmp7_[0];
				_tmp5_ = _tmp8_ != NULL;
			} else {
				_tmp5_ = FALSE;
			}
			_tmp3_ = _tmp5_;
		}
		_tmp1_ = _tmp3_;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		gint i = 0;
		gsize len = 0UL;
		gint _tmp31_;
		gint _tmp33_;
		gint _tmp34_;
		gsize _tmp35_;
		const gchar* _tmp36_;
		gint _tmp37_;
		gint _tmp38_;
		gint _tmp39_;
		const gchar* res = NULL;
		gsize _tmp40_;
		void* _tmp41_;
		void* ptr = NULL;
		const gchar* _tmp42_;
		gchar** _tmp43_;
		gint _tmp43__length1;
		const gchar* _tmp44_;
		void* _tmp45_;
		const gchar* _tmp62_;
		len = (gsize) 1;
		{
			gboolean _tmp9_ = FALSE;
			i = 0;
			_tmp9_ = TRUE;
			while (TRUE) {
				gboolean _tmp11_ = FALSE;
				gboolean _tmp12_ = FALSE;
				gchar** _tmp13_;
				gint _tmp13__length1;
				gint _tmp21_ = 0;
				gchar** _tmp22_;
				gint _tmp22__length1;
				gint _tmp23_;
				const gchar* _tmp24_;
				gsize _tmp30_;
				if (!_tmp9_) {
					gint _tmp10_;
					_tmp10_ = i;
					i = _tmp10_ + 1;
				}
				_tmp9_ = FALSE;
				_tmp13_ = str_array;
				_tmp13__length1 = str_array_length1;
				if (_tmp13__length1 != -1) {
					gint _tmp14_;
					gchar** _tmp15_;
					gint _tmp15__length1;
					_tmp14_ = i;
					_tmp15_ = str_array;
					_tmp15__length1 = str_array_length1;
					_tmp12_ = _tmp14_ < _tmp15__length1;
				} else {
					_tmp12_ = FALSE;
				}
				if (_tmp12_) {
					_tmp11_ = TRUE;
				} else {
					gboolean _tmp16_ = FALSE;
					gchar** _tmp17_;
					gint _tmp17__length1;
					_tmp17_ = str_array;
					_tmp17__length1 = str_array_length1;
					if (_tmp17__length1 == -1) {
						gchar** _tmp18_;
						gint _tmp18__length1;
						gint _tmp19_;
						const gchar* _tmp20_;
						_tmp18_ = str_array;
						_tmp18__length1 = str_array_length1;
						_tmp19_ = i;
						_tmp20_ = _tmp18_[_tmp19_];
						_tmp16_ = _tmp20_ != NULL;
					} else {
						_tmp16_ = FALSE;
					}
					_tmp11_ = _tmp16_;
				}
				if (!_tmp11_) {
					break;
				}
				_tmp22_ = str_array;
				_tmp22__length1 = str_array_length1;
				_tmp23_ = i;
				_tmp24_ = _tmp22_[_tmp23_];
				if (_tmp24_ != NULL) {
					gchar** _tmp25_;
					gint _tmp25__length1;
					gint _tmp26_;
					const gchar* _tmp27_;
					gint _tmp28_;
					gint _tmp29_;
					_tmp25_ = str_array;
					_tmp25__length1 = str_array_length1;
					_tmp26_ = i;
					_tmp27_ = _tmp25_[_tmp26_];
					_tmp28_ = strlen ((const gchar*) _tmp27_);
					_tmp29_ = _tmp28_;
					_tmp21_ = _tmp29_;
				} else {
					_tmp21_ = 0;
				}
				_tmp30_ = len;
				len = _tmp30_ + _tmp21_;
			}
		}
		_tmp31_ = i;
		if (_tmp31_ == 0) {
			gchar* _tmp32_;
			_tmp32_ = g_strdup ("");
			result = _tmp32_;
			return result;
		}
		_tmp33_ = i;
		str_array_length1 = _tmp33_;
		_tmp34_ = str_array_length1;
		_tmp35_ = len;
		_tmp36_ = separator;
		_tmp37_ = strlen ((const gchar*) _tmp36_);
		_tmp38_ = _tmp37_;
		_tmp39_ = i;
		len = _tmp35_ + (_tmp38_ * (_tmp39_ - 1));
		_tmp40_ = len;
		_tmp41_ = g_malloc (_tmp40_);
		res = _tmp41_;
		_tmp42_ = res;
		_tmp43_ = str_array;
		_tmp43__length1 = str_array_length1;
		_tmp44_ = _tmp43_[0];
		_tmp45_ = g_stpcpy ((void*) _tmp42_, (const gchar*) _tmp44_);
		ptr = _tmp45_;
		{
			gboolean _tmp46_ = FALSE;
			i = 1;
			_tmp46_ = TRUE;
			while (TRUE) {
				gint _tmp48_;
				gchar** _tmp49_;
				gint _tmp49__length1;
				void* _tmp50_;
				const gchar* _tmp51_;
				void* _tmp52_;
				const gchar* _tmp53_ = NULL;
				gchar** _tmp54_;
				gint _tmp54__length1;
				gint _tmp55_;
				const gchar* _tmp56_;
				void* _tmp60_;
				void* _tmp61_;
				if (!_tmp46_) {
					gint _tmp47_;
					_tmp47_ = i;
					i = _tmp47_ + 1;
				}
				_tmp46_ = FALSE;
				_tmp48_ = i;
				_tmp49_ = str_array;
				_tmp49__length1 = str_array_length1;
				if (!(_tmp48_ < _tmp49__length1)) {
					break;
				}
				_tmp50_ = ptr;
				_tmp51_ = separator;
				_tmp52_ = g_stpcpy (_tmp50_, (const gchar*) _tmp51_);
				ptr = _tmp52_;
				_tmp54_ = str_array;
				_tmp54__length1 = str_array_length1;
				_tmp55_ = i;
				_tmp56_ = _tmp54_[_tmp55_];
				if (_tmp56_ != NULL) {
					gchar** _tmp57_;
					gint _tmp57__length1;
					gint _tmp58_;
					const gchar* _tmp59_;
					_tmp57_ = str_array;
					_tmp57__length1 = str_array_length1;
					_tmp58_ = i;
					_tmp59_ = _tmp57_[_tmp58_];
					_tmp53_ = (const gchar*) _tmp59_;
				} else {
					_tmp53_ = "";
				}
				_tmp60_ = ptr;
				_tmp61_ = g_stpcpy (_tmp60_, _tmp53_);
				ptr = _tmp61_;
			}
		}
		_tmp62_ = res;
		res = NULL;
		result = (gchar*) _tmp62_;
		return result;
	} else {
		gchar* _tmp63_;
		_tmp63_ = g_strdup ("");
		result = _tmp63_;
		return result;
	}
}


gchar* valadoc_realpath (const gchar* name) {
	gchar* result = NULL;
	gchar* rpath = NULL;
	const gchar* start = NULL;
	const gchar* end = NULL;
	const gchar* _tmp0_;
	gboolean _tmp1_;
	glong root_len = 0L;
	const gchar* _tmp12_;
	const gchar* _tmp13_;
	const gchar* _tmp14_;
	gboolean _tmp66_ = FALSE;
	const gchar* _tmp67_;
	gint _tmp68_;
	gint _tmp69_;
	glong _tmp70_;
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = name;
	_tmp1_ = g_path_is_absolute (_tmp0_);
	if (!_tmp1_) {
		gchar* _tmp2_;
		const gchar* _tmp3_;
		const gchar* _tmp4_;
		_tmp2_ = g_get_current_dir ();
		_g_free0 (rpath);
		rpath = _tmp2_;
		_tmp3_ = name;
		end = _tmp3_;
		_tmp4_ = end;
		start = _tmp4_;
	} else {
		const gchar* _tmp5_;
		const gchar* _tmp6_;
		const gchar* _tmp7_;
		const gchar* _tmp8_;
		const gchar* _tmp9_;
		const gchar* _tmp10_;
		gchar* _tmp11_;
		_tmp5_ = name;
		_tmp6_ = g_path_skip_root (_tmp5_);
		end = _tmp6_;
		_tmp7_ = end;
		start = _tmp7_;
		_tmp8_ = name;
		_tmp9_ = start;
		_tmp10_ = name;
		_tmp11_ = string_substring (_tmp8_, (glong) 0, (glong) ((gint) (((gchar*) _tmp9_) - ((gchar*) _tmp10_))));
		_g_free0 (rpath);
		rpath = _tmp11_;
	}
	_tmp12_ = rpath;
	_tmp13_ = g_path_skip_root (_tmp12_);
	_tmp14_ = rpath;
	root_len = (glong) (((gchar*) _tmp13_) - ((gchar*) _tmp14_));
	{
		gboolean _tmp15_ = FALSE;
		_tmp15_ = TRUE;
		while (TRUE) {
			const gchar* _tmp17_;
			gunichar _tmp18_;
			glong len = 0L;
			glong _tmp35_;
			if (!_tmp15_) {
				const gchar* _tmp16_;
				_tmp16_ = end;
				start = _tmp16_;
			}
			_tmp15_ = FALSE;
			_tmp17_ = start;
			_tmp18_ = string_get_char (_tmp17_, (glong) 0);
			if (!(_tmp18_ != ((gunichar) 0))) {
				break;
			}
			while (TRUE) {
				const gchar* _tmp19_;
				gunichar _tmp20_;
				gboolean _tmp21_;
				const gchar* _tmp22_;
				const gchar* _tmp23_;
				_tmp19_ = start;
				_tmp20_ = string_get_char (_tmp19_, (glong) 0);
				_tmp21_ = G_IS_DIR_SEPARATOR (_tmp20_);
				if (!_tmp21_) {
					break;
				}
				_tmp22_ = start;
				_tmp23_ = g_utf8_next_char (_tmp22_);
				start = _tmp23_;
			}
			len = (glong) 0;
			{
				const gchar* _tmp24_;
				gboolean _tmp25_ = FALSE;
				_tmp24_ = start;
				end = _tmp24_;
				_tmp25_ = TRUE;
				while (TRUE) {
					gboolean _tmp28_ = FALSE;
					const gchar* _tmp29_;
					gunichar _tmp30_;
					glong _tmp34_;
					if (!_tmp25_) {
						const gchar* _tmp26_;
						const gchar* _tmp27_;
						_tmp26_ = end;
						_tmp27_ = g_utf8_next_char (_tmp26_);
						end = _tmp27_;
					}
					_tmp25_ = FALSE;
					_tmp29_ = end;
					_tmp30_ = string_get_char (_tmp29_, (glong) 0);
					if (_tmp30_ != ((gunichar) 0)) {
						const gchar* _tmp31_;
						gunichar _tmp32_;
						gboolean _tmp33_;
						_tmp31_ = end;
						_tmp32_ = string_get_char (_tmp31_, (glong) 0);
						_tmp33_ = G_IS_DIR_SEPARATOR (_tmp32_);
						_tmp28_ = !_tmp33_;
					} else {
						_tmp28_ = FALSE;
					}
					if (!_tmp28_) {
						break;
					}
					_tmp34_ = len;
					len = _tmp34_ + 1;
				}
			}
			_tmp35_ = len;
			if (_tmp35_ == ((glong) 0)) {
				break;
			} else {
				gboolean _tmp36_ = FALSE;
				glong _tmp37_;
				_tmp37_ = len;
				if (_tmp37_ == ((glong) 1)) {
					const gchar* _tmp38_;
					gunichar _tmp39_;
					_tmp38_ = start;
					_tmp39_ = string_get_char (_tmp38_, (glong) 0);
					_tmp36_ = _tmp39_ == ((gunichar) '.');
				} else {
					_tmp36_ = FALSE;
				}
				if (_tmp36_) {
				} else {
					gboolean _tmp40_ = FALSE;
					glong _tmp41_;
					_tmp41_ = len;
					if (_tmp41_ == ((glong) 2)) {
						const gchar* _tmp42_;
						gboolean _tmp43_;
						_tmp42_ = start;
						_tmp43_ = g_str_has_prefix (_tmp42_, "..");
						_tmp40_ = _tmp43_;
					} else {
						_tmp40_ = FALSE;
					}
					if (_tmp40_) {
						const gchar* _tmp44_;
						gint _tmp45_;
						gint _tmp46_;
						glong _tmp47_;
						_tmp44_ = rpath;
						_tmp45_ = strlen (_tmp44_);
						_tmp46_ = _tmp45_;
						_tmp47_ = root_len;
						if (((glong) _tmp46_) > _tmp47_) {
							{
								gboolean _tmp48_ = FALSE;
								_tmp48_ = TRUE;
								while (TRUE) {
									const gchar* _tmp51_;
									const gchar* _tmp52_;
									gint _tmp53_;
									gint _tmp54_;
									gchar* _tmp55_;
									if (!_tmp48_) {
										const gchar* _tmp49_;
										gboolean _tmp50_;
										_tmp49_ = rpath;
										_tmp50_ = valadoc_ends_with_dir_separator (_tmp49_);
										if (!(!_tmp50_)) {
											break;
										}
									}
									_tmp48_ = FALSE;
									_tmp51_ = rpath;
									_tmp52_ = rpath;
									_tmp53_ = strlen (_tmp52_);
									_tmp54_ = _tmp53_;
									_tmp55_ = string_substring (_tmp51_, (glong) 0, (glong) (_tmp54_ - 1));
									_g_free0 (rpath);
									rpath = _tmp55_;
								}
							}
						}
					} else {
						const gchar* _tmp56_;
						gboolean _tmp57_;
						const gchar* _tmp60_;
						const gchar* _tmp61_;
						glong _tmp62_;
						gchar* _tmp63_;
						gchar* _tmp64_;
						gchar* _tmp65_;
						_tmp56_ = rpath;
						_tmp57_ = valadoc_ends_with_dir_separator (_tmp56_);
						if (!_tmp57_) {
							const gchar* _tmp58_;
							gchar* _tmp59_;
							_tmp58_ = rpath;
							_tmp59_ = g_strconcat (_tmp58_, G_DIR_SEPARATOR_S, NULL);
							_g_free0 (rpath);
							rpath = _tmp59_;
						}
						_tmp60_ = rpath;
						_tmp61_ = start;
						_tmp62_ = len;
						_tmp63_ = string_substring (_tmp61_, (glong) 0, _tmp62_);
						_tmp64_ = _tmp63_;
						_tmp65_ = g_strconcat (_tmp60_, _tmp64_, NULL);
						_g_free0 (rpath);
						rpath = _tmp65_;
						_g_free0 (_tmp64_);
					}
				}
			}
		}
	}
	_tmp67_ = rpath;
	_tmp68_ = strlen (_tmp67_);
	_tmp69_ = _tmp68_;
	_tmp70_ = root_len;
	if (((glong) _tmp69_) > _tmp70_) {
		const gchar* _tmp71_;
		gboolean _tmp72_;
		_tmp71_ = rpath;
		_tmp72_ = valadoc_ends_with_dir_separator (_tmp71_);
		_tmp66_ = _tmp72_;
	} else {
		_tmp66_ = FALSE;
	}
	if (_tmp66_) {
		const gchar* _tmp73_;
		const gchar* _tmp74_;
		gint _tmp75_;
		gint _tmp76_;
		gchar* _tmp77_;
		_tmp73_ = rpath;
		_tmp74_ = rpath;
		_tmp75_ = strlen (_tmp74_);
		_tmp76_ = _tmp75_;
		_tmp77_ = string_substring (_tmp73_, (glong) 0, (glong) (_tmp76_ - 1));
		_g_free0 (rpath);
		rpath = _tmp77_;
	}
	if (G_DIR_SEPARATOR != '/') {
		gchar** components = NULL;
		const gchar* _tmp78_;
		gchar** _tmp79_;
		gchar** _tmp80_;
		gint components_length1;
		gint _components_size_;
		gchar** _tmp81_;
		gint _tmp81__length1;
		gchar* _tmp82_;
		_tmp78_ = rpath;
		_tmp80_ = _tmp79_ = g_strsplit (_tmp78_, "\\", 0);
		components = _tmp80_;
		components_length1 = _vala_array_length (_tmp79_);
		_components_size_ = components_length1;
		_tmp81_ = components;
		_tmp81__length1 = components_length1;
		_tmp82_ = _vala_g_strjoinv ("/", _tmp81_, _tmp81__length1);
		_g_free0 (rpath);
		rpath = _tmp82_;
		components = (_vala_array_free (components, components_length1, (GDestroyNotify) g_free), NULL);
	}
	result = rpath;
	return result;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



