/* wiki.c generated by valac, the Vala compiler
 * generated from wiki.vala, do not modify */

/* wiki.vala
 *
 * Copyright (C) 2008-2009 Florian Brosch
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Florian Brosch <flo.brosch@gmail.com>
 */

#include <glib.h>
#include <glib-object.h>
#include "valadoc.h"
#include <stdlib.h>
#include <string.h>
#include <glib/gstdio.h>
#include <valagee.h>

enum  {
	VALADOC_WIKI_PAGE_0_PROPERTY,
	VALADOC_WIKI_PAGE_DOCUMENTATION_PROPERTY,
	VALADOC_WIKI_PAGE_DOCUMENTATION_STR_PROPERTY,
	VALADOC_WIKI_PAGE_PATH_PROPERTY,
	VALADOC_WIKI_PAGE_NAME_PROPERTY,
	VALADOC_WIKI_PAGE_PACKAGE_PROPERTY,
	VALADOC_WIKI_PAGE_NUM_PROPERTIES
};
static GParamSpec* valadoc_wiki_page_properties[VALADOC_WIKI_PAGE_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
enum  {
	VALADOC_WIKI_PAGE_TREE_0_PROPERTY,
	VALADOC_WIKI_PAGE_TREE_NUM_PROPERTIES
};
static GParamSpec* valadoc_wiki_page_tree_properties[VALADOC_WIKI_PAGE_TREE_NUM_PROPERTIES];
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _g_dir_close0(var) ((var == NULL) ? NULL : (var = (g_dir_close (var), NULL)))

struct _ValadocWikiPagePrivate {
	ValadocContentPage* _documentation;
	gchar* _documentation_str;
	gchar* _path;
	gchar* _name;
	ValadocApiPackage* _package;
};

struct _ValadocWikiPageTreePrivate {
	ValaArrayList* wikipages;
};


static gpointer valadoc_wiki_page_parent_class = NULL;
static ValadocDocumentationIface * valadoc_wiki_page_valadoc_documentation_parent_iface = NULL;
static gpointer valadoc_wiki_page_tree_parent_class = NULL;

#define VALADOC_WIKI_PAGE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALADOC_TYPE_WIKI_PAGE, ValadocWikiPagePrivate))
static gchar* valadoc_wiki_page_real_get_filename (ValadocDocumentation* base);
static void valadoc_wiki_page_set_name (ValadocWikiPage* self, const gchar* value);
static void valadoc_wiki_page_set_path (ValadocWikiPage* self, const gchar* value);
static void valadoc_wiki_page_set_documentation_str (ValadocWikiPage* self, const gchar* value);
static void valadoc_wiki_page_finalize (GObject * obj);
static void _vala_valadoc_wiki_page_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_valadoc_wiki_page_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
#define VALADOC_WIKI_PAGE_TREE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALADOC_TYPE_WIKI_PAGE_TREE, ValadocWikiPageTreePrivate))
static void valadoc_wiki_page_tree_create_tree_from_path (ValadocWikiPageTree* self, ValadocDocumentationParser* docparser, ValadocApiPackage* package, ValadocErrorReporter* reporter, const gchar* path, const gchar* nameoffset);
static void valadoc_wiki_page_tree_finalize (GObject * obj);


/**
 * The corresponding file name
 */
static gchar* valadoc_wiki_page_real_get_filename (ValadocDocumentation* base) {
	ValadocWikiPage * self;
	gchar* result = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	self = (ValadocWikiPage*) base;
	_tmp0_ = self->priv->_path;
	_tmp1_ = g_path_get_basename (_tmp0_);
	result = _tmp1_;
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


ValadocWikiPage* valadoc_wiki_page_construct (GType object_type, const gchar* name, const gchar* path, ValadocApiPackage* package) {
	ValadocWikiPage * self = NULL;
	ValadocApiPackage* _tmp0_;
	ValadocApiPackage* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	g_return_val_if_fail (name != NULL, NULL);
	g_return_val_if_fail (path != NULL, NULL);
	g_return_val_if_fail (package != NULL, NULL);
	self = (ValadocWikiPage*) g_object_new (object_type, NULL);
	_tmp0_ = package;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_package);
	self->priv->_package = _tmp1_;
	_tmp2_ = name;
	valadoc_wiki_page_set_name (self, _tmp2_);
	_tmp3_ = path;
	valadoc_wiki_page_set_path (self, _tmp3_);
	return self;
}


ValadocWikiPage* valadoc_wiki_page_new (const gchar* name, const gchar* path, ValadocApiPackage* package) {
	return valadoc_wiki_page_construct (VALADOC_TYPE_WIKI_PAGE, name, path, package);
}


void valadoc_wiki_page_read (ValadocWikiPage* self, ValadocErrorReporter* reporter) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (reporter != NULL);
	{
		gchar* content = NULL;
		const gchar* _tmp0_;
		gchar* _tmp1_ = NULL;
		_tmp0_ = self->priv->_path;
		g_file_get_contents (_tmp0_, &_tmp1_, NULL, &_inner_error_);
		_g_free0 (content);
		content = _tmp1_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_free0 (content);
			if (_inner_error_->domain == G_FILE_ERROR) {
				goto __catch8_g_file_error;
			}
			_g_free0 (content);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		valadoc_wiki_page_set_documentation_str (self, content);
		_g_free0 (content);
	}
	goto __finally8;
	__catch8_g_file_error:
	{
		GError* err = NULL;
		ValadocErrorReporter* _tmp2_;
		const gchar* _tmp3_;
		GError* _tmp4_;
		const gchar* _tmp5_;
		err = _inner_error_;
		_inner_error_ = NULL;
		_tmp2_ = reporter;
		_tmp3_ = self->priv->_path;
		_tmp4_ = err;
		_tmp5_ = _tmp4_->message;
		valadoc_error_reporter_simple_error (_tmp2_, NULL, "Unable to read file '%s': %s", _tmp3_, _tmp5_);
		_g_error_free0 (err);
	}
	__finally8:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


void valadoc_wiki_page_parse (ValadocWikiPage* self, ValadocDocumentationParser* docparser, ValadocApiPackage* pkg) {
	ValadocDocumentationParser* _tmp0_;
	ValadocApiPackage* _tmp1_;
	ValadocContentPage* _tmp2_;
	ValadocContentPage* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (docparser != NULL);
	g_return_if_fail (pkg != NULL);
	_tmp0_ = docparser;
	_tmp1_ = pkg;
	_tmp2_ = valadoc_documentation_parser_parse_wikipage (_tmp0_, _tmp1_, self);
	_tmp3_ = _tmp2_;
	valadoc_wiki_page_set_documentation (self, _tmp3_);
	_g_object_unref0 (_tmp3_);
}


ValadocContentPage* valadoc_wiki_page_get_documentation (ValadocWikiPage* self) {
	ValadocContentPage* result;
	ValadocContentPage* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_documentation;
	result = _tmp0_;
	return result;
}


void valadoc_wiki_page_set_documentation (ValadocWikiPage* self, ValadocContentPage* value) {
	g_return_if_fail (self != NULL);
	if (valadoc_wiki_page_get_documentation (self) != value) {
		ValadocContentPage* _tmp0_;
		ValadocContentPage* _tmp1_;
		_tmp0_ = value;
		_tmp1_ = _g_object_ref0 (_tmp0_);
		_g_object_unref0 (self->priv->_documentation);
		self->priv->_documentation = _tmp1_;
		g_object_notify_by_pspec ((GObject *) self, valadoc_wiki_page_properties[VALADOC_WIKI_PAGE_DOCUMENTATION_PROPERTY]);
	}
}


const gchar* valadoc_wiki_page_get_documentation_str (ValadocWikiPage* self) {
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_documentation_str;
	result = _tmp0_;
	return result;
}


static void valadoc_wiki_page_set_documentation_str (ValadocWikiPage* self, const gchar* value) {
	g_return_if_fail (self != NULL);
	if (g_strcmp0 (value, valadoc_wiki_page_get_documentation_str (self)) != 0) {
		const gchar* _tmp0_;
		gchar* _tmp1_;
		_tmp0_ = value;
		_tmp1_ = g_strdup (_tmp0_);
		_g_free0 (self->priv->_documentation_str);
		self->priv->_documentation_str = _tmp1_;
		g_object_notify_by_pspec ((GObject *) self, valadoc_wiki_page_properties[VALADOC_WIKI_PAGE_DOCUMENTATION_STR_PROPERTY]);
	}
}


const gchar* valadoc_wiki_page_get_path (ValadocWikiPage* self) {
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_path;
	result = _tmp0_;
	return result;
}


static void valadoc_wiki_page_set_path (ValadocWikiPage* self, const gchar* value) {
	g_return_if_fail (self != NULL);
	if (g_strcmp0 (value, valadoc_wiki_page_get_path (self)) != 0) {
		const gchar* _tmp0_;
		gchar* _tmp1_;
		_tmp0_ = value;
		_tmp1_ = g_strdup (_tmp0_);
		_g_free0 (self->priv->_path);
		self->priv->_path = _tmp1_;
		g_object_notify_by_pspec ((GObject *) self, valadoc_wiki_page_properties[VALADOC_WIKI_PAGE_PATH_PROPERTY]);
	}
}


const gchar* valadoc_wiki_page_get_name (ValadocWikiPage* self) {
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_name;
	result = _tmp0_;
	return result;
}


static void valadoc_wiki_page_set_name (ValadocWikiPage* self, const gchar* value) {
	g_return_if_fail (self != NULL);
	if (g_strcmp0 (value, valadoc_wiki_page_get_name (self)) != 0) {
		const gchar* _tmp0_;
		gchar* _tmp1_;
		_tmp0_ = value;
		_tmp1_ = g_strdup (_tmp0_);
		_g_free0 (self->priv->_name);
		self->priv->_name = _tmp1_;
		g_object_notify_by_pspec ((GObject *) self, valadoc_wiki_page_properties[VALADOC_WIKI_PAGE_NAME_PROPERTY]);
	}
}


static ValadocApiPackage* valadoc_wiki_page_real_get_package (ValadocDocumentation* base) {
	ValadocApiPackage* result;
	ValadocWikiPage* self;
	ValadocApiPackage* _tmp0_;
	self = (ValadocWikiPage*) base;
	_tmp0_ = self->priv->_package;
	result = _tmp0_;
	return result;
}


static void valadoc_wiki_page_class_init (ValadocWikiPageClass * klass) {
	valadoc_wiki_page_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ValadocWikiPagePrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_valadoc_wiki_page_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_valadoc_wiki_page_set_property;
	G_OBJECT_CLASS (klass)->finalize = valadoc_wiki_page_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALADOC_WIKI_PAGE_DOCUMENTATION_PROPERTY, valadoc_wiki_page_properties[VALADOC_WIKI_PAGE_DOCUMENTATION_PROPERTY] = g_param_spec_object ("documentation", "documentation", "documentation", VALADOC_CONTENT_TYPE_PAGE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALADOC_WIKI_PAGE_DOCUMENTATION_STR_PROPERTY, valadoc_wiki_page_properties[VALADOC_WIKI_PAGE_DOCUMENTATION_STR_PROPERTY] = g_param_spec_string ("documentation-str", "documentation-str", "documentation-str", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALADOC_WIKI_PAGE_PATH_PROPERTY, valadoc_wiki_page_properties[VALADOC_WIKI_PAGE_PATH_PROPERTY] = g_param_spec_string ("path", "path", "path", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALADOC_WIKI_PAGE_NAME_PROPERTY, valadoc_wiki_page_properties[VALADOC_WIKI_PAGE_NAME_PROPERTY] = g_param_spec_string ("name", "name", "name", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALADOC_WIKI_PAGE_PACKAGE_PROPERTY, valadoc_wiki_page_properties[VALADOC_WIKI_PAGE_PACKAGE_PROPERTY] = g_param_spec_object ("package", "package", "package", VALADOC_API_TYPE_PACKAGE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
}


static void valadoc_wiki_page_valadoc_documentation_interface_init (ValadocDocumentationIface * iface) {
	valadoc_wiki_page_valadoc_documentation_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_filename = (gchar* (*) (ValadocDocumentation *)) valadoc_wiki_page_real_get_filename;
	iface->get_package = valadoc_wiki_page_real_get_package;
}


static void valadoc_wiki_page_instance_init (ValadocWikiPage * self) {
	self->priv = VALADOC_WIKI_PAGE_GET_PRIVATE (self);
}


static void valadoc_wiki_page_finalize (GObject * obj) {
	ValadocWikiPage * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALADOC_TYPE_WIKI_PAGE, ValadocWikiPage);
	_g_object_unref0 (self->priv->_documentation);
	_g_free0 (self->priv->_documentation_str);
	_g_free0 (self->priv->_path);
	_g_free0 (self->priv->_name);
	_g_object_unref0 (self->priv->_package);
	G_OBJECT_CLASS (valadoc_wiki_page_parent_class)->finalize (obj);
}


GType valadoc_wiki_page_get_type (void) {
	static volatile gsize valadoc_wiki_page_type_id__volatile = 0;
	if (g_once_init_enter (&valadoc_wiki_page_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValadocWikiPageClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) valadoc_wiki_page_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValadocWikiPage), 0, (GInstanceInitFunc) valadoc_wiki_page_instance_init, NULL };
		static const GInterfaceInfo valadoc_documentation_info = { (GInterfaceInitFunc) valadoc_wiki_page_valadoc_documentation_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType valadoc_wiki_page_type_id;
		valadoc_wiki_page_type_id = g_type_register_static (G_TYPE_OBJECT, "ValadocWikiPage", &g_define_type_info, 0);
		g_type_add_interface_static (valadoc_wiki_page_type_id, VALADOC_TYPE_DOCUMENTATION, &valadoc_documentation_info);
		g_once_init_leave (&valadoc_wiki_page_type_id__volatile, valadoc_wiki_page_type_id);
	}
	return valadoc_wiki_page_type_id__volatile;
}


static void _vala_valadoc_wiki_page_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	ValadocWikiPage * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, VALADOC_TYPE_WIKI_PAGE, ValadocWikiPage);
	switch (property_id) {
		case VALADOC_WIKI_PAGE_DOCUMENTATION_PROPERTY:
		g_value_set_object (value, valadoc_wiki_page_get_documentation (self));
		break;
		case VALADOC_WIKI_PAGE_DOCUMENTATION_STR_PROPERTY:
		g_value_set_string (value, valadoc_wiki_page_get_documentation_str (self));
		break;
		case VALADOC_WIKI_PAGE_PATH_PROPERTY:
		g_value_set_string (value, valadoc_wiki_page_get_path (self));
		break;
		case VALADOC_WIKI_PAGE_NAME_PROPERTY:
		g_value_set_string (value, valadoc_wiki_page_get_name (self));
		break;
		case VALADOC_WIKI_PAGE_PACKAGE_PROPERTY:
		g_value_set_object (value, valadoc_documentation_get_package ((ValadocDocumentation*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_valadoc_wiki_page_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	ValadocWikiPage * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, VALADOC_TYPE_WIKI_PAGE, ValadocWikiPage);
	switch (property_id) {
		case VALADOC_WIKI_PAGE_DOCUMENTATION_PROPERTY:
		valadoc_wiki_page_set_documentation (self, g_value_get_object (value));
		break;
		case VALADOC_WIKI_PAGE_DOCUMENTATION_STR_PROPERTY:
		valadoc_wiki_page_set_documentation_str (self, g_value_get_string (value));
		break;
		case VALADOC_WIKI_PAGE_PATH_PROPERTY:
		valadoc_wiki_page_set_path (self, g_value_get_string (value));
		break;
		case VALADOC_WIKI_PAGE_NAME_PROPERTY:
		valadoc_wiki_page_set_name (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


ValadocWikiPageTree* valadoc_wiki_page_tree_construct (GType object_type) {
	ValadocWikiPageTree * self = NULL;
	self = (ValadocWikiPageTree*) g_object_new (object_type, NULL);
	return self;
}


ValadocWikiPageTree* valadoc_wiki_page_tree_new (void) {
	return valadoc_wiki_page_tree_construct (VALADOC_TYPE_WIKI_PAGE_TREE);
}


static gpointer _vala_iterable_ref0 (gpointer self) {
	return self ? vala_iterable_ref (self) : NULL;
}


ValaCollection* valadoc_wiki_page_tree_get_pages (ValadocWikiPageTree* self) {
	ValaCollection* result = NULL;
	ValaArrayList* _tmp0_ = NULL;
	ValaArrayList* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = self->priv->wikipages;
	if (_tmp1_ == NULL) {
		GEqualFunc _tmp2_;
		ValaArrayList* _tmp3_;
		_tmp2_ = g_direct_equal;
		_tmp3_ = vala_array_list_new (VALADOC_TYPE_WIKI_PAGE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, _tmp2_);
		_vala_iterable_unref0 (_tmp0_);
		_tmp0_ = _tmp3_;
	} else {
		ValaArrayList* _tmp4_;
		ValaArrayList* _tmp5_;
		_tmp4_ = self->priv->wikipages;
		_tmp5_ = _vala_iterable_ref0 (_tmp4_);
		_vala_iterable_unref0 (_tmp0_);
		_tmp0_ = _tmp5_;
	}
	result = (ValaCollection*) _tmp0_;
	return result;
}


ValadocWikiPage* valadoc_wiki_page_tree_search (ValadocWikiPageTree* self, const gchar* name) {
	ValadocWikiPage* result = NULL;
	ValaArrayList* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = self->priv->wikipages;
	if (_tmp0_ == NULL) {
		result = NULL;
		return result;
	}
	{
		ValaArrayList* _page_list = NULL;
		ValaArrayList* _tmp1_;
		ValaArrayList* _tmp2_;
		gint _page_size = 0;
		ValaArrayList* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		gint _page_index = 0;
		_tmp1_ = self->priv->wikipages;
		_tmp2_ = _vala_iterable_ref0 (_tmp1_);
		_page_list = _tmp2_;
		_tmp3_ = _page_list;
		_tmp4_ = vala_collection_get_size ((ValaCollection*) _tmp3_);
		_tmp5_ = _tmp4_;
		_page_size = _tmp5_;
		_page_index = -1;
		while (TRUE) {
			gint _tmp6_;
			gint _tmp7_;
			gint _tmp8_;
			ValadocWikiPage* page = NULL;
			ValaArrayList* _tmp9_;
			gint _tmp10_;
			gpointer _tmp11_;
			ValadocWikiPage* _tmp12_;
			const gchar* _tmp13_;
			const gchar* _tmp14_;
			const gchar* _tmp15_;
			_tmp6_ = _page_index;
			_page_index = _tmp6_ + 1;
			_tmp7_ = _page_index;
			_tmp8_ = _page_size;
			if (!(_tmp7_ < _tmp8_)) {
				break;
			}
			_tmp9_ = _page_list;
			_tmp10_ = _page_index;
			_tmp11_ = vala_list_get ((ValaList*) _tmp9_, _tmp10_);
			page = (ValadocWikiPage*) _tmp11_;
			_tmp12_ = page;
			_tmp13_ = valadoc_wiki_page_get_name (_tmp12_);
			_tmp14_ = _tmp13_;
			_tmp15_ = name;
			if (g_strcmp0 (_tmp14_, _tmp15_) == 0) {
				result = page;
				_vala_iterable_unref0 (_page_list);
				return result;
			}
			_g_object_unref0 (page);
		}
		_vala_iterable_unref0 (_page_list);
	}
	result = NULL;
	return result;
}


static void valadoc_wiki_page_tree_create_tree_from_path (ValadocWikiPageTree* self, ValadocDocumentationParser* docparser, ValadocApiPackage* package, ValadocErrorReporter* reporter, const gchar* path, const gchar* nameoffset) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (docparser != NULL);
	g_return_if_fail (package != NULL);
	g_return_if_fail (reporter != NULL);
	g_return_if_fail (path != NULL);
	{
		GDir* dir = NULL;
		const gchar* _tmp0_;
		GDir* _tmp1_;
		_tmp0_ = path;
		_tmp1_ = g_dir_open (_tmp0_, (guint) 0, &_inner_error_);
		dir = _tmp1_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == G_FILE_ERROR) {
				goto __catch9_g_file_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		{
			gchar* curname = NULL;
			GDir* _tmp2_;
			const gchar* _tmp3_;
			gchar* _tmp4_;
			_tmp2_ = dir;
			_tmp3_ = g_dir_read_name (_tmp2_);
			_tmp4_ = g_strdup (_tmp3_);
			curname = _tmp4_;
			{
				gboolean _tmp5_ = FALSE;
				_tmp5_ = TRUE;
				while (TRUE) {
					const gchar* _tmp9_;
					gchar* filename = NULL;
					const gchar* _tmp10_;
					const gchar* _tmp11_;
					gchar* _tmp12_;
					gboolean _tmp13_ = FALSE;
					const gchar* _tmp14_;
					gboolean _tmp15_;
					if (!_tmp5_) {
						GDir* _tmp6_;
						const gchar* _tmp7_;
						gchar* _tmp8_;
						_tmp6_ = dir;
						_tmp7_ = g_dir_read_name (_tmp6_);
						_tmp8_ = g_strdup (_tmp7_);
						_g_free0 (curname);
						curname = _tmp8_;
					}
					_tmp5_ = FALSE;
					_tmp9_ = curname;
					if (!(_tmp9_ != NULL)) {
						break;
					}
					_tmp10_ = path;
					_tmp11_ = curname;
					_tmp12_ = g_build_filename (_tmp10_, _tmp11_, NULL);
					filename = _tmp12_;
					_tmp14_ = curname;
					_tmp15_ = g_str_has_suffix (_tmp14_, ".valadoc");
					if (_tmp15_) {
						const gchar* _tmp16_;
						gboolean _tmp17_;
						_tmp16_ = filename;
						_tmp17_ = g_file_test (_tmp16_, G_FILE_TEST_IS_REGULAR);
						_tmp13_ = _tmp17_;
					} else {
						_tmp13_ = FALSE;
					}
					if (_tmp13_) {
						gchar* _tmp18_ = NULL;
						const gchar* _tmp19_;
						ValadocWikiPage* wikipage = NULL;
						const gchar* _tmp25_;
						ValadocApiPackage* _tmp26_;
						ValadocWikiPage* _tmp27_;
						ValaArrayList* _tmp28_;
						ValadocWikiPage* _tmp29_;
						ValadocWikiPage* _tmp30_;
						ValadocErrorReporter* _tmp31_;
						_tmp19_ = nameoffset;
						if (_tmp19_ != NULL) {
							const gchar* _tmp20_;
							const gchar* _tmp21_;
							gchar* _tmp22_;
							_tmp20_ = nameoffset;
							_tmp21_ = curname;
							_tmp22_ = g_build_filename (_tmp20_, _tmp21_, NULL);
							_g_free0 (_tmp18_);
							_tmp18_ = _tmp22_;
						} else {
							const gchar* _tmp23_;
							gchar* _tmp24_;
							_tmp23_ = curname;
							_tmp24_ = g_strdup (_tmp23_);
							_g_free0 (_tmp18_);
							_tmp18_ = _tmp24_;
						}
						_tmp25_ = filename;
						_tmp26_ = package;
						_tmp27_ = valadoc_wiki_page_new (_tmp18_, _tmp25_, _tmp26_);
						wikipage = _tmp27_;
						_tmp28_ = self->priv->wikipages;
						_tmp29_ = wikipage;
						vala_collection_add ((ValaCollection*) _tmp28_, _tmp29_);
						_tmp30_ = wikipage;
						_tmp31_ = reporter;
						valadoc_wiki_page_read (_tmp30_, _tmp31_);
						_g_object_unref0 (wikipage);
						_g_free0 (_tmp18_);
					} else {
						const gchar* _tmp32_;
						gboolean _tmp33_;
						_tmp32_ = filename;
						_tmp33_ = g_file_test (_tmp32_, G_FILE_TEST_IS_DIR);
						if (_tmp33_) {
							gchar* _tmp34_ = NULL;
							const gchar* _tmp35_;
							ValadocDocumentationParser* _tmp41_;
							ValadocApiPackage* _tmp42_;
							ValadocErrorReporter* _tmp43_;
							const gchar* _tmp44_;
							_tmp35_ = nameoffset;
							if (_tmp35_ != NULL) {
								const gchar* _tmp36_;
								const gchar* _tmp37_;
								gchar* _tmp38_;
								_tmp36_ = nameoffset;
								_tmp37_ = curname;
								_tmp38_ = g_build_filename (_tmp36_, _tmp37_, NULL);
								_g_free0 (_tmp34_);
								_tmp34_ = _tmp38_;
							} else {
								const gchar* _tmp39_;
								gchar* _tmp40_;
								_tmp39_ = curname;
								_tmp40_ = g_strdup (_tmp39_);
								_g_free0 (_tmp34_);
								_tmp34_ = _tmp40_;
							}
							_tmp41_ = docparser;
							_tmp42_ = package;
							_tmp43_ = reporter;
							_tmp44_ = filename;
							valadoc_wiki_page_tree_create_tree_from_path (self, _tmp41_, _tmp42_, _tmp43_, _tmp44_, _tmp34_);
							_g_free0 (_tmp34_);
						}
					}
					_g_free0 (filename);
				}
			}
			_g_free0 (curname);
		}
		_g_dir_close0 (dir);
	}
	goto __finally9;
	__catch9_g_file_error:
	{
		GError* err = NULL;
		ValadocErrorReporter* _tmp45_;
		const gchar* _tmp46_;
		GError* _tmp47_;
		const gchar* _tmp48_;
		err = _inner_error_;
		_inner_error_ = NULL;
		_tmp45_ = reporter;
		_tmp46_ = path;
		_tmp47_ = err;
		_tmp48_ = _tmp47_->message;
		valadoc_error_reporter_simple_error (_tmp45_, NULL, "Unable to open directory '%s': %s", _tmp46_, _tmp48_);
		_g_error_free0 (err);
	}
	__finally9:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


void valadoc_wiki_page_tree_parse (ValadocWikiPageTree* self, ValadocSettings* settings, ValadocDocumentationParser* docparser, ValadocApiPackage* package, ValadocErrorReporter* reporter) {
	const gchar* path = NULL;
	ValadocSettings* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	GEqualFunc _tmp3_;
	ValaArrayList* _tmp4_;
	ValadocDocumentationParser* _tmp5_;
	ValadocApiPackage* _tmp6_;
	ValadocErrorReporter* _tmp7_;
	const gchar* _tmp8_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (settings != NULL);
	g_return_if_fail (docparser != NULL);
	g_return_if_fail (package != NULL);
	g_return_if_fail (reporter != NULL);
	_tmp0_ = settings;
	_tmp1_ = _tmp0_->wiki_directory;
	path = _tmp1_;
	_tmp2_ = path;
	if (_tmp2_ == NULL) {
		return;
	}
	_tmp3_ = g_direct_equal;
	_tmp4_ = vala_array_list_new (VALADOC_TYPE_WIKI_PAGE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, _tmp3_);
	_vala_iterable_unref0 (self->priv->wikipages);
	self->priv->wikipages = _tmp4_;
	_tmp5_ = docparser;
	_tmp6_ = package;
	_tmp7_ = reporter;
	_tmp8_ = path;
	valadoc_wiki_page_tree_create_tree_from_path (self, _tmp5_, _tmp6_, _tmp7_, _tmp8_, NULL);
	{
		ValaArrayList* _page_list = NULL;
		ValaArrayList* _tmp9_;
		ValaArrayList* _tmp10_;
		gint _page_size = 0;
		ValaArrayList* _tmp11_;
		gint _tmp12_;
		gint _tmp13_;
		gint _page_index = 0;
		_tmp9_ = self->priv->wikipages;
		_tmp10_ = _vala_iterable_ref0 (_tmp9_);
		_page_list = _tmp10_;
		_tmp11_ = _page_list;
		_tmp12_ = vala_collection_get_size ((ValaCollection*) _tmp11_);
		_tmp13_ = _tmp12_;
		_page_size = _tmp13_;
		_page_index = -1;
		while (TRUE) {
			gint _tmp14_;
			gint _tmp15_;
			gint _tmp16_;
			ValadocWikiPage* page = NULL;
			ValaArrayList* _tmp17_;
			gint _tmp18_;
			gpointer _tmp19_;
			ValadocWikiPage* _tmp20_;
			ValadocDocumentationParser* _tmp21_;
			ValadocApiPackage* _tmp22_;
			_tmp14_ = _page_index;
			_page_index = _tmp14_ + 1;
			_tmp15_ = _page_index;
			_tmp16_ = _page_size;
			if (!(_tmp15_ < _tmp16_)) {
				break;
			}
			_tmp17_ = _page_list;
			_tmp18_ = _page_index;
			_tmp19_ = vala_list_get ((ValaList*) _tmp17_, _tmp18_);
			page = (ValadocWikiPage*) _tmp19_;
			_tmp20_ = page;
			_tmp21_ = docparser;
			_tmp22_ = package;
			valadoc_wiki_page_parse (_tmp20_, _tmp21_, _tmp22_);
			_g_object_unref0 (page);
		}
		_vala_iterable_unref0 (_page_list);
	}
}


void valadoc_wiki_page_tree_check (ValadocWikiPageTree* self, ValadocSettings* settings, ValadocDocumentationParser* docparser, ValadocApiPackage* pkg) {
	ValaArrayList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (settings != NULL);
	g_return_if_fail (docparser != NULL);
	g_return_if_fail (pkg != NULL);
	_tmp0_ = self->priv->wikipages;
	if (_tmp0_ == NULL) {
		return;
	}
	{
		ValaArrayList* _page_list = NULL;
		ValaArrayList* _tmp1_;
		ValaArrayList* _tmp2_;
		gint _page_size = 0;
		ValaArrayList* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		gint _page_index = 0;
		_tmp1_ = self->priv->wikipages;
		_tmp2_ = _vala_iterable_ref0 (_tmp1_);
		_page_list = _tmp2_;
		_tmp3_ = _page_list;
		_tmp4_ = vala_collection_get_size ((ValaCollection*) _tmp3_);
		_tmp5_ = _tmp4_;
		_page_size = _tmp5_;
		_page_index = -1;
		while (TRUE) {
			gint _tmp6_;
			gint _tmp7_;
			gint _tmp8_;
			ValadocWikiPage* page = NULL;
			ValaArrayList* _tmp9_;
			gint _tmp10_;
			gpointer _tmp11_;
			ValadocDocumentationParser* _tmp12_;
			ValadocApiPackage* _tmp13_;
			ValadocWikiPage* _tmp14_;
			_tmp6_ = _page_index;
			_page_index = _tmp6_ + 1;
			_tmp7_ = _page_index;
			_tmp8_ = _page_size;
			if (!(_tmp7_ < _tmp8_)) {
				break;
			}
			_tmp9_ = _page_list;
			_tmp10_ = _page_index;
			_tmp11_ = vala_list_get ((ValaList*) _tmp9_, _tmp10_);
			page = (ValadocWikiPage*) _tmp11_;
			_tmp12_ = docparser;
			_tmp13_ = pkg;
			_tmp14_ = page;
			valadoc_documentation_parser_check_wikipage (_tmp12_, _tmp13_, _tmp14_);
			_g_object_unref0 (page);
		}
		_vala_iterable_unref0 (_page_list);
	}
}


static void valadoc_wiki_page_tree_class_init (ValadocWikiPageTreeClass * klass) {
	valadoc_wiki_page_tree_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ValadocWikiPageTreePrivate));
	G_OBJECT_CLASS (klass)->finalize = valadoc_wiki_page_tree_finalize;
}


static void valadoc_wiki_page_tree_instance_init (ValadocWikiPageTree * self) {
	self->priv = VALADOC_WIKI_PAGE_TREE_GET_PRIVATE (self);
}


static void valadoc_wiki_page_tree_finalize (GObject * obj) {
	ValadocWikiPageTree * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALADOC_TYPE_WIKI_PAGE_TREE, ValadocWikiPageTree);
	_vala_iterable_unref0 (self->priv->wikipages);
	G_OBJECT_CLASS (valadoc_wiki_page_tree_parent_class)->finalize (obj);
}


GType valadoc_wiki_page_tree_get_type (void) {
	static volatile gsize valadoc_wiki_page_tree_type_id__volatile = 0;
	if (g_once_init_enter (&valadoc_wiki_page_tree_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValadocWikiPageTreeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) valadoc_wiki_page_tree_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValadocWikiPageTree), 0, (GInstanceInitFunc) valadoc_wiki_page_tree_instance_init, NULL };
		GType valadoc_wiki_page_tree_type_id;
		valadoc_wiki_page_tree_type_id = g_type_register_static (G_TYPE_OBJECT, "ValadocWikiPageTree", &g_define_type_info, 0);
		g_once_init_leave (&valadoc_wiki_page_tree_type_id__volatile, valadoc_wiki_page_tree_type_id);
	}
	return valadoc_wiki_page_tree_type_id__volatile;
}



