/*
 * Copyright (c) 2017, Intel Corporation
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 *    * Redistributions of source code must retain the above copyright notice,
 *      this list of conditions and the following disclaimer.
 *    * Redistributions in binary form must reproduce the above copyright
 *      notice, this list of conditions and the following disclaimer in the
 *      documentation and/or other materials provided with the distribution.
 *    * Neither the name of Intel Corporation nor the names of its contributors
 *      may be used to endorse or promote products derived from this software
 *      without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#pragma once

#define BIT(n)				(1ULL << n)

#define BITMASK(len)			(BIT(len) - 1)

/* Get value from the bits within 'bitmap' represented by 'mask'. The 'mask'
 * parameter must be a continuous bit mask (e.g. 0b00111000). This macro
 * doesn't work with non-continuous bit masks (e.g. 0b00101001).
 */
#define BITMAP_GET_VALUE(bitmap, mask, shift) \
			((bitmap & mask) >> shift)

/* Set the value 'val' in the 'bitmap' variable at the position represented by
 * 'mask'.
 */
#define BITMAP_SET_VALUE(bitmap, val, mask, shift) \
			(bitmap = (bitmap & ~mask) | ((val << shift) & mask))

struct __una_u32 { uint32_t x; } __attribute__((packed));

static inline uint32_t get_unaligned_be32(const void *p)
{
	const struct __una_u32 *ptr = (const struct __una_u32 *)p;
	return ntohl(ptr->x);
}

static inline void put_unaligned_be32(uint32_t val, void *p)
{
	struct __una_u32 *ptr = (struct __una_u32 *)p;
	ptr->x = htonl(val);
}
