/* user-dict.c generated by valac 0.38.1.30-90885, the Vala compiler
 * generated from user-dict.vala, do not modify */

/*
 * Copyright (C) 2011-2017 Daiki Ueno <ueno@gnu.org>
 * Copyright (C) 2011-2017 Red Hat, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <gee.h>
#include <glib/gstdio.h>


#define SKK_TYPE_DICT (skk_dict_get_type ())
#define SKK_DICT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SKK_TYPE_DICT, SkkDict))
#define SKK_DICT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SKK_TYPE_DICT, SkkDictClass))
#define SKK_IS_DICT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SKK_TYPE_DICT))
#define SKK_IS_DICT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SKK_TYPE_DICT))
#define SKK_DICT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SKK_TYPE_DICT, SkkDictClass))

typedef struct _SkkDict SkkDict;
typedef struct _SkkDictClass SkkDictClass;
typedef struct _SkkDictPrivate SkkDictPrivate;

#define SKK_TYPE_CANDIDATE (skk_candidate_get_type ())
#define SKK_CANDIDATE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SKK_TYPE_CANDIDATE, SkkCandidate))
#define SKK_CANDIDATE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SKK_TYPE_CANDIDATE, SkkCandidateClass))
#define SKK_IS_CANDIDATE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SKK_TYPE_CANDIDATE))
#define SKK_IS_CANDIDATE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SKK_TYPE_CANDIDATE))
#define SKK_CANDIDATE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SKK_TYPE_CANDIDATE, SkkCandidateClass))

typedef struct _SkkCandidate SkkCandidate;
typedef struct _SkkCandidateClass SkkCandidateClass;

#define SKK_TYPE_USER_DICT (skk_user_dict_get_type ())
#define SKK_USER_DICT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SKK_TYPE_USER_DICT, SkkUserDict))
#define SKK_USER_DICT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SKK_TYPE_USER_DICT, SkkUserDictClass))
#define SKK_IS_USER_DICT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SKK_TYPE_USER_DICT))
#define SKK_IS_USER_DICT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SKK_TYPE_USER_DICT))
#define SKK_USER_DICT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SKK_TYPE_USER_DICT, SkkUserDictClass))

typedef struct _SkkUserDict SkkUserDict;
typedef struct _SkkUserDictClass SkkUserDictClass;
typedef struct _SkkUserDictPrivate SkkUserDictPrivate;

#define SKK_TYPE_ENCODING_CONVERTER (skk_encoding_converter_get_type ())
#define SKK_ENCODING_CONVERTER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SKK_TYPE_ENCODING_CONVERTER, SkkEncodingConverter))
#define SKK_ENCODING_CONVERTER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SKK_TYPE_ENCODING_CONVERTER, SkkEncodingConverterClass))
#define SKK_IS_ENCODING_CONVERTER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SKK_TYPE_ENCODING_CONVERTER))
#define SKK_IS_ENCODING_CONVERTER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SKK_TYPE_ENCODING_CONVERTER))
#define SKK_ENCODING_CONVERTER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SKK_TYPE_ENCODING_CONVERTER, SkkEncodingConverterClass))

typedef struct _SkkEncodingConverter SkkEncodingConverter;
typedef struct _SkkEncodingConverterClass SkkEncodingConverterClass;
enum  {
	SKK_USER_DICT_0_PROPERTY,
	SKK_USER_DICT_READ_ONLY_PROPERTY,
	SKK_USER_DICT_NUM_PROPERTIES
};
static GParamSpec* skk_user_dict_properties[SKK_USER_DICT_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))

struct _SkkDict {
	GObject parent_instance;
	SkkDictPrivate * priv;
};

struct _SkkDictClass {
	GObjectClass parent_class;
	void (*reload) (SkkDict* self, GError** error);
	SkkCandidate** (*lookup) (SkkDict* self, const gchar* midasi, gboolean okuri, int* result_length1);
	gchar** (*complete) (SkkDict* self, const gchar* midasi, int* result_length1);
	gboolean (*select_candidate) (SkkDict* self, SkkCandidate* candidate);
	gboolean (*purge_candidate) (SkkDict* self, SkkCandidate* candidate);
	void (*save) (SkkDict* self, GError** error);
	gboolean (*get_read_only) (SkkDict* self);
};

struct _SkkUserDict {
	SkkDict parent_instance;
	SkkUserDictPrivate * priv;
};

struct _SkkUserDictClass {
	SkkDictClass parent_class;
};

struct _SkkUserDictPrivate {
	GFile* file;
	gchar* etag;
	SkkEncodingConverter* converter;
	GeeMap* okuri_ari_entries;
	GeeMap* okuri_nasi_entries;
};

typedef enum  {
	SKK_SKK_DICT_ERROR_NOT_READABLE,
	SKK_SKK_DICT_ERROR_MALFORMED_INPUT
} SkkSkkDictError;
#define SKK_SKK_DICT_ERROR skk_skk_dict_error_quark ()

static gpointer skk_user_dict_parent_class = NULL;

GType skk_dict_get_type (void) G_GNUC_CONST;
GType skk_candidate_get_type (void) G_GNUC_CONST;
GType skk_user_dict_get_type (void) G_GNUC_CONST;
GType skk_encoding_converter_get_type (void) G_GNUC_CONST;
#define SKK_USER_DICT_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), SKK_TYPE_USER_DICT, SkkUserDictPrivate))
GQuark skk_skk_dict_error_quark (void);
static void skk_user_dict_load (SkkUserDict* self, GError** error);
static guint8* _vala_array_dup2 (guint8* self, int length);
gchar* skk_encoding_converter_extract_coding_system (const gchar* line);
SkkEncodingConverter* skk_encoding_converter_new_from_coding_system (const gchar* coding, GError** error);
SkkEncodingConverter* skk_encoding_converter_construct_from_coding_system (GType object_type, const gchar* coding, GError** error);
gchar* skk_encoding_converter_decode (SkkEncodingConverter* self, const gchar* external_str, GError** error);
SkkCandidate** skk_dict_split_candidates (SkkDict* self, const gchar* midasi, gboolean okuri, const gchar* line, int* result_length1);
static void skk_user_dict_real_reload (SkkDict* base, GError** error);
static gint skk_user_dict_compare_entry_asc (GeeMapEntry* a, GeeMapEntry* b);
static gint skk_user_dict_compare_entry_dsc (GeeMapEntry* a, GeeMapEntry* b);
static void skk_user_dict_write_entries (SkkUserDict* self, GString* builder, GeeList* entries);
gchar* skk_dict_join_candidates (SkkDict* self, SkkCandidate** candidates, int candidates_length1);
static void skk_user_dict_real_save (SkkDict* base, GError** error);
gchar* skk_encoding_converter_get_coding_system (SkkEncodingConverter* self);
gchar* skk_encoding_converter_encode (SkkEncodingConverter* self, const gchar* internal_str, GError** error);
static GeeMap* skk_user_dict_get_entries (SkkUserDict* self, gboolean okuri);
static SkkCandidate** skk_user_dict_real_lookup (SkkDict* base, const gchar* midasi, gboolean okuri, int* result_length1);
static gchar** skk_user_dict_real_complete (SkkDict* base, const gchar* midasi, int* result_length1);
static gboolean skk_user_dict_real_select_candidate (SkkDict* base, SkkCandidate* candidate);
gboolean skk_candidate_get_okuri (SkkCandidate* self);
const gchar* skk_candidate_get_midasi (SkkCandidate* self);
const gchar* skk_candidate_get_text (SkkCandidate* self);
static gboolean skk_user_dict_real_purge_candidate (SkkDict* base, SkkCandidate* candidate);
SkkUserDict* skk_user_dict_new (const gchar* path, const gchar* encoding, GError** error);
SkkUserDict* skk_user_dict_construct (GType object_type, const gchar* path, const gchar* encoding, GError** error);
SkkDict* skk_dict_construct (GType object_type);
SkkEncodingConverter* skk_encoding_converter_new (const gchar* encoding, GError** error);
SkkEncodingConverter* skk_encoding_converter_construct (GType object_type, const gchar* encoding, GError** error);
void skk_dict_reload (SkkDict* self, GError** error);
static void skk_user_dict_finalize (GObject * obj);
gboolean skk_dict_get_read_only (SkkDict* self);
static void _vala_skk_user_dict_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


static guint8* _vala_array_dup2 (guint8* self, int length) {
	return g_memdup (self, length * sizeof (guint8));
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static gint string_index_of (const gchar* self, const gchar* needle, gint start_index) {
	gint result = 0;
	gchar* _result_ = NULL;
	gint _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (needle != NULL, 0);
	_tmp0_ = start_index;
	_tmp1_ = needle;
	_tmp2_ = strstr (((gchar*) self) + _tmp0_, (gchar*) _tmp1_);
	_result_ = _tmp2_;
	_tmp3_ = _result_;
	if (_tmp3_ != NULL) {
		gchar* _tmp4_;
		_tmp4_ = _result_;
		result = (gint) (_tmp4_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}


static gchar* string_slice (const gchar* self, glong start, glong end) {
	gchar* result = NULL;
	glong string_length = 0L;
	gint _tmp0_;
	gint _tmp1_;
	glong _tmp2_;
	glong _tmp5_;
	gboolean _tmp8_ = FALSE;
	glong _tmp9_;
	gboolean _tmp12_ = FALSE;
	glong _tmp13_;
	glong _tmp16_;
	glong _tmp17_;
	glong _tmp18_;
	glong _tmp19_;
	glong _tmp20_;
	gchar* _tmp21_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	string_length = (glong) _tmp1_;
	_tmp2_ = start;
	if (_tmp2_ < ((glong) 0)) {
		glong _tmp3_;
		glong _tmp4_;
		_tmp3_ = string_length;
		_tmp4_ = start;
		start = _tmp3_ + _tmp4_;
	}
	_tmp5_ = end;
	if (_tmp5_ < ((glong) 0)) {
		glong _tmp6_;
		glong _tmp7_;
		_tmp6_ = string_length;
		_tmp7_ = end;
		end = _tmp6_ + _tmp7_;
	}
	_tmp9_ = start;
	if (_tmp9_ >= ((glong) 0)) {
		glong _tmp10_;
		glong _tmp11_;
		_tmp10_ = start;
		_tmp11_ = string_length;
		_tmp8_ = _tmp10_ <= _tmp11_;
	} else {
		_tmp8_ = FALSE;
	}
	g_return_val_if_fail (_tmp8_, NULL);
	_tmp13_ = end;
	if (_tmp13_ >= ((glong) 0)) {
		glong _tmp14_;
		glong _tmp15_;
		_tmp14_ = end;
		_tmp15_ = string_length;
		_tmp12_ = _tmp14_ <= _tmp15_;
	} else {
		_tmp12_ = FALSE;
	}
	g_return_val_if_fail (_tmp12_, NULL);
	_tmp16_ = start;
	_tmp17_ = end;
	g_return_val_if_fail (_tmp16_ <= _tmp17_, NULL);
	_tmp18_ = start;
	_tmp19_ = end;
	_tmp20_ = start;
	_tmp21_ = g_strndup (((gchar*) self) + _tmp18_, (gsize) (_tmp19_ - _tmp20_));
	result = _tmp21_;
	return result;
}


static void skk_user_dict_load (SkkUserDict* self, GError** error) {
	guint8* contents = NULL;
	gint contents_length1 = 0;
	gint _contents_size_ = 0;
	GMemoryInputStream* memory = NULL;
	guint8* _tmp5_;
	gint _tmp5__length1;
	guint8* _tmp6_;
	gint _tmp6__length1;
	GDestroyNotify _tmp7_;
	GMemoryInputStream* _tmp8_;
	GDataInputStream* data = NULL;
	GMemoryInputStream* _tmp9_;
	GDataInputStream* _tmp10_;
	gchar* line = NULL;
	gsize length = 0UL;
	gchar* _tmp11_ = NULL;
	GDataInputStream* _tmp12_;
	gsize _tmp13_ = 0UL;
	gchar* _tmp14_;
	gchar* _tmp15_;
	const gchar* _tmp16_;
	gchar* coding = NULL;
	const gchar* _tmp17_;
	gchar* _tmp18_;
	const gchar* _tmp19_;
	GeeMap* entries = NULL;
	GeeMap* _tmp45_;
	gboolean okuri = FALSE;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	{
		GFile* _tmp0_;
		guint8* _tmp1_ = NULL;
		gsize _tmp2_;
		gchar* _tmp3_ = NULL;
		_tmp0_ = self->priv->file;
		g_file_load_contents (_tmp0_, NULL, &_tmp1_, &_tmp2_, &_tmp3_, &_inner_error_);
		contents = (g_free (contents), NULL);
		contents = _tmp1_;
		contents_length1 = _tmp2_;
		_contents_size_ = contents_length1;
		_g_free0 (self->priv->etag);
		self->priv->etag = _tmp3_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch12_g_error;
		}
	}
	goto __finally12;
	__catch12_g_error:
	{
		GError* e = NULL;
		GError* _tmp4_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp4_ = g_error_new_literal (SKK_SKK_DICT_ERROR, SKK_SKK_DICT_ERROR_NOT_READABLE, "can't load contents");
		_inner_error_ = _tmp4_;
		_g_error_free0 (e);
		goto __finally12;
	}
	__finally12:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if ((_inner_error_->domain == SKK_SKK_DICT_ERROR) || (_inner_error_->domain == G_IO_ERROR)) {
			g_propagate_error (error, _inner_error_);
			contents = (g_free (contents), NULL);
			return;
		} else {
			contents = (g_free (contents), NULL);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp5_ = contents;
	_tmp5__length1 = contents_length1;
	_tmp6_ = (_tmp5_ != NULL) ? _vala_array_dup2 (_tmp5_, _tmp5__length1) : ((gpointer) _tmp5_);
	_tmp6__length1 = _tmp5__length1;
	_tmp7_ = g_free;
	_tmp8_ = (GMemoryInputStream*) g_memory_input_stream_new_from_data (_tmp6_, _tmp6__length1, _tmp7_);
	memory = _tmp8_;
	_tmp9_ = memory;
	_tmp10_ = g_data_input_stream_new ((GInputStream*) _tmp9_);
	data = _tmp10_;
	line = NULL;
	_tmp12_ = data;
	_tmp14_ = g_data_input_stream_read_line (_tmp12_, &_tmp13_, NULL, &_inner_error_);
	length = _tmp13_;
	_tmp11_ = _tmp14_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if ((_inner_error_->domain == SKK_SKK_DICT_ERROR) || (_inner_error_->domain == G_IO_ERROR)) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (line);
			_g_object_unref0 (data);
			_g_object_unref0 (memory);
			contents = (g_free (contents), NULL);
			return;
		} else {
			_g_free0 (line);
			_g_object_unref0 (data);
			_g_object_unref0 (memory);
			contents = (g_free (contents), NULL);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp15_ = _tmp11_;
	_tmp11_ = NULL;
	_g_free0 (line);
	line = _tmp15_;
	_tmp16_ = line;
	if (_tmp16_ == NULL) {
		_g_free0 (_tmp11_);
		_g_free0 (line);
		_g_object_unref0 (data);
		_g_object_unref0 (memory);
		contents = (g_free (contents), NULL);
		return;
	}
	_tmp17_ = line;
	_tmp18_ = skk_encoding_converter_extract_coding_system (_tmp17_);
	coding = _tmp18_;
	_tmp19_ = coding;
	if (_tmp19_ != NULL) {
		gchar* _tmp28_ = NULL;
		GDataInputStream* _tmp29_;
		gsize _tmp30_ = 0UL;
		gchar* _tmp31_;
		gchar* _tmp32_;
		const gchar* _tmp33_;
		{
			SkkEncodingConverter* _converter = NULL;
			const gchar* _tmp20_;
			SkkEncodingConverter* _tmp21_;
			SkkEncodingConverter* _tmp22_;
			_tmp20_ = coding;
			_tmp21_ = skk_encoding_converter_new_from_coding_system (_tmp20_, &_inner_error_);
			_converter = _tmp21_;
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				goto __catch13_g_error;
			}
			_tmp22_ = _converter;
			if (_tmp22_ != NULL) {
				SkkEncodingConverter* _tmp23_;
				SkkEncodingConverter* _tmp24_;
				_tmp23_ = _converter;
				_tmp24_ = _g_object_ref0 (_tmp23_);
				_g_object_unref0 (self->priv->converter);
				self->priv->converter = _tmp24_;
			}
			_g_object_unref0 (_converter);
		}
		goto __finally13;
		__catch13_g_error:
		{
			GError* e = NULL;
			const gchar* _tmp25_;
			GError* _tmp26_;
			const gchar* _tmp27_;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp25_ = coding;
			_tmp26_ = e;
			_tmp27_ = _tmp26_->message;
			g_warning ("user-dict.vala:51: can't create converter from coding system %s: %s", _tmp25_, _tmp27_);
			_g_error_free0 (e);
		}
		__finally13:
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if ((_inner_error_->domain == SKK_SKK_DICT_ERROR) || (_inner_error_->domain == G_IO_ERROR)) {
				g_propagate_error (error, _inner_error_);
				_g_free0 (coding);
				_g_free0 (_tmp11_);
				_g_free0 (line);
				_g_object_unref0 (data);
				_g_object_unref0 (memory);
				contents = (g_free (contents), NULL);
				return;
			} else {
				_g_free0 (coding);
				_g_free0 (_tmp11_);
				_g_free0 (line);
				_g_object_unref0 (data);
				_g_object_unref0 (memory);
				contents = (g_free (contents), NULL);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		_tmp29_ = data;
		_tmp31_ = g_data_input_stream_read_line (_tmp29_, &_tmp30_, NULL, &_inner_error_);
		length = _tmp30_;
		_tmp28_ = _tmp31_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if ((_inner_error_->domain == SKK_SKK_DICT_ERROR) || (_inner_error_->domain == G_IO_ERROR)) {
				g_propagate_error (error, _inner_error_);
				_g_free0 (coding);
				_g_free0 (_tmp11_);
				_g_free0 (line);
				_g_object_unref0 (data);
				_g_object_unref0 (memory);
				contents = (g_free (contents), NULL);
				return;
			} else {
				_g_free0 (coding);
				_g_free0 (_tmp11_);
				_g_free0 (line);
				_g_object_unref0 (data);
				_g_object_unref0 (memory);
				contents = (g_free (contents), NULL);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		_tmp32_ = _tmp28_;
		_tmp28_ = NULL;
		_g_free0 (line);
		line = _tmp32_;
		_tmp33_ = line;
		if (_tmp33_ == NULL) {
			_g_free0 (_tmp28_);
			_g_free0 (coding);
			_g_free0 (_tmp11_);
			_g_free0 (line);
			_g_object_unref0 (data);
			_g_object_unref0 (memory);
			contents = (g_free (contents), NULL);
			return;
		}
		_g_free0 (_tmp28_);
	}
	entries = NULL;
	while (TRUE) {
		const gchar* _tmp34_;
		const gchar* _tmp35_;
		gboolean _tmp36_;
		gchar* _tmp39_ = NULL;
		GDataInputStream* _tmp40_;
		gsize _tmp41_ = 0UL;
		gchar* _tmp42_;
		gchar* _tmp43_;
		const gchar* _tmp44_;
		_tmp34_ = line;
		if (!(_tmp34_ != NULL)) {
			break;
		}
		_tmp35_ = line;
		_tmp36_ = g_str_has_prefix (_tmp35_, ";; okuri-ari entries.");
		if (_tmp36_) {
			GeeMap* _tmp37_;
			GeeMap* _tmp38_;
			_tmp37_ = self->priv->okuri_ari_entries;
			_tmp38_ = _g_object_ref0 (_tmp37_);
			_g_object_unref0 (entries);
			entries = _tmp38_;
			break;
		}
		_tmp40_ = data;
		_tmp42_ = g_data_input_stream_read_line (_tmp40_, &_tmp41_, NULL, &_inner_error_);
		length = _tmp41_;
		_tmp39_ = _tmp42_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if ((_inner_error_->domain == SKK_SKK_DICT_ERROR) || (_inner_error_->domain == G_IO_ERROR)) {
				g_propagate_error (error, _inner_error_);
				_g_object_unref0 (entries);
				_g_free0 (coding);
				_g_free0 (_tmp11_);
				_g_free0 (line);
				_g_object_unref0 (data);
				_g_object_unref0 (memory);
				contents = (g_free (contents), NULL);
				return;
			} else {
				_g_object_unref0 (entries);
				_g_free0 (coding);
				_g_free0 (_tmp11_);
				_g_free0 (line);
				_g_object_unref0 (data);
				_g_object_unref0 (memory);
				contents = (g_free (contents), NULL);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		_tmp43_ = _tmp39_;
		_tmp39_ = NULL;
		_g_free0 (line);
		line = _tmp43_;
		_tmp44_ = line;
		if (_tmp44_ == NULL) {
			_g_free0 (_tmp39_);
			break;
		}
		_g_free0 (_tmp39_);
	}
	_tmp45_ = entries;
	if (_tmp45_ == NULL) {
		GError* _tmp46_;
		_tmp46_ = g_error_new_literal (SKK_SKK_DICT_ERROR, SKK_SKK_DICT_ERROR_MALFORMED_INPUT, "no okuri-ari boundary");
		_inner_error_ = _tmp46_;
		if ((_inner_error_->domain == SKK_SKK_DICT_ERROR) || (_inner_error_->domain == G_IO_ERROR)) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (entries);
			_g_free0 (coding);
			_g_free0 (_tmp11_);
			_g_free0 (line);
			_g_object_unref0 (data);
			_g_object_unref0 (memory);
			contents = (g_free (contents), NULL);
			return;
		} else {
			_g_object_unref0 (entries);
			_g_free0 (coding);
			_g_free0 (_tmp11_);
			_g_free0 (line);
			_g_object_unref0 (data);
			_g_object_unref0 (memory);
			contents = (g_free (contents), NULL);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	okuri = TRUE;
	while (TRUE) {
		const gchar* _tmp47_;
		gchar* _tmp48_ = NULL;
		GDataInputStream* _tmp49_;
		gsize _tmp50_ = 0UL;
		gchar* _tmp51_;
		gchar* _tmp52_;
		const gchar* _tmp53_;
		const gchar* _tmp54_;
		gboolean _tmp55_;
		gint index = 0;
		const gchar* _tmp67_;
		gint _tmp68_;
		gint _tmp69_;
		gchar* midasi = NULL;
		const gchar* _tmp72_;
		gint _tmp73_;
		gchar* _tmp74_;
		gchar* candidates_str = NULL;
		const gchar* _tmp75_;
		gint _tmp76_;
		const gchar* _tmp77_;
		gint _tmp78_;
		gint _tmp79_;
		gchar* _tmp80_;
		gboolean _tmp81_ = FALSE;
		const gchar* _tmp82_;
		gboolean _tmp83_;
		SkkCandidate** candidates = NULL;
		const gchar* _tmp88_;
		gboolean _tmp89_;
		const gchar* _tmp90_;
		gint _tmp91_;
		SkkCandidate** _tmp92_;
		gint candidates_length1;
		gint _candidates_size_;
		GeeArrayList* list = NULL;
		GeeArrayList* _tmp93_;
		SkkCandidate** _tmp94_;
		gint _tmp94__length1;
		GeeMap* _tmp98_;
		const gchar* _tmp99_;
		GeeArrayList* _tmp100_;
		_tmp47_ = line;
		if (!(_tmp47_ != NULL)) {
			break;
		}
		_tmp49_ = data;
		_tmp51_ = g_data_input_stream_read_line (_tmp49_, &_tmp50_, NULL, &_inner_error_);
		length = _tmp50_;
		_tmp48_ = _tmp51_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if ((_inner_error_->domain == SKK_SKK_DICT_ERROR) || (_inner_error_->domain == G_IO_ERROR)) {
				g_propagate_error (error, _inner_error_);
				_g_object_unref0 (entries);
				_g_free0 (coding);
				_g_free0 (_tmp11_);
				_g_free0 (line);
				_g_object_unref0 (data);
				_g_object_unref0 (memory);
				contents = (g_free (contents), NULL);
				return;
			} else {
				_g_object_unref0 (entries);
				_g_free0 (coding);
				_g_free0 (_tmp11_);
				_g_free0 (line);
				_g_object_unref0 (data);
				_g_object_unref0 (memory);
				contents = (g_free (contents), NULL);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		_tmp52_ = _tmp48_;
		_tmp48_ = NULL;
		_g_free0 (line);
		line = _tmp52_;
		_tmp53_ = line;
		if (_tmp53_ == NULL) {
			_g_free0 (_tmp48_);
			break;
		}
		_tmp54_ = line;
		_tmp55_ = g_str_has_prefix (_tmp54_, ";; okuri-nasi entries.");
		if (_tmp55_) {
			GeeMap* _tmp56_;
			GeeMap* _tmp57_;
			_tmp56_ = self->priv->okuri_nasi_entries;
			_tmp57_ = _g_object_ref0 (_tmp56_);
			_g_object_unref0 (entries);
			entries = _tmp57_;
			okuri = FALSE;
			_g_free0 (_tmp48_);
			continue;
		}
		{
			gchar* _tmp58_ = NULL;
			SkkEncodingConverter* _tmp59_;
			const gchar* _tmp60_;
			gchar* _tmp61_;
			gchar* _tmp62_;
			_tmp59_ = self->priv->converter;
			_tmp60_ = line;
			_tmp61_ = skk_encoding_converter_decode (_tmp59_, _tmp60_, &_inner_error_);
			_tmp58_ = _tmp61_;
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				goto __catch14_g_error;
			}
			_tmp62_ = _tmp58_;
			_tmp58_ = NULL;
			_g_free0 (line);
			line = _tmp62_;
			_g_free0 (_tmp58_);
		}
		goto __finally14;
		__catch14_g_error:
		{
			GError* e = NULL;
			const gchar* _tmp63_;
			GError* _tmp64_;
			const gchar* _tmp65_;
			GError* _tmp66_;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp63_ = line;
			_tmp64_ = e;
			_tmp65_ = _tmp64_->message;
			_tmp66_ = g_error_new (SKK_SKK_DICT_ERROR, SKK_SKK_DICT_ERROR_MALFORMED_INPUT, "can't decode line %s: %s", _tmp63_, _tmp65_);
			_inner_error_ = _tmp66_;
			_g_error_free0 (e);
			goto __finally14;
		}
		__finally14:
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if ((_inner_error_->domain == SKK_SKK_DICT_ERROR) || (_inner_error_->domain == G_IO_ERROR)) {
				g_propagate_error (error, _inner_error_);
				_g_free0 (_tmp48_);
				_g_object_unref0 (entries);
				_g_free0 (coding);
				_g_free0 (_tmp11_);
				_g_free0 (line);
				_g_object_unref0 (data);
				_g_object_unref0 (memory);
				contents = (g_free (contents), NULL);
				return;
			} else {
				_g_free0 (_tmp48_);
				_g_object_unref0 (entries);
				_g_free0 (coding);
				_g_free0 (_tmp11_);
				_g_free0 (line);
				_g_object_unref0 (data);
				_g_object_unref0 (memory);
				contents = (g_free (contents), NULL);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		_tmp67_ = line;
		_tmp68_ = string_index_of (_tmp67_, " ", 0);
		index = _tmp68_;
		_tmp69_ = index;
		if (_tmp69_ < 1) {
			const gchar* _tmp70_;
			GError* _tmp71_;
			_tmp70_ = line;
			_tmp71_ = g_error_new (SKK_SKK_DICT_ERROR, SKK_SKK_DICT_ERROR_MALFORMED_INPUT, "can't extract midasi from line %s", _tmp70_);
			_inner_error_ = _tmp71_;
			if ((_inner_error_->domain == SKK_SKK_DICT_ERROR) || (_inner_error_->domain == G_IO_ERROR)) {
				g_propagate_error (error, _inner_error_);
				_g_free0 (_tmp48_);
				_g_object_unref0 (entries);
				_g_free0 (coding);
				_g_free0 (_tmp11_);
				_g_free0 (line);
				_g_object_unref0 (data);
				_g_object_unref0 (memory);
				contents = (g_free (contents), NULL);
				return;
			} else {
				_g_free0 (_tmp48_);
				_g_object_unref0 (entries);
				_g_free0 (coding);
				_g_free0 (_tmp11_);
				_g_free0 (line);
				_g_object_unref0 (data);
				_g_object_unref0 (memory);
				contents = (g_free (contents), NULL);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		_tmp72_ = line;
		_tmp73_ = index;
		_tmp74_ = string_slice (_tmp72_, (glong) 0, (glong) _tmp73_);
		midasi = _tmp74_;
		_tmp75_ = line;
		_tmp76_ = index;
		_tmp77_ = line;
		_tmp78_ = strlen (_tmp77_);
		_tmp79_ = _tmp78_;
		_tmp80_ = string_slice (_tmp75_, (glong) (_tmp76_ + 1), (glong) _tmp79_);
		candidates_str = _tmp80_;
		_tmp82_ = candidates_str;
		_tmp83_ = g_str_has_prefix (_tmp82_, "/");
		if (!_tmp83_) {
			_tmp81_ = TRUE;
		} else {
			const gchar* _tmp84_;
			gboolean _tmp85_;
			_tmp84_ = candidates_str;
			_tmp85_ = g_str_has_suffix (_tmp84_, "/");
			_tmp81_ = !_tmp85_;
		}
		if (_tmp81_) {
			const gchar* _tmp86_;
			GError* _tmp87_;
			_tmp86_ = candidates_str;
			_tmp87_ = g_error_new (SKK_SKK_DICT_ERROR, SKK_SKK_DICT_ERROR_MALFORMED_INPUT, "can't parse candidates list %s", _tmp86_);
			_inner_error_ = _tmp87_;
			if ((_inner_error_->domain == SKK_SKK_DICT_ERROR) || (_inner_error_->domain == G_IO_ERROR)) {
				g_propagate_error (error, _inner_error_);
				_g_free0 (candidates_str);
				_g_free0 (midasi);
				_g_free0 (_tmp48_);
				_g_object_unref0 (entries);
				_g_free0 (coding);
				_g_free0 (_tmp11_);
				_g_free0 (line);
				_g_object_unref0 (data);
				_g_object_unref0 (memory);
				contents = (g_free (contents), NULL);
				return;
			} else {
				_g_free0 (candidates_str);
				_g_free0 (midasi);
				_g_free0 (_tmp48_);
				_g_object_unref0 (entries);
				_g_free0 (coding);
				_g_free0 (_tmp11_);
				_g_free0 (line);
				_g_object_unref0 (data);
				_g_object_unref0 (memory);
				contents = (g_free (contents), NULL);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		_tmp88_ = midasi;
		_tmp89_ = okuri;
		_tmp90_ = candidates_str;
		_tmp92_ = skk_dict_split_candidates ((SkkDict*) self, _tmp88_, _tmp89_, _tmp90_, &_tmp91_);
		candidates = _tmp92_;
		candidates_length1 = _tmp91_;
		_candidates_size_ = candidates_length1;
		_tmp93_ = gee_array_list_new (SKK_TYPE_CANDIDATE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
		list = _tmp93_;
		_tmp94_ = candidates;
		_tmp94__length1 = candidates_length1;
		{
			SkkCandidate** c_collection = NULL;
			gint c_collection_length1 = 0;
			gint _c_collection_size_ = 0;
			gint c_it = 0;
			c_collection = _tmp94_;
			c_collection_length1 = _tmp94__length1;
			for (c_it = 0; c_it < _tmp94__length1; c_it = c_it + 1) {
				SkkCandidate* _tmp95_;
				SkkCandidate* c = NULL;
				_tmp95_ = _g_object_ref0 (c_collection[c_it]);
				c = _tmp95_;
				{
					GeeArrayList* _tmp96_;
					SkkCandidate* _tmp97_;
					_tmp96_ = list;
					_tmp97_ = c;
					gee_abstract_collection_add ((GeeAbstractCollection*) _tmp96_, _tmp97_);
					_g_object_unref0 (c);
				}
			}
		}
		_tmp98_ = entries;
		_tmp99_ = midasi;
		_tmp100_ = list;
		gee_map_set (_tmp98_, _tmp99_, (GeeList*) _tmp100_);
		_g_object_unref0 (list);
		candidates = (_vala_array_free (candidates, candidates_length1, (GDestroyNotify) g_object_unref), NULL);
		_g_free0 (candidates_str);
		_g_free0 (midasi);
		_g_free0 (_tmp48_);
	}
	_g_object_unref0 (entries);
	_g_free0 (coding);
	_g_free0 (_tmp11_);
	_g_free0 (line);
	_g_object_unref0 (data);
	_g_object_unref0 (memory);
	contents = (g_free (contents), NULL);
}


/**
         * {@inheritDoc}
         */
static void skk_user_dict_real_reload (SkkDict* base, GError** error) {
	SkkUserDict * self;
	gchar* attributes = NULL;
	gchar* _tmp0_;
	GFileInfo* info = NULL;
	GFile* _tmp1_;
	GFileInfo* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	GError * _inner_error_ = NULL;
	self = (SkkUserDict*) base;
	_tmp0_ = g_strdup (G_FILE_ATTRIBUTE_ETAG_VALUE);
	attributes = _tmp0_;
	_tmp1_ = self->priv->file;
	_tmp2_ = g_file_query_info (_tmp1_, attributes, G_FILE_QUERY_INFO_NONE, NULL, &_inner_error_);
	info = _tmp2_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (attributes);
		return;
	}
	_tmp3_ = g_file_info_get_etag (info);
	_tmp4_ = self->priv->etag;
	if (g_strcmp0 (_tmp3_, _tmp4_) != 0) {
		GeeMap* _tmp5_;
		GeeMap* _tmp6_;
		_tmp5_ = self->priv->okuri_ari_entries;
		gee_map_clear (_tmp5_);
		_tmp6_ = self->priv->okuri_nasi_entries;
		gee_map_clear (_tmp6_);
		{
			skk_user_dict_load (self, &_inner_error_);
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				if (_inner_error_->domain == SKK_SKK_DICT_ERROR) {
					goto __catch15_skk_skk_dict_error;
				}
				if (_inner_error_->domain == G_IO_ERROR) {
					goto __catch15_g_io_error;
				}
				_g_object_unref0 (info);
				_g_free0 (attributes);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		goto __finally15;
		__catch15_skk_skk_dict_error:
		{
			GError* e = NULL;
			GFile* _tmp7_;
			gchar* _tmp8_;
			gchar* _tmp9_;
			GError* _tmp10_;
			const gchar* _tmp11_;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp7_ = self->priv->file;
			_tmp8_ = g_file_get_path (_tmp7_);
			_tmp9_ = _tmp8_;
			_tmp10_ = e;
			_tmp11_ = _tmp10_->message;
			g_warning ("user-dict.vala:138: error parsing user dictionary %s: %s", _tmp9_, _tmp11_);
			_g_free0 (_tmp9_);
			_g_error_free0 (e);
		}
		goto __finally15;
		__catch15_g_io_error:
		{
			GError* e = NULL;
			GFile* _tmp12_;
			gchar* _tmp13_;
			gchar* _tmp14_;
			GError* _tmp15_;
			const gchar* _tmp16_;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp12_ = self->priv->file;
			_tmp13_ = g_file_get_path (_tmp12_);
			_tmp14_ = _tmp13_;
			_tmp15_ = e;
			_tmp16_ = _tmp15_->message;
			g_warning ("user-dict.vala:141: error reading user dictionary %s: %s", _tmp14_, _tmp16_);
			_g_free0 (_tmp14_);
			_g_error_free0 (e);
		}
		__finally15:
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (info);
			_g_free0 (attributes);
			return;
		}
	}
	_g_object_unref0 (info);
	_g_free0 (attributes);
}


static gint skk_user_dict_compare_entry_asc (GeeMapEntry* a, GeeMapEntry* b) {
	gint result = 0;
	GCompareFunc _tmp0_;
	GeeMapEntry* _tmp1_;
	gconstpointer _tmp2_;
	const gchar* _tmp3_;
	GeeMapEntry* _tmp4_;
	gconstpointer _tmp5_;
	const gchar* _tmp6_;
	gint _tmp7_;
	g_return_val_if_fail (a != NULL, 0);
	g_return_val_if_fail (b != NULL, 0);
	_tmp0_ = g_strcmp0;
	_tmp1_ = a;
	_tmp2_ = gee_map_entry_get_key (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = b;
	_tmp5_ = gee_map_entry_get_key (_tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = _tmp0_ ((const gchar*) _tmp3_, (const gchar*) _tmp6_);
	result = _tmp7_;
	return result;
}


static gint skk_user_dict_compare_entry_dsc (GeeMapEntry* a, GeeMapEntry* b) {
	gint result = 0;
	GCompareFunc _tmp0_;
	GeeMapEntry* _tmp1_;
	gconstpointer _tmp2_;
	const gchar* _tmp3_;
	GeeMapEntry* _tmp4_;
	gconstpointer _tmp5_;
	const gchar* _tmp6_;
	gint _tmp7_;
	g_return_val_if_fail (a != NULL, 0);
	g_return_val_if_fail (b != NULL, 0);
	_tmp0_ = g_strcmp0;
	_tmp1_ = b;
	_tmp2_ = gee_map_entry_get_key (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = a;
	_tmp5_ = gee_map_entry_get_key (_tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = _tmp0_ ((const gchar*) _tmp3_, (const gchar*) _tmp6_);
	result = _tmp7_;
	return result;
}


static void skk_user_dict_write_entries (SkkUserDict* self, GString* builder, GeeList* entries) {
	GeeIterator* iter = NULL;
	GeeList* _tmp0_;
	GeeIterator* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (builder != NULL);
	g_return_if_fail (entries != NULL);
	_tmp0_ = entries;
	_tmp1_ = gee_iterable_iterator ((GeeIterable*) _tmp0_);
	iter = _tmp1_;
	while (TRUE) {
		GeeIterator* _tmp2_;
		gboolean _tmp3_;
		GeeMapEntry* entry = NULL;
		GeeIterator* _tmp4_;
		gpointer _tmp5_;
		gchar* line = NULL;
		GeeMapEntry* _tmp6_;
		gconstpointer _tmp7_;
		const gchar* _tmp8_;
		GeeMapEntry* _tmp9_;
		gconstpointer _tmp10_;
		GeeList* _tmp11_;
		gint _tmp12_;
		gpointer* _tmp13_;
		SkkCandidate** _tmp14_;
		gint _tmp14__length1;
		gchar* _tmp15_;
		gchar* _tmp16_;
		gchar* _tmp17_;
		gchar* _tmp18_;
		GString* _tmp19_;
		const gchar* _tmp20_;
		_tmp2_ = iter;
		_tmp3_ = gee_iterator_next (_tmp2_);
		if (!_tmp3_) {
			break;
		}
		_tmp4_ = iter;
		_tmp5_ = gee_iterator_get (_tmp4_);
		entry = (GeeMapEntry*) _tmp5_;
		_tmp6_ = entry;
		_tmp7_ = gee_map_entry_get_key (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp9_ = entry;
		_tmp10_ = gee_map_entry_get_value (_tmp9_);
		_tmp11_ = _tmp10_;
		_tmp13_ = gee_collection_to_array ((GeeCollection*) ((GeeList*) _tmp11_), &_tmp12_);
		_tmp14_ = _tmp13_;
		_tmp14__length1 = _tmp12_;
		_tmp15_ = skk_dict_join_candidates ((SkkDict*) self, _tmp14_, _tmp12_);
		_tmp16_ = _tmp15_;
		_tmp17_ = g_strdup_printf ("%s %s\n", (const gchar*) _tmp8_, _tmp16_);
		_tmp18_ = _tmp17_;
		_g_free0 (_tmp16_);
		_tmp14_ = (_vala_array_free (_tmp14_, _tmp14__length1, (GDestroyNotify) g_object_unref), NULL);
		line = _tmp18_;
		_tmp19_ = builder;
		_tmp20_ = line;
		g_string_append (_tmp19_, _tmp20_);
		_g_free0 (line);
		_g_object_unref0 (entry);
	}
	_g_object_unref0 (iter);
}


/**
         * {@inheritDoc}
         */
static guint8* string_get_data (const gchar* self, int* result_length1) {
	guint8* result;
	guint8* res = NULL;
	gint res_length1;
	gint _res_size_;
	gint _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	guint8* _tmp3_;
	gint _tmp3__length1;
	guint8* _tmp4_;
	gint _tmp4__length1;
	g_return_val_if_fail (self != NULL, NULL);
	res = (guint8*) self;
	res_length1 = -1;
	_res_size_ = res_length1;
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	res_length1 = (gint) _tmp1_;
	_tmp2_ = res_length1;
	_tmp3_ = res;
	_tmp3__length1 = res_length1;
	_tmp4_ = _tmp3_;
	_tmp4__length1 = _tmp3__length1;
	if (result_length1) {
		*result_length1 = _tmp4__length1;
	}
	result = _tmp4_;
	return result;
}


static void skk_user_dict_real_save (SkkDict* base, GError** error) {
	SkkUserDict * self;
	GString* builder = NULL;
	GString* _tmp0_;
	gchar* coding = NULL;
	SkkEncodingConverter* _tmp1_;
	gchar* _tmp2_;
	const gchar* _tmp3_;
	GString* _tmp8_;
	GeeArrayList* entries = NULL;
	GeeArrayList* _tmp9_;
	GeeArrayList* _tmp10_;
	GeeMap* _tmp11_;
	GeeSet* _tmp12_;
	GeeSet* _tmp13_;
	GeeSet* _tmp14_;
	GeeArrayList* _tmp15_;
	GString* _tmp16_;
	GeeArrayList* _tmp17_;
	GeeArrayList* _tmp18_;
	GString* _tmp19_;
	GeeArrayList* _tmp20_;
	GeeMap* _tmp21_;
	GeeSet* _tmp22_;
	GeeSet* _tmp23_;
	GeeSet* _tmp24_;
	GeeArrayList* _tmp25_;
	GString* _tmp26_;
	GeeArrayList* _tmp27_;
	GeeArrayList* _tmp28_;
	gchar* contents = NULL;
	SkkEncodingConverter* _tmp29_;
	GString* _tmp30_;
	const gchar* _tmp31_;
	gchar* _tmp32_;
	GFile* _tmp33_;
	gchar* _tmp34_;
	gchar* _tmp35_;
	gchar* _tmp36_;
	gchar* _tmp37_;
	GFile* _tmp38_;
	const gchar* _tmp39_;
	guint8* _tmp40_;
	gint _tmp40__length1;
	guint8* _tmp41_;
	gint _tmp41__length1;
	const gchar* _tmp42_;
	gchar* _tmp43_ = NULL;
	GError * _inner_error_ = NULL;
	self = (SkkUserDict*) base;
	_tmp0_ = g_string_new ("");
	builder = _tmp0_;
	_tmp1_ = self->priv->converter;
	_tmp2_ = skk_encoding_converter_get_coding_system (_tmp1_);
	coding = _tmp2_;
	_tmp3_ = coding;
	if (_tmp3_ != NULL) {
		GString* _tmp4_;
		const gchar* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		_tmp4_ = builder;
		_tmp5_ = coding;
		_tmp6_ = g_strdup_printf (";;; -*- coding: %s -*-\n", _tmp5_);
		_tmp7_ = _tmp6_;
		g_string_append (_tmp4_, _tmp7_);
		_g_free0 (_tmp7_);
	}
	_tmp8_ = builder;
	g_string_append (_tmp8_, ";; okuri-ari entries.\n");
	_tmp9_ = gee_array_list_new (GEE_MAP_TYPE_ENTRY, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	entries = _tmp9_;
	_tmp10_ = entries;
	_tmp11_ = self->priv->okuri_ari_entries;
	_tmp12_ = gee_map_get_entries (_tmp11_);
	_tmp13_ = _tmp12_;
	_tmp14_ = _tmp13_;
	gee_array_list_add_all (_tmp10_, (GeeCollection*) _tmp14_);
	_g_object_unref0 (_tmp14_);
	_tmp15_ = entries;
	gee_list_sort ((GeeList*) _tmp15_, (GCompareDataFunc) skk_user_dict_compare_entry_dsc, NULL, NULL);
	_tmp16_ = builder;
	_tmp17_ = entries;
	skk_user_dict_write_entries (self, _tmp16_, (GeeList*) _tmp17_);
	_tmp18_ = entries;
	gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp18_);
	_tmp19_ = builder;
	g_string_append (_tmp19_, ";; okuri-nasi entries.\n");
	_tmp20_ = entries;
	_tmp21_ = self->priv->okuri_nasi_entries;
	_tmp22_ = gee_map_get_entries (_tmp21_);
	_tmp23_ = _tmp22_;
	_tmp24_ = _tmp23_;
	gee_array_list_add_all (_tmp20_, (GeeCollection*) _tmp24_);
	_g_object_unref0 (_tmp24_);
	_tmp25_ = entries;
	gee_list_sort ((GeeList*) _tmp25_, (GCompareDataFunc) skk_user_dict_compare_entry_asc, NULL, NULL);
	_tmp26_ = builder;
	_tmp27_ = entries;
	skk_user_dict_write_entries (self, _tmp26_, (GeeList*) _tmp27_);
	_tmp28_ = entries;
	gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp28_);
	_tmp29_ = self->priv->converter;
	_tmp30_ = builder;
	_tmp31_ = _tmp30_->str;
	_tmp32_ = skk_encoding_converter_encode (_tmp29_, _tmp31_, &_inner_error_);
	contents = _tmp32_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (entries);
		_g_free0 (coding);
		_g_string_free0 (builder);
		return;
	}
	_tmp33_ = self->priv->file;
	_tmp34_ = g_file_get_path (_tmp33_);
	_tmp35_ = _tmp34_;
	_tmp36_ = g_path_get_dirname (_tmp35_);
	_tmp37_ = _tmp36_;
	g_mkdir_with_parents (_tmp37_, 448);
	_g_free0 (_tmp37_);
	_g_free0 (_tmp35_);
	_tmp38_ = self->priv->file;
	_tmp39_ = contents;
	_tmp40_ = string_get_data (_tmp39_, &_tmp40__length1);
	_tmp41_ = _tmp40_;
	_tmp41__length1 = _tmp40__length1;
	_tmp42_ = self->priv->etag;
	g_file_replace_contents (_tmp38_, _tmp41_, (gsize) _tmp41__length1, _tmp42_, FALSE, G_FILE_CREATE_PRIVATE, &_tmp43_, NULL, &_inner_error_);
	_g_free0 (self->priv->etag);
	self->priv->etag = _tmp43_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (contents);
		_g_object_unref0 (entries);
		_g_free0 (coding);
		_g_string_free0 (builder);
		return;
	}
	_g_free0 (contents);
	_g_object_unref0 (entries);
	_g_free0 (coding);
	_g_string_free0 (builder);
}


static GeeMap* skk_user_dict_get_entries (SkkUserDict* self, gboolean okuri) {
	GeeMap* result = NULL;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = okuri;
	if (_tmp0_) {
		GeeMap* _tmp1_;
		GeeMap* _tmp2_;
		_tmp1_ = self->priv->okuri_ari_entries;
		_tmp2_ = _g_object_ref0 (_tmp1_);
		result = _tmp2_;
		return result;
	} else {
		GeeMap* _tmp3_;
		GeeMap* _tmp4_;
		_tmp3_ = self->priv->okuri_nasi_entries;
		_tmp4_ = _g_object_ref0 (_tmp3_);
		result = _tmp4_;
		return result;
	}
}


/**
         * {@inheritDoc}
         */
static SkkCandidate** skk_user_dict_real_lookup (SkkDict* base, const gchar* midasi, gboolean okuri, int* result_length1) {
	SkkUserDict * self;
	SkkCandidate** result = NULL;
	GeeMap* entries = NULL;
	gboolean _tmp0_;
	GeeMap* _tmp1_;
	GeeMap* _tmp2_;
	const gchar* _tmp3_;
	gboolean _tmp4_;
	self = (SkkUserDict*) base;
	g_return_val_if_fail (midasi != NULL, NULL);
	_tmp0_ = okuri;
	_tmp1_ = skk_user_dict_get_entries (self, _tmp0_);
	entries = _tmp1_;
	_tmp2_ = entries;
	_tmp3_ = midasi;
	_tmp4_ = gee_map_has_key (_tmp2_, _tmp3_);
	if (_tmp4_) {
		GeeMap* _tmp5_;
		const gchar* _tmp6_;
		gpointer _tmp7_;
		GeeList* _tmp8_;
		gint _tmp9_;
		gpointer* _tmp10_;
		SkkCandidate** _tmp11_;
		gint _tmp11__length1;
		SkkCandidate** _tmp12_;
		gint _tmp12__length1;
		_tmp5_ = entries;
		_tmp6_ = midasi;
		_tmp7_ = gee_map_get (_tmp5_, _tmp6_);
		_tmp8_ = (GeeList*) _tmp7_;
		_tmp10_ = gee_collection_to_array ((GeeCollection*) _tmp8_, &_tmp9_);
		_tmp11_ = _tmp10_;
		_tmp11__length1 = _tmp9_;
		_g_object_unref0 (_tmp8_);
		_tmp12_ = _tmp11_;
		_tmp12__length1 = _tmp11__length1;
		if (result_length1) {
			*result_length1 = _tmp12__length1;
		}
		result = _tmp12_;
		_g_object_unref0 (entries);
		return result;
	} else {
		SkkCandidate** _tmp13_;
		SkkCandidate** _tmp14_;
		gint _tmp14__length1;
		_tmp13_ = g_new0 (SkkCandidate*, 0 + 1);
		_tmp14_ = _tmp13_;
		_tmp14__length1 = 0;
		if (result_length1) {
			*result_length1 = _tmp14__length1;
		}
		result = _tmp14_;
		_g_object_unref0 (entries);
		return result;
	}
	_g_object_unref0 (entries);
}


/**
         * {@inheritDoc}
         */
static gchar** skk_user_dict_real_complete (SkkDict* base, const gchar* midasi, int* result_length1) {
	SkkUserDict * self;
	gchar** result = NULL;
	GeeList* completion = NULL;
	GeeArrayList* _tmp0_;
	GeeList* keys = NULL;
	GeeArrayList* _tmp1_;
	GeeList* _tmp2_;
	GeeMap* _tmp3_;
	GeeSet* _tmp4_;
	GeeSet* _tmp5_;
	GeeSet* _tmp6_;
	GeeList* _tmp7_;
	GeeIterator* iter = NULL;
	GeeList* _tmp8_;
	GeeIterator* _tmp9_;
	GeeList* _tmp32_;
	gint _tmp33_;
	gpointer* _tmp34_;
	gchar** _tmp35_;
	gint _tmp35__length1;
	self = (SkkUserDict*) base;
	g_return_val_if_fail (midasi != NULL, NULL);
	_tmp0_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
	completion = (GeeList*) _tmp0_;
	_tmp1_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
	keys = (GeeList*) _tmp1_;
	_tmp2_ = keys;
	_tmp3_ = self->priv->okuri_nasi_entries;
	_tmp4_ = gee_map_get_keys (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = _tmp5_;
	gee_collection_add_all ((GeeCollection*) _tmp2_, (GeeCollection*) _tmp6_);
	_g_object_unref0 (_tmp6_);
	_tmp7_ = keys;
	gee_list_sort (_tmp7_, NULL, NULL, NULL);
	_tmp8_ = keys;
	_tmp9_ = gee_iterable_iterator ((GeeIterable*) _tmp8_);
	iter = _tmp9_;
	while (TRUE) {
		GeeIterator* _tmp10_;
		gboolean _tmp11_;
		gchar* key = NULL;
		GeeIterator* _tmp12_;
		gpointer _tmp13_;
		const gchar* _tmp14_;
		const gchar* _tmp15_;
		gboolean _tmp16_;
		_tmp10_ = iter;
		_tmp11_ = gee_iterator_next (_tmp10_);
		if (!_tmp11_) {
			break;
		}
		_tmp12_ = iter;
		_tmp13_ = gee_iterator_get (_tmp12_);
		key = (gchar*) _tmp13_;
		_tmp14_ = key;
		_tmp15_ = midasi;
		_tmp16_ = g_str_has_prefix (_tmp14_, _tmp15_);
		if (_tmp16_) {
			const gchar* _tmp17_;
			const gchar* _tmp18_;
			_tmp17_ = key;
			_tmp18_ = midasi;
			if (g_strcmp0 (_tmp17_, _tmp18_) != 0) {
				GeeList* _tmp19_;
				const gchar* _tmp20_;
				_tmp19_ = completion;
				_tmp20_ = key;
				gee_collection_add ((GeeCollection*) _tmp19_, _tmp20_);
			}
			_g_free0 (key);
			break;
		}
		_g_free0 (key);
	}
	while (TRUE) {
		GeeIterator* _tmp21_;
		gboolean _tmp22_;
		gchar* key = NULL;
		GeeIterator* _tmp23_;
		gpointer _tmp24_;
		const gchar* _tmp25_;
		const gchar* _tmp26_;
		gboolean _tmp27_;
		const gchar* _tmp28_;
		const gchar* _tmp29_;
		_tmp21_ = iter;
		_tmp22_ = gee_iterator_next (_tmp21_);
		if (!_tmp22_) {
			break;
		}
		_tmp23_ = iter;
		_tmp24_ = gee_iterator_get (_tmp23_);
		key = (gchar*) _tmp24_;
		_tmp25_ = key;
		_tmp26_ = midasi;
		_tmp27_ = g_str_has_prefix (_tmp25_, _tmp26_);
		if (!_tmp27_) {
			_g_free0 (key);
			break;
		}
		_tmp28_ = key;
		_tmp29_ = midasi;
		if (g_strcmp0 (_tmp28_, _tmp29_) != 0) {
			GeeList* _tmp30_;
			const gchar* _tmp31_;
			_tmp30_ = completion;
			_tmp31_ = key;
			gee_collection_add ((GeeCollection*) _tmp30_, _tmp31_);
		}
		_g_free0 (key);
	}
	_tmp32_ = completion;
	_tmp34_ = gee_collection_to_array ((GeeCollection*) _tmp32_, &_tmp33_);
	_tmp35_ = _tmp34_;
	_tmp35__length1 = _tmp33_;
	if (result_length1) {
		*result_length1 = _tmp35__length1;
	}
	result = _tmp35_;
	_g_object_unref0 (iter);
	_g_object_unref0 (keys);
	_g_object_unref0 (completion);
	return result;
}


/**
         * {@inheritDoc}
         */
static gboolean skk_user_dict_real_select_candidate (SkkDict* base, SkkCandidate* candidate) {
	SkkUserDict * self;
	gboolean result = FALSE;
	GeeMap* entries = NULL;
	SkkCandidate* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	GeeMap* _tmp3_;
	GeeMap* _tmp4_;
	SkkCandidate* _tmp5_;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	gboolean _tmp8_;
	gint index = 0;
	GeeList* candidates = NULL;
	GeeMap* _tmp15_;
	SkkCandidate* _tmp16_;
	const gchar* _tmp17_;
	const gchar* _tmp18_;
	gpointer _tmp19_;
	GeeList* _tmp49_;
	SkkCandidate* _tmp50_;
	self = (SkkUserDict*) base;
	g_return_val_if_fail (candidate != NULL, FALSE);
	_tmp0_ = candidate;
	_tmp1_ = skk_candidate_get_okuri (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = skk_user_dict_get_entries (self, _tmp2_);
	entries = _tmp3_;
	_tmp4_ = entries;
	_tmp5_ = candidate;
	_tmp6_ = skk_candidate_get_midasi (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = gee_map_has_key (_tmp4_, _tmp7_);
	if (!_tmp8_) {
		GeeMap* _tmp9_;
		SkkCandidate* _tmp10_;
		const gchar* _tmp11_;
		const gchar* _tmp12_;
		GeeArrayList* _tmp13_;
		GeeArrayList* _tmp14_;
		_tmp9_ = entries;
		_tmp10_ = candidate;
		_tmp11_ = skk_candidate_get_midasi (_tmp10_);
		_tmp12_ = _tmp11_;
		_tmp13_ = gee_array_list_new (SKK_TYPE_CANDIDATE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
		_tmp14_ = _tmp13_;
		gee_map_set (_tmp9_, _tmp12_, (GeeList*) _tmp14_);
		_g_object_unref0 (_tmp14_);
	}
	index = 0;
	_tmp15_ = entries;
	_tmp16_ = candidate;
	_tmp17_ = skk_candidate_get_midasi (_tmp16_);
	_tmp18_ = _tmp17_;
	_tmp19_ = gee_map_get (_tmp15_, _tmp18_);
	candidates = (GeeList*) _tmp19_;
	{
		GeeList* _c_list = NULL;
		GeeList* _tmp20_;
		GeeList* _tmp21_;
		gint _c_size = 0;
		GeeList* _tmp22_;
		gint _tmp23_;
		gint _tmp24_;
		gint _c_index = 0;
		_tmp20_ = candidates;
		_tmp21_ = _g_object_ref0 (_tmp20_);
		_c_list = _tmp21_;
		_tmp22_ = _c_list;
		_tmp23_ = gee_collection_get_size ((GeeCollection*) _tmp22_);
		_tmp24_ = _tmp23_;
		_c_size = _tmp24_;
		_c_index = -1;
		while (TRUE) {
			gint _tmp25_;
			gint _tmp26_;
			gint _tmp27_;
			SkkCandidate* c = NULL;
			GeeList* _tmp28_;
			gint _tmp29_;
			gpointer _tmp30_;
			SkkCandidate* _tmp31_;
			const gchar* _tmp32_;
			const gchar* _tmp33_;
			SkkCandidate* _tmp34_;
			const gchar* _tmp35_;
			const gchar* _tmp36_;
			gint _tmp48_;
			_tmp25_ = _c_index;
			_c_index = _tmp25_ + 1;
			_tmp26_ = _c_index;
			_tmp27_ = _c_size;
			if (!(_tmp26_ < _tmp27_)) {
				break;
			}
			_tmp28_ = _c_list;
			_tmp29_ = _c_index;
			_tmp30_ = gee_list_get (_tmp28_, _tmp29_);
			c = (SkkCandidate*) _tmp30_;
			_tmp31_ = c;
			_tmp32_ = skk_candidate_get_text (_tmp31_);
			_tmp33_ = _tmp32_;
			_tmp34_ = candidate;
			_tmp35_ = skk_candidate_get_text (_tmp34_);
			_tmp36_ = _tmp35_;
			if (g_strcmp0 (_tmp33_, _tmp36_) == 0) {
				gint _tmp37_;
				_tmp37_ = index;
				if (_tmp37_ > 0) {
					SkkCandidate* first = NULL;
					GeeList* _tmp38_;
					gpointer _tmp39_;
					GeeList* _tmp40_;
					GeeList* _tmp41_;
					gint _tmp42_;
					gpointer _tmp43_;
					SkkCandidate* _tmp44_;
					GeeList* _tmp45_;
					gint _tmp46_;
					SkkCandidate* _tmp47_;
					_tmp38_ = candidates;
					_tmp39_ = gee_list_get (_tmp38_, 0);
					first = (SkkCandidate*) _tmp39_;
					_tmp40_ = candidates;
					_tmp41_ = candidates;
					_tmp42_ = index;
					_tmp43_ = gee_list_get (_tmp41_, _tmp42_);
					_tmp44_ = (SkkCandidate*) _tmp43_;
					gee_list_set (_tmp40_, 0, _tmp44_);
					_g_object_unref0 (_tmp44_);
					_tmp45_ = candidates;
					_tmp46_ = index;
					_tmp47_ = first;
					gee_list_set (_tmp45_, _tmp46_, _tmp47_);
					result = TRUE;
					_g_object_unref0 (first);
					_g_object_unref0 (c);
					_g_object_unref0 (_c_list);
					_g_object_unref0 (candidates);
					_g_object_unref0 (entries);
					return result;
				}
				result = FALSE;
				_g_object_unref0 (c);
				_g_object_unref0 (_c_list);
				_g_object_unref0 (candidates);
				_g_object_unref0 (entries);
				return result;
			}
			_tmp48_ = index;
			index = _tmp48_ + 1;
			_g_object_unref0 (c);
		}
		_g_object_unref0 (_c_list);
	}
	_tmp49_ = candidates;
	_tmp50_ = candidate;
	gee_list_insert (_tmp49_, 0, _tmp50_);
	result = TRUE;
	_g_object_unref0 (candidates);
	_g_object_unref0 (entries);
	return result;
}


/**
         * {@inheritDoc}
         */
static gboolean skk_user_dict_real_purge_candidate (SkkDict* base, SkkCandidate* candidate) {
	SkkUserDict * self;
	gboolean result = FALSE;
	gboolean modified = FALSE;
	GeeMap* entries = NULL;
	SkkCandidate* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	GeeMap* _tmp3_;
	GeeMap* _tmp4_;
	SkkCandidate* _tmp5_;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	gboolean _tmp8_;
	self = (SkkUserDict*) base;
	g_return_val_if_fail (candidate != NULL, FALSE);
	modified = FALSE;
	_tmp0_ = candidate;
	_tmp1_ = skk_candidate_get_okuri (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = skk_user_dict_get_entries (self, _tmp2_);
	entries = _tmp3_;
	_tmp4_ = entries;
	_tmp5_ = candidate;
	_tmp6_ = skk_candidate_get_midasi (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = gee_map_has_key (_tmp4_, _tmp7_);
	if (_tmp8_) {
		GeeList* candidates = NULL;
		GeeMap* _tmp9_;
		SkkCandidate* _tmp10_;
		const gchar* _tmp11_;
		const gchar* _tmp12_;
		gpointer _tmp13_;
		GeeList* _tmp14_;
		gint _tmp15_;
		gint _tmp16_;
		_tmp9_ = entries;
		_tmp10_ = candidate;
		_tmp11_ = skk_candidate_get_midasi (_tmp10_);
		_tmp12_ = _tmp11_;
		_tmp13_ = gee_map_get (_tmp9_, _tmp12_);
		candidates = (GeeList*) _tmp13_;
		_tmp14_ = candidates;
		_tmp15_ = gee_collection_get_size ((GeeCollection*) _tmp14_);
		_tmp16_ = _tmp15_;
		if (_tmp16_ > 0) {
			GeeIterator* iter = NULL;
			GeeList* _tmp17_;
			GeeIterator* _tmp18_;
			GeeList* _tmp30_;
			gint _tmp31_;
			gint _tmp32_;
			_tmp17_ = candidates;
			_tmp18_ = gee_iterable_iterator ((GeeIterable*) _tmp17_);
			iter = _tmp18_;
			while (TRUE) {
				GeeIterator* _tmp19_;
				gboolean _tmp20_;
				SkkCandidate* c = NULL;
				GeeIterator* _tmp21_;
				gpointer _tmp22_;
				SkkCandidate* _tmp23_;
				const gchar* _tmp24_;
				const gchar* _tmp25_;
				SkkCandidate* _tmp26_;
				const gchar* _tmp27_;
				const gchar* _tmp28_;
				_tmp19_ = iter;
				_tmp20_ = gee_iterator_next (_tmp19_);
				if (!_tmp20_) {
					break;
				}
				_tmp21_ = iter;
				_tmp22_ = gee_iterator_get (_tmp21_);
				c = (SkkCandidate*) _tmp22_;
				_tmp23_ = c;
				_tmp24_ = skk_candidate_get_text (_tmp23_);
				_tmp25_ = _tmp24_;
				_tmp26_ = candidate;
				_tmp27_ = skk_candidate_get_text (_tmp26_);
				_tmp28_ = _tmp27_;
				if (g_strcmp0 (_tmp25_, _tmp28_) == 0) {
					GeeIterator* _tmp29_;
					_tmp29_ = iter;
					gee_iterator_remove (_tmp29_);
					modified = TRUE;
				}
				_g_object_unref0 (c);
			}
			_tmp30_ = candidates;
			_tmp31_ = gee_collection_get_size ((GeeCollection*) _tmp30_);
			_tmp32_ = _tmp31_;
			if (_tmp32_ == 0) {
				GeeMap* _tmp33_;
				SkkCandidate* _tmp34_;
				const gchar* _tmp35_;
				const gchar* _tmp36_;
				_tmp33_ = entries;
				_tmp34_ = candidate;
				_tmp35_ = skk_candidate_get_midasi (_tmp34_);
				_tmp36_ = _tmp35_;
				gee_map_unset (_tmp33_, _tmp36_, NULL);
			}
			_g_object_unref0 (iter);
		}
		_g_object_unref0 (candidates);
	}
	result = modified;
	_g_object_unref0 (entries);
	return result;
}


/**
         * Create a new UserDict.
         *
         * @param path a path to the file
         * @param encoding encoding of the file (default UTF-8)
         *
         * @return a new UserDict
         * @throws GLib.Error if opening the file is failed
         */
SkkUserDict* skk_user_dict_construct (GType object_type, const gchar* path, const gchar* encoding, GError** error) {
	SkkUserDict * self = NULL;
	const gchar* _tmp0_;
	GFile* _tmp1_;
	gchar* _tmp2_;
	SkkEncodingConverter* _tmp3_ = NULL;
	const gchar* _tmp4_;
	SkkEncodingConverter* _tmp5_;
	SkkEncodingConverter* _tmp6_;
	const gchar* _tmp7_;
	gboolean _tmp8_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (path != NULL, NULL);
	g_return_val_if_fail (encoding != NULL, NULL);
	self = (SkkUserDict*) skk_dict_construct (object_type);
	_tmp0_ = path;
	_tmp1_ = g_file_new_for_path (_tmp0_);
	_g_object_unref0 (self->priv->file);
	self->priv->file = _tmp1_;
	_tmp2_ = g_strdup ("");
	_g_free0 (self->priv->etag);
	self->priv->etag = _tmp2_;
	_tmp4_ = encoding;
	_tmp5_ = skk_encoding_converter_new (_tmp4_, &_inner_error_);
	_tmp3_ = _tmp5_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (self);
		return NULL;
	}
	_tmp6_ = _tmp3_;
	_tmp3_ = NULL;
	_g_object_unref0 (self->priv->converter);
	self->priv->converter = _tmp6_;
	_tmp7_ = path;
	_tmp8_ = g_file_test (_tmp7_, G_FILE_TEST_EXISTS);
	if (_tmp8_) {
		skk_dict_reload ((SkkDict*) self, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (_tmp3_);
			_g_object_unref0 (self);
			return NULL;
		}
	}
	_g_object_unref0 (_tmp3_);
	return self;
}


SkkUserDict* skk_user_dict_new (const gchar* path, const gchar* encoding, GError** error) {
	return skk_user_dict_construct (SKK_TYPE_USER_DICT, path, encoding, error);
}


static gboolean skk_user_dict_real_get_read_only (SkkDict* base) {
	gboolean result;
	SkkUserDict* self;
	self = (SkkUserDict*) base;
	result = FALSE;
	return result;
}


static void skk_user_dict_class_init (SkkUserDictClass * klass) {
	skk_user_dict_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (SkkUserDictPrivate));
	((SkkDictClass *) klass)->reload = (void (*) (SkkDict *, GError**)) skk_user_dict_real_reload;
	((SkkDictClass *) klass)->save = (void (*) (SkkDict *, GError**)) skk_user_dict_real_save;
	((SkkDictClass *) klass)->lookup = (SkkCandidate** (*) (SkkDict *, const gchar*, gboolean, int*)) skk_user_dict_real_lookup;
	((SkkDictClass *) klass)->complete = (gchar** (*) (SkkDict *, const gchar*, int*)) skk_user_dict_real_complete;
	((SkkDictClass *) klass)->select_candidate = (gboolean (*) (SkkDict *, SkkCandidate*)) skk_user_dict_real_select_candidate;
	((SkkDictClass *) klass)->purge_candidate = (gboolean (*) (SkkDict *, SkkCandidate*)) skk_user_dict_real_purge_candidate;
	SKK_DICT_CLASS (klass)->get_read_only = skk_user_dict_real_get_read_only;
	G_OBJECT_CLASS (klass)->get_property = _vala_skk_user_dict_get_property;
	G_OBJECT_CLASS (klass)->finalize = skk_user_dict_finalize;
	/**
	         * {@inheritDoc}
	         */
	g_object_class_install_property (G_OBJECT_CLASS (klass), SKK_USER_DICT_READ_ONLY_PROPERTY, skk_user_dict_properties[SKK_USER_DICT_READ_ONLY_PROPERTY] = g_param_spec_boolean ("read-only", "read-only", "read-only", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
}


static void skk_user_dict_instance_init (SkkUserDict * self) {
	GeeHashMap* _tmp0_;
	GeeHashMap* _tmp1_;
	self->priv = SKK_USER_DICT_GET_PRIVATE (self);
	_tmp0_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, GEE_TYPE_LIST, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	self->priv->okuri_ari_entries = (GeeMap*) _tmp0_;
	_tmp1_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, GEE_TYPE_LIST, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	self->priv->okuri_nasi_entries = (GeeMap*) _tmp1_;
}


static void skk_user_dict_finalize (GObject * obj) {
	SkkUserDict * self;
	GeeMapIterator* okuri_ari_iter = NULL;
	GeeMap* _tmp0_;
	GeeMapIterator* _tmp1_;
	GeeMap* _tmp7_;
	GeeMapIterator* okuri_nasi_iter = NULL;
	GeeMap* _tmp8_;
	GeeMapIterator* _tmp9_;
	GeeMap* _tmp15_;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SKK_TYPE_USER_DICT, SkkUserDict);
	_tmp0_ = self->priv->okuri_ari_entries;
	_tmp1_ = gee_map_map_iterator (_tmp0_);
	okuri_ari_iter = _tmp1_;
	while (TRUE) {
		GeeMapIterator* _tmp2_;
		gboolean _tmp3_;
		GeeMapIterator* _tmp4_;
		gpointer _tmp5_;
		GeeList* _tmp6_;
		_tmp2_ = okuri_ari_iter;
		_tmp3_ = gee_map_iterator_next (_tmp2_);
		if (!_tmp3_) {
			break;
		}
		_tmp4_ = okuri_ari_iter;
		_tmp5_ = gee_map_iterator_get_value (_tmp4_);
		_tmp6_ = (GeeList*) _tmp5_;
		gee_collection_clear ((GeeCollection*) _tmp6_);
		_g_object_unref0 (_tmp6_);
	}
	_tmp7_ = self->priv->okuri_ari_entries;
	gee_map_clear (_tmp7_);
	_tmp8_ = self->priv->okuri_nasi_entries;
	_tmp9_ = gee_map_map_iterator (_tmp8_);
	okuri_nasi_iter = _tmp9_;
	while (TRUE) {
		GeeMapIterator* _tmp10_;
		gboolean _tmp11_;
		GeeMapIterator* _tmp12_;
		gpointer _tmp13_;
		GeeList* _tmp14_;
		_tmp10_ = okuri_nasi_iter;
		_tmp11_ = gee_map_iterator_next (_tmp10_);
		if (!_tmp11_) {
			break;
		}
		_tmp12_ = okuri_nasi_iter;
		_tmp13_ = gee_map_iterator_get_value (_tmp12_);
		_tmp14_ = (GeeList*) _tmp13_;
		gee_collection_clear ((GeeCollection*) _tmp14_);
		_g_object_unref0 (_tmp14_);
	}
	_tmp15_ = self->priv->okuri_nasi_entries;
	gee_map_clear (_tmp15_);
	_g_object_unref0 (okuri_nasi_iter);
	_g_object_unref0 (okuri_ari_iter);
	_g_object_unref0 (self->priv->file);
	_g_free0 (self->priv->etag);
	_g_object_unref0 (self->priv->converter);
	_g_object_unref0 (self->priv->okuri_ari_entries);
	_g_object_unref0 (self->priv->okuri_nasi_entries);
	G_OBJECT_CLASS (skk_user_dict_parent_class)->finalize (obj);
}


/**
     * File based implementation of Dict with write access.
     */
GType skk_user_dict_get_type (void) {
	static volatile gsize skk_user_dict_type_id__volatile = 0;
	if (g_once_init_enter (&skk_user_dict_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SkkUserDictClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) skk_user_dict_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SkkUserDict), 0, (GInstanceInitFunc) skk_user_dict_instance_init, NULL };
		GType skk_user_dict_type_id;
		skk_user_dict_type_id = g_type_register_static (SKK_TYPE_DICT, "SkkUserDict", &g_define_type_info, 0);
		g_once_init_leave (&skk_user_dict_type_id__volatile, skk_user_dict_type_id);
	}
	return skk_user_dict_type_id__volatile;
}


static void _vala_skk_user_dict_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	SkkUserDict * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SKK_TYPE_USER_DICT, SkkUserDict);
	switch (property_id) {
		case SKK_USER_DICT_READ_ONLY_PROPERTY:
		g_value_set_boolean (value, skk_dict_get_read_only ((SkkDict*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



