/* map-file.c generated by valac 0.38.1.30-90885, the Vala compiler
 * generated from map-file.vala, do not modify */

/*
 * Copyright (C) 2011-2017 Daiki Ueno <ueno@gnu.org>
 * Copyright (C) 2011-2017 Red Hat, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <json-glib/json-glib.h>


#define SKK_TYPE_MAP_FILE (skk_map_file_get_type ())
#define SKK_MAP_FILE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SKK_TYPE_MAP_FILE, SkkMapFile))
#define SKK_MAP_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SKK_TYPE_MAP_FILE, SkkMapFileClass))
#define SKK_IS_MAP_FILE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SKK_TYPE_MAP_FILE))
#define SKK_IS_MAP_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SKK_TYPE_MAP_FILE))
#define SKK_MAP_FILE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SKK_TYPE_MAP_FILE, SkkMapFileClass))

typedef struct _SkkMapFile SkkMapFile;
typedef struct _SkkMapFileClass SkkMapFileClass;
typedef struct _SkkMapFilePrivate SkkMapFilePrivate;
enum  {
	SKK_MAP_FILE_0_PROPERTY,
	SKK_MAP_FILE_NUM_PROPERTIES
};
static GParamSpec* skk_map_file_properties[SKK_MAP_FILE_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define __vala_JsonNode_free0(var) ((var == NULL) ? NULL : (var = (_vala_JsonNode_free (var), NULL)))
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))

#define SKK_TYPE_RULE_METADATA (skk_rule_metadata_get_type ())
typedef struct _SkkRuleMetadata SkkRuleMetadata;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _json_object_unref0(var) ((var == NULL) ? NULL : (var = (json_object_unref (var), NULL)))
#define _skk_rule_metadata_free0(var) ((var == NULL) ? NULL : (var = (skk_rule_metadata_free (var), NULL)))
#define _json_array_unref0(var) ((var == NULL) ? NULL : (var = (json_array_unref (var), NULL)))

struct _SkkMapFile {
	GObject parent_instance;
	SkkMapFilePrivate * priv;
};

struct _SkkMapFileClass {
	GObjectClass parent_class;
};

struct _SkkMapFilePrivate {
	GeeMap* maps;
};

struct _SkkRuleMetadata {
	gchar* base_dir;
	gchar* name;
	gchar* label;
	gchar* description;
	gchar* filter;
};

typedef enum  {
	SKK_RULE_PARSE_ERROR_FAILED
} SkkRuleParseError;
#define SKK_RULE_PARSE_ERROR skk_rule_parse_error_quark ()

static gpointer skk_map_file_parent_class = NULL;

GType skk_map_file_get_type (void) G_GNUC_CONST;
#define SKK_MAP_FILE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), SKK_TYPE_MAP_FILE, SkkMapFilePrivate))
static void skk_map_file_load_map (SkkMapFile* self, GeeMap* map, JsonObject* object);
static JsonNode* _vala_JsonNode_copy (JsonNode* self);
static void _vala_JsonNode_free (JsonNode* self);
GType skk_rule_metadata_get_type (void) G_GNUC_CONST;
SkkRuleMetadata* skk_rule_metadata_dup (const SkkRuleMetadata* self);
void skk_rule_metadata_free (SkkRuleMetadata* self);
void skk_rule_metadata_copy (const SkkRuleMetadata* self, SkkRuleMetadata* dest);
void skk_rule_metadata_destroy (SkkRuleMetadata* self);
GQuark skk_rule_parse_error_quark (void);
static void skk_map_file_load (SkkMapFile* self, SkkRuleMetadata* metadata, const gchar* type, const gchar* name, GeeSet* included, GError** error);
gchar* skk_rule_metadata_locate_map_file (SkkRuleMetadata *self, const gchar* type, const gchar* name);
SkkRuleMetadata* skk_rule_find_rule (const gchar* name);
SkkMapFile* skk_map_file_construct (GType object_type, SkkRuleMetadata* metadata, const gchar* type, const gchar* name, GError** error);
gboolean skk_map_file_has_map (SkkMapFile* self, const gchar* name);
GeeMap* skk_map_file_get (SkkMapFile* self, const gchar* name);
static void skk_map_file_finalize (GObject * obj);


static JsonNode* _vala_JsonNode_copy (JsonNode* self) {
	return g_boxed_copy (json_node_get_type (), self);
}


static gpointer __vala_JsonNode_copy0 (gpointer self) {
	return self ? _vala_JsonNode_copy (self) : NULL;
}


static void _vala_JsonNode_free (JsonNode* self) {
	g_boxed_free (json_node_get_type (), self);
}


static void skk_map_file_load_map (SkkMapFile* self, GeeMap* map, JsonObject* object) {
	GList* keys = NULL;
	JsonObject* _tmp0_;
	GList* _tmp1_;
	GList* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (map != NULL);
	g_return_if_fail (object != NULL);
	_tmp0_ = object;
	_tmp1_ = json_object_get_members (_tmp0_);
	keys = _tmp1_;
	_tmp2_ = keys;
	{
		GList* key_collection = NULL;
		GList* key_it = NULL;
		key_collection = _tmp2_;
		for (key_it = key_collection; key_it != NULL; key_it = key_it->next) {
			const gchar* key = NULL;
			key = (const gchar*) key_it->data;
			{
				JsonNode* value = NULL;
				JsonObject* _tmp3_;
				const gchar* _tmp4_;
				JsonNode* _tmp5_;
				JsonNode* _tmp6_;
				JsonNode* _tmp7_;
				JsonNodeType _tmp8_;
				_tmp3_ = object;
				_tmp4_ = key;
				_tmp5_ = json_object_get_member (_tmp3_, _tmp4_);
				_tmp6_ = __vala_JsonNode_copy0 (_tmp5_);
				value = _tmp6_;
				_tmp7_ = value;
				_tmp8_ = json_node_get_node_type (_tmp7_);
				if (_tmp8_ == JSON_NODE_NULL) {
					GeeMap* _tmp9_;
					const gchar* _tmp10_;
					_tmp9_ = map;
					_tmp10_ = key;
					gee_map_unset (_tmp9_, _tmp10_, NULL);
				} else {
					GeeMap* _tmp11_;
					const gchar* _tmp12_;
					JsonNode* _tmp13_;
					_tmp11_ = map;
					_tmp12_ = key;
					_tmp13_ = value;
					gee_map_set (_tmp11_, _tmp12_, _tmp13_);
				}
				__vala_JsonNode_free0 (value);
			}
		}
	}
	_g_list_free0 (keys);
}


static gpointer _json_object_ref0 (gpointer self) {
	return self ? json_object_ref (self) : NULL;
}


static gpointer _json_array_ref0 (gpointer self) {
	return self ? json_array_ref (self) : NULL;
}


static gint string_index_of (const gchar* self, const gchar* needle, gint start_index) {
	gint result = 0;
	gchar* _result_ = NULL;
	gint _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (needle != NULL, 0);
	_tmp0_ = start_index;
	_tmp1_ = needle;
	_tmp2_ = strstr (((gchar*) self) + _tmp0_, (gchar*) _tmp1_);
	_result_ = _tmp2_;
	_tmp3_ = _result_;
	if (_tmp3_ != NULL) {
		gchar* _tmp4_;
		_tmp4_ = _result_;
		result = (gint) (_tmp4_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}


static gchar* string_slice (const gchar* self, glong start, glong end) {
	gchar* result = NULL;
	glong string_length = 0L;
	gint _tmp0_;
	gint _tmp1_;
	glong _tmp2_;
	glong _tmp5_;
	gboolean _tmp8_ = FALSE;
	glong _tmp9_;
	gboolean _tmp12_ = FALSE;
	glong _tmp13_;
	glong _tmp16_;
	glong _tmp17_;
	glong _tmp18_;
	glong _tmp19_;
	glong _tmp20_;
	gchar* _tmp21_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	string_length = (glong) _tmp1_;
	_tmp2_ = start;
	if (_tmp2_ < ((glong) 0)) {
		glong _tmp3_;
		glong _tmp4_;
		_tmp3_ = string_length;
		_tmp4_ = start;
		start = _tmp3_ + _tmp4_;
	}
	_tmp5_ = end;
	if (_tmp5_ < ((glong) 0)) {
		glong _tmp6_;
		glong _tmp7_;
		_tmp6_ = string_length;
		_tmp7_ = end;
		end = _tmp6_ + _tmp7_;
	}
	_tmp9_ = start;
	if (_tmp9_ >= ((glong) 0)) {
		glong _tmp10_;
		glong _tmp11_;
		_tmp10_ = start;
		_tmp11_ = string_length;
		_tmp8_ = _tmp10_ <= _tmp11_;
	} else {
		_tmp8_ = FALSE;
	}
	g_return_val_if_fail (_tmp8_, NULL);
	_tmp13_ = end;
	if (_tmp13_ >= ((glong) 0)) {
		glong _tmp14_;
		glong _tmp15_;
		_tmp14_ = end;
		_tmp15_ = string_length;
		_tmp12_ = _tmp14_ <= _tmp15_;
	} else {
		_tmp12_ = FALSE;
	}
	g_return_val_if_fail (_tmp12_, NULL);
	_tmp16_ = start;
	_tmp17_ = end;
	g_return_val_if_fail (_tmp16_ <= _tmp17_, NULL);
	_tmp18_ = start;
	_tmp19_ = end;
	_tmp20_ = start;
	_tmp21_ = g_strndup (((gchar*) self) + _tmp18_, (gsize) (_tmp19_ - _tmp20_));
	result = _tmp21_;
	return result;
}


static void skk_map_file_load (SkkMapFile* self, SkkRuleMetadata* metadata, const gchar* type, const gchar* name, GeeSet* included, GError** error) {
	gchar* filename = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	const gchar* _tmp3_;
	JsonParser* parser = NULL;
	JsonParser* _tmp6_;
	JsonNode* root = NULL;
	JsonParser* _tmp19_;
	JsonNode* _tmp20_;
	JsonNode* _tmp21_;
	JsonNode* _tmp22_;
	JsonNodeType _tmp23_;
	JsonObject* object = NULL;
	JsonNode* _tmp25_;
	JsonObject* _tmp26_;
	JsonObject* _tmp27_;
	JsonNode* member = NULL;
	JsonObject* _tmp28_;
	gboolean _tmp29_;
	JsonObject* _tmp77_;
	gboolean _tmp78_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (metadata != NULL);
	g_return_if_fail (type != NULL);
	g_return_if_fail (name != NULL);
	g_return_if_fail (included != NULL);
	_tmp0_ = type;
	_tmp1_ = name;
	_tmp2_ = skk_rule_metadata_locate_map_file (metadata, _tmp0_, _tmp1_);
	filename = _tmp2_;
	_tmp3_ = filename;
	if (_tmp3_ == NULL) {
		const gchar* _tmp4_;
		GError* _tmp5_;
		_tmp4_ = filename;
		_tmp5_ = g_error_new (SKK_RULE_PARSE_ERROR, SKK_RULE_PARSE_ERROR_FAILED, "no such file %s", _tmp4_);
		_inner_error_ = _tmp5_;
		if (_inner_error_->domain == SKK_RULE_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (filename);
			return;
		} else {
			_g_free0 (filename);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp6_ = json_parser_new ();
	parser = _tmp6_;
	{
		gboolean _tmp7_ = FALSE;
		JsonParser* _tmp8_;
		const gchar* _tmp9_;
		gboolean _tmp10_;
		_tmp8_ = parser;
		_tmp9_ = filename;
		_tmp10_ = json_parser_load_from_file (_tmp8_, _tmp9_, &_inner_error_);
		_tmp7_ = _tmp10_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch28_g_error;
		}
		if (!_tmp7_) {
			GError* _tmp11_;
			_tmp11_ = g_error_new_literal (SKK_RULE_PARSE_ERROR, SKK_RULE_PARSE_ERROR_FAILED, "");
			_inner_error_ = _tmp11_;
			goto __catch28_g_error;
		}
	}
	goto __finally28;
	__catch28_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp12_;
		GError* _tmp13_;
		const gchar* _tmp14_;
		gchar* _tmp15_;
		gchar* _tmp16_;
		GError* _tmp17_;
		GError* _tmp18_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp12_ = filename;
		_tmp13_ = e;
		_tmp14_ = _tmp13_->message;
		_tmp15_ = g_strdup_printf ("can't load %s: %s", _tmp12_, _tmp14_);
		_tmp16_ = _tmp15_;
		_tmp17_ = g_error_new_literal (SKK_RULE_PARSE_ERROR, SKK_RULE_PARSE_ERROR_FAILED, _tmp16_);
		_tmp18_ = _tmp17_;
		_g_free0 (_tmp16_);
		_inner_error_ = _tmp18_;
		_g_error_free0 (e);
		goto __finally28;
	}
	__finally28:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == SKK_RULE_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (parser);
			_g_free0 (filename);
			return;
		} else {
			_g_object_unref0 (parser);
			_g_free0 (filename);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp19_ = parser;
	_tmp20_ = json_parser_get_root (_tmp19_);
	_tmp21_ = __vala_JsonNode_copy0 (_tmp20_);
	root = _tmp21_;
	_tmp22_ = root;
	_tmp23_ = json_node_get_node_type (_tmp22_);
	if (_tmp23_ != JSON_NODE_OBJECT) {
		GError* _tmp24_;
		_tmp24_ = g_error_new_literal (SKK_RULE_PARSE_ERROR, SKK_RULE_PARSE_ERROR_FAILED, "root element must be an object");
		_inner_error_ = _tmp24_;
		if (_inner_error_->domain == SKK_RULE_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			__vala_JsonNode_free0 (root);
			_g_object_unref0 (parser);
			_g_free0 (filename);
			return;
		} else {
			__vala_JsonNode_free0 (root);
			_g_object_unref0 (parser);
			_g_free0 (filename);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp25_ = root;
	_tmp26_ = json_node_get_object (_tmp25_);
	_tmp27_ = _json_object_ref0 (_tmp26_);
	object = _tmp27_;
	_tmp28_ = object;
	_tmp29_ = json_object_has_member (_tmp28_, "include");
	if (_tmp29_) {
		JsonObject* _tmp30_;
		JsonNode* _tmp31_;
		JsonNode* _tmp32_;
		JsonNode* _tmp33_;
		JsonNodeType _tmp34_;
		JsonArray* include = NULL;
		JsonNode* _tmp36_;
		JsonArray* _tmp37_;
		JsonArray* _tmp38_;
		GList* elements = NULL;
		JsonArray* _tmp39_;
		GList* _tmp40_;
		GList* _tmp41_;
		_tmp30_ = object;
		_tmp31_ = json_object_get_member (_tmp30_, "include");
		_tmp32_ = __vala_JsonNode_copy0 (_tmp31_);
		__vala_JsonNode_free0 (member);
		member = _tmp32_;
		_tmp33_ = member;
		_tmp34_ = json_node_get_node_type (_tmp33_);
		if (_tmp34_ != JSON_NODE_ARRAY) {
			GError* _tmp35_;
			_tmp35_ = g_error_new_literal (SKK_RULE_PARSE_ERROR, SKK_RULE_PARSE_ERROR_FAILED, "\"include\" element must be an array");
			_inner_error_ = _tmp35_;
			if (_inner_error_->domain == SKK_RULE_PARSE_ERROR) {
				g_propagate_error (error, _inner_error_);
				__vala_JsonNode_free0 (member);
				_json_object_unref0 (object);
				__vala_JsonNode_free0 (root);
				_g_object_unref0 (parser);
				_g_free0 (filename);
				return;
			} else {
				__vala_JsonNode_free0 (member);
				_json_object_unref0 (object);
				__vala_JsonNode_free0 (root);
				_g_object_unref0 (parser);
				_g_free0 (filename);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		_tmp36_ = member;
		_tmp37_ = json_node_get_array (_tmp36_);
		_tmp38_ = _json_array_ref0 (_tmp37_);
		include = _tmp38_;
		_tmp39_ = include;
		_tmp40_ = json_array_get_elements (_tmp39_);
		elements = _tmp40_;
		_tmp41_ = elements;
		{
			GList* element_collection = NULL;
			GList* element_it = NULL;
			element_collection = _tmp41_;
			for (element_it = element_collection; element_it != NULL; element_it = element_it->next) {
				JsonNode* element = NULL;
				element = (JsonNode*) element_it->data;
				{
					gchar* parent = NULL;
					JsonNode* _tmp42_;
					const gchar* _tmp43_;
					gchar* _tmp44_;
					GeeSet* _tmp45_;
					const gchar* _tmp46_;
					gboolean _tmp47_;
					gchar* parent_rule = NULL;
					gchar* parent_name = NULL;
					gint index = 0;
					const gchar* _tmp48_;
					gint _tmp49_;
					gint _tmp50_;
					SkkRuleMetadata* parent_metadata = NULL;
					const gchar* _tmp65_;
					SkkRuleMetadata* _tmp66_;
					SkkRuleMetadata* _tmp67_;
					SkkRuleMetadata* _tmp70_;
					const gchar* _tmp71_;
					const gchar* _tmp72_;
					GeeSet* _tmp73_;
					SkkRuleMetadata _tmp74_;
					GeeSet* _tmp75_;
					const gchar* _tmp76_;
					_tmp42_ = element;
					_tmp43_ = json_node_get_string (_tmp42_);
					_tmp44_ = g_strdup (_tmp43_);
					parent = _tmp44_;
					_tmp45_ = included;
					_tmp46_ = parent;
					_tmp47_ = gee_collection_contains ((GeeCollection*) _tmp45_, _tmp46_);
					if (_tmp47_) {
						_g_free0 (parent);
						continue;
					}
					_tmp48_ = parent;
					_tmp49_ = string_index_of (_tmp48_, "/", 0);
					index = _tmp49_;
					_tmp50_ = index;
					if (_tmp50_ < 0) {
						SkkRuleMetadata _tmp51_;
						const gchar* _tmp52_;
						gchar* _tmp53_;
						const gchar* _tmp54_;
						gchar* _tmp55_;
						_tmp51_ = *metadata;
						_tmp52_ = _tmp51_.name;
						_tmp53_ = g_strdup (_tmp52_);
						_g_free0 (parent_rule);
						parent_rule = _tmp53_;
						_tmp54_ = parent;
						_tmp55_ = g_strdup (_tmp54_);
						_g_free0 (parent_name);
						parent_name = _tmp55_;
					} else {
						const gchar* _tmp56_;
						gint _tmp57_;
						gchar* _tmp58_;
						const gchar* _tmp59_;
						gint _tmp60_;
						const gchar* _tmp61_;
						gint _tmp62_;
						gint _tmp63_;
						gchar* _tmp64_;
						_tmp56_ = parent;
						_tmp57_ = index;
						_tmp58_ = string_slice (_tmp56_, (glong) 0, (glong) _tmp57_);
						_g_free0 (parent_rule);
						parent_rule = _tmp58_;
						_tmp59_ = parent;
						_tmp60_ = index;
						_tmp61_ = parent;
						_tmp62_ = strlen (_tmp61_);
						_tmp63_ = _tmp62_;
						_tmp64_ = string_slice (_tmp59_, (glong) (_tmp60_ + 1), (glong) _tmp63_);
						_g_free0 (parent_name);
						parent_name = _tmp64_;
					}
					_tmp65_ = parent_rule;
					_tmp66_ = skk_rule_find_rule (_tmp65_);
					parent_metadata = _tmp66_;
					_tmp67_ = parent_metadata;
					if (_tmp67_ == NULL) {
						const gchar* _tmp68_;
						GError* _tmp69_;
						_tmp68_ = parent_rule;
						_tmp69_ = g_error_new (SKK_RULE_PARSE_ERROR, SKK_RULE_PARSE_ERROR_FAILED, "can't find rule %s", _tmp68_);
						_inner_error_ = _tmp69_;
						if (_inner_error_->domain == SKK_RULE_PARSE_ERROR) {
							g_propagate_error (error, _inner_error_);
							_skk_rule_metadata_free0 (parent_metadata);
							_g_free0 (parent_name);
							_g_free0 (parent_rule);
							_g_free0 (parent);
							_g_list_free0 (elements);
							_json_array_unref0 (include);
							__vala_JsonNode_free0 (member);
							_json_object_unref0 (object);
							__vala_JsonNode_free0 (root);
							_g_object_unref0 (parser);
							_g_free0 (filename);
							return;
						} else {
							_skk_rule_metadata_free0 (parent_metadata);
							_g_free0 (parent_name);
							_g_free0 (parent_rule);
							_g_free0 (parent);
							_g_list_free0 (elements);
							_json_array_unref0 (include);
							__vala_JsonNode_free0 (member);
							_json_object_unref0 (object);
							__vala_JsonNode_free0 (root);
							_g_object_unref0 (parser);
							_g_free0 (filename);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return;
						}
					}
					_tmp70_ = parent_metadata;
					_tmp71_ = type;
					_tmp72_ = parent_name;
					_tmp73_ = included;
					_tmp74_ = *_tmp70_;
					skk_map_file_load (self, &_tmp74_, _tmp71_, _tmp72_, _tmp73_, &_inner_error_);
					if (G_UNLIKELY (_inner_error_ != NULL)) {
						if (_inner_error_->domain == SKK_RULE_PARSE_ERROR) {
							g_propagate_error (error, _inner_error_);
							_skk_rule_metadata_free0 (parent_metadata);
							_g_free0 (parent_name);
							_g_free0 (parent_rule);
							_g_free0 (parent);
							_g_list_free0 (elements);
							_json_array_unref0 (include);
							__vala_JsonNode_free0 (member);
							_json_object_unref0 (object);
							__vala_JsonNode_free0 (root);
							_g_object_unref0 (parser);
							_g_free0 (filename);
							return;
						} else {
							_skk_rule_metadata_free0 (parent_metadata);
							_g_free0 (parent_name);
							_g_free0 (parent_rule);
							_g_free0 (parent);
							_g_list_free0 (elements);
							_json_array_unref0 (include);
							__vala_JsonNode_free0 (member);
							_json_object_unref0 (object);
							__vala_JsonNode_free0 (root);
							_g_object_unref0 (parser);
							_g_free0 (filename);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return;
						}
					}
					_tmp75_ = included;
					_tmp76_ = parent;
					gee_collection_add ((GeeCollection*) _tmp75_, _tmp76_);
					_skk_rule_metadata_free0 (parent_metadata);
					_g_free0 (parent_name);
					_g_free0 (parent_rule);
					_g_free0 (parent);
				}
			}
		}
		_g_list_free0 (elements);
		_json_array_unref0 (include);
	}
	_tmp77_ = object;
	_tmp78_ = json_object_has_member (_tmp77_, "define");
	if (_tmp78_) {
		JsonObject* _tmp79_;
		JsonNode* _tmp80_;
		JsonNode* _tmp81_;
		JsonNode* _tmp82_;
		JsonNodeType _tmp83_;
		JsonObject* define = NULL;
		JsonNode* _tmp85_;
		JsonObject* _tmp86_;
		JsonObject* _tmp87_;
		GList* keys = NULL;
		JsonObject* _tmp88_;
		GList* _tmp89_;
		GList* _tmp90_;
		_tmp79_ = object;
		_tmp80_ = json_object_get_member (_tmp79_, "define");
		_tmp81_ = __vala_JsonNode_copy0 (_tmp80_);
		__vala_JsonNode_free0 (member);
		member = _tmp81_;
		_tmp82_ = member;
		_tmp83_ = json_node_get_node_type (_tmp82_);
		if (_tmp83_ != JSON_NODE_OBJECT) {
			GError* _tmp84_;
			_tmp84_ = g_error_new_literal (SKK_RULE_PARSE_ERROR, SKK_RULE_PARSE_ERROR_FAILED, "\"define\" element must be an object");
			_inner_error_ = _tmp84_;
			if (_inner_error_->domain == SKK_RULE_PARSE_ERROR) {
				g_propagate_error (error, _inner_error_);
				__vala_JsonNode_free0 (member);
				_json_object_unref0 (object);
				__vala_JsonNode_free0 (root);
				_g_object_unref0 (parser);
				_g_free0 (filename);
				return;
			} else {
				__vala_JsonNode_free0 (member);
				_json_object_unref0 (object);
				__vala_JsonNode_free0 (root);
				_g_object_unref0 (parser);
				_g_free0 (filename);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		_tmp85_ = member;
		_tmp86_ = json_node_get_object (_tmp85_);
		_tmp87_ = _json_object_ref0 (_tmp86_);
		define = _tmp87_;
		_tmp88_ = define;
		_tmp89_ = json_object_get_members (_tmp88_);
		keys = _tmp89_;
		_tmp90_ = keys;
		{
			GList* key_collection = NULL;
			GList* key_it = NULL;
			key_collection = _tmp90_;
			for (key_it = key_collection; key_it != NULL; key_it = key_it->next) {
				const gchar* key = NULL;
				key = (const gchar*) key_it->data;
				{
					GeeMap* _tmp91_;
					const gchar* _tmp92_;
					gboolean _tmp93_;
					JsonObject* _tmp98_;
					const gchar* _tmp99_;
					JsonNode* _tmp100_;
					JsonNode* _tmp101_;
					JsonNode* _tmp102_;
					JsonNodeType _tmp103_;
					GeeMap* _tmp105_;
					const gchar* _tmp106_;
					gpointer _tmp107_;
					GeeMap* _tmp108_;
					JsonNode* _tmp109_;
					JsonObject* _tmp110_;
					_tmp91_ = self->priv->maps;
					_tmp92_ = key;
					_tmp93_ = gee_map_has_key (_tmp91_, _tmp92_);
					if (!_tmp93_) {
						GeeHashMap* map = NULL;
						GeeHashMap* _tmp94_;
						GeeMap* _tmp95_;
						const gchar* _tmp96_;
						GeeHashMap* _tmp97_;
						_tmp94_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, json_node_get_type (), (GBoxedCopyFunc) _vala_JsonNode_copy, (GDestroyNotify) _vala_JsonNode_free, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
						map = _tmp94_;
						_tmp95_ = self->priv->maps;
						_tmp96_ = key;
						_tmp97_ = map;
						gee_map_set (_tmp95_, _tmp96_, (GeeMap*) _tmp97_);
						_g_object_unref0 (map);
					}
					_tmp98_ = define;
					_tmp99_ = key;
					_tmp100_ = json_object_get_member (_tmp98_, _tmp99_);
					_tmp101_ = __vala_JsonNode_copy0 (_tmp100_);
					__vala_JsonNode_free0 (member);
					member = _tmp101_;
					_tmp102_ = member;
					_tmp103_ = json_node_get_node_type (_tmp102_);
					if (_tmp103_ != JSON_NODE_OBJECT) {
						GError* _tmp104_;
						_tmp104_ = g_error_new_literal (SKK_RULE_PARSE_ERROR, SKK_RULE_PARSE_ERROR_FAILED, "map element must be an object");
						_inner_error_ = _tmp104_;
						if (_inner_error_->domain == SKK_RULE_PARSE_ERROR) {
							g_propagate_error (error, _inner_error_);
							_g_list_free0 (keys);
							_json_object_unref0 (define);
							__vala_JsonNode_free0 (member);
							_json_object_unref0 (object);
							__vala_JsonNode_free0 (root);
							_g_object_unref0 (parser);
							_g_free0 (filename);
							return;
						} else {
							_g_list_free0 (keys);
							_json_object_unref0 (define);
							__vala_JsonNode_free0 (member);
							_json_object_unref0 (object);
							__vala_JsonNode_free0 (root);
							_g_object_unref0 (parser);
							_g_free0 (filename);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return;
						}
					}
					_tmp105_ = self->priv->maps;
					_tmp106_ = key;
					_tmp107_ = gee_map_get (_tmp105_, _tmp106_);
					_tmp108_ = (GeeMap*) _tmp107_;
					_tmp109_ = member;
					_tmp110_ = json_node_get_object (_tmp109_);
					skk_map_file_load_map (self, _tmp108_, _tmp110_);
					_g_object_unref0 (_tmp108_);
				}
			}
		}
		_g_list_free0 (keys);
		_json_object_unref0 (define);
	}
	__vala_JsonNode_free0 (member);
	_json_object_unref0 (object);
	__vala_JsonNode_free0 (root);
	_g_object_unref0 (parser);
	_g_free0 (filename);
}


SkkMapFile* skk_map_file_construct (GType object_type, SkkRuleMetadata* metadata, const gchar* type, const gchar* name, GError** error) {
	SkkMapFile * self = NULL;
	GeeSet* included = NULL;
	GeeHashSet* _tmp0_;
	SkkRuleMetadata _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (metadata != NULL, NULL);
	g_return_val_if_fail (type != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	self = (SkkMapFile*) g_object_new (object_type, NULL);
	_tmp0_ = gee_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL, NULL, NULL, NULL);
	included = (GeeSet*) _tmp0_;
	_tmp1_ = *metadata;
	_tmp2_ = type;
	_tmp3_ = name;
	skk_map_file_load (self, &_tmp1_, _tmp2_, _tmp3_, included, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == SKK_RULE_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (included);
			_g_object_unref0 (self);
			return NULL;
		} else {
			_g_object_unref0 (included);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_g_object_unref0 (included);
	return self;
}


gboolean skk_map_file_has_map (SkkMapFile* self, const gchar* name) {
	gboolean result = FALSE;
	GeeMap* _tmp0_;
	const gchar* _tmp1_;
	gboolean _tmp2_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (name != NULL, FALSE);
	_tmp0_ = self->priv->maps;
	_tmp1_ = name;
	_tmp2_ = gee_map_has_key (_tmp0_, _tmp1_);
	result = _tmp2_;
	return result;
}


GeeMap* skk_map_file_get (SkkMapFile* self, const gchar* name) {
	GeeMap* result = NULL;
	GeeMap* _tmp0_;
	const gchar* _tmp1_;
	gpointer _tmp2_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = self->priv->maps;
	_tmp1_ = name;
	_tmp2_ = gee_map_get (_tmp0_, _tmp1_);
	result = (GeeMap*) _tmp2_;
	return result;
}


static void skk_map_file_class_init (SkkMapFileClass * klass) {
	skk_map_file_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (SkkMapFilePrivate));
	G_OBJECT_CLASS (klass)->finalize = skk_map_file_finalize;
}


static void skk_map_file_instance_init (SkkMapFile * self) {
	GeeHashMap* _tmp0_;
	self->priv = SKK_MAP_FILE_GET_PRIVATE (self);
	_tmp0_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, GEE_TYPE_MAP, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	self->priv->maps = (GeeMap*) _tmp0_;
}


static void skk_map_file_finalize (GObject * obj) {
	SkkMapFile * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SKK_TYPE_MAP_FILE, SkkMapFile);
	_g_object_unref0 (self->priv->maps);
	G_OBJECT_CLASS (skk_map_file_parent_class)->finalize (obj);
}


GType skk_map_file_get_type (void) {
	static volatile gsize skk_map_file_type_id__volatile = 0;
	if (g_once_init_enter (&skk_map_file_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SkkMapFileClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) skk_map_file_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SkkMapFile), 0, (GInstanceInitFunc) skk_map_file_instance_init, NULL };
		GType skk_map_file_type_id;
		skk_map_file_type_id = g_type_register_static (G_TYPE_OBJECT, "SkkMapFile", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
		g_once_init_leave (&skk_map_file_type_id__volatile, skk_map_file_type_id);
	}
	return skk_map_file_type_id__volatile;
}



