/*
 * Copyright (C) 2011-2017 Daiki Ueno <ueno@gnu.org>
 * Copyright (C) 2011-2017 Red Hat, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

namespace Skk.Keysyms {
    // converted from /usr/include/X11/keysymdef.h with:
    public const uint VoidSymbol = 0xffffff;
    public const uint BackSpace = 0xff08;
    public const uint Tab = 0xff09;
    public const uint Linefeed = 0xff0a;
    public const uint Clear = 0xff0b;
    public const uint Return = 0xff0d;
    public const uint Pause = 0xff13;
    public const uint Scroll_Lock = 0xff14;
    public const uint Sys_Req = 0xff15;
    public const uint Escape = 0xff1b;
    public const uint Delete = 0xffff;
    public const uint Multi_key = 0xff20;
    public const uint Codeinput = 0xff37;
    public const uint SingleCandidate = 0xff3c;
    public const uint MultipleCandidate = 0xff3d;
    public const uint PreviousCandidate = 0xff3e;
    public const uint Kanji = 0xff21;
    public const uint Muhenkan = 0xff22;
    public const uint Henkan_Mode = 0xff23;
    public const uint Henkan = 0xff23;
    public const uint Romaji = 0xff24;
    public const uint Hiragana = 0xff25;
    public const uint Katakana = 0xff26;
    public const uint Hiragana_Katakana = 0xff27;
    public const uint Zenkaku = 0xff28;
    public const uint Hankaku = 0xff29;
    public const uint Zenkaku_Hankaku = 0xff2a;
    public const uint Touroku = 0xff2b;
    public const uint Massyo = 0xff2c;
    public const uint Kana_Lock = 0xff2d;
    public const uint Kana_Shift = 0xff2e;
    public const uint Eisu_Shift = 0xff2f;
    public const uint Eisu_toggle = 0xff30;
    public const uint Kanji_Bangou = 0xff37;
    public const uint Zen_Koho = 0xff3d;
    public const uint Mae_Koho = 0xff3e;
    public const uint Home = 0xff50;
    public const uint Left = 0xff51;
    public const uint Up = 0xff52;
    public const uint Right = 0xff53;
    public const uint Down = 0xff54;
    public const uint Prior = 0xff55;
    public const uint Page_Up = 0xff55;
    public const uint Next = 0xff56;
    public const uint Page_Down = 0xff56;
    public const uint End = 0xff57;
    public const uint Begin = 0xff58;
    public const uint Select = 0xff60;
    public const uint Print = 0xff61;
    public const uint Execute = 0xff62;
    public const uint Insert = 0xff63;
    public const uint Undo = 0xff65;
    public const uint Redo = 0xff66;
    public const uint Menu = 0xff67;
    public const uint Find = 0xff68;
    public const uint Cancel = 0xff69;
    public const uint Help = 0xff6a;
    public const uint Break = 0xff6b;
    public const uint Mode_switch = 0xff7e;
    public const uint script_switch = 0xff7e;
    public const uint Num_Lock = 0xff7f;
    public const uint KP_Space = 0xff80;
    public const uint KP_Tab = 0xff89;
    public const uint KP_Enter = 0xff8d;
    public const uint KP_F1 = 0xff91;
    public const uint KP_F2 = 0xff92;
    public const uint KP_F3 = 0xff93;
    public const uint KP_F4 = 0xff94;
    public const uint KP_Home = 0xff95;
    public const uint KP_Left = 0xff96;
    public const uint KP_Up = 0xff97;
    public const uint KP_Right = 0xff98;
    public const uint KP_Down = 0xff99;
    public const uint KP_Prior = 0xff9a;
    public const uint KP_Page_Up = 0xff9a;
    public const uint KP_Next = 0xff9b;
    public const uint KP_Page_Down = 0xff9b;
    public const uint KP_End = 0xff9c;
    public const uint KP_Begin = 0xff9d;
    public const uint KP_Insert = 0xff9e;
    public const uint KP_Delete = 0xff9f;
    public const uint KP_Equal = 0xffbd;
    public const uint KP_Multiply = 0xffaa;
    public const uint KP_Add = 0xffab;
    public const uint KP_Separator = 0xffac;
    public const uint KP_Subtract = 0xffad;
    public const uint KP_Decimal = 0xffae;
    public const uint KP_Divide = 0xffaf;
    public const uint KP_0 = 0xffb0;
    public const uint KP_1 = 0xffb1;
    public const uint KP_2 = 0xffb2;
    public const uint KP_3 = 0xffb3;
    public const uint KP_4 = 0xffb4;
    public const uint KP_5 = 0xffb5;
    public const uint KP_6 = 0xffb6;
    public const uint KP_7 = 0xffb7;
    public const uint KP_8 = 0xffb8;
    public const uint KP_9 = 0xffb9;
    public const uint F1 = 0xffbe;
    public const uint F2 = 0xffbf;
    public const uint F3 = 0xffc0;
    public const uint F4 = 0xffc1;
    public const uint F5 = 0xffc2;
    public const uint F6 = 0xffc3;
    public const uint F7 = 0xffc4;
    public const uint F8 = 0xffc5;
    public const uint F9 = 0xffc6;
    public const uint F10 = 0xffc7;
    public const uint F11 = 0xffc8;
    public const uint L1 = 0xffc8;
    public const uint F12 = 0xffc9;
    public const uint L2 = 0xffc9;
    public const uint F13 = 0xffca;
    public const uint L3 = 0xffca;
    public const uint F14 = 0xffcb;
    public const uint L4 = 0xffcb;
    public const uint F15 = 0xffcc;
    public const uint L5 = 0xffcc;
    public const uint F16 = 0xffcd;
    public const uint L6 = 0xffcd;
    public const uint F17 = 0xffce;
    public const uint L7 = 0xffce;
    public const uint F18 = 0xffcf;
    public const uint L8 = 0xffcf;
    public const uint F19 = 0xffd0;
    public const uint L9 = 0xffd0;
    public const uint F20 = 0xffd1;
    public const uint L10 = 0xffd1;
    public const uint F21 = 0xffd2;
    public const uint R1 = 0xffd2;
    public const uint F22 = 0xffd3;
    public const uint R2 = 0xffd3;
    public const uint F23 = 0xffd4;
    public const uint R3 = 0xffd4;
    public const uint F24 = 0xffd5;
    public const uint R4 = 0xffd5;
    public const uint F25 = 0xffd6;
    public const uint R5 = 0xffd6;
    public const uint F26 = 0xffd7;
    public const uint R6 = 0xffd7;
    public const uint F27 = 0xffd8;
    public const uint R7 = 0xffd8;
    public const uint F28 = 0xffd9;
    public const uint R8 = 0xffd9;
    public const uint F29 = 0xffda;
    public const uint R9 = 0xffda;
    public const uint F30 = 0xffdb;
    public const uint R10 = 0xffdb;
    public const uint F31 = 0xffdc;
    public const uint R11 = 0xffdc;
    public const uint F32 = 0xffdd;
    public const uint R12 = 0xffdd;
    public const uint F33 = 0xffde;
    public const uint R13 = 0xffde;
    public const uint F34 = 0xffdf;
    public const uint R14 = 0xffdf;
    public const uint F35 = 0xffe0;
    public const uint R15 = 0xffe0;
    public const uint Shift_L = 0xffe1;
    public const uint Shift_R = 0xffe2;
    public const uint Control_L = 0xffe3;
    public const uint Control_R = 0xffe4;
    public const uint Caps_Lock = 0xffe5;
    public const uint Shift_Lock = 0xffe6;
    public const uint Meta_L = 0xffe7;
    public const uint Meta_R = 0xffe8;
    public const uint Alt_L = 0xffe9;
    public const uint Alt_R = 0xffea;
    public const uint Super_L = 0xffeb;
    public const uint Super_R = 0xffec;
    public const uint Hyper_L = 0xffed;
    public const uint Hyper_R = 0xffee;
    public const uint ISO_Lock = 0xfe01;
    public const uint ISO_Level2_Latch = 0xfe02;
    public const uint ISO_Level3_Shift = 0xfe03;
    public const uint ISO_Level3_Latch = 0xfe04;
    public const uint ISO_Level3_Lock = 0xfe05;
    public const uint ISO_Level5_Shift = 0xfe11;
    public const uint ISO_Level5_Latch = 0xfe12;
    public const uint ISO_Level5_Lock = 0xfe13;
    public const uint ISO_Group_Shift = 0xff7e;
    public const uint ISO_Group_Latch = 0xfe06;
    public const uint ISO_Group_Lock = 0xfe07;
    public const uint ISO_Next_Group = 0xfe08;
    public const uint ISO_Next_Group_Lock = 0xfe09;
    public const uint ISO_Prev_Group = 0xfe0a;
    public const uint ISO_Prev_Group_Lock = 0xfe0b;
    public const uint ISO_First_Group = 0xfe0c;
    public const uint ISO_First_Group_Lock = 0xfe0d;
    public const uint ISO_Last_Group = 0xfe0e;
    public const uint ISO_Last_Group_Lock = 0xfe0f;
    public const uint ISO_Left_Tab = 0xfe20;
    public const uint ISO_Move_Line_Up = 0xfe21;
    public const uint ISO_Move_Line_Down = 0xfe22;
    public const uint ISO_Partial_Line_Up = 0xfe23;
    public const uint ISO_Partial_Line_Down = 0xfe24;
    public const uint ISO_Partial_Space_Left = 0xfe25;
    public const uint ISO_Partial_Space_Right = 0xfe26;
    public const uint ISO_Set_Margin_Left = 0xfe27;
    public const uint ISO_Set_Margin_Right = 0xfe28;
    public const uint ISO_Release_Margin_Left = 0xfe29;
    public const uint ISO_Release_Margin_Right = 0xfe2a;
    public const uint ISO_Release_Both_Margins = 0xfe2b;
    public const uint ISO_Fast_Cursor_Left = 0xfe2c;
    public const uint ISO_Fast_Cursor_Right = 0xfe2d;
    public const uint ISO_Fast_Cursor_Up = 0xfe2e;
    public const uint ISO_Fast_Cursor_Down = 0xfe2f;
    public const uint ISO_Continuous_Underline = 0xfe30;
    public const uint ISO_Discontinuous_Underline = 0xfe31;
    public const uint ISO_Emphasize = 0xfe32;
    public const uint ISO_Center_Object = 0xfe33;
    public const uint ISO_Enter = 0xfe34;
    public const uint dead_grave = 0xfe50;
    public const uint dead_acute = 0xfe51;
    public const uint dead_circumflex = 0xfe52;
    public const uint dead_tilde = 0xfe53;
    public const uint dead_perispomeni = 0xfe53;
    public const uint dead_macron = 0xfe54;
    public const uint dead_breve = 0xfe55;
    public const uint dead_abovedot = 0xfe56;
    public const uint dead_diaeresis = 0xfe57;
    public const uint dead_abovering = 0xfe58;
    public const uint dead_doubleacute = 0xfe59;
    public const uint dead_caron = 0xfe5a;
    public const uint dead_cedilla = 0xfe5b;
    public const uint dead_ogonek = 0xfe5c;
    public const uint dead_iota = 0xfe5d;
    public const uint dead_voiced_sound = 0xfe5e;
    public const uint dead_semivoiced_sound = 0xfe5f;
    public const uint dead_belowdot = 0xfe60;
    public const uint dead_hook = 0xfe61;
    public const uint dead_horn = 0xfe62;
    public const uint dead_stroke = 0xfe63;
    public const uint dead_abovecomma = 0xfe64;
    public const uint dead_psili = 0xfe64;
    public const uint dead_abovereversedcomma = 0xfe65;
    public const uint dead_dasia = 0xfe65;
    public const uint dead_doublegrave = 0xfe66;
    public const uint dead_belowring = 0xfe67;
    public const uint dead_belowmacron = 0xfe68;
    public const uint dead_belowcircumflex = 0xfe69;
    public const uint dead_belowtilde = 0xfe6a;
    public const uint dead_belowbreve = 0xfe6b;
    public const uint dead_belowdiaeresis = 0xfe6c;
    public const uint dead_invertedbreve = 0xfe6d;
    public const uint dead_belowcomma = 0xfe6e;
    public const uint dead_currency = 0xfe6f;
    public const uint dead_a = 0xfe80;
    public const uint dead_A = 0xfe81;
    public const uint dead_e = 0xfe82;
    public const uint dead_E = 0xfe83;
    public const uint dead_i = 0xfe84;
    public const uint dead_I = 0xfe85;
    public const uint dead_o = 0xfe86;
    public const uint dead_O = 0xfe87;
    public const uint dead_u = 0xfe88;
    public const uint dead_U = 0xfe89;
    public const uint dead_small_schwa = 0xfe8a;
    public const uint dead_capital_schwa = 0xfe8b;
    public const uint First_Virtual_Screen = 0xfed0;
    public const uint Prev_Virtual_Screen = 0xfed1;
    public const uint Next_Virtual_Screen = 0xfed2;
    public const uint Last_Virtual_Screen = 0xfed4;
    public const uint Terminate_Server = 0xfed5;
    public const uint AccessX_Enable = 0xfe70;
    public const uint AccessX_Feedback_Enable = 0xfe71;
    public const uint RepeatKeys_Enable = 0xfe72;
    public const uint SlowKeys_Enable = 0xfe73;
    public const uint BounceKeys_Enable = 0xfe74;
    public const uint StickyKeys_Enable = 0xfe75;
    public const uint MouseKeys_Enable = 0xfe76;
    public const uint MouseKeys_Accel_Enable = 0xfe77;
    public const uint Overlay1_Enable = 0xfe78;
    public const uint Overlay2_Enable = 0xfe79;
    public const uint AudibleBell_Enable = 0xfe7a;
    public const uint Pointer_Left = 0xfee0;
    public const uint Pointer_Right = 0xfee1;
    public const uint Pointer_Up = 0xfee2;
    public const uint Pointer_Down = 0xfee3;
    public const uint Pointer_UpLeft = 0xfee4;
    public const uint Pointer_UpRight = 0xfee5;
    public const uint Pointer_DownLeft = 0xfee6;
    public const uint Pointer_DownRight = 0xfee7;
    public const uint Pointer_Button_Dflt = 0xfee8;
    public const uint Pointer_Button1 = 0xfee9;
    public const uint Pointer_Button2 = 0xfeea;
    public const uint Pointer_Button3 = 0xfeeb;
    public const uint Pointer_Button4 = 0xfeec;
    public const uint Pointer_Button5 = 0xfeed;
    public const uint Pointer_DblClick_Dflt = 0xfeee;
    public const uint Pointer_DblClick1 = 0xfeef;
    public const uint Pointer_DblClick2 = 0xfef0;
    public const uint Pointer_DblClick3 = 0xfef1;
    public const uint Pointer_DblClick4 = 0xfef2;
    public const uint Pointer_DblClick5 = 0xfef3;
    public const uint Pointer_Drag_Dflt = 0xfef4;
    public const uint Pointer_Drag1 = 0xfef5;
    public const uint Pointer_Drag2 = 0xfef6;
    public const uint Pointer_Drag3 = 0xfef7;
    public const uint Pointer_Drag4 = 0xfef8;
    public const uint Pointer_Drag5 = 0xfefd;
    public const uint Pointer_EnableKeys = 0xfef9;
    public const uint Pointer_Accelerate = 0xfefa;
    public const uint Pointer_DfltBtnNext = 0xfefb;
    public const uint Pointer_DfltBtnPrev = 0xfefc;
    public const uint @3270_Duplicate = 0xfd01;
    public const uint @3270_FieldMark = 0xfd02;
    public const uint @3270_Right2 = 0xfd03;
    public const uint @3270_Left2 = 0xfd04;
    public const uint @3270_BackTab = 0xfd05;
    public const uint @3270_EraseEOF = 0xfd06;
    public const uint @3270_EraseInput = 0xfd07;
    public const uint @3270_Reset = 0xfd08;
    public const uint @3270_Quit = 0xfd09;
    public const uint @3270_PA1 = 0xfd0a;
    public const uint @3270_PA2 = 0xfd0b;
    public const uint @3270_PA3 = 0xfd0c;
    public const uint @3270_Test = 0xfd0d;
    public const uint @3270_Attn = 0xfd0e;
    public const uint @3270_CursorBlink = 0xfd0f;
    public const uint @3270_AltCursor = 0xfd10;
    public const uint @3270_KeyClick = 0xfd11;
    public const uint @3270_Jump = 0xfd12;
    public const uint @3270_Ident = 0xfd13;
    public const uint @3270_Rule = 0xfd14;
    public const uint @3270_Copy = 0xfd15;
    public const uint @3270_Play = 0xfd16;
    public const uint @3270_Setup = 0xfd17;
    public const uint @3270_Record = 0xfd18;
    public const uint @3270_ChangeScreen = 0xfd19;
    public const uint @3270_DeleteWord = 0xfd1a;
    public const uint @3270_ExSelect = 0xfd1b;
    public const uint @3270_CursorSelect = 0xfd1c;
    public const uint @3270_PrintScreen = 0xfd1d;
    public const uint @3270_Enter = 0xfd1e;
    public const uint space = 0x0020;
    public const uint exclam = 0x0021;
    public const uint quotedbl = 0x0022;
    public const uint numbersign = 0x0023;
    public const uint dollar = 0x0024;
    public const uint percent = 0x0025;
    public const uint ampersand = 0x0026;
    public const uint apostrophe = 0x0027;
    public const uint quoteright = 0x0027;
    public const uint parenleft = 0x0028;
    public const uint parenright = 0x0029;
    public const uint asterisk = 0x002a;
    public const uint plus = 0x002b;
    public const uint comma = 0x002c;
    public const uint minus = 0x002d;
    public const uint period = 0x002e;
    public const uint slash = 0x002f;
    public const uint @0 = 0x0030;
    public const uint @1 = 0x0031;
    public const uint @2 = 0x0032;
    public const uint @3 = 0x0033;
    public const uint @4 = 0x0034;
    public const uint @5 = 0x0035;
    public const uint @6 = 0x0036;
    public const uint @7 = 0x0037;
    public const uint @8 = 0x0038;
    public const uint @9 = 0x0039;
    public const uint colon = 0x003a;
    public const uint semicolon = 0x003b;
    public const uint less = 0x003c;
    public const uint equal = 0x003d;
    public const uint greater = 0x003e;
    public const uint question = 0x003f;
    public const uint at = 0x0040;
    public const uint A = 0x0041;
    public const uint B = 0x0042;
    public const uint C = 0x0043;
    public const uint D = 0x0044;
    public const uint E = 0x0045;
    public const uint F = 0x0046;
    public const uint G = 0x0047;
    public const uint H = 0x0048;
    public const uint I = 0x0049;
    public const uint J = 0x004a;
    public const uint K = 0x004b;
    public const uint L = 0x004c;
    public const uint M = 0x004d;
    public const uint N = 0x004e;
    public const uint O = 0x004f;
    public const uint P = 0x0050;
    public const uint Q = 0x0051;
    public const uint R = 0x0052;
    public const uint S = 0x0053;
    public const uint T = 0x0054;
    public const uint U = 0x0055;
    public const uint V = 0x0056;
    public const uint W = 0x0057;
    public const uint X = 0x0058;
    public const uint Y = 0x0059;
    public const uint Z = 0x005a;
    public const uint bracketleft = 0x005b;
    public const uint backslash = 0x005c;
    public const uint bracketright = 0x005d;
    public const uint asciicircum = 0x005e;
    public const uint underscore = 0x005f;
    public const uint grave = 0x0060;
    public const uint quoteleft = 0x0060;
    public const uint a = 0x0061;
    public const uint b = 0x0062;
    public const uint c = 0x0063;
    public const uint d = 0x0064;
    public const uint e = 0x0065;
    public const uint f = 0x0066;
    public const uint g = 0x0067;
    public const uint h = 0x0068;
    public const uint i = 0x0069;
    public const uint j = 0x006a;
    public const uint k = 0x006b;
    public const uint l = 0x006c;
    public const uint m = 0x006d;
    public const uint n = 0x006e;
    public const uint o = 0x006f;
    public const uint p = 0x0070;
    public const uint q = 0x0071;
    public const uint r = 0x0072;
    public const uint s = 0x0073;
    public const uint t = 0x0074;
    public const uint u = 0x0075;
    public const uint v = 0x0076;
    public const uint w = 0x0077;
    public const uint x = 0x0078;
    public const uint y = 0x0079;
    public const uint z = 0x007a;
    public const uint braceleft = 0x007b;
    public const uint bar = 0x007c;
    public const uint braceright = 0x007d;
    public const uint asciitilde = 0x007e;
    public const uint nobreakspace = 0x00a0;
    public const uint exclamdown = 0x00a1;
    public const uint cent = 0x00a2;
    public const uint sterling = 0x00a3;
    public const uint currency = 0x00a4;
    public const uint yen = 0x00a5;
    public const uint brokenbar = 0x00a6;
    public const uint section = 0x00a7;
    public const uint diaeresis = 0x00a8;
    public const uint copyright = 0x00a9;
    public const uint ordfeminine = 0x00aa;
    public const uint guillemotleft = 0x00ab;
    public const uint notsign = 0x00ac;
    public const uint hyphen = 0x00ad;
    public const uint registered = 0x00ae;
    public const uint macron = 0x00af;
    public const uint degree = 0x00b0;
    public const uint plusminus = 0x00b1;
    public const uint twosuperior = 0x00b2;
    public const uint threesuperior = 0x00b3;
    public const uint acute = 0x00b4;
    public const uint mu = 0x00b5;
    public const uint paragraph = 0x00b6;
    public const uint periodcentered = 0x00b7;
    public const uint cedilla = 0x00b8;
    public const uint onesuperior = 0x00b9;
    public const uint masculine = 0x00ba;
    public const uint guillemotright = 0x00bb;
    public const uint onequarter = 0x00bc;
    public const uint onehalf = 0x00bd;
    public const uint threequarters = 0x00be;
    public const uint questiondown = 0x00bf;
    public const uint Agrave = 0x00c0;
    public const uint Aacute = 0x00c1;
    public const uint Acircumflex = 0x00c2;
    public const uint Atilde = 0x00c3;
    public const uint Adiaeresis = 0x00c4;
    public const uint Aring = 0x00c5;
    public const uint AE = 0x00c6;
    public const uint Ccedilla = 0x00c7;
    public const uint Egrave = 0x00c8;
    public const uint Eacute = 0x00c9;
    public const uint Ecircumflex = 0x00ca;
    public const uint Ediaeresis = 0x00cb;
    public const uint Igrave = 0x00cc;
    public const uint Iacute = 0x00cd;
    public const uint Icircumflex = 0x00ce;
    public const uint Idiaeresis = 0x00cf;
    public const uint ETH = 0x00d0;
    public const uint Eth = 0x00d0;
    public const uint Ntilde = 0x00d1;
    public const uint Ograve = 0x00d2;
    public const uint Oacute = 0x00d3;
    public const uint Ocircumflex = 0x00d4;
    public const uint Otilde = 0x00d5;
    public const uint Odiaeresis = 0x00d6;
    public const uint multiply = 0x00d7;
    public const uint Oslash = 0x00d8;
    public const uint Ooblique = 0x00d8;
    public const uint Ugrave = 0x00d9;
    public const uint Uacute = 0x00da;
    public const uint Ucircumflex = 0x00db;
    public const uint Udiaeresis = 0x00dc;
    public const uint Yacute = 0x00dd;
    public const uint THORN = 0x00de;
    public const uint Thorn = 0x00de;
    public const uint ssharp = 0x00df;
    public const uint agrave = 0x00e0;
    public const uint aacute = 0x00e1;
    public const uint acircumflex = 0x00e2;
    public const uint atilde = 0x00e3;
    public const uint adiaeresis = 0x00e4;
    public const uint aring = 0x00e5;
    public const uint ae = 0x00e6;
    public const uint ccedilla = 0x00e7;
    public const uint egrave = 0x00e8;
    public const uint eacute = 0x00e9;
    public const uint ecircumflex = 0x00ea;
    public const uint ediaeresis = 0x00eb;
    public const uint igrave = 0x00ec;
    public const uint iacute = 0x00ed;
    public const uint icircumflex = 0x00ee;
    public const uint idiaeresis = 0x00ef;
    public const uint eth = 0x00f0;
    public const uint ntilde = 0x00f1;
    public const uint ograve = 0x00f2;
    public const uint oacute = 0x00f3;
    public const uint ocircumflex = 0x00f4;
    public const uint otilde = 0x00f5;
    public const uint odiaeresis = 0x00f6;
    public const uint division = 0x00f7;
    public const uint oslash = 0x00f8;
    public const uint ooblique = 0x00f8;
    public const uint ugrave = 0x00f9;
    public const uint uacute = 0x00fa;
    public const uint ucircumflex = 0x00fb;
    public const uint udiaeresis = 0x00fc;
    public const uint yacute = 0x00fd;
    public const uint thorn = 0x00fe;
    public const uint ydiaeresis = 0x00ff;
    public const uint Aogonek = 0x01a1;
    public const uint breve = 0x01a2;
    public const uint Lstroke = 0x01a3;
    public const uint Lcaron = 0x01a5;
    public const uint Sacute = 0x01a6;
    public const uint Scaron = 0x01a9;
    public const uint Scedilla = 0x01aa;
    public const uint Tcaron = 0x01ab;
    public const uint Zacute = 0x01ac;
    public const uint Zcaron = 0x01ae;
    public const uint Zabovedot = 0x01af;
    public const uint aogonek = 0x01b1;
    public const uint ogonek = 0x01b2;
    public const uint lstroke = 0x01b3;
    public const uint lcaron = 0x01b5;
    public const uint sacute = 0x01b6;
    public const uint caron = 0x01b7;
    public const uint scaron = 0x01b9;
    public const uint scedilla = 0x01ba;
    public const uint tcaron = 0x01bb;
    public const uint zacute = 0x01bc;
    public const uint doubleacute = 0x01bd;
    public const uint zcaron = 0x01be;
    public const uint zabovedot = 0x01bf;
    public const uint Racute = 0x01c0;
    public const uint Abreve = 0x01c3;
    public const uint Lacute = 0x01c5;
    public const uint Cacute = 0x01c6;
    public const uint Ccaron = 0x01c8;
    public const uint Eogonek = 0x01ca;
    public const uint Ecaron = 0x01cc;
    public const uint Dcaron = 0x01cf;
    public const uint Dstroke = 0x01d0;
    public const uint Nacute = 0x01d1;
    public const uint Ncaron = 0x01d2;
    public const uint Odoubleacute = 0x01d5;
    public const uint Rcaron = 0x01d8;
    public const uint Uring = 0x01d9;
    public const uint Udoubleacute = 0x01db;
    public const uint Tcedilla = 0x01de;
    public const uint racute = 0x01e0;
    public const uint abreve = 0x01e3;
    public const uint lacute = 0x01e5;
    public const uint cacute = 0x01e6;
    public const uint ccaron = 0x01e8;
    public const uint eogonek = 0x01ea;
    public const uint ecaron = 0x01ec;
    public const uint dcaron = 0x01ef;
    public const uint dstroke = 0x01f0;
    public const uint nacute = 0x01f1;
    public const uint ncaron = 0x01f2;
    public const uint odoubleacute = 0x01f5;
    public const uint rcaron = 0x01f8;
    public const uint uring = 0x01f9;
    public const uint udoubleacute = 0x01fb;
    public const uint tcedilla = 0x01fe;
    public const uint abovedot = 0x01ff;
    public const uint Hstroke = 0x02a1;
    public const uint Hcircumflex = 0x02a6;
    public const uint Iabovedot = 0x02a9;
    public const uint Gbreve = 0x02ab;
    public const uint Jcircumflex = 0x02ac;
    public const uint hstroke = 0x02b1;
    public const uint hcircumflex = 0x02b6;
    public const uint idotless = 0x02b9;
    public const uint gbreve = 0x02bb;
    public const uint jcircumflex = 0x02bc;
    public const uint Cabovedot = 0x02c5;
    public const uint Ccircumflex = 0x02c6;
    public const uint Gabovedot = 0x02d5;
    public const uint Gcircumflex = 0x02d8;
    public const uint Ubreve = 0x02dd;
    public const uint Scircumflex = 0x02de;
    public const uint cabovedot = 0x02e5;
    public const uint ccircumflex = 0x02e6;
    public const uint gabovedot = 0x02f5;
    public const uint gcircumflex = 0x02f8;
    public const uint ubreve = 0x02fd;
    public const uint scircumflex = 0x02fe;
    public const uint kra = 0x03a2;
    public const uint kappa = 0x03a2;
    public const uint Rcedilla = 0x03a3;
    public const uint Itilde = 0x03a5;
    public const uint Lcedilla = 0x03a6;
    public const uint Emacron = 0x03aa;
    public const uint Gcedilla = 0x03ab;
    public const uint Tslash = 0x03ac;
    public const uint rcedilla = 0x03b3;
    public const uint itilde = 0x03b5;
    public const uint lcedilla = 0x03b6;
    public const uint emacron = 0x03ba;
    public const uint gcedilla = 0x03bb;
    public const uint tslash = 0x03bc;
    public const uint ENG = 0x03bd;
    public const uint eng = 0x03bf;
    public const uint Amacron = 0x03c0;
    public const uint Iogonek = 0x03c7;
    public const uint Eabovedot = 0x03cc;
    public const uint Imacron = 0x03cf;
    public const uint Ncedilla = 0x03d1;
    public const uint Omacron = 0x03d2;
    public const uint Kcedilla = 0x03d3;
    public const uint Uogonek = 0x03d9;
    public const uint Utilde = 0x03dd;
    public const uint Umacron = 0x03de;
    public const uint amacron = 0x03e0;
    public const uint iogonek = 0x03e7;
    public const uint eabovedot = 0x03ec;
    public const uint imacron = 0x03ef;
    public const uint ncedilla = 0x03f1;
    public const uint omacron = 0x03f2;
    public const uint kcedilla = 0x03f3;
    public const uint uogonek = 0x03f9;
    public const uint utilde = 0x03fd;
    public const uint umacron = 0x03fe;
    public const uint Wcircumflex = 0x1000174;
    public const uint wcircumflex = 0x1000175;
    public const uint Ycircumflex = 0x1000176;
    public const uint ycircumflex = 0x1000177;
    public const uint Babovedot = 0x1001e02;
    public const uint babovedot = 0x1001e03;
    public const uint Dabovedot = 0x1001e0a;
    public const uint dabovedot = 0x1001e0b;
    public const uint Fabovedot = 0x1001e1e;
    public const uint fabovedot = 0x1001e1f;
    public const uint Mabovedot = 0x1001e40;
    public const uint mabovedot = 0x1001e41;
    public const uint Pabovedot = 0x1001e56;
    public const uint pabovedot = 0x1001e57;
    public const uint Sabovedot = 0x1001e60;
    public const uint sabovedot = 0x1001e61;
    public const uint Tabovedot = 0x1001e6a;
    public const uint tabovedot = 0x1001e6b;
    public const uint Wgrave = 0x1001e80;
    public const uint wgrave = 0x1001e81;
    public const uint Wacute = 0x1001e82;
    public const uint wacute = 0x1001e83;
    public const uint Wdiaeresis = 0x1001e84;
    public const uint wdiaeresis = 0x1001e85;
    public const uint Ygrave = 0x1001ef2;
    public const uint ygrave = 0x1001ef3;
    public const uint OE = 0x13bc;
    public const uint oe = 0x13bd;
    public const uint Ydiaeresis = 0x13be;
    public const uint overline = 0x047e;
    public const uint kana_fullstop = 0x04a1;
    public const uint kana_openingbracket = 0x04a2;
    public const uint kana_closingbracket = 0x04a3;
    public const uint kana_comma = 0x04a4;
    public const uint kana_conjunctive = 0x04a5;
    public const uint kana_middledot = 0x04a5;
    public const uint kana_WO = 0x04a6;
    public const uint kana_a = 0x04a7;
    public const uint kana_i = 0x04a8;
    public const uint kana_u = 0x04a9;
    public const uint kana_e = 0x04aa;
    public const uint kana_o = 0x04ab;
    public const uint kana_ya = 0x04ac;
    public const uint kana_yu = 0x04ad;
    public const uint kana_yo = 0x04ae;
    public const uint kana_tsu = 0x04af;
    public const uint kana_tu = 0x04af;
    public const uint prolongedsound = 0x04b0;
    public const uint kana_A = 0x04b1;
    public const uint kana_I = 0x04b2;
    public const uint kana_U = 0x04b3;
    public const uint kana_E = 0x04b4;
    public const uint kana_O = 0x04b5;
    public const uint kana_KA = 0x04b6;
    public const uint kana_KI = 0x04b7;
    public const uint kana_KU = 0x04b8;
    public const uint kana_KE = 0x04b9;
    public const uint kana_KO = 0x04ba;
    public const uint kana_SA = 0x04bb;
    public const uint kana_SHI = 0x04bc;
    public const uint kana_SU = 0x04bd;
    public const uint kana_SE = 0x04be;
    public const uint kana_SO = 0x04bf;
    public const uint kana_TA = 0x04c0;
    public const uint kana_CHI = 0x04c1;
    public const uint kana_TI = 0x04c1;
    public const uint kana_TSU = 0x04c2;
    public const uint kana_TU = 0x04c2;
    public const uint kana_TE = 0x04c3;
    public const uint kana_TO = 0x04c4;
    public const uint kana_NA = 0x04c5;
    public const uint kana_NI = 0x04c6;
    public const uint kana_NU = 0x04c7;
    public const uint kana_NE = 0x04c8;
    public const uint kana_NO = 0x04c9;
    public const uint kana_HA = 0x04ca;
    public const uint kana_HI = 0x04cb;
    public const uint kana_FU = 0x04cc;
    public const uint kana_HU = 0x04cc;
    public const uint kana_HE = 0x04cd;
    public const uint kana_HO = 0x04ce;
    public const uint kana_MA = 0x04cf;
    public const uint kana_MI = 0x04d0;
    public const uint kana_MU = 0x04d1;
    public const uint kana_ME = 0x04d2;
    public const uint kana_MO = 0x04d3;
    public const uint kana_YA = 0x04d4;
    public const uint kana_YU = 0x04d5;
    public const uint kana_YO = 0x04d6;
    public const uint kana_RA = 0x04d7;
    public const uint kana_RI = 0x04d8;
    public const uint kana_RU = 0x04d9;
    public const uint kana_RE = 0x04da;
    public const uint kana_RO = 0x04db;
    public const uint kana_WA = 0x04dc;
    public const uint kana_N = 0x04dd;
    public const uint voicedsound = 0x04de;
    public const uint semivoicedsound = 0x04df;
    public const uint kana_switch = 0xff7e;
    public const uint Farsi_0 = 0x10006f0;
    public const uint Farsi_1 = 0x10006f1;
    public const uint Farsi_2 = 0x10006f2;
    public const uint Farsi_3 = 0x10006f3;
    public const uint Farsi_4 = 0x10006f4;
    public const uint Farsi_5 = 0x10006f5;
    public const uint Farsi_6 = 0x10006f6;
    public const uint Farsi_7 = 0x10006f7;
    public const uint Farsi_8 = 0x10006f8;
    public const uint Farsi_9 = 0x10006f9;
    public const uint Arabic_percent = 0x100066a;
    public const uint Arabic_superscript_alef = 0x1000670;
    public const uint Arabic_tteh = 0x1000679;
    public const uint Arabic_peh = 0x100067e;
    public const uint Arabic_tcheh = 0x1000686;
    public const uint Arabic_ddal = 0x1000688;
    public const uint Arabic_rreh = 0x1000691;
    public const uint Arabic_comma = 0x05ac;
    public const uint Arabic_fullstop = 0x10006d4;
    public const uint Arabic_0 = 0x1000660;
    public const uint Arabic_1 = 0x1000661;
    public const uint Arabic_2 = 0x1000662;
    public const uint Arabic_3 = 0x1000663;
    public const uint Arabic_4 = 0x1000664;
    public const uint Arabic_5 = 0x1000665;
    public const uint Arabic_6 = 0x1000666;
    public const uint Arabic_7 = 0x1000667;
    public const uint Arabic_8 = 0x1000668;
    public const uint Arabic_9 = 0x1000669;
    public const uint Arabic_semicolon = 0x05bb;
    public const uint Arabic_question_mark = 0x05bf;
    public const uint Arabic_hamza = 0x05c1;
    public const uint Arabic_maddaonalef = 0x05c2;
    public const uint Arabic_hamzaonalef = 0x05c3;
    public const uint Arabic_hamzaonwaw = 0x05c4;
    public const uint Arabic_hamzaunderalef = 0x05c5;
    public const uint Arabic_hamzaonyeh = 0x05c6;
    public const uint Arabic_alef = 0x05c7;
    public const uint Arabic_beh = 0x05c8;
    public const uint Arabic_tehmarbuta = 0x05c9;
    public const uint Arabic_teh = 0x05ca;
    public const uint Arabic_theh = 0x05cb;
    public const uint Arabic_jeem = 0x05cc;
    public const uint Arabic_hah = 0x05cd;
    public const uint Arabic_khah = 0x05ce;
    public const uint Arabic_dal = 0x05cf;
    public const uint Arabic_thal = 0x05d0;
    public const uint Arabic_ra = 0x05d1;
    public const uint Arabic_zain = 0x05d2;
    public const uint Arabic_seen = 0x05d3;
    public const uint Arabic_sheen = 0x05d4;
    public const uint Arabic_sad = 0x05d5;
    public const uint Arabic_dad = 0x05d6;
    public const uint Arabic_tah = 0x05d7;
    public const uint Arabic_zah = 0x05d8;
    public const uint Arabic_ain = 0x05d9;
    public const uint Arabic_ghain = 0x05da;
    public const uint Arabic_tatweel = 0x05e0;
    public const uint Arabic_feh = 0x05e1;
    public const uint Arabic_qaf = 0x05e2;
    public const uint Arabic_kaf = 0x05e3;
    public const uint Arabic_lam = 0x05e4;
    public const uint Arabic_meem = 0x05e5;
    public const uint Arabic_noon = 0x05e6;
    public const uint Arabic_ha = 0x05e7;
    public const uint Arabic_heh = 0x05e7;
    public const uint Arabic_waw = 0x05e8;
    public const uint Arabic_alefmaksura = 0x05e9;
    public const uint Arabic_yeh = 0x05ea;
    public const uint Arabic_fathatan = 0x05eb;
    public const uint Arabic_dammatan = 0x05ec;
    public const uint Arabic_kasratan = 0x05ed;
    public const uint Arabic_fatha = 0x05ee;
    public const uint Arabic_damma = 0x05ef;
    public const uint Arabic_kasra = 0x05f0;
    public const uint Arabic_shadda = 0x05f1;
    public const uint Arabic_sukun = 0x05f2;
    public const uint Arabic_madda_above = 0x1000653;
    public const uint Arabic_hamza_above = 0x1000654;
    public const uint Arabic_hamza_below = 0x1000655;
    public const uint Arabic_jeh = 0x1000698;
    public const uint Arabic_veh = 0x10006a4;
    public const uint Arabic_keheh = 0x10006a9;
    public const uint Arabic_gaf = 0x10006af;
    public const uint Arabic_noon_ghunna = 0x10006ba;
    public const uint Arabic_heh_doachashmee = 0x10006be;
    public const uint Farsi_yeh = 0x10006cc;
    public const uint Arabic_farsi_yeh = 0x10006cc;
    public const uint Arabic_yeh_baree = 0x10006d2;
    public const uint Arabic_heh_goal = 0x10006c1;
    public const uint Arabic_switch = 0xff7e;
    public const uint Cyrillic_GHE_bar = 0x1000492;
    public const uint Cyrillic_ghe_bar = 0x1000493;
    public const uint Cyrillic_ZHE_descender = 0x1000496;
    public const uint Cyrillic_zhe_descender = 0x1000497;
    public const uint Cyrillic_KA_descender = 0x100049a;
    public const uint Cyrillic_ka_descender = 0x100049b;
    public const uint Cyrillic_KA_vertstroke = 0x100049c;
    public const uint Cyrillic_ka_vertstroke = 0x100049d;
    public const uint Cyrillic_EN_descender = 0x10004a2;
    public const uint Cyrillic_en_descender = 0x10004a3;
    public const uint Cyrillic_U_straight = 0x10004ae;
    public const uint Cyrillic_u_straight = 0x10004af;
    public const uint Cyrillic_U_straight_bar = 0x10004b0;
    public const uint Cyrillic_u_straight_bar = 0x10004b1;
    public const uint Cyrillic_HA_descender = 0x10004b2;
    public const uint Cyrillic_ha_descender = 0x10004b3;
    public const uint Cyrillic_CHE_descender = 0x10004b6;
    public const uint Cyrillic_che_descender = 0x10004b7;
    public const uint Cyrillic_CHE_vertstroke = 0x10004b8;
    public const uint Cyrillic_che_vertstroke = 0x10004b9;
    public const uint Cyrillic_SHHA = 0x10004ba;
    public const uint Cyrillic_shha = 0x10004bb;
    public const uint Cyrillic_SCHWA = 0x10004d8;
    public const uint Cyrillic_schwa = 0x10004d9;
    public const uint Cyrillic_I_macron = 0x10004e2;
    public const uint Cyrillic_i_macron = 0x10004e3;
    public const uint Cyrillic_O_bar = 0x10004e8;
    public const uint Cyrillic_o_bar = 0x10004e9;
    public const uint Cyrillic_U_macron = 0x10004ee;
    public const uint Cyrillic_u_macron = 0x10004ef;
    public const uint Serbian_dje = 0x06a1;
    public const uint Macedonia_gje = 0x06a2;
    public const uint Cyrillic_io = 0x06a3;
    public const uint Ukrainian_ie = 0x06a4;
    public const uint Ukranian_je = 0x06a4;
    public const uint Macedonia_dse = 0x06a5;
    public const uint Ukrainian_i = 0x06a6;
    public const uint Ukranian_i = 0x06a6;
    public const uint Ukrainian_yi = 0x06a7;
    public const uint Ukranian_yi = 0x06a7;
    public const uint Cyrillic_je = 0x06a8;
    public const uint Serbian_je = 0x06a8;
    public const uint Cyrillic_lje = 0x06a9;
    public const uint Serbian_lje = 0x06a9;
    public const uint Cyrillic_nje = 0x06aa;
    public const uint Serbian_nje = 0x06aa;
    public const uint Serbian_tshe = 0x06ab;
    public const uint Macedonia_kje = 0x06ac;
    public const uint Ukrainian_ghe_with_upturn = 0x06ad;
    public const uint Byelorussian_shortu = 0x06ae;
    public const uint Cyrillic_dzhe = 0x06af;
    public const uint Serbian_dze = 0x06af;
    public const uint numerosign = 0x06b0;
    public const uint Serbian_DJE = 0x06b1;
    public const uint Macedonia_GJE = 0x06b2;
    public const uint Cyrillic_IO = 0x06b3;
    public const uint Ukrainian_IE = 0x06b4;
    public const uint Ukranian_JE = 0x06b4;
    public const uint Macedonia_DSE = 0x06b5;
    public const uint Ukrainian_I = 0x06b6;
    public const uint Ukranian_I = 0x06b6;
    public const uint Ukrainian_YI = 0x06b7;
    public const uint Ukranian_YI = 0x06b7;
    public const uint Cyrillic_JE = 0x06b8;
    public const uint Serbian_JE = 0x06b8;
    public const uint Cyrillic_LJE = 0x06b9;
    public const uint Serbian_LJE = 0x06b9;
    public const uint Cyrillic_NJE = 0x06ba;
    public const uint Serbian_NJE = 0x06ba;
    public const uint Serbian_TSHE = 0x06bb;
    public const uint Macedonia_KJE = 0x06bc;
    public const uint Ukrainian_GHE_WITH_UPTURN = 0x06bd;
    public const uint Byelorussian_SHORTU = 0x06be;
    public const uint Cyrillic_DZHE = 0x06bf;
    public const uint Serbian_DZE = 0x06bf;
    public const uint Cyrillic_yu = 0x06c0;
    public const uint Cyrillic_a = 0x06c1;
    public const uint Cyrillic_be = 0x06c2;
    public const uint Cyrillic_tse = 0x06c3;
    public const uint Cyrillic_de = 0x06c4;
    public const uint Cyrillic_ie = 0x06c5;
    public const uint Cyrillic_ef = 0x06c6;
    public const uint Cyrillic_ghe = 0x06c7;
    public const uint Cyrillic_ha = 0x06c8;
    public const uint Cyrillic_i = 0x06c9;
    public const uint Cyrillic_shorti = 0x06ca;
    public const uint Cyrillic_ka = 0x06cb;
    public const uint Cyrillic_el = 0x06cc;
    public const uint Cyrillic_em = 0x06cd;
    public const uint Cyrillic_en = 0x06ce;
    public const uint Cyrillic_o = 0x06cf;
    public const uint Cyrillic_pe = 0x06d0;
    public const uint Cyrillic_ya = 0x06d1;
    public const uint Cyrillic_er = 0x06d2;
    public const uint Cyrillic_es = 0x06d3;
    public const uint Cyrillic_te = 0x06d4;
    public const uint Cyrillic_u = 0x06d5;
    public const uint Cyrillic_zhe = 0x06d6;
    public const uint Cyrillic_ve = 0x06d7;
    public const uint Cyrillic_softsign = 0x06d8;
    public const uint Cyrillic_yeru = 0x06d9;
    public const uint Cyrillic_ze = 0x06da;
    public const uint Cyrillic_sha = 0x06db;
    public const uint Cyrillic_e = 0x06dc;
    public const uint Cyrillic_shcha = 0x06dd;
    public const uint Cyrillic_che = 0x06de;
    public const uint Cyrillic_hardsign = 0x06df;
    public const uint Cyrillic_YU = 0x06e0;
    public const uint Cyrillic_A = 0x06e1;
    public const uint Cyrillic_BE = 0x06e2;
    public const uint Cyrillic_TSE = 0x06e3;
    public const uint Cyrillic_DE = 0x06e4;
    public const uint Cyrillic_IE = 0x06e5;
    public const uint Cyrillic_EF = 0x06e6;
    public const uint Cyrillic_GHE = 0x06e7;
    public const uint Cyrillic_HA = 0x06e8;
    public const uint Cyrillic_I = 0x06e9;
    public const uint Cyrillic_SHORTI = 0x06ea;
    public const uint Cyrillic_KA = 0x06eb;
    public const uint Cyrillic_EL = 0x06ec;
    public const uint Cyrillic_EM = 0x06ed;
    public const uint Cyrillic_EN = 0x06ee;
    public const uint Cyrillic_O = 0x06ef;
    public const uint Cyrillic_PE = 0x06f0;
    public const uint Cyrillic_YA = 0x06f1;
    public const uint Cyrillic_ER = 0x06f2;
    public const uint Cyrillic_ES = 0x06f3;
    public const uint Cyrillic_TE = 0x06f4;
    public const uint Cyrillic_U = 0x06f5;
    public const uint Cyrillic_ZHE = 0x06f6;
    public const uint Cyrillic_VE = 0x06f7;
    public const uint Cyrillic_SOFTSIGN = 0x06f8;
    public const uint Cyrillic_YERU = 0x06f9;
    public const uint Cyrillic_ZE = 0x06fa;
    public const uint Cyrillic_SHA = 0x06fb;
    public const uint Cyrillic_E = 0x06fc;
    public const uint Cyrillic_SHCHA = 0x06fd;
    public const uint Cyrillic_CHE = 0x06fe;
    public const uint Cyrillic_HARDSIGN = 0x06ff;
    public const uint Greek_ALPHAaccent = 0x07a1;
    public const uint Greek_EPSILONaccent = 0x07a2;
    public const uint Greek_ETAaccent = 0x07a3;
    public const uint Greek_IOTAaccent = 0x07a4;
    public const uint Greek_IOTAdieresis = 0x07a5;
    public const uint Greek_IOTAdiaeresis = 0x07a5;
    public const uint Greek_OMICRONaccent = 0x07a7;
    public const uint Greek_UPSILONaccent = 0x07a8;
    public const uint Greek_UPSILONdieresis = 0x07a9;
    public const uint Greek_OMEGAaccent = 0x07ab;
    public const uint Greek_accentdieresis = 0x07ae;
    public const uint Greek_horizbar = 0x07af;
    public const uint Greek_alphaaccent = 0x07b1;
    public const uint Greek_epsilonaccent = 0x07b2;
    public const uint Greek_etaaccent = 0x07b3;
    public const uint Greek_iotaaccent = 0x07b4;
    public const uint Greek_iotadieresis = 0x07b5;
    public const uint Greek_iotaaccentdieresis = 0x07b6;
    public const uint Greek_omicronaccent = 0x07b7;
    public const uint Greek_upsilonaccent = 0x07b8;
    public const uint Greek_upsilondieresis = 0x07b9;
    public const uint Greek_upsilonaccentdieresis = 0x07ba;
    public const uint Greek_omegaaccent = 0x07bb;
    public const uint Greek_ALPHA = 0x07c1;
    public const uint Greek_BETA = 0x07c2;
    public const uint Greek_GAMMA = 0x07c3;
    public const uint Greek_DELTA = 0x07c4;
    public const uint Greek_EPSILON = 0x07c5;
    public const uint Greek_ZETA = 0x07c6;
    public const uint Greek_ETA = 0x07c7;
    public const uint Greek_THETA = 0x07c8;
    public const uint Greek_IOTA = 0x07c9;
    public const uint Greek_KAPPA = 0x07ca;
    public const uint Greek_LAMDA = 0x07cb;
    public const uint Greek_LAMBDA = 0x07cb;
    public const uint Greek_MU = 0x07cc;
    public const uint Greek_NU = 0x07cd;
    public const uint Greek_XI = 0x07ce;
    public const uint Greek_OMICRON = 0x07cf;
    public const uint Greek_PI = 0x07d0;
    public const uint Greek_RHO = 0x07d1;
    public const uint Greek_SIGMA = 0x07d2;
    public const uint Greek_TAU = 0x07d4;
    public const uint Greek_UPSILON = 0x07d5;
    public const uint Greek_PHI = 0x07d6;
    public const uint Greek_CHI = 0x07d7;
    public const uint Greek_PSI = 0x07d8;
    public const uint Greek_OMEGA = 0x07d9;
    public const uint Greek_alpha = 0x07e1;
    public const uint Greek_beta = 0x07e2;
    public const uint Greek_gamma = 0x07e3;
    public const uint Greek_delta = 0x07e4;
    public const uint Greek_epsilon = 0x07e5;
    public const uint Greek_zeta = 0x07e6;
    public const uint Greek_eta = 0x07e7;
    public const uint Greek_theta = 0x07e8;
    public const uint Greek_iota = 0x07e9;
    public const uint Greek_kappa = 0x07ea;
    public const uint Greek_lamda = 0x07eb;
    public const uint Greek_lambda = 0x07eb;
    public const uint Greek_mu = 0x07ec;
    public const uint Greek_nu = 0x07ed;
    public const uint Greek_xi = 0x07ee;
    public const uint Greek_omicron = 0x07ef;
    public const uint Greek_pi = 0x07f0;
    public const uint Greek_rho = 0x07f1;
    public const uint Greek_sigma = 0x07f2;
    public const uint Greek_finalsmallsigma = 0x07f3;
    public const uint Greek_tau = 0x07f4;
    public const uint Greek_upsilon = 0x07f5;
    public const uint Greek_phi = 0x07f6;
    public const uint Greek_chi = 0x07f7;
    public const uint Greek_psi = 0x07f8;
    public const uint Greek_omega = 0x07f9;
    public const uint Greek_switch = 0xff7e;
    public const uint leftradical = 0x08a1;
    public const uint topleftradical = 0x08a2;
    public const uint horizconnector = 0x08a3;
    public const uint topintegral = 0x08a4;
    public const uint botintegral = 0x08a5;
    public const uint vertconnector = 0x08a6;
    public const uint topleftsqbracket = 0x08a7;
    public const uint botleftsqbracket = 0x08a8;
    public const uint toprightsqbracket = 0x08a9;
    public const uint botrightsqbracket = 0x08aa;
    public const uint topleftparens = 0x08ab;
    public const uint botleftparens = 0x08ac;
    public const uint toprightparens = 0x08ad;
    public const uint botrightparens = 0x08ae;
    public const uint leftmiddlecurlybrace = 0x08af;
    public const uint rightmiddlecurlybrace = 0x08b0;
    public const uint topleftsummation = 0x08b1;
    public const uint botleftsummation = 0x08b2;
    public const uint topvertsummationconnector = 0x08b3;
    public const uint botvertsummationconnector = 0x08b4;
    public const uint toprightsummation = 0x08b5;
    public const uint botrightsummation = 0x08b6;
    public const uint rightmiddlesummation = 0x08b7;
    public const uint lessthanequal = 0x08bc;
    public const uint notequal = 0x08bd;
    public const uint greaterthanequal = 0x08be;
    public const uint integral = 0x08bf;
    public const uint therefore = 0x08c0;
    public const uint variation = 0x08c1;
    public const uint infinity = 0x08c2;
    public const uint nabla = 0x08c5;
    public const uint approximate = 0x08c8;
    public const uint similarequal = 0x08c9;
    public const uint ifonlyif = 0x08cd;
    public const uint implies = 0x08ce;
    public const uint identical = 0x08cf;
    public const uint radical = 0x08d6;
    public const uint includedin = 0x08da;
    public const uint includes = 0x08db;
    public const uint intersection = 0x08dc;
    public const uint union = 0x08dd;
    public const uint logicaland = 0x08de;
    public const uint logicalor = 0x08df;
    public const uint partialderivative = 0x08ef;
    public const uint function = 0x08f6;
    public const uint leftarrow = 0x08fb;
    public const uint uparrow = 0x08fc;
    public const uint rightarrow = 0x08fd;
    public const uint downarrow = 0x08fe;
    public const uint blank = 0x09df;
    public const uint soliddiamond = 0x09e0;
    public const uint checkerboard = 0x09e1;
    public const uint ht = 0x09e2;
    public const uint ff = 0x09e3;
    public const uint cr = 0x09e4;
    public const uint lf = 0x09e5;
    public const uint nl = 0x09e8;
    public const uint vt = 0x09e9;
    public const uint lowrightcorner = 0x09ea;
    public const uint uprightcorner = 0x09eb;
    public const uint upleftcorner = 0x09ec;
    public const uint lowleftcorner = 0x09ed;
    public const uint crossinglines = 0x09ee;
    public const uint horizlinescan1 = 0x09ef;
    public const uint horizlinescan3 = 0x09f0;
    public const uint horizlinescan5 = 0x09f1;
    public const uint horizlinescan7 = 0x09f2;
    public const uint horizlinescan9 = 0x09f3;
    public const uint leftt = 0x09f4;
    public const uint rightt = 0x09f5;
    public const uint bott = 0x09f6;
    public const uint topt = 0x09f7;
    public const uint vertbar = 0x09f8;
    public const uint emspace = 0x0aa1;
    public const uint enspace = 0x0aa2;
    public const uint em3space = 0x0aa3;
    public const uint em4space = 0x0aa4;
    public const uint digitspace = 0x0aa5;
    public const uint punctspace = 0x0aa6;
    public const uint thinspace = 0x0aa7;
    public const uint hairspace = 0x0aa8;
    public const uint emdash = 0x0aa9;
    public const uint endash = 0x0aaa;
    public const uint signifblank = 0x0aac;
    public const uint ellipsis = 0x0aae;
    public const uint doubbaselinedot = 0x0aaf;
    public const uint onethird = 0x0ab0;
    public const uint twothirds = 0x0ab1;
    public const uint onefifth = 0x0ab2;
    public const uint twofifths = 0x0ab3;
    public const uint threefifths = 0x0ab4;
    public const uint fourfifths = 0x0ab5;
    public const uint onesixth = 0x0ab6;
    public const uint fivesixths = 0x0ab7;
    public const uint careof = 0x0ab8;
    public const uint figdash = 0x0abb;
    public const uint leftanglebracket = 0x0abc;
    public const uint decimalpoint = 0x0abd;
    public const uint rightanglebracket = 0x0abe;
    public const uint marker = 0x0abf;
    public const uint oneeighth = 0x0ac3;
    public const uint threeeighths = 0x0ac4;
    public const uint fiveeighths = 0x0ac5;
    public const uint seveneighths = 0x0ac6;
    public const uint trademark = 0x0ac9;
    public const uint signaturemark = 0x0aca;
    public const uint trademarkincircle = 0x0acb;
    public const uint leftopentriangle = 0x0acc;
    public const uint rightopentriangle = 0x0acd;
    public const uint emopencircle = 0x0ace;
    public const uint emopenrectangle = 0x0acf;
    public const uint leftsinglequotemark = 0x0ad0;
    public const uint rightsinglequotemark = 0x0ad1;
    public const uint leftdoublequotemark = 0x0ad2;
    public const uint rightdoublequotemark = 0x0ad3;
    public const uint prescription = 0x0ad4;
    public const uint minutes = 0x0ad6;
    public const uint seconds = 0x0ad7;
    public const uint latincross = 0x0ad9;
    public const uint hexagram = 0x0ada;
    public const uint filledrectbullet = 0x0adb;
    public const uint filledlefttribullet = 0x0adc;
    public const uint filledrighttribullet = 0x0add;
    public const uint emfilledcircle = 0x0ade;
    public const uint emfilledrect = 0x0adf;
    public const uint enopencircbullet = 0x0ae0;
    public const uint enopensquarebullet = 0x0ae1;
    public const uint openrectbullet = 0x0ae2;
    public const uint opentribulletup = 0x0ae3;
    public const uint opentribulletdown = 0x0ae4;
    public const uint openstar = 0x0ae5;
    public const uint enfilledcircbullet = 0x0ae6;
    public const uint enfilledsqbullet = 0x0ae7;
    public const uint filledtribulletup = 0x0ae8;
    public const uint filledtribulletdown = 0x0ae9;
    public const uint leftpointer = 0x0aea;
    public const uint rightpointer = 0x0aeb;
    public const uint club = 0x0aec;
    public const uint diamond = 0x0aed;
    public const uint heart = 0x0aee;
    public const uint maltesecross = 0x0af0;
    public const uint dagger = 0x0af1;
    public const uint doubledagger = 0x0af2;
    public const uint checkmark = 0x0af3;
    public const uint ballotcross = 0x0af4;
    public const uint musicalsharp = 0x0af5;
    public const uint musicalflat = 0x0af6;
    public const uint malesymbol = 0x0af7;
    public const uint femalesymbol = 0x0af8;
    public const uint telephone = 0x0af9;
    public const uint telephonerecorder = 0x0afa;
    public const uint phonographcopyright = 0x0afb;
    public const uint caret = 0x0afc;
    public const uint singlelowquotemark = 0x0afd;
    public const uint doublelowquotemark = 0x0afe;
    public const uint cursor = 0x0aff;
    public const uint leftcaret = 0x0ba3;
    public const uint rightcaret = 0x0ba6;
    public const uint downcaret = 0x0ba8;
    public const uint upcaret = 0x0ba9;
    public const uint overbar = 0x0bc0;
    public const uint downtack = 0x0bc2;
    public const uint upshoe = 0x0bc3;
    public const uint downstile = 0x0bc4;
    public const uint underbar = 0x0bc6;
    public const uint jot = 0x0bca;
    public const uint quad = 0x0bcc;
    public const uint uptack = 0x0bce;
    public const uint circle = 0x0bcf;
    public const uint upstile = 0x0bd3;
    public const uint downshoe = 0x0bd6;
    public const uint rightshoe = 0x0bd8;
    public const uint leftshoe = 0x0bda;
    public const uint lefttack = 0x0bdc;
    public const uint righttack = 0x0bfc;
    public const uint hebrew_doublelowline = 0x0cdf;
    public const uint hebrew_aleph = 0x0ce0;
    public const uint hebrew_bet = 0x0ce1;
    public const uint hebrew_beth = 0x0ce1;
    public const uint hebrew_gimel = 0x0ce2;
    public const uint hebrew_gimmel = 0x0ce2;
    public const uint hebrew_dalet = 0x0ce3;
    public const uint hebrew_daleth = 0x0ce3;
    public const uint hebrew_he = 0x0ce4;
    public const uint hebrew_waw = 0x0ce5;
    public const uint hebrew_zain = 0x0ce6;
    public const uint hebrew_zayin = 0x0ce6;
    public const uint hebrew_chet = 0x0ce7;
    public const uint hebrew_het = 0x0ce7;
    public const uint hebrew_tet = 0x0ce8;
    public const uint hebrew_teth = 0x0ce8;
    public const uint hebrew_yod = 0x0ce9;
    public const uint hebrew_finalkaph = 0x0cea;
    public const uint hebrew_kaph = 0x0ceb;
    public const uint hebrew_lamed = 0x0cec;
    public const uint hebrew_finalmem = 0x0ced;
    public const uint hebrew_mem = 0x0cee;
    public const uint hebrew_finalnun = 0x0cef;
    public const uint hebrew_nun = 0x0cf0;
    public const uint hebrew_samech = 0x0cf1;
    public const uint hebrew_samekh = 0x0cf1;
    public const uint hebrew_ayin = 0x0cf2;
    public const uint hebrew_finalpe = 0x0cf3;
    public const uint hebrew_pe = 0x0cf4;
    public const uint hebrew_finalzade = 0x0cf5;
    public const uint hebrew_finalzadi = 0x0cf5;
    public const uint hebrew_zade = 0x0cf6;
    public const uint hebrew_zadi = 0x0cf6;
    public const uint hebrew_qoph = 0x0cf7;
    public const uint hebrew_kuf = 0x0cf7;
    public const uint hebrew_resh = 0x0cf8;
    public const uint hebrew_shin = 0x0cf9;
    public const uint hebrew_taw = 0x0cfa;
    public const uint hebrew_taf = 0x0cfa;
    public const uint Hebrew_switch = 0xff7e;
    public const uint Thai_kokai = 0x0da1;
    public const uint Thai_khokhai = 0x0da2;
    public const uint Thai_khokhuat = 0x0da3;
    public const uint Thai_khokhwai = 0x0da4;
    public const uint Thai_khokhon = 0x0da5;
    public const uint Thai_khorakhang = 0x0da6;
    public const uint Thai_ngongu = 0x0da7;
    public const uint Thai_chochan = 0x0da8;
    public const uint Thai_choching = 0x0da9;
    public const uint Thai_chochang = 0x0daa;
    public const uint Thai_soso = 0x0dab;
    public const uint Thai_chochoe = 0x0dac;
    public const uint Thai_yoying = 0x0dad;
    public const uint Thai_dochada = 0x0dae;
    public const uint Thai_topatak = 0x0daf;
    public const uint Thai_thothan = 0x0db0;
    public const uint Thai_thonangmontho = 0x0db1;
    public const uint Thai_thophuthao = 0x0db2;
    public const uint Thai_nonen = 0x0db3;
    public const uint Thai_dodek = 0x0db4;
    public const uint Thai_totao = 0x0db5;
    public const uint Thai_thothung = 0x0db6;
    public const uint Thai_thothahan = 0x0db7;
    public const uint Thai_thothong = 0x0db8;
    public const uint Thai_nonu = 0x0db9;
    public const uint Thai_bobaimai = 0x0dba;
    public const uint Thai_popla = 0x0dbb;
    public const uint Thai_phophung = 0x0dbc;
    public const uint Thai_fofa = 0x0dbd;
    public const uint Thai_phophan = 0x0dbe;
    public const uint Thai_fofan = 0x0dbf;
    public const uint Thai_phosamphao = 0x0dc0;
    public const uint Thai_moma = 0x0dc1;
    public const uint Thai_yoyak = 0x0dc2;
    public const uint Thai_rorua = 0x0dc3;
    public const uint Thai_ru = 0x0dc4;
    public const uint Thai_loling = 0x0dc5;
    public const uint Thai_lu = 0x0dc6;
    public const uint Thai_wowaen = 0x0dc7;
    public const uint Thai_sosala = 0x0dc8;
    public const uint Thai_sorusi = 0x0dc9;
    public const uint Thai_sosua = 0x0dca;
    public const uint Thai_hohip = 0x0dcb;
    public const uint Thai_lochula = 0x0dcc;
    public const uint Thai_oang = 0x0dcd;
    public const uint Thai_honokhuk = 0x0dce;
    public const uint Thai_paiyannoi = 0x0dcf;
    public const uint Thai_saraa = 0x0dd0;
    public const uint Thai_maihanakat = 0x0dd1;
    public const uint Thai_saraaa = 0x0dd2;
    public const uint Thai_saraam = 0x0dd3;
    public const uint Thai_sarai = 0x0dd4;
    public const uint Thai_saraii = 0x0dd5;
    public const uint Thai_saraue = 0x0dd6;
    public const uint Thai_sarauee = 0x0dd7;
    public const uint Thai_sarau = 0x0dd8;
    public const uint Thai_sarauu = 0x0dd9;
    public const uint Thai_phinthu = 0x0dda;
    public const uint Thai_maihanakat_maitho = 0x0dde;
    public const uint Thai_baht = 0x0ddf;
    public const uint Thai_sarae = 0x0de0;
    public const uint Thai_saraae = 0x0de1;
    public const uint Thai_sarao = 0x0de2;
    public const uint Thai_saraaimaimuan = 0x0de3;
    public const uint Thai_saraaimaimalai = 0x0de4;
    public const uint Thai_lakkhangyao = 0x0de5;
    public const uint Thai_maiyamok = 0x0de6;
    public const uint Thai_maitaikhu = 0x0de7;
    public const uint Thai_maiek = 0x0de8;
    public const uint Thai_maitho = 0x0de9;
    public const uint Thai_maitri = 0x0dea;
    public const uint Thai_maichattawa = 0x0deb;
    public const uint Thai_thanthakhat = 0x0dec;
    public const uint Thai_nikhahit = 0x0ded;
    public const uint Thai_leksun = 0x0df0;
    public const uint Thai_leknung = 0x0df1;
    public const uint Thai_leksong = 0x0df2;
    public const uint Thai_leksam = 0x0df3;
    public const uint Thai_leksi = 0x0df4;
    public const uint Thai_lekha = 0x0df5;
    public const uint Thai_lekhok = 0x0df6;
    public const uint Thai_lekchet = 0x0df7;
    public const uint Thai_lekpaet = 0x0df8;
    public const uint Thai_lekkao = 0x0df9;
    public const uint Hangul = 0xff31;
    public const uint Hangul_Start = 0xff32;
    public const uint Hangul_End = 0xff33;
    public const uint Hangul_Hanja = 0xff34;
    public const uint Hangul_Jamo = 0xff35;
    public const uint Hangul_Romaja = 0xff36;
    public const uint Hangul_Codeinput = 0xff37;
    public const uint Hangul_Jeonja = 0xff38;
    public const uint Hangul_Banja = 0xff39;
    public const uint Hangul_PreHanja = 0xff3a;
    public const uint Hangul_PostHanja = 0xff3b;
    public const uint Hangul_SingleCandidate = 0xff3c;
    public const uint Hangul_MultipleCandidate = 0xff3d;
    public const uint Hangul_PreviousCandidate = 0xff3e;
    public const uint Hangul_Special = 0xff3f;
    public const uint Hangul_switch = 0xff7e;
    public const uint Hangul_Kiyeog = 0x0ea1;
    public const uint Hangul_SsangKiyeog = 0x0ea2;
    public const uint Hangul_KiyeogSios = 0x0ea3;
    public const uint Hangul_Nieun = 0x0ea4;
    public const uint Hangul_NieunJieuj = 0x0ea5;
    public const uint Hangul_NieunHieuh = 0x0ea6;
    public const uint Hangul_Dikeud = 0x0ea7;
    public const uint Hangul_SsangDikeud = 0x0ea8;
    public const uint Hangul_Rieul = 0x0ea9;
    public const uint Hangul_RieulKiyeog = 0x0eaa;
    public const uint Hangul_RieulMieum = 0x0eab;
    public const uint Hangul_RieulPieub = 0x0eac;
    public const uint Hangul_RieulSios = 0x0ead;
    public const uint Hangul_RieulTieut = 0x0eae;
    public const uint Hangul_RieulPhieuf = 0x0eaf;
    public const uint Hangul_RieulHieuh = 0x0eb0;
    public const uint Hangul_Mieum = 0x0eb1;
    public const uint Hangul_Pieub = 0x0eb2;
    public const uint Hangul_SsangPieub = 0x0eb3;
    public const uint Hangul_PieubSios = 0x0eb4;
    public const uint Hangul_Sios = 0x0eb5;
    public const uint Hangul_SsangSios = 0x0eb6;
    public const uint Hangul_Ieung = 0x0eb7;
    public const uint Hangul_Jieuj = 0x0eb8;
    public const uint Hangul_SsangJieuj = 0x0eb9;
    public const uint Hangul_Cieuc = 0x0eba;
    public const uint Hangul_Khieuq = 0x0ebb;
    public const uint Hangul_Tieut = 0x0ebc;
    public const uint Hangul_Phieuf = 0x0ebd;
    public const uint Hangul_Hieuh = 0x0ebe;
    public const uint Hangul_A = 0x0ebf;
    public const uint Hangul_AE = 0x0ec0;
    public const uint Hangul_YA = 0x0ec1;
    public const uint Hangul_YAE = 0x0ec2;
    public const uint Hangul_EO = 0x0ec3;
    public const uint Hangul_E = 0x0ec4;
    public const uint Hangul_YEO = 0x0ec5;
    public const uint Hangul_YE = 0x0ec6;
    public const uint Hangul_O = 0x0ec7;
    public const uint Hangul_WA = 0x0ec8;
    public const uint Hangul_WAE = 0x0ec9;
    public const uint Hangul_OE = 0x0eca;
    public const uint Hangul_YO = 0x0ecb;
    public const uint Hangul_U = 0x0ecc;
    public const uint Hangul_WEO = 0x0ecd;
    public const uint Hangul_WE = 0x0ece;
    public const uint Hangul_WI = 0x0ecf;
    public const uint Hangul_YU = 0x0ed0;
    public const uint Hangul_EU = 0x0ed1;
    public const uint Hangul_YI = 0x0ed2;
    public const uint Hangul_I = 0x0ed3;
    public const uint Hangul_J_Kiyeog = 0x0ed4;
    public const uint Hangul_J_SsangKiyeog = 0x0ed5;
    public const uint Hangul_J_KiyeogSios = 0x0ed6;
    public const uint Hangul_J_Nieun = 0x0ed7;
    public const uint Hangul_J_NieunJieuj = 0x0ed8;
    public const uint Hangul_J_NieunHieuh = 0x0ed9;
    public const uint Hangul_J_Dikeud = 0x0eda;
    public const uint Hangul_J_Rieul = 0x0edb;
    public const uint Hangul_J_RieulKiyeog = 0x0edc;
    public const uint Hangul_J_RieulMieum = 0x0edd;
    public const uint Hangul_J_RieulPieub = 0x0ede;
    public const uint Hangul_J_RieulSios = 0x0edf;
    public const uint Hangul_J_RieulTieut = 0x0ee0;
    public const uint Hangul_J_RieulPhieuf = 0x0ee1;
    public const uint Hangul_J_RieulHieuh = 0x0ee2;
    public const uint Hangul_J_Mieum = 0x0ee3;
    public const uint Hangul_J_Pieub = 0x0ee4;
    public const uint Hangul_J_PieubSios = 0x0ee5;
    public const uint Hangul_J_Sios = 0x0ee6;
    public const uint Hangul_J_SsangSios = 0x0ee7;
    public const uint Hangul_J_Ieung = 0x0ee8;
    public const uint Hangul_J_Jieuj = 0x0ee9;
    public const uint Hangul_J_Cieuc = 0x0eea;
    public const uint Hangul_J_Khieuq = 0x0eeb;
    public const uint Hangul_J_Tieut = 0x0eec;
    public const uint Hangul_J_Phieuf = 0x0eed;
    public const uint Hangul_J_Hieuh = 0x0eee;
    public const uint Hangul_RieulYeorinHieuh = 0x0eef;
    public const uint Hangul_SunkyeongeumMieum = 0x0ef0;
    public const uint Hangul_SunkyeongeumPieub = 0x0ef1;
    public const uint Hangul_PanSios = 0x0ef2;
    public const uint Hangul_KkogjiDalrinIeung = 0x0ef3;
    public const uint Hangul_SunkyeongeumPhieuf = 0x0ef4;
    public const uint Hangul_YeorinHieuh = 0x0ef5;
    public const uint Hangul_AraeA = 0x0ef6;
    public const uint Hangul_AraeAE = 0x0ef7;
    public const uint Hangul_J_PanSios = 0x0ef8;
    public const uint Hangul_J_KkogjiDalrinIeung = 0x0ef9;
    public const uint Hangul_J_YeorinHieuh = 0x0efa;
    public const uint Korean_Won = 0x0eff;
    public const uint Armenian_ligature_ew = 0x1000587;
    public const uint Armenian_full_stop = 0x1000589;
    public const uint Armenian_verjaket = 0x1000589;
    public const uint Armenian_separation_mark = 0x100055d;
    public const uint Armenian_but = 0x100055d;
    public const uint Armenian_hyphen = 0x100058a;
    public const uint Armenian_yentamna = 0x100058a;
    public const uint Armenian_exclam = 0x100055c;
    public const uint Armenian_amanak = 0x100055c;
    public const uint Armenian_accent = 0x100055b;
    public const uint Armenian_shesht = 0x100055b;
    public const uint Armenian_question = 0x100055e;
    public const uint Armenian_paruyk = 0x100055e;
    public const uint Armenian_AYB = 0x1000531;
    public const uint Armenian_ayb = 0x1000561;
    public const uint Armenian_BEN = 0x1000532;
    public const uint Armenian_ben = 0x1000562;
    public const uint Armenian_GIM = 0x1000533;
    public const uint Armenian_gim = 0x1000563;
    public const uint Armenian_DA = 0x1000534;
    public const uint Armenian_da = 0x1000564;
    public const uint Armenian_YECH = 0x1000535;
    public const uint Armenian_yech = 0x1000565;
    public const uint Armenian_ZA = 0x1000536;
    public const uint Armenian_za = 0x1000566;
    public const uint Armenian_E = 0x1000537;
    public const uint Armenian_e = 0x1000567;
    public const uint Armenian_AT = 0x1000538;
    public const uint Armenian_at = 0x1000568;
    public const uint Armenian_TO = 0x1000539;
    public const uint Armenian_to = 0x1000569;
    public const uint Armenian_ZHE = 0x100053a;
    public const uint Armenian_zhe = 0x100056a;
    public const uint Armenian_INI = 0x100053b;
    public const uint Armenian_ini = 0x100056b;
    public const uint Armenian_LYUN = 0x100053c;
    public const uint Armenian_lyun = 0x100056c;
    public const uint Armenian_KHE = 0x100053d;
    public const uint Armenian_khe = 0x100056d;
    public const uint Armenian_TSA = 0x100053e;
    public const uint Armenian_tsa = 0x100056e;
    public const uint Armenian_KEN = 0x100053f;
    public const uint Armenian_ken = 0x100056f;
    public const uint Armenian_HO = 0x1000540;
    public const uint Armenian_ho = 0x1000570;
    public const uint Armenian_DZA = 0x1000541;
    public const uint Armenian_dza = 0x1000571;
    public const uint Armenian_GHAT = 0x1000542;
    public const uint Armenian_ghat = 0x1000572;
    public const uint Armenian_TCHE = 0x1000543;
    public const uint Armenian_tche = 0x1000573;
    public const uint Armenian_MEN = 0x1000544;
    public const uint Armenian_men = 0x1000574;
    public const uint Armenian_HI = 0x1000545;
    public const uint Armenian_hi = 0x1000575;
    public const uint Armenian_NU = 0x1000546;
    public const uint Armenian_nu = 0x1000576;
    public const uint Armenian_SHA = 0x1000547;
    public const uint Armenian_sha = 0x1000577;
    public const uint Armenian_VO = 0x1000548;
    public const uint Armenian_vo = 0x1000578;
    public const uint Armenian_CHA = 0x1000549;
    public const uint Armenian_cha = 0x1000579;
    public const uint Armenian_PE = 0x100054a;
    public const uint Armenian_pe = 0x100057a;
    public const uint Armenian_JE = 0x100054b;
    public const uint Armenian_je = 0x100057b;
    public const uint Armenian_RA = 0x100054c;
    public const uint Armenian_ra = 0x100057c;
    public const uint Armenian_SE = 0x100054d;
    public const uint Armenian_se = 0x100057d;
    public const uint Armenian_VEV = 0x100054e;
    public const uint Armenian_vev = 0x100057e;
    public const uint Armenian_TYUN = 0x100054f;
    public const uint Armenian_tyun = 0x100057f;
    public const uint Armenian_RE = 0x1000550;
    public const uint Armenian_re = 0x1000580;
    public const uint Armenian_TSO = 0x1000551;
    public const uint Armenian_tso = 0x1000581;
    public const uint Armenian_VYUN = 0x1000552;
    public const uint Armenian_vyun = 0x1000582;
    public const uint Armenian_PYUR = 0x1000553;
    public const uint Armenian_pyur = 0x1000583;
    public const uint Armenian_KE = 0x1000554;
    public const uint Armenian_ke = 0x1000584;
    public const uint Armenian_O = 0x1000555;
    public const uint Armenian_o = 0x1000585;
    public const uint Armenian_FE = 0x1000556;
    public const uint Armenian_fe = 0x1000586;
    public const uint Armenian_apostrophe = 0x100055a;
    public const uint Georgian_an = 0x10010d0;
    public const uint Georgian_ban = 0x10010d1;
    public const uint Georgian_gan = 0x10010d2;
    public const uint Georgian_don = 0x10010d3;
    public const uint Georgian_en = 0x10010d4;
    public const uint Georgian_vin = 0x10010d5;
    public const uint Georgian_zen = 0x10010d6;
    public const uint Georgian_tan = 0x10010d7;
    public const uint Georgian_in = 0x10010d8;
    public const uint Georgian_kan = 0x10010d9;
    public const uint Georgian_las = 0x10010da;
    public const uint Georgian_man = 0x10010db;
    public const uint Georgian_nar = 0x10010dc;
    public const uint Georgian_on = 0x10010dd;
    public const uint Georgian_par = 0x10010de;
    public const uint Georgian_zhar = 0x10010df;
    public const uint Georgian_rae = 0x10010e0;
    public const uint Georgian_san = 0x10010e1;
    public const uint Georgian_tar = 0x10010e2;
    public const uint Georgian_un = 0x10010e3;
    public const uint Georgian_phar = 0x10010e4;
    public const uint Georgian_khar = 0x10010e5;
    public const uint Georgian_ghan = 0x10010e6;
    public const uint Georgian_qar = 0x10010e7;
    public const uint Georgian_shin = 0x10010e8;
    public const uint Georgian_chin = 0x10010e9;
    public const uint Georgian_can = 0x10010ea;
    public const uint Georgian_jil = 0x10010eb;
    public const uint Georgian_cil = 0x10010ec;
    public const uint Georgian_char = 0x10010ed;
    public const uint Georgian_xan = 0x10010ee;
    public const uint Georgian_jhan = 0x10010ef;
    public const uint Georgian_hae = 0x10010f0;
    public const uint Georgian_he = 0x10010f1;
    public const uint Georgian_hie = 0x10010f2;
    public const uint Georgian_we = 0x10010f3;
    public const uint Georgian_har = 0x10010f4;
    public const uint Georgian_hoe = 0x10010f5;
    public const uint Georgian_fi = 0x10010f6;
    public const uint Xabovedot = 0x1001e8a;
    public const uint Ibreve = 0x100012c;
    public const uint Zstroke = 0x10001b5;
    public const uint Gcaron = 0x10001e6;
    public const uint Ocaron = 0x10001d1;
    public const uint Obarred = 0x100019f;
    public const uint xabovedot = 0x1001e8b;
    public const uint ibreve = 0x100012d;
    public const uint zstroke = 0x10001b6;
    public const uint gcaron = 0x10001e7;
    public const uint ocaron = 0x10001d2;
    public const uint obarred = 0x1000275;
    public const uint SCHWA = 0x100018f;
    public const uint schwa = 0x1000259;
    public const uint Lbelowdot = 0x1001e36;
    public const uint lbelowdot = 0x1001e37;
    public const uint Abelowdot = 0x1001ea0;
    public const uint abelowdot = 0x1001ea1;
    public const uint Ahook = 0x1001ea2;
    public const uint ahook = 0x1001ea3;
    public const uint Acircumflexacute = 0x1001ea4;
    public const uint acircumflexacute = 0x1001ea5;
    public const uint Acircumflexgrave = 0x1001ea6;
    public const uint acircumflexgrave = 0x1001ea7;
    public const uint Acircumflexhook = 0x1001ea8;
    public const uint acircumflexhook = 0x1001ea9;
    public const uint Acircumflextilde = 0x1001eaa;
    public const uint acircumflextilde = 0x1001eab;
    public const uint Acircumflexbelowdot = 0x1001eac;
    public const uint acircumflexbelowdot = 0x1001ead;
    public const uint Abreveacute = 0x1001eae;
    public const uint abreveacute = 0x1001eaf;
    public const uint Abrevegrave = 0x1001eb0;
    public const uint abrevegrave = 0x1001eb1;
    public const uint Abrevehook = 0x1001eb2;
    public const uint abrevehook = 0x1001eb3;
    public const uint Abrevetilde = 0x1001eb4;
    public const uint abrevetilde = 0x1001eb5;
    public const uint Abrevebelowdot = 0x1001eb6;
    public const uint abrevebelowdot = 0x1001eb7;
    public const uint Ebelowdot = 0x1001eb8;
    public const uint ebelowdot = 0x1001eb9;
    public const uint Ehook = 0x1001eba;
    public const uint ehook = 0x1001ebb;
    public const uint Etilde = 0x1001ebc;
    public const uint etilde = 0x1001ebd;
    public const uint Ecircumflexacute = 0x1001ebe;
    public const uint ecircumflexacute = 0x1001ebf;
    public const uint Ecircumflexgrave = 0x1001ec0;
    public const uint ecircumflexgrave = 0x1001ec1;
    public const uint Ecircumflexhook = 0x1001ec2;
    public const uint ecircumflexhook = 0x1001ec3;
    public const uint Ecircumflextilde = 0x1001ec4;
    public const uint ecircumflextilde = 0x1001ec5;
    public const uint Ecircumflexbelowdot = 0x1001ec6;
    public const uint ecircumflexbelowdot = 0x1001ec7;
    public const uint Ihook = 0x1001ec8;
    public const uint ihook = 0x1001ec9;
    public const uint Ibelowdot = 0x1001eca;
    public const uint ibelowdot = 0x1001ecb;
    public const uint Obelowdot = 0x1001ecc;
    public const uint obelowdot = 0x1001ecd;
    public const uint Ohook = 0x1001ece;
    public const uint ohook = 0x1001ecf;
    public const uint Ocircumflexacute = 0x1001ed0;
    public const uint ocircumflexacute = 0x1001ed1;
    public const uint Ocircumflexgrave = 0x1001ed2;
    public const uint ocircumflexgrave = 0x1001ed3;
    public const uint Ocircumflexhook = 0x1001ed4;
    public const uint ocircumflexhook = 0x1001ed5;
    public const uint Ocircumflextilde = 0x1001ed6;
    public const uint ocircumflextilde = 0x1001ed7;
    public const uint Ocircumflexbelowdot = 0x1001ed8;
    public const uint ocircumflexbelowdot = 0x1001ed9;
    public const uint Ohornacute = 0x1001eda;
    public const uint ohornacute = 0x1001edb;
    public const uint Ohorngrave = 0x1001edc;
    public const uint ohorngrave = 0x1001edd;
    public const uint Ohornhook = 0x1001ede;
    public const uint ohornhook = 0x1001edf;
    public const uint Ohorntilde = 0x1001ee0;
    public const uint ohorntilde = 0x1001ee1;
    public const uint Ohornbelowdot = 0x1001ee2;
    public const uint ohornbelowdot = 0x1001ee3;
    public const uint Ubelowdot = 0x1001ee4;
    public const uint ubelowdot = 0x1001ee5;
    public const uint Uhook = 0x1001ee6;
    public const uint uhook = 0x1001ee7;
    public const uint Uhornacute = 0x1001ee8;
    public const uint uhornacute = 0x1001ee9;
    public const uint Uhorngrave = 0x1001eea;
    public const uint uhorngrave = 0x1001eeb;
    public const uint Uhornhook = 0x1001eec;
    public const uint uhornhook = 0x1001eed;
    public const uint Uhorntilde = 0x1001eee;
    public const uint uhorntilde = 0x1001eef;
    public const uint Uhornbelowdot = 0x1001ef0;
    public const uint uhornbelowdot = 0x1001ef1;
    public const uint Ybelowdot = 0x1001ef4;
    public const uint ybelowdot = 0x1001ef5;
    public const uint Yhook = 0x1001ef6;
    public const uint yhook = 0x1001ef7;
    public const uint Ytilde = 0x1001ef8;
    public const uint ytilde = 0x1001ef9;
    public const uint Ohorn = 0x10001a0;
    public const uint ohorn = 0x10001a1;
    public const uint Uhorn = 0x10001af;
    public const uint uhorn = 0x10001b0;
    public const uint EcuSign = 0x10020a0;
    public const uint ColonSign = 0x10020a1;
    public const uint CruzeiroSign = 0x10020a2;
    public const uint FFrancSign = 0x10020a3;
    public const uint LiraSign = 0x10020a4;
    public const uint MillSign = 0x10020a5;
    public const uint NairaSign = 0x10020a6;
    public const uint PesetaSign = 0x10020a7;
    public const uint RupeeSign = 0x10020a8;
    public const uint WonSign = 0x10020a9;
    public const uint NewSheqelSign = 0x10020aa;
    public const uint DongSign = 0x10020ab;
    public const uint EuroSign = 0x20ac;
    public const uint zerosuperior = 0x1002070;
    public const uint foursuperior = 0x1002074;
    public const uint fivesuperior = 0x1002075;
    public const uint sixsuperior = 0x1002076;
    public const uint sevensuperior = 0x1002077;
    public const uint eightsuperior = 0x1002078;
    public const uint ninesuperior = 0x1002079;
    public const uint zerosubscript = 0x1002080;
    public const uint onesubscript = 0x1002081;
    public const uint twosubscript = 0x1002082;
    public const uint threesubscript = 0x1002083;
    public const uint foursubscript = 0x1002084;
    public const uint fivesubscript = 0x1002085;
    public const uint sixsubscript = 0x1002086;
    public const uint sevensubscript = 0x1002087;
    public const uint eightsubscript = 0x1002088;
    public const uint ninesubscript = 0x1002089;
    public const uint partdifferential = 0x1002202;
    public const uint emptyset = 0x1002205;
    public const uint elementof = 0x1002208;
    public const uint notelementof = 0x1002209;
    public const uint containsas = 0x100220B;
    public const uint squareroot = 0x100221A;
    public const uint cuberoot = 0x100221B;
    public const uint fourthroot = 0x100221C;
    public const uint dintegral = 0x100222C;
    public const uint tintegral = 0x100222D;
    public const uint because = 0x1002235;
    public const uint approxeq = 0x1002248;
    public const uint notapproxeq = 0x1002247;
    public const uint notidentical = 0x1002262;
    public const uint stricteq = 0x1002263;
    public const uint braille_dot_1 = 0xfff1;
    public const uint braille_dot_2 = 0xfff2;
    public const uint braille_dot_3 = 0xfff3;
    public const uint braille_dot_4 = 0xfff4;
    public const uint braille_dot_5 = 0xfff5;
    public const uint braille_dot_6 = 0xfff6;
    public const uint braille_dot_7 = 0xfff7;
    public const uint braille_dot_8 = 0xfff8;
    public const uint braille_dot_9 = 0xfff9;
    public const uint braille_dot_10 = 0xfffa;
    public const uint braille_blank = 0x1002800;
    public const uint braille_dots_1 = 0x1002801;
    public const uint braille_dots_2 = 0x1002802;
    public const uint braille_dots_12 = 0x1002803;
    public const uint braille_dots_3 = 0x1002804;
    public const uint braille_dots_13 = 0x1002805;
    public const uint braille_dots_23 = 0x1002806;
    public const uint braille_dots_123 = 0x1002807;
    public const uint braille_dots_4 = 0x1002808;
    public const uint braille_dots_14 = 0x1002809;
    public const uint braille_dots_24 = 0x100280a;
    public const uint braille_dots_124 = 0x100280b;
    public const uint braille_dots_34 = 0x100280c;
    public const uint braille_dots_134 = 0x100280d;
    public const uint braille_dots_234 = 0x100280e;
    public const uint braille_dots_1234 = 0x100280f;
    public const uint braille_dots_5 = 0x1002810;
    public const uint braille_dots_15 = 0x1002811;
    public const uint braille_dots_25 = 0x1002812;
    public const uint braille_dots_125 = 0x1002813;
    public const uint braille_dots_35 = 0x1002814;
    public const uint braille_dots_135 = 0x1002815;
    public const uint braille_dots_235 = 0x1002816;
    public const uint braille_dots_1235 = 0x1002817;
    public const uint braille_dots_45 = 0x1002818;
    public const uint braille_dots_145 = 0x1002819;
    public const uint braille_dots_245 = 0x100281a;
    public const uint braille_dots_1245 = 0x100281b;
    public const uint braille_dots_345 = 0x100281c;
    public const uint braille_dots_1345 = 0x100281d;
    public const uint braille_dots_2345 = 0x100281e;
    public const uint braille_dots_12345 = 0x100281f;
    public const uint braille_dots_6 = 0x1002820;
    public const uint braille_dots_16 = 0x1002821;
    public const uint braille_dots_26 = 0x1002822;
    public const uint braille_dots_126 = 0x1002823;
    public const uint braille_dots_36 = 0x1002824;
    public const uint braille_dots_136 = 0x1002825;
    public const uint braille_dots_236 = 0x1002826;
    public const uint braille_dots_1236 = 0x1002827;
    public const uint braille_dots_46 = 0x1002828;
    public const uint braille_dots_146 = 0x1002829;
    public const uint braille_dots_246 = 0x100282a;
    public const uint braille_dots_1246 = 0x100282b;
    public const uint braille_dots_346 = 0x100282c;
    public const uint braille_dots_1346 = 0x100282d;
    public const uint braille_dots_2346 = 0x100282e;
    public const uint braille_dots_12346 = 0x100282f;
    public const uint braille_dots_56 = 0x1002830;
    public const uint braille_dots_156 = 0x1002831;
    public const uint braille_dots_256 = 0x1002832;
    public const uint braille_dots_1256 = 0x1002833;
    public const uint braille_dots_356 = 0x1002834;
    public const uint braille_dots_1356 = 0x1002835;
    public const uint braille_dots_2356 = 0x1002836;
    public const uint braille_dots_12356 = 0x1002837;
    public const uint braille_dots_456 = 0x1002838;
    public const uint braille_dots_1456 = 0x1002839;
    public const uint braille_dots_2456 = 0x100283a;
    public const uint braille_dots_12456 = 0x100283b;
    public const uint braille_dots_3456 = 0x100283c;
    public const uint braille_dots_13456 = 0x100283d;
    public const uint braille_dots_23456 = 0x100283e;
    public const uint braille_dots_123456 = 0x100283f;
    public const uint braille_dots_7 = 0x1002840;
    public const uint braille_dots_17 = 0x1002841;
    public const uint braille_dots_27 = 0x1002842;
    public const uint braille_dots_127 = 0x1002843;
    public const uint braille_dots_37 = 0x1002844;
    public const uint braille_dots_137 = 0x1002845;
    public const uint braille_dots_237 = 0x1002846;
    public const uint braille_dots_1237 = 0x1002847;
    public const uint braille_dots_47 = 0x1002848;
    public const uint braille_dots_147 = 0x1002849;
    public const uint braille_dots_247 = 0x100284a;
    public const uint braille_dots_1247 = 0x100284b;
    public const uint braille_dots_347 = 0x100284c;
    public const uint braille_dots_1347 = 0x100284d;
    public const uint braille_dots_2347 = 0x100284e;
    public const uint braille_dots_12347 = 0x100284f;
    public const uint braille_dots_57 = 0x1002850;
    public const uint braille_dots_157 = 0x1002851;
    public const uint braille_dots_257 = 0x1002852;
    public const uint braille_dots_1257 = 0x1002853;
    public const uint braille_dots_357 = 0x1002854;
    public const uint braille_dots_1357 = 0x1002855;
    public const uint braille_dots_2357 = 0x1002856;
    public const uint braille_dots_12357 = 0x1002857;
    public const uint braille_dots_457 = 0x1002858;
    public const uint braille_dots_1457 = 0x1002859;
    public const uint braille_dots_2457 = 0x100285a;
    public const uint braille_dots_12457 = 0x100285b;
    public const uint braille_dots_3457 = 0x100285c;
    public const uint braille_dots_13457 = 0x100285d;
    public const uint braille_dots_23457 = 0x100285e;
    public const uint braille_dots_123457 = 0x100285f;
    public const uint braille_dots_67 = 0x1002860;
    public const uint braille_dots_167 = 0x1002861;
    public const uint braille_dots_267 = 0x1002862;
    public const uint braille_dots_1267 = 0x1002863;
    public const uint braille_dots_367 = 0x1002864;
    public const uint braille_dots_1367 = 0x1002865;
    public const uint braille_dots_2367 = 0x1002866;
    public const uint braille_dots_12367 = 0x1002867;
    public const uint braille_dots_467 = 0x1002868;
    public const uint braille_dots_1467 = 0x1002869;
    public const uint braille_dots_2467 = 0x100286a;
    public const uint braille_dots_12467 = 0x100286b;
    public const uint braille_dots_3467 = 0x100286c;
    public const uint braille_dots_13467 = 0x100286d;
    public const uint braille_dots_23467 = 0x100286e;
    public const uint braille_dots_123467 = 0x100286f;
    public const uint braille_dots_567 = 0x1002870;
    public const uint braille_dots_1567 = 0x1002871;
    public const uint braille_dots_2567 = 0x1002872;
    public const uint braille_dots_12567 = 0x1002873;
    public const uint braille_dots_3567 = 0x1002874;
    public const uint braille_dots_13567 = 0x1002875;
    public const uint braille_dots_23567 = 0x1002876;
    public const uint braille_dots_123567 = 0x1002877;
    public const uint braille_dots_4567 = 0x1002878;
    public const uint braille_dots_14567 = 0x1002879;
    public const uint braille_dots_24567 = 0x100287a;
    public const uint braille_dots_124567 = 0x100287b;
    public const uint braille_dots_34567 = 0x100287c;
    public const uint braille_dots_134567 = 0x100287d;
    public const uint braille_dots_234567 = 0x100287e;
    public const uint braille_dots_1234567 = 0x100287f;
    public const uint braille_dots_8 = 0x1002880;
    public const uint braille_dots_18 = 0x1002881;
    public const uint braille_dots_28 = 0x1002882;
    public const uint braille_dots_128 = 0x1002883;
    public const uint braille_dots_38 = 0x1002884;
    public const uint braille_dots_138 = 0x1002885;
    public const uint braille_dots_238 = 0x1002886;
    public const uint braille_dots_1238 = 0x1002887;
    public const uint braille_dots_48 = 0x1002888;
    public const uint braille_dots_148 = 0x1002889;
    public const uint braille_dots_248 = 0x100288a;
    public const uint braille_dots_1248 = 0x100288b;
    public const uint braille_dots_348 = 0x100288c;
    public const uint braille_dots_1348 = 0x100288d;
    public const uint braille_dots_2348 = 0x100288e;
    public const uint braille_dots_12348 = 0x100288f;
    public const uint braille_dots_58 = 0x1002890;
    public const uint braille_dots_158 = 0x1002891;
    public const uint braille_dots_258 = 0x1002892;
    public const uint braille_dots_1258 = 0x1002893;
    public const uint braille_dots_358 = 0x1002894;
    public const uint braille_dots_1358 = 0x1002895;
    public const uint braille_dots_2358 = 0x1002896;
    public const uint braille_dots_12358 = 0x1002897;
    public const uint braille_dots_458 = 0x1002898;
    public const uint braille_dots_1458 = 0x1002899;
    public const uint braille_dots_2458 = 0x100289a;
    public const uint braille_dots_12458 = 0x100289b;
    public const uint braille_dots_3458 = 0x100289c;
    public const uint braille_dots_13458 = 0x100289d;
    public const uint braille_dots_23458 = 0x100289e;
    public const uint braille_dots_123458 = 0x100289f;
    public const uint braille_dots_68 = 0x10028a0;
    public const uint braille_dots_168 = 0x10028a1;
    public const uint braille_dots_268 = 0x10028a2;
    public const uint braille_dots_1268 = 0x10028a3;
    public const uint braille_dots_368 = 0x10028a4;
    public const uint braille_dots_1368 = 0x10028a5;
    public const uint braille_dots_2368 = 0x10028a6;
    public const uint braille_dots_12368 = 0x10028a7;
    public const uint braille_dots_468 = 0x10028a8;
    public const uint braille_dots_1468 = 0x10028a9;
    public const uint braille_dots_2468 = 0x10028aa;
    public const uint braille_dots_12468 = 0x10028ab;
    public const uint braille_dots_3468 = 0x10028ac;
    public const uint braille_dots_13468 = 0x10028ad;
    public const uint braille_dots_23468 = 0x10028ae;
    public const uint braille_dots_123468 = 0x10028af;
    public const uint braille_dots_568 = 0x10028b0;
    public const uint braille_dots_1568 = 0x10028b1;
    public const uint braille_dots_2568 = 0x10028b2;
    public const uint braille_dots_12568 = 0x10028b3;
    public const uint braille_dots_3568 = 0x10028b4;
    public const uint braille_dots_13568 = 0x10028b5;
    public const uint braille_dots_23568 = 0x10028b6;
    public const uint braille_dots_123568 = 0x10028b7;
    public const uint braille_dots_4568 = 0x10028b8;
    public const uint braille_dots_14568 = 0x10028b9;
    public const uint braille_dots_24568 = 0x10028ba;
    public const uint braille_dots_124568 = 0x10028bb;
    public const uint braille_dots_34568 = 0x10028bc;
    public const uint braille_dots_134568 = 0x10028bd;
    public const uint braille_dots_234568 = 0x10028be;
    public const uint braille_dots_1234568 = 0x10028bf;
    public const uint braille_dots_78 = 0x10028c0;
    public const uint braille_dots_178 = 0x10028c1;
    public const uint braille_dots_278 = 0x10028c2;
    public const uint braille_dots_1278 = 0x10028c3;
    public const uint braille_dots_378 = 0x10028c4;
    public const uint braille_dots_1378 = 0x10028c5;
    public const uint braille_dots_2378 = 0x10028c6;
    public const uint braille_dots_12378 = 0x10028c7;
    public const uint braille_dots_478 = 0x10028c8;
    public const uint braille_dots_1478 = 0x10028c9;
    public const uint braille_dots_2478 = 0x10028ca;
    public const uint braille_dots_12478 = 0x10028cb;
    public const uint braille_dots_3478 = 0x10028cc;
    public const uint braille_dots_13478 = 0x10028cd;
    public const uint braille_dots_23478 = 0x10028ce;
    public const uint braille_dots_123478 = 0x10028cf;
    public const uint braille_dots_578 = 0x10028d0;
    public const uint braille_dots_1578 = 0x10028d1;
    public const uint braille_dots_2578 = 0x10028d2;
    public const uint braille_dots_12578 = 0x10028d3;
    public const uint braille_dots_3578 = 0x10028d4;
    public const uint braille_dots_13578 = 0x10028d5;
    public const uint braille_dots_23578 = 0x10028d6;
    public const uint braille_dots_123578 = 0x10028d7;
    public const uint braille_dots_4578 = 0x10028d8;
    public const uint braille_dots_14578 = 0x10028d9;
    public const uint braille_dots_24578 = 0x10028da;
    public const uint braille_dots_124578 = 0x10028db;
    public const uint braille_dots_34578 = 0x10028dc;
    public const uint braille_dots_134578 = 0x10028dd;
    public const uint braille_dots_234578 = 0x10028de;
    public const uint braille_dots_1234578 = 0x10028df;
    public const uint braille_dots_678 = 0x10028e0;
    public const uint braille_dots_1678 = 0x10028e1;
    public const uint braille_dots_2678 = 0x10028e2;
    public const uint braille_dots_12678 = 0x10028e3;
    public const uint braille_dots_3678 = 0x10028e4;
    public const uint braille_dots_13678 = 0x10028e5;
    public const uint braille_dots_23678 = 0x10028e6;
    public const uint braille_dots_123678 = 0x10028e7;
    public const uint braille_dots_4678 = 0x10028e8;
    public const uint braille_dots_14678 = 0x10028e9;
    public const uint braille_dots_24678 = 0x10028ea;
    public const uint braille_dots_124678 = 0x10028eb;
    public const uint braille_dots_34678 = 0x10028ec;
    public const uint braille_dots_134678 = 0x10028ed;
    public const uint braille_dots_234678 = 0x10028ee;
    public const uint braille_dots_1234678 = 0x10028ef;
    public const uint braille_dots_5678 = 0x10028f0;
    public const uint braille_dots_15678 = 0x10028f1;
    public const uint braille_dots_25678 = 0x10028f2;
    public const uint braille_dots_125678 = 0x10028f3;
    public const uint braille_dots_35678 = 0x10028f4;
    public const uint braille_dots_135678 = 0x10028f5;
    public const uint braille_dots_235678 = 0x10028f6;
    public const uint braille_dots_1235678 = 0x10028f7;
    public const uint braille_dots_45678 = 0x10028f8;
    public const uint braille_dots_145678 = 0x10028f9;
    public const uint braille_dots_245678 = 0x10028fa;
    public const uint braille_dots_1245678 = 0x10028fb;
    public const uint braille_dots_345678 = 0x10028fc;
    public const uint braille_dots_1345678 = 0x10028fd;
    public const uint braille_dots_2345678 = 0x10028fe;
    public const uint braille_dots_12345678 = 0x10028ff;
    public const uint Sinh_ng = 0x1000d82;
    public const uint Sinh_h2 = 0x1000d83;
    public const uint Sinh_a = 0x1000d85;
    public const uint Sinh_aa = 0x1000d86;
    public const uint Sinh_ae = 0x1000d87;
    public const uint Sinh_aee = 0x1000d88;
    public const uint Sinh_i = 0x1000d89;
    public const uint Sinh_ii = 0x1000d8a;
    public const uint Sinh_u = 0x1000d8b;
    public const uint Sinh_uu = 0x1000d8c;
    public const uint Sinh_ri = 0x1000d8d;
    public const uint Sinh_rii = 0x1000d8e;
    public const uint Sinh_lu = 0x1000d8f;
    public const uint Sinh_luu = 0x1000d90;
    public const uint Sinh_e = 0x1000d91;
    public const uint Sinh_ee = 0x1000d92;
    public const uint Sinh_ai = 0x1000d93;
    public const uint Sinh_o = 0x1000d94;
    public const uint Sinh_oo = 0x1000d95;
    public const uint Sinh_au = 0x1000d96;
    public const uint Sinh_ka = 0x1000d9a;
    public const uint Sinh_kha = 0x1000d9b;
    public const uint Sinh_ga = 0x1000d9c;
    public const uint Sinh_gha = 0x1000d9d;
    public const uint Sinh_ng2 = 0x1000d9e;
    public const uint Sinh_nga = 0x1000d9f;
    public const uint Sinh_ca = 0x1000da0;
    public const uint Sinh_cha = 0x1000da1;
    public const uint Sinh_ja = 0x1000da2;
    public const uint Sinh_jha = 0x1000da3;
    public const uint Sinh_nya = 0x1000da4;
    public const uint Sinh_jnya = 0x1000da5;
    public const uint Sinh_nja = 0x1000da6;
    public const uint Sinh_tta = 0x1000da7;
    public const uint Sinh_ttha = 0x1000da8;
    public const uint Sinh_dda = 0x1000da9;
    public const uint Sinh_ddha = 0x1000daa;
    public const uint Sinh_nna = 0x1000dab;
    public const uint Sinh_ndda = 0x1000dac;
    public const uint Sinh_tha = 0x1000dad;
    public const uint Sinh_thha = 0x1000dae;
    public const uint Sinh_dha = 0x1000daf;
    public const uint Sinh_dhha = 0x1000db0;
    public const uint Sinh_na = 0x1000db1;
    public const uint Sinh_ndha = 0x1000db3;
    public const uint Sinh_pa = 0x1000db4;
    public const uint Sinh_pha = 0x1000db5;
    public const uint Sinh_ba = 0x1000db6;
    public const uint Sinh_bha = 0x1000db7;
    public const uint Sinh_ma = 0x1000db8;
    public const uint Sinh_mba = 0x1000db9;
    public const uint Sinh_ya = 0x1000dba;
    public const uint Sinh_ra = 0x1000dbb;
    public const uint Sinh_la = 0x1000dbd;
    public const uint Sinh_va = 0x1000dc0;
    public const uint Sinh_sha = 0x1000dc1;
    public const uint Sinh_ssha = 0x1000dc2;
    public const uint Sinh_sa = 0x1000dc3;
    public const uint Sinh_ha = 0x1000dc4;
    public const uint Sinh_lla = 0x1000dc5;
    public const uint Sinh_fa = 0x1000dc6;
    public const uint Sinh_al = 0x1000dca;
    public const uint Sinh_aa2 = 0x1000dcf;
    public const uint Sinh_ae2 = 0x1000dd0;
    public const uint Sinh_aee2 = 0x1000dd1;
    public const uint Sinh_i2 = 0x1000dd2;
    public const uint Sinh_ii2 = 0x1000dd3;
    public const uint Sinh_u2 = 0x1000dd4;
    public const uint Sinh_uu2 = 0x1000dd6;
    public const uint Sinh_ru2 = 0x1000dd8;
    public const uint Sinh_e2 = 0x1000dd9;
    public const uint Sinh_ee2 = 0x1000dda;
    public const uint Sinh_ai2 = 0x1000ddb;
    public const uint Sinh_o2 = 0x1000ddc;
    public const uint Sinh_oo2 = 0x1000ddd;
    public const uint Sinh_au2 = 0x1000dde;
    public const uint Sinh_lu2 = 0x1000ddf;
    public const uint Sinh_ruu2 = 0x1000df2;
    public const uint Sinh_luu2 = 0x1000df3;
    public const uint Sinh_kunddaliya = 0x1000df4;
}
