/* key-event.c generated by valac 0.38.1.30-90885, the Vala compiler
 * generated from key-event.vala, do not modify */

/*
 * Copyright (C) 2011-2017 Daiki Ueno <ueno@gnu.org>
 * Copyright (C) 2011-2017 Red Hat, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>


#define SKK_TYPE_MODIFIER_TYPE (skk_modifier_type_get_type ())

#define SKK_TYPE_KEY_EVENT (skk_key_event_get_type ())
#define SKK_KEY_EVENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SKK_TYPE_KEY_EVENT, SkkKeyEvent))
#define SKK_KEY_EVENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SKK_TYPE_KEY_EVENT, SkkKeyEventClass))
#define SKK_IS_KEY_EVENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SKK_TYPE_KEY_EVENT))
#define SKK_IS_KEY_EVENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SKK_TYPE_KEY_EVENT))
#define SKK_KEY_EVENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SKK_TYPE_KEY_EVENT, SkkKeyEventClass))

typedef struct _SkkKeyEvent SkkKeyEvent;
typedef struct _SkkKeyEventClass SkkKeyEventClass;
typedef struct _SkkKeyEventPrivate SkkKeyEventPrivate;
enum  {
	SKK_KEY_EVENT_0_PROPERTY,
	SKK_KEY_EVENT_NAME_PROPERTY,
	SKK_KEY_EVENT_CODE_PROPERTY,
	SKK_KEY_EVENT_MODIFIERS_PROPERTY,
	SKK_KEY_EVENT_NUM_PROPERTIES
};
static GParamSpec* skk_key_event_properties[SKK_KEY_EVENT_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))

#define SKK_KEY_EVENT_TYPE_CODE_KEYVAL_ENTRY (skk_key_event_code_keyval_entry_get_type ())
typedef struct _SkkKeyEventCodeKeyvalEntry SkkKeyEventCodeKeyvalEntry;

#define SKK_KEY_EVENT_TYPE_NAME_KEYVAL_ENTRY (skk_key_event_name_keyval_entry_get_type ())
typedef struct _SkkKeyEventNameKeyvalEntry SkkKeyEventNameKeyvalEntry;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

typedef enum  {
	SKK_KEY_EVENT_FORMAT_ERROR_PARSE_FAILED,
	SKK_KEY_EVENT_FORMAT_ERROR_KEYSYM_NOT_FOUND
} SkkKeyEventFormatError;
#define SKK_KEY_EVENT_FORMAT_ERROR skk_key_event_format_error_quark ()
typedef enum  {
	SKK_MODIFIER_TYPE_NONE = 0,
	SKK_MODIFIER_TYPE_SHIFT_MASK = 1 << 0,
	SKK_MODIFIER_TYPE_LOCK_MASK = 1 << 1,
	SKK_MODIFIER_TYPE_CONTROL_MASK = 1 << 2,
	SKK_MODIFIER_TYPE_MOD1_MASK = 1 << 3,
	SKK_MODIFIER_TYPE_MOD2_MASK = 1 << 4,
	SKK_MODIFIER_TYPE_MOD3_MASK = 1 << 5,
	SKK_MODIFIER_TYPE_MOD4_MASK = 1 << 6,
	SKK_MODIFIER_TYPE_MOD5_MASK = 1 << 7,
	SKK_MODIFIER_TYPE_LSHIFT_MASK = 1 << 22,
	SKK_MODIFIER_TYPE_RSHIFT_MASK = 1 << 23,
	SKK_MODIFIER_TYPE_USLEEP_MASK = 1 << 24,
	SKK_MODIFIER_TYPE_SUPER_MASK = 1 << 26,
	SKK_MODIFIER_TYPE_HYPER_MASK = 1 << 27,
	SKK_MODIFIER_TYPE_META_MASK = 1 << 28,
	SKK_MODIFIER_TYPE_RELEASE_MASK = 1 << 30
} SkkModifierType;

struct _SkkKeyEvent {
	GObject parent_instance;
	SkkKeyEventPrivate * priv;
};

struct _SkkKeyEventClass {
	GObjectClass parent_class;
};

struct _SkkKeyEventPrivate {
	gchar* _name;
	gunichar _code;
	SkkModifierType _modifiers;
};

struct _SkkKeyEventCodeKeyvalEntry {
	guint key;
	gunichar value;
};

struct _SkkKeyEventNameKeyvalEntry {
	guint key;
	gchar* value;
};


static gpointer skk_key_event_parent_class = NULL;

GQuark skk_key_event_format_error_quark (void);
GType skk_modifier_type_get_type (void) G_GNUC_CONST;
GType skk_key_event_get_type (void) G_GNUC_CONST;
#define SKK_KEY_EVENT_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), SKK_TYPE_KEY_EVENT, SkkKeyEventPrivate))
static GType skk_key_event_code_keyval_entry_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static SkkKeyEventCodeKeyvalEntry* skk_key_event_code_keyval_entry_dup (const SkkKeyEventCodeKeyvalEntry* self);
static void skk_key_event_code_keyval_entry_free (SkkKeyEventCodeKeyvalEntry* self);
#define SKK_KEYSYMS_Tab ((guint) 0xff09)
#define SKK_KEYSYMS_Return ((guint) 0xff0d)
#define SKK_KEYSYMS_BackSpace ((guint) 0xff08)
static GType skk_key_event_name_keyval_entry_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static SkkKeyEventNameKeyvalEntry* skk_key_event_name_keyval_entry_dup (const SkkKeyEventNameKeyvalEntry* self);
static void skk_key_event_name_keyval_entry_free (SkkKeyEventNameKeyvalEntry* self);
static void skk_key_event_name_keyval_entry_copy (const SkkKeyEventNameKeyvalEntry* self, SkkKeyEventNameKeyvalEntry* dest);
static void skk_key_event_name_keyval_entry_destroy (SkkKeyEventNameKeyvalEntry* self);
#define SKK_KEYSYMS_Up ((guint) 0xff52)
#define SKK_KEYSYMS_Down ((guint) 0xff54)
#define SKK_KEYSYMS_Left ((guint) 0xff51)
#define SKK_KEYSYMS_Right ((guint) 0xff53)
#define SKK_KEYSYMS_Page_Up ((guint) 0xff55)
#define SKK_KEYSYMS_KP_Page_Up ((guint) 0xff9a)
#define SKK_KEYSYMS_Page_Down ((guint) 0xff56)
#define SKK_KEYSYMS_KP_Page_Down ((guint) 0xff9b)
#define SKK_KEYSYMS_Muhenkan ((guint) 0xff22)
#define SKK_KEYSYMS_Henkan ((guint) 0xff23)
SkkKeyEvent* skk_key_event_new (const gchar* name, gunichar code, SkkModifierType modifiers);
SkkKeyEvent* skk_key_event_construct (GType object_type, const gchar* name, gunichar code, SkkModifierType modifiers);
static void skk_key_event_set_name (SkkKeyEvent* self, const gchar* value);
static void skk_key_event_set_code (SkkKeyEvent* self, gunichar value);
void skk_key_event_set_modifiers (SkkKeyEvent* self, SkkModifierType value);
SkkKeyEvent* skk_key_event_copy (SkkKeyEvent* self);
const gchar* skk_key_event_get_name (SkkKeyEvent* self);
gunichar skk_key_event_get_code (SkkKeyEvent* self);
SkkModifierType skk_key_event_get_modifiers (SkkKeyEvent* self);
SkkKeyEvent* skk_key_event_new_from_string (const gchar* key, GError** error);
SkkKeyEvent* skk_key_event_construct_from_string (GType object_type, const gchar* key, GError** error);
gchar* skk_key_event_to_string (SkkKeyEvent* self);
SkkKeyEvent* skk_key_event_new_from_x_keysym (guint keyval, SkkModifierType modifiers, GError** error);
SkkKeyEvent* skk_key_event_construct_from_x_keysym (GType object_type, guint keyval, SkkModifierType modifiers, GError** error);
gboolean skk_key_event_base_equal (SkkKeyEvent* self, SkkKeyEvent* key);
static void skk_key_event_finalize (GObject * obj);
static void _vala_skk_key_event_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_skk_key_event_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);

static const SkkKeyEventCodeKeyvalEntry SKK_KEY_EVENT_CODE_KEYVALS[3] = {{SKK_KEYSYMS_Tab, (gunichar) '\t'}, {SKK_KEYSYMS_Return, (gunichar) '\n'}, {SKK_KEYSYMS_BackSpace, (gunichar) '\b'}};
static const SkkKeyEventNameKeyvalEntry SKK_KEY_EVENT_NAME_KEYVALS[10] = {{SKK_KEYSYMS_Up, "Up"}, {SKK_KEYSYMS_Down, "Down"}, {SKK_KEYSYMS_Left, "Left"}, {SKK_KEYSYMS_Right, "Right"}, {SKK_KEYSYMS_Page_Up, "Page_Up"}, {SKK_KEYSYMS_KP_Page_Up, "Page_Up"}, {SKK_KEYSYMS_Page_Down, "Page_Down"}, {SKK_KEYSYMS_KP_Page_Down, "Page_Down"}, {SKK_KEYSYMS_Muhenkan, "lshift"}, {SKK_KEYSYMS_Henkan, "rshift"}};

GQuark skk_key_event_format_error_quark (void) {
	return g_quark_from_static_string ("skk_key_event_format_error-quark");
}


/**
     * A set of bit-flags to indicate the state of modifier keys.
     */
GType skk_modifier_type_get_type (void) {
	static volatile gsize skk_modifier_type_type_id__volatile = 0;
	if (g_once_init_enter (&skk_modifier_type_type_id__volatile)) {
		static const GFlagsValue values[] = {{SKK_MODIFIER_TYPE_NONE, "SKK_MODIFIER_TYPE_NONE", "none"}, {SKK_MODIFIER_TYPE_SHIFT_MASK, "SKK_MODIFIER_TYPE_SHIFT_MASK", "shift-mask"}, {SKK_MODIFIER_TYPE_LOCK_MASK, "SKK_MODIFIER_TYPE_LOCK_MASK", "lock-mask"}, {SKK_MODIFIER_TYPE_CONTROL_MASK, "SKK_MODIFIER_TYPE_CONTROL_MASK", "control-mask"}, {SKK_MODIFIER_TYPE_MOD1_MASK, "SKK_MODIFIER_TYPE_MOD1_MASK", "mod1-mask"}, {SKK_MODIFIER_TYPE_MOD2_MASK, "SKK_MODIFIER_TYPE_MOD2_MASK", "mod2-mask"}, {SKK_MODIFIER_TYPE_MOD3_MASK, "SKK_MODIFIER_TYPE_MOD3_MASK", "mod3-mask"}, {SKK_MODIFIER_TYPE_MOD4_MASK, "SKK_MODIFIER_TYPE_MOD4_MASK", "mod4-mask"}, {SKK_MODIFIER_TYPE_MOD5_MASK, "SKK_MODIFIER_TYPE_MOD5_MASK", "mod5-mask"}, {SKK_MODIFIER_TYPE_LSHIFT_MASK, "SKK_MODIFIER_TYPE_LSHIFT_MASK", "lshift-mask"}, {SKK_MODIFIER_TYPE_RSHIFT_MASK, "SKK_MODIFIER_TYPE_RSHIFT_MASK", "rshift-mask"}, {SKK_MODIFIER_TYPE_USLEEP_MASK, "SKK_MODIFIER_TYPE_USLEEP_MASK", "usleep-mask"}, {SKK_MODIFIER_TYPE_SUPER_MASK, "SKK_MODIFIER_TYPE_SUPER_MASK", "super-mask"}, {SKK_MODIFIER_TYPE_HYPER_MASK, "SKK_MODIFIER_TYPE_HYPER_MASK", "hyper-mask"}, {SKK_MODIFIER_TYPE_META_MASK, "SKK_MODIFIER_TYPE_META_MASK", "meta-mask"}, {SKK_MODIFIER_TYPE_RELEASE_MASK, "SKK_MODIFIER_TYPE_RELEASE_MASK", "release-mask"}, {0, NULL, NULL}};
		GType skk_modifier_type_type_id;
		skk_modifier_type_type_id = g_flags_register_static ("SkkModifierType", values);
		g_once_init_leave (&skk_modifier_type_type_id__volatile, skk_modifier_type_type_id);
	}
	return skk_modifier_type_type_id__volatile;
}


/**
         * Create a key event.
         *
         * @param name a key name
         * @param code a character code
         * @param modifiers state of modifier keys
         *
         * @return a new KeyEvent
         */
SkkKeyEvent* skk_key_event_construct (GType object_type, const gchar* name, gunichar code, SkkModifierType modifiers) {
	SkkKeyEvent * self = NULL;
	const gchar* _tmp0_;
	gunichar _tmp1_;
	SkkModifierType _tmp2_;
	self = (SkkKeyEvent*) g_object_new (object_type, NULL);
	_tmp0_ = name;
	skk_key_event_set_name (self, _tmp0_);
	_tmp1_ = code;
	skk_key_event_set_code (self, _tmp1_);
	_tmp2_ = modifiers;
	skk_key_event_set_modifiers (self, _tmp2_);
	return self;
}


SkkKeyEvent* skk_key_event_new (const gchar* name, gunichar code, SkkModifierType modifiers) {
	return skk_key_event_construct (SKK_TYPE_KEY_EVENT, name, code, modifiers);
}


/**
         * Create a copy of the key event.
         *
         * @return a new KeyEvent
         */
SkkKeyEvent* skk_key_event_copy (SkkKeyEvent* self) {
	SkkKeyEvent* result = NULL;
	const gchar* _tmp0_;
	gunichar _tmp1_;
	SkkModifierType _tmp2_;
	SkkKeyEvent* _tmp3_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_name;
	_tmp1_ = self->priv->_code;
	_tmp2_ = self->priv->_modifiers;
	_tmp3_ = skk_key_event_new (_tmp0_, _tmp1_, _tmp2_);
	result = _tmp3_;
	return result;
}


/**
         * Create a key event from string.
         *
         * @param key a string representation of a key event
         *
         * @return a new KeyEvent
         */
static gchar* string_slice (const gchar* self, glong start, glong end) {
	gchar* result = NULL;
	glong string_length = 0L;
	gint _tmp0_;
	gint _tmp1_;
	glong _tmp2_;
	glong _tmp5_;
	gboolean _tmp8_ = FALSE;
	glong _tmp9_;
	gboolean _tmp12_ = FALSE;
	glong _tmp13_;
	glong _tmp16_;
	glong _tmp17_;
	glong _tmp18_;
	glong _tmp19_;
	glong _tmp20_;
	gchar* _tmp21_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	string_length = (glong) _tmp1_;
	_tmp2_ = start;
	if (_tmp2_ < ((glong) 0)) {
		glong _tmp3_;
		glong _tmp4_;
		_tmp3_ = string_length;
		_tmp4_ = start;
		start = _tmp3_ + _tmp4_;
	}
	_tmp5_ = end;
	if (_tmp5_ < ((glong) 0)) {
		glong _tmp6_;
		glong _tmp7_;
		_tmp6_ = string_length;
		_tmp7_ = end;
		end = _tmp6_ + _tmp7_;
	}
	_tmp9_ = start;
	if (_tmp9_ >= ((glong) 0)) {
		glong _tmp10_;
		glong _tmp11_;
		_tmp10_ = start;
		_tmp11_ = string_length;
		_tmp8_ = _tmp10_ <= _tmp11_;
	} else {
		_tmp8_ = FALSE;
	}
	g_return_val_if_fail (_tmp8_, NULL);
	_tmp13_ = end;
	if (_tmp13_ >= ((glong) 0)) {
		glong _tmp14_;
		glong _tmp15_;
		_tmp14_ = end;
		_tmp15_ = string_length;
		_tmp12_ = _tmp14_ <= _tmp15_;
	} else {
		_tmp12_ = FALSE;
	}
	g_return_val_if_fail (_tmp12_, NULL);
	_tmp16_ = start;
	_tmp17_ = end;
	g_return_val_if_fail (_tmp16_ <= _tmp17_, NULL);
	_tmp18_ = start;
	_tmp19_ = end;
	_tmp20_ = start;
	_tmp21_ = g_strndup (((gchar*) self) + _tmp18_, (gsize) (_tmp19_ - _tmp20_));
	result = _tmp21_;
	return result;
}


static gunichar string_get_char (const gchar* self, glong index) {
	gunichar result = 0U;
	glong _tmp0_;
	gunichar _tmp1_;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = index;
	_tmp1_ = g_utf8_get_char (((gchar*) self) + _tmp0_);
	result = _tmp1_;
	return result;
}


static gint string_last_index_of (const gchar* self, const gchar* needle, gint start_index) {
	gint result = 0;
	gchar* _result_ = NULL;
	gint _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (needle != NULL, 0);
	_tmp0_ = start_index;
	_tmp1_ = needle;
	_tmp2_ = g_strrstr (((gchar*) self) + _tmp0_, (gchar*) _tmp1_);
	_result_ = _tmp2_;
	_tmp3_ = _result_;
	if (_tmp3_ != NULL) {
		gchar* _tmp4_;
		_tmp4_ = _result_;
		result = (gint) (_tmp4_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}


static glong string_strnlen (gchar* str, glong maxlen) {
	glong result = 0L;
	gchar* end = NULL;
	gchar* _tmp0_;
	glong _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	_tmp0_ = str;
	_tmp1_ = maxlen;
	_tmp2_ = memchr (_tmp0_, 0, (gsize) _tmp1_);
	end = _tmp2_;
	_tmp3_ = end;
	if (_tmp3_ == NULL) {
		glong _tmp4_;
		_tmp4_ = maxlen;
		result = _tmp4_;
		return result;
	} else {
		gchar* _tmp5_;
		gchar* _tmp6_;
		_tmp5_ = end;
		_tmp6_ = str;
		result = (glong) (_tmp5_ - _tmp6_);
		return result;
	}
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp1_;
	glong _tmp8_;
	glong _tmp14_;
	glong _tmp17_;
	glong _tmp18_;
	glong _tmp19_;
	glong _tmp20_;
	glong _tmp21_;
	gchar* _tmp22_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = offset;
	if (_tmp1_ >= ((glong) 0)) {
		glong _tmp2_;
		_tmp2_ = len;
		_tmp0_ = _tmp2_ >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		glong _tmp3_;
		glong _tmp4_;
		glong _tmp5_;
		_tmp3_ = offset;
		_tmp4_ = len;
		_tmp5_ = string_strnlen ((gchar*) self, _tmp3_ + _tmp4_);
		string_length = _tmp5_;
	} else {
		gint _tmp6_;
		gint _tmp7_;
		_tmp6_ = strlen (self);
		_tmp7_ = _tmp6_;
		string_length = (glong) _tmp7_;
	}
	_tmp8_ = offset;
	if (_tmp8_ < ((glong) 0)) {
		glong _tmp9_;
		glong _tmp10_;
		glong _tmp11_;
		_tmp9_ = string_length;
		_tmp10_ = offset;
		offset = _tmp9_ + _tmp10_;
		_tmp11_ = offset;
		g_return_val_if_fail (_tmp11_ >= ((glong) 0), NULL);
	} else {
		glong _tmp12_;
		glong _tmp13_;
		_tmp12_ = offset;
		_tmp13_ = string_length;
		g_return_val_if_fail (_tmp12_ <= _tmp13_, NULL);
	}
	_tmp14_ = len;
	if (_tmp14_ < ((glong) 0)) {
		glong _tmp15_;
		glong _tmp16_;
		_tmp15_ = string_length;
		_tmp16_ = offset;
		len = _tmp15_ - _tmp16_;
	}
	_tmp17_ = offset;
	_tmp18_ = len;
	_tmp19_ = string_length;
	g_return_val_if_fail ((_tmp17_ + _tmp18_) <= _tmp19_, NULL);
	_tmp20_ = offset;
	_tmp21_ = len;
	_tmp22_ = g_strndup (((gchar*) self) + _tmp20_, (gsize) _tmp21_);
	result = _tmp22_;
	return result;
}


SkkKeyEvent* skk_key_event_construct_from_string (GType object_type, const gchar* key, GError** error) {
	SkkKeyEvent * self = NULL;
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_;
	gboolean _tmp2_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (key != NULL, NULL);
	self = (SkkKeyEvent*) g_object_new (object_type, NULL);
	_tmp1_ = key;
	_tmp2_ = g_str_has_prefix (_tmp1_, "(");
	if (_tmp2_) {
		const gchar* _tmp3_;
		gboolean _tmp4_;
		_tmp3_ = key;
		_tmp4_ = g_str_has_suffix (_tmp3_, ")");
		_tmp0_ = _tmp4_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gchar** strv = NULL;
		const gchar* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		gchar** _tmp8_;
		gchar** _tmp9_;
		gchar** _tmp10_;
		gint _tmp10__length1;
		gint strv_length1;
		gint _strv_size_;
		gint index = 0;
		gchar** _tmp55_;
		gint _tmp55__length1;
		gint _tmp56_;
		const gchar* _tmp57_;
		gunichar _tmp58_ = 0U;
		const gchar* _tmp59_;
		gint _tmp60_;
		_tmp5_ = key;
		_tmp6_ = string_slice (_tmp5_, (glong) 1, (glong) -1);
		_tmp7_ = _tmp6_;
		_tmp9_ = _tmp8_ = g_strsplit (_tmp7_, " ", 0);
		_tmp10_ = _tmp9_;
		_tmp10__length1 = _vala_array_length (_tmp8_);
		_g_free0 (_tmp7_);
		strv = _tmp10_;
		strv_length1 = _tmp10__length1;
		_strv_size_ = strv_length1;
		index = 0;
		{
			gboolean _tmp11_ = FALSE;
			_tmp11_ = TRUE;
			while (TRUE) {
				gint _tmp13_;
				gchar** _tmp14_;
				gint _tmp14__length1;
				gchar** _tmp15_;
				gint _tmp15__length1;
				gint _tmp16_;
				const gchar* _tmp17_;
				if (!_tmp11_) {
					gint _tmp12_;
					_tmp12_ = index;
					index = _tmp12_ + 1;
				}
				_tmp11_ = FALSE;
				_tmp13_ = index;
				_tmp14_ = strv;
				_tmp14__length1 = strv_length1;
				if (!(_tmp13_ < (_tmp14__length1 - 1))) {
					break;
				}
				_tmp15_ = strv;
				_tmp15__length1 = strv_length1;
				_tmp16_ = index;
				_tmp17_ = _tmp15_[_tmp16_];
				if (g_strcmp0 (_tmp17_, "control") == 0) {
					SkkModifierType _tmp18_;
					_tmp18_ = self->priv->_modifiers;
					skk_key_event_set_modifiers (self, _tmp18_ | SKK_MODIFIER_TYPE_CONTROL_MASK);
				} else {
					gchar** _tmp19_;
					gint _tmp19__length1;
					gint _tmp20_;
					const gchar* _tmp21_;
					_tmp19_ = strv;
					_tmp19__length1 = strv_length1;
					_tmp20_ = index;
					_tmp21_ = _tmp19_[_tmp20_];
					if (g_strcmp0 (_tmp21_, "meta") == 0) {
						SkkModifierType _tmp22_;
						_tmp22_ = self->priv->_modifiers;
						skk_key_event_set_modifiers (self, _tmp22_ | SKK_MODIFIER_TYPE_META_MASK);
					} else {
						gchar** _tmp23_;
						gint _tmp23__length1;
						gint _tmp24_;
						const gchar* _tmp25_;
						_tmp23_ = strv;
						_tmp23__length1 = strv_length1;
						_tmp24_ = index;
						_tmp25_ = _tmp23_[_tmp24_];
						if (g_strcmp0 (_tmp25_, "hyper") == 0) {
							SkkModifierType _tmp26_;
							_tmp26_ = self->priv->_modifiers;
							skk_key_event_set_modifiers (self, _tmp26_ | SKK_MODIFIER_TYPE_HYPER_MASK);
						} else {
							gchar** _tmp27_;
							gint _tmp27__length1;
							gint _tmp28_;
							const gchar* _tmp29_;
							_tmp27_ = strv;
							_tmp27__length1 = strv_length1;
							_tmp28_ = index;
							_tmp29_ = _tmp27_[_tmp28_];
							if (g_strcmp0 (_tmp29_, "super") == 0) {
								SkkModifierType _tmp30_;
								_tmp30_ = self->priv->_modifiers;
								skk_key_event_set_modifiers (self, _tmp30_ | SKK_MODIFIER_TYPE_SUPER_MASK);
							} else {
								gchar** _tmp31_;
								gint _tmp31__length1;
								gint _tmp32_;
								const gchar* _tmp33_;
								_tmp31_ = strv;
								_tmp31__length1 = strv_length1;
								_tmp32_ = index;
								_tmp33_ = _tmp31_[_tmp32_];
								if (g_strcmp0 (_tmp33_, "alt") == 0) {
									SkkModifierType _tmp34_;
									_tmp34_ = self->priv->_modifiers;
									skk_key_event_set_modifiers (self, _tmp34_ | SKK_MODIFIER_TYPE_MOD1_MASK);
								} else {
									gchar** _tmp35_;
									gint _tmp35__length1;
									gint _tmp36_;
									const gchar* _tmp37_;
									_tmp35_ = strv;
									_tmp35__length1 = strv_length1;
									_tmp36_ = index;
									_tmp37_ = _tmp35_[_tmp36_];
									if (g_strcmp0 (_tmp37_, "lshift") == 0) {
										SkkModifierType _tmp38_;
										_tmp38_ = self->priv->_modifiers;
										skk_key_event_set_modifiers (self, _tmp38_ | SKK_MODIFIER_TYPE_LSHIFT_MASK);
									} else {
										gchar** _tmp39_;
										gint _tmp39__length1;
										gint _tmp40_;
										const gchar* _tmp41_;
										_tmp39_ = strv;
										_tmp39__length1 = strv_length1;
										_tmp40_ = index;
										_tmp41_ = _tmp39_[_tmp40_];
										if (g_strcmp0 (_tmp41_, "rshift") == 0) {
											SkkModifierType _tmp42_;
											_tmp42_ = self->priv->_modifiers;
											skk_key_event_set_modifiers (self, _tmp42_ | SKK_MODIFIER_TYPE_RSHIFT_MASK);
										} else {
											gchar** _tmp43_;
											gint _tmp43__length1;
											gint _tmp44_;
											const gchar* _tmp45_;
											_tmp43_ = strv;
											_tmp43__length1 = strv_length1;
											_tmp44_ = index;
											_tmp45_ = _tmp43_[_tmp44_];
											if (g_strcmp0 (_tmp45_, "usleep") == 0) {
												SkkModifierType _tmp46_;
												_tmp46_ = self->priv->_modifiers;
												skk_key_event_set_modifiers (self, _tmp46_ | SKK_MODIFIER_TYPE_USLEEP_MASK);
											} else {
												gchar** _tmp47_;
												gint _tmp47__length1;
												gint _tmp48_;
												const gchar* _tmp49_;
												_tmp47_ = strv;
												_tmp47__length1 = strv_length1;
												_tmp48_ = index;
												_tmp49_ = _tmp47_[_tmp48_];
												if (g_strcmp0 (_tmp49_, "release") == 0) {
													SkkModifierType _tmp50_;
													_tmp50_ = self->priv->_modifiers;
													skk_key_event_set_modifiers (self, _tmp50_ | SKK_MODIFIER_TYPE_RELEASE_MASK);
												} else {
													gchar** _tmp51_;
													gint _tmp51__length1;
													gint _tmp52_;
													const gchar* _tmp53_;
													GError* _tmp54_;
													_tmp51_ = strv;
													_tmp51__length1 = strv_length1;
													_tmp52_ = index;
													_tmp53_ = _tmp51_[_tmp52_];
													_tmp54_ = g_error_new (SKK_KEY_EVENT_FORMAT_ERROR, SKK_KEY_EVENT_FORMAT_ERROR_PARSE_FAILED, "unknown modifier %s", _tmp53_);
													_inner_error_ = _tmp54_;
													if (_inner_error_->domain == SKK_KEY_EVENT_FORMAT_ERROR) {
														g_propagate_error (error, _inner_error_);
														strv = (_vala_array_free (strv, strv_length1, (GDestroyNotify) g_free), NULL);
														_g_object_unref0 (self);
														return NULL;
													} else {
														strv = (_vala_array_free (strv, strv_length1, (GDestroyNotify) g_free), NULL);
														g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
														g_clear_error (&_inner_error_);
														return NULL;
													}
												}
											}
										}
									}
								}
							}
						}
					}
				}
			}
		}
		_tmp55_ = strv;
		_tmp55__length1 = strv_length1;
		_tmp56_ = index;
		_tmp57_ = _tmp55_[_tmp56_];
		skk_key_event_set_name (self, _tmp57_);
		_tmp59_ = self->priv->_name;
		_tmp60_ = g_utf8_strlen (_tmp59_, (gssize) -1);
		if (_tmp60_ == 1) {
			const gchar* _tmp61_;
			gunichar _tmp62_;
			_tmp61_ = self->priv->_name;
			_tmp62_ = string_get_char (_tmp61_, (glong) 0);
			_tmp58_ = _tmp62_;
		} else {
			_tmp58_ = (gunichar) '\0';
		}
		skk_key_event_set_code (self, _tmp58_);
		strv = (_vala_array_free (strv, strv_length1, (GDestroyNotify) g_free), NULL);
	} else {
		gint index = 0;
		const gchar* _tmp63_;
		gint _tmp64_;
		gint _tmp65_;
		_tmp63_ = key;
		_tmp64_ = string_last_index_of (_tmp63_, "-", 0);
		index = _tmp64_;
		_tmp65_ = index;
		if (_tmp65_ > 0) {
			gchar** mods = NULL;
			const gchar* _tmp66_;
			gint _tmp67_;
			gchar* _tmp68_;
			gchar* _tmp69_;
			gchar** _tmp70_;
			gchar** _tmp71_;
			gchar** _tmp72_;
			gint _tmp72__length1;
			gint mods_length1;
			gint _mods_size_;
			gchar** _tmp73_;
			gint _tmp73__length1;
			const gchar* _tmp83_;
			gint _tmp84_;
			gchar* _tmp85_;
			gchar* _tmp86_;
			gunichar _tmp87_ = 0U;
			const gchar* _tmp88_;
			gint _tmp89_;
			_tmp66_ = key;
			_tmp67_ = index;
			_tmp68_ = string_substring (_tmp66_, (glong) 0, (glong) _tmp67_);
			_tmp69_ = _tmp68_;
			_tmp71_ = _tmp70_ = g_strsplit (_tmp69_, "-", 0);
			_tmp72_ = _tmp71_;
			_tmp72__length1 = _vala_array_length (_tmp70_);
			_g_free0 (_tmp69_);
			mods = _tmp72_;
			mods_length1 = _tmp72__length1;
			_mods_size_ = mods_length1;
			_tmp73_ = mods;
			_tmp73__length1 = mods_length1;
			{
				gchar** mod_collection = NULL;
				gint mod_collection_length1 = 0;
				gint _mod_collection_size_ = 0;
				gint mod_it = 0;
				mod_collection = _tmp73_;
				mod_collection_length1 = _tmp73__length1;
				for (mod_it = 0; mod_it < _tmp73__length1; mod_it = mod_it + 1) {
					gchar* _tmp74_;
					gchar* mod = NULL;
					_tmp74_ = g_strdup (mod_collection[mod_it]);
					mod = _tmp74_;
					{
						const gchar* _tmp75_;
						_tmp75_ = mod;
						if (g_strcmp0 (_tmp75_, "C") == 0) {
							SkkModifierType _tmp76_;
							_tmp76_ = self->priv->_modifiers;
							skk_key_event_set_modifiers (self, _tmp76_ | SKK_MODIFIER_TYPE_CONTROL_MASK);
						} else {
							const gchar* _tmp77_;
							_tmp77_ = mod;
							if (g_strcmp0 (_tmp77_, "A") == 0) {
								SkkModifierType _tmp78_;
								_tmp78_ = self->priv->_modifiers;
								skk_key_event_set_modifiers (self, _tmp78_ | SKK_MODIFIER_TYPE_MOD1_MASK);
							} else {
								const gchar* _tmp79_;
								_tmp79_ = mod;
								if (g_strcmp0 (_tmp79_, "M") == 0) {
									SkkModifierType _tmp80_;
									_tmp80_ = self->priv->_modifiers;
									skk_key_event_set_modifiers (self, _tmp80_ | SKK_MODIFIER_TYPE_META_MASK);
								} else {
									const gchar* _tmp81_;
									_tmp81_ = mod;
									if (g_strcmp0 (_tmp81_, "G") == 0) {
										SkkModifierType _tmp82_;
										_tmp82_ = self->priv->_modifiers;
										skk_key_event_set_modifiers (self, _tmp82_ | SKK_MODIFIER_TYPE_MOD5_MASK);
									}
								}
							}
						}
						_g_free0 (mod);
					}
				}
			}
			_tmp83_ = key;
			_tmp84_ = index;
			_tmp85_ = string_substring (_tmp83_, (glong) (_tmp84_ + 1), (glong) -1);
			_tmp86_ = _tmp85_;
			skk_key_event_set_name (self, _tmp86_);
			_g_free0 (_tmp86_);
			_tmp88_ = self->priv->_name;
			_tmp89_ = g_utf8_strlen (_tmp88_, (gssize) -1);
			if (_tmp89_ == 1) {
				const gchar* _tmp90_;
				gunichar _tmp91_;
				_tmp90_ = self->priv->_name;
				_tmp91_ = string_get_char (_tmp90_, (glong) 0);
				_tmp87_ = _tmp91_;
			} else {
				_tmp87_ = (gunichar) '\0';
			}
			skk_key_event_set_code (self, _tmp87_);
			mods = (_vala_array_free (mods, mods_length1, (GDestroyNotify) g_free), NULL);
		} else {
			const gchar* _tmp92_;
			gunichar _tmp93_ = 0U;
			const gchar* _tmp94_;
			gint _tmp95_;
			skk_key_event_set_modifiers (self, SKK_MODIFIER_TYPE_NONE);
			_tmp92_ = key;
			skk_key_event_set_name (self, _tmp92_);
			_tmp94_ = self->priv->_name;
			_tmp95_ = g_utf8_strlen (_tmp94_, (gssize) -1);
			if (_tmp95_ == 1) {
				const gchar* _tmp96_;
				gunichar _tmp97_;
				_tmp96_ = self->priv->_name;
				_tmp97_ = string_get_char (_tmp96_, (glong) 0);
				_tmp93_ = _tmp97_;
			} else {
				_tmp93_ = (gunichar) '\0';
			}
			skk_key_event_set_code (self, _tmp93_);
		}
	}
	return self;
}


SkkKeyEvent* skk_key_event_new_from_string (const gchar* key, GError** error) {
	return skk_key_event_construct_from_string (SKK_TYPE_KEY_EVENT, key, error);
}


/**
         * Convert the KeyEvent to string.
         *
         * @return a string representing the KeyEvent
         */
static gchar* g_unichar_to_string (gunichar self) {
	gchar* result = NULL;
	gchar* str = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	_tmp0_ = g_new0 (gchar, 7);
	str = (gchar*) _tmp0_;
	_tmp1_ = str;
	g_unichar_to_utf8 (self, _tmp1_);
	result = str;
	return result;
}


static gchar* _vala_g_strjoinv (const gchar* separator, gchar** str_array, int str_array_length1) {
	gchar* result = NULL;
	const gchar* _tmp0_;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gchar** _tmp3_;
	gint _tmp3__length1;
	_tmp0_ = separator;
	if (_tmp0_ == NULL) {
		separator = "";
	}
	_tmp3_ = str_array;
	_tmp3__length1 = str_array_length1;
	if (_tmp3_ != NULL) {
		_tmp2_ = TRUE;
	} else {
		gchar** _tmp4_;
		gint _tmp4__length1;
		_tmp4_ = str_array;
		_tmp4__length1 = str_array_length1;
		_tmp2_ = _tmp4__length1 > 0;
	}
	if (_tmp2_) {
		_tmp1_ = TRUE;
	} else {
		gboolean _tmp5_ = FALSE;
		gchar** _tmp6_;
		gint _tmp6__length1;
		_tmp6_ = str_array;
		_tmp6__length1 = str_array_length1;
		if (_tmp6__length1 == -1) {
			gchar** _tmp7_;
			gint _tmp7__length1;
			const gchar* _tmp8_;
			_tmp7_ = str_array;
			_tmp7__length1 = str_array_length1;
			_tmp8_ = _tmp7_[0];
			_tmp5_ = _tmp8_ != NULL;
		} else {
			_tmp5_ = FALSE;
		}
		_tmp1_ = _tmp5_;
	}
	if (_tmp1_) {
		gint i = 0;
		gsize len = 0UL;
		gint _tmp31_;
		gint _tmp33_;
		gint _tmp34_;
		gsize _tmp35_;
		const gchar* _tmp36_;
		gint _tmp37_;
		gint _tmp38_;
		gint _tmp39_;
		const gchar* res = NULL;
		gsize _tmp40_;
		void* _tmp41_;
		void* ptr = NULL;
		const gchar* _tmp42_;
		gchar** _tmp43_;
		gint _tmp43__length1;
		const gchar* _tmp44_;
		void* _tmp45_;
		const gchar* _tmp62_;
		len = (gsize) 1;
		{
			gboolean _tmp9_ = FALSE;
			i = 0;
			_tmp9_ = TRUE;
			while (TRUE) {
				gboolean _tmp11_ = FALSE;
				gboolean _tmp12_ = FALSE;
				gchar** _tmp13_;
				gint _tmp13__length1;
				gint _tmp21_ = 0;
				gchar** _tmp22_;
				gint _tmp22__length1;
				gint _tmp23_;
				const gchar* _tmp24_;
				gsize _tmp30_;
				if (!_tmp9_) {
					gint _tmp10_;
					_tmp10_ = i;
					i = _tmp10_ + 1;
				}
				_tmp9_ = FALSE;
				_tmp13_ = str_array;
				_tmp13__length1 = str_array_length1;
				if (_tmp13__length1 != -1) {
					gint _tmp14_;
					gchar** _tmp15_;
					gint _tmp15__length1;
					_tmp14_ = i;
					_tmp15_ = str_array;
					_tmp15__length1 = str_array_length1;
					_tmp12_ = _tmp14_ < _tmp15__length1;
				} else {
					_tmp12_ = FALSE;
				}
				if (_tmp12_) {
					_tmp11_ = TRUE;
				} else {
					gboolean _tmp16_ = FALSE;
					gchar** _tmp17_;
					gint _tmp17__length1;
					_tmp17_ = str_array;
					_tmp17__length1 = str_array_length1;
					if (_tmp17__length1 == -1) {
						gchar** _tmp18_;
						gint _tmp18__length1;
						gint _tmp19_;
						const gchar* _tmp20_;
						_tmp18_ = str_array;
						_tmp18__length1 = str_array_length1;
						_tmp19_ = i;
						_tmp20_ = _tmp18_[_tmp19_];
						_tmp16_ = _tmp20_ != NULL;
					} else {
						_tmp16_ = FALSE;
					}
					_tmp11_ = _tmp16_;
				}
				if (!_tmp11_) {
					break;
				}
				_tmp22_ = str_array;
				_tmp22__length1 = str_array_length1;
				_tmp23_ = i;
				_tmp24_ = _tmp22_[_tmp23_];
				if (_tmp24_ != NULL) {
					gchar** _tmp25_;
					gint _tmp25__length1;
					gint _tmp26_;
					const gchar* _tmp27_;
					gint _tmp28_;
					gint _tmp29_;
					_tmp25_ = str_array;
					_tmp25__length1 = str_array_length1;
					_tmp26_ = i;
					_tmp27_ = _tmp25_[_tmp26_];
					_tmp28_ = strlen ((const gchar*) _tmp27_);
					_tmp29_ = _tmp28_;
					_tmp21_ = _tmp29_;
				} else {
					_tmp21_ = 0;
				}
				_tmp30_ = len;
				len = _tmp30_ + _tmp21_;
			}
		}
		_tmp31_ = i;
		if (_tmp31_ == 0) {
			gchar* _tmp32_;
			_tmp32_ = g_strdup ("");
			result = _tmp32_;
			return result;
		}
		_tmp33_ = i;
		str_array_length1 = _tmp33_;
		_tmp34_ = str_array_length1;
		_tmp35_ = len;
		_tmp36_ = separator;
		_tmp37_ = strlen ((const gchar*) _tmp36_);
		_tmp38_ = _tmp37_;
		_tmp39_ = i;
		len = _tmp35_ + (_tmp38_ * (_tmp39_ - 1));
		_tmp40_ = len;
		_tmp41_ = g_malloc (_tmp40_);
		res = _tmp41_;
		_tmp42_ = res;
		_tmp43_ = str_array;
		_tmp43__length1 = str_array_length1;
		_tmp44_ = _tmp43_[0];
		_tmp45_ = g_stpcpy ((void*) _tmp42_, (const gchar*) _tmp44_);
		ptr = _tmp45_;
		{
			gboolean _tmp46_ = FALSE;
			i = 1;
			_tmp46_ = TRUE;
			while (TRUE) {
				gint _tmp48_;
				gchar** _tmp49_;
				gint _tmp49__length1;
				void* _tmp50_;
				const gchar* _tmp51_;
				void* _tmp52_;
				const gchar* _tmp53_ = NULL;
				gchar** _tmp54_;
				gint _tmp54__length1;
				gint _tmp55_;
				const gchar* _tmp56_;
				void* _tmp60_;
				void* _tmp61_;
				if (!_tmp46_) {
					gint _tmp47_;
					_tmp47_ = i;
					i = _tmp47_ + 1;
				}
				_tmp46_ = FALSE;
				_tmp48_ = i;
				_tmp49_ = str_array;
				_tmp49__length1 = str_array_length1;
				if (!(_tmp48_ < _tmp49__length1)) {
					break;
				}
				_tmp50_ = ptr;
				_tmp51_ = separator;
				_tmp52_ = g_stpcpy (_tmp50_, (const gchar*) _tmp51_);
				ptr = _tmp52_;
				_tmp54_ = str_array;
				_tmp54__length1 = str_array_length1;
				_tmp55_ = i;
				_tmp56_ = _tmp54_[_tmp55_];
				if (_tmp56_ != NULL) {
					gchar** _tmp57_;
					gint _tmp57__length1;
					gint _tmp58_;
					const gchar* _tmp59_;
					_tmp57_ = str_array;
					_tmp57__length1 = str_array_length1;
					_tmp58_ = i;
					_tmp59_ = _tmp57_[_tmp58_];
					_tmp53_ = (const gchar*) _tmp59_;
				} else {
					_tmp53_ = "";
				}
				_tmp60_ = ptr;
				_tmp61_ = g_stpcpy (_tmp60_, _tmp53_);
				ptr = _tmp61_;
			}
		}
		_tmp62_ = res;
		res = NULL;
		result = (gchar*) _tmp62_;
		return result;
	} else {
		gchar* _tmp63_;
		_tmp63_ = g_strdup ("");
		result = _tmp63_;
		return result;
	}
}


gchar* skk_key_event_to_string (SkkKeyEvent* self) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	const gchar* _tmp1_;
	gchar* _base = NULL;
	gchar* _tmp6_;
	SkkModifierType _tmp7_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = self->priv->_name;
	if (_tmp1_ != NULL) {
		const gchar* _tmp2_;
		gchar* _tmp3_;
		_tmp2_ = self->priv->_name;
		_tmp3_ = g_strdup (_tmp2_);
		_g_free0 (_tmp0_);
		_tmp0_ = _tmp3_;
	} else {
		gunichar _tmp4_;
		gchar* _tmp5_;
		_tmp4_ = self->priv->_code;
		_tmp5_ = g_unichar_to_string (_tmp4_);
		_g_free0 (_tmp0_);
		_tmp0_ = _tmp5_;
	}
	_tmp6_ = g_strdup (_tmp0_);
	_base = _tmp6_;
	_tmp7_ = self->priv->_modifiers;
	if (_tmp7_ != 0) {
		GeeArrayList* elements = NULL;
		GeeArrayList* _tmp8_;
		SkkModifierType _tmp9_;
		SkkModifierType _tmp11_;
		SkkModifierType _tmp13_;
		SkkModifierType _tmp15_;
		SkkModifierType _tmp17_;
		SkkModifierType _tmp19_;
		SkkModifierType _tmp21_;
		SkkModifierType _tmp23_;
		SkkModifierType _tmp25_;
		GeeArrayList* _tmp27_;
		const gchar* _tmp28_;
		GeeArrayList* _tmp29_;
		gchar** array = NULL;
		GeeArrayList* _tmp30_;
		gint _tmp31_;
		gpointer* _tmp32_;
		gint array_length1;
		gint _array_size_;
		gint _tmp33_;
		gchar** _tmp34_;
		gint _tmp34__length1;
		gchar* _tmp35_;
		gchar* _tmp36_;
		gchar* _tmp37_;
		gchar* _tmp38_;
		gchar* _tmp39_;
		gchar* _tmp40_;
		_tmp8_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
		elements = _tmp8_;
		_tmp9_ = self->priv->_modifiers;
		if ((_tmp9_ & SKK_MODIFIER_TYPE_CONTROL_MASK) != 0) {
			GeeArrayList* _tmp10_;
			_tmp10_ = elements;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp10_, "control");
		}
		_tmp11_ = self->priv->_modifiers;
		if ((_tmp11_ & SKK_MODIFIER_TYPE_META_MASK) != 0) {
			GeeArrayList* _tmp12_;
			_tmp12_ = elements;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp12_, "meta");
		}
		_tmp13_ = self->priv->_modifiers;
		if ((_tmp13_ & SKK_MODIFIER_TYPE_HYPER_MASK) != 0) {
			GeeArrayList* _tmp14_;
			_tmp14_ = elements;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp14_, "hyper");
		}
		_tmp15_ = self->priv->_modifiers;
		if ((_tmp15_ & SKK_MODIFIER_TYPE_SUPER_MASK) != 0) {
			GeeArrayList* _tmp16_;
			_tmp16_ = elements;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp16_, "super");
		}
		_tmp17_ = self->priv->_modifiers;
		if ((_tmp17_ & SKK_MODIFIER_TYPE_MOD1_MASK) != 0) {
			GeeArrayList* _tmp18_;
			_tmp18_ = elements;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp18_, "alt");
		}
		_tmp19_ = self->priv->_modifiers;
		if ((_tmp19_ & SKK_MODIFIER_TYPE_LSHIFT_MASK) != 0) {
			GeeArrayList* _tmp20_;
			_tmp20_ = elements;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp20_, "lshift");
		}
		_tmp21_ = self->priv->_modifiers;
		if ((_tmp21_ & SKK_MODIFIER_TYPE_RSHIFT_MASK) != 0) {
			GeeArrayList* _tmp22_;
			_tmp22_ = elements;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp22_, "rshift");
		}
		_tmp23_ = self->priv->_modifiers;
		if ((_tmp23_ & SKK_MODIFIER_TYPE_USLEEP_MASK) != 0) {
			GeeArrayList* _tmp24_;
			_tmp24_ = elements;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp24_, "usleep");
		}
		_tmp25_ = self->priv->_modifiers;
		if ((_tmp25_ & SKK_MODIFIER_TYPE_RELEASE_MASK) != 0) {
			GeeArrayList* _tmp26_;
			_tmp26_ = elements;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp26_, "release");
		}
		_tmp27_ = elements;
		_tmp28_ = _base;
		gee_abstract_collection_add ((GeeAbstractCollection*) _tmp27_, _tmp28_);
		_tmp29_ = elements;
		gee_abstract_collection_add ((GeeAbstractCollection*) _tmp29_, NULL);
		_tmp30_ = elements;
		_tmp32_ = gee_collection_to_array ((GeeCollection*) _tmp30_, &_tmp31_);
		array = _tmp32_;
		array_length1 = _tmp31_;
		_array_size_ = array_length1;
		array_length1 = -1;
		_tmp33_ = array_length1;
		_tmp34_ = array;
		_tmp34__length1 = array_length1;
		_tmp35_ = _vala_g_strjoinv (" ", _tmp34_, _tmp34__length1);
		_tmp36_ = _tmp35_;
		_tmp37_ = g_strconcat ("(", _tmp36_, NULL);
		_tmp38_ = _tmp37_;
		_tmp39_ = g_strconcat (_tmp38_, ")", NULL);
		_tmp40_ = _tmp39_;
		_g_free0 (_tmp38_);
		_g_free0 (_tmp36_);
		result = _tmp40_;
		array = (_vala_array_free (array, array_length1, (GDestroyNotify) g_free), NULL);
		_g_object_unref0 (elements);
		_g_free0 (_base);
		_g_free0 (_tmp0_);
		return result;
	} else {
		result = _base;
		_g_free0 (_tmp0_);
		return result;
	}
	_g_free0 (_base);
	_g_free0 (_tmp0_);
}


/**
         * Create a key event from an X keysym and modifiers.
         *
         * @param keyval an X keysym
         * @param modifiers modifier mask
         *
         * @return a new KeyEvent
         */
SkkKeyEvent* skk_key_event_construct_from_x_keysym (GType object_type, guint keyval, SkkModifierType modifiers, GError** error) {
	SkkKeyEvent * self = NULL;
	gboolean _tmp10_ = FALSE;
	const gchar* _tmp11_;
	gboolean _tmp13_ = FALSE;
	const gchar* _tmp14_;
	SkkModifierType _tmp22_;
	GError * _inner_error_ = NULL;
	self = (SkkKeyEvent*) g_object_new (object_type, NULL);
	{
		SkkKeyEventNameKeyvalEntry* entry_collection = NULL;
		gint entry_collection_length1 = 0;
		gint _entry_collection_size_ = 0;
		gint entry_it = 0;
		entry_collection = SKK_KEY_EVENT_NAME_KEYVALS;
		entry_collection_length1 = G_N_ELEMENTS (SKK_KEY_EVENT_NAME_KEYVALS);
		for (entry_it = 0; entry_it < G_N_ELEMENTS (SKK_KEY_EVENT_NAME_KEYVALS); entry_it = entry_it + 1) {
			SkkKeyEventNameKeyvalEntry entry = {0};
			entry = entry_collection[entry_it];
			{
				SkkKeyEventNameKeyvalEntry _tmp0_;
				guint _tmp1_;
				guint _tmp2_;
				_tmp0_ = entry;
				_tmp1_ = _tmp0_.key;
				_tmp2_ = keyval;
				if (_tmp1_ == _tmp2_) {
					SkkKeyEventNameKeyvalEntry _tmp3_;
					const gchar* _tmp4_;
					_tmp3_ = entry;
					_tmp4_ = _tmp3_.value;
					skk_key_event_set_name (self, _tmp4_);
					break;
				}
			}
		}
	}
	{
		SkkKeyEventCodeKeyvalEntry* entry_collection = NULL;
		gint entry_collection_length1 = 0;
		gint _entry_collection_size_ = 0;
		gint entry_it = 0;
		entry_collection = SKK_KEY_EVENT_CODE_KEYVALS;
		entry_collection_length1 = G_N_ELEMENTS (SKK_KEY_EVENT_CODE_KEYVALS);
		for (entry_it = 0; entry_it < G_N_ELEMENTS (SKK_KEY_EVENT_CODE_KEYVALS); entry_it = entry_it + 1) {
			SkkKeyEventCodeKeyvalEntry entry = {0};
			entry = entry_collection[entry_it];
			{
				SkkKeyEventCodeKeyvalEntry _tmp5_;
				guint _tmp6_;
				guint _tmp7_;
				_tmp5_ = entry;
				_tmp6_ = _tmp5_.key;
				_tmp7_ = keyval;
				if (_tmp6_ == _tmp7_) {
					SkkKeyEventCodeKeyvalEntry _tmp8_;
					gunichar _tmp9_;
					_tmp8_ = entry;
					_tmp9_ = _tmp8_.value;
					skk_key_event_set_code (self, _tmp9_);
					break;
				}
			}
		}
	}
	_tmp11_ = self->priv->_name;
	if (_tmp11_ == NULL) {
		_tmp10_ = TRUE;
	} else {
		gunichar _tmp12_;
		_tmp12_ = self->priv->_code;
		_tmp10_ = _tmp12_ == ((gunichar) '\0');
	}
	_vala_assert (_tmp10_, "name == null || code == '\\0'");
	_tmp14_ = self->priv->_name;
	if (_tmp14_ == NULL) {
		gunichar _tmp15_;
		_tmp15_ = self->priv->_code;
		_tmp13_ = _tmp15_ == ((gunichar) '\0');
	} else {
		_tmp13_ = FALSE;
	}
	if (_tmp13_) {
		gboolean _tmp16_ = FALSE;
		guint _tmp17_;
		_tmp17_ = keyval;
		if (((guint) 0x20) <= _tmp17_) {
			guint _tmp18_;
			_tmp18_ = keyval;
			_tmp16_ = _tmp18_ < ((guint) 0x7F);
		} else {
			_tmp16_ = FALSE;
		}
		if (_tmp16_) {
			guint _tmp19_;
			_tmp19_ = keyval;
			skk_key_event_set_code (self, (gunichar) _tmp19_);
		} else {
			guint _tmp20_;
			GError* _tmp21_;
			_tmp20_ = keyval;
			_tmp21_ = g_error_new (SKK_KEY_EVENT_FORMAT_ERROR, SKK_KEY_EVENT_FORMAT_ERROR_KEYSYM_NOT_FOUND, "unknown keysym %u", _tmp20_);
			_inner_error_ = _tmp21_;
			if (_inner_error_->domain == SKK_KEY_EVENT_FORMAT_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_object_unref0 (self);
				return NULL;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
	}
	_tmp22_ = modifiers;
	skk_key_event_set_modifiers (self, _tmp22_);
	return self;
}


SkkKeyEvent* skk_key_event_new_from_x_keysym (guint keyval, SkkModifierType modifiers, GError** error) {
	return skk_key_event_construct_from_x_keysym (SKK_TYPE_KEY_EVENT, keyval, modifiers, error);
}


/**
         * Compare two key events ignoring modifiers.
         *
         * @param key a KeyEvent
         *
         * @return `true` if those base components are equal, `false` otherwise
         */
gboolean skk_key_event_base_equal (SkkKeyEvent* self, SkkKeyEvent* key) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gunichar _tmp1_;
	SkkKeyEvent* _tmp2_;
	gunichar _tmp3_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (key != NULL, FALSE);
	_tmp1_ = self->priv->_code;
	_tmp2_ = key;
	_tmp3_ = _tmp2_->priv->_code;
	if (_tmp1_ == _tmp3_) {
		const gchar* _tmp4_;
		SkkKeyEvent* _tmp5_;
		const gchar* _tmp6_;
		_tmp4_ = self->priv->_name;
		_tmp5_ = key;
		_tmp6_ = _tmp5_->priv->_name;
		_tmp0_ = g_strcmp0 (_tmp4_, _tmp6_) == 0;
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}


const gchar* skk_key_event_get_name (SkkKeyEvent* self) {
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_name;
	result = _tmp0_;
	return result;
}


static void skk_key_event_set_name (SkkKeyEvent* self, const gchar* value) {
	g_return_if_fail (self != NULL);
	if (g_strcmp0 (value, skk_key_event_get_name (self)) != 0) {
		const gchar* _tmp0_;
		gchar* _tmp1_;
		_tmp0_ = value;
		_tmp1_ = g_strdup (_tmp0_);
		_g_free0 (self->priv->_name);
		self->priv->_name = _tmp1_;
		g_object_notify_by_pspec ((GObject *) self, skk_key_event_properties[SKK_KEY_EVENT_NAME_PROPERTY]);
	}
}


gunichar skk_key_event_get_code (SkkKeyEvent* self) {
	gunichar result;
	gunichar _tmp0_;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = self->priv->_code;
	result = _tmp0_;
	return result;
}


static void skk_key_event_set_code (SkkKeyEvent* self, gunichar value) {
	g_return_if_fail (self != NULL);
	if (skk_key_event_get_code (self) != value) {
		gunichar _tmp0_;
		_tmp0_ = value;
		self->priv->_code = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, skk_key_event_properties[SKK_KEY_EVENT_CODE_PROPERTY]);
	}
}


SkkModifierType skk_key_event_get_modifiers (SkkKeyEvent* self) {
	SkkModifierType result;
	SkkModifierType _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_modifiers;
	result = _tmp0_;
	return result;
}


void skk_key_event_set_modifiers (SkkKeyEvent* self, SkkModifierType value) {
	g_return_if_fail (self != NULL);
	if (skk_key_event_get_modifiers (self) != value) {
		SkkModifierType _tmp0_;
		_tmp0_ = value;
		self->priv->_modifiers = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, skk_key_event_properties[SKK_KEY_EVENT_MODIFIERS_PROPERTY]);
	}
}


static SkkKeyEventCodeKeyvalEntry* skk_key_event_code_keyval_entry_dup (const SkkKeyEventCodeKeyvalEntry* self) {
	SkkKeyEventCodeKeyvalEntry* dup;
	dup = g_new0 (SkkKeyEventCodeKeyvalEntry, 1);
	memcpy (dup, self, sizeof (SkkKeyEventCodeKeyvalEntry));
	return dup;
}


static void skk_key_event_code_keyval_entry_free (SkkKeyEventCodeKeyvalEntry* self) {
	g_free (self);
}


static GType skk_key_event_code_keyval_entry_get_type (void) {
	static volatile gsize skk_key_event_code_keyval_entry_type_id__volatile = 0;
	if (g_once_init_enter (&skk_key_event_code_keyval_entry_type_id__volatile)) {
		GType skk_key_event_code_keyval_entry_type_id;
		skk_key_event_code_keyval_entry_type_id = g_boxed_type_register_static ("SkkKeyEventCodeKeyvalEntry", (GBoxedCopyFunc) skk_key_event_code_keyval_entry_dup, (GBoxedFreeFunc) skk_key_event_code_keyval_entry_free);
		g_once_init_leave (&skk_key_event_code_keyval_entry_type_id__volatile, skk_key_event_code_keyval_entry_type_id);
	}
	return skk_key_event_code_keyval_entry_type_id__volatile;
}


static void skk_key_event_name_keyval_entry_copy (const SkkKeyEventNameKeyvalEntry* self, SkkKeyEventNameKeyvalEntry* dest) {
	guint _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	_tmp0_ = (*self).key;
	(*dest).key = _tmp0_;
	_tmp1_ = (*self).value;
	_tmp2_ = g_strdup (_tmp1_);
	_g_free0 ((*dest).value);
	(*dest).value = _tmp2_;
}


static void skk_key_event_name_keyval_entry_destroy (SkkKeyEventNameKeyvalEntry* self) {
	_g_free0 ((*self).value);
}


static SkkKeyEventNameKeyvalEntry* skk_key_event_name_keyval_entry_dup (const SkkKeyEventNameKeyvalEntry* self) {
	SkkKeyEventNameKeyvalEntry* dup;
	dup = g_new0 (SkkKeyEventNameKeyvalEntry, 1);
	skk_key_event_name_keyval_entry_copy (self, dup);
	return dup;
}


static void skk_key_event_name_keyval_entry_free (SkkKeyEventNameKeyvalEntry* self) {
	skk_key_event_name_keyval_entry_destroy (self);
	g_free (self);
}


static GType skk_key_event_name_keyval_entry_get_type (void) {
	static volatile gsize skk_key_event_name_keyval_entry_type_id__volatile = 0;
	if (g_once_init_enter (&skk_key_event_name_keyval_entry_type_id__volatile)) {
		GType skk_key_event_name_keyval_entry_type_id;
		skk_key_event_name_keyval_entry_type_id = g_boxed_type_register_static ("SkkKeyEventNameKeyvalEntry", (GBoxedCopyFunc) skk_key_event_name_keyval_entry_dup, (GBoxedFreeFunc) skk_key_event_name_keyval_entry_free);
		g_once_init_leave (&skk_key_event_name_keyval_entry_type_id__volatile, skk_key_event_name_keyval_entry_type_id);
	}
	return skk_key_event_name_keyval_entry_type_id__volatile;
}


static void skk_key_event_class_init (SkkKeyEventClass * klass) {
	skk_key_event_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (SkkKeyEventPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_skk_key_event_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_skk_key_event_set_property;
	G_OBJECT_CLASS (klass)->finalize = skk_key_event_finalize;
	/**
	         * The base name of the KeyEvent.
	         *
	         * This is exclusive to {@link code}.
	         */
	g_object_class_install_property (G_OBJECT_CLASS (klass), SKK_KEY_EVENT_NAME_PROPERTY, skk_key_event_properties[SKK_KEY_EVENT_NAME_PROPERTY] = g_param_spec_string ("name", "name", "name", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	         * The base code of the KeyEvent.
	         *
	         * This is exclusive to {@link name}.
	         */
	g_object_class_install_property (G_OBJECT_CLASS (klass), SKK_KEY_EVENT_CODE_PROPERTY, skk_key_event_properties[SKK_KEY_EVENT_CODE_PROPERTY] = g_param_spec_uint ("code", "code", "code", 0, G_MAXUINT, 0U, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	         * Modifier mask.
	         */
	g_object_class_install_property (G_OBJECT_CLASS (klass), SKK_KEY_EVENT_MODIFIERS_PROPERTY, skk_key_event_properties[SKK_KEY_EVENT_MODIFIERS_PROPERTY] = g_param_spec_flags ("modifiers", "modifiers", "modifiers", SKK_TYPE_MODIFIER_TYPE, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void skk_key_event_instance_init (SkkKeyEvent * self) {
	self->priv = SKK_KEY_EVENT_GET_PRIVATE (self);
}


static void skk_key_event_finalize (GObject * obj) {
	SkkKeyEvent * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SKK_TYPE_KEY_EVENT, SkkKeyEvent);
	_g_free0 (self->priv->_name);
	G_OBJECT_CLASS (skk_key_event_parent_class)->finalize (obj);
}


/**
     * Object representing a key event.
     */
GType skk_key_event_get_type (void) {
	static volatile gsize skk_key_event_type_id__volatile = 0;
	if (g_once_init_enter (&skk_key_event_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SkkKeyEventClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) skk_key_event_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SkkKeyEvent), 0, (GInstanceInitFunc) skk_key_event_instance_init, NULL };
		GType skk_key_event_type_id;
		skk_key_event_type_id = g_type_register_static (G_TYPE_OBJECT, "SkkKeyEvent", &g_define_type_info, 0);
		g_once_init_leave (&skk_key_event_type_id__volatile, skk_key_event_type_id);
	}
	return skk_key_event_type_id__volatile;
}


static void _vala_skk_key_event_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	SkkKeyEvent * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SKK_TYPE_KEY_EVENT, SkkKeyEvent);
	switch (property_id) {
		case SKK_KEY_EVENT_NAME_PROPERTY:
		g_value_set_string (value, skk_key_event_get_name (self));
		break;
		case SKK_KEY_EVENT_CODE_PROPERTY:
		g_value_set_uint (value, skk_key_event_get_code (self));
		break;
		case SKK_KEY_EVENT_MODIFIERS_PROPERTY:
		g_value_set_flags (value, skk_key_event_get_modifiers (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_skk_key_event_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	SkkKeyEvent * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SKK_TYPE_KEY_EVENT, SkkKeyEvent);
	switch (property_id) {
		case SKK_KEY_EVENT_NAME_PROPERTY:
		skk_key_event_set_name (self, g_value_get_string (value));
		break;
		case SKK_KEY_EVENT_CODE_PROPERTY:
		skk_key_event_set_code (self, g_value_get_uint (value));
		break;
		case SKK_KEY_EVENT_MODIFIERS_PROPERTY:
		skk_key_event_set_modifiers (self, g_value_get_flags (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



