/* file-dict.c generated by valac 0.38.1.30-90885, the Vala compiler
 * generated from file-dict.vala, do not modify */

/*
 * Copyright (C) 2011-2017 Daiki Ueno <ueno@gnu.org>
 * Copyright (C) 2011-2017 Red Hat, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <gee.h>


#define SKK_TYPE_DICT (skk_dict_get_type ())
#define SKK_DICT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SKK_TYPE_DICT, SkkDict))
#define SKK_DICT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SKK_TYPE_DICT, SkkDictClass))
#define SKK_IS_DICT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SKK_TYPE_DICT))
#define SKK_IS_DICT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SKK_TYPE_DICT))
#define SKK_DICT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SKK_TYPE_DICT, SkkDictClass))

typedef struct _SkkDict SkkDict;
typedef struct _SkkDictClass SkkDictClass;
typedef struct _SkkDictPrivate SkkDictPrivate;

#define SKK_TYPE_CANDIDATE (skk_candidate_get_type ())
#define SKK_CANDIDATE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SKK_TYPE_CANDIDATE, SkkCandidate))
#define SKK_CANDIDATE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SKK_TYPE_CANDIDATE, SkkCandidateClass))
#define SKK_IS_CANDIDATE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SKK_TYPE_CANDIDATE))
#define SKK_IS_CANDIDATE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SKK_TYPE_CANDIDATE))
#define SKK_CANDIDATE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SKK_TYPE_CANDIDATE, SkkCandidateClass))

typedef struct _SkkCandidate SkkCandidate;
typedef struct _SkkCandidateClass SkkCandidateClass;

#define SKK_TYPE_FILE_DICT (skk_file_dict_get_type ())
#define SKK_FILE_DICT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SKK_TYPE_FILE_DICT, SkkFileDict))
#define SKK_FILE_DICT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SKK_TYPE_FILE_DICT, SkkFileDictClass))
#define SKK_IS_FILE_DICT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SKK_TYPE_FILE_DICT))
#define SKK_IS_FILE_DICT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SKK_TYPE_FILE_DICT))
#define SKK_FILE_DICT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SKK_TYPE_FILE_DICT, SkkFileDictClass))

typedef struct _SkkFileDict SkkFileDict;
typedef struct _SkkFileDictClass SkkFileDictClass;
typedef struct _SkkFileDictPrivate SkkFileDictPrivate;

#define SKK_TYPE_MEMORY_MAPPED_FILE (skk_memory_mapped_file_get_type ())
#define SKK_MEMORY_MAPPED_FILE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SKK_TYPE_MEMORY_MAPPED_FILE, SkkMemoryMappedFile))
#define SKK_MEMORY_MAPPED_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SKK_TYPE_MEMORY_MAPPED_FILE, SkkMemoryMappedFileClass))
#define SKK_IS_MEMORY_MAPPED_FILE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SKK_TYPE_MEMORY_MAPPED_FILE))
#define SKK_IS_MEMORY_MAPPED_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SKK_TYPE_MEMORY_MAPPED_FILE))
#define SKK_MEMORY_MAPPED_FILE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SKK_TYPE_MEMORY_MAPPED_FILE, SkkMemoryMappedFileClass))

typedef struct _SkkMemoryMappedFile SkkMemoryMappedFile;
typedef struct _SkkMemoryMappedFileClass SkkMemoryMappedFileClass;

#define SKK_TYPE_ENCODING_CONVERTER (skk_encoding_converter_get_type ())
#define SKK_ENCODING_CONVERTER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SKK_TYPE_ENCODING_CONVERTER, SkkEncodingConverter))
#define SKK_ENCODING_CONVERTER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SKK_TYPE_ENCODING_CONVERTER, SkkEncodingConverterClass))
#define SKK_IS_ENCODING_CONVERTER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SKK_TYPE_ENCODING_CONVERTER))
#define SKK_IS_ENCODING_CONVERTER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SKK_TYPE_ENCODING_CONVERTER))
#define SKK_ENCODING_CONVERTER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SKK_TYPE_ENCODING_CONVERTER, SkkEncodingConverterClass))

typedef struct _SkkEncodingConverter SkkEncodingConverter;
typedef struct _SkkEncodingConverterClass SkkEncodingConverterClass;
enum  {
	SKK_FILE_DICT_0_PROPERTY,
	SKK_FILE_DICT_READ_ONLY_PROPERTY,
	SKK_FILE_DICT_NUM_PROPERTIES
};
static GParamSpec* skk_file_dict_properties[SKK_FILE_DICT_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _SkkDict {
	GObject parent_instance;
	SkkDictPrivate * priv;
};

struct _SkkDictClass {
	GObjectClass parent_class;
	void (*reload) (SkkDict* self, GError** error);
	SkkCandidate** (*lookup) (SkkDict* self, const gchar* midasi, gboolean okuri, int* result_length1);
	gchar** (*complete) (SkkDict* self, const gchar* midasi, int* result_length1);
	gboolean (*select_candidate) (SkkDict* self, SkkCandidate* candidate);
	gboolean (*purge_candidate) (SkkDict* self, SkkCandidate* candidate);
	void (*save) (SkkDict* self, GError** error);
	gboolean (*get_read_only) (SkkDict* self);
};

struct _SkkFileDict {
	SkkDict parent_instance;
	SkkFileDictPrivate * priv;
};

struct _SkkFileDictClass {
	SkkDictClass parent_class;
};

struct _SkkFileDictPrivate {
	GFile* file;
	SkkMemoryMappedFile* mmap;
	gchar* etag;
	SkkEncodingConverter* converter;
	glong okuri_ari_offset;
	glong okuri_nasi_offset;
};

typedef enum  {
	SKK_SKK_DICT_ERROR_NOT_READABLE,
	SKK_SKK_DICT_ERROR_MALFORMED_INPUT
} SkkSkkDictError;
#define SKK_SKK_DICT_ERROR skk_skk_dict_error_quark ()

static gpointer skk_file_dict_parent_class = NULL;

GType skk_dict_get_type (void) G_GNUC_CONST;
GType skk_candidate_get_type (void) G_GNUC_CONST;
GType skk_file_dict_get_type (void) G_GNUC_CONST;
GType skk_memory_mapped_file_get_type (void) G_GNUC_CONST;
GType skk_encoding_converter_get_type (void) G_GNUC_CONST;
#define SKK_FILE_DICT_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), SKK_TYPE_FILE_DICT, SkkFileDictPrivate))
static gchar* skk_file_dict_read_line (SkkFileDict* self, glong* offset);
gsize skk_memory_mapped_file_get_length (SkkMemoryMappedFile* self);
void* skk_memory_mapped_file_get_memory (SkkMemoryMappedFile* self);
static gchar* skk_file_dict_read_previous_line (SkkFileDict* self, glong* pos, const gchar* line);
static gchar* skk_file_dict_read_next_line (SkkFileDict* self, glong* pos, const gchar* line);
static gboolean skk_file_dict_read_until (SkkFileDict* self, glong* offset, const gchar* line);
GQuark skk_skk_dict_error_quark (void);
static void skk_file_dict_load (SkkFileDict* self, GError** error);
void skk_memory_mapped_file_remap (SkkMemoryMappedFile* self, GError** error);
gchar* skk_encoding_converter_extract_coding_system (const gchar* line);
SkkEncodingConverter* skk_encoding_converter_new_from_coding_system (const gchar* coding, GError** error);
SkkEncodingConverter* skk_encoding_converter_construct_from_coding_system (GType object_type, const gchar* coding, GError** error);
static void skk_file_dict_real_reload (SkkDict* base, GError** error);
static gboolean skk_file_dict_search_pos (SkkFileDict* self, const gchar* midasi, glong start_offset, glong end_offset, GCompareFunc cmp, glong* pos, gchar* * line, gint direction);
static SkkCandidate** skk_file_dict_real_lookup (SkkDict* base, const gchar* midasi, gboolean okuri, int* result_length1);
gchar* skk_encoding_converter_encode (SkkEncodingConverter* self, const gchar* internal_str, GError** error);
gchar* skk_encoding_converter_decode (SkkEncodingConverter* self, const gchar* external_str, GError** error);
SkkCandidate** skk_dict_split_candidates (SkkDict* self, const gchar* midasi, gboolean okuri, const gchar* line, int* result_length1);
static gint skk_file_dict_strcmp_prefix (const gchar* a, const gchar* b);
static gchar** skk_file_dict_real_complete (SkkDict* base, const gchar* midasi, int* result_length1);
static gint _skk_file_dict_strcmp_prefix_gcompare_func (gconstpointer a, gconstpointer b);
SkkFileDict* skk_file_dict_new (const gchar* path, const gchar* encoding, GError** error);
SkkFileDict* skk_file_dict_construct (GType object_type, const gchar* path, const gchar* encoding, GError** error);
SkkDict* skk_dict_construct (GType object_type);
SkkMemoryMappedFile* skk_memory_mapped_file_new (GFile* file);
SkkMemoryMappedFile* skk_memory_mapped_file_construct (GType object_type, GFile* file);
SkkEncodingConverter* skk_encoding_converter_new (const gchar* encoding, GError** error);
SkkEncodingConverter* skk_encoding_converter_construct (GType object_type, const gchar* encoding, GError** error);
void skk_dict_reload (SkkDict* self, GError** error);
static void skk_file_dict_finalize (GObject * obj);
gboolean skk_dict_get_read_only (SkkDict* self);
static void _vala_skk_file_dict_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);


static gchar* skk_file_dict_read_line (SkkFileDict* self, glong* offset) {
	gchar* result = NULL;
	glong _tmp0_;
	SkkMemoryMappedFile* _tmp1_;
	gsize _tmp2_;
	gsize _tmp3_;
	gchar* p = NULL;
	SkkMemoryMappedFile* _tmp4_;
	void* _tmp5_;
	void* _tmp6_;
	glong _tmp7_;
	glong _tmp13_;
	GString* builder = NULL;
	GString* _tmp16_;
	glong _offset = 0L;
	glong _tmp17_;
	GString* _tmp28_;
	const gchar* _tmp29_;
	gchar* _tmp30_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = *offset;
	_tmp1_ = self->priv->mmap;
	_tmp2_ = skk_memory_mapped_file_get_length (_tmp1_);
	_tmp3_ = _tmp2_;
	g_return_val_if_fail (((gsize) _tmp0_) < _tmp3_, NULL);
	_tmp4_ = self->priv->mmap;
	_tmp5_ = skk_memory_mapped_file_get_memory (_tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = *offset;
	p = ((gchar*) _tmp6_) + _tmp7_;
	{
		gboolean _tmp8_ = FALSE;
		_tmp8_ = TRUE;
		while (TRUE) {
			glong _tmp11_;
			gchar* _tmp12_;
			if (!_tmp8_) {
				glong _tmp9_;
				gchar* _tmp10_;
				_tmp9_ = *offset;
				*offset = _tmp9_ - 1;
				_tmp10_ = p;
				p = _tmp10_ - 1;
			}
			_tmp8_ = FALSE;
			_tmp11_ = *offset;
			if (!(_tmp11_ > ((glong) 0))) {
				break;
			}
			_tmp12_ = p;
			if ((*_tmp12_) == '\n') {
				break;
			}
		}
	}
	_tmp13_ = *offset;
	if (_tmp13_ > ((glong) 0)) {
		glong _tmp14_;
		gchar* _tmp15_;
		_tmp14_ = *offset;
		*offset = _tmp14_ + 1;
		_tmp15_ = p;
		p = _tmp15_ + 1;
	}
	_tmp16_ = g_string_new ("");
	builder = _tmp16_;
	_tmp17_ = *offset;
	_offset = _tmp17_;
	{
		gboolean _tmp18_ = FALSE;
		_tmp18_ = TRUE;
		while (TRUE) {
			glong _tmp21_;
			SkkMemoryMappedFile* _tmp22_;
			gsize _tmp23_;
			gsize _tmp24_;
			gchar* _tmp25_;
			GString* _tmp26_;
			gchar* _tmp27_;
			if (!_tmp18_) {
				glong _tmp19_;
				gchar* _tmp20_;
				_tmp19_ = _offset;
				_offset = _tmp19_ + 1;
				_tmp20_ = p;
				p = _tmp20_ + 1;
			}
			_tmp18_ = FALSE;
			_tmp21_ = _offset;
			_tmp22_ = self->priv->mmap;
			_tmp23_ = skk_memory_mapped_file_get_length (_tmp22_);
			_tmp24_ = _tmp23_;
			if (!(((gsize) _tmp21_) < _tmp24_)) {
				break;
			}
			_tmp25_ = p;
			if ((*_tmp25_) == '\n') {
				break;
			}
			_tmp26_ = builder;
			_tmp27_ = p;
			g_string_append_c (_tmp26_, *_tmp27_);
		}
	}
	_tmp28_ = builder;
	_tmp29_ = _tmp28_->str;
	_tmp30_ = g_strdup (_tmp29_);
	result = _tmp30_;
	_g_string_free0 (builder);
	return result;
}


static gchar* skk_file_dict_read_previous_line (SkkFileDict* self, glong* pos, const gchar* line) {
	gchar* result = NULL;
	glong _tmp0_;
	glong _tmp1_;
	gchar* _tmp2_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (line != NULL, NULL);
	_tmp0_ = *pos;
	if (_tmp0_ < ((glong) 2)) {
		result = NULL;
		return result;
	}
	_tmp1_ = *pos;
	*pos = _tmp1_ - 2;
	_tmp2_ = skk_file_dict_read_line (self, pos);
	result = _tmp2_;
	return result;
}


static gchar* skk_file_dict_read_next_line (SkkFileDict* self, glong* pos, const gchar* line) {
	gchar* result = NULL;
	glong _tmp0_;
	const gchar* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	SkkMemoryMappedFile* _tmp4_;
	gsize _tmp5_;
	gsize _tmp6_;
	glong _tmp7_;
	const gchar* _tmp8_;
	gint _tmp9_;
	gint _tmp10_;
	gchar* _tmp11_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (line != NULL, NULL);
	_tmp0_ = *pos;
	_tmp1_ = line;
	_tmp2_ = strlen (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = self->priv->mmap;
	_tmp5_ = skk_memory_mapped_file_get_length (_tmp4_);
	_tmp6_ = _tmp5_;
	if (((gsize) ((_tmp0_ + _tmp3_) + 1)) >= _tmp6_) {
		result = NULL;
		return result;
	}
	_tmp7_ = *pos;
	_tmp8_ = line;
	_tmp9_ = strlen (_tmp8_);
	_tmp10_ = _tmp9_;
	*pos = _tmp7_ + (_tmp10_ + 1);
	_tmp11_ = skk_file_dict_read_line (self, pos);
	result = _tmp11_;
	return result;
}


static gboolean skk_file_dict_read_until (SkkFileDict* self, glong* offset, const gchar* line) {
	gboolean result = FALSE;
	glong _tmp0_;
	SkkMemoryMappedFile* _tmp1_;
	gsize _tmp2_;
	gsize _tmp3_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (line != NULL, FALSE);
	_tmp0_ = *offset;
	_tmp1_ = self->priv->mmap;
	_tmp2_ = skk_memory_mapped_file_get_length (_tmp1_);
	_tmp3_ = _tmp2_;
	g_return_val_if_fail (((gsize) _tmp0_) < _tmp3_, NULL);
	while (TRUE) {
		glong _tmp4_;
		const gchar* _tmp5_;
		gint _tmp6_;
		gint _tmp7_;
		SkkMemoryMappedFile* _tmp8_;
		gsize _tmp9_;
		gsize _tmp10_;
		gchar* p = NULL;
		SkkMemoryMappedFile* _tmp11_;
		void* _tmp12_;
		void* _tmp13_;
		glong _tmp14_;
		gboolean _tmp15_ = FALSE;
		gchar* _tmp16_;
		glong _tmp27_;
		_tmp4_ = *offset;
		_tmp5_ = line;
		_tmp6_ = strlen (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = self->priv->mmap;
		_tmp9_ = skk_memory_mapped_file_get_length (_tmp8_);
		_tmp10_ = _tmp9_;
		if (!(((gsize) (_tmp4_ + _tmp7_)) < _tmp10_)) {
			break;
		}
		_tmp11_ = self->priv->mmap;
		_tmp12_ = skk_memory_mapped_file_get_memory (_tmp11_);
		_tmp13_ = _tmp12_;
		_tmp14_ = *offset;
		p = ((gchar*) _tmp13_) + _tmp14_;
		_tmp16_ = p;
		if ((*_tmp16_) == '\n') {
			gchar* _tmp17_;
			const gchar* _tmp18_;
			const gchar* _tmp19_;
			gint _tmp20_;
			gint _tmp21_;
			gint _tmp22_;
			_tmp17_ = p;
			_tmp18_ = line;
			_tmp19_ = line;
			_tmp20_ = strlen (_tmp19_);
			_tmp21_ = _tmp20_;
			_tmp22_ = memcmp (_tmp17_ + 1, (void*) _tmp18_, (gsize) _tmp21_);
			_tmp15_ = _tmp22_ == 0;
		} else {
			_tmp15_ = FALSE;
		}
		if (_tmp15_) {
			glong _tmp23_;
			const gchar* _tmp24_;
			gint _tmp25_;
			gint _tmp26_;
			_tmp23_ = *offset;
			_tmp24_ = line;
			_tmp25_ = strlen (_tmp24_);
			_tmp26_ = _tmp25_;
			*offset = _tmp23_ + _tmp26_;
			result = TRUE;
			return result;
		}
		_tmp27_ = *offset;
		*offset = _tmp27_ + 1;
	}
	result = FALSE;
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void skk_file_dict_load (SkkFileDict* self, GError** error) {
	SkkMemoryMappedFile* _tmp0_;
	glong offset = 0L;
	gchar* line = NULL;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* coding = NULL;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	const gchar* _tmp6_;
	gboolean _tmp15_;
	glong _tmp17_;
	gboolean _tmp18_;
	glong _tmp20_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->mmap;
	skk_memory_mapped_file_remap (_tmp0_, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == SKK_SKK_DICT_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	offset = (glong) 0;
	_tmp1_ = skk_file_dict_read_line (self, &offset);
	line = _tmp1_;
	_tmp2_ = line;
	if (_tmp2_ == NULL) {
		GError* _tmp3_;
		_tmp3_ = g_error_new_literal (SKK_SKK_DICT_ERROR, SKK_SKK_DICT_ERROR_MALFORMED_INPUT, "can't read the first line");
		_inner_error_ = _tmp3_;
		if (_inner_error_->domain == SKK_SKK_DICT_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (line);
			return;
		} else {
			_g_free0 (line);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp4_ = line;
	_tmp5_ = skk_encoding_converter_extract_coding_system (_tmp4_);
	coding = _tmp5_;
	_tmp6_ = coding;
	if (_tmp6_ != NULL) {
		{
			SkkEncodingConverter* _converter = NULL;
			const gchar* _tmp7_;
			SkkEncodingConverter* _tmp8_;
			SkkEncodingConverter* _tmp9_;
			_tmp7_ = coding;
			_tmp8_ = skk_encoding_converter_new_from_coding_system (_tmp7_, &_inner_error_);
			_converter = _tmp8_;
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				goto __catch2_g_error;
			}
			_tmp9_ = _converter;
			if (_tmp9_ != NULL) {
				SkkEncodingConverter* _tmp10_;
				SkkEncodingConverter* _tmp11_;
				_tmp10_ = _converter;
				_tmp11_ = _g_object_ref0 (_tmp10_);
				_g_object_unref0 (self->priv->converter);
				self->priv->converter = _tmp11_;
			}
			_g_object_unref0 (_converter);
		}
		goto __finally2;
		__catch2_g_error:
		{
			GError* e = NULL;
			const gchar* _tmp12_;
			GError* _tmp13_;
			const gchar* _tmp14_;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp12_ = coding;
			_tmp13_ = e;
			_tmp14_ = _tmp13_->message;
			g_warning ("file-dict.vala:105: can't create converter from coding system %s: %s", _tmp12_, _tmp14_);
			_g_error_free0 (e);
		}
		__finally2:
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == SKK_SKK_DICT_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_free0 (coding);
				_g_free0 (line);
				return;
			} else {
				_g_free0 (coding);
				_g_free0 (line);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
	}
	offset = (glong) 0;
	_tmp15_ = skk_file_dict_read_until (self, &offset, ";; okuri-ari entries.\n");
	if (!_tmp15_) {
		GError* _tmp16_;
		_tmp16_ = g_error_new_literal (SKK_SKK_DICT_ERROR, SKK_SKK_DICT_ERROR_MALFORMED_INPUT, "no okuri-ari boundary");
		_inner_error_ = _tmp16_;
		if (_inner_error_->domain == SKK_SKK_DICT_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (coding);
			_g_free0 (line);
			return;
		} else {
			_g_free0 (coding);
			_g_free0 (line);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp17_ = offset;
	self->priv->okuri_ari_offset = _tmp17_;
	_tmp18_ = skk_file_dict_read_until (self, &offset, ";; okuri-nasi entries.\n");
	if (!_tmp18_) {
		GError* _tmp19_;
		_tmp19_ = g_error_new_literal (SKK_SKK_DICT_ERROR, SKK_SKK_DICT_ERROR_MALFORMED_INPUT, "no okuri-nasi boundary");
		_inner_error_ = _tmp19_;
		if (_inner_error_->domain == SKK_SKK_DICT_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (coding);
			_g_free0 (line);
			return;
		} else {
			_g_free0 (coding);
			_g_free0 (line);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp20_ = offset;
	self->priv->okuri_nasi_offset = _tmp20_;
	_g_free0 (coding);
	_g_free0 (line);
}


/**
         * {@inheritDoc}
         */
static void skk_file_dict_real_reload (SkkDict* base, GError** error) {
	SkkFileDict * self;
	gchar* attributes = NULL;
	gchar* _tmp0_;
	GFileInfo* info = NULL;
	GFile* _tmp1_;
	GFileInfo* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	GError * _inner_error_ = NULL;
	self = (SkkFileDict*) base;
	_tmp0_ = g_strdup (G_FILE_ATTRIBUTE_ETAG_VALUE);
	attributes = _tmp0_;
	_tmp1_ = self->priv->file;
	_tmp2_ = g_file_query_info (_tmp1_, attributes, G_FILE_QUERY_INFO_NONE, NULL, &_inner_error_);
	info = _tmp2_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (attributes);
		return;
	}
	_tmp3_ = g_file_info_get_etag (info);
	_tmp4_ = self->priv->etag;
	if (g_strcmp0 (_tmp3_, _tmp4_) != 0) {
		{
			const gchar* _tmp5_;
			gchar* _tmp6_;
			skk_file_dict_load (self, &_inner_error_);
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				if (_inner_error_->domain == SKK_SKK_DICT_ERROR) {
					goto __catch3_skk_skk_dict_error;
				}
				_g_object_unref0 (info);
				_g_free0 (attributes);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
			_tmp5_ = g_file_info_get_etag (info);
			_tmp6_ = g_strdup (_tmp5_);
			_g_free0 (self->priv->etag);
			self->priv->etag = _tmp6_;
		}
		goto __finally3;
		__catch3_skk_skk_dict_error:
		{
			GError* e = NULL;
			GFile* _tmp7_;
			gchar* _tmp8_;
			gchar* _tmp9_;
			GError* _tmp10_;
			const gchar* _tmp11_;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp7_ = self->priv->file;
			_tmp8_ = g_file_get_path (_tmp7_);
			_tmp9_ = _tmp8_;
			_tmp10_ = e;
			_tmp11_ = _tmp10_->message;
			g_warning ("file-dict.vala:140: error loading file dictionary %s %s", _tmp9_, _tmp11_);
			_g_free0 (_tmp9_);
			_g_error_free0 (e);
		}
		__finally3:
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (info);
			_g_free0 (attributes);
			return;
		}
	}
	_g_object_unref0 (info);
	_g_free0 (attributes);
}


static gint string_index_of (const gchar* self, const gchar* needle, gint start_index) {
	gint result = 0;
	gchar* _result_ = NULL;
	gint _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (needle != NULL, 0);
	_tmp0_ = start_index;
	_tmp1_ = needle;
	_tmp2_ = strstr (((gchar*) self) + _tmp0_, (gchar*) _tmp1_);
	_result_ = _tmp2_;
	_tmp3_ = _result_;
	if (_tmp3_ != NULL) {
		gchar* _tmp4_;
		_tmp4_ = _result_;
		result = (gint) (_tmp4_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}


static gchar* string_slice (const gchar* self, glong start, glong end) {
	gchar* result = NULL;
	glong string_length = 0L;
	gint _tmp0_;
	gint _tmp1_;
	glong _tmp2_;
	glong _tmp5_;
	gboolean _tmp8_ = FALSE;
	glong _tmp9_;
	gboolean _tmp12_ = FALSE;
	glong _tmp13_;
	glong _tmp16_;
	glong _tmp17_;
	glong _tmp18_;
	glong _tmp19_;
	glong _tmp20_;
	gchar* _tmp21_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	string_length = (glong) _tmp1_;
	_tmp2_ = start;
	if (_tmp2_ < ((glong) 0)) {
		glong _tmp3_;
		glong _tmp4_;
		_tmp3_ = string_length;
		_tmp4_ = start;
		start = _tmp3_ + _tmp4_;
	}
	_tmp5_ = end;
	if (_tmp5_ < ((glong) 0)) {
		glong _tmp6_;
		glong _tmp7_;
		_tmp6_ = string_length;
		_tmp7_ = end;
		end = _tmp6_ + _tmp7_;
	}
	_tmp9_ = start;
	if (_tmp9_ >= ((glong) 0)) {
		glong _tmp10_;
		glong _tmp11_;
		_tmp10_ = start;
		_tmp11_ = string_length;
		_tmp8_ = _tmp10_ <= _tmp11_;
	} else {
		_tmp8_ = FALSE;
	}
	g_return_val_if_fail (_tmp8_, NULL);
	_tmp13_ = end;
	if (_tmp13_ >= ((glong) 0)) {
		glong _tmp14_;
		glong _tmp15_;
		_tmp14_ = end;
		_tmp15_ = string_length;
		_tmp12_ = _tmp14_ <= _tmp15_;
	} else {
		_tmp12_ = FALSE;
	}
	g_return_val_if_fail (_tmp12_, NULL);
	_tmp16_ = start;
	_tmp17_ = end;
	g_return_val_if_fail (_tmp16_ <= _tmp17_, NULL);
	_tmp18_ = start;
	_tmp19_ = end;
	_tmp20_ = start;
	_tmp21_ = g_strndup (((gchar*) self) + _tmp18_, (gsize) (_tmp19_ - _tmp20_));
	result = _tmp21_;
	return result;
}


static gboolean skk_file_dict_search_pos (SkkFileDict* self, const gchar* midasi, glong start_offset, glong end_offset, GCompareFunc cmp, glong* pos, gchar* * line, gint direction) {
	glong _vala_pos = 0L;
	gchar* _vala_line = NULL;
	gboolean result = FALSE;
	glong offset = 0L;
	glong _tmp0_;
	glong _tmp1_;
	glong _tmp2_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (midasi != NULL, FALSE);
	_tmp0_ = start_offset;
	_tmp1_ = end_offset;
	_tmp2_ = start_offset;
	offset = _tmp0_ + ((_tmp1_ - _tmp2_) / 2);
	while (TRUE) {
		glong _tmp3_;
		glong _tmp4_;
		glong _tmp5_;
		SkkMemoryMappedFile* _tmp6_;
		gsize _tmp7_;
		gsize _tmp8_;
		gchar* _line = NULL;
		gchar* _tmp9_;
		gint index = 0;
		const gchar* _tmp10_;
		gint _tmp11_;
		gint _tmp12_;
		gint r = 0;
		GCompareFunc _tmp14_;
		const gchar* _tmp15_;
		gint _tmp16_;
		gchar* _tmp17_;
		gchar* _tmp18_;
		const gchar* _tmp19_;
		gint _tmp20_;
		gint _tmp21_;
		gint _tmp22_;
		gint _tmp26_;
		gint _tmp27_;
		glong _tmp33_;
		glong _tmp34_;
		glong _tmp35_;
		_tmp3_ = start_offset;
		_tmp4_ = end_offset;
		if (!(_tmp3_ <= _tmp4_)) {
			break;
		}
		_tmp5_ = offset;
		_tmp6_ = self->priv->mmap;
		_tmp7_ = skk_memory_mapped_file_get_length (_tmp6_);
		_tmp8_ = _tmp7_;
		_vala_assert (((gsize) _tmp5_) < _tmp8_, "offset < mmap.length");
		_tmp9_ = skk_file_dict_read_line (self, &offset);
		_line = _tmp9_;
		_tmp10_ = _line;
		_tmp11_ = string_index_of (_tmp10_, " ", 0);
		index = _tmp11_;
		_tmp12_ = index;
		if (_tmp12_ < 1) {
			const gchar* _tmp13_;
			_tmp13_ = _line;
			g_warning ("file-dict.vala:160: corrupted dictionary entry: %s", _tmp13_);
			_g_free0 (_line);
			break;
		}
		_tmp14_ = cmp;
		_tmp15_ = _line;
		_tmp16_ = index;
		_tmp17_ = string_slice (_tmp15_, (glong) 0, (glong) _tmp16_);
		_tmp18_ = _tmp17_;
		_tmp19_ = midasi;
		_tmp20_ = _tmp14_ (_tmp18_, _tmp19_);
		_tmp21_ = _tmp20_;
		_g_free0 (_tmp18_);
		r = _tmp21_;
		_tmp22_ = r;
		if (_tmp22_ == 0) {
			glong _tmp23_;
			const gchar* _tmp24_;
			gchar* _tmp25_;
			_tmp23_ = offset;
			_vala_pos = _tmp23_;
			_tmp24_ = _line;
			_tmp25_ = g_strdup (_tmp24_);
			_g_free0 (_vala_line);
			_vala_line = _tmp25_;
			result = TRUE;
			_g_free0 (_line);
			if (pos) {
				*pos = _vala_pos;
			}
			if (line) {
				*line = _vala_line;
			} else {
				_g_free0 (_vala_line);
			}
			return result;
		}
		_tmp26_ = r;
		_tmp27_ = direction;
		if ((_tmp26_ * _tmp27_) > 0) {
			glong _tmp28_;
			_tmp28_ = offset;
			end_offset = _tmp28_ - 2;
		} else {
			glong _tmp29_;
			const gchar* _tmp30_;
			gint _tmp31_;
			gint _tmp32_;
			_tmp29_ = offset;
			_tmp30_ = _line;
			_tmp31_ = strlen (_tmp30_);
			_tmp32_ = _tmp31_;
			start_offset = (_tmp29_ + _tmp32_) + 1;
		}
		_tmp33_ = start_offset;
		_tmp34_ = end_offset;
		_tmp35_ = start_offset;
		offset = _tmp33_ + ((_tmp34_ - _tmp35_) / 2);
		_g_free0 (_line);
	}
	_vala_pos = (glong) -1;
	_g_free0 (_vala_line);
	_vala_line = NULL;
	result = FALSE;
	if (pos) {
		*pos = _vala_pos;
	}
	if (line) {
		*line = _vala_line;
	} else {
		_g_free0 (_vala_line);
	}
	return result;
}


/**
         * {@inheritDoc}
         */
static SkkCandidate** skk_file_dict_real_lookup (SkkDict* base, const gchar* midasi, gboolean okuri, int* result_length1) {
	SkkFileDict * self;
	SkkCandidate** result = NULL;
	SkkMemoryMappedFile* _tmp0_;
	void* _tmp1_;
	void* _tmp2_;
	glong start_offset = 0L;
	glong end_offset = 0L;
	gboolean _tmp5_;
	gchar* _midasi = NULL;
	glong pos = 0L;
	gchar* line = NULL;
	gint _tmp22_ = 0;
	gboolean _tmp23_;
	const gchar* _tmp24_;
	glong _tmp25_;
	glong _tmp26_;
	GCompareFunc _tmp27_;
	glong _tmp28_ = 0L;
	gchar* _tmp29_ = NULL;
	gboolean _tmp30_;
	SkkCandidate** _tmp57_;
	SkkCandidate** _tmp58_;
	gint _tmp58__length1;
	GError * _inner_error_ = NULL;
	self = (SkkFileDict*) base;
	g_return_val_if_fail (midasi != NULL, NULL);
	_tmp0_ = self->priv->mmap;
	_tmp1_ = skk_memory_mapped_file_get_memory (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == NULL) {
		SkkCandidate** _tmp3_;
		SkkCandidate** _tmp4_;
		gint _tmp4__length1;
		_tmp3_ = g_new0 (SkkCandidate*, 0 + 1);
		_tmp4_ = _tmp3_;
		_tmp4__length1 = 0;
		if (result_length1) {
			*result_length1 = _tmp4__length1;
		}
		result = _tmp4_;
		return result;
	}
	_tmp5_ = okuri;
	if (_tmp5_) {
		glong _tmp6_;
		glong _tmp7_;
		_tmp6_ = self->priv->okuri_ari_offset;
		start_offset = _tmp6_;
		_tmp7_ = self->priv->okuri_nasi_offset;
		end_offset = _tmp7_;
	} else {
		glong _tmp8_;
		SkkMemoryMappedFile* _tmp9_;
		gsize _tmp10_;
		gsize _tmp11_;
		_tmp8_ = self->priv->okuri_nasi_offset;
		start_offset = _tmp8_;
		_tmp9_ = self->priv->mmap;
		_tmp10_ = skk_memory_mapped_file_get_length (_tmp9_);
		_tmp11_ = _tmp10_;
		end_offset = ((glong) _tmp11_) - 1;
	}
	{
		gchar* _tmp12_ = NULL;
		SkkEncodingConverter* _tmp13_;
		const gchar* _tmp14_;
		gchar* _tmp15_;
		gchar* _tmp16_;
		_tmp13_ = self->priv->converter;
		_tmp14_ = midasi;
		_tmp15_ = skk_encoding_converter_encode (_tmp13_, _tmp14_, &_inner_error_);
		_tmp12_ = _tmp15_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch4_g_error;
		}
		_tmp16_ = _tmp12_;
		_tmp12_ = NULL;
		_g_free0 (_midasi);
		_midasi = _tmp16_;
		_g_free0 (_tmp12_);
	}
	goto __finally4;
	__catch4_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp17_;
		GError* _tmp18_;
		const gchar* _tmp19_;
		SkkCandidate** _tmp20_;
		SkkCandidate** _tmp21_;
		gint _tmp21__length1;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp17_ = midasi;
		_tmp18_ = e;
		_tmp19_ = _tmp18_->message;
		g_warning ("file-dict.vala:202: can't encode %s: %s", _tmp17_, _tmp19_);
		_tmp20_ = g_new0 (SkkCandidate*, 0 + 1);
		_tmp21_ = _tmp20_;
		_tmp21__length1 = 0;
		if (result_length1) {
			*result_length1 = _tmp21__length1;
		}
		result = _tmp21_;
		_g_error_free0 (e);
		_g_free0 (_midasi);
		return result;
	}
	__finally4:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_free0 (_midasi);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_tmp23_ = okuri;
	if (_tmp23_) {
		_tmp22_ = -1;
	} else {
		_tmp22_ = 1;
	}
	_tmp24_ = _midasi;
	_tmp25_ = start_offset;
	_tmp26_ = end_offset;
	_tmp27_ = g_strcmp0;
	_tmp30_ = skk_file_dict_search_pos (self, _tmp24_, _tmp25_, _tmp26_, _tmp27_, &_tmp28_, &_tmp29_, _tmp22_);
	pos = _tmp28_;
	_g_free0 (line);
	line = _tmp29_;
	if (_tmp30_) {
		gint index = 0;
		const gchar* _tmp31_;
		gint _tmp32_;
		gchar* _line = NULL;
		gint _tmp33_;
		_tmp31_ = line;
		_tmp32_ = string_index_of (_tmp31_, " ", 0);
		index = _tmp32_;
		_tmp33_ = index;
		if (_tmp33_ > 0) {
			const gchar* _tmp51_;
			gboolean _tmp52_;
			const gchar* _tmp53_;
			gint _tmp54_;
			SkkCandidate** _tmp55_;
			SkkCandidate** _tmp56_;
			gint _tmp56__length1;
			{
				gchar* _tmp34_ = NULL;
				SkkEncodingConverter* _tmp35_;
				const gchar* _tmp36_;
				gint _tmp37_;
				const gchar* _tmp38_;
				gint _tmp39_;
				gint _tmp40_;
				gchar* _tmp41_;
				gchar* _tmp42_;
				gchar* _tmp43_;
				gchar* _tmp44_;
				gchar* _tmp45_;
				_tmp35_ = self->priv->converter;
				_tmp36_ = line;
				_tmp37_ = index;
				_tmp38_ = line;
				_tmp39_ = strlen (_tmp38_);
				_tmp40_ = _tmp39_;
				_tmp41_ = string_slice (_tmp36_, (glong) _tmp37_, (glong) _tmp40_);
				_tmp42_ = _tmp41_;
				_tmp43_ = skk_encoding_converter_decode (_tmp35_, _tmp42_, &_inner_error_);
				_tmp44_ = _tmp43_;
				_g_free0 (_tmp42_);
				_tmp34_ = _tmp44_;
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					goto __catch5_g_error;
				}
				_tmp45_ = _tmp34_;
				_tmp34_ = NULL;
				_g_free0 (_line);
				_line = _tmp45_;
				_g_free0 (_tmp34_);
			}
			goto __finally5;
			__catch5_g_error:
			{
				GError* e = NULL;
				const gchar* _tmp46_;
				GError* _tmp47_;
				const gchar* _tmp48_;
				SkkCandidate** _tmp49_;
				SkkCandidate** _tmp50_;
				gint _tmp50__length1;
				e = _inner_error_;
				_inner_error_ = NULL;
				_tmp46_ = line;
				_tmp47_ = e;
				_tmp48_ = _tmp47_->message;
				g_warning ("file-dict.vala:221: can't decode line %s: %s", _tmp46_, _tmp48_);
				_tmp49_ = g_new0 (SkkCandidate*, 0 + 1);
				_tmp50_ = _tmp49_;
				_tmp50__length1 = 0;
				if (result_length1) {
					*result_length1 = _tmp50__length1;
				}
				result = _tmp50_;
				_g_error_free0 (e);
				_g_free0 (_line);
				_g_free0 (line);
				_g_free0 (_midasi);
				return result;
			}
			__finally5:
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				_g_free0 (_line);
				_g_free0 (line);
				_g_free0 (_midasi);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
			_tmp51_ = midasi;
			_tmp52_ = okuri;
			_tmp53_ = _line;
			_tmp55_ = skk_dict_split_candidates ((SkkDict*) self, _tmp51_, _tmp52_, _tmp53_, &_tmp54_);
			_tmp56_ = _tmp55_;
			_tmp56__length1 = _tmp54_;
			if (result_length1) {
				*result_length1 = _tmp56__length1;
			}
			result = _tmp56_;
			_g_free0 (_line);
			_g_free0 (line);
			_g_free0 (_midasi);
			return result;
		}
		_g_free0 (_line);
	}
	_tmp57_ = g_new0 (SkkCandidate*, 0 + 1);
	_tmp58_ = _tmp57_;
	_tmp58__length1 = 0;
	if (result_length1) {
		*result_length1 = _tmp58__length1;
	}
	result = _tmp58_;
	_g_free0 (line);
	_g_free0 (_midasi);
	return result;
}


static gint skk_file_dict_strcmp_prefix (const gchar* a, const gchar* b) {
	gint result = 0;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gboolean _tmp2_;
	GCompareFunc _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	gint _tmp6_;
	g_return_val_if_fail (a != NULL, 0);
	g_return_val_if_fail (b != NULL, 0);
	_tmp0_ = a;
	_tmp1_ = b;
	_tmp2_ = g_str_has_prefix (_tmp0_, _tmp1_);
	if (_tmp2_) {
		result = 0;
		return result;
	}
	_tmp3_ = g_strcmp0;
	_tmp4_ = a;
	_tmp5_ = b;
	_tmp6_ = _tmp3_ (_tmp4_, _tmp5_);
	result = _tmp6_;
	return result;
}


/**
         * {@inheritDoc}
         */
static gint _skk_file_dict_strcmp_prefix_gcompare_func (gconstpointer a, gconstpointer b) {
	gint result;
	result = skk_file_dict_strcmp_prefix ((const gchar*) a, (const gchar*) b);
	return result;
}


static gchar** skk_file_dict_real_complete (SkkDict* base, const gchar* midasi, int* result_length1) {
	SkkFileDict * self;
	gchar** result = NULL;
	SkkMemoryMappedFile* _tmp0_;
	void* _tmp1_;
	void* _tmp2_;
	GeeArrayList* completion = NULL;
	GeeArrayList* _tmp5_;
	glong start_offset = 0L;
	glong end_offset = 0L;
	glong _tmp6_;
	SkkMemoryMappedFile* _tmp7_;
	gsize _tmp8_;
	gsize _tmp9_;
	gchar* _midasi = NULL;
	glong pos = 0L;
	gchar* line = NULL;
	const gchar* _tmp22_;
	glong _tmp23_;
	glong _tmp24_;
	glong _tmp25_ = 0L;
	gchar* _tmp26_ = NULL;
	gboolean _tmp27_;
	GeeArrayList* _tmp83_;
	gint _tmp84_;
	gpointer* _tmp85_;
	gchar** _tmp86_;
	gint _tmp86__length1;
	GError * _inner_error_ = NULL;
	self = (SkkFileDict*) base;
	g_return_val_if_fail (midasi != NULL, NULL);
	_tmp0_ = self->priv->mmap;
	_tmp1_ = skk_memory_mapped_file_get_memory (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == NULL) {
		gchar** _tmp3_;
		gchar** _tmp4_;
		gint _tmp4__length1;
		_tmp3_ = g_new0 (gchar*, 0 + 1);
		_tmp4_ = _tmp3_;
		_tmp4__length1 = 0;
		if (result_length1) {
			*result_length1 = _tmp4__length1;
		}
		result = _tmp4_;
		return result;
	}
	_tmp5_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
	completion = _tmp5_;
	_tmp6_ = self->priv->okuri_nasi_offset;
	start_offset = _tmp6_;
	_tmp7_ = self->priv->mmap;
	_tmp8_ = skk_memory_mapped_file_get_length (_tmp7_);
	_tmp9_ = _tmp8_;
	end_offset = ((glong) _tmp9_) - 1;
	{
		gchar* _tmp10_ = NULL;
		SkkEncodingConverter* _tmp11_;
		const gchar* _tmp12_;
		gchar* _tmp13_;
		gchar* _tmp14_;
		_tmp11_ = self->priv->converter;
		_tmp12_ = midasi;
		_tmp13_ = skk_encoding_converter_encode (_tmp11_, _tmp12_, &_inner_error_);
		_tmp10_ = _tmp13_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch6_g_error;
		}
		_tmp14_ = _tmp10_;
		_tmp10_ = NULL;
		_g_free0 (_midasi);
		_midasi = _tmp14_;
		_g_free0 (_tmp10_);
	}
	goto __finally6;
	__catch6_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp15_;
		GError* _tmp16_;
		const gchar* _tmp17_;
		GeeArrayList* _tmp18_;
		gint _tmp19_;
		gpointer* _tmp20_;
		gchar** _tmp21_;
		gint _tmp21__length1;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp15_ = midasi;
		_tmp16_ = e;
		_tmp17_ = _tmp16_->message;
		g_warning ("file-dict.vala:254: can't decode %s: %s", _tmp15_, _tmp17_);
		_tmp18_ = completion;
		_tmp20_ = gee_collection_to_array ((GeeCollection*) _tmp18_, &_tmp19_);
		_tmp21_ = _tmp20_;
		_tmp21__length1 = _tmp19_;
		if (result_length1) {
			*result_length1 = _tmp21__length1;
		}
		result = _tmp21_;
		_g_error_free0 (e);
		_g_free0 (_midasi);
		_g_object_unref0 (completion);
		return result;
	}
	__finally6:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_free0 (_midasi);
		_g_object_unref0 (completion);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_tmp22_ = _midasi;
	_tmp23_ = start_offset;
	_tmp24_ = end_offset;
	_tmp27_ = skk_file_dict_search_pos (self, _tmp22_, _tmp23_, _tmp24_, _skk_file_dict_strcmp_prefix_gcompare_func, &_tmp25_, &_tmp26_, 1);
	pos = _tmp25_;
	_g_free0 (line);
	line = _tmp26_;
	if (_tmp27_) {
		glong _pos = 0L;
		glong _tmp28_;
		gchar* _line = NULL;
		const gchar* _tmp29_;
		gchar* _tmp30_;
		glong _tmp56_;
		const gchar* _tmp57_;
		gchar* _tmp58_;
		_tmp28_ = pos;
		_pos = _tmp28_;
		_tmp29_ = line;
		_tmp30_ = g_strdup (_tmp29_);
		_line = _tmp30_;
		{
			gboolean _tmp31_ = FALSE;
			_tmp31_ = TRUE;
			while (TRUE) {
				gint index = 0;
				const gchar* _tmp39_;
				gint _tmp40_;
				gint _tmp41_;
				if (!_tmp31_) {
					gboolean _tmp32_ = FALSE;
					const gchar* _tmp33_;
					gchar* _tmp34_;
					const gchar* _tmp35_;
					_tmp33_ = line;
					_tmp34_ = skk_file_dict_read_previous_line (self, &pos, _tmp33_);
					_g_free0 (line);
					line = _tmp34_;
					_tmp35_ = line;
					if (_tmp35_ != NULL) {
						const gchar* _tmp36_;
						const gchar* _tmp37_;
						gboolean _tmp38_;
						_tmp36_ = line;
						_tmp37_ = _midasi;
						_tmp38_ = g_str_has_prefix (_tmp36_, _tmp37_);
						_tmp32_ = _tmp38_;
					} else {
						_tmp32_ = FALSE;
					}
					if (!_tmp32_) {
						break;
					}
				}
				_tmp31_ = FALSE;
				_tmp39_ = line;
				_tmp40_ = string_index_of (_tmp39_, " ", 0);
				index = _tmp40_;
				_tmp41_ = index;
				if (_tmp41_ < 0) {
					const gchar* _tmp42_;
					_tmp42_ = line;
					g_warning ("file-dict.vala:274: corrupted dictionary entry: %s", _tmp42_);
				} else {
					gchar* completed = NULL;
					const gchar* _tmp43_;
					gint _tmp44_;
					gchar* _tmp45_;
					const gchar* _tmp46_;
					const gchar* _tmp47_;
					_tmp43_ = line;
					_tmp44_ = index;
					_tmp45_ = string_slice (_tmp43_, (glong) 0, (glong) _tmp44_);
					completed = _tmp45_;
					_tmp46_ = completed;
					_tmp47_ = _midasi;
					if (g_strcmp0 (_tmp46_, _tmp47_) != 0) {
						{
							gchar* decoded = NULL;
							SkkEncodingConverter* _tmp48_;
							const gchar* _tmp49_;
							gchar* _tmp50_;
							GeeArrayList* _tmp51_;
							const gchar* _tmp52_;
							_tmp48_ = self->priv->converter;
							_tmp49_ = completed;
							_tmp50_ = skk_encoding_converter_decode (_tmp48_, _tmp49_, &_inner_error_);
							decoded = _tmp50_;
							if (G_UNLIKELY (_inner_error_ != NULL)) {
								goto __catch7_g_error;
							}
							_tmp51_ = completion;
							_tmp52_ = decoded;
							gee_abstract_list_insert ((GeeAbstractList*) _tmp51_, 0, _tmp52_);
							_g_free0 (decoded);
						}
						goto __finally7;
						__catch7_g_error:
						{
							GError* e = NULL;
							const gchar* _tmp53_;
							GError* _tmp54_;
							const gchar* _tmp55_;
							e = _inner_error_;
							_inner_error_ = NULL;
							_tmp53_ = line;
							_tmp54_ = e;
							_tmp55_ = _tmp54_->message;
							g_warning ("file-dict.vala:284: can't decode line %s: %s", _tmp53_, _tmp55_);
							_g_error_free0 (e);
						}
						__finally7:
						if (G_UNLIKELY (_inner_error_ != NULL)) {
							_g_free0 (completed);
							_g_free0 (_line);
							_g_free0 (line);
							_g_free0 (_midasi);
							_g_object_unref0 (completion);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return NULL;
						}
					}
					_g_free0 (completed);
				}
			}
		}
		_tmp56_ = _pos;
		pos = _tmp56_;
		_tmp57_ = _line;
		_tmp58_ = g_strdup (_tmp57_);
		_g_free0 (line);
		line = _tmp58_;
		while (TRUE) {
			gboolean _tmp59_ = FALSE;
			const gchar* _tmp60_;
			gchar* _tmp61_;
			const gchar* _tmp62_;
			gint index = 0;
			const gchar* _tmp66_;
			gint _tmp67_;
			gint _tmp68_;
			_tmp60_ = line;
			_tmp61_ = skk_file_dict_read_next_line (self, &pos, _tmp60_);
			_g_free0 (line);
			line = _tmp61_;
			_tmp62_ = line;
			if (_tmp62_ != NULL) {
				const gchar* _tmp63_;
				const gchar* _tmp64_;
				gboolean _tmp65_;
				_tmp63_ = line;
				_tmp64_ = _midasi;
				_tmp65_ = g_str_has_prefix (_tmp63_, _tmp64_);
				_tmp59_ = _tmp65_;
			} else {
				_tmp59_ = FALSE;
			}
			if (!_tmp59_) {
				break;
			}
			_tmp66_ = line;
			_tmp67_ = string_index_of (_tmp66_, " ", 0);
			index = _tmp67_;
			_tmp68_ = index;
			if (_tmp68_ < 0) {
				const gchar* _tmp69_;
				_tmp69_ = line;
				g_warning ("file-dict.vala:299: corrupted dictionary entry: %s", _tmp69_);
			} else {
				gchar* completed = NULL;
				const gchar* _tmp70_;
				gint _tmp71_;
				gchar* _tmp72_;
				const gchar* _tmp73_;
				const gchar* _tmp74_;
				_tmp70_ = line;
				_tmp71_ = index;
				_tmp72_ = string_slice (_tmp70_, (glong) 0, (glong) _tmp71_);
				completed = _tmp72_;
				_tmp73_ = completed;
				_tmp74_ = _midasi;
				if (g_strcmp0 (_tmp73_, _tmp74_) != 0) {
					{
						gchar* decoded = NULL;
						SkkEncodingConverter* _tmp75_;
						const gchar* _tmp76_;
						gchar* _tmp77_;
						GeeArrayList* _tmp78_;
						const gchar* _tmp79_;
						_tmp75_ = self->priv->converter;
						_tmp76_ = completed;
						_tmp77_ = skk_encoding_converter_decode (_tmp75_, _tmp76_, &_inner_error_);
						decoded = _tmp77_;
						if (G_UNLIKELY (_inner_error_ != NULL)) {
							goto __catch8_g_error;
						}
						_tmp78_ = completion;
						_tmp79_ = decoded;
						gee_abstract_collection_add ((GeeAbstractCollection*) _tmp78_, _tmp79_);
						_g_free0 (decoded);
					}
					goto __finally8;
					__catch8_g_error:
					{
						GError* e = NULL;
						const gchar* _tmp80_;
						GError* _tmp81_;
						const gchar* _tmp82_;
						e = _inner_error_;
						_inner_error_ = NULL;
						_tmp80_ = line;
						_tmp81_ = e;
						_tmp82_ = _tmp81_->message;
						g_warning ("file-dict.vala:309: can't decode line %s: %s", _tmp80_, _tmp82_);
						_g_error_free0 (e);
					}
					__finally8:
					if (G_UNLIKELY (_inner_error_ != NULL)) {
						_g_free0 (completed);
						_g_free0 (_line);
						_g_free0 (line);
						_g_free0 (_midasi);
						_g_object_unref0 (completion);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return NULL;
					}
				}
				_g_free0 (completed);
			}
		}
		_g_free0 (_line);
	}
	_tmp83_ = completion;
	_tmp85_ = gee_collection_to_array ((GeeCollection*) _tmp83_, &_tmp84_);
	_tmp86_ = _tmp85_;
	_tmp86__length1 = _tmp84_;
	if (result_length1) {
		*result_length1 = _tmp86__length1;
	}
	result = _tmp86_;
	_g_free0 (line);
	_g_free0 (_midasi);
	_g_object_unref0 (completion);
	return result;
}


/**
         * Create a new FileDict.
         *
         * @param path a path to the file
         * @param encoding encoding of the file (default EUC-JP)
         *
         * @return a new FileDict
         * @throws GLib.Error if opening the file is failed
         */
SkkFileDict* skk_file_dict_construct (GType object_type, const gchar* path, const gchar* encoding, GError** error) {
	SkkFileDict * self = NULL;
	const gchar* _tmp0_;
	GFile* _tmp1_;
	GFile* _tmp2_;
	SkkMemoryMappedFile* _tmp3_;
	gchar* _tmp4_;
	SkkEncodingConverter* _tmp5_ = NULL;
	const gchar* _tmp6_;
	SkkEncodingConverter* _tmp7_;
	SkkEncodingConverter* _tmp8_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (path != NULL, NULL);
	g_return_val_if_fail (encoding != NULL, NULL);
	self = (SkkFileDict*) skk_dict_construct (object_type);
	_tmp0_ = path;
	_tmp1_ = g_file_new_for_path (_tmp0_);
	_g_object_unref0 (self->priv->file);
	self->priv->file = _tmp1_;
	_tmp2_ = self->priv->file;
	_tmp3_ = skk_memory_mapped_file_new (_tmp2_);
	_g_object_unref0 (self->priv->mmap);
	self->priv->mmap = _tmp3_;
	_tmp4_ = g_strdup ("");
	_g_free0 (self->priv->etag);
	self->priv->etag = _tmp4_;
	_tmp6_ = encoding;
	_tmp7_ = skk_encoding_converter_new (_tmp6_, &_inner_error_);
	_tmp5_ = _tmp7_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (self);
		return NULL;
	}
	_tmp8_ = _tmp5_;
	_tmp5_ = NULL;
	_g_object_unref0 (self->priv->converter);
	self->priv->converter = _tmp8_;
	skk_dict_reload ((SkkDict*) self, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (_tmp5_);
		_g_object_unref0 (self);
		return NULL;
	}
	_g_object_unref0 (_tmp5_);
	return self;
}


SkkFileDict* skk_file_dict_new (const gchar* path, const gchar* encoding, GError** error) {
	return skk_file_dict_construct (SKK_TYPE_FILE_DICT, path, encoding, error);
}


static gboolean skk_file_dict_real_get_read_only (SkkDict* base) {
	gboolean result;
	SkkFileDict* self;
	self = (SkkFileDict*) base;
	result = TRUE;
	return result;
}


static void skk_file_dict_class_init (SkkFileDictClass * klass) {
	skk_file_dict_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (SkkFileDictPrivate));
	((SkkDictClass *) klass)->reload = (void (*) (SkkDict *, GError**)) skk_file_dict_real_reload;
	((SkkDictClass *) klass)->lookup = (SkkCandidate** (*) (SkkDict *, const gchar*, gboolean, int*)) skk_file_dict_real_lookup;
	((SkkDictClass *) klass)->complete = (gchar** (*) (SkkDict *, const gchar*, int*)) skk_file_dict_real_complete;
	SKK_DICT_CLASS (klass)->get_read_only = skk_file_dict_real_get_read_only;
	G_OBJECT_CLASS (klass)->get_property = _vala_skk_file_dict_get_property;
	G_OBJECT_CLASS (klass)->finalize = skk_file_dict_finalize;
	/**
	         * {@inheritDoc}
	         */
	g_object_class_install_property (G_OBJECT_CLASS (klass), SKK_FILE_DICT_READ_ONLY_PROPERTY, skk_file_dict_properties[SKK_FILE_DICT_READ_ONLY_PROPERTY] = g_param_spec_boolean ("read-only", "read-only", "read-only", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
}


static void skk_file_dict_instance_init (SkkFileDict * self) {
	self->priv = SKK_FILE_DICT_GET_PRIVATE (self);
}


static void skk_file_dict_finalize (GObject * obj) {
	SkkFileDict * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SKK_TYPE_FILE_DICT, SkkFileDict);
	_g_object_unref0 (self->priv->file);
	_g_object_unref0 (self->priv->mmap);
	_g_free0 (self->priv->etag);
	_g_object_unref0 (self->priv->converter);
	G_OBJECT_CLASS (skk_file_dict_parent_class)->finalize (obj);
}


/**
     * Read-only file based implementation of Dict.
     */
GType skk_file_dict_get_type (void) {
	static volatile gsize skk_file_dict_type_id__volatile = 0;
	if (g_once_init_enter (&skk_file_dict_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SkkFileDictClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) skk_file_dict_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SkkFileDict), 0, (GInstanceInitFunc) skk_file_dict_instance_init, NULL };
		GType skk_file_dict_type_id;
		skk_file_dict_type_id = g_type_register_static (SKK_TYPE_DICT, "SkkFileDict", &g_define_type_info, 0);
		g_once_init_leave (&skk_file_dict_type_id__volatile, skk_file_dict_type_id);
	}
	return skk_file_dict_type_id__volatile;
}


static void _vala_skk_file_dict_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	SkkFileDict * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SKK_TYPE_FILE_DICT, SkkFileDict);
	switch (property_id) {
		case SKK_FILE_DICT_READ_ONLY_PROPERTY:
		g_value_set_boolean (value, skk_dict_get_read_only ((SkkDict*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



