/* dict.c generated by valac 0.38.1.30-90885, the Vala compiler
 * generated from dict.vala, do not modify */

/*
 * Copyright (C) 2011-2017 Daiki Ueno <ueno@gnu.org>
 * Copyright (C) 2011-2017 Red Hat, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>


#define SKK_TYPE_DICT (skk_dict_get_type ())
#define SKK_DICT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SKK_TYPE_DICT, SkkDict))
#define SKK_DICT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SKK_TYPE_DICT, SkkDictClass))
#define SKK_IS_DICT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SKK_TYPE_DICT))
#define SKK_IS_DICT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SKK_TYPE_DICT))
#define SKK_DICT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SKK_TYPE_DICT, SkkDictClass))

typedef struct _SkkDict SkkDict;
typedef struct _SkkDictClass SkkDictClass;
typedef struct _SkkDictPrivate SkkDictPrivate;

#define SKK_TYPE_CANDIDATE (skk_candidate_get_type ())
#define SKK_CANDIDATE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SKK_TYPE_CANDIDATE, SkkCandidate))
#define SKK_CANDIDATE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SKK_TYPE_CANDIDATE, SkkCandidateClass))
#define SKK_IS_CANDIDATE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SKK_TYPE_CANDIDATE))
#define SKK_IS_CANDIDATE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SKK_TYPE_CANDIDATE))
#define SKK_CANDIDATE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SKK_TYPE_CANDIDATE, SkkCandidateClass))

typedef struct _SkkCandidate SkkCandidate;
typedef struct _SkkCandidateClass SkkCandidateClass;
enum  {
	SKK_DICT_0_PROPERTY,
	SKK_DICT_READ_ONLY_PROPERTY,
	SKK_DICT_NUM_PROPERTIES
};
static GParamSpec* skk_dict_properties[SKK_DICT_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define SKK_TYPE_EMPTY_DICT (skk_empty_dict_get_type ())
#define SKK_EMPTY_DICT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SKK_TYPE_EMPTY_DICT, SkkEmptyDict))
#define SKK_EMPTY_DICT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SKK_TYPE_EMPTY_DICT, SkkEmptyDictClass))
#define SKK_IS_EMPTY_DICT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SKK_TYPE_EMPTY_DICT))
#define SKK_IS_EMPTY_DICT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SKK_TYPE_EMPTY_DICT))
#define SKK_EMPTY_DICT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SKK_TYPE_EMPTY_DICT, SkkEmptyDictClass))

typedef struct _SkkEmptyDict SkkEmptyDict;
typedef struct _SkkEmptyDictClass SkkEmptyDictClass;
typedef struct _SkkEmptyDictPrivate SkkEmptyDictPrivate;
enum  {
	SKK_EMPTY_DICT_0_PROPERTY,
	SKK_EMPTY_DICT_READ_ONLY_PROPERTY,
	SKK_EMPTY_DICT_NUM_PROPERTIES
};
static GParamSpec* skk_empty_dict_properties[SKK_EMPTY_DICT_NUM_PROPERTIES];

struct _SkkDict {
	GObject parent_instance;
	SkkDictPrivate * priv;
};

struct _SkkDictClass {
	GObjectClass parent_class;
	void (*reload) (SkkDict* self, GError** error);
	SkkCandidate** (*lookup) (SkkDict* self, const gchar* midasi, gboolean okuri, int* result_length1);
	gchar** (*complete) (SkkDict* self, const gchar* midasi, int* result_length1);
	gboolean (*select_candidate) (SkkDict* self, SkkCandidate* candidate);
	gboolean (*purge_candidate) (SkkDict* self, SkkCandidate* candidate);
	void (*save) (SkkDict* self, GError** error);
	gboolean (*get_read_only) (SkkDict* self);
};

struct _SkkEmptyDict {
	SkkDict parent_instance;
	SkkEmptyDictPrivate * priv;
};

struct _SkkEmptyDictClass {
	SkkDictClass parent_class;
};

typedef enum  {
	SKK_SKK_DICT_ERROR_NOT_READABLE,
	SKK_SKK_DICT_ERROR_MALFORMED_INPUT
} SkkSkkDictError;
#define SKK_SKK_DICT_ERROR skk_skk_dict_error_quark ()

static gpointer skk_dict_parent_class = NULL;
static gpointer skk_empty_dict_parent_class = NULL;

GType skk_dict_get_type (void) G_GNUC_CONST;
GType skk_candidate_get_type (void) G_GNUC_CONST;
SkkCandidate** skk_dict_split_candidates (SkkDict* self, const gchar* midasi, gboolean okuri, const gchar* line, int* result_length1);
SkkCandidate* skk_candidate_new (const gchar* midasi, gboolean okuri, const gchar* text, const gchar* annotation, const gchar* output);
SkkCandidate* skk_candidate_construct (GType object_type, const gchar* midasi, gboolean okuri, const gchar* text, const gchar* annotation, const gchar* output);
gchar* skk_dict_join_candidates (SkkDict* self, SkkCandidate** candidates, int candidates_length1);
gchar* skk_candidate_to_string (SkkCandidate* self);
void skk_dict_reload (SkkDict* self, GError** error);
static void skk_dict_real_reload (SkkDict* self, GError** error);
SkkCandidate** skk_dict_lookup (SkkDict* self, const gchar* midasi, gboolean okuri, int* result_length1);
static SkkCandidate** skk_dict_real_lookup (SkkDict* self, const gchar* midasi, gboolean okuri, int* result_length1);
gchar** skk_dict_complete (SkkDict* self, const gchar* midasi, int* result_length1);
static gchar** skk_dict_real_complete (SkkDict* self, const gchar* midasi, int* result_length1);
gboolean skk_dict_select_candidate (SkkDict* self, SkkCandidate* candidate);
static gboolean skk_dict_real_select_candidate (SkkDict* self, SkkCandidate* candidate);
gboolean skk_dict_purge_candidate (SkkDict* self, SkkCandidate* candidate);
static gboolean skk_dict_real_purge_candidate (SkkDict* self, SkkCandidate* candidate);
void skk_dict_save (SkkDict* self, GError** error);
static void skk_dict_real_save (SkkDict* self, GError** error);
SkkDict* skk_dict_construct (GType object_type);
gboolean skk_dict_get_read_only (SkkDict* self);
static void _vala_skk_dict_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
GType skk_empty_dict_get_type (void) G_GNUC_CONST;
static void skk_empty_dict_real_reload (SkkDict* base, GError** error);
static SkkCandidate** skk_empty_dict_real_lookup (SkkDict* base, const gchar* midasi, gboolean okuri, int* result_length1);
static gchar** skk_empty_dict_real_complete (SkkDict* base, const gchar* midasi, int* result_length1);
SkkEmptyDict* skk_empty_dict_new (void);
SkkEmptyDict* skk_empty_dict_construct (GType object_type);
static void _vala_skk_empty_dict_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
GQuark skk_skk_dict_error_quark (void);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


/**
         * Parse a line consisting of candidates separated by "/".
         *
         * @param line a line consisting of candidates
         * @return an array of Candidates
         */
static gchar* string_strip (const gchar* self) {
	gchar* result = NULL;
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	g_strstrip (_tmp1_);
	result = _result_;
	return result;
}


static gchar* string_slice (const gchar* self, glong start, glong end) {
	gchar* result = NULL;
	glong string_length = 0L;
	gint _tmp0_;
	gint _tmp1_;
	glong _tmp2_;
	glong _tmp5_;
	gboolean _tmp8_ = FALSE;
	glong _tmp9_;
	gboolean _tmp12_ = FALSE;
	glong _tmp13_;
	glong _tmp16_;
	glong _tmp17_;
	glong _tmp18_;
	glong _tmp19_;
	glong _tmp20_;
	gchar* _tmp21_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	string_length = (glong) _tmp1_;
	_tmp2_ = start;
	if (_tmp2_ < ((glong) 0)) {
		glong _tmp3_;
		glong _tmp4_;
		_tmp3_ = string_length;
		_tmp4_ = start;
		start = _tmp3_ + _tmp4_;
	}
	_tmp5_ = end;
	if (_tmp5_ < ((glong) 0)) {
		glong _tmp6_;
		glong _tmp7_;
		_tmp6_ = string_length;
		_tmp7_ = end;
		end = _tmp6_ + _tmp7_;
	}
	_tmp9_ = start;
	if (_tmp9_ >= ((glong) 0)) {
		glong _tmp10_;
		glong _tmp11_;
		_tmp10_ = start;
		_tmp11_ = string_length;
		_tmp8_ = _tmp10_ <= _tmp11_;
	} else {
		_tmp8_ = FALSE;
	}
	g_return_val_if_fail (_tmp8_, NULL);
	_tmp13_ = end;
	if (_tmp13_ >= ((glong) 0)) {
		glong _tmp14_;
		glong _tmp15_;
		_tmp14_ = end;
		_tmp15_ = string_length;
		_tmp12_ = _tmp14_ <= _tmp15_;
	} else {
		_tmp12_ = FALSE;
	}
	g_return_val_if_fail (_tmp12_, NULL);
	_tmp16_ = start;
	_tmp17_ = end;
	g_return_val_if_fail (_tmp16_ <= _tmp17_, NULL);
	_tmp18_ = start;
	_tmp19_ = end;
	_tmp20_ = start;
	_tmp21_ = g_strndup (((gchar*) self) + _tmp18_, (gsize) (_tmp19_ - _tmp20_));
	result = _tmp21_;
	return result;
}


SkkCandidate** skk_dict_split_candidates (SkkDict* self, const gchar* midasi, gboolean okuri, const gchar* line, int* result_length1) {
	SkkCandidate** result = NULL;
	gchar** strv = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar** _tmp5_;
	gchar** _tmp6_;
	gchar** _tmp7_;
	gint _tmp7__length1;
	gint strv_length1;
	gint _strv_size_;
	SkkCandidate** candidates = NULL;
	gchar** _tmp8_;
	gint _tmp8__length1;
	SkkCandidate** _tmp9_;
	gint candidates_length1;
	gint _candidates_size_;
	SkkCandidate** _tmp38_;
	gint _tmp38__length1;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (midasi != NULL, NULL);
	g_return_val_if_fail (line != NULL, NULL);
	_tmp0_ = line;
	_tmp1_ = string_strip (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = string_slice (_tmp2_, (glong) 1, (glong) -1);
	_tmp4_ = _tmp3_;
	_tmp6_ = _tmp5_ = g_strsplit (_tmp4_, "/", 0);
	_tmp7_ = _tmp6_;
	_tmp7__length1 = _vala_array_length (_tmp5_);
	_g_free0 (_tmp4_);
	_g_free0 (_tmp2_);
	strv = _tmp7_;
	strv_length1 = _tmp7__length1;
	_strv_size_ = strv_length1;
	_tmp8_ = strv;
	_tmp8__length1 = strv_length1;
	_tmp9_ = g_new0 (SkkCandidate*, _tmp8__length1 + 1);
	candidates = _tmp9_;
	candidates_length1 = _tmp8__length1;
	_candidates_size_ = candidates_length1;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp10_ = FALSE;
			_tmp10_ = TRUE;
			while (TRUE) {
				gint _tmp12_;
				gchar** _tmp13_;
				gint _tmp13__length1;
				gchar** text_annotation = NULL;
				gchar** _tmp14_;
				gint _tmp14__length1;
				gint _tmp15_;
				const gchar* _tmp16_;
				gchar** _tmp17_;
				gchar** _tmp18_;
				gint text_annotation_length1;
				gint _text_annotation_size_;
				gchar* text = NULL;
				gchar* annotation = NULL;
				gchar** _tmp19_;
				gint _tmp19__length1;
				SkkCandidate** _tmp30_;
				gint _tmp30__length1;
				gint _tmp31_;
				const gchar* _tmp32_;
				gboolean _tmp33_;
				const gchar* _tmp34_;
				const gchar* _tmp35_;
				SkkCandidate* _tmp36_;
				SkkCandidate* _tmp37_;
				if (!_tmp10_) {
					gint _tmp11_;
					_tmp11_ = i;
					i = _tmp11_ + 1;
				}
				_tmp10_ = FALSE;
				_tmp12_ = i;
				_tmp13_ = strv;
				_tmp13__length1 = strv_length1;
				if (!(_tmp12_ < _tmp13__length1)) {
					break;
				}
				_tmp14_ = strv;
				_tmp14__length1 = strv_length1;
				_tmp15_ = i;
				_tmp16_ = _tmp14_[_tmp15_];
				_tmp18_ = _tmp17_ = g_strsplit (_tmp16_, ";", 2);
				text_annotation = _tmp18_;
				text_annotation_length1 = _vala_array_length (_tmp17_);
				_text_annotation_size_ = text_annotation_length1;
				_tmp19_ = text_annotation;
				_tmp19__length1 = text_annotation_length1;
				if (_tmp19__length1 == 2) {
					gchar** _tmp20_;
					gint _tmp20__length1;
					const gchar* _tmp21_;
					gchar* _tmp22_;
					gchar** _tmp23_;
					gint _tmp23__length1;
					const gchar* _tmp24_;
					gchar* _tmp25_;
					_tmp20_ = text_annotation;
					_tmp20__length1 = text_annotation_length1;
					_tmp21_ = _tmp20_[0];
					_tmp22_ = g_strdup (_tmp21_);
					_g_free0 (text);
					text = _tmp22_;
					_tmp23_ = text_annotation;
					_tmp23__length1 = text_annotation_length1;
					_tmp24_ = _tmp23_[1];
					_tmp25_ = g_strdup (_tmp24_);
					_g_free0 (annotation);
					annotation = _tmp25_;
				} else {
					gchar** _tmp26_;
					gint _tmp26__length1;
					gint _tmp27_;
					const gchar* _tmp28_;
					gchar* _tmp29_;
					_tmp26_ = strv;
					_tmp26__length1 = strv_length1;
					_tmp27_ = i;
					_tmp28_ = _tmp26_[_tmp27_];
					_tmp29_ = g_strdup (_tmp28_);
					_g_free0 (text);
					text = _tmp29_;
					_g_free0 (annotation);
					annotation = NULL;
				}
				_tmp30_ = candidates;
				_tmp30__length1 = candidates_length1;
				_tmp31_ = i;
				_tmp32_ = midasi;
				_tmp33_ = okuri;
				_tmp34_ = text;
				_tmp35_ = annotation;
				_tmp36_ = skk_candidate_new (_tmp32_, _tmp33_, _tmp34_, _tmp35_, NULL);
				_g_object_unref0 (_tmp30_[_tmp31_]);
				_tmp30_[_tmp31_] = _tmp36_;
				_tmp37_ = _tmp30_[_tmp31_];
				_g_free0 (annotation);
				_g_free0 (text);
				text_annotation = (_vala_array_free (text_annotation, text_annotation_length1, (GDestroyNotify) g_free), NULL);
			}
		}
	}
	_tmp38_ = candidates;
	_tmp38__length1 = candidates_length1;
	if (result_length1) {
		*result_length1 = _tmp38__length1;
	}
	result = _tmp38_;
	strv = (_vala_array_free (strv, strv_length1, (GDestroyNotify) g_free), NULL);
	return result;
}


/**
         * Format an array of Candidates to be saved in a dictionary file.
         *
         * @param candidates an array of Candidate
         * @return a string
         */
static gchar* _vala_g_strjoinv (const gchar* separator, gchar** str_array, int str_array_length1) {
	gchar* result = NULL;
	const gchar* _tmp0_;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gchar** _tmp3_;
	gint _tmp3__length1;
	_tmp0_ = separator;
	if (_tmp0_ == NULL) {
		separator = "";
	}
	_tmp3_ = str_array;
	_tmp3__length1 = str_array_length1;
	if (_tmp3_ != NULL) {
		_tmp2_ = TRUE;
	} else {
		gchar** _tmp4_;
		gint _tmp4__length1;
		_tmp4_ = str_array;
		_tmp4__length1 = str_array_length1;
		_tmp2_ = _tmp4__length1 > 0;
	}
	if (_tmp2_) {
		_tmp1_ = TRUE;
	} else {
		gboolean _tmp5_ = FALSE;
		gchar** _tmp6_;
		gint _tmp6__length1;
		_tmp6_ = str_array;
		_tmp6__length1 = str_array_length1;
		if (_tmp6__length1 == -1) {
			gchar** _tmp7_;
			gint _tmp7__length1;
			const gchar* _tmp8_;
			_tmp7_ = str_array;
			_tmp7__length1 = str_array_length1;
			_tmp8_ = _tmp7_[0];
			_tmp5_ = _tmp8_ != NULL;
		} else {
			_tmp5_ = FALSE;
		}
		_tmp1_ = _tmp5_;
	}
	if (_tmp1_) {
		gint i = 0;
		gsize len = 0UL;
		gint _tmp31_;
		gint _tmp33_;
		gint _tmp34_;
		gsize _tmp35_;
		const gchar* _tmp36_;
		gint _tmp37_;
		gint _tmp38_;
		gint _tmp39_;
		const gchar* res = NULL;
		gsize _tmp40_;
		void* _tmp41_;
		void* ptr = NULL;
		const gchar* _tmp42_;
		gchar** _tmp43_;
		gint _tmp43__length1;
		const gchar* _tmp44_;
		void* _tmp45_;
		const gchar* _tmp62_;
		len = (gsize) 1;
		{
			gboolean _tmp9_ = FALSE;
			i = 0;
			_tmp9_ = TRUE;
			while (TRUE) {
				gboolean _tmp11_ = FALSE;
				gboolean _tmp12_ = FALSE;
				gchar** _tmp13_;
				gint _tmp13__length1;
				gint _tmp21_ = 0;
				gchar** _tmp22_;
				gint _tmp22__length1;
				gint _tmp23_;
				const gchar* _tmp24_;
				gsize _tmp30_;
				if (!_tmp9_) {
					gint _tmp10_;
					_tmp10_ = i;
					i = _tmp10_ + 1;
				}
				_tmp9_ = FALSE;
				_tmp13_ = str_array;
				_tmp13__length1 = str_array_length1;
				if (_tmp13__length1 != -1) {
					gint _tmp14_;
					gchar** _tmp15_;
					gint _tmp15__length1;
					_tmp14_ = i;
					_tmp15_ = str_array;
					_tmp15__length1 = str_array_length1;
					_tmp12_ = _tmp14_ < _tmp15__length1;
				} else {
					_tmp12_ = FALSE;
				}
				if (_tmp12_) {
					_tmp11_ = TRUE;
				} else {
					gboolean _tmp16_ = FALSE;
					gchar** _tmp17_;
					gint _tmp17__length1;
					_tmp17_ = str_array;
					_tmp17__length1 = str_array_length1;
					if (_tmp17__length1 == -1) {
						gchar** _tmp18_;
						gint _tmp18__length1;
						gint _tmp19_;
						const gchar* _tmp20_;
						_tmp18_ = str_array;
						_tmp18__length1 = str_array_length1;
						_tmp19_ = i;
						_tmp20_ = _tmp18_[_tmp19_];
						_tmp16_ = _tmp20_ != NULL;
					} else {
						_tmp16_ = FALSE;
					}
					_tmp11_ = _tmp16_;
				}
				if (!_tmp11_) {
					break;
				}
				_tmp22_ = str_array;
				_tmp22__length1 = str_array_length1;
				_tmp23_ = i;
				_tmp24_ = _tmp22_[_tmp23_];
				if (_tmp24_ != NULL) {
					gchar** _tmp25_;
					gint _tmp25__length1;
					gint _tmp26_;
					const gchar* _tmp27_;
					gint _tmp28_;
					gint _tmp29_;
					_tmp25_ = str_array;
					_tmp25__length1 = str_array_length1;
					_tmp26_ = i;
					_tmp27_ = _tmp25_[_tmp26_];
					_tmp28_ = strlen ((const gchar*) _tmp27_);
					_tmp29_ = _tmp28_;
					_tmp21_ = _tmp29_;
				} else {
					_tmp21_ = 0;
				}
				_tmp30_ = len;
				len = _tmp30_ + _tmp21_;
			}
		}
		_tmp31_ = i;
		if (_tmp31_ == 0) {
			gchar* _tmp32_;
			_tmp32_ = g_strdup ("");
			result = _tmp32_;
			return result;
		}
		_tmp33_ = i;
		str_array_length1 = _tmp33_;
		_tmp34_ = str_array_length1;
		_tmp35_ = len;
		_tmp36_ = separator;
		_tmp37_ = strlen ((const gchar*) _tmp36_);
		_tmp38_ = _tmp37_;
		_tmp39_ = i;
		len = _tmp35_ + (_tmp38_ * (_tmp39_ - 1));
		_tmp40_ = len;
		_tmp41_ = g_malloc (_tmp40_);
		res = _tmp41_;
		_tmp42_ = res;
		_tmp43_ = str_array;
		_tmp43__length1 = str_array_length1;
		_tmp44_ = _tmp43_[0];
		_tmp45_ = g_stpcpy ((void*) _tmp42_, (const gchar*) _tmp44_);
		ptr = _tmp45_;
		{
			gboolean _tmp46_ = FALSE;
			i = 1;
			_tmp46_ = TRUE;
			while (TRUE) {
				gint _tmp48_;
				gchar** _tmp49_;
				gint _tmp49__length1;
				void* _tmp50_;
				const gchar* _tmp51_;
				void* _tmp52_;
				const gchar* _tmp53_ = NULL;
				gchar** _tmp54_;
				gint _tmp54__length1;
				gint _tmp55_;
				const gchar* _tmp56_;
				void* _tmp60_;
				void* _tmp61_;
				if (!_tmp46_) {
					gint _tmp47_;
					_tmp47_ = i;
					i = _tmp47_ + 1;
				}
				_tmp46_ = FALSE;
				_tmp48_ = i;
				_tmp49_ = str_array;
				_tmp49__length1 = str_array_length1;
				if (!(_tmp48_ < _tmp49__length1)) {
					break;
				}
				_tmp50_ = ptr;
				_tmp51_ = separator;
				_tmp52_ = g_stpcpy (_tmp50_, (const gchar*) _tmp51_);
				ptr = _tmp52_;
				_tmp54_ = str_array;
				_tmp54__length1 = str_array_length1;
				_tmp55_ = i;
				_tmp56_ = _tmp54_[_tmp55_];
				if (_tmp56_ != NULL) {
					gchar** _tmp57_;
					gint _tmp57__length1;
					gint _tmp58_;
					const gchar* _tmp59_;
					_tmp57_ = str_array;
					_tmp57__length1 = str_array_length1;
					_tmp58_ = i;
					_tmp59_ = _tmp57_[_tmp58_];
					_tmp53_ = (const gchar*) _tmp59_;
				} else {
					_tmp53_ = "";
				}
				_tmp60_ = ptr;
				_tmp61_ = g_stpcpy (_tmp60_, _tmp53_);
				ptr = _tmp61_;
			}
		}
		_tmp62_ = res;
		res = NULL;
		result = (gchar*) _tmp62_;
		return result;
	} else {
		gchar* _tmp63_;
		_tmp63_ = g_strdup ("");
		result = _tmp63_;
		return result;
	}
}


gchar* skk_dict_join_candidates (SkkDict* self, SkkCandidate** candidates, int candidates_length1) {
	gchar* result = NULL;
	gchar** strv = NULL;
	SkkCandidate** _tmp0_;
	gint _tmp0__length1;
	gchar** _tmp1_;
	gint strv_length1;
	gint _strv_size_;
	gchar** _tmp13_;
	gint _tmp13__length1;
	gchar* _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
	gchar* _tmp19_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = candidates;
	_tmp0__length1 = candidates_length1;
	_tmp1_ = g_new0 (gchar*, _tmp0__length1 + 1);
	strv = _tmp1_;
	strv_length1 = _tmp0__length1;
	_strv_size_ = strv_length1;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp2_ = FALSE;
			_tmp2_ = TRUE;
			while (TRUE) {
				gint _tmp4_;
				SkkCandidate** _tmp5_;
				gint _tmp5__length1;
				gchar** _tmp6_;
				gint _tmp6__length1;
				gint _tmp7_;
				SkkCandidate** _tmp8_;
				gint _tmp8__length1;
				gint _tmp9_;
				SkkCandidate* _tmp10_;
				gchar* _tmp11_;
				gchar* _tmp12_;
				if (!_tmp2_) {
					gint _tmp3_;
					_tmp3_ = i;
					i = _tmp3_ + 1;
				}
				_tmp2_ = FALSE;
				_tmp4_ = i;
				_tmp5_ = candidates;
				_tmp5__length1 = candidates_length1;
				if (!(_tmp4_ < _tmp5__length1)) {
					break;
				}
				_tmp6_ = strv;
				_tmp6__length1 = strv_length1;
				_tmp7_ = i;
				_tmp8_ = candidates;
				_tmp8__length1 = candidates_length1;
				_tmp9_ = i;
				_tmp10_ = _tmp8_[_tmp9_];
				_tmp11_ = skk_candidate_to_string (_tmp10_);
				_g_free0 (_tmp6_[_tmp7_]);
				_tmp6_[_tmp7_] = _tmp11_;
				_tmp12_ = _tmp6_[_tmp7_];
			}
		}
	}
	_tmp13_ = strv;
	_tmp13__length1 = strv_length1;
	_tmp14_ = _vala_g_strjoinv ("/", _tmp13_, _tmp13__length1);
	_tmp15_ = _tmp14_;
	_tmp16_ = g_strconcat ("/", _tmp15_, NULL);
	_tmp17_ = _tmp16_;
	_tmp18_ = g_strconcat (_tmp17_, "/", NULL);
	_tmp19_ = _tmp18_;
	_g_free0 (_tmp17_);
	_g_free0 (_tmp15_);
	result = _tmp19_;
	strv = (_vala_array_free (strv, strv_length1, (GDestroyNotify) g_free), NULL);
	return result;
}


/**
         * Reload the dictionary.
         *
         * @throws GLib.Error when reading the dictionary failed.
         */
static void skk_dict_real_reload (SkkDict* self, GError** error) {
	g_critical ("Type `%s' does not implement abstract method `skk_dict_reload'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}


void skk_dict_reload (SkkDict* self, GError** error) {
	g_return_if_fail (self != NULL);
	SKK_DICT_GET_CLASS (self)->reload (self, error);
}


/**
         * Lookup candidates in the dictionary.
         *
         * @param midasi a midasi (title) string to lookup
         * @param okuri whether to search okuri-ari entries or
         * okuri-nasi entries
         *
         * @return an array of Candidate
         */
static SkkCandidate** skk_dict_real_lookup (SkkDict* self, const gchar* midasi, gboolean okuri, int* result_length1) {
	g_critical ("Type `%s' does not implement abstract method `skk_dict_lookup'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}


SkkCandidate** skk_dict_lookup (SkkDict* self, const gchar* midasi, gboolean okuri, int* result_length1) {
	g_return_val_if_fail (self != NULL, NULL);
	return SKK_DICT_GET_CLASS (self)->lookup (self, midasi, okuri, result_length1);
}


/**
         * Return an array of strings which matches midasi.
         *
         * @param midasi a midasi (title) string to lookup
         *
         * @return an array of strings
         */
static gchar** skk_dict_real_complete (SkkDict* self, const gchar* midasi, int* result_length1) {
	g_critical ("Type `%s' does not implement abstract method `skk_dict_complete'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}


gchar** skk_dict_complete (SkkDict* self, const gchar* midasi, int* result_length1) {
	g_return_val_if_fail (self != NULL, NULL);
	return SKK_DICT_GET_CLASS (self)->complete (self, midasi, result_length1);
}


/**
         * Select a candidate in the dictionary.
         *
         * @param candidate an Candidate
         *
         * @return `true` if the dictionary is modified, `false` otherwise.
         */
static gboolean skk_dict_real_select_candidate (SkkDict* self, SkkCandidate* candidate) {
	gboolean result = FALSE;
	g_return_val_if_fail (candidate != NULL, FALSE);
	result = FALSE;
	return result;
}


gboolean skk_dict_select_candidate (SkkDict* self, SkkCandidate* candidate) {
	g_return_val_if_fail (self != NULL, FALSE);
	return SKK_DICT_GET_CLASS (self)->select_candidate (self, candidate);
}


/**
         * Purge a candidate in the dictionary.
         *
         * @param candidate an Candidate
         *
         * @return `true` if the dictionary is modified, `false` otherwise.
         */
static gboolean skk_dict_real_purge_candidate (SkkDict* self, SkkCandidate* candidate) {
	gboolean result = FALSE;
	g_return_val_if_fail (candidate != NULL, FALSE);
	result = FALSE;
	return result;
}


gboolean skk_dict_purge_candidate (SkkDict* self, SkkCandidate* candidate) {
	g_return_val_if_fail (self != NULL, FALSE);
	return SKK_DICT_GET_CLASS (self)->purge_candidate (self, candidate);
}


/**
         * Save the dictionary on disk.
         *
         * @throws GLib.Error if the dictionary cannot be saved.
         */
static void skk_dict_real_save (SkkDict* self, GError** error) {
}


void skk_dict_save (SkkDict* self, GError** error) {
	g_return_if_fail (self != NULL);
	SKK_DICT_GET_CLASS (self)->save (self, error);
}


SkkDict* skk_dict_construct (GType object_type) {
	SkkDict * self = NULL;
	self = (SkkDict*) g_object_new (object_type, NULL);
	return self;
}


gboolean skk_dict_get_read_only (SkkDict* self) {
	g_return_val_if_fail (self != NULL, FALSE);
	return SKK_DICT_GET_CLASS (self)->get_read_only (self);
}


static void skk_dict_class_init (SkkDictClass * klass) {
	skk_dict_parent_class = g_type_class_peek_parent (klass);
	((SkkDictClass *) klass)->reload = (void (*) (SkkDict *, GError**)) skk_dict_real_reload;
	((SkkDictClass *) klass)->lookup = (SkkCandidate** (*) (SkkDict *, const gchar*, gboolean, int*)) skk_dict_real_lookup;
	((SkkDictClass *) klass)->complete = (gchar** (*) (SkkDict *, const gchar*, int*)) skk_dict_real_complete;
	((SkkDictClass *) klass)->select_candidate = (gboolean (*) (SkkDict *, SkkCandidate*)) skk_dict_real_select_candidate;
	((SkkDictClass *) klass)->purge_candidate = (gboolean (*) (SkkDict *, SkkCandidate*)) skk_dict_real_purge_candidate;
	((SkkDictClass *) klass)->save = (void (*) (SkkDict *, GError**)) skk_dict_real_save;
	G_OBJECT_CLASS (klass)->get_property = _vala_skk_dict_get_property;
	/**
	         * Flag to indicate whether the dictionary is read only.
	         */
	g_object_class_install_property (G_OBJECT_CLASS (klass), SKK_DICT_READ_ONLY_PROPERTY, skk_dict_properties[SKK_DICT_READ_ONLY_PROPERTY] = g_param_spec_boolean ("read-only", "read-only", "read-only", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
}


static void skk_dict_instance_init (SkkDict * self) {
}


/**
     * Base abstract class of dictionaries.
     */
GType skk_dict_get_type (void) {
	static volatile gsize skk_dict_type_id__volatile = 0;
	if (g_once_init_enter (&skk_dict_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SkkDictClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) skk_dict_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SkkDict), 0, (GInstanceInitFunc) skk_dict_instance_init, NULL };
		GType skk_dict_type_id;
		skk_dict_type_id = g_type_register_static (G_TYPE_OBJECT, "SkkDict", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
		g_once_init_leave (&skk_dict_type_id__volatile, skk_dict_type_id);
	}
	return skk_dict_type_id__volatile;
}


static void _vala_skk_dict_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	SkkDict * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SKK_TYPE_DICT, SkkDict);
	switch (property_id) {
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


/**
         * {@inheritDoc}
         */
static void skk_empty_dict_real_reload (SkkDict* base, GError** error) {
	SkkEmptyDict * self;
	self = (SkkEmptyDict*) base;
}


/**
         * {@inheritDoc}
         */
static SkkCandidate** skk_empty_dict_real_lookup (SkkDict* base, const gchar* midasi, gboolean okuri, int* result_length1) {
	SkkEmptyDict * self;
	SkkCandidate** result = NULL;
	SkkCandidate** _tmp0_;
	SkkCandidate** _tmp1_;
	gint _tmp1__length1;
	self = (SkkEmptyDict*) base;
	g_return_val_if_fail (midasi != NULL, NULL);
	_tmp0_ = g_new0 (SkkCandidate*, 0 + 1);
	_tmp1_ = _tmp0_;
	_tmp1__length1 = 0;
	if (result_length1) {
		*result_length1 = _tmp1__length1;
	}
	result = _tmp1_;
	return result;
}


/**
         * {@inheritDoc}
         */
static gchar** skk_empty_dict_real_complete (SkkDict* base, const gchar* midasi, int* result_length1) {
	SkkEmptyDict * self;
	gchar** result = NULL;
	gchar** _tmp0_;
	gchar** _tmp1_;
	gint _tmp1__length1;
	self = (SkkEmptyDict*) base;
	g_return_val_if_fail (midasi != NULL, NULL);
	_tmp0_ = g_new0 (gchar*, 0 + 1);
	_tmp1_ = _tmp0_;
	_tmp1__length1 = 0;
	if (result_length1) {
		*result_length1 = _tmp1__length1;
	}
	result = _tmp1_;
	return result;
}


SkkEmptyDict* skk_empty_dict_construct (GType object_type) {
	SkkEmptyDict * self = NULL;
	self = (SkkEmptyDict*) skk_dict_construct (object_type);
	return self;
}


SkkEmptyDict* skk_empty_dict_new (void) {
	return skk_empty_dict_construct (SKK_TYPE_EMPTY_DICT);
}


static gboolean skk_empty_dict_real_get_read_only (SkkDict* base) {
	gboolean result;
	SkkEmptyDict* self;
	self = (SkkEmptyDict*) base;
	result = TRUE;
	return result;
}


static void skk_empty_dict_class_init (SkkEmptyDictClass * klass) {
	skk_empty_dict_parent_class = g_type_class_peek_parent (klass);
	((SkkDictClass *) klass)->reload = (void (*) (SkkDict *, GError**)) skk_empty_dict_real_reload;
	((SkkDictClass *) klass)->lookup = (SkkCandidate** (*) (SkkDict *, const gchar*, gboolean, int*)) skk_empty_dict_real_lookup;
	((SkkDictClass *) klass)->complete = (gchar** (*) (SkkDict *, const gchar*, int*)) skk_empty_dict_real_complete;
	SKK_DICT_CLASS (klass)->get_read_only = skk_empty_dict_real_get_read_only;
	G_OBJECT_CLASS (klass)->get_property = _vala_skk_empty_dict_get_property;
	/**
	         * {@inheritDoc}
	         */
	g_object_class_install_property (G_OBJECT_CLASS (klass), SKK_EMPTY_DICT_READ_ONLY_PROPERTY, skk_empty_dict_properties[SKK_EMPTY_DICT_READ_ONLY_PROPERTY] = g_param_spec_boolean ("read-only", "read-only", "read-only", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
}


static void skk_empty_dict_instance_init (SkkEmptyDict * self) {
}


/**
     * Null implementation of Dict.
     */
GType skk_empty_dict_get_type (void) {
	static volatile gsize skk_empty_dict_type_id__volatile = 0;
	if (g_once_init_enter (&skk_empty_dict_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SkkEmptyDictClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) skk_empty_dict_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SkkEmptyDict), 0, (GInstanceInitFunc) skk_empty_dict_instance_init, NULL };
		GType skk_empty_dict_type_id;
		skk_empty_dict_type_id = g_type_register_static (SKK_TYPE_DICT, "SkkEmptyDict", &g_define_type_info, 0);
		g_once_init_leave (&skk_empty_dict_type_id__volatile, skk_empty_dict_type_id);
	}
	return skk_empty_dict_type_id__volatile;
}


static void _vala_skk_empty_dict_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	SkkEmptyDict * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SKK_TYPE_EMPTY_DICT, SkkEmptyDict);
	switch (property_id) {
		case SKK_EMPTY_DICT_READ_ONLY_PROPERTY:
		g_value_set_boolean (value, skk_dict_get_read_only ((SkkDict*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


GQuark skk_skk_dict_error_quark (void) {
	return g_quark_from_static_string ("skk_skk_dict_error-quark");
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



