// Copyright 2023 LiveKit, Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.32.0
// 	protoc        v4.23.4
// source: livekit_analytics.proto

package livekit

import (
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	emptypb "google.golang.org/protobuf/types/known/emptypb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

type StreamType int32

const (
	StreamType_UPSTREAM   StreamType = 0
	StreamType_DOWNSTREAM StreamType = 1
)

// Enum value maps for StreamType.
var (
	StreamType_name = map[int32]string{
		0: "UPSTREAM",
		1: "DOWNSTREAM",
	}
	StreamType_value = map[string]int32{
		"UPSTREAM":   0,
		"DOWNSTREAM": 1,
	}
)

func (x StreamType) Enum() *StreamType {
	p := new(StreamType)
	*p = x
	return p
}

func (x StreamType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (StreamType) Descriptor() protoreflect.EnumDescriptor {
	return file_livekit_analytics_proto_enumTypes[0].Descriptor()
}

func (StreamType) Type() protoreflect.EnumType {
	return &file_livekit_analytics_proto_enumTypes[0]
}

func (x StreamType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use StreamType.Descriptor instead.
func (StreamType) EnumDescriptor() ([]byte, []int) {
	return file_livekit_analytics_proto_rawDescGZIP(), []int{0}
}

type AnalyticsEventType int32

const (
	AnalyticsEventType_ROOM_CREATED                       AnalyticsEventType = 0
	AnalyticsEventType_ROOM_ENDED                         AnalyticsEventType = 1
	AnalyticsEventType_PARTICIPANT_JOINED                 AnalyticsEventType = 2
	AnalyticsEventType_PARTICIPANT_LEFT                   AnalyticsEventType = 3
	AnalyticsEventType_TRACK_PUBLISHED                    AnalyticsEventType = 4
	AnalyticsEventType_TRACK_PUBLISH_REQUESTED            AnalyticsEventType = 20
	AnalyticsEventType_TRACK_UNPUBLISHED                  AnalyticsEventType = 5
	AnalyticsEventType_TRACK_SUBSCRIBED                   AnalyticsEventType = 6
	AnalyticsEventType_TRACK_SUBSCRIBE_REQUESTED          AnalyticsEventType = 21
	AnalyticsEventType_TRACK_SUBSCRIBE_FAILED             AnalyticsEventType = 25
	AnalyticsEventType_TRACK_UNSUBSCRIBED                 AnalyticsEventType = 7
	AnalyticsEventType_TRACK_PUBLISHED_UPDATE             AnalyticsEventType = 10
	AnalyticsEventType_TRACK_MUTED                        AnalyticsEventType = 23
	AnalyticsEventType_TRACK_UNMUTED                      AnalyticsEventType = 24
	AnalyticsEventType_TRACK_PUBLISH_STATS                AnalyticsEventType = 26
	AnalyticsEventType_TRACK_SUBSCRIBE_STATS              AnalyticsEventType = 27
	AnalyticsEventType_PARTICIPANT_ACTIVE                 AnalyticsEventType = 11
	AnalyticsEventType_PARTICIPANT_RESUMED                AnalyticsEventType = 22
	AnalyticsEventType_EGRESS_STARTED                     AnalyticsEventType = 12
	AnalyticsEventType_EGRESS_ENDED                       AnalyticsEventType = 13
	AnalyticsEventType_EGRESS_UPDATED                     AnalyticsEventType = 28
	AnalyticsEventType_TRACK_MAX_SUBSCRIBED_VIDEO_QUALITY AnalyticsEventType = 14
	AnalyticsEventType_RECONNECTED                        AnalyticsEventType = 15
	AnalyticsEventType_INGRESS_CREATED                    AnalyticsEventType = 18
	AnalyticsEventType_INGRESS_DELETED                    AnalyticsEventType = 19
	AnalyticsEventType_INGRESS_STARTED                    AnalyticsEventType = 16
	AnalyticsEventType_INGRESS_ENDED                      AnalyticsEventType = 17
	AnalyticsEventType_INGRESS_UPDATED                    AnalyticsEventType = 29
)

// Enum value maps for AnalyticsEventType.
var (
	AnalyticsEventType_name = map[int32]string{
		0:  "ROOM_CREATED",
		1:  "ROOM_ENDED",
		2:  "PARTICIPANT_JOINED",
		3:  "PARTICIPANT_LEFT",
		4:  "TRACK_PUBLISHED",
		20: "TRACK_PUBLISH_REQUESTED",
		5:  "TRACK_UNPUBLISHED",
		6:  "TRACK_SUBSCRIBED",
		21: "TRACK_SUBSCRIBE_REQUESTED",
		25: "TRACK_SUBSCRIBE_FAILED",
		7:  "TRACK_UNSUBSCRIBED",
		10: "TRACK_PUBLISHED_UPDATE",
		23: "TRACK_MUTED",
		24: "TRACK_UNMUTED",
		26: "TRACK_PUBLISH_STATS",
		27: "TRACK_SUBSCRIBE_STATS",
		11: "PARTICIPANT_ACTIVE",
		22: "PARTICIPANT_RESUMED",
		12: "EGRESS_STARTED",
		13: "EGRESS_ENDED",
		28: "EGRESS_UPDATED",
		14: "TRACK_MAX_SUBSCRIBED_VIDEO_QUALITY",
		15: "RECONNECTED",
		18: "INGRESS_CREATED",
		19: "INGRESS_DELETED",
		16: "INGRESS_STARTED",
		17: "INGRESS_ENDED",
		29: "INGRESS_UPDATED",
	}
	AnalyticsEventType_value = map[string]int32{
		"ROOM_CREATED":                       0,
		"ROOM_ENDED":                         1,
		"PARTICIPANT_JOINED":                 2,
		"PARTICIPANT_LEFT":                   3,
		"TRACK_PUBLISHED":                    4,
		"TRACK_PUBLISH_REQUESTED":            20,
		"TRACK_UNPUBLISHED":                  5,
		"TRACK_SUBSCRIBED":                   6,
		"TRACK_SUBSCRIBE_REQUESTED":          21,
		"TRACK_SUBSCRIBE_FAILED":             25,
		"TRACK_UNSUBSCRIBED":                 7,
		"TRACK_PUBLISHED_UPDATE":             10,
		"TRACK_MUTED":                        23,
		"TRACK_UNMUTED":                      24,
		"TRACK_PUBLISH_STATS":                26,
		"TRACK_SUBSCRIBE_STATS":              27,
		"PARTICIPANT_ACTIVE":                 11,
		"PARTICIPANT_RESUMED":                22,
		"EGRESS_STARTED":                     12,
		"EGRESS_ENDED":                       13,
		"EGRESS_UPDATED":                     28,
		"TRACK_MAX_SUBSCRIBED_VIDEO_QUALITY": 14,
		"RECONNECTED":                        15,
		"INGRESS_CREATED":                    18,
		"INGRESS_DELETED":                    19,
		"INGRESS_STARTED":                    16,
		"INGRESS_ENDED":                      17,
		"INGRESS_UPDATED":                    29,
	}
)

func (x AnalyticsEventType) Enum() *AnalyticsEventType {
	p := new(AnalyticsEventType)
	*p = x
	return p
}

func (x AnalyticsEventType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (AnalyticsEventType) Descriptor() protoreflect.EnumDescriptor {
	return file_livekit_analytics_proto_enumTypes[1].Descriptor()
}

func (AnalyticsEventType) Type() protoreflect.EnumType {
	return &file_livekit_analytics_proto_enumTypes[1]
}

func (x AnalyticsEventType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use AnalyticsEventType.Descriptor instead.
func (AnalyticsEventType) EnumDescriptor() ([]byte, []int) {
	return file_livekit_analytics_proto_rawDescGZIP(), []int{1}
}

type AnalyticsVideoLayer struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Layer   int32  `protobuf:"varint,1,opt,name=layer,proto3" json:"layer,omitempty"`
	Packets uint32 `protobuf:"varint,2,opt,name=packets,proto3" json:"packets,omitempty"`
	Bytes   uint64 `protobuf:"varint,3,opt,name=bytes,proto3" json:"bytes,omitempty"`
	Frames  uint32 `protobuf:"varint,4,opt,name=frames,proto3" json:"frames,omitempty"`
}

func (x *AnalyticsVideoLayer) Reset() {
	*x = AnalyticsVideoLayer{}
	if protoimpl.UnsafeEnabled {
		mi := &file_livekit_analytics_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AnalyticsVideoLayer) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AnalyticsVideoLayer) ProtoMessage() {}

func (x *AnalyticsVideoLayer) ProtoReflect() protoreflect.Message {
	mi := &file_livekit_analytics_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AnalyticsVideoLayer.ProtoReflect.Descriptor instead.
func (*AnalyticsVideoLayer) Descriptor() ([]byte, []int) {
	return file_livekit_analytics_proto_rawDescGZIP(), []int{0}
}

func (x *AnalyticsVideoLayer) GetLayer() int32 {
	if x != nil {
		return x.Layer
	}
	return 0
}

func (x *AnalyticsVideoLayer) GetPackets() uint32 {
	if x != nil {
		return x.Packets
	}
	return 0
}

func (x *AnalyticsVideoLayer) GetBytes() uint64 {
	if x != nil {
		return x.Bytes
	}
	return 0
}

func (x *AnalyticsVideoLayer) GetFrames() uint32 {
	if x != nil {
		return x.Frames
	}
	return 0
}

type AnalyticsStream struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Ssrc              uint32                 `protobuf:"varint,1,opt,name=ssrc,proto3" json:"ssrc,omitempty"`
	PrimaryPackets    uint32                 `protobuf:"varint,2,opt,name=primary_packets,json=primaryPackets,proto3" json:"primary_packets,omitempty"`
	PrimaryBytes      uint64                 `protobuf:"varint,3,opt,name=primary_bytes,json=primaryBytes,proto3" json:"primary_bytes,omitempty"`
	RetransmitPackets uint32                 `protobuf:"varint,4,opt,name=retransmit_packets,json=retransmitPackets,proto3" json:"retransmit_packets,omitempty"`
	RetransmitBytes   uint64                 `protobuf:"varint,5,opt,name=retransmit_bytes,json=retransmitBytes,proto3" json:"retransmit_bytes,omitempty"`
	PaddingPackets    uint32                 `protobuf:"varint,6,opt,name=padding_packets,json=paddingPackets,proto3" json:"padding_packets,omitempty"`
	PaddingBytes      uint64                 `protobuf:"varint,7,opt,name=padding_bytes,json=paddingBytes,proto3" json:"padding_bytes,omitempty"`
	PacketsLost       uint32                 `protobuf:"varint,8,opt,name=packets_lost,json=packetsLost,proto3" json:"packets_lost,omitempty"`
	Frames            uint32                 `protobuf:"varint,9,opt,name=frames,proto3" json:"frames,omitempty"`
	Rtt               uint32                 `protobuf:"varint,10,opt,name=rtt,proto3" json:"rtt,omitempty"`
	Jitter            uint32                 `protobuf:"varint,11,opt,name=jitter,proto3" json:"jitter,omitempty"`
	Nacks             uint32                 `protobuf:"varint,12,opt,name=nacks,proto3" json:"nacks,omitempty"`
	Plis              uint32                 `protobuf:"varint,13,opt,name=plis,proto3" json:"plis,omitempty"`
	Firs              uint32                 `protobuf:"varint,14,opt,name=firs,proto3" json:"firs,omitempty"`
	VideoLayers       []*AnalyticsVideoLayer `protobuf:"bytes,15,rep,name=video_layers,json=videoLayers,proto3" json:"video_layers,omitempty"`
}

func (x *AnalyticsStream) Reset() {
	*x = AnalyticsStream{}
	if protoimpl.UnsafeEnabled {
		mi := &file_livekit_analytics_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AnalyticsStream) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AnalyticsStream) ProtoMessage() {}

func (x *AnalyticsStream) ProtoReflect() protoreflect.Message {
	mi := &file_livekit_analytics_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AnalyticsStream.ProtoReflect.Descriptor instead.
func (*AnalyticsStream) Descriptor() ([]byte, []int) {
	return file_livekit_analytics_proto_rawDescGZIP(), []int{1}
}

func (x *AnalyticsStream) GetSsrc() uint32 {
	if x != nil {
		return x.Ssrc
	}
	return 0
}

func (x *AnalyticsStream) GetPrimaryPackets() uint32 {
	if x != nil {
		return x.PrimaryPackets
	}
	return 0
}

func (x *AnalyticsStream) GetPrimaryBytes() uint64 {
	if x != nil {
		return x.PrimaryBytes
	}
	return 0
}

func (x *AnalyticsStream) GetRetransmitPackets() uint32 {
	if x != nil {
		return x.RetransmitPackets
	}
	return 0
}

func (x *AnalyticsStream) GetRetransmitBytes() uint64 {
	if x != nil {
		return x.RetransmitBytes
	}
	return 0
}

func (x *AnalyticsStream) GetPaddingPackets() uint32 {
	if x != nil {
		return x.PaddingPackets
	}
	return 0
}

func (x *AnalyticsStream) GetPaddingBytes() uint64 {
	if x != nil {
		return x.PaddingBytes
	}
	return 0
}

func (x *AnalyticsStream) GetPacketsLost() uint32 {
	if x != nil {
		return x.PacketsLost
	}
	return 0
}

func (x *AnalyticsStream) GetFrames() uint32 {
	if x != nil {
		return x.Frames
	}
	return 0
}

func (x *AnalyticsStream) GetRtt() uint32 {
	if x != nil {
		return x.Rtt
	}
	return 0
}

func (x *AnalyticsStream) GetJitter() uint32 {
	if x != nil {
		return x.Jitter
	}
	return 0
}

func (x *AnalyticsStream) GetNacks() uint32 {
	if x != nil {
		return x.Nacks
	}
	return 0
}

func (x *AnalyticsStream) GetPlis() uint32 {
	if x != nil {
		return x.Plis
	}
	return 0
}

func (x *AnalyticsStream) GetFirs() uint32 {
	if x != nil {
		return x.Firs
	}
	return 0
}

func (x *AnalyticsStream) GetVideoLayers() []*AnalyticsVideoLayer {
	if x != nil {
		return x.VideoLayers
	}
	return nil
}

type AnalyticsStat struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	AnalyticsKey  string                 `protobuf:"bytes,1,opt,name=analytics_key,json=analyticsKey,proto3" json:"analytics_key,omitempty"`
	Kind          StreamType             `protobuf:"varint,2,opt,name=kind,proto3,enum=livekit.StreamType" json:"kind,omitempty"`
	TimeStamp     *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=time_stamp,json=timeStamp,proto3" json:"time_stamp,omitempty"`
	Node          string                 `protobuf:"bytes,4,opt,name=node,proto3" json:"node,omitempty"`
	RoomId        string                 `protobuf:"bytes,5,opt,name=room_id,json=roomId,proto3" json:"room_id,omitempty"`
	RoomName      string                 `protobuf:"bytes,6,opt,name=room_name,json=roomName,proto3" json:"room_name,omitempty"`
	ParticipantId string                 `protobuf:"bytes,7,opt,name=participant_id,json=participantId,proto3" json:"participant_id,omitempty"`
	TrackId       string                 `protobuf:"bytes,8,opt,name=track_id,json=trackId,proto3" json:"track_id,omitempty"`
	Score         float32                `protobuf:"fixed32,9,opt,name=score,proto3" json:"score,omitempty"` // average score
	Streams       []*AnalyticsStream     `protobuf:"bytes,10,rep,name=streams,proto3" json:"streams,omitempty"`
	Mime          string                 `protobuf:"bytes,11,opt,name=mime,proto3" json:"mime,omitempty"`
	MinScore      float32                `protobuf:"fixed32,12,opt,name=min_score,json=minScore,proto3" json:"min_score,omitempty"`
	MedianScore   float32                `protobuf:"fixed32,13,opt,name=median_score,json=medianScore,proto3" json:"median_score,omitempty"`
	ProjectId     string                 `protobuf:"bytes,14,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
}

func (x *AnalyticsStat) Reset() {
	*x = AnalyticsStat{}
	if protoimpl.UnsafeEnabled {
		mi := &file_livekit_analytics_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AnalyticsStat) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AnalyticsStat) ProtoMessage() {}

func (x *AnalyticsStat) ProtoReflect() protoreflect.Message {
	mi := &file_livekit_analytics_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AnalyticsStat.ProtoReflect.Descriptor instead.
func (*AnalyticsStat) Descriptor() ([]byte, []int) {
	return file_livekit_analytics_proto_rawDescGZIP(), []int{2}
}

func (x *AnalyticsStat) GetAnalyticsKey() string {
	if x != nil {
		return x.AnalyticsKey
	}
	return ""
}

func (x *AnalyticsStat) GetKind() StreamType {
	if x != nil {
		return x.Kind
	}
	return StreamType_UPSTREAM
}

func (x *AnalyticsStat) GetTimeStamp() *timestamppb.Timestamp {
	if x != nil {
		return x.TimeStamp
	}
	return nil
}

func (x *AnalyticsStat) GetNode() string {
	if x != nil {
		return x.Node
	}
	return ""
}

func (x *AnalyticsStat) GetRoomId() string {
	if x != nil {
		return x.RoomId
	}
	return ""
}

func (x *AnalyticsStat) GetRoomName() string {
	if x != nil {
		return x.RoomName
	}
	return ""
}

func (x *AnalyticsStat) GetParticipantId() string {
	if x != nil {
		return x.ParticipantId
	}
	return ""
}

func (x *AnalyticsStat) GetTrackId() string {
	if x != nil {
		return x.TrackId
	}
	return ""
}

func (x *AnalyticsStat) GetScore() float32 {
	if x != nil {
		return x.Score
	}
	return 0
}

func (x *AnalyticsStat) GetStreams() []*AnalyticsStream {
	if x != nil {
		return x.Streams
	}
	return nil
}

func (x *AnalyticsStat) GetMime() string {
	if x != nil {
		return x.Mime
	}
	return ""
}

func (x *AnalyticsStat) GetMinScore() float32 {
	if x != nil {
		return x.MinScore
	}
	return 0
}

func (x *AnalyticsStat) GetMedianScore() float32 {
	if x != nil {
		return x.MedianScore
	}
	return 0
}

func (x *AnalyticsStat) GetProjectId() string {
	if x != nil {
		return x.ProjectId
	}
	return ""
}

type AnalyticsStats struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Stats []*AnalyticsStat `protobuf:"bytes,1,rep,name=stats,proto3" json:"stats,omitempty"`
}

func (x *AnalyticsStats) Reset() {
	*x = AnalyticsStats{}
	if protoimpl.UnsafeEnabled {
		mi := &file_livekit_analytics_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AnalyticsStats) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AnalyticsStats) ProtoMessage() {}

func (x *AnalyticsStats) ProtoReflect() protoreflect.Message {
	mi := &file_livekit_analytics_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AnalyticsStats.ProtoReflect.Descriptor instead.
func (*AnalyticsStats) Descriptor() ([]byte, []int) {
	return file_livekit_analytics_proto_rawDescGZIP(), []int{3}
}

func (x *AnalyticsStats) GetStats() []*AnalyticsStat {
	if x != nil {
		return x.Stats
	}
	return nil
}

type AnalyticsClientMeta struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Region            string `protobuf:"bytes,1,opt,name=region,proto3" json:"region,omitempty"`
	Node              string `protobuf:"bytes,2,opt,name=node,proto3" json:"node,omitempty"`
	ClientAddr        string `protobuf:"bytes,3,opt,name=client_addr,json=clientAddr,proto3" json:"client_addr,omitempty"`
	ClientConnectTime uint32 `protobuf:"varint,4,opt,name=client_connect_time,json=clientConnectTime,proto3" json:"client_connect_time,omitempty"`
	// udp, tcp, turn
	ConnectionType  string          `protobuf:"bytes,5,opt,name=connection_type,json=connectionType,proto3" json:"connection_type,omitempty"`
	ReconnectReason ReconnectReason `protobuf:"varint,6,opt,name=reconnect_reason,json=reconnectReason,proto3,enum=livekit.ReconnectReason" json:"reconnect_reason,omitempty"`
}

func (x *AnalyticsClientMeta) Reset() {
	*x = AnalyticsClientMeta{}
	if protoimpl.UnsafeEnabled {
		mi := &file_livekit_analytics_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AnalyticsClientMeta) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AnalyticsClientMeta) ProtoMessage() {}

func (x *AnalyticsClientMeta) ProtoReflect() protoreflect.Message {
	mi := &file_livekit_analytics_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AnalyticsClientMeta.ProtoReflect.Descriptor instead.
func (*AnalyticsClientMeta) Descriptor() ([]byte, []int) {
	return file_livekit_analytics_proto_rawDescGZIP(), []int{4}
}

func (x *AnalyticsClientMeta) GetRegion() string {
	if x != nil {
		return x.Region
	}
	return ""
}

func (x *AnalyticsClientMeta) GetNode() string {
	if x != nil {
		return x.Node
	}
	return ""
}

func (x *AnalyticsClientMeta) GetClientAddr() string {
	if x != nil {
		return x.ClientAddr
	}
	return ""
}

func (x *AnalyticsClientMeta) GetClientConnectTime() uint32 {
	if x != nil {
		return x.ClientConnectTime
	}
	return 0
}

func (x *AnalyticsClientMeta) GetConnectionType() string {
	if x != nil {
		return x.ConnectionType
	}
	return ""
}

func (x *AnalyticsClientMeta) GetReconnectReason() ReconnectReason {
	if x != nil {
		return x.ReconnectReason
	}
	return ReconnectReason_RR_UNKNOWN
}

type AnalyticsEvent struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Type                      AnalyticsEventType     `protobuf:"varint,1,opt,name=type,proto3,enum=livekit.AnalyticsEventType" json:"type,omitempty"`
	Timestamp                 *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=timestamp,proto3" json:"timestamp,omitempty"`
	RoomId                    string                 `protobuf:"bytes,3,opt,name=room_id,json=roomId,proto3" json:"room_id,omitempty"`
	Room                      *Room                  `protobuf:"bytes,4,opt,name=room,proto3" json:"room,omitempty"`
	ParticipantId             string                 `protobuf:"bytes,5,opt,name=participant_id,json=participantId,proto3" json:"participant_id,omitempty"`
	Participant               *ParticipantInfo       `protobuf:"bytes,6,opt,name=participant,proto3" json:"participant,omitempty"`
	TrackId                   string                 `protobuf:"bytes,7,opt,name=track_id,json=trackId,proto3" json:"track_id,omitempty"`
	Track                     *TrackInfo             `protobuf:"bytes,8,opt,name=track,proto3" json:"track,omitempty"`
	AnalyticsKey              string                 `protobuf:"bytes,10,opt,name=analytics_key,json=analyticsKey,proto3" json:"analytics_key,omitempty"`
	ClientInfo                *ClientInfo            `protobuf:"bytes,11,opt,name=client_info,json=clientInfo,proto3" json:"client_info,omitempty"`
	ClientMeta                *AnalyticsClientMeta   `protobuf:"bytes,12,opt,name=client_meta,json=clientMeta,proto3" json:"client_meta,omitempty"`
	EgressId                  string                 `protobuf:"bytes,13,opt,name=egress_id,json=egressId,proto3" json:"egress_id,omitempty"`
	IngressId                 string                 `protobuf:"bytes,19,opt,name=ingress_id,json=ingressId,proto3" json:"ingress_id,omitempty"`
	MaxSubscribedVideoQuality VideoQuality           `protobuf:"varint,14,opt,name=max_subscribed_video_quality,json=maxSubscribedVideoQuality,proto3,enum=livekit.VideoQuality" json:"max_subscribed_video_quality,omitempty"`
	Publisher                 *ParticipantInfo       `protobuf:"bytes,15,opt,name=publisher,proto3" json:"publisher,omitempty"`
	Mime                      string                 `protobuf:"bytes,16,opt,name=mime,proto3" json:"mime,omitempty"`
	Egress                    *EgressInfo            `protobuf:"bytes,17,opt,name=egress,proto3" json:"egress,omitempty"`
	Ingress                   *IngressInfo           `protobuf:"bytes,18,opt,name=ingress,proto3" json:"ingress,omitempty"`
	Error                     string                 `protobuf:"bytes,20,opt,name=error,proto3" json:"error,omitempty"`
	RtpStats                  *RTPStats              `protobuf:"bytes,21,opt,name=rtp_stats,json=rtpStats,proto3" json:"rtp_stats,omitempty"`
	VideoLayer                int32                  `protobuf:"varint,22,opt,name=video_layer,json=videoLayer,proto3" json:"video_layer,omitempty"`
	ProjectId                 string                 `protobuf:"bytes,23,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
}

func (x *AnalyticsEvent) Reset() {
	*x = AnalyticsEvent{}
	if protoimpl.UnsafeEnabled {
		mi := &file_livekit_analytics_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AnalyticsEvent) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AnalyticsEvent) ProtoMessage() {}

func (x *AnalyticsEvent) ProtoReflect() protoreflect.Message {
	mi := &file_livekit_analytics_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AnalyticsEvent.ProtoReflect.Descriptor instead.
func (*AnalyticsEvent) Descriptor() ([]byte, []int) {
	return file_livekit_analytics_proto_rawDescGZIP(), []int{5}
}

func (x *AnalyticsEvent) GetType() AnalyticsEventType {
	if x != nil {
		return x.Type
	}
	return AnalyticsEventType_ROOM_CREATED
}

func (x *AnalyticsEvent) GetTimestamp() *timestamppb.Timestamp {
	if x != nil {
		return x.Timestamp
	}
	return nil
}

func (x *AnalyticsEvent) GetRoomId() string {
	if x != nil {
		return x.RoomId
	}
	return ""
}

func (x *AnalyticsEvent) GetRoom() *Room {
	if x != nil {
		return x.Room
	}
	return nil
}

func (x *AnalyticsEvent) GetParticipantId() string {
	if x != nil {
		return x.ParticipantId
	}
	return ""
}

func (x *AnalyticsEvent) GetParticipant() *ParticipantInfo {
	if x != nil {
		return x.Participant
	}
	return nil
}

func (x *AnalyticsEvent) GetTrackId() string {
	if x != nil {
		return x.TrackId
	}
	return ""
}

func (x *AnalyticsEvent) GetTrack() *TrackInfo {
	if x != nil {
		return x.Track
	}
	return nil
}

func (x *AnalyticsEvent) GetAnalyticsKey() string {
	if x != nil {
		return x.AnalyticsKey
	}
	return ""
}

func (x *AnalyticsEvent) GetClientInfo() *ClientInfo {
	if x != nil {
		return x.ClientInfo
	}
	return nil
}

func (x *AnalyticsEvent) GetClientMeta() *AnalyticsClientMeta {
	if x != nil {
		return x.ClientMeta
	}
	return nil
}

func (x *AnalyticsEvent) GetEgressId() string {
	if x != nil {
		return x.EgressId
	}
	return ""
}

func (x *AnalyticsEvent) GetIngressId() string {
	if x != nil {
		return x.IngressId
	}
	return ""
}

func (x *AnalyticsEvent) GetMaxSubscribedVideoQuality() VideoQuality {
	if x != nil {
		return x.MaxSubscribedVideoQuality
	}
	return VideoQuality_LOW
}

func (x *AnalyticsEvent) GetPublisher() *ParticipantInfo {
	if x != nil {
		return x.Publisher
	}
	return nil
}

func (x *AnalyticsEvent) GetMime() string {
	if x != nil {
		return x.Mime
	}
	return ""
}

func (x *AnalyticsEvent) GetEgress() *EgressInfo {
	if x != nil {
		return x.Egress
	}
	return nil
}

func (x *AnalyticsEvent) GetIngress() *IngressInfo {
	if x != nil {
		return x.Ingress
	}
	return nil
}

func (x *AnalyticsEvent) GetError() string {
	if x != nil {
		return x.Error
	}
	return ""
}

func (x *AnalyticsEvent) GetRtpStats() *RTPStats {
	if x != nil {
		return x.RtpStats
	}
	return nil
}

func (x *AnalyticsEvent) GetVideoLayer() int32 {
	if x != nil {
		return x.VideoLayer
	}
	return 0
}

func (x *AnalyticsEvent) GetProjectId() string {
	if x != nil {
		return x.ProjectId
	}
	return ""
}

type AnalyticsEvents struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Events []*AnalyticsEvent `protobuf:"bytes,1,rep,name=events,proto3" json:"events,omitempty"`
}

func (x *AnalyticsEvents) Reset() {
	*x = AnalyticsEvents{}
	if protoimpl.UnsafeEnabled {
		mi := &file_livekit_analytics_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AnalyticsEvents) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AnalyticsEvents) ProtoMessage() {}

func (x *AnalyticsEvents) ProtoReflect() protoreflect.Message {
	mi := &file_livekit_analytics_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AnalyticsEvents.ProtoReflect.Descriptor instead.
func (*AnalyticsEvents) Descriptor() ([]byte, []int) {
	return file_livekit_analytics_proto_rawDescGZIP(), []int{6}
}

func (x *AnalyticsEvents) GetEvents() []*AnalyticsEvent {
	if x != nil {
		return x.Events
	}
	return nil
}

type AnalyticsRoomParticipant struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Id       string                 `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	Identity string                 `protobuf:"bytes,2,opt,name=identity,proto3" json:"identity,omitempty"`
	Name     string                 `protobuf:"bytes,3,opt,name=name,proto3" json:"name,omitempty"`
	State    ParticipantInfo_State  `protobuf:"varint,4,opt,name=state,proto3,enum=livekit.ParticipantInfo_State" json:"state,omitempty"`
	JoinedAt *timestamppb.Timestamp `protobuf:"bytes,5,opt,name=joined_at,json=joinedAt,proto3" json:"joined_at,omitempty"`
}

func (x *AnalyticsRoomParticipant) Reset() {
	*x = AnalyticsRoomParticipant{}
	if protoimpl.UnsafeEnabled {
		mi := &file_livekit_analytics_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AnalyticsRoomParticipant) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AnalyticsRoomParticipant) ProtoMessage() {}

func (x *AnalyticsRoomParticipant) ProtoReflect() protoreflect.Message {
	mi := &file_livekit_analytics_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AnalyticsRoomParticipant.ProtoReflect.Descriptor instead.
func (*AnalyticsRoomParticipant) Descriptor() ([]byte, []int) {
	return file_livekit_analytics_proto_rawDescGZIP(), []int{7}
}

func (x *AnalyticsRoomParticipant) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *AnalyticsRoomParticipant) GetIdentity() string {
	if x != nil {
		return x.Identity
	}
	return ""
}

func (x *AnalyticsRoomParticipant) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *AnalyticsRoomParticipant) GetState() ParticipantInfo_State {
	if x != nil {
		return x.State
	}
	return ParticipantInfo_JOINING
}

func (x *AnalyticsRoomParticipant) GetJoinedAt() *timestamppb.Timestamp {
	if x != nil {
		return x.JoinedAt
	}
	return nil
}

type AnalyticsRoom struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Id           string                      `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	Name         string                      `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
	CreatedAt    *timestamppb.Timestamp      `protobuf:"bytes,3,opt,name=created_at,json=createdAt,proto3" json:"created_at,omitempty"`
	Participants []*AnalyticsRoomParticipant `protobuf:"bytes,4,rep,name=participants,proto3" json:"participants,omitempty"`
}

func (x *AnalyticsRoom) Reset() {
	*x = AnalyticsRoom{}
	if protoimpl.UnsafeEnabled {
		mi := &file_livekit_analytics_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AnalyticsRoom) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AnalyticsRoom) ProtoMessage() {}

func (x *AnalyticsRoom) ProtoReflect() protoreflect.Message {
	mi := &file_livekit_analytics_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AnalyticsRoom.ProtoReflect.Descriptor instead.
func (*AnalyticsRoom) Descriptor() ([]byte, []int) {
	return file_livekit_analytics_proto_rawDescGZIP(), []int{8}
}

func (x *AnalyticsRoom) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *AnalyticsRoom) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *AnalyticsRoom) GetCreatedAt() *timestamppb.Timestamp {
	if x != nil {
		return x.CreatedAt
	}
	return nil
}

func (x *AnalyticsRoom) GetParticipants() []*AnalyticsRoomParticipant {
	if x != nil {
		return x.Participants
	}
	return nil
}

type AnalyticsNodeRooms struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	NodeId         string                 `protobuf:"bytes,1,opt,name=node_id,json=nodeId,proto3" json:"node_id,omitempty"`
	SequenceNumber uint64                 `protobuf:"varint,2,opt,name=sequence_number,json=sequenceNumber,proto3" json:"sequence_number,omitempty"`
	Timestamp      *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=timestamp,proto3" json:"timestamp,omitempty"`
	Rooms          []*AnalyticsRoom       `protobuf:"bytes,4,rep,name=rooms,proto3" json:"rooms,omitempty"`
}

func (x *AnalyticsNodeRooms) Reset() {
	*x = AnalyticsNodeRooms{}
	if protoimpl.UnsafeEnabled {
		mi := &file_livekit_analytics_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AnalyticsNodeRooms) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AnalyticsNodeRooms) ProtoMessage() {}

func (x *AnalyticsNodeRooms) ProtoReflect() protoreflect.Message {
	mi := &file_livekit_analytics_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AnalyticsNodeRooms.ProtoReflect.Descriptor instead.
func (*AnalyticsNodeRooms) Descriptor() ([]byte, []int) {
	return file_livekit_analytics_proto_rawDescGZIP(), []int{9}
}

func (x *AnalyticsNodeRooms) GetNodeId() string {
	if x != nil {
		return x.NodeId
	}
	return ""
}

func (x *AnalyticsNodeRooms) GetSequenceNumber() uint64 {
	if x != nil {
		return x.SequenceNumber
	}
	return 0
}

func (x *AnalyticsNodeRooms) GetTimestamp() *timestamppb.Timestamp {
	if x != nil {
		return x.Timestamp
	}
	return nil
}

func (x *AnalyticsNodeRooms) GetRooms() []*AnalyticsRoom {
	if x != nil {
		return x.Rooms
	}
	return nil
}

var File_livekit_analytics_proto protoreflect.FileDescriptor

var file_livekit_analytics_proto_rawDesc = []byte{
	0x0a, 0x17, 0x6c, 0x69, 0x76, 0x65, 0x6b, 0x69, 0x74, 0x5f, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74,
	0x69, 0x63, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x07, 0x6c, 0x69, 0x76, 0x65, 0x6b,
	0x69, 0x74, 0x1a, 0x1b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2f, 0x65, 0x6d, 0x70, 0x74, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x14, 0x6c, 0x69, 0x76, 0x65, 0x6b, 0x69, 0x74, 0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x73,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x14, 0x6c, 0x69, 0x76, 0x65, 0x6b, 0x69, 0x74, 0x5f,
	0x65, 0x67, 0x72, 0x65, 0x73, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x15, 0x6c, 0x69,
	0x76, 0x65, 0x6b, 0x69, 0x74, 0x5f, 0x69, 0x6e, 0x67, 0x72, 0x65, 0x73, 0x73, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x22, 0x73, 0x0a, 0x13, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73,
	0x56, 0x69, 0x64, 0x65, 0x6f, 0x4c, 0x61, 0x79, 0x65, 0x72, 0x12, 0x14, 0x0a, 0x05, 0x6c, 0x61,
	0x79, 0x65, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x05, 0x52, 0x05, 0x6c, 0x61, 0x79, 0x65, 0x72,
	0x12, 0x18, 0x0a, 0x07, 0x70, 0x61, 0x63, 0x6b, 0x65, 0x74, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0d, 0x52, 0x07, 0x70, 0x61, 0x63, 0x6b, 0x65, 0x74, 0x73, 0x12, 0x14, 0x0a, 0x05, 0x62, 0x79,
	0x74, 0x65, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x04, 0x52, 0x05, 0x62, 0x79, 0x74, 0x65, 0x73,
	0x12, 0x16, 0x0a, 0x06, 0x66, 0x72, 0x61, 0x6d, 0x65, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0d,
	0x52, 0x06, 0x66, 0x72, 0x61, 0x6d, 0x65, 0x73, 0x22, 0xff, 0x03, 0x0a, 0x0f, 0x41, 0x6e, 0x61,
	0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x12, 0x12, 0x0a, 0x04,
	0x73, 0x73, 0x72, 0x63, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x04, 0x73, 0x73, 0x72, 0x63,
	0x12, 0x27, 0x0a, 0x0f, 0x70, 0x72, 0x69, 0x6d, 0x61, 0x72, 0x79, 0x5f, 0x70, 0x61, 0x63, 0x6b,
	0x65, 0x74, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x0e, 0x70, 0x72, 0x69, 0x6d, 0x61,
	0x72, 0x79, 0x50, 0x61, 0x63, 0x6b, 0x65, 0x74, 0x73, 0x12, 0x23, 0x0a, 0x0d, 0x70, 0x72, 0x69,
	0x6d, 0x61, 0x72, 0x79, 0x5f, 0x62, 0x79, 0x74, 0x65, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x04,
	0x52, 0x0c, 0x70, 0x72, 0x69, 0x6d, 0x61, 0x72, 0x79, 0x42, 0x79, 0x74, 0x65, 0x73, 0x12, 0x2d,
	0x0a, 0x12, 0x72, 0x65, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x6d, 0x69, 0x74, 0x5f, 0x70, 0x61, 0x63,
	0x6b, 0x65, 0x74, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x11, 0x72, 0x65, 0x74, 0x72,
	0x61, 0x6e, 0x73, 0x6d, 0x69, 0x74, 0x50, 0x61, 0x63, 0x6b, 0x65, 0x74, 0x73, 0x12, 0x29, 0x0a,
	0x10, 0x72, 0x65, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x6d, 0x69, 0x74, 0x5f, 0x62, 0x79, 0x74, 0x65,
	0x73, 0x18, 0x05, 0x20, 0x01, 0x28, 0x04, 0x52, 0x0f, 0x72, 0x65, 0x74, 0x72, 0x61, 0x6e, 0x73,
	0x6d, 0x69, 0x74, 0x42, 0x79, 0x74, 0x65, 0x73, 0x12, 0x27, 0x0a, 0x0f, 0x70, 0x61, 0x64, 0x64,
	0x69, 0x6e, 0x67, 0x5f, 0x70, 0x61, 0x63, 0x6b, 0x65, 0x74, 0x73, 0x18, 0x06, 0x20, 0x01, 0x28,
	0x0d, 0x52, 0x0e, 0x70, 0x61, 0x64, 0x64, 0x69, 0x6e, 0x67, 0x50, 0x61, 0x63, 0x6b, 0x65, 0x74,
	0x73, 0x12, 0x23, 0x0a, 0x0d, 0x70, 0x61, 0x64, 0x64, 0x69, 0x6e, 0x67, 0x5f, 0x62, 0x79, 0x74,
	0x65, 0x73, 0x18, 0x07, 0x20, 0x01, 0x28, 0x04, 0x52, 0x0c, 0x70, 0x61, 0x64, 0x64, 0x69, 0x6e,
	0x67, 0x42, 0x79, 0x74, 0x65, 0x73, 0x12, 0x21, 0x0a, 0x0c, 0x70, 0x61, 0x63, 0x6b, 0x65, 0x74,
	0x73, 0x5f, 0x6c, 0x6f, 0x73, 0x74, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x0b, 0x70, 0x61,
	0x63, 0x6b, 0x65, 0x74, 0x73, 0x4c, 0x6f, 0x73, 0x74, 0x12, 0x16, 0x0a, 0x06, 0x66, 0x72, 0x61,
	0x6d, 0x65, 0x73, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x06, 0x66, 0x72, 0x61, 0x6d, 0x65,
	0x73, 0x12, 0x10, 0x0a, 0x03, 0x72, 0x74, 0x74, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x03,
	0x72, 0x74, 0x74, 0x12, 0x16, 0x0a, 0x06, 0x6a, 0x69, 0x74, 0x74, 0x65, 0x72, 0x18, 0x0b, 0x20,
	0x01, 0x28, 0x0d, 0x52, 0x06, 0x6a, 0x69, 0x74, 0x74, 0x65, 0x72, 0x12, 0x14, 0x0a, 0x05, 0x6e,
	0x61, 0x63, 0x6b, 0x73, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x05, 0x6e, 0x61, 0x63, 0x6b,
	0x73, 0x12, 0x12, 0x0a, 0x04, 0x70, 0x6c, 0x69, 0x73, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x0d, 0x52,
	0x04, 0x70, 0x6c, 0x69, 0x73, 0x12, 0x12, 0x0a, 0x04, 0x66, 0x69, 0x72, 0x73, 0x18, 0x0e, 0x20,
	0x01, 0x28, 0x0d, 0x52, 0x04, 0x66, 0x69, 0x72, 0x73, 0x12, 0x3f, 0x0a, 0x0c, 0x76, 0x69, 0x64,
	0x65, 0x6f, 0x5f, 0x6c, 0x61, 0x79, 0x65, 0x72, 0x73, 0x18, 0x0f, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x1c, 0x2e, 0x6c, 0x69, 0x76, 0x65, 0x6b, 0x69, 0x74, 0x2e, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x74,
	0x69, 0x63, 0x73, 0x56, 0x69, 0x64, 0x65, 0x6f, 0x4c, 0x61, 0x79, 0x65, 0x72, 0x52, 0x0b, 0x76,
	0x69, 0x64, 0x65, 0x6f, 0x4c, 0x61, 0x79, 0x65, 0x72, 0x73, 0x22, 0xe1, 0x03, 0x0a, 0x0d, 0x41,
	0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x53, 0x74, 0x61, 0x74, 0x12, 0x23, 0x0a, 0x0d,
	0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x5f, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x0c, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x4b, 0x65,
	0x79, 0x12, 0x27, 0x0a, 0x04, 0x6b, 0x69, 0x6e, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32,
	0x13, 0x2e, 0x6c, 0x69, 0x76, 0x65, 0x6b, 0x69, 0x74, 0x2e, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d,
	0x54, 0x79, 0x70, 0x65, 0x52, 0x04, 0x6b, 0x69, 0x6e, 0x64, 0x12, 0x39, 0x0a, 0x0a, 0x74, 0x69,
	0x6d, 0x65, 0x5f, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x09, 0x74, 0x69, 0x6d, 0x65,
	0x53, 0x74, 0x61, 0x6d, 0x70, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x6f, 0x64, 0x65, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x6f, 0x64, 0x65, 0x12, 0x17, 0x0a, 0x07, 0x72, 0x6f, 0x6f,
	0x6d, 0x5f, 0x69, 0x64, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x72, 0x6f, 0x6f, 0x6d,
	0x49, 0x64, 0x12, 0x1b, 0x0a, 0x09, 0x72, 0x6f, 0x6f, 0x6d, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x06, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x72, 0x6f, 0x6f, 0x6d, 0x4e, 0x61, 0x6d, 0x65, 0x12,
	0x25, 0x0a, 0x0e, 0x70, 0x61, 0x72, 0x74, 0x69, 0x63, 0x69, 0x70, 0x61, 0x6e, 0x74, 0x5f, 0x69,
	0x64, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x70, 0x61, 0x72, 0x74, 0x69, 0x63, 0x69,
	0x70, 0x61, 0x6e, 0x74, 0x49, 0x64, 0x12, 0x19, 0x0a, 0x08, 0x74, 0x72, 0x61, 0x63, 0x6b, 0x5f,
	0x69, 0x64, 0x18, 0x08, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x74, 0x72, 0x61, 0x63, 0x6b, 0x49,
	0x64, 0x12, 0x14, 0x0a, 0x05, 0x73, 0x63, 0x6f, 0x72, 0x65, 0x18, 0x09, 0x20, 0x01, 0x28, 0x02,
	0x52, 0x05, 0x73, 0x63, 0x6f, 0x72, 0x65, 0x12, 0x32, 0x0a, 0x07, 0x73, 0x74, 0x72, 0x65, 0x61,
	0x6d, 0x73, 0x18, 0x0a, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x18, 0x2e, 0x6c, 0x69, 0x76, 0x65, 0x6b,
	0x69, 0x74, 0x2e, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x53, 0x74, 0x72, 0x65,
	0x61, 0x6d, 0x52, 0x07, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x73, 0x12, 0x12, 0x0a, 0x04, 0x6d,
	0x69, 0x6d, 0x65, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6d, 0x69, 0x6d, 0x65, 0x12,
	0x1b, 0x0a, 0x09, 0x6d, 0x69, 0x6e, 0x5f, 0x73, 0x63, 0x6f, 0x72, 0x65, 0x18, 0x0c, 0x20, 0x01,
	0x28, 0x02, 0x52, 0x08, 0x6d, 0x69, 0x6e, 0x53, 0x63, 0x6f, 0x72, 0x65, 0x12, 0x21, 0x0a, 0x0c,
	0x6d, 0x65, 0x64, 0x69, 0x61, 0x6e, 0x5f, 0x73, 0x63, 0x6f, 0x72, 0x65, 0x18, 0x0d, 0x20, 0x01,
	0x28, 0x02, 0x52, 0x0b, 0x6d, 0x65, 0x64, 0x69, 0x61, 0x6e, 0x53, 0x63, 0x6f, 0x72, 0x65, 0x12,
	0x1d, 0x0a, 0x0a, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x0e, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x49, 0x64, 0x22, 0x3e,
	0x0a, 0x0e, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x53, 0x74, 0x61, 0x74, 0x73,
	0x12, 0x2c, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x16, 0x2e, 0x6c, 0x69, 0x76, 0x65, 0x6b, 0x69, 0x74, 0x2e, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x74,
	0x69, 0x63, 0x73, 0x53, 0x74, 0x61, 0x74, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x73, 0x22, 0x80,
	0x02, 0x0a, 0x13, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x43, 0x6c, 0x69, 0x65,
	0x6e, 0x74, 0x4d, 0x65, 0x74, 0x61, 0x12, 0x16, 0x0a, 0x06, 0x72, 0x65, 0x67, 0x69, 0x6f, 0x6e,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x72, 0x65, 0x67, 0x69, 0x6f, 0x6e, 0x12, 0x12,
	0x0a, 0x04, 0x6e, 0x6f, 0x64, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x6f,
	0x64, 0x65, 0x12, 0x1f, 0x0a, 0x0b, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x5f, 0x61, 0x64, 0x64,
	0x72, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x41,
	0x64, 0x64, 0x72, 0x12, 0x2e, 0x0a, 0x13, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x5f, 0x63, 0x6f,
	0x6e, 0x6e, 0x65, 0x63, 0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0d,
	0x52, 0x11, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x54,
	0x69, 0x6d, 0x65, 0x12, 0x27, 0x0a, 0x0f, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0e, 0x63, 0x6f,
	0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x79, 0x70, 0x65, 0x12, 0x43, 0x0a, 0x10,
	0x72, 0x65, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x5f, 0x72, 0x65, 0x61, 0x73, 0x6f, 0x6e,
	0x18, 0x06, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x18, 0x2e, 0x6c, 0x69, 0x76, 0x65, 0x6b, 0x69, 0x74,
	0x2e, 0x52, 0x65, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x52, 0x65, 0x61, 0x73, 0x6f, 0x6e,
	0x52, 0x0f, 0x72, 0x65, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x52, 0x65, 0x61, 0x73, 0x6f,
	0x6e, 0x22, 0xbc, 0x07, 0x0a, 0x0e, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x45,
	0x76, 0x65, 0x6e, 0x74, 0x12, 0x2f, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0e, 0x32, 0x1b, 0x2e, 0x6c, 0x69, 0x76, 0x65, 0x6b, 0x69, 0x74, 0x2e, 0x41, 0x6e, 0x61,
	0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x54, 0x79, 0x70, 0x65, 0x52,
	0x04, 0x74, 0x79, 0x70, 0x65, 0x12, 0x38, 0x0a, 0x09, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61,
	0x6d, 0x70, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73,
	0x74, 0x61, 0x6d, 0x70, 0x52, 0x09, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x12,
	0x17, 0x0a, 0x07, 0x72, 0x6f, 0x6f, 0x6d, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x06, 0x72, 0x6f, 0x6f, 0x6d, 0x49, 0x64, 0x12, 0x21, 0x0a, 0x04, 0x72, 0x6f, 0x6f, 0x6d,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x0d, 0x2e, 0x6c, 0x69, 0x76, 0x65, 0x6b, 0x69, 0x74,
	0x2e, 0x52, 0x6f, 0x6f, 0x6d, 0x52, 0x04, 0x72, 0x6f, 0x6f, 0x6d, 0x12, 0x25, 0x0a, 0x0e, 0x70,
	0x61, 0x72, 0x74, 0x69, 0x63, 0x69, 0x70, 0x61, 0x6e, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x05, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x0d, 0x70, 0x61, 0x72, 0x74, 0x69, 0x63, 0x69, 0x70, 0x61, 0x6e, 0x74,
	0x49, 0x64, 0x12, 0x3a, 0x0a, 0x0b, 0x70, 0x61, 0x72, 0x74, 0x69, 0x63, 0x69, 0x70, 0x61, 0x6e,
	0x74, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x18, 0x2e, 0x6c, 0x69, 0x76, 0x65, 0x6b, 0x69,
	0x74, 0x2e, 0x50, 0x61, 0x72, 0x74, 0x69, 0x63, 0x69, 0x70, 0x61, 0x6e, 0x74, 0x49, 0x6e, 0x66,
	0x6f, 0x52, 0x0b, 0x70, 0x61, 0x72, 0x74, 0x69, 0x63, 0x69, 0x70, 0x61, 0x6e, 0x74, 0x12, 0x19,
	0x0a, 0x08, 0x74, 0x72, 0x61, 0x63, 0x6b, 0x5f, 0x69, 0x64, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x07, 0x74, 0x72, 0x61, 0x63, 0x6b, 0x49, 0x64, 0x12, 0x28, 0x0a, 0x05, 0x74, 0x72, 0x61,
	0x63, 0x6b, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x12, 0x2e, 0x6c, 0x69, 0x76, 0x65, 0x6b,
	0x69, 0x74, 0x2e, 0x54, 0x72, 0x61, 0x63, 0x6b, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x05, 0x74, 0x72,
	0x61, 0x63, 0x6b, 0x12, 0x23, 0x0a, 0x0d, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73,
	0x5f, 0x6b, 0x65, 0x79, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x61, 0x6e, 0x61, 0x6c,
	0x79, 0x74, 0x69, 0x63, 0x73, 0x4b, 0x65, 0x79, 0x12, 0x34, 0x0a, 0x0b, 0x63, 0x6c, 0x69, 0x65,
	0x6e, 0x74, 0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x13, 0x2e,
	0x6c, 0x69, 0x76, 0x65, 0x6b, 0x69, 0x74, 0x2e, 0x43, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x49, 0x6e,
	0x66, 0x6f, 0x52, 0x0a, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x3d,
	0x0a, 0x0b, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x5f, 0x6d, 0x65, 0x74, 0x61, 0x18, 0x0c, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x6c, 0x69, 0x76, 0x65, 0x6b, 0x69, 0x74, 0x2e, 0x41, 0x6e,
	0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x43, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x4d, 0x65, 0x74,
	0x61, 0x52, 0x0a, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x4d, 0x65, 0x74, 0x61, 0x12, 0x1b, 0x0a,
	0x09, 0x65, 0x67, 0x72, 0x65, 0x73, 0x73, 0x5f, 0x69, 0x64, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x08, 0x65, 0x67, 0x72, 0x65, 0x73, 0x73, 0x49, 0x64, 0x12, 0x1d, 0x0a, 0x0a, 0x69, 0x6e,
	0x67, 0x72, 0x65, 0x73, 0x73, 0x5f, 0x69, 0x64, 0x18, 0x13, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09,
	0x69, 0x6e, 0x67, 0x72, 0x65, 0x73, 0x73, 0x49, 0x64, 0x12, 0x56, 0x0a, 0x1c, 0x6d, 0x61, 0x78,
	0x5f, 0x73, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x62, 0x65, 0x64, 0x5f, 0x76, 0x69, 0x64, 0x65,
	0x6f, 0x5f, 0x71, 0x75, 0x61, 0x6c, 0x69, 0x74, 0x79, 0x18, 0x0e, 0x20, 0x01, 0x28, 0x0e, 0x32,
	0x15, 0x2e, 0x6c, 0x69, 0x76, 0x65, 0x6b, 0x69, 0x74, 0x2e, 0x56, 0x69, 0x64, 0x65, 0x6f, 0x51,
	0x75, 0x61, 0x6c, 0x69, 0x74, 0x79, 0x52, 0x19, 0x6d, 0x61, 0x78, 0x53, 0x75, 0x62, 0x73, 0x63,
	0x72, 0x69, 0x62, 0x65, 0x64, 0x56, 0x69, 0x64, 0x65, 0x6f, 0x51, 0x75, 0x61, 0x6c, 0x69, 0x74,
	0x79, 0x12, 0x36, 0x0a, 0x09, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x65, 0x72, 0x18, 0x0f,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x18, 0x2e, 0x6c, 0x69, 0x76, 0x65, 0x6b, 0x69, 0x74, 0x2e, 0x50,
	0x61, 0x72, 0x74, 0x69, 0x63, 0x69, 0x70, 0x61, 0x6e, 0x74, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x09,
	0x70, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x65, 0x72, 0x12, 0x12, 0x0a, 0x04, 0x6d, 0x69, 0x6d,
	0x65, 0x18, 0x10, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6d, 0x69, 0x6d, 0x65, 0x12, 0x2b, 0x0a,
	0x06, 0x65, 0x67, 0x72, 0x65, 0x73, 0x73, 0x18, 0x11, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x13, 0x2e,
	0x6c, 0x69, 0x76, 0x65, 0x6b, 0x69, 0x74, 0x2e, 0x45, 0x67, 0x72, 0x65, 0x73, 0x73, 0x49, 0x6e,
	0x66, 0x6f, 0x52, 0x06, 0x65, 0x67, 0x72, 0x65, 0x73, 0x73, 0x12, 0x2e, 0x0a, 0x07, 0x69, 0x6e,
	0x67, 0x72, 0x65, 0x73, 0x73, 0x18, 0x12, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x14, 0x2e, 0x6c, 0x69,
	0x76, 0x65, 0x6b, 0x69, 0x74, 0x2e, 0x49, 0x6e, 0x67, 0x72, 0x65, 0x73, 0x73, 0x49, 0x6e, 0x66,
	0x6f, 0x52, 0x07, 0x69, 0x6e, 0x67, 0x72, 0x65, 0x73, 0x73, 0x12, 0x14, 0x0a, 0x05, 0x65, 0x72,
	0x72, 0x6f, 0x72, 0x18, 0x14, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x65, 0x72, 0x72, 0x6f, 0x72,
	0x12, 0x2e, 0x0a, 0x09, 0x72, 0x74, 0x70, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x73, 0x18, 0x15, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x11, 0x2e, 0x6c, 0x69, 0x76, 0x65, 0x6b, 0x69, 0x74, 0x2e, 0x52, 0x54,
	0x50, 0x53, 0x74, 0x61, 0x74, 0x73, 0x52, 0x08, 0x72, 0x74, 0x70, 0x53, 0x74, 0x61, 0x74, 0x73,
	0x12, 0x1f, 0x0a, 0x0b, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x5f, 0x6c, 0x61, 0x79, 0x65, 0x72, 0x18,
	0x16, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0a, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x4c, 0x61, 0x79, 0x65,
	0x72, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69, 0x64, 0x18,
	0x17, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x49, 0x64,
	0x22, 0x42, 0x0a, 0x0f, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x45, 0x76, 0x65,
	0x6e, 0x74, 0x73, 0x12, 0x2f, 0x0a, 0x06, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x73, 0x18, 0x01, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x6c, 0x69, 0x76, 0x65, 0x6b, 0x69, 0x74, 0x2e, 0x41, 0x6e,
	0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x52, 0x06, 0x65, 0x76,
	0x65, 0x6e, 0x74, 0x73, 0x22, 0xc9, 0x01, 0x0a, 0x18, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69,
	0x63, 0x73, 0x52, 0x6f, 0x6f, 0x6d, 0x50, 0x61, 0x72, 0x74, 0x69, 0x63, 0x69, 0x70, 0x61, 0x6e,
	0x74, 0x12, 0x0e, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x02, 0x69,
	0x64, 0x12, 0x1a, 0x0a, 0x08, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x08, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x12, 0x12, 0x0a,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x12, 0x34, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0e,
	0x32, 0x1e, 0x2e, 0x6c, 0x69, 0x76, 0x65, 0x6b, 0x69, 0x74, 0x2e, 0x50, 0x61, 0x72, 0x74, 0x69,
	0x63, 0x69, 0x70, 0x61, 0x6e, 0x74, 0x49, 0x6e, 0x66, 0x6f, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x65,
	0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x12, 0x37, 0x0a, 0x09, 0x6a, 0x6f, 0x69, 0x6e, 0x65,
	0x64, 0x5f, 0x61, 0x74, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d,
	0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x08, 0x6a, 0x6f, 0x69, 0x6e, 0x65, 0x64, 0x41, 0x74,
	0x22, 0xb5, 0x01, 0x0a, 0x0d, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x52, 0x6f,
	0x6f, 0x6d, 0x12, 0x0e, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x02,
	0x69, 0x64, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x39, 0x0a, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65,
	0x64, 0x5f, 0x61, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d,
	0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x09, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x64, 0x41,
	0x74, 0x12, 0x45, 0x0a, 0x0c, 0x70, 0x61, 0x72, 0x74, 0x69, 0x63, 0x69, 0x70, 0x61, 0x6e, 0x74,
	0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x21, 0x2e, 0x6c, 0x69, 0x76, 0x65, 0x6b, 0x69,
	0x74, 0x2e, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x52, 0x6f, 0x6f, 0x6d, 0x50,
	0x61, 0x72, 0x74, 0x69, 0x63, 0x69, 0x70, 0x61, 0x6e, 0x74, 0x52, 0x0c, 0x70, 0x61, 0x72, 0x74,
	0x69, 0x63, 0x69, 0x70, 0x61, 0x6e, 0x74, 0x73, 0x22, 0xbe, 0x01, 0x0a, 0x12, 0x41, 0x6e, 0x61,
	0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x4e, 0x6f, 0x64, 0x65, 0x52, 0x6f, 0x6f, 0x6d, 0x73, 0x12,
	0x17, 0x0a, 0x07, 0x6e, 0x6f, 0x64, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x06, 0x6e, 0x6f, 0x64, 0x65, 0x49, 0x64, 0x12, 0x27, 0x0a, 0x0f, 0x73, 0x65, 0x71, 0x75,
	0x65, 0x6e, 0x63, 0x65, 0x5f, 0x6e, 0x75, 0x6d, 0x62, 0x65, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x04, 0x52, 0x0e, 0x73, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x63, 0x65, 0x4e, 0x75, 0x6d, 0x62, 0x65,
	0x72, 0x12, 0x38, 0x0a, 0x09, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70,
	0x52, 0x09, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x12, 0x2c, 0x0a, 0x05, 0x72,
	0x6f, 0x6f, 0x6d, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x16, 0x2e, 0x6c, 0x69, 0x76,
	0x65, 0x6b, 0x69, 0x74, 0x2e, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x52, 0x6f,
	0x6f, 0x6d, 0x52, 0x05, 0x72, 0x6f, 0x6f, 0x6d, 0x73, 0x2a, 0x2a, 0x0a, 0x0a, 0x53, 0x74, 0x72,
	0x65, 0x61, 0x6d, 0x54, 0x79, 0x70, 0x65, 0x12, 0x0c, 0x0a, 0x08, 0x55, 0x50, 0x53, 0x54, 0x52,
	0x45, 0x41, 0x4d, 0x10, 0x00, 0x12, 0x0e, 0x0a, 0x0a, 0x44, 0x4f, 0x57, 0x4e, 0x53, 0x54, 0x52,
	0x45, 0x41, 0x4d, 0x10, 0x01, 0x2a, 0x95, 0x05, 0x0a, 0x12, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x74,
	0x69, 0x63, 0x73, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x54, 0x79, 0x70, 0x65, 0x12, 0x10, 0x0a, 0x0c,
	0x52, 0x4f, 0x4f, 0x4d, 0x5f, 0x43, 0x52, 0x45, 0x41, 0x54, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0e,
	0x0a, 0x0a, 0x52, 0x4f, 0x4f, 0x4d, 0x5f, 0x45, 0x4e, 0x44, 0x45, 0x44, 0x10, 0x01, 0x12, 0x16,
	0x0a, 0x12, 0x50, 0x41, 0x52, 0x54, 0x49, 0x43, 0x49, 0x50, 0x41, 0x4e, 0x54, 0x5f, 0x4a, 0x4f,
	0x49, 0x4e, 0x45, 0x44, 0x10, 0x02, 0x12, 0x14, 0x0a, 0x10, 0x50, 0x41, 0x52, 0x54, 0x49, 0x43,
	0x49, 0x50, 0x41, 0x4e, 0x54, 0x5f, 0x4c, 0x45, 0x46, 0x54, 0x10, 0x03, 0x12, 0x13, 0x0a, 0x0f,
	0x54, 0x52, 0x41, 0x43, 0x4b, 0x5f, 0x50, 0x55, 0x42, 0x4c, 0x49, 0x53, 0x48, 0x45, 0x44, 0x10,
	0x04, 0x12, 0x1b, 0x0a, 0x17, 0x54, 0x52, 0x41, 0x43, 0x4b, 0x5f, 0x50, 0x55, 0x42, 0x4c, 0x49,
	0x53, 0x48, 0x5f, 0x52, 0x45, 0x51, 0x55, 0x45, 0x53, 0x54, 0x45, 0x44, 0x10, 0x14, 0x12, 0x15,
	0x0a, 0x11, 0x54, 0x52, 0x41, 0x43, 0x4b, 0x5f, 0x55, 0x4e, 0x50, 0x55, 0x42, 0x4c, 0x49, 0x53,
	0x48, 0x45, 0x44, 0x10, 0x05, 0x12, 0x14, 0x0a, 0x10, 0x54, 0x52, 0x41, 0x43, 0x4b, 0x5f, 0x53,
	0x55, 0x42, 0x53, 0x43, 0x52, 0x49, 0x42, 0x45, 0x44, 0x10, 0x06, 0x12, 0x1d, 0x0a, 0x19, 0x54,
	0x52, 0x41, 0x43, 0x4b, 0x5f, 0x53, 0x55, 0x42, 0x53, 0x43, 0x52, 0x49, 0x42, 0x45, 0x5f, 0x52,
	0x45, 0x51, 0x55, 0x45, 0x53, 0x54, 0x45, 0x44, 0x10, 0x15, 0x12, 0x1a, 0x0a, 0x16, 0x54, 0x52,
	0x41, 0x43, 0x4b, 0x5f, 0x53, 0x55, 0x42, 0x53, 0x43, 0x52, 0x49, 0x42, 0x45, 0x5f, 0x46, 0x41,
	0x49, 0x4c, 0x45, 0x44, 0x10, 0x19, 0x12, 0x16, 0x0a, 0x12, 0x54, 0x52, 0x41, 0x43, 0x4b, 0x5f,
	0x55, 0x4e, 0x53, 0x55, 0x42, 0x53, 0x43, 0x52, 0x49, 0x42, 0x45, 0x44, 0x10, 0x07, 0x12, 0x1a,
	0x0a, 0x16, 0x54, 0x52, 0x41, 0x43, 0x4b, 0x5f, 0x50, 0x55, 0x42, 0x4c, 0x49, 0x53, 0x48, 0x45,
	0x44, 0x5f, 0x55, 0x50, 0x44, 0x41, 0x54, 0x45, 0x10, 0x0a, 0x12, 0x0f, 0x0a, 0x0b, 0x54, 0x52,
	0x41, 0x43, 0x4b, 0x5f, 0x4d, 0x55, 0x54, 0x45, 0x44, 0x10, 0x17, 0x12, 0x11, 0x0a, 0x0d, 0x54,
	0x52, 0x41, 0x43, 0x4b, 0x5f, 0x55, 0x4e, 0x4d, 0x55, 0x54, 0x45, 0x44, 0x10, 0x18, 0x12, 0x17,
	0x0a, 0x13, 0x54, 0x52, 0x41, 0x43, 0x4b, 0x5f, 0x50, 0x55, 0x42, 0x4c, 0x49, 0x53, 0x48, 0x5f,
	0x53, 0x54, 0x41, 0x54, 0x53, 0x10, 0x1a, 0x12, 0x19, 0x0a, 0x15, 0x54, 0x52, 0x41, 0x43, 0x4b,
	0x5f, 0x53, 0x55, 0x42, 0x53, 0x43, 0x52, 0x49, 0x42, 0x45, 0x5f, 0x53, 0x54, 0x41, 0x54, 0x53,
	0x10, 0x1b, 0x12, 0x16, 0x0a, 0x12, 0x50, 0x41, 0x52, 0x54, 0x49, 0x43, 0x49, 0x50, 0x41, 0x4e,
	0x54, 0x5f, 0x41, 0x43, 0x54, 0x49, 0x56, 0x45, 0x10, 0x0b, 0x12, 0x17, 0x0a, 0x13, 0x50, 0x41,
	0x52, 0x54, 0x49, 0x43, 0x49, 0x50, 0x41, 0x4e, 0x54, 0x5f, 0x52, 0x45, 0x53, 0x55, 0x4d, 0x45,
	0x44, 0x10, 0x16, 0x12, 0x12, 0x0a, 0x0e, 0x45, 0x47, 0x52, 0x45, 0x53, 0x53, 0x5f, 0x53, 0x54,
	0x41, 0x52, 0x54, 0x45, 0x44, 0x10, 0x0c, 0x12, 0x10, 0x0a, 0x0c, 0x45, 0x47, 0x52, 0x45, 0x53,
	0x53, 0x5f, 0x45, 0x4e, 0x44, 0x45, 0x44, 0x10, 0x0d, 0x12, 0x12, 0x0a, 0x0e, 0x45, 0x47, 0x52,
	0x45, 0x53, 0x53, 0x5f, 0x55, 0x50, 0x44, 0x41, 0x54, 0x45, 0x44, 0x10, 0x1c, 0x12, 0x26, 0x0a,
	0x22, 0x54, 0x52, 0x41, 0x43, 0x4b, 0x5f, 0x4d, 0x41, 0x58, 0x5f, 0x53, 0x55, 0x42, 0x53, 0x43,
	0x52, 0x49, 0x42, 0x45, 0x44, 0x5f, 0x56, 0x49, 0x44, 0x45, 0x4f, 0x5f, 0x51, 0x55, 0x41, 0x4c,
	0x49, 0x54, 0x59, 0x10, 0x0e, 0x12, 0x0f, 0x0a, 0x0b, 0x52, 0x45, 0x43, 0x4f, 0x4e, 0x4e, 0x45,
	0x43, 0x54, 0x45, 0x44, 0x10, 0x0f, 0x12, 0x13, 0x0a, 0x0f, 0x49, 0x4e, 0x47, 0x52, 0x45, 0x53,
	0x53, 0x5f, 0x43, 0x52, 0x45, 0x41, 0x54, 0x45, 0x44, 0x10, 0x12, 0x12, 0x13, 0x0a, 0x0f, 0x49,
	0x4e, 0x47, 0x52, 0x45, 0x53, 0x53, 0x5f, 0x44, 0x45, 0x4c, 0x45, 0x54, 0x45, 0x44, 0x10, 0x13,
	0x12, 0x13, 0x0a, 0x0f, 0x49, 0x4e, 0x47, 0x52, 0x45, 0x53, 0x53, 0x5f, 0x53, 0x54, 0x41, 0x52,
	0x54, 0x45, 0x44, 0x10, 0x10, 0x12, 0x11, 0x0a, 0x0d, 0x49, 0x4e, 0x47, 0x52, 0x45, 0x53, 0x53,
	0x5f, 0x45, 0x4e, 0x44, 0x45, 0x44, 0x10, 0x11, 0x12, 0x13, 0x0a, 0x0f, 0x49, 0x4e, 0x47, 0x52,
	0x45, 0x53, 0x53, 0x5f, 0x55, 0x50, 0x44, 0x41, 0x54, 0x45, 0x44, 0x10, 0x1d, 0x32, 0xf5, 0x01,
	0x0a, 0x18, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x52, 0x65, 0x63, 0x6f, 0x72,
	0x64, 0x65, 0x72, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x12, 0x42, 0x0a, 0x0b, 0x49, 0x6e,
	0x67, 0x65, 0x73, 0x74, 0x53, 0x74, 0x61, 0x74, 0x73, 0x12, 0x17, 0x2e, 0x6c, 0x69, 0x76, 0x65,
	0x6b, 0x69, 0x74, 0x2e, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x53, 0x74, 0x61,
	0x74, 0x73, 0x1a, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x22, 0x00, 0x28, 0x01, 0x12, 0x44,
	0x0a, 0x0c, 0x49, 0x6e, 0x67, 0x65, 0x73, 0x74, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x73, 0x12, 0x18,
	0x2e, 0x6c, 0x69, 0x76, 0x65, 0x6b, 0x69, 0x74, 0x2e, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69,
	0x63, 0x73, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x73, 0x1a, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79,
	0x22, 0x00, 0x28, 0x01, 0x12, 0x4f, 0x0a, 0x14, 0x49, 0x6e, 0x67, 0x65, 0x73, 0x74, 0x4e, 0x6f,
	0x64, 0x65, 0x52, 0x6f, 0x6f, 0x6d, 0x53, 0x74, 0x61, 0x74, 0x65, 0x73, 0x12, 0x1b, 0x2e, 0x6c,
	0x69, 0x76, 0x65, 0x6b, 0x69, 0x74, 0x2e, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73,
	0x4e, 0x6f, 0x64, 0x65, 0x52, 0x6f, 0x6f, 0x6d, 0x73, 0x1a, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74,
	0x79, 0x22, 0x00, 0x28, 0x01, 0x42, 0x46, 0x5a, 0x23, 0x67, 0x69, 0x74, 0x68, 0x75, 0x62, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x6c, 0x69, 0x76, 0x65, 0x6b, 0x69, 0x74, 0x2f, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x63, 0x6f, 0x6c, 0x2f, 0x6c, 0x69, 0x76, 0x65, 0x6b, 0x69, 0x74, 0xaa, 0x02, 0x0d, 0x4c,
	0x69, 0x76, 0x65, 0x4b, 0x69, 0x74, 0x2e, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0xea, 0x02, 0x0e, 0x4c,
	0x69, 0x76, 0x65, 0x4b, 0x69, 0x74, 0x3a, 0x3a, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x06, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_livekit_analytics_proto_rawDescOnce sync.Once
	file_livekit_analytics_proto_rawDescData = file_livekit_analytics_proto_rawDesc
)

func file_livekit_analytics_proto_rawDescGZIP() []byte {
	file_livekit_analytics_proto_rawDescOnce.Do(func() {
		file_livekit_analytics_proto_rawDescData = protoimpl.X.CompressGZIP(file_livekit_analytics_proto_rawDescData)
	})
	return file_livekit_analytics_proto_rawDescData
}

var file_livekit_analytics_proto_enumTypes = make([]protoimpl.EnumInfo, 2)
var file_livekit_analytics_proto_msgTypes = make([]protoimpl.MessageInfo, 10)
var file_livekit_analytics_proto_goTypes = []interface{}{
	(StreamType)(0),                  // 0: livekit.StreamType
	(AnalyticsEventType)(0),          // 1: livekit.AnalyticsEventType
	(*AnalyticsVideoLayer)(nil),      // 2: livekit.AnalyticsVideoLayer
	(*AnalyticsStream)(nil),          // 3: livekit.AnalyticsStream
	(*AnalyticsStat)(nil),            // 4: livekit.AnalyticsStat
	(*AnalyticsStats)(nil),           // 5: livekit.AnalyticsStats
	(*AnalyticsClientMeta)(nil),      // 6: livekit.AnalyticsClientMeta
	(*AnalyticsEvent)(nil),           // 7: livekit.AnalyticsEvent
	(*AnalyticsEvents)(nil),          // 8: livekit.AnalyticsEvents
	(*AnalyticsRoomParticipant)(nil), // 9: livekit.AnalyticsRoomParticipant
	(*AnalyticsRoom)(nil),            // 10: livekit.AnalyticsRoom
	(*AnalyticsNodeRooms)(nil),       // 11: livekit.AnalyticsNodeRooms
	(*timestamppb.Timestamp)(nil),    // 12: google.protobuf.Timestamp
	(ReconnectReason)(0),             // 13: livekit.ReconnectReason
	(*Room)(nil),                     // 14: livekit.Room
	(*ParticipantInfo)(nil),          // 15: livekit.ParticipantInfo
	(*TrackInfo)(nil),                // 16: livekit.TrackInfo
	(*ClientInfo)(nil),               // 17: livekit.ClientInfo
	(VideoQuality)(0),                // 18: livekit.VideoQuality
	(*EgressInfo)(nil),               // 19: livekit.EgressInfo
	(*IngressInfo)(nil),              // 20: livekit.IngressInfo
	(*RTPStats)(nil),                 // 21: livekit.RTPStats
	(ParticipantInfo_State)(0),       // 22: livekit.ParticipantInfo.State
	(*emptypb.Empty)(nil),            // 23: google.protobuf.Empty
}
var file_livekit_analytics_proto_depIdxs = []int32{
	2,  // 0: livekit.AnalyticsStream.video_layers:type_name -> livekit.AnalyticsVideoLayer
	0,  // 1: livekit.AnalyticsStat.kind:type_name -> livekit.StreamType
	12, // 2: livekit.AnalyticsStat.time_stamp:type_name -> google.protobuf.Timestamp
	3,  // 3: livekit.AnalyticsStat.streams:type_name -> livekit.AnalyticsStream
	4,  // 4: livekit.AnalyticsStats.stats:type_name -> livekit.AnalyticsStat
	13, // 5: livekit.AnalyticsClientMeta.reconnect_reason:type_name -> livekit.ReconnectReason
	1,  // 6: livekit.AnalyticsEvent.type:type_name -> livekit.AnalyticsEventType
	12, // 7: livekit.AnalyticsEvent.timestamp:type_name -> google.protobuf.Timestamp
	14, // 8: livekit.AnalyticsEvent.room:type_name -> livekit.Room
	15, // 9: livekit.AnalyticsEvent.participant:type_name -> livekit.ParticipantInfo
	16, // 10: livekit.AnalyticsEvent.track:type_name -> livekit.TrackInfo
	17, // 11: livekit.AnalyticsEvent.client_info:type_name -> livekit.ClientInfo
	6,  // 12: livekit.AnalyticsEvent.client_meta:type_name -> livekit.AnalyticsClientMeta
	18, // 13: livekit.AnalyticsEvent.max_subscribed_video_quality:type_name -> livekit.VideoQuality
	15, // 14: livekit.AnalyticsEvent.publisher:type_name -> livekit.ParticipantInfo
	19, // 15: livekit.AnalyticsEvent.egress:type_name -> livekit.EgressInfo
	20, // 16: livekit.AnalyticsEvent.ingress:type_name -> livekit.IngressInfo
	21, // 17: livekit.AnalyticsEvent.rtp_stats:type_name -> livekit.RTPStats
	7,  // 18: livekit.AnalyticsEvents.events:type_name -> livekit.AnalyticsEvent
	22, // 19: livekit.AnalyticsRoomParticipant.state:type_name -> livekit.ParticipantInfo.State
	12, // 20: livekit.AnalyticsRoomParticipant.joined_at:type_name -> google.protobuf.Timestamp
	12, // 21: livekit.AnalyticsRoom.created_at:type_name -> google.protobuf.Timestamp
	9,  // 22: livekit.AnalyticsRoom.participants:type_name -> livekit.AnalyticsRoomParticipant
	12, // 23: livekit.AnalyticsNodeRooms.timestamp:type_name -> google.protobuf.Timestamp
	10, // 24: livekit.AnalyticsNodeRooms.rooms:type_name -> livekit.AnalyticsRoom
	5,  // 25: livekit.AnalyticsRecorderService.IngestStats:input_type -> livekit.AnalyticsStats
	8,  // 26: livekit.AnalyticsRecorderService.IngestEvents:input_type -> livekit.AnalyticsEvents
	11, // 27: livekit.AnalyticsRecorderService.IngestNodeRoomStates:input_type -> livekit.AnalyticsNodeRooms
	23, // 28: livekit.AnalyticsRecorderService.IngestStats:output_type -> google.protobuf.Empty
	23, // 29: livekit.AnalyticsRecorderService.IngestEvents:output_type -> google.protobuf.Empty
	23, // 30: livekit.AnalyticsRecorderService.IngestNodeRoomStates:output_type -> google.protobuf.Empty
	28, // [28:31] is the sub-list for method output_type
	25, // [25:28] is the sub-list for method input_type
	25, // [25:25] is the sub-list for extension type_name
	25, // [25:25] is the sub-list for extension extendee
	0,  // [0:25] is the sub-list for field type_name
}

func init() { file_livekit_analytics_proto_init() }
func file_livekit_analytics_proto_init() {
	if File_livekit_analytics_proto != nil {
		return
	}
	file_livekit_models_proto_init()
	file_livekit_egress_proto_init()
	file_livekit_ingress_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_livekit_analytics_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AnalyticsVideoLayer); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_livekit_analytics_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AnalyticsStream); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_livekit_analytics_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AnalyticsStat); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_livekit_analytics_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AnalyticsStats); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_livekit_analytics_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AnalyticsClientMeta); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_livekit_analytics_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AnalyticsEvent); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_livekit_analytics_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AnalyticsEvents); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_livekit_analytics_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AnalyticsRoomParticipant); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_livekit_analytics_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AnalyticsRoom); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_livekit_analytics_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AnalyticsNodeRooms); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_livekit_analytics_proto_rawDesc,
			NumEnums:      2,
			NumMessages:   10,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_livekit_analytics_proto_goTypes,
		DependencyIndexes: file_livekit_analytics_proto_depIdxs,
		EnumInfos:         file_livekit_analytics_proto_enumTypes,
		MessageInfos:      file_livekit_analytics_proto_msgTypes,
	}.Build()
	File_livekit_analytics_proto = out.File
	file_livekit_analytics_proto_rawDesc = nil
	file_livekit_analytics_proto_goTypes = nil
	file_livekit_analytics_proto_depIdxs = nil
}
