// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.

/// <p>The properties of the custom terminology.</p>
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::fmt::Debug)]
pub struct TerminologyProperties {
    /// <p>The name of the custom terminology.</p>
    pub name: ::std::option::Option<::std::string::String>,
    /// <p>The description of the custom terminology properties.</p>
    pub description: ::std::option::Option<::std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the custom terminology.</p>
    pub arn: ::std::option::Option<::std::string::String>,
    /// <p>The language code for the source text of the translation request for which the custom terminology is being used.</p>
    pub source_language_code: ::std::option::Option<::std::string::String>,
    /// <p>The language codes for the target languages available with the custom terminology resource. All possible target languages are returned in array.</p>
    pub target_language_codes: ::std::option::Option<::std::vec::Vec<::std::string::String>>,
    /// <p>The encryption key for the custom terminology.</p>
    pub encryption_key: ::std::option::Option<crate::types::EncryptionKey>,
    /// <p>The size of the file used when importing a custom terminology.</p>
    pub size_bytes: ::std::option::Option<i32>,
    /// <p>The number of terms included in the custom terminology.</p>
    pub term_count: ::std::option::Option<i32>,
    /// <p>The time at which the custom terminology was created, based on the timestamp.</p>
    pub created_at: ::std::option::Option<::aws_smithy_types::DateTime>,
    /// <p>The time at which the custom terminology was last update, based on the timestamp.</p>
    pub last_updated_at: ::std::option::Option<::aws_smithy_types::DateTime>,
    /// <p>The directionality of your terminology resource indicates whether it has one source language (uni-directional) or multiple (multi-directional).</p>
    /// <dl>
    /// <dt>
    /// UNI
    /// </dt>
    /// <dd>
    /// <p>The terminology resource has one source language (the first column in a CSV file), and all of its other languages are target languages.</p>
    /// </dd>
    /// <dt>
    /// MULTI
    /// </dt>
    /// <dd>
    /// <p>Any language in the terminology resource can be the source language.</p>
    /// </dd>
    /// </dl>
    pub directionality: ::std::option::Option<crate::types::Directionality>,
    /// <p>Additional information from Amazon Translate about the terminology resource.</p>
    pub message: ::std::option::Option<::std::string::String>,
    /// <p>The number of terms in the input file that Amazon Translate skipped when you created or updated the terminology resource.</p>
    pub skipped_term_count: ::std::option::Option<i32>,
    /// <p>The format of the custom terminology input file.</p>
    pub format: ::std::option::Option<crate::types::TerminologyDataFormat>,
}
impl TerminologyProperties {
    /// <p>The name of the custom terminology.</p>
    pub fn name(&self) -> ::std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The description of the custom terminology properties.</p>
    pub fn description(&self) -> ::std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the custom terminology.</p>
    pub fn arn(&self) -> ::std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The language code for the source text of the translation request for which the custom terminology is being used.</p>
    pub fn source_language_code(&self) -> ::std::option::Option<&str> {
        self.source_language_code.as_deref()
    }
    /// <p>The language codes for the target languages available with the custom terminology resource. All possible target languages are returned in array.</p>
    ///
    /// If no value was sent for this field, a default will be set. If you want to determine if no value was sent, use `.target_language_codes.is_none()`.
    pub fn target_language_codes(&self) -> &[::std::string::String] {
        self.target_language_codes.as_deref().unwrap_or_default()
    }
    /// <p>The encryption key for the custom terminology.</p>
    pub fn encryption_key(&self) -> ::std::option::Option<&crate::types::EncryptionKey> {
        self.encryption_key.as_ref()
    }
    /// <p>The size of the file used when importing a custom terminology.</p>
    pub fn size_bytes(&self) -> ::std::option::Option<i32> {
        self.size_bytes
    }
    /// <p>The number of terms included in the custom terminology.</p>
    pub fn term_count(&self) -> ::std::option::Option<i32> {
        self.term_count
    }
    /// <p>The time at which the custom terminology was created, based on the timestamp.</p>
    pub fn created_at(&self) -> ::std::option::Option<&::aws_smithy_types::DateTime> {
        self.created_at.as_ref()
    }
    /// <p>The time at which the custom terminology was last update, based on the timestamp.</p>
    pub fn last_updated_at(&self) -> ::std::option::Option<&::aws_smithy_types::DateTime> {
        self.last_updated_at.as_ref()
    }
    /// <p>The directionality of your terminology resource indicates whether it has one source language (uni-directional) or multiple (multi-directional).</p>
    /// <dl>
    /// <dt>
    /// UNI
    /// </dt>
    /// <dd>
    /// <p>The terminology resource has one source language (the first column in a CSV file), and all of its other languages are target languages.</p>
    /// </dd>
    /// <dt>
    /// MULTI
    /// </dt>
    /// <dd>
    /// <p>Any language in the terminology resource can be the source language.</p>
    /// </dd>
    /// </dl>
    pub fn directionality(&self) -> ::std::option::Option<&crate::types::Directionality> {
        self.directionality.as_ref()
    }
    /// <p>Additional information from Amazon Translate about the terminology resource.</p>
    pub fn message(&self) -> ::std::option::Option<&str> {
        self.message.as_deref()
    }
    /// <p>The number of terms in the input file that Amazon Translate skipped when you created or updated the terminology resource.</p>
    pub fn skipped_term_count(&self) -> ::std::option::Option<i32> {
        self.skipped_term_count
    }
    /// <p>The format of the custom terminology input file.</p>
    pub fn format(&self) -> ::std::option::Option<&crate::types::TerminologyDataFormat> {
        self.format.as_ref()
    }
}
impl TerminologyProperties {
    /// Creates a new builder-style object to manufacture [`TerminologyProperties`](crate::types::TerminologyProperties).
    pub fn builder() -> crate::types::builders::TerminologyPropertiesBuilder {
        crate::types::builders::TerminologyPropertiesBuilder::default()
    }
}

/// A builder for [`TerminologyProperties`](crate::types::TerminologyProperties).
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::default::Default, ::std::fmt::Debug)]
pub struct TerminologyPropertiesBuilder {
    pub(crate) name: ::std::option::Option<::std::string::String>,
    pub(crate) description: ::std::option::Option<::std::string::String>,
    pub(crate) arn: ::std::option::Option<::std::string::String>,
    pub(crate) source_language_code: ::std::option::Option<::std::string::String>,
    pub(crate) target_language_codes: ::std::option::Option<::std::vec::Vec<::std::string::String>>,
    pub(crate) encryption_key: ::std::option::Option<crate::types::EncryptionKey>,
    pub(crate) size_bytes: ::std::option::Option<i32>,
    pub(crate) term_count: ::std::option::Option<i32>,
    pub(crate) created_at: ::std::option::Option<::aws_smithy_types::DateTime>,
    pub(crate) last_updated_at: ::std::option::Option<::aws_smithy_types::DateTime>,
    pub(crate) directionality: ::std::option::Option<crate::types::Directionality>,
    pub(crate) message: ::std::option::Option<::std::string::String>,
    pub(crate) skipped_term_count: ::std::option::Option<i32>,
    pub(crate) format: ::std::option::Option<crate::types::TerminologyDataFormat>,
}
impl TerminologyPropertiesBuilder {
    /// <p>The name of the custom terminology.</p>
    pub fn name(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.name = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>The name of the custom terminology.</p>
    pub fn set_name(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.name = input;
        self
    }
    /// <p>The name of the custom terminology.</p>
    pub fn get_name(&self) -> &::std::option::Option<::std::string::String> {
        &self.name
    }
    /// <p>The description of the custom terminology properties.</p>
    pub fn description(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.description = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>The description of the custom terminology properties.</p>
    pub fn set_description(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.description = input;
        self
    }
    /// <p>The description of the custom terminology properties.</p>
    pub fn get_description(&self) -> &::std::option::Option<::std::string::String> {
        &self.description
    }
    /// <p>The Amazon Resource Name (ARN) of the custom terminology.</p>
    pub fn arn(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.arn = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>The Amazon Resource Name (ARN) of the custom terminology.</p>
    pub fn set_arn(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.arn = input;
        self
    }
    /// <p>The Amazon Resource Name (ARN) of the custom terminology.</p>
    pub fn get_arn(&self) -> &::std::option::Option<::std::string::String> {
        &self.arn
    }
    /// <p>The language code for the source text of the translation request for which the custom terminology is being used.</p>
    pub fn source_language_code(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.source_language_code = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>The language code for the source text of the translation request for which the custom terminology is being used.</p>
    pub fn set_source_language_code(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.source_language_code = input;
        self
    }
    /// <p>The language code for the source text of the translation request for which the custom terminology is being used.</p>
    pub fn get_source_language_code(&self) -> &::std::option::Option<::std::string::String> {
        &self.source_language_code
    }
    /// Appends an item to `target_language_codes`.
    ///
    /// To override the contents of this collection use [`set_target_language_codes`](Self::set_target_language_codes).
    ///
    /// <p>The language codes for the target languages available with the custom terminology resource. All possible target languages are returned in array.</p>
    pub fn target_language_codes(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        let mut v = self.target_language_codes.unwrap_or_default();
        v.push(input.into());
        self.target_language_codes = ::std::option::Option::Some(v);
        self
    }
    /// <p>The language codes for the target languages available with the custom terminology resource. All possible target languages are returned in array.</p>
    pub fn set_target_language_codes(mut self, input: ::std::option::Option<::std::vec::Vec<::std::string::String>>) -> Self {
        self.target_language_codes = input;
        self
    }
    /// <p>The language codes for the target languages available with the custom terminology resource. All possible target languages are returned in array.</p>
    pub fn get_target_language_codes(&self) -> &::std::option::Option<::std::vec::Vec<::std::string::String>> {
        &self.target_language_codes
    }
    /// <p>The encryption key for the custom terminology.</p>
    pub fn encryption_key(mut self, input: crate::types::EncryptionKey) -> Self {
        self.encryption_key = ::std::option::Option::Some(input);
        self
    }
    /// <p>The encryption key for the custom terminology.</p>
    pub fn set_encryption_key(mut self, input: ::std::option::Option<crate::types::EncryptionKey>) -> Self {
        self.encryption_key = input;
        self
    }
    /// <p>The encryption key for the custom terminology.</p>
    pub fn get_encryption_key(&self) -> &::std::option::Option<crate::types::EncryptionKey> {
        &self.encryption_key
    }
    /// <p>The size of the file used when importing a custom terminology.</p>
    pub fn size_bytes(mut self, input: i32) -> Self {
        self.size_bytes = ::std::option::Option::Some(input);
        self
    }
    /// <p>The size of the file used when importing a custom terminology.</p>
    pub fn set_size_bytes(mut self, input: ::std::option::Option<i32>) -> Self {
        self.size_bytes = input;
        self
    }
    /// <p>The size of the file used when importing a custom terminology.</p>
    pub fn get_size_bytes(&self) -> &::std::option::Option<i32> {
        &self.size_bytes
    }
    /// <p>The number of terms included in the custom terminology.</p>
    pub fn term_count(mut self, input: i32) -> Self {
        self.term_count = ::std::option::Option::Some(input);
        self
    }
    /// <p>The number of terms included in the custom terminology.</p>
    pub fn set_term_count(mut self, input: ::std::option::Option<i32>) -> Self {
        self.term_count = input;
        self
    }
    /// <p>The number of terms included in the custom terminology.</p>
    pub fn get_term_count(&self) -> &::std::option::Option<i32> {
        &self.term_count
    }
    /// <p>The time at which the custom terminology was created, based on the timestamp.</p>
    pub fn created_at(mut self, input: ::aws_smithy_types::DateTime) -> Self {
        self.created_at = ::std::option::Option::Some(input);
        self
    }
    /// <p>The time at which the custom terminology was created, based on the timestamp.</p>
    pub fn set_created_at(mut self, input: ::std::option::Option<::aws_smithy_types::DateTime>) -> Self {
        self.created_at = input;
        self
    }
    /// <p>The time at which the custom terminology was created, based on the timestamp.</p>
    pub fn get_created_at(&self) -> &::std::option::Option<::aws_smithy_types::DateTime> {
        &self.created_at
    }
    /// <p>The time at which the custom terminology was last update, based on the timestamp.</p>
    pub fn last_updated_at(mut self, input: ::aws_smithy_types::DateTime) -> Self {
        self.last_updated_at = ::std::option::Option::Some(input);
        self
    }
    /// <p>The time at which the custom terminology was last update, based on the timestamp.</p>
    pub fn set_last_updated_at(mut self, input: ::std::option::Option<::aws_smithy_types::DateTime>) -> Self {
        self.last_updated_at = input;
        self
    }
    /// <p>The time at which the custom terminology was last update, based on the timestamp.</p>
    pub fn get_last_updated_at(&self) -> &::std::option::Option<::aws_smithy_types::DateTime> {
        &self.last_updated_at
    }
    /// <p>The directionality of your terminology resource indicates whether it has one source language (uni-directional) or multiple (multi-directional).</p>
    /// <dl>
    /// <dt>
    /// UNI
    /// </dt>
    /// <dd>
    /// <p>The terminology resource has one source language (the first column in a CSV file), and all of its other languages are target languages.</p>
    /// </dd>
    /// <dt>
    /// MULTI
    /// </dt>
    /// <dd>
    /// <p>Any language in the terminology resource can be the source language.</p>
    /// </dd>
    /// </dl>
    pub fn directionality(mut self, input: crate::types::Directionality) -> Self {
        self.directionality = ::std::option::Option::Some(input);
        self
    }
    /// <p>The directionality of your terminology resource indicates whether it has one source language (uni-directional) or multiple (multi-directional).</p>
    /// <dl>
    /// <dt>
    /// UNI
    /// </dt>
    /// <dd>
    /// <p>The terminology resource has one source language (the first column in a CSV file), and all of its other languages are target languages.</p>
    /// </dd>
    /// <dt>
    /// MULTI
    /// </dt>
    /// <dd>
    /// <p>Any language in the terminology resource can be the source language.</p>
    /// </dd>
    /// </dl>
    pub fn set_directionality(mut self, input: ::std::option::Option<crate::types::Directionality>) -> Self {
        self.directionality = input;
        self
    }
    /// <p>The directionality of your terminology resource indicates whether it has one source language (uni-directional) or multiple (multi-directional).</p>
    /// <dl>
    /// <dt>
    /// UNI
    /// </dt>
    /// <dd>
    /// <p>The terminology resource has one source language (the first column in a CSV file), and all of its other languages are target languages.</p>
    /// </dd>
    /// <dt>
    /// MULTI
    /// </dt>
    /// <dd>
    /// <p>Any language in the terminology resource can be the source language.</p>
    /// </dd>
    /// </dl>
    pub fn get_directionality(&self) -> &::std::option::Option<crate::types::Directionality> {
        &self.directionality
    }
    /// <p>Additional information from Amazon Translate about the terminology resource.</p>
    pub fn message(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.message = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>Additional information from Amazon Translate about the terminology resource.</p>
    pub fn set_message(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.message = input;
        self
    }
    /// <p>Additional information from Amazon Translate about the terminology resource.</p>
    pub fn get_message(&self) -> &::std::option::Option<::std::string::String> {
        &self.message
    }
    /// <p>The number of terms in the input file that Amazon Translate skipped when you created or updated the terminology resource.</p>
    pub fn skipped_term_count(mut self, input: i32) -> Self {
        self.skipped_term_count = ::std::option::Option::Some(input);
        self
    }
    /// <p>The number of terms in the input file that Amazon Translate skipped when you created or updated the terminology resource.</p>
    pub fn set_skipped_term_count(mut self, input: ::std::option::Option<i32>) -> Self {
        self.skipped_term_count = input;
        self
    }
    /// <p>The number of terms in the input file that Amazon Translate skipped when you created or updated the terminology resource.</p>
    pub fn get_skipped_term_count(&self) -> &::std::option::Option<i32> {
        &self.skipped_term_count
    }
    /// <p>The format of the custom terminology input file.</p>
    pub fn format(mut self, input: crate::types::TerminologyDataFormat) -> Self {
        self.format = ::std::option::Option::Some(input);
        self
    }
    /// <p>The format of the custom terminology input file.</p>
    pub fn set_format(mut self, input: ::std::option::Option<crate::types::TerminologyDataFormat>) -> Self {
        self.format = input;
        self
    }
    /// <p>The format of the custom terminology input file.</p>
    pub fn get_format(&self) -> &::std::option::Option<crate::types::TerminologyDataFormat> {
        &self.format
    }
    /// Consumes the builder and constructs a [`TerminologyProperties`](crate::types::TerminologyProperties).
    pub fn build(self) -> crate::types::TerminologyProperties {
        crate::types::TerminologyProperties {
            name: self.name,
            description: self.description,
            arn: self.arn,
            source_language_code: self.source_language_code,
            target_language_codes: self.target_language_codes,
            encryption_key: self.encryption_key,
            size_bytes: self.size_bytes,
            term_count: self.term_count,
            created_at: self.created_at,
            last_updated_at: self.last_updated_at,
            directionality: self.directionality,
            message: self.message,
            skipped_term_count: self.skipped_term_count,
            format: self.format,
        }
    }
}
