// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::fmt::Debug)]
pub struct UpdateParallelDataOutput {
    /// <p>The name of the parallel data resource being updated.</p>
    pub name: ::std::option::Option<::std::string::String>,
    /// <p>The status of the parallel data resource that you are attempting to update. Your update request is accepted only if this status is either <code>ACTIVE</code> or <code>FAILED</code>.</p>
    pub status: ::std::option::Option<crate::types::ParallelDataStatus>,
    /// <p>The status of the parallel data update attempt. When the updated parallel data resource is ready for you to use, the status is <code>ACTIVE</code>.</p>
    pub latest_update_attempt_status: ::std::option::Option<crate::types::ParallelDataStatus>,
    /// <p>The time that the most recent update was attempted.</p>
    pub latest_update_attempt_at: ::std::option::Option<::aws_smithy_types::DateTime>,
    _request_id: Option<String>,
}
impl UpdateParallelDataOutput {
    /// <p>The name of the parallel data resource being updated.</p>
    pub fn name(&self) -> ::std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The status of the parallel data resource that you are attempting to update. Your update request is accepted only if this status is either <code>ACTIVE</code> or <code>FAILED</code>.</p>
    pub fn status(&self) -> ::std::option::Option<&crate::types::ParallelDataStatus> {
        self.status.as_ref()
    }
    /// <p>The status of the parallel data update attempt. When the updated parallel data resource is ready for you to use, the status is <code>ACTIVE</code>.</p>
    pub fn latest_update_attempt_status(&self) -> ::std::option::Option<&crate::types::ParallelDataStatus> {
        self.latest_update_attempt_status.as_ref()
    }
    /// <p>The time that the most recent update was attempted.</p>
    pub fn latest_update_attempt_at(&self) -> ::std::option::Option<&::aws_smithy_types::DateTime> {
        self.latest_update_attempt_at.as_ref()
    }
}
impl ::aws_types::request_id::RequestId for UpdateParallelDataOutput {
    fn request_id(&self) -> Option<&str> {
        self._request_id.as_deref()
    }
}
impl UpdateParallelDataOutput {
    /// Creates a new builder-style object to manufacture [`UpdateParallelDataOutput`](crate::operation::update_parallel_data::UpdateParallelDataOutput).
    pub fn builder() -> crate::operation::update_parallel_data::builders::UpdateParallelDataOutputBuilder {
        crate::operation::update_parallel_data::builders::UpdateParallelDataOutputBuilder::default()
    }
}

/// A builder for [`UpdateParallelDataOutput`](crate::operation::update_parallel_data::UpdateParallelDataOutput).
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::default::Default, ::std::fmt::Debug)]
pub struct UpdateParallelDataOutputBuilder {
    pub(crate) name: ::std::option::Option<::std::string::String>,
    pub(crate) status: ::std::option::Option<crate::types::ParallelDataStatus>,
    pub(crate) latest_update_attempt_status: ::std::option::Option<crate::types::ParallelDataStatus>,
    pub(crate) latest_update_attempt_at: ::std::option::Option<::aws_smithy_types::DateTime>,
    _request_id: Option<String>,
}
impl UpdateParallelDataOutputBuilder {
    /// <p>The name of the parallel data resource being updated.</p>
    pub fn name(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.name = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>The name of the parallel data resource being updated.</p>
    pub fn set_name(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.name = input;
        self
    }
    /// <p>The name of the parallel data resource being updated.</p>
    pub fn get_name(&self) -> &::std::option::Option<::std::string::String> {
        &self.name
    }
    /// <p>The status of the parallel data resource that you are attempting to update. Your update request is accepted only if this status is either <code>ACTIVE</code> or <code>FAILED</code>.</p>
    pub fn status(mut self, input: crate::types::ParallelDataStatus) -> Self {
        self.status = ::std::option::Option::Some(input);
        self
    }
    /// <p>The status of the parallel data resource that you are attempting to update. Your update request is accepted only if this status is either <code>ACTIVE</code> or <code>FAILED</code>.</p>
    pub fn set_status(mut self, input: ::std::option::Option<crate::types::ParallelDataStatus>) -> Self {
        self.status = input;
        self
    }
    /// <p>The status of the parallel data resource that you are attempting to update. Your update request is accepted only if this status is either <code>ACTIVE</code> or <code>FAILED</code>.</p>
    pub fn get_status(&self) -> &::std::option::Option<crate::types::ParallelDataStatus> {
        &self.status
    }
    /// <p>The status of the parallel data update attempt. When the updated parallel data resource is ready for you to use, the status is <code>ACTIVE</code>.</p>
    pub fn latest_update_attempt_status(mut self, input: crate::types::ParallelDataStatus) -> Self {
        self.latest_update_attempt_status = ::std::option::Option::Some(input);
        self
    }
    /// <p>The status of the parallel data update attempt. When the updated parallel data resource is ready for you to use, the status is <code>ACTIVE</code>.</p>
    pub fn set_latest_update_attempt_status(mut self, input: ::std::option::Option<crate::types::ParallelDataStatus>) -> Self {
        self.latest_update_attempt_status = input;
        self
    }
    /// <p>The status of the parallel data update attempt. When the updated parallel data resource is ready for you to use, the status is <code>ACTIVE</code>.</p>
    pub fn get_latest_update_attempt_status(&self) -> &::std::option::Option<crate::types::ParallelDataStatus> {
        &self.latest_update_attempt_status
    }
    /// <p>The time that the most recent update was attempted.</p>
    pub fn latest_update_attempt_at(mut self, input: ::aws_smithy_types::DateTime) -> Self {
        self.latest_update_attempt_at = ::std::option::Option::Some(input);
        self
    }
    /// <p>The time that the most recent update was attempted.</p>
    pub fn set_latest_update_attempt_at(mut self, input: ::std::option::Option<::aws_smithy_types::DateTime>) -> Self {
        self.latest_update_attempt_at = input;
        self
    }
    /// <p>The time that the most recent update was attempted.</p>
    pub fn get_latest_update_attempt_at(&self) -> &::std::option::Option<::aws_smithy_types::DateTime> {
        &self.latest_update_attempt_at
    }
    pub(crate) fn _request_id(mut self, request_id: impl Into<String>) -> Self {
        self._request_id = Some(request_id.into());
        self
    }

    pub(crate) fn _set_request_id(&mut self, request_id: Option<String>) -> &mut Self {
        self._request_id = request_id;
        self
    }
    /// Consumes the builder and constructs a [`UpdateParallelDataOutput`](crate::operation::update_parallel_data::UpdateParallelDataOutput).
    pub fn build(self) -> crate::operation::update_parallel_data::UpdateParallelDataOutput {
        crate::operation::update_parallel_data::UpdateParallelDataOutput {
            name: self.name,
            status: self.status,
            latest_update_attempt_status: self.latest_update_attempt_status,
            latest_update_attempt_at: self.latest_update_attempt_at,
            _request_id: self._request_id,
        }
    }
}
