// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(::std::fmt::Debug)]
pub struct StartStreamTranscriptionInput {
    /// <p>Specify the language code that represents the language spoken in your audio.</p>
    /// <p>If you're unsure of the language spoken in your audio, consider using <code>IdentifyLanguage</code> to enable automatic language identification.</p>
    /// <p>For a list of languages supported with Amazon Transcribe streaming, refer to the <a href="https://docs.aws.amazon.com/transcribe/latest/dg/supported-languages.html">Supported languages</a> table.</p>
    pub language_code: ::std::option::Option<crate::types::LanguageCode>,
    /// <p>The sample rate of the input audio (in hertz). Low-quality audio, such as telephone audio, is typically around 8,000 Hz. High-quality audio typically ranges from 16,000 Hz to 48,000 Hz. Note that the sample rate you specify must match that of your audio.</p>
    pub media_sample_rate_hertz: ::std::option::Option<i32>,
    /// <p>Specify the encoding of your input audio. Supported formats are:</p>
    /// <ul>
    /// <li>
    /// <p>FLAC</p></li>
    /// <li>
    /// <p>OPUS-encoded audio in an Ogg container</p></li>
    /// <li>
    /// <p>PCM (only signed 16-bit little-endian audio formats, which does not include WAV)</p></li>
    /// </ul>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/transcribe/latest/dg/how-input.html#how-input-audio">Media formats</a>.</p>
    pub media_encoding: ::std::option::Option<crate::types::MediaEncoding>,
    /// <p>Specify the name of the custom vocabulary that you want to use when processing your transcription. Note that vocabulary names are case sensitive.</p>
    /// <p>If the language of the specified custom vocabulary doesn't match the language identified in your media, the custom vocabulary is not applied to your transcription.</p><important>
    /// <p>This parameter is <b>not</b> intended for use with the <code>IdentifyLanguage</code> parameter. If you're including <code>IdentifyLanguage</code> in your request and want to use one or more custom vocabularies with your transcription, use the <code>VocabularyNames</code> parameter instead.</p>
    /// </important>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/transcribe/latest/dg/custom-vocabulary.html">Custom vocabularies</a>.</p>
    pub vocabulary_name: ::std::option::Option<::std::string::String>,
    /// <p>Specify a name for your transcription session. If you don't include this parameter in your request, Amazon Transcribe generates an ID and returns it in the response.</p>
    /// <p>You can use a session ID to retry a streaming session.</p>
    pub session_id: ::std::option::Option<::std::string::String>,
    /// <p>An encoded stream of audio blobs. Audio streams are encoded as either HTTP/2 or WebSocket data frames.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/transcribe/latest/dg/streaming.html">Transcribing streaming audio</a>.</p>
    pub audio_stream: ::aws_smithy_http::event_stream::EventStreamSender<crate::types::AudioStream, crate::types::error::AudioStreamError>,
    /// <p>Specify the name of the custom vocabulary filter that you want to use when processing your transcription. Note that vocabulary filter names are case sensitive.</p>
    /// <p>If the language of the specified custom vocabulary filter doesn't match the language identified in your media, the vocabulary filter is not applied to your transcription.</p><important>
    /// <p>This parameter is <b>not</b> intended for use with the <code>IdentifyLanguage</code> parameter. If you're including <code>IdentifyLanguage</code> in your request and want to use one or more vocabulary filters with your transcription, use the <code>VocabularyFilterNames</code> parameter instead.</p>
    /// </important>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/transcribe/latest/dg/vocabulary-filtering.html">Using vocabulary filtering with unwanted words</a>.</p>
    pub vocabulary_filter_name: ::std::option::Option<::std::string::String>,
    /// <p>Specify how you want your vocabulary filter applied to your transcript.</p>
    /// <p>To replace words with <code>***</code>, choose <code>mask</code>.</p>
    /// <p>To delete words, choose <code>remove</code>.</p>
    /// <p>To flag words without changing them, choose <code>tag</code>.</p>
    pub vocabulary_filter_method: ::std::option::Option<crate::types::VocabularyFilterMethod>,
    /// <p>Enables speaker partitioning (diarization) in your transcription output. Speaker partitioning labels the speech from individual speakers in your media file.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/transcribe/latest/dg/diarization.html">Partitioning speakers (diarization)</a>.</p>
    pub show_speaker_label: ::std::option::Option<bool>,
    /// <p>Enables channel identification in multi-channel audio.</p>
    /// <p>Channel identification transcribes the audio on each channel independently, then appends the output for each channel into one transcript.</p>
    /// <p>If you have multi-channel audio and do not enable channel identification, your audio is transcribed in a continuous manner and your transcript is not separated by channel.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/transcribe/latest/dg/channel-id.html">Transcribing multi-channel audio</a>.</p>
    pub enable_channel_identification: ::std::option::Option<bool>,
    /// <p>Specify the number of channels in your audio stream. Up to two channels are supported.</p>
    pub number_of_channels: ::std::option::Option<i32>,
    /// <p>Enables partial result stabilization for your transcription. Partial result stabilization can reduce latency in your output, but may impact accuracy. For more information, see <a href="https://docs.aws.amazon.com/transcribe/latest/dg/streaming.html#streaming-partial-result-stabilization">Partial-result stabilization</a>.</p>
    pub enable_partial_results_stabilization: ::std::option::Option<bool>,
    /// <p>Specify the level of stability to use when you enable partial results stabilization (<code>EnablePartialResultsStabilization</code>).</p>
    /// <p>Low stability provides the highest accuracy. High stability transcribes faster, but with slightly lower accuracy.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/transcribe/latest/dg/streaming.html#streaming-partial-result-stabilization">Partial-result stabilization</a>.</p>
    pub partial_results_stability: ::std::option::Option<crate::types::PartialResultsStability>,
    /// <p>Labels all personally identifiable information (PII) identified in your transcript.</p>
    /// <p>Content identification is performed at the segment level; PII specified in <code>PiiEntityTypes</code> is flagged upon complete transcription of an audio segment.</p>
    /// <p>You can’t set <code>ContentIdentificationType</code> and <code>ContentRedactionType</code> in the same request. If you set both, your request returns a <code>BadRequestException</code>.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/transcribe/latest/dg/pii-redaction.html">Redacting or identifying personally identifiable information</a>.</p>
    pub content_identification_type: ::std::option::Option<crate::types::ContentIdentificationType>,
    /// <p>Redacts all personally identifiable information (PII) identified in your transcript.</p>
    /// <p>Content redaction is performed at the segment level; PII specified in <code>PiiEntityTypes</code> is redacted upon complete transcription of an audio segment.</p>
    /// <p>You can’t set <code>ContentRedactionType</code> and <code>ContentIdentificationType</code> in the same request. If you set both, your request returns a <code>BadRequestException</code>.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/transcribe/latest/dg/pii-redaction.html">Redacting or identifying personally identifiable information</a>.</p>
    pub content_redaction_type: ::std::option::Option<crate::types::ContentRedactionType>,
    /// <p>Specify which types of personally identifiable information (PII) you want to redact in your transcript. You can include as many types as you'd like, or you can select <code>ALL</code>.</p>
    /// <p>To include <code>PiiEntityTypes</code> in your request, you must also include either <code>ContentIdentificationType</code> or <code>ContentRedactionType</code>.</p>
    /// <p>Values must be comma-separated and can include: <code>BANK_ACCOUNT_NUMBER</code>, <code>BANK_ROUTING</code>, <code>CREDIT_DEBIT_NUMBER</code>, <code>CREDIT_DEBIT_CVV</code>, <code>CREDIT_DEBIT_EXPIRY</code>, <code>PIN</code>, <code>EMAIL</code>, <code>ADDRESS</code>, <code>NAME</code>, <code>PHONE</code>, <code>SSN</code>, or <code>ALL</code>.</p>
    pub pii_entity_types: ::std::option::Option<::std::string::String>,
    /// <p>Specify the name of the custom language model that you want to use when processing your transcription. Note that language model names are case sensitive.</p>
    /// <p>The language of the specified language model must match the language code you specify in your transcription request. If the languages don't match, the custom language model isn't applied. There are no errors or warnings associated with a language mismatch.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/transcribe/latest/dg/custom-language-models.html">Custom language models</a>.</p>
    pub language_model_name: ::std::option::Option<::std::string::String>,
    /// <p>Enables automatic language identification for your transcription.</p>
    /// <p>If you include <code>IdentifyLanguage</code>, you can optionally include a list of language codes, using <code>LanguageOptions</code>, that you think may be present in your audio stream. Including language options can improve transcription accuracy.</p>
    /// <p>You can also include a preferred language using <code>PreferredLanguage</code>. Adding a preferred language can help Amazon Transcribe identify the language faster than if you omit this parameter.</p>
    /// <p>If you have multi-channel audio that contains different languages on each channel, and you've enabled channel identification, automatic language identification identifies the dominant language on each audio channel.</p>
    /// <p>Note that you must include either <code>LanguageCode</code> or <code>IdentifyLanguage</code> or <code>IdentifyMultipleLanguages</code> in your request. If you include more than one of these parameters, your transcription job fails.</p>
    /// <p>Streaming language identification can't be combined with custom language models or redaction.</p>
    pub identify_language: ::std::option::Option<bool>,
    /// <p>Specify two or more language codes that represent the languages you think may be present in your media; including more than five is not recommended. If you're unsure what languages are present, do not include this parameter.</p>
    /// <p>Including language options can improve the accuracy of language identification.</p>
    /// <p>If you include <code>LanguageOptions</code> in your request, you must also include <code>IdentifyLanguage</code>.</p>
    /// <p>For a list of languages supported with Amazon Transcribe streaming, refer to the <a href="https://docs.aws.amazon.com/transcribe/latest/dg/supported-languages.html">Supported languages</a> table.</p><important>
    /// <p>You can only include one language dialect per language per stream. For example, you cannot include <code>en-US</code> and <code>en-AU</code> in the same request.</p>
    /// </important>
    pub language_options: ::std::option::Option<::std::string::String>,
    /// <p>Specify a preferred language from the subset of languages codes you specified in <code>LanguageOptions</code>.</p>
    /// <p>You can only use this parameter if you've included <code>IdentifyLanguage</code> and <code>LanguageOptions</code> in your request.</p>
    pub preferred_language: ::std::option::Option<crate::types::LanguageCode>,
    /// <p>Enables automatic multi-language identification in your transcription job request. Use this parameter if your stream contains more than one language. If your stream contains only one language, use IdentifyLanguage instead.</p>
    /// <p>If you include <code>IdentifyMultipleLanguages</code>, you can optionally include a list of language codes, using <code>LanguageOptions</code>, that you think may be present in your stream. Including <code>LanguageOptions</code> restricts <code>IdentifyMultipleLanguages</code> to only the language options that you specify, which can improve transcription accuracy.</p>
    /// <p>If you want to apply a custom vocabulary or a custom vocabulary filter to your automatic multiple language identification request, include <code>VocabularyNames</code> or <code>VocabularyFilterNames</code>.</p>
    /// <p>Note that you must include one of <code>LanguageCode</code>, <code>IdentifyLanguage</code>, or <code>IdentifyMultipleLanguages</code> in your request. If you include more than one of these parameters, your transcription job fails.</p>
    pub identify_multiple_languages: ::std::option::Option<bool>,
    /// <p>Specify the names of the custom vocabularies that you want to use when processing your transcription. Note that vocabulary names are case sensitive.</p>
    /// <p>If none of the languages of the specified custom vocabularies match the language identified in your media, your job fails.</p><important>
    /// <p>This parameter is only intended for use <b>with</b> the <code>IdentifyLanguage</code> parameter. If you're <b>not</b> including <code>IdentifyLanguage</code> in your request and want to use a custom vocabulary with your transcription, use the <code>VocabularyName</code> parameter instead.</p>
    /// </important>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/transcribe/latest/dg/custom-vocabulary.html">Custom vocabularies</a>.</p>
    pub vocabulary_names: ::std::option::Option<::std::string::String>,
    /// <p>Specify the names of the custom vocabulary filters that you want to use when processing your transcription. Note that vocabulary filter names are case sensitive.</p>
    /// <p>If none of the languages of the specified custom vocabulary filters match the language identified in your media, your job fails.</p><important>
    /// <p>This parameter is only intended for use <b>with</b> the <code>IdentifyLanguage</code> parameter. If you're <b>not</b> including <code>IdentifyLanguage</code> in your request and want to use a custom vocabulary filter with your transcription, use the <code>VocabularyFilterName</code> parameter instead.</p>
    /// </important>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/transcribe/latest/dg/vocabulary-filtering.html">Using vocabulary filtering with unwanted words</a>.</p>
    pub vocabulary_filter_names: ::std::option::Option<::std::string::String>,
}
impl StartStreamTranscriptionInput {
    /// <p>Specify the language code that represents the language spoken in your audio.</p>
    /// <p>If you're unsure of the language spoken in your audio, consider using <code>IdentifyLanguage</code> to enable automatic language identification.</p>
    /// <p>For a list of languages supported with Amazon Transcribe streaming, refer to the <a href="https://docs.aws.amazon.com/transcribe/latest/dg/supported-languages.html">Supported languages</a> table.</p>
    pub fn language_code(&self) -> ::std::option::Option<&crate::types::LanguageCode> {
        self.language_code.as_ref()
    }
    /// <p>The sample rate of the input audio (in hertz). Low-quality audio, such as telephone audio, is typically around 8,000 Hz. High-quality audio typically ranges from 16,000 Hz to 48,000 Hz. Note that the sample rate you specify must match that of your audio.</p>
    pub fn media_sample_rate_hertz(&self) -> ::std::option::Option<i32> {
        self.media_sample_rate_hertz
    }
    /// <p>Specify the encoding of your input audio. Supported formats are:</p>
    /// <ul>
    /// <li>
    /// <p>FLAC</p></li>
    /// <li>
    /// <p>OPUS-encoded audio in an Ogg container</p></li>
    /// <li>
    /// <p>PCM (only signed 16-bit little-endian audio formats, which does not include WAV)</p></li>
    /// </ul>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/transcribe/latest/dg/how-input.html#how-input-audio">Media formats</a>.</p>
    pub fn media_encoding(&self) -> ::std::option::Option<&crate::types::MediaEncoding> {
        self.media_encoding.as_ref()
    }
    /// <p>Specify the name of the custom vocabulary that you want to use when processing your transcription. Note that vocabulary names are case sensitive.</p>
    /// <p>If the language of the specified custom vocabulary doesn't match the language identified in your media, the custom vocabulary is not applied to your transcription.</p><important>
    /// <p>This parameter is <b>not</b> intended for use with the <code>IdentifyLanguage</code> parameter. If you're including <code>IdentifyLanguage</code> in your request and want to use one or more custom vocabularies with your transcription, use the <code>VocabularyNames</code> parameter instead.</p>
    /// </important>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/transcribe/latest/dg/custom-vocabulary.html">Custom vocabularies</a>.</p>
    pub fn vocabulary_name(&self) -> ::std::option::Option<&str> {
        self.vocabulary_name.as_deref()
    }
    /// <p>Specify a name for your transcription session. If you don't include this parameter in your request, Amazon Transcribe generates an ID and returns it in the response.</p>
    /// <p>You can use a session ID to retry a streaming session.</p>
    pub fn session_id(&self) -> ::std::option::Option<&str> {
        self.session_id.as_deref()
    }
    /// <p>An encoded stream of audio blobs. Audio streams are encoded as either HTTP/2 or WebSocket data frames.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/transcribe/latest/dg/streaming.html">Transcribing streaming audio</a>.</p>
    pub fn audio_stream(
        &self,
    ) -> &::aws_smithy_http::event_stream::EventStreamSender<crate::types::AudioStream, crate::types::error::AudioStreamError> {
        &self.audio_stream
    }
    /// <p>Specify the name of the custom vocabulary filter that you want to use when processing your transcription. Note that vocabulary filter names are case sensitive.</p>
    /// <p>If the language of the specified custom vocabulary filter doesn't match the language identified in your media, the vocabulary filter is not applied to your transcription.</p><important>
    /// <p>This parameter is <b>not</b> intended for use with the <code>IdentifyLanguage</code> parameter. If you're including <code>IdentifyLanguage</code> in your request and want to use one or more vocabulary filters with your transcription, use the <code>VocabularyFilterNames</code> parameter instead.</p>
    /// </important>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/transcribe/latest/dg/vocabulary-filtering.html">Using vocabulary filtering with unwanted words</a>.</p>
    pub fn vocabulary_filter_name(&self) -> ::std::option::Option<&str> {
        self.vocabulary_filter_name.as_deref()
    }
    /// <p>Specify how you want your vocabulary filter applied to your transcript.</p>
    /// <p>To replace words with <code>***</code>, choose <code>mask</code>.</p>
    /// <p>To delete words, choose <code>remove</code>.</p>
    /// <p>To flag words without changing them, choose <code>tag</code>.</p>
    pub fn vocabulary_filter_method(&self) -> ::std::option::Option<&crate::types::VocabularyFilterMethod> {
        self.vocabulary_filter_method.as_ref()
    }
    /// <p>Enables speaker partitioning (diarization) in your transcription output. Speaker partitioning labels the speech from individual speakers in your media file.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/transcribe/latest/dg/diarization.html">Partitioning speakers (diarization)</a>.</p>
    pub fn show_speaker_label(&self) -> ::std::option::Option<bool> {
        self.show_speaker_label
    }
    /// <p>Enables channel identification in multi-channel audio.</p>
    /// <p>Channel identification transcribes the audio on each channel independently, then appends the output for each channel into one transcript.</p>
    /// <p>If you have multi-channel audio and do not enable channel identification, your audio is transcribed in a continuous manner and your transcript is not separated by channel.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/transcribe/latest/dg/channel-id.html">Transcribing multi-channel audio</a>.</p>
    pub fn enable_channel_identification(&self) -> ::std::option::Option<bool> {
        self.enable_channel_identification
    }
    /// <p>Specify the number of channels in your audio stream. Up to two channels are supported.</p>
    pub fn number_of_channels(&self) -> ::std::option::Option<i32> {
        self.number_of_channels
    }
    /// <p>Enables partial result stabilization for your transcription. Partial result stabilization can reduce latency in your output, but may impact accuracy. For more information, see <a href="https://docs.aws.amazon.com/transcribe/latest/dg/streaming.html#streaming-partial-result-stabilization">Partial-result stabilization</a>.</p>
    pub fn enable_partial_results_stabilization(&self) -> ::std::option::Option<bool> {
        self.enable_partial_results_stabilization
    }
    /// <p>Specify the level of stability to use when you enable partial results stabilization (<code>EnablePartialResultsStabilization</code>).</p>
    /// <p>Low stability provides the highest accuracy. High stability transcribes faster, but with slightly lower accuracy.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/transcribe/latest/dg/streaming.html#streaming-partial-result-stabilization">Partial-result stabilization</a>.</p>
    pub fn partial_results_stability(&self) -> ::std::option::Option<&crate::types::PartialResultsStability> {
        self.partial_results_stability.as_ref()
    }
    /// <p>Labels all personally identifiable information (PII) identified in your transcript.</p>
    /// <p>Content identification is performed at the segment level; PII specified in <code>PiiEntityTypes</code> is flagged upon complete transcription of an audio segment.</p>
    /// <p>You can’t set <code>ContentIdentificationType</code> and <code>ContentRedactionType</code> in the same request. If you set both, your request returns a <code>BadRequestException</code>.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/transcribe/latest/dg/pii-redaction.html">Redacting or identifying personally identifiable information</a>.</p>
    pub fn content_identification_type(&self) -> ::std::option::Option<&crate::types::ContentIdentificationType> {
        self.content_identification_type.as_ref()
    }
    /// <p>Redacts all personally identifiable information (PII) identified in your transcript.</p>
    /// <p>Content redaction is performed at the segment level; PII specified in <code>PiiEntityTypes</code> is redacted upon complete transcription of an audio segment.</p>
    /// <p>You can’t set <code>ContentRedactionType</code> and <code>ContentIdentificationType</code> in the same request. If you set both, your request returns a <code>BadRequestException</code>.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/transcribe/latest/dg/pii-redaction.html">Redacting or identifying personally identifiable information</a>.</p>
    pub fn content_redaction_type(&self) -> ::std::option::Option<&crate::types::ContentRedactionType> {
        self.content_redaction_type.as_ref()
    }
    /// <p>Specify which types of personally identifiable information (PII) you want to redact in your transcript. You can include as many types as you'd like, or you can select <code>ALL</code>.</p>
    /// <p>To include <code>PiiEntityTypes</code> in your request, you must also include either <code>ContentIdentificationType</code> or <code>ContentRedactionType</code>.</p>
    /// <p>Values must be comma-separated and can include: <code>BANK_ACCOUNT_NUMBER</code>, <code>BANK_ROUTING</code>, <code>CREDIT_DEBIT_NUMBER</code>, <code>CREDIT_DEBIT_CVV</code>, <code>CREDIT_DEBIT_EXPIRY</code>, <code>PIN</code>, <code>EMAIL</code>, <code>ADDRESS</code>, <code>NAME</code>, <code>PHONE</code>, <code>SSN</code>, or <code>ALL</code>.</p>
    pub fn pii_entity_types(&self) -> ::std::option::Option<&str> {
        self.pii_entity_types.as_deref()
    }
    /// <p>Specify the name of the custom language model that you want to use when processing your transcription. Note that language model names are case sensitive.</p>
    /// <p>The language of the specified language model must match the language code you specify in your transcription request. If the languages don't match, the custom language model isn't applied. There are no errors or warnings associated with a language mismatch.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/transcribe/latest/dg/custom-language-models.html">Custom language models</a>.</p>
    pub fn language_model_name(&self) -> ::std::option::Option<&str> {
        self.language_model_name.as_deref()
    }
    /// <p>Enables automatic language identification for your transcription.</p>
    /// <p>If you include <code>IdentifyLanguage</code>, you can optionally include a list of language codes, using <code>LanguageOptions</code>, that you think may be present in your audio stream. Including language options can improve transcription accuracy.</p>
    /// <p>You can also include a preferred language using <code>PreferredLanguage</code>. Adding a preferred language can help Amazon Transcribe identify the language faster than if you omit this parameter.</p>
    /// <p>If you have multi-channel audio that contains different languages on each channel, and you've enabled channel identification, automatic language identification identifies the dominant language on each audio channel.</p>
    /// <p>Note that you must include either <code>LanguageCode</code> or <code>IdentifyLanguage</code> or <code>IdentifyMultipleLanguages</code> in your request. If you include more than one of these parameters, your transcription job fails.</p>
    /// <p>Streaming language identification can't be combined with custom language models or redaction.</p>
    pub fn identify_language(&self) -> ::std::option::Option<bool> {
        self.identify_language
    }
    /// <p>Specify two or more language codes that represent the languages you think may be present in your media; including more than five is not recommended. If you're unsure what languages are present, do not include this parameter.</p>
    /// <p>Including language options can improve the accuracy of language identification.</p>
    /// <p>If you include <code>LanguageOptions</code> in your request, you must also include <code>IdentifyLanguage</code>.</p>
    /// <p>For a list of languages supported with Amazon Transcribe streaming, refer to the <a href="https://docs.aws.amazon.com/transcribe/latest/dg/supported-languages.html">Supported languages</a> table.</p><important>
    /// <p>You can only include one language dialect per language per stream. For example, you cannot include <code>en-US</code> and <code>en-AU</code> in the same request.</p>
    /// </important>
    pub fn language_options(&self) -> ::std::option::Option<&str> {
        self.language_options.as_deref()
    }
    /// <p>Specify a preferred language from the subset of languages codes you specified in <code>LanguageOptions</code>.</p>
    /// <p>You can only use this parameter if you've included <code>IdentifyLanguage</code> and <code>LanguageOptions</code> in your request.</p>
    pub fn preferred_language(&self) -> ::std::option::Option<&crate::types::LanguageCode> {
        self.preferred_language.as_ref()
    }
    /// <p>Enables automatic multi-language identification in your transcription job request. Use this parameter if your stream contains more than one language. If your stream contains only one language, use IdentifyLanguage instead.</p>
    /// <p>If you include <code>IdentifyMultipleLanguages</code>, you can optionally include a list of language codes, using <code>LanguageOptions</code>, that you think may be present in your stream. Including <code>LanguageOptions</code> restricts <code>IdentifyMultipleLanguages</code> to only the language options that you specify, which can improve transcription accuracy.</p>
    /// <p>If you want to apply a custom vocabulary or a custom vocabulary filter to your automatic multiple language identification request, include <code>VocabularyNames</code> or <code>VocabularyFilterNames</code>.</p>
    /// <p>Note that you must include one of <code>LanguageCode</code>, <code>IdentifyLanguage</code>, or <code>IdentifyMultipleLanguages</code> in your request. If you include more than one of these parameters, your transcription job fails.</p>
    pub fn identify_multiple_languages(&self) -> ::std::option::Option<bool> {
        self.identify_multiple_languages
    }
    /// <p>Specify the names of the custom vocabularies that you want to use when processing your transcription. Note that vocabulary names are case sensitive.</p>
    /// <p>If none of the languages of the specified custom vocabularies match the language identified in your media, your job fails.</p><important>
    /// <p>This parameter is only intended for use <b>with</b> the <code>IdentifyLanguage</code> parameter. If you're <b>not</b> including <code>IdentifyLanguage</code> in your request and want to use a custom vocabulary with your transcription, use the <code>VocabularyName</code> parameter instead.</p>
    /// </important>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/transcribe/latest/dg/custom-vocabulary.html">Custom vocabularies</a>.</p>
    pub fn vocabulary_names(&self) -> ::std::option::Option<&str> {
        self.vocabulary_names.as_deref()
    }
    /// <p>Specify the names of the custom vocabulary filters that you want to use when processing your transcription. Note that vocabulary filter names are case sensitive.</p>
    /// <p>If none of the languages of the specified custom vocabulary filters match the language identified in your media, your job fails.</p><important>
    /// <p>This parameter is only intended for use <b>with</b> the <code>IdentifyLanguage</code> parameter. If you're <b>not</b> including <code>IdentifyLanguage</code> in your request and want to use a custom vocabulary filter with your transcription, use the <code>VocabularyFilterName</code> parameter instead.</p>
    /// </important>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/transcribe/latest/dg/vocabulary-filtering.html">Using vocabulary filtering with unwanted words</a>.</p>
    pub fn vocabulary_filter_names(&self) -> ::std::option::Option<&str> {
        self.vocabulary_filter_names.as_deref()
    }
}
impl StartStreamTranscriptionInput {
    /// Creates a new builder-style object to manufacture [`StartStreamTranscriptionInput`](crate::operation::start_stream_transcription::StartStreamTranscriptionInput).
    pub fn builder() -> crate::operation::start_stream_transcription::builders::StartStreamTranscriptionInputBuilder {
        crate::operation::start_stream_transcription::builders::StartStreamTranscriptionInputBuilder::default()
    }
}

/// A builder for [`StartStreamTranscriptionInput`](crate::operation::start_stream_transcription::StartStreamTranscriptionInput).
#[non_exhaustive]
#[derive(::std::default::Default, ::std::fmt::Debug)]
pub struct StartStreamTranscriptionInputBuilder {
    pub(crate) language_code: ::std::option::Option<crate::types::LanguageCode>,
    pub(crate) media_sample_rate_hertz: ::std::option::Option<i32>,
    pub(crate) media_encoding: ::std::option::Option<crate::types::MediaEncoding>,
    pub(crate) vocabulary_name: ::std::option::Option<::std::string::String>,
    pub(crate) session_id: ::std::option::Option<::std::string::String>,
    pub(crate) audio_stream:
        ::std::option::Option<::aws_smithy_http::event_stream::EventStreamSender<crate::types::AudioStream, crate::types::error::AudioStreamError>>,
    pub(crate) vocabulary_filter_name: ::std::option::Option<::std::string::String>,
    pub(crate) vocabulary_filter_method: ::std::option::Option<crate::types::VocabularyFilterMethod>,
    pub(crate) show_speaker_label: ::std::option::Option<bool>,
    pub(crate) enable_channel_identification: ::std::option::Option<bool>,
    pub(crate) number_of_channels: ::std::option::Option<i32>,
    pub(crate) enable_partial_results_stabilization: ::std::option::Option<bool>,
    pub(crate) partial_results_stability: ::std::option::Option<crate::types::PartialResultsStability>,
    pub(crate) content_identification_type: ::std::option::Option<crate::types::ContentIdentificationType>,
    pub(crate) content_redaction_type: ::std::option::Option<crate::types::ContentRedactionType>,
    pub(crate) pii_entity_types: ::std::option::Option<::std::string::String>,
    pub(crate) language_model_name: ::std::option::Option<::std::string::String>,
    pub(crate) identify_language: ::std::option::Option<bool>,
    pub(crate) language_options: ::std::option::Option<::std::string::String>,
    pub(crate) preferred_language: ::std::option::Option<crate::types::LanguageCode>,
    pub(crate) identify_multiple_languages: ::std::option::Option<bool>,
    pub(crate) vocabulary_names: ::std::option::Option<::std::string::String>,
    pub(crate) vocabulary_filter_names: ::std::option::Option<::std::string::String>,
}
impl StartStreamTranscriptionInputBuilder {
    /// <p>Specify the language code that represents the language spoken in your audio.</p>
    /// <p>If you're unsure of the language spoken in your audio, consider using <code>IdentifyLanguage</code> to enable automatic language identification.</p>
    /// <p>For a list of languages supported with Amazon Transcribe streaming, refer to the <a href="https://docs.aws.amazon.com/transcribe/latest/dg/supported-languages.html">Supported languages</a> table.</p>
    pub fn language_code(mut self, input: crate::types::LanguageCode) -> Self {
        self.language_code = ::std::option::Option::Some(input);
        self
    }
    /// <p>Specify the language code that represents the language spoken in your audio.</p>
    /// <p>If you're unsure of the language spoken in your audio, consider using <code>IdentifyLanguage</code> to enable automatic language identification.</p>
    /// <p>For a list of languages supported with Amazon Transcribe streaming, refer to the <a href="https://docs.aws.amazon.com/transcribe/latest/dg/supported-languages.html">Supported languages</a> table.</p>
    pub fn set_language_code(mut self, input: ::std::option::Option<crate::types::LanguageCode>) -> Self {
        self.language_code = input;
        self
    }
    /// <p>Specify the language code that represents the language spoken in your audio.</p>
    /// <p>If you're unsure of the language spoken in your audio, consider using <code>IdentifyLanguage</code> to enable automatic language identification.</p>
    /// <p>For a list of languages supported with Amazon Transcribe streaming, refer to the <a href="https://docs.aws.amazon.com/transcribe/latest/dg/supported-languages.html">Supported languages</a> table.</p>
    pub fn get_language_code(&self) -> &::std::option::Option<crate::types::LanguageCode> {
        &self.language_code
    }
    /// <p>The sample rate of the input audio (in hertz). Low-quality audio, such as telephone audio, is typically around 8,000 Hz. High-quality audio typically ranges from 16,000 Hz to 48,000 Hz. Note that the sample rate you specify must match that of your audio.</p>
    /// This field is required.
    pub fn media_sample_rate_hertz(mut self, input: i32) -> Self {
        self.media_sample_rate_hertz = ::std::option::Option::Some(input);
        self
    }
    /// <p>The sample rate of the input audio (in hertz). Low-quality audio, such as telephone audio, is typically around 8,000 Hz. High-quality audio typically ranges from 16,000 Hz to 48,000 Hz. Note that the sample rate you specify must match that of your audio.</p>
    pub fn set_media_sample_rate_hertz(mut self, input: ::std::option::Option<i32>) -> Self {
        self.media_sample_rate_hertz = input;
        self
    }
    /// <p>The sample rate of the input audio (in hertz). Low-quality audio, such as telephone audio, is typically around 8,000 Hz. High-quality audio typically ranges from 16,000 Hz to 48,000 Hz. Note that the sample rate you specify must match that of your audio.</p>
    pub fn get_media_sample_rate_hertz(&self) -> &::std::option::Option<i32> {
        &self.media_sample_rate_hertz
    }
    /// <p>Specify the encoding of your input audio. Supported formats are:</p>
    /// <ul>
    /// <li>
    /// <p>FLAC</p></li>
    /// <li>
    /// <p>OPUS-encoded audio in an Ogg container</p></li>
    /// <li>
    /// <p>PCM (only signed 16-bit little-endian audio formats, which does not include WAV)</p></li>
    /// </ul>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/transcribe/latest/dg/how-input.html#how-input-audio">Media formats</a>.</p>
    /// This field is required.
    pub fn media_encoding(mut self, input: crate::types::MediaEncoding) -> Self {
        self.media_encoding = ::std::option::Option::Some(input);
        self
    }
    /// <p>Specify the encoding of your input audio. Supported formats are:</p>
    /// <ul>
    /// <li>
    /// <p>FLAC</p></li>
    /// <li>
    /// <p>OPUS-encoded audio in an Ogg container</p></li>
    /// <li>
    /// <p>PCM (only signed 16-bit little-endian audio formats, which does not include WAV)</p></li>
    /// </ul>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/transcribe/latest/dg/how-input.html#how-input-audio">Media formats</a>.</p>
    pub fn set_media_encoding(mut self, input: ::std::option::Option<crate::types::MediaEncoding>) -> Self {
        self.media_encoding = input;
        self
    }
    /// <p>Specify the encoding of your input audio. Supported formats are:</p>
    /// <ul>
    /// <li>
    /// <p>FLAC</p></li>
    /// <li>
    /// <p>OPUS-encoded audio in an Ogg container</p></li>
    /// <li>
    /// <p>PCM (only signed 16-bit little-endian audio formats, which does not include WAV)</p></li>
    /// </ul>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/transcribe/latest/dg/how-input.html#how-input-audio">Media formats</a>.</p>
    pub fn get_media_encoding(&self) -> &::std::option::Option<crate::types::MediaEncoding> {
        &self.media_encoding
    }
    /// <p>Specify the name of the custom vocabulary that you want to use when processing your transcription. Note that vocabulary names are case sensitive.</p>
    /// <p>If the language of the specified custom vocabulary doesn't match the language identified in your media, the custom vocabulary is not applied to your transcription.</p><important>
    /// <p>This parameter is <b>not</b> intended for use with the <code>IdentifyLanguage</code> parameter. If you're including <code>IdentifyLanguage</code> in your request and want to use one or more custom vocabularies with your transcription, use the <code>VocabularyNames</code> parameter instead.</p>
    /// </important>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/transcribe/latest/dg/custom-vocabulary.html">Custom vocabularies</a>.</p>
    pub fn vocabulary_name(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.vocabulary_name = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>Specify the name of the custom vocabulary that you want to use when processing your transcription. Note that vocabulary names are case sensitive.</p>
    /// <p>If the language of the specified custom vocabulary doesn't match the language identified in your media, the custom vocabulary is not applied to your transcription.</p><important>
    /// <p>This parameter is <b>not</b> intended for use with the <code>IdentifyLanguage</code> parameter. If you're including <code>IdentifyLanguage</code> in your request and want to use one or more custom vocabularies with your transcription, use the <code>VocabularyNames</code> parameter instead.</p>
    /// </important>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/transcribe/latest/dg/custom-vocabulary.html">Custom vocabularies</a>.</p>
    pub fn set_vocabulary_name(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.vocabulary_name = input;
        self
    }
    /// <p>Specify the name of the custom vocabulary that you want to use when processing your transcription. Note that vocabulary names are case sensitive.</p>
    /// <p>If the language of the specified custom vocabulary doesn't match the language identified in your media, the custom vocabulary is not applied to your transcription.</p><important>
    /// <p>This parameter is <b>not</b> intended for use with the <code>IdentifyLanguage</code> parameter. If you're including <code>IdentifyLanguage</code> in your request and want to use one or more custom vocabularies with your transcription, use the <code>VocabularyNames</code> parameter instead.</p>
    /// </important>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/transcribe/latest/dg/custom-vocabulary.html">Custom vocabularies</a>.</p>
    pub fn get_vocabulary_name(&self) -> &::std::option::Option<::std::string::String> {
        &self.vocabulary_name
    }
    /// <p>Specify a name for your transcription session. If you don't include this parameter in your request, Amazon Transcribe generates an ID and returns it in the response.</p>
    /// <p>You can use a session ID to retry a streaming session.</p>
    pub fn session_id(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.session_id = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>Specify a name for your transcription session. If you don't include this parameter in your request, Amazon Transcribe generates an ID and returns it in the response.</p>
    /// <p>You can use a session ID to retry a streaming session.</p>
    pub fn set_session_id(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.session_id = input;
        self
    }
    /// <p>Specify a name for your transcription session. If you don't include this parameter in your request, Amazon Transcribe generates an ID and returns it in the response.</p>
    /// <p>You can use a session ID to retry a streaming session.</p>
    pub fn get_session_id(&self) -> &::std::option::Option<::std::string::String> {
        &self.session_id
    }
    /// <p>An encoded stream of audio blobs. Audio streams are encoded as either HTTP/2 or WebSocket data frames.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/transcribe/latest/dg/streaming.html">Transcribing streaming audio</a>.</p>
    /// This field is required.
    pub fn audio_stream(
        mut self,
        input: ::aws_smithy_http::event_stream::EventStreamSender<crate::types::AudioStream, crate::types::error::AudioStreamError>,
    ) -> Self {
        self.audio_stream = ::std::option::Option::Some(input);
        self
    }
    /// <p>An encoded stream of audio blobs. Audio streams are encoded as either HTTP/2 or WebSocket data frames.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/transcribe/latest/dg/streaming.html">Transcribing streaming audio</a>.</p>
    pub fn set_audio_stream(
        mut self,
        input: ::std::option::Option<
            ::aws_smithy_http::event_stream::EventStreamSender<crate::types::AudioStream, crate::types::error::AudioStreamError>,
        >,
    ) -> Self {
        self.audio_stream = input;
        self
    }
    /// <p>An encoded stream of audio blobs. Audio streams are encoded as either HTTP/2 or WebSocket data frames.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/transcribe/latest/dg/streaming.html">Transcribing streaming audio</a>.</p>
    pub fn get_audio_stream(
        &self,
    ) -> &::std::option::Option<::aws_smithy_http::event_stream::EventStreamSender<crate::types::AudioStream, crate::types::error::AudioStreamError>>
    {
        &self.audio_stream
    }
    /// <p>Specify the name of the custom vocabulary filter that you want to use when processing your transcription. Note that vocabulary filter names are case sensitive.</p>
    /// <p>If the language of the specified custom vocabulary filter doesn't match the language identified in your media, the vocabulary filter is not applied to your transcription.</p><important>
    /// <p>This parameter is <b>not</b> intended for use with the <code>IdentifyLanguage</code> parameter. If you're including <code>IdentifyLanguage</code> in your request and want to use one or more vocabulary filters with your transcription, use the <code>VocabularyFilterNames</code> parameter instead.</p>
    /// </important>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/transcribe/latest/dg/vocabulary-filtering.html">Using vocabulary filtering with unwanted words</a>.</p>
    pub fn vocabulary_filter_name(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.vocabulary_filter_name = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>Specify the name of the custom vocabulary filter that you want to use when processing your transcription. Note that vocabulary filter names are case sensitive.</p>
    /// <p>If the language of the specified custom vocabulary filter doesn't match the language identified in your media, the vocabulary filter is not applied to your transcription.</p><important>
    /// <p>This parameter is <b>not</b> intended for use with the <code>IdentifyLanguage</code> parameter. If you're including <code>IdentifyLanguage</code> in your request and want to use one or more vocabulary filters with your transcription, use the <code>VocabularyFilterNames</code> parameter instead.</p>
    /// </important>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/transcribe/latest/dg/vocabulary-filtering.html">Using vocabulary filtering with unwanted words</a>.</p>
    pub fn set_vocabulary_filter_name(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.vocabulary_filter_name = input;
        self
    }
    /// <p>Specify the name of the custom vocabulary filter that you want to use when processing your transcription. Note that vocabulary filter names are case sensitive.</p>
    /// <p>If the language of the specified custom vocabulary filter doesn't match the language identified in your media, the vocabulary filter is not applied to your transcription.</p><important>
    /// <p>This parameter is <b>not</b> intended for use with the <code>IdentifyLanguage</code> parameter. If you're including <code>IdentifyLanguage</code> in your request and want to use one or more vocabulary filters with your transcription, use the <code>VocabularyFilterNames</code> parameter instead.</p>
    /// </important>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/transcribe/latest/dg/vocabulary-filtering.html">Using vocabulary filtering with unwanted words</a>.</p>
    pub fn get_vocabulary_filter_name(&self) -> &::std::option::Option<::std::string::String> {
        &self.vocabulary_filter_name
    }
    /// <p>Specify how you want your vocabulary filter applied to your transcript.</p>
    /// <p>To replace words with <code>***</code>, choose <code>mask</code>.</p>
    /// <p>To delete words, choose <code>remove</code>.</p>
    /// <p>To flag words without changing them, choose <code>tag</code>.</p>
    pub fn vocabulary_filter_method(mut self, input: crate::types::VocabularyFilterMethod) -> Self {
        self.vocabulary_filter_method = ::std::option::Option::Some(input);
        self
    }
    /// <p>Specify how you want your vocabulary filter applied to your transcript.</p>
    /// <p>To replace words with <code>***</code>, choose <code>mask</code>.</p>
    /// <p>To delete words, choose <code>remove</code>.</p>
    /// <p>To flag words without changing them, choose <code>tag</code>.</p>
    pub fn set_vocabulary_filter_method(mut self, input: ::std::option::Option<crate::types::VocabularyFilterMethod>) -> Self {
        self.vocabulary_filter_method = input;
        self
    }
    /// <p>Specify how you want your vocabulary filter applied to your transcript.</p>
    /// <p>To replace words with <code>***</code>, choose <code>mask</code>.</p>
    /// <p>To delete words, choose <code>remove</code>.</p>
    /// <p>To flag words without changing them, choose <code>tag</code>.</p>
    pub fn get_vocabulary_filter_method(&self) -> &::std::option::Option<crate::types::VocabularyFilterMethod> {
        &self.vocabulary_filter_method
    }
    /// <p>Enables speaker partitioning (diarization) in your transcription output. Speaker partitioning labels the speech from individual speakers in your media file.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/transcribe/latest/dg/diarization.html">Partitioning speakers (diarization)</a>.</p>
    pub fn show_speaker_label(mut self, input: bool) -> Self {
        self.show_speaker_label = ::std::option::Option::Some(input);
        self
    }
    /// <p>Enables speaker partitioning (diarization) in your transcription output. Speaker partitioning labels the speech from individual speakers in your media file.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/transcribe/latest/dg/diarization.html">Partitioning speakers (diarization)</a>.</p>
    pub fn set_show_speaker_label(mut self, input: ::std::option::Option<bool>) -> Self {
        self.show_speaker_label = input;
        self
    }
    /// <p>Enables speaker partitioning (diarization) in your transcription output. Speaker partitioning labels the speech from individual speakers in your media file.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/transcribe/latest/dg/diarization.html">Partitioning speakers (diarization)</a>.</p>
    pub fn get_show_speaker_label(&self) -> &::std::option::Option<bool> {
        &self.show_speaker_label
    }
    /// <p>Enables channel identification in multi-channel audio.</p>
    /// <p>Channel identification transcribes the audio on each channel independently, then appends the output for each channel into one transcript.</p>
    /// <p>If you have multi-channel audio and do not enable channel identification, your audio is transcribed in a continuous manner and your transcript is not separated by channel.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/transcribe/latest/dg/channel-id.html">Transcribing multi-channel audio</a>.</p>
    pub fn enable_channel_identification(mut self, input: bool) -> Self {
        self.enable_channel_identification = ::std::option::Option::Some(input);
        self
    }
    /// <p>Enables channel identification in multi-channel audio.</p>
    /// <p>Channel identification transcribes the audio on each channel independently, then appends the output for each channel into one transcript.</p>
    /// <p>If you have multi-channel audio and do not enable channel identification, your audio is transcribed in a continuous manner and your transcript is not separated by channel.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/transcribe/latest/dg/channel-id.html">Transcribing multi-channel audio</a>.</p>
    pub fn set_enable_channel_identification(mut self, input: ::std::option::Option<bool>) -> Self {
        self.enable_channel_identification = input;
        self
    }
    /// <p>Enables channel identification in multi-channel audio.</p>
    /// <p>Channel identification transcribes the audio on each channel independently, then appends the output for each channel into one transcript.</p>
    /// <p>If you have multi-channel audio and do not enable channel identification, your audio is transcribed in a continuous manner and your transcript is not separated by channel.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/transcribe/latest/dg/channel-id.html">Transcribing multi-channel audio</a>.</p>
    pub fn get_enable_channel_identification(&self) -> &::std::option::Option<bool> {
        &self.enable_channel_identification
    }
    /// <p>Specify the number of channels in your audio stream. Up to two channels are supported.</p>
    pub fn number_of_channels(mut self, input: i32) -> Self {
        self.number_of_channels = ::std::option::Option::Some(input);
        self
    }
    /// <p>Specify the number of channels in your audio stream. Up to two channels are supported.</p>
    pub fn set_number_of_channels(mut self, input: ::std::option::Option<i32>) -> Self {
        self.number_of_channels = input;
        self
    }
    /// <p>Specify the number of channels in your audio stream. Up to two channels are supported.</p>
    pub fn get_number_of_channels(&self) -> &::std::option::Option<i32> {
        &self.number_of_channels
    }
    /// <p>Enables partial result stabilization for your transcription. Partial result stabilization can reduce latency in your output, but may impact accuracy. For more information, see <a href="https://docs.aws.amazon.com/transcribe/latest/dg/streaming.html#streaming-partial-result-stabilization">Partial-result stabilization</a>.</p>
    pub fn enable_partial_results_stabilization(mut self, input: bool) -> Self {
        self.enable_partial_results_stabilization = ::std::option::Option::Some(input);
        self
    }
    /// <p>Enables partial result stabilization for your transcription. Partial result stabilization can reduce latency in your output, but may impact accuracy. For more information, see <a href="https://docs.aws.amazon.com/transcribe/latest/dg/streaming.html#streaming-partial-result-stabilization">Partial-result stabilization</a>.</p>
    pub fn set_enable_partial_results_stabilization(mut self, input: ::std::option::Option<bool>) -> Self {
        self.enable_partial_results_stabilization = input;
        self
    }
    /// <p>Enables partial result stabilization for your transcription. Partial result stabilization can reduce latency in your output, but may impact accuracy. For more information, see <a href="https://docs.aws.amazon.com/transcribe/latest/dg/streaming.html#streaming-partial-result-stabilization">Partial-result stabilization</a>.</p>
    pub fn get_enable_partial_results_stabilization(&self) -> &::std::option::Option<bool> {
        &self.enable_partial_results_stabilization
    }
    /// <p>Specify the level of stability to use when you enable partial results stabilization (<code>EnablePartialResultsStabilization</code>).</p>
    /// <p>Low stability provides the highest accuracy. High stability transcribes faster, but with slightly lower accuracy.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/transcribe/latest/dg/streaming.html#streaming-partial-result-stabilization">Partial-result stabilization</a>.</p>
    pub fn partial_results_stability(mut self, input: crate::types::PartialResultsStability) -> Self {
        self.partial_results_stability = ::std::option::Option::Some(input);
        self
    }
    /// <p>Specify the level of stability to use when you enable partial results stabilization (<code>EnablePartialResultsStabilization</code>).</p>
    /// <p>Low stability provides the highest accuracy. High stability transcribes faster, but with slightly lower accuracy.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/transcribe/latest/dg/streaming.html#streaming-partial-result-stabilization">Partial-result stabilization</a>.</p>
    pub fn set_partial_results_stability(mut self, input: ::std::option::Option<crate::types::PartialResultsStability>) -> Self {
        self.partial_results_stability = input;
        self
    }
    /// <p>Specify the level of stability to use when you enable partial results stabilization (<code>EnablePartialResultsStabilization</code>).</p>
    /// <p>Low stability provides the highest accuracy. High stability transcribes faster, but with slightly lower accuracy.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/transcribe/latest/dg/streaming.html#streaming-partial-result-stabilization">Partial-result stabilization</a>.</p>
    pub fn get_partial_results_stability(&self) -> &::std::option::Option<crate::types::PartialResultsStability> {
        &self.partial_results_stability
    }
    /// <p>Labels all personally identifiable information (PII) identified in your transcript.</p>
    /// <p>Content identification is performed at the segment level; PII specified in <code>PiiEntityTypes</code> is flagged upon complete transcription of an audio segment.</p>
    /// <p>You can’t set <code>ContentIdentificationType</code> and <code>ContentRedactionType</code> in the same request. If you set both, your request returns a <code>BadRequestException</code>.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/transcribe/latest/dg/pii-redaction.html">Redacting or identifying personally identifiable information</a>.</p>
    pub fn content_identification_type(mut self, input: crate::types::ContentIdentificationType) -> Self {
        self.content_identification_type = ::std::option::Option::Some(input);
        self
    }
    /// <p>Labels all personally identifiable information (PII) identified in your transcript.</p>
    /// <p>Content identification is performed at the segment level; PII specified in <code>PiiEntityTypes</code> is flagged upon complete transcription of an audio segment.</p>
    /// <p>You can’t set <code>ContentIdentificationType</code> and <code>ContentRedactionType</code> in the same request. If you set both, your request returns a <code>BadRequestException</code>.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/transcribe/latest/dg/pii-redaction.html">Redacting or identifying personally identifiable information</a>.</p>
    pub fn set_content_identification_type(mut self, input: ::std::option::Option<crate::types::ContentIdentificationType>) -> Self {
        self.content_identification_type = input;
        self
    }
    /// <p>Labels all personally identifiable information (PII) identified in your transcript.</p>
    /// <p>Content identification is performed at the segment level; PII specified in <code>PiiEntityTypes</code> is flagged upon complete transcription of an audio segment.</p>
    /// <p>You can’t set <code>ContentIdentificationType</code> and <code>ContentRedactionType</code> in the same request. If you set both, your request returns a <code>BadRequestException</code>.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/transcribe/latest/dg/pii-redaction.html">Redacting or identifying personally identifiable information</a>.</p>
    pub fn get_content_identification_type(&self) -> &::std::option::Option<crate::types::ContentIdentificationType> {
        &self.content_identification_type
    }
    /// <p>Redacts all personally identifiable information (PII) identified in your transcript.</p>
    /// <p>Content redaction is performed at the segment level; PII specified in <code>PiiEntityTypes</code> is redacted upon complete transcription of an audio segment.</p>
    /// <p>You can’t set <code>ContentRedactionType</code> and <code>ContentIdentificationType</code> in the same request. If you set both, your request returns a <code>BadRequestException</code>.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/transcribe/latest/dg/pii-redaction.html">Redacting or identifying personally identifiable information</a>.</p>
    pub fn content_redaction_type(mut self, input: crate::types::ContentRedactionType) -> Self {
        self.content_redaction_type = ::std::option::Option::Some(input);
        self
    }
    /// <p>Redacts all personally identifiable information (PII) identified in your transcript.</p>
    /// <p>Content redaction is performed at the segment level; PII specified in <code>PiiEntityTypes</code> is redacted upon complete transcription of an audio segment.</p>
    /// <p>You can’t set <code>ContentRedactionType</code> and <code>ContentIdentificationType</code> in the same request. If you set both, your request returns a <code>BadRequestException</code>.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/transcribe/latest/dg/pii-redaction.html">Redacting or identifying personally identifiable information</a>.</p>
    pub fn set_content_redaction_type(mut self, input: ::std::option::Option<crate::types::ContentRedactionType>) -> Self {
        self.content_redaction_type = input;
        self
    }
    /// <p>Redacts all personally identifiable information (PII) identified in your transcript.</p>
    /// <p>Content redaction is performed at the segment level; PII specified in <code>PiiEntityTypes</code> is redacted upon complete transcription of an audio segment.</p>
    /// <p>You can’t set <code>ContentRedactionType</code> and <code>ContentIdentificationType</code> in the same request. If you set both, your request returns a <code>BadRequestException</code>.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/transcribe/latest/dg/pii-redaction.html">Redacting or identifying personally identifiable information</a>.</p>
    pub fn get_content_redaction_type(&self) -> &::std::option::Option<crate::types::ContentRedactionType> {
        &self.content_redaction_type
    }
    /// <p>Specify which types of personally identifiable information (PII) you want to redact in your transcript. You can include as many types as you'd like, or you can select <code>ALL</code>.</p>
    /// <p>To include <code>PiiEntityTypes</code> in your request, you must also include either <code>ContentIdentificationType</code> or <code>ContentRedactionType</code>.</p>
    /// <p>Values must be comma-separated and can include: <code>BANK_ACCOUNT_NUMBER</code>, <code>BANK_ROUTING</code>, <code>CREDIT_DEBIT_NUMBER</code>, <code>CREDIT_DEBIT_CVV</code>, <code>CREDIT_DEBIT_EXPIRY</code>, <code>PIN</code>, <code>EMAIL</code>, <code>ADDRESS</code>, <code>NAME</code>, <code>PHONE</code>, <code>SSN</code>, or <code>ALL</code>.</p>
    pub fn pii_entity_types(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.pii_entity_types = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>Specify which types of personally identifiable information (PII) you want to redact in your transcript. You can include as many types as you'd like, or you can select <code>ALL</code>.</p>
    /// <p>To include <code>PiiEntityTypes</code> in your request, you must also include either <code>ContentIdentificationType</code> or <code>ContentRedactionType</code>.</p>
    /// <p>Values must be comma-separated and can include: <code>BANK_ACCOUNT_NUMBER</code>, <code>BANK_ROUTING</code>, <code>CREDIT_DEBIT_NUMBER</code>, <code>CREDIT_DEBIT_CVV</code>, <code>CREDIT_DEBIT_EXPIRY</code>, <code>PIN</code>, <code>EMAIL</code>, <code>ADDRESS</code>, <code>NAME</code>, <code>PHONE</code>, <code>SSN</code>, or <code>ALL</code>.</p>
    pub fn set_pii_entity_types(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.pii_entity_types = input;
        self
    }
    /// <p>Specify which types of personally identifiable information (PII) you want to redact in your transcript. You can include as many types as you'd like, or you can select <code>ALL</code>.</p>
    /// <p>To include <code>PiiEntityTypes</code> in your request, you must also include either <code>ContentIdentificationType</code> or <code>ContentRedactionType</code>.</p>
    /// <p>Values must be comma-separated and can include: <code>BANK_ACCOUNT_NUMBER</code>, <code>BANK_ROUTING</code>, <code>CREDIT_DEBIT_NUMBER</code>, <code>CREDIT_DEBIT_CVV</code>, <code>CREDIT_DEBIT_EXPIRY</code>, <code>PIN</code>, <code>EMAIL</code>, <code>ADDRESS</code>, <code>NAME</code>, <code>PHONE</code>, <code>SSN</code>, or <code>ALL</code>.</p>
    pub fn get_pii_entity_types(&self) -> &::std::option::Option<::std::string::String> {
        &self.pii_entity_types
    }
    /// <p>Specify the name of the custom language model that you want to use when processing your transcription. Note that language model names are case sensitive.</p>
    /// <p>The language of the specified language model must match the language code you specify in your transcription request. If the languages don't match, the custom language model isn't applied. There are no errors or warnings associated with a language mismatch.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/transcribe/latest/dg/custom-language-models.html">Custom language models</a>.</p>
    pub fn language_model_name(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.language_model_name = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>Specify the name of the custom language model that you want to use when processing your transcription. Note that language model names are case sensitive.</p>
    /// <p>The language of the specified language model must match the language code you specify in your transcription request. If the languages don't match, the custom language model isn't applied. There are no errors or warnings associated with a language mismatch.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/transcribe/latest/dg/custom-language-models.html">Custom language models</a>.</p>
    pub fn set_language_model_name(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.language_model_name = input;
        self
    }
    /// <p>Specify the name of the custom language model that you want to use when processing your transcription. Note that language model names are case sensitive.</p>
    /// <p>The language of the specified language model must match the language code you specify in your transcription request. If the languages don't match, the custom language model isn't applied. There are no errors or warnings associated with a language mismatch.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/transcribe/latest/dg/custom-language-models.html">Custom language models</a>.</p>
    pub fn get_language_model_name(&self) -> &::std::option::Option<::std::string::String> {
        &self.language_model_name
    }
    /// <p>Enables automatic language identification for your transcription.</p>
    /// <p>If you include <code>IdentifyLanguage</code>, you can optionally include a list of language codes, using <code>LanguageOptions</code>, that you think may be present in your audio stream. Including language options can improve transcription accuracy.</p>
    /// <p>You can also include a preferred language using <code>PreferredLanguage</code>. Adding a preferred language can help Amazon Transcribe identify the language faster than if you omit this parameter.</p>
    /// <p>If you have multi-channel audio that contains different languages on each channel, and you've enabled channel identification, automatic language identification identifies the dominant language on each audio channel.</p>
    /// <p>Note that you must include either <code>LanguageCode</code> or <code>IdentifyLanguage</code> or <code>IdentifyMultipleLanguages</code> in your request. If you include more than one of these parameters, your transcription job fails.</p>
    /// <p>Streaming language identification can't be combined with custom language models or redaction.</p>
    pub fn identify_language(mut self, input: bool) -> Self {
        self.identify_language = ::std::option::Option::Some(input);
        self
    }
    /// <p>Enables automatic language identification for your transcription.</p>
    /// <p>If you include <code>IdentifyLanguage</code>, you can optionally include a list of language codes, using <code>LanguageOptions</code>, that you think may be present in your audio stream. Including language options can improve transcription accuracy.</p>
    /// <p>You can also include a preferred language using <code>PreferredLanguage</code>. Adding a preferred language can help Amazon Transcribe identify the language faster than if you omit this parameter.</p>
    /// <p>If you have multi-channel audio that contains different languages on each channel, and you've enabled channel identification, automatic language identification identifies the dominant language on each audio channel.</p>
    /// <p>Note that you must include either <code>LanguageCode</code> or <code>IdentifyLanguage</code> or <code>IdentifyMultipleLanguages</code> in your request. If you include more than one of these parameters, your transcription job fails.</p>
    /// <p>Streaming language identification can't be combined with custom language models or redaction.</p>
    pub fn set_identify_language(mut self, input: ::std::option::Option<bool>) -> Self {
        self.identify_language = input;
        self
    }
    /// <p>Enables automatic language identification for your transcription.</p>
    /// <p>If you include <code>IdentifyLanguage</code>, you can optionally include a list of language codes, using <code>LanguageOptions</code>, that you think may be present in your audio stream. Including language options can improve transcription accuracy.</p>
    /// <p>You can also include a preferred language using <code>PreferredLanguage</code>. Adding a preferred language can help Amazon Transcribe identify the language faster than if you omit this parameter.</p>
    /// <p>If you have multi-channel audio that contains different languages on each channel, and you've enabled channel identification, automatic language identification identifies the dominant language on each audio channel.</p>
    /// <p>Note that you must include either <code>LanguageCode</code> or <code>IdentifyLanguage</code> or <code>IdentifyMultipleLanguages</code> in your request. If you include more than one of these parameters, your transcription job fails.</p>
    /// <p>Streaming language identification can't be combined with custom language models or redaction.</p>
    pub fn get_identify_language(&self) -> &::std::option::Option<bool> {
        &self.identify_language
    }
    /// <p>Specify two or more language codes that represent the languages you think may be present in your media; including more than five is not recommended. If you're unsure what languages are present, do not include this parameter.</p>
    /// <p>Including language options can improve the accuracy of language identification.</p>
    /// <p>If you include <code>LanguageOptions</code> in your request, you must also include <code>IdentifyLanguage</code>.</p>
    /// <p>For a list of languages supported with Amazon Transcribe streaming, refer to the <a href="https://docs.aws.amazon.com/transcribe/latest/dg/supported-languages.html">Supported languages</a> table.</p><important>
    /// <p>You can only include one language dialect per language per stream. For example, you cannot include <code>en-US</code> and <code>en-AU</code> in the same request.</p>
    /// </important>
    pub fn language_options(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.language_options = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>Specify two or more language codes that represent the languages you think may be present in your media; including more than five is not recommended. If you're unsure what languages are present, do not include this parameter.</p>
    /// <p>Including language options can improve the accuracy of language identification.</p>
    /// <p>If you include <code>LanguageOptions</code> in your request, you must also include <code>IdentifyLanguage</code>.</p>
    /// <p>For a list of languages supported with Amazon Transcribe streaming, refer to the <a href="https://docs.aws.amazon.com/transcribe/latest/dg/supported-languages.html">Supported languages</a> table.</p><important>
    /// <p>You can only include one language dialect per language per stream. For example, you cannot include <code>en-US</code> and <code>en-AU</code> in the same request.</p>
    /// </important>
    pub fn set_language_options(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.language_options = input;
        self
    }
    /// <p>Specify two or more language codes that represent the languages you think may be present in your media; including more than five is not recommended. If you're unsure what languages are present, do not include this parameter.</p>
    /// <p>Including language options can improve the accuracy of language identification.</p>
    /// <p>If you include <code>LanguageOptions</code> in your request, you must also include <code>IdentifyLanguage</code>.</p>
    /// <p>For a list of languages supported with Amazon Transcribe streaming, refer to the <a href="https://docs.aws.amazon.com/transcribe/latest/dg/supported-languages.html">Supported languages</a> table.</p><important>
    /// <p>You can only include one language dialect per language per stream. For example, you cannot include <code>en-US</code> and <code>en-AU</code> in the same request.</p>
    /// </important>
    pub fn get_language_options(&self) -> &::std::option::Option<::std::string::String> {
        &self.language_options
    }
    /// <p>Specify a preferred language from the subset of languages codes you specified in <code>LanguageOptions</code>.</p>
    /// <p>You can only use this parameter if you've included <code>IdentifyLanguage</code> and <code>LanguageOptions</code> in your request.</p>
    pub fn preferred_language(mut self, input: crate::types::LanguageCode) -> Self {
        self.preferred_language = ::std::option::Option::Some(input);
        self
    }
    /// <p>Specify a preferred language from the subset of languages codes you specified in <code>LanguageOptions</code>.</p>
    /// <p>You can only use this parameter if you've included <code>IdentifyLanguage</code> and <code>LanguageOptions</code> in your request.</p>
    pub fn set_preferred_language(mut self, input: ::std::option::Option<crate::types::LanguageCode>) -> Self {
        self.preferred_language = input;
        self
    }
    /// <p>Specify a preferred language from the subset of languages codes you specified in <code>LanguageOptions</code>.</p>
    /// <p>You can only use this parameter if you've included <code>IdentifyLanguage</code> and <code>LanguageOptions</code> in your request.</p>
    pub fn get_preferred_language(&self) -> &::std::option::Option<crate::types::LanguageCode> {
        &self.preferred_language
    }
    /// <p>Enables automatic multi-language identification in your transcription job request. Use this parameter if your stream contains more than one language. If your stream contains only one language, use IdentifyLanguage instead.</p>
    /// <p>If you include <code>IdentifyMultipleLanguages</code>, you can optionally include a list of language codes, using <code>LanguageOptions</code>, that you think may be present in your stream. Including <code>LanguageOptions</code> restricts <code>IdentifyMultipleLanguages</code> to only the language options that you specify, which can improve transcription accuracy.</p>
    /// <p>If you want to apply a custom vocabulary or a custom vocabulary filter to your automatic multiple language identification request, include <code>VocabularyNames</code> or <code>VocabularyFilterNames</code>.</p>
    /// <p>Note that you must include one of <code>LanguageCode</code>, <code>IdentifyLanguage</code>, or <code>IdentifyMultipleLanguages</code> in your request. If you include more than one of these parameters, your transcription job fails.</p>
    pub fn identify_multiple_languages(mut self, input: bool) -> Self {
        self.identify_multiple_languages = ::std::option::Option::Some(input);
        self
    }
    /// <p>Enables automatic multi-language identification in your transcription job request. Use this parameter if your stream contains more than one language. If your stream contains only one language, use IdentifyLanguage instead.</p>
    /// <p>If you include <code>IdentifyMultipleLanguages</code>, you can optionally include a list of language codes, using <code>LanguageOptions</code>, that you think may be present in your stream. Including <code>LanguageOptions</code> restricts <code>IdentifyMultipleLanguages</code> to only the language options that you specify, which can improve transcription accuracy.</p>
    /// <p>If you want to apply a custom vocabulary or a custom vocabulary filter to your automatic multiple language identification request, include <code>VocabularyNames</code> or <code>VocabularyFilterNames</code>.</p>
    /// <p>Note that you must include one of <code>LanguageCode</code>, <code>IdentifyLanguage</code>, or <code>IdentifyMultipleLanguages</code> in your request. If you include more than one of these parameters, your transcription job fails.</p>
    pub fn set_identify_multiple_languages(mut self, input: ::std::option::Option<bool>) -> Self {
        self.identify_multiple_languages = input;
        self
    }
    /// <p>Enables automatic multi-language identification in your transcription job request. Use this parameter if your stream contains more than one language. If your stream contains only one language, use IdentifyLanguage instead.</p>
    /// <p>If you include <code>IdentifyMultipleLanguages</code>, you can optionally include a list of language codes, using <code>LanguageOptions</code>, that you think may be present in your stream. Including <code>LanguageOptions</code> restricts <code>IdentifyMultipleLanguages</code> to only the language options that you specify, which can improve transcription accuracy.</p>
    /// <p>If you want to apply a custom vocabulary or a custom vocabulary filter to your automatic multiple language identification request, include <code>VocabularyNames</code> or <code>VocabularyFilterNames</code>.</p>
    /// <p>Note that you must include one of <code>LanguageCode</code>, <code>IdentifyLanguage</code>, or <code>IdentifyMultipleLanguages</code> in your request. If you include more than one of these parameters, your transcription job fails.</p>
    pub fn get_identify_multiple_languages(&self) -> &::std::option::Option<bool> {
        &self.identify_multiple_languages
    }
    /// <p>Specify the names of the custom vocabularies that you want to use when processing your transcription. Note that vocabulary names are case sensitive.</p>
    /// <p>If none of the languages of the specified custom vocabularies match the language identified in your media, your job fails.</p><important>
    /// <p>This parameter is only intended for use <b>with</b> the <code>IdentifyLanguage</code> parameter. If you're <b>not</b> including <code>IdentifyLanguage</code> in your request and want to use a custom vocabulary with your transcription, use the <code>VocabularyName</code> parameter instead.</p>
    /// </important>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/transcribe/latest/dg/custom-vocabulary.html">Custom vocabularies</a>.</p>
    pub fn vocabulary_names(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.vocabulary_names = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>Specify the names of the custom vocabularies that you want to use when processing your transcription. Note that vocabulary names are case sensitive.</p>
    /// <p>If none of the languages of the specified custom vocabularies match the language identified in your media, your job fails.</p><important>
    /// <p>This parameter is only intended for use <b>with</b> the <code>IdentifyLanguage</code> parameter. If you're <b>not</b> including <code>IdentifyLanguage</code> in your request and want to use a custom vocabulary with your transcription, use the <code>VocabularyName</code> parameter instead.</p>
    /// </important>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/transcribe/latest/dg/custom-vocabulary.html">Custom vocabularies</a>.</p>
    pub fn set_vocabulary_names(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.vocabulary_names = input;
        self
    }
    /// <p>Specify the names of the custom vocabularies that you want to use when processing your transcription. Note that vocabulary names are case sensitive.</p>
    /// <p>If none of the languages of the specified custom vocabularies match the language identified in your media, your job fails.</p><important>
    /// <p>This parameter is only intended for use <b>with</b> the <code>IdentifyLanguage</code> parameter. If you're <b>not</b> including <code>IdentifyLanguage</code> in your request and want to use a custom vocabulary with your transcription, use the <code>VocabularyName</code> parameter instead.</p>
    /// </important>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/transcribe/latest/dg/custom-vocabulary.html">Custom vocabularies</a>.</p>
    pub fn get_vocabulary_names(&self) -> &::std::option::Option<::std::string::String> {
        &self.vocabulary_names
    }
    /// <p>Specify the names of the custom vocabulary filters that you want to use when processing your transcription. Note that vocabulary filter names are case sensitive.</p>
    /// <p>If none of the languages of the specified custom vocabulary filters match the language identified in your media, your job fails.</p><important>
    /// <p>This parameter is only intended for use <b>with</b> the <code>IdentifyLanguage</code> parameter. If you're <b>not</b> including <code>IdentifyLanguage</code> in your request and want to use a custom vocabulary filter with your transcription, use the <code>VocabularyFilterName</code> parameter instead.</p>
    /// </important>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/transcribe/latest/dg/vocabulary-filtering.html">Using vocabulary filtering with unwanted words</a>.</p>
    pub fn vocabulary_filter_names(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.vocabulary_filter_names = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>Specify the names of the custom vocabulary filters that you want to use when processing your transcription. Note that vocabulary filter names are case sensitive.</p>
    /// <p>If none of the languages of the specified custom vocabulary filters match the language identified in your media, your job fails.</p><important>
    /// <p>This parameter is only intended for use <b>with</b> the <code>IdentifyLanguage</code> parameter. If you're <b>not</b> including <code>IdentifyLanguage</code> in your request and want to use a custom vocabulary filter with your transcription, use the <code>VocabularyFilterName</code> parameter instead.</p>
    /// </important>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/transcribe/latest/dg/vocabulary-filtering.html">Using vocabulary filtering with unwanted words</a>.</p>
    pub fn set_vocabulary_filter_names(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.vocabulary_filter_names = input;
        self
    }
    /// <p>Specify the names of the custom vocabulary filters that you want to use when processing your transcription. Note that vocabulary filter names are case sensitive.</p>
    /// <p>If none of the languages of the specified custom vocabulary filters match the language identified in your media, your job fails.</p><important>
    /// <p>This parameter is only intended for use <b>with</b> the <code>IdentifyLanguage</code> parameter. If you're <b>not</b> including <code>IdentifyLanguage</code> in your request and want to use a custom vocabulary filter with your transcription, use the <code>VocabularyFilterName</code> parameter instead.</p>
    /// </important>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/transcribe/latest/dg/vocabulary-filtering.html">Using vocabulary filtering with unwanted words</a>.</p>
    pub fn get_vocabulary_filter_names(&self) -> &::std::option::Option<::std::string::String> {
        &self.vocabulary_filter_names
    }
    /// Consumes the builder and constructs a [`StartStreamTranscriptionInput`](crate::operation::start_stream_transcription::StartStreamTranscriptionInput).
    /// This method will fail if any of the following fields are not set:
    /// - [`audio_stream`](crate::operation::start_stream_transcription::builders::StartStreamTranscriptionInputBuilder::audio_stream)
    pub fn build(
        self,
    ) -> ::std::result::Result<
        crate::operation::start_stream_transcription::StartStreamTranscriptionInput,
        ::aws_smithy_types::error::operation::BuildError,
    > {
        ::std::result::Result::Ok(crate::operation::start_stream_transcription::StartStreamTranscriptionInput {
            language_code: self.language_code,
            media_sample_rate_hertz: self.media_sample_rate_hertz,
            media_encoding: self.media_encoding,
            vocabulary_name: self.vocabulary_name,
            session_id: self.session_id,
            audio_stream: self.audio_stream.ok_or_else(|| {
                ::aws_smithy_types::error::operation::BuildError::missing_field(
                    "audio_stream",
                    "audio_stream was not specified but it is required when building StartStreamTranscriptionInput",
                )
            })?,
            vocabulary_filter_name: self.vocabulary_filter_name,
            vocabulary_filter_method: self.vocabulary_filter_method,
            show_speaker_label: self.show_speaker_label,
            enable_channel_identification: self.enable_channel_identification,
            number_of_channels: self.number_of_channels,
            enable_partial_results_stabilization: self.enable_partial_results_stabilization,
            partial_results_stability: self.partial_results_stability,
            content_identification_type: self.content_identification_type,
            content_redaction_type: self.content_redaction_type,
            pii_entity_types: self.pii_entity_types,
            language_model_name: self.language_model_name,
            identify_language: self.identify_language,
            language_options: self.language_options,
            preferred_language: self.preferred_language,
            identify_multiple_languages: self.identify_multiple_languages,
            vocabulary_names: self.vocabulary_names,
            vocabulary_filter_names: self.vocabulary_filter_names,
        })
    }
}
