// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
pub use ::aws_smithy_runtime_api::client::endpoint::EndpointFuture;
pub use ::aws_smithy_runtime_api::client::endpoint::SharedEndpointResolver;
pub use ::aws_smithy_types::endpoint::Endpoint;

///
#[cfg(test)]
mod test {

    /// For region ap-east-1 with FIPS disabled and DualStack disabled
    #[test]
    fn test_1() {
        let params = crate::config::endpoint::Params::builder()
            .region("ap-east-1".to_string())
            .use_fips(false)
            .use_dual_stack(false)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://portal.sso.ap-east-1.amazonaws.com");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://portal.sso.ap-east-1.amazonaws.com")
                .build()
        );
    }

    /// For region ap-northeast-1 with FIPS disabled and DualStack disabled
    #[test]
    fn test_2() {
        let params = crate::config::endpoint::Params::builder()
            .region("ap-northeast-1".to_string())
            .use_fips(false)
            .use_dual_stack(false)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://portal.sso.ap-northeast-1.amazonaws.com");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://portal.sso.ap-northeast-1.amazonaws.com")
                .build()
        );
    }

    /// For region ap-northeast-2 with FIPS disabled and DualStack disabled
    #[test]
    fn test_3() {
        let params = crate::config::endpoint::Params::builder()
            .region("ap-northeast-2".to_string())
            .use_fips(false)
            .use_dual_stack(false)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://portal.sso.ap-northeast-2.amazonaws.com");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://portal.sso.ap-northeast-2.amazonaws.com")
                .build()
        );
    }

    /// For region ap-northeast-3 with FIPS disabled and DualStack disabled
    #[test]
    fn test_4() {
        let params = crate::config::endpoint::Params::builder()
            .region("ap-northeast-3".to_string())
            .use_fips(false)
            .use_dual_stack(false)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://portal.sso.ap-northeast-3.amazonaws.com");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://portal.sso.ap-northeast-3.amazonaws.com")
                .build()
        );
    }

    /// For region ap-south-1 with FIPS disabled and DualStack disabled
    #[test]
    fn test_5() {
        let params = crate::config::endpoint::Params::builder()
            .region("ap-south-1".to_string())
            .use_fips(false)
            .use_dual_stack(false)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://portal.sso.ap-south-1.amazonaws.com");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://portal.sso.ap-south-1.amazonaws.com")
                .build()
        );
    }

    /// For region ap-southeast-1 with FIPS disabled and DualStack disabled
    #[test]
    fn test_6() {
        let params = crate::config::endpoint::Params::builder()
            .region("ap-southeast-1".to_string())
            .use_fips(false)
            .use_dual_stack(false)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://portal.sso.ap-southeast-1.amazonaws.com");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://portal.sso.ap-southeast-1.amazonaws.com")
                .build()
        );
    }

    /// For region ap-southeast-2 with FIPS disabled and DualStack disabled
    #[test]
    fn test_7() {
        let params = crate::config::endpoint::Params::builder()
            .region("ap-southeast-2".to_string())
            .use_fips(false)
            .use_dual_stack(false)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://portal.sso.ap-southeast-2.amazonaws.com");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://portal.sso.ap-southeast-2.amazonaws.com")
                .build()
        );
    }

    /// For region ca-central-1 with FIPS disabled and DualStack disabled
    #[test]
    fn test_8() {
        let params = crate::config::endpoint::Params::builder()
            .region("ca-central-1".to_string())
            .use_fips(false)
            .use_dual_stack(false)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://portal.sso.ca-central-1.amazonaws.com");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://portal.sso.ca-central-1.amazonaws.com")
                .build()
        );
    }

    /// For region eu-central-1 with FIPS disabled and DualStack disabled
    #[test]
    fn test_9() {
        let params = crate::config::endpoint::Params::builder()
            .region("eu-central-1".to_string())
            .use_fips(false)
            .use_dual_stack(false)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://portal.sso.eu-central-1.amazonaws.com");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://portal.sso.eu-central-1.amazonaws.com")
                .build()
        );
    }

    /// For region eu-north-1 with FIPS disabled and DualStack disabled
    #[test]
    fn test_10() {
        let params = crate::config::endpoint::Params::builder()
            .region("eu-north-1".to_string())
            .use_fips(false)
            .use_dual_stack(false)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://portal.sso.eu-north-1.amazonaws.com");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://portal.sso.eu-north-1.amazonaws.com")
                .build()
        );
    }

    /// For region eu-south-1 with FIPS disabled and DualStack disabled
    #[test]
    fn test_11() {
        let params = crate::config::endpoint::Params::builder()
            .region("eu-south-1".to_string())
            .use_fips(false)
            .use_dual_stack(false)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://portal.sso.eu-south-1.amazonaws.com");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://portal.sso.eu-south-1.amazonaws.com")
                .build()
        );
    }

    /// For region eu-west-1 with FIPS disabled and DualStack disabled
    #[test]
    fn test_12() {
        let params = crate::config::endpoint::Params::builder()
            .region("eu-west-1".to_string())
            .use_fips(false)
            .use_dual_stack(false)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://portal.sso.eu-west-1.amazonaws.com");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://portal.sso.eu-west-1.amazonaws.com")
                .build()
        );
    }

    /// For region eu-west-2 with FIPS disabled and DualStack disabled
    #[test]
    fn test_13() {
        let params = crate::config::endpoint::Params::builder()
            .region("eu-west-2".to_string())
            .use_fips(false)
            .use_dual_stack(false)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://portal.sso.eu-west-2.amazonaws.com");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://portal.sso.eu-west-2.amazonaws.com")
                .build()
        );
    }

    /// For region eu-west-3 with FIPS disabled and DualStack disabled
    #[test]
    fn test_14() {
        let params = crate::config::endpoint::Params::builder()
            .region("eu-west-3".to_string())
            .use_fips(false)
            .use_dual_stack(false)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://portal.sso.eu-west-3.amazonaws.com");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://portal.sso.eu-west-3.amazonaws.com")
                .build()
        );
    }

    /// For region me-south-1 with FIPS disabled and DualStack disabled
    #[test]
    fn test_15() {
        let params = crate::config::endpoint::Params::builder()
            .region("me-south-1".to_string())
            .use_fips(false)
            .use_dual_stack(false)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://portal.sso.me-south-1.amazonaws.com");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://portal.sso.me-south-1.amazonaws.com")
                .build()
        );
    }

    /// For region sa-east-1 with FIPS disabled and DualStack disabled
    #[test]
    fn test_16() {
        let params = crate::config::endpoint::Params::builder()
            .region("sa-east-1".to_string())
            .use_fips(false)
            .use_dual_stack(false)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://portal.sso.sa-east-1.amazonaws.com");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://portal.sso.sa-east-1.amazonaws.com")
                .build()
        );
    }

    /// For region us-east-1 with FIPS disabled and DualStack disabled
    #[test]
    fn test_17() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-east-1".to_string())
            .use_fips(false)
            .use_dual_stack(false)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://portal.sso.us-east-1.amazonaws.com");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://portal.sso.us-east-1.amazonaws.com")
                .build()
        );
    }

    /// For region us-east-2 with FIPS disabled and DualStack disabled
    #[test]
    fn test_18() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-east-2".to_string())
            .use_fips(false)
            .use_dual_stack(false)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://portal.sso.us-east-2.amazonaws.com");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://portal.sso.us-east-2.amazonaws.com")
                .build()
        );
    }

    /// For region us-west-2 with FIPS disabled and DualStack disabled
    #[test]
    fn test_19() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-west-2".to_string())
            .use_fips(false)
            .use_dual_stack(false)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://portal.sso.us-west-2.amazonaws.com");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://portal.sso.us-west-2.amazonaws.com")
                .build()
        );
    }

    /// For region us-east-1 with FIPS enabled and DualStack enabled
    #[test]
    fn test_20() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-east-1".to_string())
            .use_fips(true)
            .use_dual_stack(true)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://portal.sso-fips.us-east-1.api.aws");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://portal.sso-fips.us-east-1.api.aws")
                .build()
        );
    }

    /// For region us-east-1 with FIPS enabled and DualStack disabled
    #[test]
    fn test_21() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-east-1".to_string())
            .use_fips(true)
            .use_dual_stack(false)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://portal.sso-fips.us-east-1.amazonaws.com");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://portal.sso-fips.us-east-1.amazonaws.com")
                .build()
        );
    }

    /// For region us-east-1 with FIPS disabled and DualStack enabled
    #[test]
    fn test_22() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-east-1".to_string())
            .use_fips(false)
            .use_dual_stack(true)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://portal.sso.us-east-1.api.aws");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://portal.sso.us-east-1.api.aws")
                .build()
        );
    }

    /// For region cn-north-1 with FIPS enabled and DualStack enabled
    #[test]
    fn test_23() {
        let params = crate::config::endpoint::Params::builder()
            .region("cn-north-1".to_string())
            .use_fips(true)
            .use_dual_stack(true)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://portal.sso-fips.cn-north-1.api.amazonwebservices.com.cn");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://portal.sso-fips.cn-north-1.api.amazonwebservices.com.cn")
                .build()
        );
    }

    /// For region cn-north-1 with FIPS enabled and DualStack disabled
    #[test]
    fn test_24() {
        let params = crate::config::endpoint::Params::builder()
            .region("cn-north-1".to_string())
            .use_fips(true)
            .use_dual_stack(false)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://portal.sso-fips.cn-north-1.amazonaws.com.cn");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://portal.sso-fips.cn-north-1.amazonaws.com.cn")
                .build()
        );
    }

    /// For region cn-north-1 with FIPS disabled and DualStack enabled
    #[test]
    fn test_25() {
        let params = crate::config::endpoint::Params::builder()
            .region("cn-north-1".to_string())
            .use_fips(false)
            .use_dual_stack(true)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://portal.sso.cn-north-1.api.amazonwebservices.com.cn");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://portal.sso.cn-north-1.api.amazonwebservices.com.cn")
                .build()
        );
    }

    /// For region cn-north-1 with FIPS disabled and DualStack disabled
    #[test]
    fn test_26() {
        let params = crate::config::endpoint::Params::builder()
            .region("cn-north-1".to_string())
            .use_fips(false)
            .use_dual_stack(false)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://portal.sso.cn-north-1.amazonaws.com.cn");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://portal.sso.cn-north-1.amazonaws.com.cn")
                .build()
        );
    }

    /// For region us-gov-east-1 with FIPS disabled and DualStack disabled
    #[test]
    fn test_27() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-gov-east-1".to_string())
            .use_fips(false)
            .use_dual_stack(false)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://portal.sso.us-gov-east-1.amazonaws.com");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://portal.sso.us-gov-east-1.amazonaws.com")
                .build()
        );
    }

    /// For region us-gov-west-1 with FIPS disabled and DualStack disabled
    #[test]
    fn test_28() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-gov-west-1".to_string())
            .use_fips(false)
            .use_dual_stack(false)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://portal.sso.us-gov-west-1.amazonaws.com");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://portal.sso.us-gov-west-1.amazonaws.com")
                .build()
        );
    }

    /// For region us-gov-east-1 with FIPS enabled and DualStack enabled
    #[test]
    fn test_29() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-gov-east-1".to_string())
            .use_fips(true)
            .use_dual_stack(true)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://portal.sso-fips.us-gov-east-1.api.aws");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://portal.sso-fips.us-gov-east-1.api.aws")
                .build()
        );
    }

    /// For region us-gov-east-1 with FIPS enabled and DualStack disabled
    #[test]
    fn test_30() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-gov-east-1".to_string())
            .use_fips(true)
            .use_dual_stack(false)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://portal.sso.us-gov-east-1.amazonaws.com");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://portal.sso.us-gov-east-1.amazonaws.com")
                .build()
        );
    }

    /// For region us-gov-east-1 with FIPS disabled and DualStack enabled
    #[test]
    fn test_31() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-gov-east-1".to_string())
            .use_fips(false)
            .use_dual_stack(true)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://portal.sso.us-gov-east-1.api.aws");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://portal.sso.us-gov-east-1.api.aws")
                .build()
        );
    }

    /// For region us-iso-east-1 with FIPS enabled and DualStack enabled
    #[test]
    fn test_32() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-iso-east-1".to_string())
            .use_fips(true)
            .use_dual_stack(true)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let error = endpoint.expect_err("expected error: FIPS and DualStack are enabled, but this partition does not support one or both [For region us-iso-east-1 with FIPS enabled and DualStack enabled]");
        assert_eq!(
            format!("{}", error),
            "FIPS and DualStack are enabled, but this partition does not support one or both"
        )
    }

    /// For region us-iso-east-1 with FIPS enabled and DualStack disabled
    #[test]
    fn test_33() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-iso-east-1".to_string())
            .use_fips(true)
            .use_dual_stack(false)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://portal.sso-fips.us-iso-east-1.c2s.ic.gov");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://portal.sso-fips.us-iso-east-1.c2s.ic.gov")
                .build()
        );
    }

    /// For region us-iso-east-1 with FIPS disabled and DualStack enabled
    #[test]
    fn test_34() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-iso-east-1".to_string())
            .use_fips(false)
            .use_dual_stack(true)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let error = endpoint.expect_err("expected error: DualStack is enabled but this partition does not support DualStack [For region us-iso-east-1 with FIPS disabled and DualStack enabled]");
        assert_eq!(format!("{}", error), "DualStack is enabled but this partition does not support DualStack")
    }

    /// For region us-iso-east-1 with FIPS disabled and DualStack disabled
    #[test]
    fn test_35() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-iso-east-1".to_string())
            .use_fips(false)
            .use_dual_stack(false)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://portal.sso.us-iso-east-1.c2s.ic.gov");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://portal.sso.us-iso-east-1.c2s.ic.gov")
                .build()
        );
    }

    /// For region us-isob-east-1 with FIPS enabled and DualStack enabled
    #[test]
    fn test_36() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-isob-east-1".to_string())
            .use_fips(true)
            .use_dual_stack(true)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let error = endpoint.expect_err("expected error: FIPS and DualStack are enabled, but this partition does not support one or both [For region us-isob-east-1 with FIPS enabled and DualStack enabled]");
        assert_eq!(
            format!("{}", error),
            "FIPS and DualStack are enabled, but this partition does not support one or both"
        )
    }

    /// For region us-isob-east-1 with FIPS enabled and DualStack disabled
    #[test]
    fn test_37() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-isob-east-1".to_string())
            .use_fips(true)
            .use_dual_stack(false)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://portal.sso-fips.us-isob-east-1.sc2s.sgov.gov");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://portal.sso-fips.us-isob-east-1.sc2s.sgov.gov")
                .build()
        );
    }

    /// For region us-isob-east-1 with FIPS disabled and DualStack enabled
    #[test]
    fn test_38() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-isob-east-1".to_string())
            .use_fips(false)
            .use_dual_stack(true)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let error = endpoint.expect_err("expected error: DualStack is enabled but this partition does not support DualStack [For region us-isob-east-1 with FIPS disabled and DualStack enabled]");
        assert_eq!(format!("{}", error), "DualStack is enabled but this partition does not support DualStack")
    }

    /// For region us-isob-east-1 with FIPS disabled and DualStack disabled
    #[test]
    fn test_39() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-isob-east-1".to_string())
            .use_fips(false)
            .use_dual_stack(false)
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://portal.sso.us-isob-east-1.sc2s.sgov.gov");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder()
                .url("https://portal.sso.us-isob-east-1.sc2s.sgov.gov")
                .build()
        );
    }

    /// For custom endpoint with region set and fips disabled and dualstack disabled
    #[test]
    fn test_40() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-east-1".to_string())
            .use_fips(false)
            .use_dual_stack(false)
            .endpoint("https://example.com".to_string())
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://example.com");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder().url("https://example.com").build()
        );
    }

    /// For custom endpoint with region not set and fips disabled and dualstack disabled
    #[test]
    fn test_41() {
        let params = crate::config::endpoint::Params::builder()
            .use_fips(false)
            .use_dual_stack(false)
            .endpoint("https://example.com".to_string())
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let endpoint = endpoint.expect("Expected valid endpoint: https://example.com");
        assert_eq!(
            endpoint,
            ::aws_smithy_types::endpoint::Endpoint::builder().url("https://example.com").build()
        );
    }

    /// For custom endpoint with fips enabled and dualstack disabled
    #[test]
    fn test_42() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-east-1".to_string())
            .use_fips(true)
            .use_dual_stack(false)
            .endpoint("https://example.com".to_string())
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let error = endpoint.expect_err("expected error: Invalid Configuration: FIPS and custom endpoint are not supported [For custom endpoint with fips enabled and dualstack disabled]");
        assert_eq!(format!("{}", error), "Invalid Configuration: FIPS and custom endpoint are not supported")
    }

    /// For custom endpoint with fips disabled and dualstack enabled
    #[test]
    fn test_43() {
        let params = crate::config::endpoint::Params::builder()
            .region("us-east-1".to_string())
            .use_fips(false)
            .use_dual_stack(true)
            .endpoint("https://example.com".to_string())
            .build()
            .expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let error = endpoint.expect_err("expected error: Invalid Configuration: Dualstack and custom endpoint are not supported [For custom endpoint with fips disabled and dualstack enabled]");
        assert_eq!(
            format!("{}", error),
            "Invalid Configuration: Dualstack and custom endpoint are not supported"
        )
    }

    /// Missing region
    #[test]
    fn test_44() {
        let params = crate::config::endpoint::Params::builder().build().expect("invalid params");
        let resolver = crate::config::endpoint::DefaultResolver::new();
        let endpoint = resolver.resolve_endpoint(&params);
        let error = endpoint.expect_err("expected error: Invalid Configuration: Missing Region [Missing region]");
        assert_eq!(format!("{}", error), "Invalid Configuration: Missing Region")
    }
}

/// Endpoint resolver trait specific to AWS Single Sign-On
pub trait ResolveEndpoint: ::std::marker::Send + ::std::marker::Sync + ::std::fmt::Debug {
    /// Resolve an endpoint with the given parameters
    fn resolve_endpoint<'a>(&'a self, params: &'a crate::config::endpoint::Params) -> ::aws_smithy_runtime_api::client::endpoint::EndpointFuture<'a>;

    /// Convert this service-specific resolver into a `SharedEndpointResolver`
    ///
    /// The resulting resolver will downcast `EndpointResolverParams` into `crate::config::endpoint::Params`.
    fn into_shared_resolver(self) -> ::aws_smithy_runtime_api::client::endpoint::SharedEndpointResolver
    where
        Self: Sized + 'static,
    {
        ::aws_smithy_runtime_api::client::endpoint::SharedEndpointResolver::new(DowncastParams(self))
    }
}

#[derive(Debug)]
struct DowncastParams<T>(T);
impl<T> ::aws_smithy_runtime_api::client::endpoint::ResolveEndpoint for DowncastParams<T>
where
    T: ResolveEndpoint,
{
    fn resolve_endpoint<'a>(
        &'a self,
        params: &'a ::aws_smithy_runtime_api::client::endpoint::EndpointResolverParams,
    ) -> ::aws_smithy_runtime_api::client::endpoint::EndpointFuture<'a> {
        let ep = match params.get::<crate::config::endpoint::Params>() {
            Some(params) => self.0.resolve_endpoint(params),
            None => ::aws_smithy_runtime_api::client::endpoint::EndpointFuture::ready(Err("params of expected type was not present".into())),
        };
        ep
    }
}

/// The default endpoint resolver
#[derive(Debug, Default)]
pub struct DefaultResolver {
    partition_resolver: crate::endpoint_lib::partition::PartitionResolver,
}

impl DefaultResolver {
    /// Create a new endpoint resolver with default settings
    pub fn new() -> Self {
        Self {
            partition_resolver: crate::endpoint_lib::DEFAULT_PARTITION_RESOLVER.clone(),
        }
    }

    fn resolve_endpoint(
        &self,
        params: &crate::config::endpoint::Params,
    ) -> Result<::aws_smithy_types::endpoint::Endpoint, ::aws_smithy_runtime_api::box_error::BoxError> {
        let mut diagnostic_collector = crate::endpoint_lib::diagnostic::DiagnosticCollector::new();
        Ok(
            crate::config::endpoint::internals::resolve_endpoint(params, &mut diagnostic_collector, &self.partition_resolver)
                .map_err(|err| err.with_source(diagnostic_collector.take_last_error()))?,
        )
    }
}

impl crate::config::endpoint::ResolveEndpoint for DefaultResolver {
    fn resolve_endpoint(&self, params: &crate::config::endpoint::Params) -> ::aws_smithy_runtime_api::client::endpoint::EndpointFuture {
        ::aws_smithy_runtime_api::client::endpoint::EndpointFuture::ready(self.resolve_endpoint(params))
    }
}

#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::fmt::Debug)]
/// Configuration parameters for resolving the correct endpoint
pub struct Params {
    /// The AWS region used to dispatch the request.
    pub(crate) region: ::std::option::Option<::std::string::String>,
    /// When true, use the dual-stack endpoint. If the configured endpoint does not support dual-stack, dispatching the request MAY return an error.
    pub(crate) use_dual_stack: bool,
    /// When true, send this request to the FIPS-compliant regional endpoint. If the configured endpoint does not have a FIPS compliant endpoint, dispatching the request will return an error.
    pub(crate) use_fips: bool,
    /// Override the endpoint used to send this request
    pub(crate) endpoint: ::std::option::Option<::std::string::String>,
}
impl Params {
    /// Create a builder for [`Params`]
    pub fn builder() -> crate::config::endpoint::ParamsBuilder {
        crate::config::endpoint::ParamsBuilder::default()
    }
    /// The AWS region used to dispatch the request.
    pub fn region(&self) -> ::std::option::Option<&str> {
        self.region.as_deref()
    }
    /// When true, use the dual-stack endpoint. If the configured endpoint does not support dual-stack, dispatching the request MAY return an error.
    pub fn use_dual_stack(&self) -> ::std::option::Option<bool> {
        Some(self.use_dual_stack)
    }
    /// When true, send this request to the FIPS-compliant regional endpoint. If the configured endpoint does not have a FIPS compliant endpoint, dispatching the request will return an error.
    pub fn use_fips(&self) -> ::std::option::Option<bool> {
        Some(self.use_fips)
    }
    /// Override the endpoint used to send this request
    pub fn endpoint(&self) -> ::std::option::Option<&str> {
        self.endpoint.as_deref()
    }
}

/// Builder for [`Params`]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::default::Default, ::std::fmt::Debug)]
pub struct ParamsBuilder {
    region: ::std::option::Option<::std::string::String>,
    use_dual_stack: ::std::option::Option<bool>,
    use_fips: ::std::option::Option<bool>,
    endpoint: ::std::option::Option<::std::string::String>,
}
impl ParamsBuilder {
    /// Consume this builder, creating [`Params`].
    pub fn build(self) -> ::std::result::Result<crate::config::endpoint::Params, crate::config::endpoint::InvalidParams> {
        Ok(
            #[allow(clippy::unnecessary_lazy_evaluations)]
            crate::config::endpoint::Params {
                region: self.region,
                use_dual_stack: self
                    .use_dual_stack
                    .or_else(|| Some(false))
                    .ok_or_else(|| crate::config::endpoint::InvalidParams::missing("use_dual_stack"))?,
                use_fips: self
                    .use_fips
                    .or_else(|| Some(false))
                    .ok_or_else(|| crate::config::endpoint::InvalidParams::missing("use_fips"))?,
                endpoint: self.endpoint,
            },
        )
    }
    /// Sets the value for region
    ///
    /// The AWS region used to dispatch the request.
    pub fn region(mut self, value: impl Into<::std::string::String>) -> Self {
        self.region = Some(value.into());
        self
    }

    /// Sets the value for region
    ///
    /// The AWS region used to dispatch the request.
    pub fn set_region(mut self, param: Option<::std::string::String>) -> Self {
        self.region = param;
        self
    }
    /// Sets the value for use_dual_stack
    ///
    /// When unset, this parameter has a default value of `false`.
    /// When true, use the dual-stack endpoint. If the configured endpoint does not support dual-stack, dispatching the request MAY return an error.
    pub fn use_dual_stack(mut self, value: impl Into<bool>) -> Self {
        self.use_dual_stack = Some(value.into());
        self
    }

    /// Sets the value for use_dual_stack
    ///
    /// When unset, this parameter has a default value of `false`.
    /// When true, use the dual-stack endpoint. If the configured endpoint does not support dual-stack, dispatching the request MAY return an error.
    pub fn set_use_dual_stack(mut self, param: Option<bool>) -> Self {
        self.use_dual_stack = param;
        self
    }
    /// Sets the value for use_fips
    ///
    /// When unset, this parameter has a default value of `false`.
    /// When true, send this request to the FIPS-compliant regional endpoint. If the configured endpoint does not have a FIPS compliant endpoint, dispatching the request will return an error.
    pub fn use_fips(mut self, value: impl Into<bool>) -> Self {
        self.use_fips = Some(value.into());
        self
    }

    /// Sets the value for use_fips
    ///
    /// When unset, this parameter has a default value of `false`.
    /// When true, send this request to the FIPS-compliant regional endpoint. If the configured endpoint does not have a FIPS compliant endpoint, dispatching the request will return an error.
    pub fn set_use_fips(mut self, param: Option<bool>) -> Self {
        self.use_fips = param;
        self
    }
    /// Sets the value for endpoint
    ///
    /// Override the endpoint used to send this request
    pub fn endpoint(mut self, value: impl Into<::std::string::String>) -> Self {
        self.endpoint = Some(value.into());
        self
    }

    /// Sets the value for endpoint
    ///
    /// Override the endpoint used to send this request
    pub fn set_endpoint(mut self, param: Option<::std::string::String>) -> Self {
        self.endpoint = param;
        self
    }
}

/// An error that occurred during endpoint resolution
#[derive(Debug)]
pub struct InvalidParams {
    field: std::borrow::Cow<'static, str>,
}

impl InvalidParams {
    #[allow(dead_code)]
    fn missing(field: &'static str) -> Self {
        Self { field: field.into() }
    }
}

impl std::fmt::Display for InvalidParams {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "a required field was missing: `{}`", self.field)
    }
}

impl std::error::Error for InvalidParams {}

mod internals;
