// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(clippy::unnecessary_wraps)]
pub fn de_complete_multipart_upload_http_error(
    _response_status: u16,
    _response_headers: &::aws_smithy_runtime_api::http::Headers,
    _response_body: &[u8],
) -> std::result::Result<
    crate::operation::complete_multipart_upload::CompleteMultipartUploadOutput,
    crate::operation::complete_multipart_upload::CompleteMultipartUploadError,
> {
    #[allow(unused_mut)]
    let mut generic_builder = crate::protocol_serde::parse_http_error_metadata(_response_status, _response_headers, _response_body)
        .map_err(crate::operation::complete_multipart_upload::CompleteMultipartUploadError::unhandled)?;
    generic_builder = crate::s3_request_id::apply_extended_request_id(generic_builder, _response_headers);
    generic_builder = ::aws_types::request_id::apply_request_id(generic_builder, _response_headers);
    let generic = generic_builder.build();
    Err(crate::operation::complete_multipart_upload::CompleteMultipartUploadError::generic(
        generic,
    ))
}

#[allow(clippy::unnecessary_wraps)]
pub fn de_complete_multipart_upload_http_response(
    _response_status: u16,
    _response_headers: &::aws_smithy_runtime_api::http::Headers,
    _response_body: &[u8],
) -> std::result::Result<
    crate::operation::complete_multipart_upload::CompleteMultipartUploadOutput,
    crate::operation::complete_multipart_upload::CompleteMultipartUploadError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::operation::complete_multipart_upload::builders::CompleteMultipartUploadOutputBuilder::default();
        output = crate::protocol_serde::shape_complete_multipart_upload::de_complete_multipart_upload(_response_body, output)
            .map_err(crate::operation::complete_multipart_upload::CompleteMultipartUploadError::unhandled)?;
        output = output.set_bucket_key_enabled(
            crate::protocol_serde::shape_complete_multipart_upload_output::de_bucket_key_enabled_header(_response_headers).map_err(|_| {
                crate::operation::complete_multipart_upload::CompleteMultipartUploadError::unhandled(
                    "Failed to parse BucketKeyEnabled from header `x-amz-server-side-encryption-bucket-key-enabled",
                )
            })?,
        );
        output = output.set_expiration(
            crate::protocol_serde::shape_complete_multipart_upload_output::de_expiration_header(_response_headers).map_err(|_| {
                crate::operation::complete_multipart_upload::CompleteMultipartUploadError::unhandled(
                    "Failed to parse Expiration from header `x-amz-expiration",
                )
            })?,
        );
        output = output.set_request_charged(
            crate::protocol_serde::shape_complete_multipart_upload_output::de_request_charged_header(_response_headers).map_err(|_| {
                crate::operation::complete_multipart_upload::CompleteMultipartUploadError::unhandled(
                    "Failed to parse RequestCharged from header `x-amz-request-charged",
                )
            })?,
        );
        output = output.set_ssekms_key_id(
            crate::protocol_serde::shape_complete_multipart_upload_output::de_ssekms_key_id_header(_response_headers).map_err(|_| {
                crate::operation::complete_multipart_upload::CompleteMultipartUploadError::unhandled(
                    "Failed to parse SSEKMSKeyId from header `x-amz-server-side-encryption-aws-kms-key-id",
                )
            })?,
        );
        output = output.set_server_side_encryption(
            crate::protocol_serde::shape_complete_multipart_upload_output::de_server_side_encryption_header(_response_headers).map_err(|_| {
                crate::operation::complete_multipart_upload::CompleteMultipartUploadError::unhandled(
                    "Failed to parse ServerSideEncryption from header `x-amz-server-side-encryption",
                )
            })?,
        );
        output = output.set_version_id(
            crate::protocol_serde::shape_complete_multipart_upload_output::de_version_id_header(_response_headers).map_err(|_| {
                crate::operation::complete_multipart_upload::CompleteMultipartUploadError::unhandled(
                    "Failed to parse VersionId from header `x-amz-version-id",
                )
            })?,
        );
        output._set_extended_request_id(crate::s3_request_id::RequestIdExt::extended_request_id(_response_headers).map(str::to_string));
        output._set_request_id(::aws_types::request_id::RequestId::request_id(_response_headers).map(str::to_string));
        output.build()
    })
}

pub fn ser_complete_multipart_upload_headers(
    input: &crate::operation::complete_multipart_upload::CompleteMultipartUploadInput,
    mut builder: ::http::request::Builder,
) -> std::result::Result<::http::request::Builder, ::aws_smithy_types::error::operation::BuildError> {
    if let ::std::option::Option::Some(inner_1) = &input.checksum_crc32 {
        let formatted_2 = inner_1.as_str();
        if !formatted_2.is_empty() {
            let header_value = formatted_2;
            let header_value: ::http::HeaderValue = header_value.parse().map_err(|err| {
                ::aws_smithy_types::error::operation::BuildError::invalid_field(
                    "checksum_crc32",
                    format!("`{}` cannot be used as a header value: {}", &header_value, err),
                )
            })?;
            builder = builder.header("x-amz-checksum-crc32", header_value);
        }
    }
    if let ::std::option::Option::Some(inner_3) = &input.checksum_crc32_c {
        let formatted_4 = inner_3.as_str();
        if !formatted_4.is_empty() {
            let header_value = formatted_4;
            let header_value: ::http::HeaderValue = header_value.parse().map_err(|err| {
                ::aws_smithy_types::error::operation::BuildError::invalid_field(
                    "checksum_crc32_c",
                    format!("`{}` cannot be used as a header value: {}", &header_value, err),
                )
            })?;
            builder = builder.header("x-amz-checksum-crc32c", header_value);
        }
    }
    if let ::std::option::Option::Some(inner_5) = &input.checksum_sha1 {
        let formatted_6 = inner_5.as_str();
        if !formatted_6.is_empty() {
            let header_value = formatted_6;
            let header_value: ::http::HeaderValue = header_value.parse().map_err(|err| {
                ::aws_smithy_types::error::operation::BuildError::invalid_field(
                    "checksum_sha1",
                    format!("`{}` cannot be used as a header value: {}", &header_value, err),
                )
            })?;
            builder = builder.header("x-amz-checksum-sha1", header_value);
        }
    }
    if let ::std::option::Option::Some(inner_7) = &input.checksum_sha256 {
        let formatted_8 = inner_7.as_str();
        if !formatted_8.is_empty() {
            let header_value = formatted_8;
            let header_value: ::http::HeaderValue = header_value.parse().map_err(|err| {
                ::aws_smithy_types::error::operation::BuildError::invalid_field(
                    "checksum_sha256",
                    format!("`{}` cannot be used as a header value: {}", &header_value, err),
                )
            })?;
            builder = builder.header("x-amz-checksum-sha256", header_value);
        }
    }
    if let ::std::option::Option::Some(inner_9) = &input.request_payer {
        let formatted_10 = inner_9.as_str();
        if !formatted_10.is_empty() {
            let header_value = formatted_10;
            let header_value: ::http::HeaderValue = header_value.parse().map_err(|err| {
                ::aws_smithy_types::error::operation::BuildError::invalid_field(
                    "request_payer",
                    format!("`{}` cannot be used as a header value: {}", &header_value, err),
                )
            })?;
            builder = builder.header("x-amz-request-payer", header_value);
        }
    }
    if let ::std::option::Option::Some(inner_11) = &input.expected_bucket_owner {
        let formatted_12 = inner_11.as_str();
        if !formatted_12.is_empty() {
            let header_value = formatted_12;
            let header_value: ::http::HeaderValue = header_value.parse().map_err(|err| {
                ::aws_smithy_types::error::operation::BuildError::invalid_field(
                    "expected_bucket_owner",
                    format!("`{}` cannot be used as a header value: {}", &header_value, err),
                )
            })?;
            builder = builder.header("x-amz-expected-bucket-owner", header_value);
        }
    }
    if let ::std::option::Option::Some(inner_13) = &input.sse_customer_algorithm {
        let formatted_14 = inner_13.as_str();
        if !formatted_14.is_empty() {
            let header_value = formatted_14;
            let header_value: ::http::HeaderValue = header_value.parse().map_err(|err| {
                ::aws_smithy_types::error::operation::BuildError::invalid_field(
                    "sse_customer_algorithm",
                    format!("`{}` cannot be used as a header value: {}", &header_value, err),
                )
            })?;
            builder = builder.header("x-amz-server-side-encryption-customer-algorithm", header_value);
        }
    }
    if let ::std::option::Option::Some(inner_15) = &input.sse_customer_key {
        let formatted_16 = inner_15.as_str();
        if !formatted_16.is_empty() {
            let header_value = formatted_16;
            let header_value: ::http::HeaderValue = header_value.parse().map_err(|err| {
                ::aws_smithy_types::error::operation::BuildError::invalid_field(
                    "sse_customer_key",
                    format!("`{}` cannot be used as a header value: {}", &"*** Sensitive Data Redacted ***", err),
                )
            })?;
            builder = builder.header("x-amz-server-side-encryption-customer-key", header_value);
        }
    }
    if let ::std::option::Option::Some(inner_17) = &input.sse_customer_key_md5 {
        let formatted_18 = inner_17.as_str();
        if !formatted_18.is_empty() {
            let header_value = formatted_18;
            let header_value: ::http::HeaderValue = header_value.parse().map_err(|err| {
                ::aws_smithy_types::error::operation::BuildError::invalid_field(
                    "sse_customer_key_md5",
                    format!("`{}` cannot be used as a header value: {}", &header_value, err),
                )
            })?;
            builder = builder.header("x-amz-server-side-encryption-customer-key-MD5", header_value);
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn de_complete_multipart_upload(
    inp: &[u8],
    mut builder: crate::operation::complete_multipart_upload::builders::CompleteMultipartUploadOutputBuilder,
) -> Result<crate::operation::complete_multipart_upload::builders::CompleteMultipartUploadOutputBuilder, ::aws_smithy_xml::decode::XmlDecodeError> {
    let mut doc = ::aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    #[allow(unused_variables)]
    let start_el = decoder.start_el();
    if !start_el.matches("CompleteMultipartUploadResult") {
        return Err(::aws_smithy_xml::decode::XmlDecodeError::custom(format!(
            "encountered invalid XML root: expected CompleteMultipartUploadResult but got {:?}. This is likely a bug in the SDK.",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("ChecksumSHA1") /* ChecksumSHA1 com.amazonaws.s3.synthetic#CompleteMultipartUploadOutput$ChecksumSHA1 */ =>  {
                let var_19 =
                    Some(
                        Result::<::std::string::String, ::aws_smithy_xml::decode::XmlDecodeError>::Ok(
                            ::aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_checksum_sha1(var_19);
            }
            ,
            s if s.matches("ChecksumSHA256") /* ChecksumSHA256 com.amazonaws.s3.synthetic#CompleteMultipartUploadOutput$ChecksumSHA256 */ =>  {
                let var_20 =
                    Some(
                        Result::<::std::string::String, ::aws_smithy_xml::decode::XmlDecodeError>::Ok(
                            ::aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_checksum_sha256(var_20);
            }
            ,
            s if s.matches("Bucket") /* Bucket com.amazonaws.s3.synthetic#CompleteMultipartUploadOutput$Bucket */ =>  {
                let var_21 =
                    Some(
                        Result::<::std::string::String, ::aws_smithy_xml::decode::XmlDecodeError>::Ok(
                            ::aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_bucket(var_21);
            }
            ,
            s if s.matches("ETag") /* ETag com.amazonaws.s3.synthetic#CompleteMultipartUploadOutput$ETag */ =>  {
                let var_22 =
                    Some(
                        Result::<::std::string::String, ::aws_smithy_xml::decode::XmlDecodeError>::Ok(
                            ::aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_e_tag(var_22);
            }
            ,
            s if s.matches("ChecksumCRC32C") /* ChecksumCRC32C com.amazonaws.s3.synthetic#CompleteMultipartUploadOutput$ChecksumCRC32C */ =>  {
                let var_23 =
                    Some(
                        Result::<::std::string::String, ::aws_smithy_xml::decode::XmlDecodeError>::Ok(
                            ::aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_checksum_crc32_c(var_23);
            }
            ,
            s if s.matches("ChecksumCRC32") /* ChecksumCRC32 com.amazonaws.s3.synthetic#CompleteMultipartUploadOutput$ChecksumCRC32 */ =>  {
                let var_24 =
                    Some(
                        Result::<::std::string::String, ::aws_smithy_xml::decode::XmlDecodeError>::Ok(
                            ::aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_checksum_crc32(var_24);
            }
            ,
            s if s.matches("Key") /* Key com.amazonaws.s3.synthetic#CompleteMultipartUploadOutput$Key */ =>  {
                let var_25 =
                    Some(
                        Result::<::std::string::String, ::aws_smithy_xml::decode::XmlDecodeError>::Ok(
                            ::aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_key(var_25);
            }
            ,
            s if s.matches("Location") /* Location com.amazonaws.s3.synthetic#CompleteMultipartUploadOutput$Location */ =>  {
                let var_26 =
                    Some(
                        Result::<::std::string::String, ::aws_smithy_xml::decode::XmlDecodeError>::Ok(
                            ::aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_location(var_26);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}
